/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.MediaCollectionDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.ExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.SharedExtendedCollectionProperties;
import com.lunaimaging.insight.core.domain.SharedMediaCollection;
import com.lunaimaging.insight.core.domain.cache.UnboundCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.domain.search.Result;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcCollectionDao
extends JdbcBaseDao
implements MediaCollectionDao,
Maintainable {
    protected List<Result> results;
    protected int[] resultIds;
    protected UnboundCache propertiesCache = new UnboundCache();
    protected UnboundCache sharedPropertiesCache = new UnboundCache();
    protected UnboundCache collectionCache = new UnboundCache();
    protected UnboundCache sharedCollectionCache = new UnboundCache();
    private boolean initialized = false;

    @Override
    public ExtendedCollectionProperties getDefaultExtendedCollectionProperties() throws DataAccessException {
        try {
            this.initialize();
            List allExtendedCollectionProperties = this.propertiesCache.getAll();
            ExtendedCollectionProperties ecp = null;
            for (int i = 0; i < allExtendedCollectionProperties.size(); ++i) {
                ecp = (ExtendedCollectionProperties)allExtendedCollectionProperties.get(i);
                if (!ecp.getUseAsDefault()) continue;
                return ecp;
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve DefaultExtendedProperties!", (Throwable)e);
        }
        return null;
    }

    @Override
    public ExtendedCollectionProperties getAllCollectionsExtendedCollectionProperties() throws DataAccessException {
        try {
            this.initialize();
            List allExtendedCollectionProperties = this.propertiesCache.getAll();
            ExtendedCollectionProperties ecp = null;
            for (int i = 0; i < allExtendedCollectionProperties.size(); ++i) {
                ecp = (ExtendedCollectionProperties)allExtendedCollectionProperties.get(i);
                if (!ecp.getCollectionId().equalsIgnoreCase("All Collections")) continue;
                return ecp;
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve ExtendedProperties for All Collections!", (Throwable)e);
        }
        return null;
    }

    public List<ExtendedCollectionProperties> getAllExtendedCollectionProperties() {
        return this.propertiesCache.getAll();
    }

    public ExtendedCollectionProperties getExtendedCollectionProperties(String mediaCollectionid) {
        return (ExtendedCollectionProperties)this.propertiesCache.get(mediaCollectionid);
    }

    @Override
    public MediaCollection getMediaCollection(String id) throws DataAccessException {
        MediaCollection mc = null;
        try {
            this.initialize();
            mc = (MediaCollection)this.collectionCache.get(id.toLowerCase());
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve CollectionPropertiesById!", (Throwable)e);
        }
        return mc;
    }

    @Override
    public SharedMediaCollection getSharedCollection(String uri) throws DataAccessException {
        SharedMediaCollection mc = null;
        try {
            this.initialize();
            mc = (SharedMediaCollection)this.sharedCollectionCache.get(uri);
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve CollectionPropertiesByUri!", (Throwable)e);
        }
        return mc;
    }

    @Override
    public List<MediaCollection> getAllMediaCollections() throws DataAccessException {
        return this.collectionCache.getAll();
    }

    @Override
    public List<MediaCollection> getPublicMediaCollections() throws DataAccessException {
        return this.sharedCollectionCache.getAll();
    }

    @Override
    public List<MediaCollection> getLocalMediaCollections() throws DataAccessException {
        ArrayList<MediaCollection> localCollections = new ArrayList<MediaCollection>();
        List<MediaCollection> all = this.getAllMediaCollections();
        for (MediaCollection mc : all) {
            if (mc == null || mc.isPublicCollection()) continue;
            localCollections.add(mc);
        }
        return localCollections;
    }

    @Override
    public void saveMediaCollection(MediaCollection mc) throws DataAccessException {
        try {
            if (mc == null) {
                throw new InvalidParameterException("PublisherMedia Collection cannot be null!");
            }
            this.deleteMediaCollection(mc);
            this.insertOnly(mc, true);
            boolean useAsDefault = true;
            if (!this.collectionCache.contains(mc.getId().toLowerCase())) {
                this.collectionCache.put(mc.getId().toLowerCase(), mc);
                if (mc instanceof SharedMediaCollection) {
                    this.sharedCollectionCache.put(((SharedExtendedCollectionProperties)((SharedMediaCollection)mc).getExtendedCollectionProperties()).getUri(), mc);
                }
                List list = this.collectionCache.getAll();
                for (MediaCollection cachedCollection : list) {
                    ExtendedCollectionProperties ecp = cachedCollection.getExtendedCollectionProperties();
                    if (ecp == null || !ecp.getUseAsDefault()) continue;
                    useAsDefault = false;
                    break;
                }
            } else {
                Object obj = this.collectionCache.get(mc.getId().toLowerCase());
                MediaCollection cachedCollection = (MediaCollection)obj;
                ExtendedCollectionProperties ecp = cachedCollection.getExtendedCollectionProperties();
                if (ecp == null || !ecp.getUseAsDefault()) {
                    useAsDefault = false;
                }
            }
            mc.getExtendedCollectionProperties().setUseAsDefault(useAsDefault);
            this.saveExtendedCollectionProperties(mc.getExtendedCollectionProperties());
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Unexpected error, unable to save media collection", (Throwable)e);
        }
    }

    @Override
    public void deleteMediaCollection(MediaCollection mc) throws DataAccessException {
        try {
            if (mc == null) {
                throw new InvalidParameterException("PublisherMedia Collection cannot be null!");
            }
            this.deleteObject(mc);
            this.collectionCache.remove(mc.getId().toLowerCase());
            if (mc instanceof SharedMediaCollection) {
                this.sharedCollectionCache.remove(((SharedExtendedCollectionProperties)((SharedMediaCollection)mc).getExtendedCollectionProperties()).getUri());
            }
            this.deleteExtendedCollectionProperties(mc.getExtendedCollectionProperties());
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Unexpected error, unable to delete media collection", (Throwable)e);
        }
    }

    private void deleteExtendedCollectionProperties(ExtendedCollectionProperties ecp) throws SQLException {
        if (ecp != null) {
            this.deleteObject(ecp);
            this.propertiesCache.remove(ecp.getCollectionId());
        }
    }

    private void saveExtendedCollectionProperties(ExtendedCollectionProperties ecp) throws SQLException {
        if (ecp != null) {
            this.deleteObject(ecp);
            this.insertOnly(ecp, true);
        }
    }

    @Override
    public void suspendMediaCollection(MediaCollection mc) {
        try {
            if (mc == null) {
                throw new InvalidParameterException("PublisherMedia Collection cannot be null!");
            }
            this.collectionCache.remove(mc.getId().toLowerCase());
            if (mc instanceof SharedMediaCollection) {
                this.sharedCollectionCache.remove(((SharedExtendedCollectionProperties)((SharedMediaCollection)mc).getExtendedCollectionProperties()).getUri());
            }
            this.suspendExtendedCollectionProperties(mc.getExtendedCollectionProperties());
            this.log.info((Object)("suspended collection: " + mc.getCollectionName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void suspendExtendedCollectionProperties(ExtendedCollectionProperties ecp) {
        if (ecp != null) {
            this.propertiesCache.remove(ecp.getCollectionId());
        }
    }

    void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Cache(s)");
            this.log.info((Object)"LUNA Viewer collection cache initialization. Please wait...");
            this.initializeExtendedPropertiesFields();
            this.initializeMediaCollection();
            this.log.info((Object)"End of LUNA Viewer collection cache initialization.");
            this.initialized = true;
        }
    }

    private void initializeExtendedPropertiesFields() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new extended collection properties cache");
        Collection ecps = this.getAllObjects(ExtendedCollectionProperties.class);
        for (ExtendedCollectionProperties ecp : ecps) {
            this.propertiesCache.put(ecp.getCollectionId(), ecp);
        }
        Collection secps = this.getAllObjects(SharedExtendedCollectionProperties.class);
        for (ExtendedCollectionProperties ecp : secps) {
            this.sharedPropertiesCache.put(ecp.getCollectionId(), ecp);
        }
        this.log.debug((Object)"Completed extended collection properties cache");
    }

    private void initializeMediaCollection() throws SQLException {
        this.log.debug((Object)"Creating new collection properties cache");
        Collection mcs = this.getAllObjects(MediaCollection.class);
        for (MediaCollection mc : mcs) {
            mc.setExtendedCollectionProperties(this.getExtendedCollectionProperties(mc.getId()));
            mc.setPublicCollection(false);
            this.collectionCache.put(mc.getId().toLowerCase(), mc);
        }
        Collection smcs = this.getAllObjects(SharedMediaCollection.class);
        for (MediaCollection mc : smcs) {
            mc.setExtendedCollectionProperties((ExtendedCollectionProperties)this.sharedPropertiesCache.get(mc.getId()));
            mc.setPublicCollection(true);
            this.collectionCache.put(mc.getId().toLowerCase(), mc);
            SharedExtendedCollectionProperties props = (SharedExtendedCollectionProperties)((SharedMediaCollection)mc).getExtendedCollectionProperties();
            if (props == null || props.getUri() == null) continue;
            this.sharedCollectionCache.put(props.getUri(), mc);
        }
        this.log.debug((Object)"Completed collection properties cache");
    }

    @Override
    public void startMaintenance() throws Exception {
        this.propertiesCache.purge();
        this.sharedPropertiesCache.purge();
        this.collectionCache.purge();
        this.sharedCollectionCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

