/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.CategoriesDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.Category;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.techempower.ReflectiveComparator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcCategoriesDao
extends JdbcBaseDao
implements CategoriesDao,
Maintainable {
    protected LRUCache categoriesCache = new LRUCache();
    protected LRUCache subCategoriesCache = new LRUCache();
    protected boolean initialized = false;

    protected synchronized void initialize() throws DataRetrievalFailureException {
        if (!this.initialized) {
            this.log.debug((Object)"initialize()");
            try {
                this.constructCategoriesCache();
                this.initialized = true;
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage());
                throw new DataRetrievalFailureException("Unexpected error, unable to load Category Cache! ", (Throwable)e);
            }
        }
    }

    @Override
    public Category getCategory(int catId) {
        try {
            Category cat = (Category)this.categoriesCache.get(catId);
            if (cat == null) {
                cat = (Category)this.constructObject(Category.class, catId);
            }
            if (cat == null) {
                return null;
            }
            List<Category> children = this.getSubCategories(catId);
            if (children != null) {
                cat.setChildren(children);
            }
            return cat;
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve Category for id=" + catId, (Throwable)e);
        }
    }

    @Override
    public List<Category> getSubCategories(int parentCategoryId) {
        ArrayList<Category> categoryList = (ArrayList<Category>)this.subCategoriesCache.get(parentCategoryId);
        if (categoryList != null) {
            return categoryList;
        }
        categoryList = new ArrayList<Category>();
        try {
            List catList = (List)this.constructObjects(Category.class, "parentId", parentCategoryId);
            if (catList != null && catList.size() > 0) {
                Collections.sort(catList, new ReflectiveComparator("getSortOrder", 2));
                categoryList.addAll(catList);
                for (Category cat : catList) {
                    List<Category> children = this.getSubCategories(cat.getId());
                    if (children == null) continue;
                    cat.setChildren(children);
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve Categories for parentCategoryId=" + parentCategoryId, (Throwable)e);
        }
        this.subCategoriesCache.put(parentCategoryId, categoryList);
        return categoryList;
    }

    @Override
    public synchronized void saveCategory(Category cat) throws DataAccessException {
        try {
            this.saveObject(cat);
            cat = (Category)this.constructObject(Category.class, cat.getId());
            this.categoriesCache.put(cat.getId(), cat);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new DataRetrievalFailureException("Error saving Category: displayName=" + cat.getCategory(), (Throwable)e);
        }
    }

    @Override
    public void deleteCategory(Category cat) {
        try {
            this.categoriesCache.remove(cat.getId());
            this.deleteObject(cat);
            List<Category> children = this.getSubCategories(cat.getId());
            if (children != null && children.size() > 0) {
                for (Category c : children) {
                    this.deleteCategory(c);
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new DataRetrievalFailureException("Unexpected error, unable to delete category, id=" + cat.getId(), (Throwable)e);
        }
    }

    private void constructCategoriesCache() throws SQLException {
        this.log.debug((Object)"Start constructing Category cache.");
        Collection allCats = new ArrayList();
        allCats = this.getAllObjects(Category.class, this.categoriesCache.getMaximumSize());
        int count = 0;
        for (Category cat : allCats) {
            List catList;
            this.categoriesCache.put(new Integer(cat.getId()), cat);
            if (this.log.isDebugEnabled() && ++count % 50 == 1) {
                this.log.info((Object)("Adding Category: " + cat.getCategory() + ", # " + count + " of " + allCats.size() + " total Catgories."));
            }
            if (cat.getParentId() < 0) continue;
            if (!this.subCategoriesCache.contains(cat.getParentId())) {
                this.subCategoriesCache.put(cat.getParentId(), new ArrayList());
            }
            if (!this.containsCategory(catList = (List)this.subCategoriesCache.get(cat.getParentId()), cat)) {
                catList.add(cat);
            }
            this.subCategoriesCache.put(cat.getParentId(), catList);
        }
        this.log.debug((Object)"Finished constructing Category cache.");
    }

    private boolean containsCategory(List<Category> catList, Category category) {
        if (catList == null || category == null) {
            return false;
        }
        for (Category c : catList) {
            if (c.getId() != category.getId()) continue;
            return true;
        }
        return false;
    }

    public void setCategoryCacheMaxSize(int maxCacheSize) {
        this.categoriesCache.setMaximumSize(maxCacheSize);
        this.subCategoriesCache.setMaximumSize(maxCacheSize);
    }

    @Override
    public void startMaintenance() throws Exception {
        this.categoriesCache.purge();
        this.subCategoriesCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }
}

