/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.luna.insight.server.SimpleDate;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.jdbc.DbAccessMetadata;
import com.lunaimaging.insight.core.jdbc.MapDbAccessMetadata;
import com.lunaimaging.insight.core.jdbc.ObjectDbAccessMetadata;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcBaseDao {
    protected Log log = LogFactory.getLog(this.getClass());
    protected DataSource dataSource;
    protected DatabaseType databaseType;
    protected Map<String, ObjectDbAccessMetadata> metadataBeans;
    protected static final ResultSetHandler defaultRsHandler = new MapListHandler();
    protected static final int DEFAULT_BATCH_SIZE = 10000;
    protected String objectDataTablePrefix = "ObjectData_";
    private static final String METADATA_BEAN_SUFFIX = "_Metadata";
    private static final int IDENTITY_NOT_RETURNED = -1;
    private static final String IDENTITY_RESULT_NAME = "IDENTITY";
    private static final String SQL_NULL_VALUE = "NULL";

    protected String constrcutMediaObjectDataQuery(MediaCollection mc) {
        StringBuilder sb = new StringBuilder();
        if (mc != null) {
            sb.append("SELECT * FROM [" + this.objectDataTablePrefix + mc.getId() + "]");
            sb.append(" WHERE ");
            sb.append(" id LIKE '" + this.escapeForSql(mc.getId()) + "%' ");
        }
        return sb.toString();
    }

    protected Object constructObject(CharSequence query, Object[] params, ResultSetHandler rsh) throws SQLException {
        QueryRunner run = new QueryRunner(this.dataSource);
        this.log.debug((Object)("query = " + query));
        return run.query(query.toString(), params, rsh);
    }

    protected Object constructObject(CharSequence query, ResultSetHandler rsh) throws SQLException {
        return this.constructObject(query, new Object[0], rsh);
    }

    protected Object constructObject(CharSequence query, Object[] params) throws SQLException {
        return this.constructObject(query, params, defaultRsHandler);
    }

    protected Object constructObject(CharSequence query) throws SQLException {
        return this.constructObject(query, new Object[0], defaultRsHandler);
    }

    protected void doUpdateOrSimpleInsert(CharSequence query) throws SQLException {
        QueryRunner run = new QueryRunner(this.dataSource);
        this.log.debug((Object)query);
        run.update(query.toString());
    }

    protected synchronized Object doInsertAndReturnId(BeanMap data, ObjectDbAccessMetadata metadata) throws SQLException {
        String query = this.generateInsertSql((Map)data, metadata);
        switch (this.databaseType) {
            case SQLSERVER: {
                return this.doInsertAndReturnId_SQLSERVER(metadata, query);
            }
            case ORACLE: {
                return this.doInsertAndReturnId_ORACLE(metadata, query);
            }
            case MYSQL: {
                return this.doInsertAndReturnId_MYSQL(metadata, query);
            }
        }
        return null;
    }

    protected synchronized Object doReturnLastId(BeanMap data, ObjectDbAccessMetadata metadata) throws SQLException {
        String query = this.generateInsertSql((Map)data, metadata);
        switch (this.databaseType) {
            case SQLSERVER: {
                return this.doInsertAndReturnId_SQLSERVER(metadata, query);
            }
            case ORACLE: {
                return this.doInsertAndReturnId_ORACLE(metadata, query);
            }
            case MYSQL: {
                return this.doInsertAndReturnId_MYSQL(metadata, query);
            }
        }
        return null;
    }

    protected Object constructObjectOnly(Class c, Object id) throws SQLException {
        return this.constructObject((CharSequence)this.generateSelectSql(c, id), (ResultSetHandler)new BeanHandler(c));
    }

    protected Object constructObjectOnly(Class c, Map params) throws SQLException {
        Object data = this.constructObject((CharSequence)this.generateSelectSql(c, params), (ResultSetHandler)new BeanHandler(c));
        return data;
    }

    protected Object constructObjectOnly(Class c, Object id, ResultSetHandler resultSetHandler) throws SQLException {
        return this.constructObject((CharSequence)this.generateSelectSql(c, id), resultSetHandler);
    }

    protected Object constructObject(Class c, Object id) throws SQLException {
        Object data = this.constructObjectOnly(c, id);
        this.loadMappings(data);
        return data;
    }

    protected void deleteObjects(Class c, String paramName, Object paramValue) throws SQLException {
        if (c != null) {
            ObjectDbAccessMetadata mapMetadata = this.getMetadataBean(c);
            this.doUpdateOrSimpleInsert(this.generateDeleteSql(mapMetadata.getTableName(), paramName, paramValue));
        }
    }

    protected void deleteObjects(Class c, Map params) throws SQLException {
        if (c != null && params != null && params.size() > 0) {
            ObjectDbAccessMetadata mapMetadata = this.getMetadataBean(c);
            this.doUpdateOrSimpleInsert(this.generateDeleteSql(mapMetadata.getTableName(), params));
        }
    }

    protected void deleteAllObjects(Class c) throws SQLException {
        this.deleteObjects(c, null, null);
    }

    protected void deleteObject(Object obj) throws SQLException {
        if (obj != null) {
            if (obj.getClass().isArray()) {
                for (Object o : (Object[])obj) {
                    this.deleteObject(o);
                }
            } else if (obj instanceof Collection) {
                this.deleteObject(((Collection)obj).toArray());
            } else {
                ObjectDbAccessMetadata mapMetadata = this.getMetadataBean(obj.getClass());
                BeanMap beanMap = new BeanMap(obj);
                Object identity = beanMap.get((Object)mapMetadata.getIdColumnName());
                this.doUpdateOrSimpleInsert(this.generateDeleteSql(mapMetadata, identity));
            }
        }
    }

    protected Collection getAllObjects(Class c) throws SQLException {
        Collection objects = (Collection)this.constructObject((CharSequence)this.generateSelectSql(c), (ResultSetHandler)new BeanListHandler(c));
        this.batchLoadMappings(objects);
        return objects;
    }

    protected Collection getAllObjects(Class c, int sampleSize) throws SQLException {
        Collection objects = (Collection)this.constructObject((CharSequence)this.generateSelectSql(sampleSize, c), (ResultSetHandler)new BeanListHandler(c));
        this.batchLoadMappings(objects);
        return objects;
    }

    protected Collection getAllObjectsOnly(Class c) throws SQLException {
        return (Collection)this.constructObject((CharSequence)this.generateSelectSql(c), (ResultSetHandler)new BeanListHandler(c));
    }

    protected Collection constructObjects(Class c, String paramName, Object paramValue) throws SQLException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(paramName, paramValue);
        return this.constructObjects(c, params);
    }

    protected Collection constructObjects(Class c, Map<String, Object> params) throws SQLException {
        Collection objects = this.constructObjects(c, this.generateSelectSql(c, params));
        this.batchLoadMappings(objects);
        return objects;
    }

    protected Collection constructObjects(Class c, String query) throws SQLException {
        Collection objects = (Collection)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(c));
        this.batchLoadMappings(objects);
        return objects;
    }

    protected Object getObjectsAsList(String query) throws SQLException {
        return this.constructObject((CharSequence)query, (ResultSetHandler)new ArrayListHandler());
    }

    protected void saveObjectOnly(Object saveMe) throws SQLException {
        ObjectDbAccessMetadata metadata = this.getMetadataBean(saveMe.getClass());
        BeanMap data = new BeanMap(saveMe);
        this.saveObject(data, metadata);
    }

    protected void saveObject(Object saveMe) throws SQLException {
        ObjectDbAccessMetadata metadata = this.getMetadataBean(saveMe.getClass());
        BeanMap data = new BeanMap(saveMe);
        this.saveObject(data, metadata);
        this.saveMappings(data, metadata);
    }

    protected void insertOnly(Object saveMe, boolean includeIdentity) throws SQLException {
        ObjectDbAccessMetadata metadata = this.getMetadataBean(saveMe.getClass());
        BeanMap data = new BeanMap(saveMe);
        QueryRunner run = new QueryRunner(this.dataSource);
        run.update(this.generateInsertSql((Map)data, metadata, includeIdentity));
    }

    protected void batchInsert(List objectsToInsert) throws SQLException {
        if (CollectionUtils.isNotEmpty((Collection)objectsToInsert)) {
            ObjectDbAccessMetadata metadata = this.getMetadataBean(objectsToInsert.get(0).getClass());
            BeanMap data = new BeanMap(objectsToInsert.get(0));
            StringBuilder names = new StringBuilder("INSERT INTO " + metadata.getTableName() + "( ");
            StringBuilder values = new StringBuilder(" ) VALUES ( ");
            ArrayList<String> parameterList = new ArrayList<String>();
            String appendPrefix = "";
            for (Object key : data.keySet()) {
                if (!this.addMemberVarToSqlStatement((Map)data, metadata, key, true)) continue;
                parameterList.add(String.valueOf(key));
                names.append(appendPrefix + key);
                values.append(appendPrefix + "?");
                appendPrefix = ", ";
            }
            values.append(" )");
            String query = names.toString() + values.toString();
            this.log.debug((Object)("batchInsert(..) : query = " + query));
            QueryRunner run = new QueryRunner(this.dataSource);
            int totalNumberOfBatches = (int)Math.ceil((double)objectsToInsert.size() / 10000.0);
            for (int batch = 0; batch < totalNumberOfBatches; ++batch) {
                int batchIndex = batch * 10000;
                int batchSize = Math.min(10000, objectsToInsert.size() - batchIndex);
                Object[][] params = new Object[batchSize][parameterList.size()];
                for (int i = 0; i < params.length; ++i) {
                    int objectIndex = i + batchIndex;
                    data = new BeanMap(objectsToInsert.get(objectIndex));
                    params[i] = new Object[parameterList.size()];
                    for (int j = 0; j < parameterList.size(); ++j) {
                        params[i][j] = data.get(parameterList.get(j));
                    }
                }
                run.batch(query, params);
            }
        }
    }

    protected void loadMappings(Object loadMe) throws SQLException {
        if (loadMe != null) {
            ObjectDbAccessMetadata metadata = this.getMetadataBean(loadMe.getClass());
            BeanMap data = new BeanMap(loadMe);
            Object parentIdValue = data.get((Object)metadata.getIdColumnName());
            for (MapDbAccessMetadata mapMetadata : metadata.getMapMetadataBeans()) {
                Collection rawData = (Collection)this.constructObject(this.generateSelectSql(mapMetadata, parentIdValue));
                for (String dataArrayVarName : mapMetadata.getDataArrayNames().keySet()) {
                    String dbColumnName = mapMetadata.getDataArrayNames().get(dataArrayVarName);
                    ArrayList dataArray = new ArrayList();
                    for (Map dataRow : rawData) {
                        dataArray.add(dataRow.get(dbColumnName));
                    }
                    data.put((Object)dataArrayVarName, dataArray);
                }
            }
        }
    }

    protected void batchLoadMappings(Collection<Object> loadMe) throws SQLException {
        this.log.debug((Object)"Loading mappings. Please wait...");
        ArrayList<Object> objects = new ArrayList<Object>(loadMe);
        if (objects.size() > 0) {
            ObjectDbAccessMetadata metadata = this.getMetadataBean(objects.get(0).getClass());
            for (MapDbAccessMetadata mapMetadata : metadata.getMapMetadataBeans()) {
                Collection rawData = (Collection)this.constructObject("SELECT * FROM " + mapMetadata.getTableName());
                for (Object e : objects) {
                    BeanMap data = new BeanMap(e);
                    Object parentIdValue = data.get((Object)metadata.getIdColumnName());
                    for (String dataArrayVarName : mapMetadata.getDataArrayNames().keySet()) {
                        String dbColumnName = mapMetadata.getDataArrayNames().get(dataArrayVarName);
                        ArrayList dataArray = new ArrayList();
                        for (Map dataRow : rawData) {
                            String idCol;
                            Object o = dataRow.get(idCol = mapMetadata.getIdColumnName());
                            if (o instanceof Number) {
                                if (((Number)parentIdValue).intValue() != ((Number)o).intValue()) continue;
                                dataArray.add(dataRow.get(dbColumnName));
                                continue;
                            }
                            if (!parentIdValue.equals(o)) continue;
                            dataArray.add(dataRow.get(dbColumnName));
                        }
                        data.put((Object)dataArrayVarName, dataArray);
                    }
                }
            }
        }
    }

    private Object doInsertAndReturnId_SQLSERVER(ObjectDbAccessMetadata metadata, CharSequence query) throws SQLException {
        StringBuilder sb = new StringBuilder(query);
        sb.insert(0, "BEGIN TRANSACTION; ");
        sb.append(" SELECT IsNull(@@identity, -1) AS 'IDENTITY'; COMMIT TRANSACTION;");
        List result = (List)this.constructObject((CharSequence)sb, defaultRsHandler);
        return ((Map)result.get(0)).get(IDENTITY_RESULT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doInsertAndReturnId_ORACLE(ObjectDbAccessMetadata metadata, CharSequence query) throws SQLException {
        Integer identity = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.log.debug((Object)query);
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(query.toString());
            rs = stmt.executeQuery(query.toString());
            rs.close();
            stmt.close();
            String identityQuery = "SELECT " + metadata.getIdentitySequenceName() + ".currVal AS " + IDENTITY_RESULT_NAME + " FROM DUAL";
            this.log.debug((Object)identityQuery);
            stmt = con.prepareStatement(identityQuery);
            stmt.executeQuery(identityQuery);
            rs = stmt.getResultSet();
            if (rs != null && rs.next()) {
                identity = rs.getInt(IDENTITY_RESULT_NAME);
                rs.close();
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.log.error((Object)"Unable to insert for oracle db: ", (Throwable)e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doInsertAndReturnId_MYSQL(ObjectDbAccessMetadata metadata, CharSequence query) throws SQLException {
        Integer identity = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.log.debug((Object)query);
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(query.toString());
            stmt.execute(query.toString());
            stmt.close();
            String identityQuery = "SELECT LAST_INSERT_ID() AS IDENTITY";
            this.log.debug((Object)identityQuery);
            stmt = con.prepareStatement(identityQuery);
            stmt.executeQuery(identityQuery);
            rs = stmt.getResultSet();
            if (rs != null && rs.next()) {
                identity = rs.getInt(IDENTITY_RESULT_NAME);
                rs.close();
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.log.error((Object)"Unable to insert for oracle db: ", (Throwable)e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateLastId(Class c) {
        ObjectDbAccessMetadata mapMetadata = this.getMetadataBean(c);
        String query = "SELECT MAX(" + mapMetadata.getIdColumnName() + ") FROM " + mapMetadata.getTableName();
        int id = 0;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.log.debug((Object)query);
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement(query);
            stmt.executeQuery(query);
            rs = stmt.getResultSet();
            if (rs != null && rs.next()) {
                id = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)"Unable to insert for oracle db: ", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return id;
    }

    private void saveMappings(BeanMap data, ObjectDbAccessMetadata metadata) throws SQLException {
        Object parentIdValue = data.get((Object)metadata.getIdColumnName());
        block0: for (MapDbAccessMetadata mapMetadata : metadata.getMapMetadataBeans()) {
            this.doUpdateOrSimpleInsert(this.generateDeleteSql(mapMetadata, parentIdValue));
            int max = 999;
            for (int rowIndex = 0; rowIndex < max; ++rowIndex) {
                HashMap<String, Object> mappingRow = new HashMap<String, Object>();
                mappingRow.put(mapMetadata.getIdColumnName(), parentIdValue);
                for (String dataArrayVarName : mapMetadata.getDataArrayNames().keySet()) {
                    if (rowIndex == 0 && (max = ((ArrayList)data.get((Object)dataArrayVarName)).size()) == 0) break;
                    String dbColumnName = mapMetadata.getDataArrayNames().get(dataArrayVarName);
                    mappingRow.put(dbColumnName, ((ArrayList)data.get((Object)dataArrayVarName)).get(rowIndex));
                }
                if (max == 0) continue block0;
                this.doUpdateOrSimpleInsert(this.generateInsertSql(mappingRow, mapMetadata));
            }
        }
    }

    private void saveObject(BeanMap data, ObjectDbAccessMetadata metadata) throws SQLException {
        if (this.isNew(data, metadata)) {
            Object newId = this.doInsertAndReturnId(data, metadata);
            data.put((Object)metadata.getIdColumnName(), newId);
        } else {
            this.doUpdateOrSimpleInsert(this.generateUpdateSql((Map)data, metadata));
        }
    }

    private String generateSelectSql(int sampleSize, Class c) {
        switch (this.databaseType) {
            case SQLSERVER: {
                return "SELECT TOP " + sampleSize + " * FROM " + this.getMetadataBean(c).getTableName();
            }
            case MYSQL: {
                return "SELECT * FROM " + this.getMetadataBean(c).getTableName() + " limit " + sampleSize;
            }
            case ORACLE: {
                return "SELECT * FROM " + this.getMetadataBean(c).getTableName() + " WHERE ROWNUM < " + sampleSize;
            }
        }
        return null;
    }

    private String generateSelectSql(Class c) {
        return "SELECT * FROM " + this.getMetadataBean(c).getTableName();
    }

    private String generateSelectSql(Class c, Object id) {
        return this.generateSelectSql(this.getMetadataBean(c), id);
    }

    private String generateSelectSql(DbAccessMetadata metadata, Object id) {
        return "SELECT * FROM " + metadata.getTableName() + " WHERE " + metadata.getIdColumnName() + " = " + this.convertForSql(id);
    }

    private String generateSelectSql(Class c, Map<String, Object> params) {
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(c).getTableName());
        String appendPrefix = " WHERE ";
        for (String key : params.keySet()) {
            query.append(appendPrefix + key + "=" + this.convertForSql(params.get(key)));
            appendPrefix = " AND ";
        }
        return query.toString();
    }

    private String generateUpdateSql(Map data, DbAccessMetadata metadata) {
        StringBuilder sb = new StringBuilder("UPDATE " + metadata.getTableName() + " SET ");
        String appendPrefix = "";
        for (Object key : data.keySet()) {
            if (!this.addMemberVarToSqlStatement(data, metadata, key, false)) continue;
            sb.append(appendPrefix + key + "=" + this.convertForSql(data.get(key)));
            appendPrefix = ", ";
        }
        sb.append(" WHERE " + metadata.getIdColumnName() + "=" + data.get(metadata.getIdColumnName()));
        String sql = sb.toString();
        this.log.debug((Object)("generateUpdateSql(..): " + sql));
        return sql;
    }

    protected String generateInsertSql(Map data, DbAccessMetadata metadata) {
        return this.generateInsertSql(data, metadata, false);
    }

    protected String generateInsertSql(Map data, DbAccessMetadata metadata, boolean includeIdentity) {
        StringBuilder names = new StringBuilder("INSERT INTO " + metadata.getTableName() + " ( ");
        StringBuilder values = new StringBuilder(" ) VALUES( ");
        String appendPrefix = "";
        for (Object key : data.keySet()) {
            if (!this.addMemberVarToSqlStatement(data, metadata, key, includeIdentity)) continue;
            values.append(appendPrefix + this.convertForSql(data.get(key)));
            if (this.databaseType.getColumnNameEscapePrefix() != null) {
                key = this.databaseType.getColumnNameEscapePrefix() + key;
            }
            if (this.databaseType.getColumnNameEscapeSuffix() != null) {
                key = key + this.databaseType.getColumnNameEscapeSuffix();
            }
            names.append(appendPrefix + key);
            appendPrefix = ", ";
        }
        String query = names.toString() + values.toString() + " )";
        this.log.debug((Object)("generateInsertSql(..) query = " + query));
        return query;
    }

    private String generateDeleteSql(DbAccessMetadata metadata, Object id) {
        return this.generateDeleteSql(metadata.getTableName(), metadata.getIdColumnName(), id);
    }

    private String generateDeleteSql(String tableName, String columnName, Object value) {
        String query = "DELETE FROM " + tableName;
        if (columnName != null && value != null) {
            query = query + " WHERE " + columnName + " = " + this.convertForSql(value);
        }
        this.log.debug((Object)("generateDeleteSql(..): " + query));
        this.log.debug((Object)("generateDeleteSql(..): query = " + query));
        return query;
    }

    private String generateDeleteSql(String tableName, Map<String, Object> params) {
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM " + tableName);
        if (params != null && params.size() > 0) {
            query.append(" WHERE ");
            int index = 0;
            for (String key : params.keySet()) {
                if (index != 0) {
                    query.append(" AND ");
                }
                query.append(key + " = " + this.convertForSql(params.get(key)));
                ++index;
            }
        }
        this.log.debug((Object)("query = " + query.toString()));
        return query.toString();
    }

    private boolean isNew(BeanMap data, DbAccessMetadata metadata) {
        Object id = data.get((Object)metadata.getIdColumnName());
        return id == null || id instanceof Integer && ((Number)id).intValue() <= 0;
    }

    private boolean addMemberVarToSqlStatement(Map data, DbAccessMetadata metadata, Object key, boolean includeIdentity) {
        if (metadata instanceof ObjectDbAccessMetadata) {
            if (includeIdentity && ((ObjectDbAccessMetadata)metadata).getIdColumnName().equals((String)key)) {
                return true;
            }
            return !((ObjectDbAccessMetadata)metadata).getIdColumnName().equals((String)key) && !((ObjectDbAccessMetadata)metadata).getExcludeColumnNames().contains((String)key) && this.isAllowedType(((BeanMap)data).getType((String)key));
        }
        return true;
    }

    private boolean isAllowedType(Class type) {
        return type.isPrimitive() || type.getName().equals(String.class.getName()) || type.getName().equals(StringBuffer.class.getName()) || type.getName().equals(StringBuilder.class.getName()) || type.getName().equals(Date.class.getName()) || type.getName().equals(SimpleDate.class.getName()) || type.getName().equals(Timestamp.class.getName());
    }

    private String convertForSql(Object obj) {
        if (obj == null) {
            return this.escapeNull();
        }
        if (obj instanceof CharSequence) {
            return this.convertInput((CharSequence)obj);
        }
        if (obj instanceof Date) {
            return this.convertInput((Date)obj);
        }
        if (obj instanceof Boolean) {
            return this.convertInput((Boolean)obj);
        }
        return obj + "";
    }

    protected String escapeNull() {
        return SQL_NULL_VALUE;
    }

    protected String convertInput(CharSequence input) {
        switch (this.databaseType) {
            case SQLSERVER: {
                return "N'" + this.escapeForSql(input) + "'";
            }
            case ORACLE: {
                return "'" + this.escapeForSql(input) + "'";
            }
            case MYSQL: {
                return "'" + this.escapeForSql(input) + "'";
            }
        }
        return null;
    }

    protected String escapeForSql(CharSequence input) {
        return input.toString().replaceAll("'", "''");
    }

    protected String convertInput(Boolean input) {
        return input != false ? "1" : "0";
    }

    String convertInput(Date input) {
        switch (this.databaseType) {
            case SQLSERVER: {
                return this.convertInput(input.toString());
            }
            case ORACLE: {
                return this.convertInput(input.toString());
            }
            case MYSQL: {
                return this.convertInput(input.toString());
            }
        }
        return null;
    }

    protected ObjectDbAccessMetadata getMetadataBean(Class c) {
        ObjectDbAccessMetadata metadata = this.metadataBeans.get(c.getName() + METADATA_BEAN_SUFFIX);
        if (metadata == null) {
            metadata = new ObjectDbAccessMetadata();
        }
        if (metadata.hasNulls()) {
            this.deNullMetadata(metadata, c);
            this.metadataBeans.put(c.getName() + METADATA_BEAN_SUFFIX, metadata);
        }
        return metadata;
    }

    private void deNullMetadata(ObjectDbAccessMetadata metadata, Class c) {
        if (metadata.getClassName() == null) {
            metadata.setClassName(c.getName());
        }
        if (metadata.getTableName() == null) {
            if (c.getName().endsWith("s")) {
                metadata.setTableName(c.getSimpleName());
            } else {
                metadata.setTableName(c.getSimpleName() + "s");
            }
        }
        if (metadata.getIdColumnName() == null) {
            metadata.setIdColumnName("id");
        }
        if (metadata.getExcludeColumnNames() == null) {
            metadata.setExcludeColumnNames(new ArrayList<String>());
        }
        if (metadata.getMapMetadataBeans() == null) {
            metadata.setMapMetadataBeans(new ArrayList<MapDbAccessMetadata>());
        }
        if (StringUtils.isEmpty((String)metadata.getIdentitySequenceName())) {
            metadata.setIdentitySequenceName(metadata.getTableName() + "_seq");
        }
        metadata.setHasNulls(false);
    }

    public void setMetadataBeans(Map<String, ObjectDbAccessMetadata> metadataBeans) {
        this.metadataBeans = metadataBeans;
        for (String key : metadataBeans.keySet()) {
            this.log.debug((Object)("Object Metadata bean: " + key.substring(key.lastIndexOf(".") + 1) + ", table=" + metadataBeans.get(key).getTableName() + " set..."));
            StringBuilder logEntry = new StringBuilder("...with Mapping Metadata Beans for: ");
            if (metadataBeans.get(key).getMapMetadataBeans() != null) {
                for (MapDbAccessMetadata map : metadataBeans.get(key).getMapMetadataBeans()) {
                    logEntry.append(map.getTableName() + "  ");
                }
            } else {
                logEntry.append(" no mappings.");
            }
            this.log.debug((Object)logEntry);
        }
    }

    public void setDataSource(DataSource dataSource) throws SQLException {
        String productName = dataSource.getConnection().getMetaData().getDatabaseProductName();
        this.log.debug((Object)("Database Product Name = " + productName));
        if (this.databaseType == null) {
            this.setDatabaseType(productName);
        }
        this.dataSource = dataSource;
    }

    public void setDatabaseType(String rawDatabaseType) {
        for (DatabaseType type : DatabaseType.values()) {
            if (!rawDatabaseType.toUpperCase().matches(type.getMatcher())) continue;
            this.log.debug((Object)("Setting database type (from DB product name or app context) = " + type.toString()));
            this.setDatabaseType(type);
            break;
        }
    }

    public void setObjectDataTablePrefix(String objectDataTablePrefix) {
        this.objectDataTablePrefix = objectDataTablePrefix;
    }

    public void setDatabaseType(DatabaseType databaseName) {
        this.databaseType = databaseName;
    }

    private static enum DatabaseType {
        SQLSERVER(".*SQL\\s*SERVER.*", "[", "]"),
        MYSQL(".*MY\\s*SQL.*", "", ""),
        ORACLE(".*ORACLE.*", "", "");

        private String matcher;
        private String columnNameEscapePrefix;
        private String columnNameEscapeSuffix;

        private DatabaseType(String matcher, String escapePrefix, String escapeSuffix) {
            this.matcher = matcher;
            this.columnNameEscapePrefix = escapePrefix;
            this.columnNameEscapeSuffix = escapeSuffix;
        }

        public String getMatcher() {
            return this.matcher;
        }

        public String getColumnNameEscapePrefix() {
            return this.columnNameEscapePrefix;
        }

        public String getColumnNameEscapeSuffix() {
            return this.columnNameEscapeSuffix;
        }
    }
}

