/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.AuthenticationDao;
import com.lunaimaging.insight.core.dao.exceptions.AuthenticationFailureException;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.Authenticable;
import com.lunaimaging.insight.core.domain.Credentials;
import com.lunaimaging.insight.core.domain.DomainUser;
import com.lunaimaging.insight.core.domain.IpRange;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.authenticators.Authenticator;
import com.lunaimaging.insight.core.domain.authenticators.LdapSearchAuthenticator;
import com.lunaimaging.insight.core.domain.authenticators.LegacyUserAuthenticator;
import com.lunaimaging.insight.core.domain.cache.IntUnboundCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.utils.PasswordEncryptUtils;
import com.lunaimaging.security.IpAddressUsernamePasswordToken;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcAuthenticationDao
extends JdbcBaseDao
implements AuthenticationDao,
Maintainable {
    protected IntUnboundCache userCache = new IntUnboundCache();
    protected IntUnboundCache ipRangeCache = new IntUnboundCache();
    protected IntUnboundCache credentialsCache = new IntUnboundCache();
    protected Credentials defaultCredentials;
    protected int defaultThumbnailSize;
    protected int defaultPageSize;
    private int RESOLUTION_CAP = 5;
    private List<Authenticator> authenticators;
    protected boolean initialized = false;
    protected List<MediaCollection> mediaCollections = null;
    protected boolean isLuna7 = true;

    protected synchronized void initialize() throws DataRetrievalFailureException {
        this.log.debug((Object)"initialize()");
        try {
            this.log.info((Object)"LUNA Viewer authentication cache initialization. Please wait...");
            this.constructCredentialsCache();
            this.constructDefaultCredentials();
            this.constructUserCache();
            this.constructIpRangeCache();
            this.log.info((Object)"End of LUNA Viewer authentication cache initialization.");
            this.initialized = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to load authentication Caches! Check log for errors, could be a malformed IP in IP Ranges.", (Throwable)e);
        }
    }

    @Override
    public Authenticable authenticate(IpAddressUsernamePasswordToken token) throws DataAccessException {
        User u;
        block12: {
            u = null;
            try {
                String pwd = token.getPassword() != null ? new String(token.getPassword()) : null;
                try {
                    u = this.getUserWithPassword(token.getUsername(), pwd);
                    if (u != null && !(u instanceof DomainUser)) {
                        String encrptedPassword = PasswordEncryptUtils.digest(pwd);
                        u.setPassword(encrptedPassword);
                        this.saveUser(u);
                    }
                }
                catch (DataAccessException e) {
                    User userToCheck = this.getUser(token.getUsername(), "");
                    try {
                        if (!PasswordEncryptUtils.matches(pwd, userToCheck.getPassword())) {
                            String msg = "Login Failure: user=" + u + ", IP=" + token.getIpAddress();
                            this.log.info((Object)msg);
                            throw new AuthenticationFailureException(msg);
                        }
                        u = userToCheck;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        String msg = "Login Failure: user=" + u + ", IP=" + token.getIpAddress();
                        this.log.info((Object)msg);
                        throw new AuthenticationFailureException(msg);
                    }
                }
                if (u != null) {
                    if (u instanceof DomainUser) {
                        return this.authenticateViaAuthenticators((DomainUser)u, token);
                    }
                    if (StringUtils.isNotEmpty((String)token.getIpAddress())) {
                        u.setIpRange(this.authenticate(token.getIpAddress()));
                        if (u.getIpRange() != null && u.getCredentials() != null) {
                            this.setMergedCredentials(u, u.getCredentials(), u.getIpRange().getCredentials());
                        }
                    }
                    break block12;
                }
                return this.authenticateViaAuthenticators(null, token);
            }
            catch (DataAccessException e) {
                AuthenticationFailureException afx = new AuthenticationFailureException("Login Failure: user=" + token.getUsername() + ", IP=" + token.getIpAddress());
                this.log.info((Object)afx.getMessage());
                throw afx;
            }
        }
        return u;
    }

    @Override
    public Authenticable authenticate(String ipAddress, String username, String password) throws DataAccessException {
        IpAddressUsernamePasswordToken token = new IpAddressUsernamePasswordToken(username, password);
        token.setIpAddress(ipAddress);
        return this.authenticate(token);
    }

    private synchronized User authenticateViaAuthenticators(DomainUser user, IpAddressUsernamePasswordToken token) {
        String pwd;
        User toReturn = null;
        String string = pwd = token.getPassword() != null ? new String(token.getPassword()) : null;
        if (user != null && StringUtils.isNotEmpty((String)user.getAuthenticatorType())) {
            boolean isAuthenticatorAccessed = false;
            for (Authenticator authenticator : this.authenticators) {
                if (!authenticator.getClass().toString().equalsIgnoreCase(user.getAuthenticatorType())) continue;
                isAuthenticatorAccessed = true;
                toReturn = this.preAssignDomainCredentials(authenticator, user, token);
                if (toReturn == null) continue;
                return toReturn;
            }
            if (isAuthenticatorAccessed) {
                return null;
            }
        }
        for (Authenticator authenticator : this.authenticators) {
            toReturn = this.preAssignDomainCredentials(authenticator, user, token);
            if (toReturn == null) continue;
            return toReturn;
        }
        String msg = "authenticateViaAuthenticators Failure: username=" + token.getUsername();
        this.log.info((Object)msg);
        throw new DataRetrievalFailureException(msg);
    }

    private User preAssignDomainCredentials(Authenticator authenticator, DomainUser user, IpAddressUsernamePasswordToken token) {
        Credentials domainCred = null;
        try {
            if (authenticator.getClass() == LegacyUserAuthenticator.class) {
                domainCred = ((LegacyUserAuthenticator)authenticator).authenticate(token, this.credentialsCache, this.mediaCollections);
            } else if (authenticator.getClass() == LdapSearchAuthenticator.class) {
                domainCred = ((LdapSearchAuthenticator)authenticator).authenticate(token, this.credentialsCache, this.mediaCollections);
            } else {
                if (user != null && token != null) {
                    token.setCredentialsId(user.getCredentialsId());
                }
                domainCred = authenticator.authenticate(token, this.credentialsCache);
            }
            if (domainCred != null) {
                for (int j = 0; j < domainCred.getMaxResolutions().size(); ++j) {
                    if (Integer.valueOf(domainCred.getMaxResolutions().get(j).toString()) <= this.RESOLUTION_CAP) continue;
                    domainCred.getMaxResolutions().set(j, this.RESOLUTION_CAP);
                }
                String pwd = token.getPassword() != null ? new String(token.getPassword()) : null;
                return this.assignDomainCredentials(user, token.getUsername(), pwd, domainCred, authenticator.getClass().toString());
            }
            this.log.debug((Object)("could not login with authenticator = " + authenticator + ", username=" + token.getUsername()));
        }
        catch (AuthenticationFailureException e) {
            String msg = "authenticateViaAuthenticators Failure: username=" + token.getUsername();
            this.log.info((Object)msg);
            throw new DataRetrievalFailureException(msg);
        }
        return null;
    }

    private User assignDomainCredentials(DomainUser user, String username, String password, Credentials domainCred, String authenticateType) {
        boolean saveNewUser = false;
        if (user == null) {
            saveNewUser = true;
            user = new DomainUser();
            user.setDomainAuthenticationRequired(true);
            user.setAuthenticatorType(authenticateType);
            user.setUsername(username);
            user.setPassword(password);
            user.setEnabled(true);
            user.setDefaultPageSize(this.defaultPageSize);
            user.setDefaultThumbnailSize(this.defaultThumbnailSize);
            user.setFirstName("");
            user.setLastName("");
            user.setEmail("");
        }
        if (domainCred == null) {
            user.setDomainCredentials(new Credentials(this.getDefaultCredentials()));
        } else {
            user.setDomainCredentials(domainCred);
        }
        if (saveNewUser) {
            user.setCredentials(this.getDefaultCredentials());
            user.setCredentialsId(this.getDefaultCredentials().getId());
        }
        if (authenticateType != null && !authenticateType.isEmpty()) {
            this.setMergedCredentials(user, user.getCredentials(), user.getDomainCredentials());
        } else {
            user.setMergedCredentials(user.getDomainCredentials());
        }
        if (saveNewUser && domainCred != null) {
            user.setCredentialsId(domainCred.getId());
        }
        if (saveNewUser) {
            user.setPassword("");
            this.saveUser(user);
        }
        return user;
    }

    @Override
    public IpRange authenticate(String ipAddress) throws DataAccessException {
        IpRange defaultIpRange = null;
        for (IpRange i : this.ipRangeCache.getAll()) {
            if (i.isSetAsDefault()) {
                defaultIpRange = i;
            }
            if (!i.contains(ipAddress)) continue;
            return i;
        }
        return defaultIpRange;
    }

    @Override
    public Map<Integer, String> getAllUsersMap(boolean includeDisabled) throws DataAccessException {
        HashMap<Integer, String> allUsers = new HashMap<Integer, String>();
        for (User u : this.getAllUsers()) {
            if (!includeDisabled && !u.isEnabled()) continue;
            allUsers.put(u.getId(), u.getUsername());
        }
        return allUsers;
    }

    public Map<String, String> getUsernameMap(boolean includeDisabled) throws DataAccessException {
        CaseInsensitiveMap allUsers = new CaseInsensitiveMap();
        for (User u : this.getAllUsers()) {
            if (!includeDisabled && !u.isEnabled()) continue;
            allUsers.put(u.getUsername(), "");
        }
        return allUsers;
    }

    @Override
    public boolean isUniqueName(String username) {
        boolean toReturn;
        block2: {
            Authenticator authenticator;
            toReturn = false;
            Map<String, String> userMap = this.getUsernameMap(true);
            if (userMap.containsKey(username)) {
                toReturn = true;
            }
            if (!toReturn) break block2;
            Iterator<Authenticator> iterator = this.authenticators.iterator();
            while (iterator.hasNext() && (toReturn = (authenticator = iterator.next()).isUniqueUsername(username))) {
            }
        }
        return toReturn;
    }

    @Override
    public Collection<User> getAllUsers() throws DataAccessException {
        return this.userCache.getAll();
    }

    public User getUserWithPassword(String username, String password) throws DataAccessException {
        for (User u : this.getAllUsers()) {
            if (!u.getUsername().equalsIgnoreCase(username)) continue;
            if (u instanceof DomainUser) {
                return u;
            }
            if (u.getPassword().equals(password)) {
                return u;
            }
            String msg = "Need to check encrypted password for user: username=" + username;
            this.log.debug((Object)msg);
            throw new DataRetrievalFailureException(msg);
        }
        return null;
    }

    @Override
    public User getUser(String username, String ipAddress) throws DataAccessException {
        for (User u : this.getAllUsers()) {
            if (!u.getUsername().equals(username)) continue;
            return u;
        }
        return null;
    }

    @Override
    public User getUserByEmailAddress(String emailAddress, String ipAddress) throws DataAccessException {
        for (User u : this.getAllUsers()) {
            if (!StringUtils.equalsIgnoreCase((String)u.getEmail(), (String)emailAddress)) continue;
            return u;
        }
        String msg = "Failed attempt to process forgotten password: emailAddress=" + emailAddress + ", IP=" + ipAddress;
        this.log.info((Object)msg);
        throw new AuthenticationFailureException(msg);
    }

    @Override
    public User getUser(int userId) throws DataAccessException {
        if (this.userCache.get(userId) != null) {
            return (User)this.userCache.get(userId);
        }
        String msg = "Failed attempt to find user: id=" + userId;
        this.log.info((Object)msg);
        throw new DataRetrievalFailureException(msg);
    }

    @Override
    public void saveUser(User user) throws DataAccessException {
        try {
            this.saveObject(user);
            this.userCache.put(user.getId(), user);
        }
        catch (SQLException e) {
            String msg = "Error saving user: username=" + user.getUsername();
            this.log.error((Object)msg);
            throw new DataRetrievalFailureException(msg, (Throwable)e);
        }
    }

    @Override
    public String generateRandomPassword(int length) {
        Random rand = new Random();
        char[] password = new char[length];
        for (int x = 0; x < length; ++x) {
            int randDecimalAsciiVal = rand.nextInt(74) + 48;
            if (randDecimalAsciiVal > 57 && randDecimalAsciiVal < 65 || randDecimalAsciiVal > 90 && randDecimalAsciiVal < 97) {
                --x;
                continue;
            }
            password[x] = (char)randDecimalAsciiVal;
        }
        return String.valueOf(password);
    }

    public void setMergedCredentials(User user, Credentials originalCred, Credentials newCred) {
        Credentials mergedCredentials = new Credentials();
        Credentials userCredentials = originalCred;
        try {
            mergedCredentials = (Credentials)BeanUtils.cloneBean((Object)userCredentials);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            e.printStackTrace();
        }
        mergedCredentials.setExportAllowed(originalCred.isExportAllowed() || newCred.isExportAllowed());
        mergedCredentials.setUploadAllowed(originalCred.isUploadAllowed() || newCred.isUploadAllowed());
        mergedCredentials.setPublicContentAllowed(originalCred.isPublicContentAllowed() || newCred.isPublicContentAllowed());
        for (int i = 0; i < newCred.getAuthorizedCollectionIds().size(); ++i) {
            String foreignId = (String)newCred.getAuthorizedCollectionIds().get(i);
            int foreignMax = newCred.retrieveMaxResolution(foreignId);
            int foreignExportMax = newCred.retrieveMaxExportResolution(foreignId);
            int myMaxForForeignId = userCredentials.retrieveMaxResolution(foreignId);
            int myExportMaxForForeignId = userCredentials.retrieveMaxExportResolution(foreignId);
            if (myMaxForForeignId == -1 || myMaxForForeignId > -1 && myMaxForForeignId < foreignMax) {
                mergedCredentials.updateMaxResolution(foreignId, foreignMax);
            }
            if (myExportMaxForForeignId != -1 && (myExportMaxForForeignId <= -1 || myExportMaxForForeignId >= foreignExportMax)) continue;
            mergedCredentials.updateMaxExportResolution(foreignId, foreignExportMax);
        }
        user.setMergedCredentials(mergedCredentials);
    }

    private Credentials getCredentials(int credentialsId) throws DataRetrievalFailureException {
        return (Credentials)this.credentialsCache.get(credentialsId);
    }

    private void constructUserCache() throws SQLException {
        this.log.debug((Object)"Start constructing User cache.");
        Collection allUsers = new ArrayList();
        Collection allDomainUsers = new ArrayList();
        HashMap<String, Object> paramsUser = new HashMap<String, Object>();
        HashMap<String, Object> paramsDomainUser = new HashMap<String, Object>();
        paramsUser.put("domainAuthenticationRequired", 0);
        paramsDomainUser.put("domainAuthenticationRequired", 1);
        allUsers = this.constructObjects(User.class, paramsUser);
        allDomainUsers = this.constructObjects(DomainUser.class, paramsDomainUser);
        int count = 0;
        for (User u : allUsers) {
            u.setCredentials(this.getCredentials(u.getCredentialsId()));
            this.userCache.put(u.getId(), u);
            if (!this.log.isDebugEnabled() || ++count % 50 != 1) continue;
            this.log.debug((Object)("Adding User: " + u.getUsername() + ", # " + count + " of " + allUsers.size() + " total users."));
        }
        this.log.debug((Object)"Finished constructing User cache.");
        this.log.debug((Object)"Start constructing DomainUser cache.");
        count = 0;
        for (User u : allDomainUsers) {
            u.setCredentials(this.getCredentials(u.getCredentialsId()));
            if (((DomainUser)u).isDomainAuthenticationRequired()) {
                this.userCache.put(u.getId(), u);
            }
            if (!this.log.isDebugEnabled() || ++count % 50 != 1) continue;
            this.log.info((Object)("Adding User: " + u.getUsername() + ", # " + count + " of " + allUsers.size() + " total users."));
        }
        this.log.debug((Object)"Finished constructing DomainUser cache.");
    }

    private void constructIpRangeCache() throws SQLException {
        this.log.debug((Object)"Start constructing IP Range cache.");
        Collection allIpRanges = new ArrayList();
        allIpRanges = this.getAllObjects(IpRange.class);
        int count = 0;
        for (IpRange i : allIpRanges) {
            i.setCredentials(this.getCredentials(i.getCredentialsId()));
            this.ipRangeCache.put(i.getId(), i);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Adding IP Range: " + i.getLocation() + " (" + i.getStartIp() + "-" + i.getEndIp() + "), # " + ++count + " of " + allIpRanges.size() + " total IP Ranges."));
        }
        this.log.debug((Object)"Finished constructing IP Range cache.");
    }

    private void constructCredentialsCache() throws SQLException {
        this.log.debug((Object)"Start constructing Credentials cache.");
        Collection allCredentials = new ArrayList();
        allCredentials = this.getAllObjects(Credentials.class);
        int count = 0;
        for (Credentials c : allCredentials) {
            this.credentialsCache.put(c.getId(), c);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Credentials: " + c.getName() + ", # " + ++count + " of " + allCredentials.size() + " total Credentials."));
            }
            if (!c.isUseAsDefault()) continue;
            this.defaultCredentials = c;
        }
        this.log.debug((Object)"Finished constructing Credentials cache.");
    }

    private void constructDefaultCredentials() {
        for (Authenticator a : this.authenticators) {
            int id = a.getDefaultCredentialsId();
            Object obj = this.credentialsCache.get(id);
            if (obj == null) continue;
            Credentials c = (Credentials)obj;
            a.setDefaultCredentals(c);
            this.log.debug((Object)("Authenticator = " + a.toString() + " default Credentials set. Credentials id = " + c.getId()));
        }
    }

    @Override
    public Credentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    public void setDefaultCredentials(Credentials defaultCredentials) {
        this.defaultCredentials = defaultCredentials;
    }

    public void setMediaCollectionList(List<MediaCollection> mediaCollections) {
        this.mediaCollections = mediaCollections;
    }

    @Override
    public void startMaintenance() throws Exception {
        this.userCache.purge();
        this.ipRangeCache.purge();
        this.credentialsCache.purge();
        this.defaultCredentials = null;
        this.initialized = false;
        if (this.isLuna7) {
            this.endMaintenance();
        }
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }

    public List<Authenticator> getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(List<Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public int getDefaultThumbnailSize() {
        return this.defaultThumbnailSize;
    }

    public void setDefaultThumbnailSize(int defaultThumbnailSize) {
        this.defaultThumbnailSize = defaultThumbnailSize;
    }
}

