/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.lunaimaging.insight.core.dao.ApplicationConfigurationDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.ApplicationConfiguration;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.utils.ParsingUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.dao.DataRetrievalFailureException;

public class JdbcApplicationConfigurationDao
extends JdbcBaseDao
implements ApplicationConfigurationDao,
Maintainable {
    protected ApplicationConfiguration applicationConfigurationInstance;

    protected synchronized void initialize() throws DataRetrievalFailureException {
        try {
            this.populateAppConfig();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to load application configuration information! Does the table exist?", (Throwable)e);
        }
    }

    @Override
    public void repopulateAppConfig() {
        this.initialize();
    }

    private void populateAppConfig() throws SQLException {
        this.applicationConfigurationInstance = new ApplicationConfiguration();
        String appConfigQuery = "SELECT * FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName();
        List attributeList = (List)this.constructObject(appConfigQuery);
        String key = null;
        Object value = null;
        for (Map attribute : attributeList) {
            try {
                int index;
                key = (String)attribute.get("attribute");
                if (!StringUtils.isNotEmpty((String)key) || (value = attribute.get("attributeValue")) == null) continue;
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.PUBLIC_CONTENT_URL_PREFIX.getAttributeName())) {
                    this.applicationConfigurationInstance.addContentDistributionUrl(String.valueOf(value));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.DISTRIBUTED_CONTENT_IDENTITY_PREFIX.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.DISTRIBUTED_CONTENT_IDENTITY_PREFIX.getAttributeName().length()));
                    this.applicationConfigurationInstance.addPublicContentRecipient(value, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.DISTRIBUTED_CONTENT_PASSWORD_PREFIX.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.META_DESCRIPTION_PREFIX.getAttributeName())) {
                    index = ConfigurationAttributes.META_DESCRIPTION_PREFIX.getAttributeName().length();
                    this.applicationConfigurationInstance.addMetaDescription(key.substring(index), value);
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.THUMB_FACET_LABEL_PREFIX.getAttributeName())) {
                    index = ConfigurationAttributes.THUMB_FACET_LABEL_PREFIX.getAttributeName().length();
                    this.applicationConfigurationInstance.addThumbnailFacetLabel(key.substring(index), value);
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.META_KEYWORDS_PREFIX.getAttributeName())) {
                    index = ConfigurationAttributes.META_KEYWORDS_PREFIX.getAttributeName().length();
                    this.applicationConfigurationInstance.addMetaKeywords(key.substring(index), value);
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.BUY_LINK_PARAM_NAME.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.BUY_LINK_PARAM_NAME.getAttributeName().length()));
                    this.applicationConfigurationInstance.addBuyLinkParamName(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.BUY_LINK_PARAM_NAME.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.BUY_LINK_PARAM_SRC_FIELD.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.BUY_LINK_PARAM_SRC_FIELD.getAttributeName().length()));
                    this.applicationConfigurationInstance.addBuyLinkParamSrcField(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.BUY_LINK_PARAM_SRC_FIELD.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.BUY_LINK_COLLECTION_ID.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.BUY_LINK_COLLECTION_ID.getAttributeName().length()));
                    this.applicationConfigurationInstance.addBuyLinkCollectionId(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.BUY_LINK_COLLECTION_ID.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.BUY_BUTTON_COLLECTION_ID.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.BUY_BUTTON_COLLECTION_ID.getAttributeName().length()));
                    this.applicationConfigurationInstance.addBuyButtonCollectionId(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.BUY_BUTTON_COLLECTION_ID.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.BUY_BUTTON_CUSTOM_TEXT.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.BUY_BUTTON_CUSTOM_TEXT.getAttributeName().length()));
                    this.applicationConfigurationInstance.addBuyButtonCustomText(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.BUY_BUTTON_CUSTOM_TEXT.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.OAI_ORDERED_DC_FIELD.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.OAI_ORDERED_DC_FIELD.getAttributeName().length()));
                    this.applicationConfigurationInstance.addOaiOrderedDCField(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.OAI_ORDERED_DC_FIELD.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.OAI_ORDERED_STANDARD_FIELDS.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.OAI_ORDERED_STANDARD_FIELDS.getAttributeName().length()));
                    this.applicationConfigurationInstance.addOaiOrderedStandardFields(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.OAI_ORDERED_STANDARD_FIELDS.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.OAI_ORDERED_STANDARD_NAME.getAttributeName())) {
                    index = NumberUtils.toInt((String)key.substring(ConfigurationAttributes.OAI_ORDERED_STANDARD_NAME.getAttributeName().length()));
                    this.applicationConfigurationInstance.addOaiOrderedStandardName(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.OAI_ORDERED_STANDARD_NAME.getAttributeName() + index));
                    continue;
                }
                if (ParsingUtils.startsWithIgnoreCaseTrim(key, ConfigurationAttributes.BUY_BUTTON_BASE_URL.getAttributeName())) {
                    String s = key.substring(ConfigurationAttributes.BUY_BUTTON_BASE_URL.getAttributeName().length());
                    if (!StringUtils.isNotBlank((String)s)) continue;
                    index = NumberUtils.toInt((String)s);
                    this.applicationConfigurationInstance.addBuyButtonBaseUrls(index, (String)this.getFirstValueFromMap(attributeList, ConfigurationAttributes.BUY_BUTTON_BASE_URL.getAttributeName() + index));
                    continue;
                }
                BeanUtils.setProperty((Object)this.applicationConfigurationInstance, (String)key, value);
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to set attribute to app config: [" + key + "]"), (Throwable)e);
            }
        }
    }

    protected Object getFirstValueFromMap(List<Map<String, Object>> attributeList, String key) {
        if (attributeList != null) {
            for (Map<String, Object> map : attributeList) {
                if (map == null || !StringUtils.equalsIgnoreCase((String)((String)map.get("attribute")), (String)key)) continue;
                return map.get("attributeValue");
            }
        }
        return null;
    }

    @Override
    public void deleteAttribute(String attribute) throws SQLException {
        String appConfigQuery = "DELETE FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " WHERE ATTRIBUTE=" + this.convertInput(attribute);
        this.doUpdateOrSimpleInsert(appConfigQuery);
        this.repopulateAppConfig();
    }

    @Override
    public void purgeBuyButtonProperties() throws SQLException {
        String appConfigQuery = "DELETE FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " WHERE ATTRIBUTE LIKE '" + ConfigurationAttributes.BUY_BUTTON_COLLECTION_ID.getAttributeName() + "%'";
        this.doUpdateOrSimpleInsert(appConfigQuery);
        appConfigQuery = "DELETE FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " WHERE ATTRIBUTE LIKE '" + ConfigurationAttributes.BUY_BUTTON_CUSTOM_TEXT.getAttributeName() + "%'";
        this.doUpdateOrSimpleInsert(appConfigQuery);
        appConfigQuery = "DELETE FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " WHERE ATTRIBUTE LIKE '" + ConfigurationAttributes.BUY_BUTTON_BASE_URL.getAttributeName() + "%'";
        this.doUpdateOrSimpleInsert(appConfigQuery);
        this.repopulateAppConfig();
    }

    @Override
    public void purgeBuyLinkParamAttributes() throws SQLException {
        String appConfigQuery = "DELETE FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " WHERE ATTRIBUTE LIKE '" + ConfigurationAttributes.BUY_LINK_COLLECTION_ID.getAttributeName() + "%'";
        this.doUpdateOrSimpleInsert(appConfigQuery);
        appConfigQuery = "DELETE FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " WHERE ATTRIBUTE LIKE '" + ConfigurationAttributes.BUY_LINK_PARAM_NAME.getAttributeName() + "%'";
        this.doUpdateOrSimpleInsert(appConfigQuery);
        appConfigQuery = "DELETE FROM " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " WHERE ATTRIBUTE LIKE '" + ConfigurationAttributes.BUY_LINK_PARAM_SRC_FIELD.getAttributeName() + "%'";
        this.doUpdateOrSimpleInsert(appConfigQuery);
        this.repopulateAppConfig();
    }

    @Override
    public void insertAttribute(String attribute, String value) throws SQLException {
        String appConfigQuery = "INSERT INTO " + this.getMetadataBean(this.applicationConfigurationInstance.getClass()).getTableName() + " (ATTRIBUTE, ATTRIBUTEVALUE) VALUES (" + this.convertInput(attribute) + "," + this.convertInput(value) + ")";
        this.doUpdateOrSimpleInsert(appConfigQuery);
        this.repopulateAppConfig();
    }

    @Override
    public void batchInsertBuyButtonProperties(List<String> buyButtonCollectionIds, List<String> buyButtonCustomText, List<String> buyButtonBaseUrls) throws SQLException {
        for (int i = 0; i < buyButtonCollectionIds.size(); ++i) {
            if (buyButtonCollectionIds.get(i) == null) continue;
            try {
                boolean isChanged = false;
                if (buyButtonCustomText.size() > i && StringUtils.isNotEmpty((String)buyButtonCustomText.get(i))) {
                    this.insertAttribute(ConfigurationAttributes.BUY_BUTTON_CUSTOM_TEXT.getAttributeName() + i, buyButtonCustomText.get(i));
                    isChanged = true;
                }
                if (buyButtonBaseUrls.size() > i && StringUtils.isNotEmpty((String)buyButtonBaseUrls.get(i))) {
                    this.insertAttribute(ConfigurationAttributes.BUY_BUTTON_BASE_URL.getAttributeName() + i, buyButtonBaseUrls.get(i));
                    isChanged = true;
                }
                if (!isChanged) continue;
                this.insertAttribute(ConfigurationAttributes.BUY_BUTTON_COLLECTION_ID.getAttributeName() + i, buyButtonCollectionIds.get(i));
                continue;
            }
            catch (SQLException s) {
                this.log.error((Object)("Could not insert entry for index " + i + ": buyButtonCustomText-" + buyButtonCustomText.get(i) + " buyButtonBaseUrls-" + buyButtonBaseUrls.get(i) + " buyButtonCollectionIds-" + buyButtonCollectionIds.get(i)), (Throwable)s);
            }
        }
        this.repopulateAppConfig();
    }

    @Override
    public void batchInsertBuyLinkParamAttributes(List<String> buyLinkCollectionIds, List<String> buyLinkParamNames, List<String> buyLinkParamSrcFields) throws SQLException {
        for (int i = 0; i < buyLinkCollectionIds.size(); ++i) {
            if (buyLinkParamNames.size() <= i || buyLinkParamSrcFields.size() <= i) continue;
            try {
                this.insertAttribute(ConfigurationAttributes.BUY_LINK_COLLECTION_ID.getAttributeName() + i, buyLinkCollectionIds.get(i));
                this.insertAttribute(ConfigurationAttributes.BUY_LINK_PARAM_NAME.getAttributeName() + i, buyLinkParamNames.get(i));
                this.insertAttribute(ConfigurationAttributes.BUY_LINK_PARAM_SRC_FIELD.getAttributeName() + i, buyLinkParamSrcFields.get(i));
                continue;
            }
            catch (SQLException s) {
                this.log.error((Object)("Could not insert entry for index " + i + ": buyLinkCollectionIds-" + buyLinkCollectionIds.get(i) + " buyLinkParamNames-" + buyLinkParamNames.get(i) + " buyLinkParamSrcFields-" + buyLinkParamSrcFields.get(i)), (Throwable)s);
            }
        }
        this.repopulateAppConfig();
    }

    @Override
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfigurationInstance;
    }

    @Override
    public void startMaintenance() throws Exception {
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }

    public static enum ConfigurationAttributes {
        PUBLIC_CONTENT_URL_PREFIX("publicContentUrl"),
        DISTRIBUTED_CONTENT_IDENTITY_PREFIX("dcid"),
        DISTRIBUTED_CONTENT_PASSWORD_PREFIX("dcpw"),
        BUY_LINK_PARAM_NAME("buyLinkParamName"),
        BUY_LINK_PARAM_SRC_FIELD("buyLinkParamSrcField"),
        BUY_LINK_COLLECTION_ID("buyLinkCollectionId"),
        BUY_BUTTON_COLLECTION_ID("buyButtonCollectionId"),
        BUY_BUTTON_CUSTOM_TEXT("buyButtonCustomText"),
        BUY_LINK_BASE_URL("buyLinkBaseUrl"),
        BUY_BUTTON_BASE_URL("buyButtonBaseUrl"),
        META_KEYWORDS_PREFIX("metaKeywords"),
        META_DESCRIPTION_PREFIX("metaDescription"),
        THUMB_FACET_LABEL_PREFIX("thumbnailFacetLabel"),
        OAI_ORDERED_STANDARD_NAME("oaiOrderedStandardName"),
        OAI_ORDERED_DC_FIELD("oaiOrderedDCField"),
        OAI_ORDERED_STANDARD_FIELDS("oaiOrderedStandardFields");

        protected String attributeName;

        private ConfigurationAttributes(String attributeName) {
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }
    }
}

