/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.jdbc;

import com.luna.insight.server.SimpleDate;
import com.lunaimaging.insight.core.dao.AnnotationDao;
import com.lunaimaging.insight.core.dao.jdbc.JdbcBaseDao;
import com.lunaimaging.insight.core.domain.Annotation;
import com.lunaimaging.insight.core.domain.AnnotationHistory;
import com.lunaimaging.insight.core.domain.MediaCollection;
import com.lunaimaging.insight.core.domain.User;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.domain.search.SearchCriteria;
import com.lunaimaging.insight.core.utils.InsightCoreUtils;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.CollectionUtils;

public class JdbcAnnotationDao
extends JdbcBaseDao
implements AnnotationDao,
Maintainable {
    protected int maximumAnnotationCache = 5000000;
    protected LRUCache annotationsCache = new LRUCache();
    protected LRUCache annotationIdCache = new LRUCache();
    private boolean initialized = false;
    protected List<MediaCollection> allMediaCollections;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void setMaximumAnnotationCache(int maximumAnnotationCache) {
        this.maximumAnnotationCache = maximumAnnotationCache;
    }

    @Override
    public List<Annotation> getAnnotations(String mid, int mgid) throws DataAccessException {
        return this.getAnnotations(mid, mgid, 0);
    }

    public int getAnnotationCount(String mid, int mgid) throws DataAccessException {
        return this.getAnnotationCount(mid, mgid, 0);
    }

    public List<Annotation> getAnnotations(String mid, int mgid, int userId, Integer offset, Integer limit) {
        return this.getAnnotations(mid, mgid, userId, null, null, offset, limit);
    }

    public List<Annotation> getAnnotations(String mid, Integer offset, Integer limit) throws DataAccessException {
        boolean firstEntry = true;
        String idFieldName = "mediaId";
        if (this.validateUri(mid)) {
            idFieldName = "canvasUri";
        }
        Annotation antt = new Annotation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(antt.getClass()).getTableName());
        query.append(" WHERE " + idFieldName + " IN ( ");
        query.append("'" + mid + "'");
        query.append(" )");
        if (offset != null || limit != null) {
            query.append(" LIMIT ");
            if (offset != null) {
                query.append(offset);
                if (limit != null) {
                    query.append(",");
                }
            }
            if (limit != null) {
                query.append(limit);
            }
        }
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(Annotation.class));
            if (searchResult != null && limit != null) {
                for (Annotation a : searchResult) {
                    this.loadHistory(a);
                }
            }
            return searchResult;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this mediaa", (Throwable)e);
        }
    }

    public List<Annotation> getAnnotations(String mid, int mgid, int userId, Integer xPos, Integer yPos, Integer offset, Integer limit) {
        boolean firstEntry = true;
        String idFieldName = "mediaId";
        if (this.validateUri(mid)) {
            idFieldName = "canvasUri";
        }
        Annotation antt = new Annotation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(antt.getClass()).getTableName());
        String concat = firstEntry ? " WHERE " : " AND ";
        query.append(concat + "( " + idFieldName + " IN ( ");
        query.append("'" + mid + "'");
        query.append(" ) ) ");
        if (xPos != null && yPos != null) {
            query.append("AND (");
            query.append("XPOS = " + xPos + " AND ");
            query.append("YPOS = " + yPos + ")");
        }
        query.append("AND (");
        query.append("( mgid = 0 )");
        if (mgid > 0) {
            query.append(" OR ( mgid = " + mgid + ")");
        }
        if (userId > 0) {
            query.append(" OR ( userId = " + userId + " AND mgid < 0 )");
        }
        query.append(")");
        if (offset != null || limit != null) {
            query.append(" LIMIT ");
            if (offset != null) {
                query.append(offset);
                if (limit != null) {
                    query.append(",");
                }
            }
            if (limit != null) {
                query.append(limit);
            }
        }
        this.log.debug((Object)("getAnnotations(..) query = " + query));
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(Annotation.class));
            if (searchResult != null && limit != null) {
                for (Annotation a : searchResult) {
                    this.loadHistory(a);
                }
            }
            return searchResult;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this mediaa", (Throwable)e);
        }
    }

    public List<Annotation> getAnnotations(Integer xPos, Integer yPos, Integer fWidth, Integer fHeight, String mid) {
        boolean firstEntry = true;
        Annotation antt = new Annotation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(antt.getClass()).getTableName());
        String concat = firstEntry ? " WHERE " : " AND ";
        query.append(concat + "( mediaId IN ( ");
        query.append("'" + mid + "'");
        query.append(" ) ");
        if (xPos != null && yPos != null) {
            query.append("AND (");
            query.append("XPOS = " + xPos + " AND ");
            query.append("YPOS = " + yPos + ")");
        }
        if (fWidth != null && fHeight != null) {
            query.append("AND (");
            query.append("fWidth = " + fWidth + " AND ");
            query.append("fHeight = " + fHeight + ")");
        }
        query.append(")");
        this.log.debug((Object)("getAnnotations(..) query = " + query));
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(Annotation.class));
            return searchResult;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this media", (Throwable)e);
        }
    }

    public List<String> getUniqueLegacyValues(String mid) throws DataAccessException {
        Annotation antt = new Annotation();
        AnnotationHistory ah = new AnnotationHistory();
        StringBuilder query = new StringBuilder("SELECT DISTINCT ANNOTATION FROM " + this.getMetadataBean(antt.getClass()).getTableName() + " A LEFT JOIN " + this.getMetadataBean(ah.getClass()).getTableName() + " H ON A.ID = H.ANNOTATIONID WHERE MEDIAID = '" + mid + "' AND H.VALUE IS NULL");
        try {
            List values = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new ColumnListHandler(1));
            this.logger.debug("Found " + values == null ? Integer.valueOf(0) : values.size() + " unique values");
            return values;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve distinct legacy values for " + mid, (Throwable)e);
        }
    }

    public List<String> getUniqueValuesByCreatorName(String mid, String creatorName) throws DataAccessException {
        Annotation antt = new Annotation();
        AnnotationHistory ah = new AnnotationHistory();
        StringBuilder query = new StringBuilder("SELECT DISTINCT VALUE FROM " + this.getMetadataBean(antt.getClass()).getTableName() + " A INNER JOIN " + this.getMetadataBean(ah.getClass()).getTableName() + " H ON A.ID = H.ANNOTATIONID WHERE MEDIAID = '" + mid + "' AND CREATORNAME = '" + creatorName + "'");
        try {
            List values = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new ColumnListHandler(1));
            this.logger.debug("Found " + values == null ? Integer.valueOf(0) : values.size() + " unique values");
            return values;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve distinct values for " + mid + " creator: " + creatorName, (Throwable)e);
        }
    }

    public List<String> getUniqueUserCorrectionValues(String mid) throws DataAccessException {
        Annotation antt = new Annotation();
        AnnotationHistory ah = new AnnotationHistory();
        StringBuilder query = new StringBuilder("SELECT DISTINCT VALUE FROM " + this.getMetadataBean(antt.getClass()).getTableName() + " A INNER JOIN " + this.getMetadataBean(ah.getClass()).getTableName() + " H ON A.ID = H.ANNOTATIONID  WHERE MEDIAID = '" + mid + "' AND CREATORTYPE = 'Person' AND A.annotation = H.value");
        try {
            List values = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new ColumnListHandler(1));
            this.logger.debug("Found " + values == null ? Integer.valueOf(0) : values.size() + " unique values");
            return values;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve distinct user corrected values for " + mid, (Throwable)e);
        }
    }

    public int getAnnotationCount(String mid) throws DataAccessException {
        boolean firstEntry = true;
        Annotation antt = new Annotation();
        StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM " + this.getMetadataBean(antt.getClass()).getTableName());
        query.append(" WHERE mediaId IN ( ");
        query.append("'" + mid + "'");
        query.append(" )");
        try {
            Object searchResult = this.constructObject((CharSequence)query, (ResultSetHandler)new ScalarHandler(1));
            return Integer.parseInt(searchResult.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this media", (Throwable)e);
        }
    }

    public int getAnnotationCount(String mid, int mgid, int userId) throws DataAccessException {
        boolean firstEntry = true;
        Annotation antt = new Annotation();
        StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM " + this.getMetadataBean(antt.getClass()).getTableName());
        String concat = firstEntry ? " WHERE " : " AND ";
        query.append(concat + " ( mediaId IN ( ");
        query.append("'" + mid + "'");
        query.append(" ) ) ");
        query.append("AND (");
        query.append("( mgid = 0 )");
        if (mgid > 0) {
            query.append(" OR ( mgid = " + mgid + ")");
        }
        if (userId > 0) {
            query.append(" OR ( userId = " + userId + " AND mgid < 0 )");
        }
        query.append(")");
        try {
            Object searchResult = this.constructObject((CharSequence)query, (ResultSetHandler)new ScalarHandler(1));
            return Integer.parseInt(searchResult.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this media", (Throwable)e);
        }
    }

    public List<Annotation> getAllAnnotations() {
        return (List)this.annotationIdCache.getAll();
    }

    public List<Annotation> getAnnotations(User user) throws DataAccessException {
        ArrayList<Annotation> toReturn = new ArrayList<Annotation>();
        try {
            List ma;
            if (user != null && (ma = (List)this.constructObjects(Annotation.class, "userId", user.getId())) != null) {
                toReturn.addAll(ma);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotation for user: " + user, (Throwable)e);
        }
        return toReturn;
    }

    public Annotation getAnnotation(int id) throws DataAccessException {
        Annotation a = null;
        try {
            a = (Annotation)this.annotationIdCache.get(id);
            if (a == null) {
                a = (Annotation)this.constructObject(Annotation.class, id);
                if (a != null) {
                    this.loadHistory(a);
                }
                if (a != null) {
                    this.addToCaches(a);
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve getAnnotation!", (Throwable)e);
        }
        return a;
    }

    @Override
    public List<Annotation> getAnnotations(List<Integer> ids) throws DataAccessException {
        ArrayList<Annotation> toReturn = new ArrayList<Annotation>();
        ArrayList<Integer> notInCacheList = new ArrayList<Integer>();
        for (int i = 0; i < ids.size(); ++i) {
            Annotation a = null;
            a = (Annotation)this.annotationIdCache.get(ids.get(i));
            if (a == null) {
                notInCacheList.add(ids.get(i));
                continue;
            }
            toReturn.add(a);
        }
        if (!notInCacheList.isEmpty()) {
            StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(Annotation.class).getTableName());
            query.append(" WHERE ID IN ( ");
            query.append(StringUtils.join(notInCacheList, (String)","));
            query.append(" )");
            try {
                List annotNotInCacheList = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(Annotation.class));
                for (Annotation anno : annotNotInCacheList) {
                    this.addToCaches(anno);
                    toReturn.add(anno);
                }
            }
            catch (SQLException e) {
                throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this mediaa", (Throwable)e);
            }
        }
        return toReturn;
    }

    public List<Annotation> getAnnotations(SearchCriteria annotationSearchCriteria, User user) {
        Annotation a = new Annotation();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.getMetadataBean(a.getClass()).getTableName() + " WHERE ");
        ArrayList<User> uList = annotationSearchCriteria.getUsers();
        boolean addAnd = false;
        if (user != null || uList != null) {
            query.append(" (userId IN ( ");
            String userIdAppendPrefix = "";
            for (User u : uList) {
                query.append(userIdAppendPrefix + u.getId());
                userIdAppendPrefix = ", ";
            }
            query.append(" ) ) ");
            addAnd = true;
        }
        if (!annotationSearchCriteria.getSearchText().trim().equals("")) {
            if (addAnd) {
                query.append(" AND ");
            }
            addAnd = true;
            query.append(" ( ");
            query.append(" ( annotation LIKE '%" + this.escapeForSql(annotationSearchCriteria.getSearchText().trim()) + "%' ");
            query.append(" ) ) ");
        }
        if (!annotationSearchCriteria.isIncludeLocked()) {
            if (addAnd) {
                query.append(" AND ");
            }
            query.append(" (password IS NULL OR password = '') ");
        }
        query.append(" ORDER BY annotation ");
        try {
            List searchResult = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new BeanListHandler(Annotation.class));
            return searchResult;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this annotationSearchCriteria", (Throwable)e);
        }
    }

    public int saveAnnotation(Annotation a) throws DataAccessException {
        long startTime = System.currentTimeMillis();
        try {
            List<AnnotationHistory> histListUpdated;
            Annotation updatedAnnot = a;
            this.saveObject(a);
            List<AnnotationHistory> histListExisting = this.getHistory(a);
            if (histListExisting == null) {
                histListExisting = new ArrayList<AnnotationHistory>();
            }
            if ((histListUpdated = updatedAnnot.getHistory()) == null) {
                histListUpdated = new ArrayList<AnnotationHistory>();
            }
            List histListToDelete = org.apache.commons.collections.ListUtils.subtract(histListExisting, histListUpdated);
            List histListToAdd = org.apache.commons.collections.ListUtils.subtract(histListUpdated, histListExisting);
            if (histListToAdd != null) {
                SimpleDate now = new SimpleDate(new Date());
                for (AnnotationHistory h : histListToAdd) {
                    if (h.getAnnotationId() == 0) {
                        h.setAnnotationId(a.getId());
                    }
                    h.setModifiedTimestamp(now.toString());
                    this.saveObject(h);
                }
            }
            if (histListToDelete != null) {
                for (AnnotationHistory h : histListToDelete) {
                    this.deleteObject(h);
                }
            }
            if (a.getId() > 0) {
                this.addToCaches(a);
                return a.getId();
            }
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            throw new DataAccessResourceFailureException("Unable to save newly created annotation", (Throwable)e);
        }
        this.log.debug((Object)("db save time: " + (System.currentTimeMillis() - startTime) + "ms"));
        return -1;
    }

    public List<Annotation> saveAnnotationBatch(List<Annotation> annotList, String mediaId, String source) throws DataAccessException {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return null;
        }
        List<Annotation> dbAnnots = null;
        ArrayList historyList = new ArrayList();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            if (annotList != null && annotList.size() > 0) {
                HashMap<Integer, List<AnnotationHistory>> annotHistMap = new HashMap<Integer, List<AnnotationHistory>>();
                int seqNo = 0;
                for (Annotation annot : annotList) {
                    annotHistMap.put(++seqNo, annot.getHistory());
                    annot.setSeqno(seqNo);
                }
                this.batchInsert(annotList);
                dbAnnots = this.getAnnotations(mediaId, null, null);
                for (Annotation a : dbAnnots) {
                    List histList;
                    if (!StringUtils.equals((CharSequence)a.getSource(), (CharSequence)source) || (histList = (List)annotHistMap.get(a.getSeqno())) == null) continue;
                    for (AnnotationHistory hist : histList) {
                        hist.setAnnotationId(a.getId());
                    }
                    historyList.addAll(histList);
                }
                if (historyList.size() > 0) {
                    this.batchInsert(historyList);
                }
            } else {
                this.log.debug((Object)"No annotations to save");
            }
        }
        catch (SQLException e) {
            this.log.error((Object)"Unable to save newly created annotation", (Throwable)e);
            throw new DataAccessResourceFailureException("Unable to save newly created annotation", (Throwable)e);
        }
        stopWatch.stop();
        this.log.debug((Object)("db save time: " + stopWatch.getTime() + "ms"));
        return dbAnnots;
    }

    protected void updateCache(Annotation s) {
    }

    public void deleteAnnotation(Annotation annot) throws DataAccessException {
        try {
            this.removeFromCaches(annot);
            this.deleteObject(annot);
            this.deleteObjects(AnnotationHistory.class, "annotationId", annot.getId());
        }
        catch (SQLException e) {
            this.log.info((Object)("Trouble deleting annotation: " + annot), (Throwable)e);
            throw new DataAccessResourceFailureException("Trouble deleting annotation: " + annot, (Throwable)e);
        }
        catch (Exception e) {
            this.log.info((Object)"Error: ", (Throwable)e);
            throw new DataAccessResourceFailureException("Trouble deleting annotation: ", (Throwable)e);
        }
    }

    public List<AnnotationHistory> deleteAnnotationHistory(List<Integer> annotIdToDelete, boolean keepManualEdits) throws SQLException {
        if (annotIdToDelete == null) {
            return null;
        }
        List idLists = ListUtils.partition(annotIdToDelete, (int)10000);
        ArrayList<AnnotationHistory> remainingHistList = new ArrayList<AnnotationHistory>();
        for (List delList : idLists) {
            try {
                String commaDelimitedString = delList.stream().map(Object::toString).collect(Collectors.joining(","));
                String deleteHistoryQuery = "DELETE FROM " + this.getMetadataBean(AnnotationHistory.class).getTableName() + " WHERE ANNOTATIONID IN (" + commaDelimitedString + ")";
                if (keepManualEdits) {
                    deleteHistoryQuery = deleteHistoryQuery + " AND CREATORTYPE <> 'Person'";
                }
                this.doUpdateOrSimpleInsert(deleteHistoryQuery);
                String remainingHistoryQuery = "SELECT * FROM " + this.getMetadataBean(AnnotationHistory.class).getTableName() + " WHERE ANNOTATIONID IN (" + commaDelimitedString + ")";
                List remainingHistory = (List)this.constructObjects(AnnotationHistory.class, remainingHistoryQuery);
                if (remainingHistory == null) continue;
                remainingHistList.addAll(remainingHistory);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error deleting annotation history", (Throwable)e);
            }
        }
        return remainingHistList;
    }

    @Override
    public void deleteAnnotationsBySource(String mediaId, String source) throws DataAccessException {
        this.deleteAnnotationsBySource(mediaId, source, true);
    }

    public void deleteAnnotationsBySource(String mediaId, String source, boolean keepManualEdits) throws DataAccessException {
        if (mediaId == null || source == null) {
            return;
        }
        List<AnnotationHistory> histNotDeletedList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("mediaId", mediaId);
            params.put("source", source);
            long startTime = System.currentTimeMillis();
            Collection annots = this.constructObjects(Annotation.class, params);
            if (annots != null) {
                ArrayList<Integer> annotIdList = new ArrayList<Integer>();
                for (Annotation annot : annots) {
                    annotIdList.add(annot.getId());
                }
                histNotDeletedList = this.deleteAnnotationHistory(annotIdList, keepManualEdits);
            }
            this.log.info((Object)("Time in deleting history for annotations in mediaId: " + mediaId + " " + (System.currentTimeMillis() - startTime) + "ms"));
            startTime = System.currentTimeMillis();
            if (histNotDeletedList != null && histNotDeletedList.size() > 0) {
                HashSet<Integer> annotIdSet = new HashSet<Integer>();
                for (AnnotationHistory h : histNotDeletedList) {
                    annotIdSet.add(h.getAnnotationId());
                }
                String commaDelimitedString = annotIdSet.stream().map(Object::toString).collect(Collectors.joining(","));
                String deleteQuery = "DELETE FROM " + this.getMetadataBean(Annotation.class).getTableName() + " WHERE MEDIAID='" + mediaId + "' AND SOURCE= '" + source + "' AND ID NOT IN (" + commaDelimitedString + ")";
                this.doUpdateOrSimpleInsert(deleteQuery);
                String updateQuery = "UPDATE " + this.getMetadataBean(Annotation.class).getTableName() + " SET SEQNO=0 WHERE ID IN (" + commaDelimitedString + ")";
                this.doUpdateOrSimpleInsert(updateQuery);
            } else {
                this.deleteObjects(Annotation.class, params);
            }
            this.log.info((Object)("Time in deleting annotations in mediaId: " + mediaId + " " + (System.currentTimeMillis() - startTime) + "ms"));
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Unable to delete annotations", (Throwable)e);
        }
    }

    public synchronized void initialize() throws SQLException {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Cache(s)");
            this.initializeAnnotations();
            this.initialized = true;
        }
    }

    public synchronized void purgeCollectionAnnotation(String collectionId) {
        try {
            this.initializeAnnotations();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        List<Object> annotations = new ArrayList();
        annotations = this.getAllAnnotations();
        Iterator<Object> iter = annotations.iterator();
        while (iter.hasNext()) {
            Annotation annot = (Annotation)iter.next();
            if (!InsightCoreUtils.getCollectionIdFromLunaMediaId(annot.getMediaId()).equals(collectionId)) continue;
            this.deleteAnnotation(annot);
            iter.remove();
        }
    }

    private void initializeAnnotations() throws SQLException, ClassCastException {
        this.log.debug((Object)"Creating new annotations cache");
        this.annotationsCache = new LRUCache(this.maximumAnnotationCache);
        this.annotationIdCache = new LRUCache(this.maximumAnnotationCache);
        Collection allAnnotations = this.getAllObjects(Annotation.class, this.annotationsCache.getMaximumSize());
        if (!CollectionUtils.isEmpty((Collection)allAnnotations)) {
            for (Annotation a : allAnnotations) {
                this.addToCaches(a);
            }
        }
        this.log.debug((Object)("Completed annotations cache: " + this.annotationsCache.size()));
        this.log.debug((Object)("Completed annotation ID cache: " + this.annotationIdCache.size()));
    }

    public synchronized void addToCaches(Annotation annot) {
        ArrayList<Annotation> list = (ArrayList<Annotation>)this.annotationsCache.get(annot.getMediaId());
        if (list == null) {
            list = new ArrayList<Annotation>();
            this.annotationsCache.put(annot.getMediaId(), list);
        }
        Iterator itA = list.iterator();
        while (itA.hasNext()) {
            Annotation a = (Annotation)itA.next();
            if (a.getId() != annot.getId()) continue;
            itA.remove();
        }
        list.add(annot);
        this.annotationIdCache.put(annot.getId(), annot);
    }

    public synchronized void removeFromCaches(Annotation annot) {
        List list = (List)this.annotationsCache.get(annot.getMediaId());
        if (list != null) {
            Iterator itList = list.iterator();
            while (itList.hasNext()) {
                Annotation a = (Annotation)itList.next();
                if (a.getId() != annot.getId()) continue;
                itList.remove();
                break;
            }
        }
        this.annotationIdCache.remove(annot.getId());
    }

    @Override
    public List<String> getAnnotatedMediaByCollectionId(String collectionId) throws DataAccessException {
        ArrayList<String> mediaIdList = new ArrayList();
        StringBuilder query = new StringBuilder("SELECT mediaId FROM " + this.getMetadataBean(Annotation.class).getTableName());
        query.append(" WHERE mediaId like '");
        query.append(collectionId + "~%");
        query.append("' group by mediaid");
        try {
            mediaIdList = (List)this.constructObject((CharSequence)query, (ResultSetHandler)new ColumnListHandler("mediaId"));
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Unexpected error, unable to retrieve annotations for this mediaa", (Throwable)e);
        }
        return mediaIdList;
    }

    public void loadHistory(Annotation a) {
        try {
            List ah = (List)this.constructObjects(AnnotationHistory.class, "annotationId", a.getId());
            if (ah != null && ah.size() > 0) {
                a.setHistory(ah);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error((Object)("No annotation history for id=" + a.getId()), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("No annotation history for id=" + a.getId()), (Throwable)e);
        }
    }

    private List<AnnotationHistory> getHistory(Annotation a) {
        try {
            return (List)this.constructObjects(AnnotationHistory.class, "annotationId", a.getId());
        }
        catch (SQLException e) {
            this.logger.error((Object)("No annotation history for id=" + a.getId()), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)("No annotation history for id=" + a.getId()), (Throwable)e);
        }
        return null;
    }

    public int getTotalAnnotation() {
        return this.annotationIdCache.size();
    }

    @Override
    public void startMaintenance() throws Exception {
        this.annotationsCache.purge();
        this.annotationIdCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }

    public int getMaximumAnnotationCache() {
        return this.maximumAnnotationCache;
    }

    private boolean validateUri(String uri) {
        URL url;
        try {
            url = new URL(uri);
        }
        catch (Exception e1) {
            return false;
        }
        return "http".equals(url.getProtocol()) || "https".equals(url.getProtocol());
    }
}

