/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.javax;

import com.lunaimaging.insight.core.dao.SendEmailDao;
import com.lunaimaging.insight.core.dao.exceptions.EmailFailureException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;

public class JavaxSendEmailDao
implements SendEmailDao {
    protected static Authenticator auth = null;
    protected static Log log = LogFactory.getLog(JavaxSendEmailDao.class);
    protected int smtpPort = 25;
    protected String smtpHost;
    protected String smtpUser;
    protected String smtpPassword;
    protected String emailFromAddress;
    protected String emailTemplateDir;
    protected String ccOnRegistration;
    protected boolean enableTsl = false;
    protected int sslPort = 0;

    private void initializeMail() {
        if (StringUtils.isNotEmpty((String)this.smtpUser) && StringUtils.isNotEmpty((String)this.smtpPassword)) {
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(JavaxSendEmailDao.this.smtpUser, JavaxSendEmailDao.this.smtpPassword);
                }
            };
        }
    }

    @Override
    public void sendForgotPassword(String userEmail, String firstName, String newPassword) throws DataAccessException {
        Properties replaceVars = new Properties();
        replaceVars.setProperty("FIRST_NAME", firstName);
        replaceVars.setProperty("PASSWORD", newPassword);
        this.send(this.emailFromAddress, userEmail, Template.PASSWORD_RESET, replaceVars);
    }

    @Override
    public void sendNewRegistrationEmail(String userEmail, String username) throws DataAccessException {
        Properties replaceVars = new Properties();
        replaceVars.setProperty("USERNAME", username);
        this.send(this.emailFromAddress, userEmail, Template.NEW_REGISTRATION, replaceVars);
    }

    private void send(String from, String to, Template template, Properties replaceVars) throws DataAccessException {
        String messageSubject = "";
        StringBuffer messageBody = new StringBuffer(100);
        boolean messageBodyStarted = false;
        InputStreamReader reader = null;
        BufferedReader lnReader = null;
        try {
            reader = new FileReader(System.getProperty("staticResourcePath") + this.emailTemplateDir + template.getFilename());
            lnReader = new LineNumberReader(reader);
            String line = ((LineNumberReader)lnReader).readLine();
            while (line != null) {
                if (line.toUpperCase().startsWith("SUBJECT: ")) {
                    messageSubject = this.replaceText(line.substring(9), replaceVars);
                } else if (messageBodyStarted || line.trim().length() != 0) {
                    messageBodyStarted = true;
                    messageBody.append(line);
                    messageBody.append("\r\n");
                }
                line = ((LineNumberReader)lnReader).readLine();
            }
            String content = this.replaceText(messageBody.toString(), replaceVars);
            this.send(from, to, messageSubject, content);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EmailFailureException("Unexpected IO error reading email template: " + this.emailTemplateDir + template.getFilename(), e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (lnReader != null) {
                    lnReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void send(String from, String to, String subject, String content) throws DataAccessException {
        try {
            Properties systemProps = System.getProperties();
            systemProps.put("mail.smtp.host", this.smtpHost);
            systemProps.put("mail.smtp.port", (Object)this.smtpPort);
            Session session = null;
            if (auth != null) {
                systemProps.put("mail.smtp.auth", "true");
                session = Session.getDefaultInstance((Properties)systemProps, (Authenticator)auth);
            } else {
                systemProps.put("mail.smtp.auth", "false");
                session = Session.getDefaultInstance((Properties)systemProps);
            }
            if (this.enableTsl) {
                systemProps.put("mail.smtp.starttls.enable", "true");
            }
            if (this.sslPort > 0) {
                systemProps.put("mail.smtp.socketFactory.port", (Object)this.sslPort);
                systemProps.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                systemProps.put("mail.smtp.socketFactory.fallback", "false");
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            if (this.ccOnRegistration != null && this.ccOnRegistration.length() > 0) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.ccOnRegistration));
            }
            message.setSubject(subject);
            message.setText(content);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EmailFailureException("There was an unexpected error sending email", e);
        }
    }

    private String replaceText(String content, Properties replaceVars) {
        String newContent = content;
        for (Object key : replaceVars.keySet()) {
            newContent = newContent.replaceAll("\\$" + (String)key, Matcher.quoteReplacement(replaceVars.getProperty((String)key)));
        }
        return newContent;
    }

    public void setEmailFromAddress(String emailFromAddress) {
        this.emailFromAddress = emailFromAddress;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setEmailTemplateDir(String emailTemplateDir) {
        this.emailTemplateDir = emailTemplateDir;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
        this.initializeMail();
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
        this.initializeMail();
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getCcOnRegistration() {
        return this.ccOnRegistration;
    }

    public void setCcOnRegistration(String cc) {
        this.ccOnRegistration = cc;
    }

    public boolean getEnableTsl() {
        return this.enableTsl;
    }

    public void setEnableTsl(boolean b) {
        this.enableTsl = b;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public void setSslPort(int port) {
        this.sslPort = port;
    }

    private static enum Template {
        PASSWORD_RESET("password_reset.txt"),
        NEW_REGISTRATION("new_registration.txt");

        private String template;

        private Template(String in) {
            this.template = in;
        }

        public String getFilename() {
            return this.template;
        }
    }
}

