/*
 * Decompiled with CFR 0.152.
 */
package com.lunaimaging.insight.core.dao.http;

import com.lunaimaging.inscribe.domain.PublishEntity;
import com.lunaimaging.inscribe.domain.SharedSchema;
import com.lunaimaging.insight.core.domain.ActivityResult;
import com.lunaimaging.insight.core.domain.cache.LRUCache;
import com.lunaimaging.insight.core.domain.logic.Maintainable;
import com.lunaimaging.insight.core.http.LibraryHttpAdapter;
import com.lunaimaging.orion.editor.domain.Schema;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryHttpDao
implements Maintainable {
    protected Log log = LogFactory.getLog(this.getClass());
    private LibraryHttpAdapter libraryHttpAdapter;
    protected int maxCacheSize = 5000;
    protected LRUCache pageLastIdCache = new LRUCache();
    private boolean initialized = false;

    @Override
    public void startMaintenance() throws Exception {
        this.pageLastIdCache.purge();
        this.initialized = false;
    }

    @Override
    public void endMaintenance() throws Exception {
        this.initialize();
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            this.log.debug((Object)"initializing Cache(s)");
            this.initializeLibraryCache();
            this.initialized = true;
        }
    }

    public void initializeLibraryCache() {
        this.pageLastIdCache = new LRUCache(this.maxCacheSize);
    }

    private String getKey(List<String> collectionIds, int pageNo, int pageSize) {
        String SEP = ":";
        String key = pageNo + SEP + pageSize;
        if (collectionIds != null) {
            for (String cid : collectionIds) {
                key = key + cid;
            }
        }
        return key;
    }

    public ActivityResult getPublishEntities(List<String> collectionIds, int pageNo, int pageSize) {
        long startTime = System.currentTimeMillis();
        this.libraryHttpAdapter.login();
        List<PublishEntity> entities = null;
        int lowestId = -1;
        ActivityResult ar = null;
        if (this.pageLastIdCache.contains(this.getKey(collectionIds, pageNo + 1, pageSize))) {
            ar = this.libraryHttpAdapter.getPublishEntitiesBeforeLastId(collectionIds, (Integer)this.pageLastIdCache.get(this.getKey(collectionIds, pageNo + 1, pageSize)), pageSize);
            entities = ar.getEntities();
        } else {
            ar = this.libraryHttpAdapter.getPublishEntities(collectionIds, pageNo, pageSize);
            entities = ar.getEntities();
        }
        if (!this.pageLastIdCache.contains(this.getKey(collectionIds, pageNo, pageSize))) {
            if (entities != null && entities.size() > 0) {
                lowestId = entities.get(0).getId();
            }
            if (lowestId > 0) {
                this.pageLastIdCache.put(this.getKey(collectionIds, pageNo, pageSize), lowestId);
            }
        }
        System.out.println("LibraryHttpDao time elapsed: " + (System.currentTimeMillis() - startTime) + "ms");
        return ar;
    }

    public int getLastActivityPageNo(List<String> collectionIds, int pageSize) {
        this.libraryHttpAdapter.login();
        return this.libraryHttpAdapter.getLastActivityPageNo(collectionIds, pageSize);
    }

    public int getActivityTotal(List<String> collectionIds) {
        this.libraryHttpAdapter.login();
        return this.libraryHttpAdapter.getTotal(collectionIds);
    }

    public Schema getSchema(String collectionId) {
        this.libraryHttpAdapter.login();
        return this.libraryHttpAdapter.getSchema(collectionId);
    }

    public SharedSchema getSharedSchema(String collectionId) {
        this.libraryHttpAdapter.login();
        return this.libraryHttpAdapter.getSharedSchema(collectionId);
    }

    public void setLibraryHttpAdapter(LibraryHttpAdapter libraryHttpAdapter) {
        this.libraryHttpAdapter = libraryHttpAdapter;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }
}

