/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.outputListeners;

import com.zerog.ia.download.dialogs.ProgressDialog;
import com.zerog.ia.download.downloaders.ZGDownloader;
import com.zerog.ia.download.outputListeners.DownloadListener;
import java.util.Date;

public class GUIDownloadListener
implements DownloadListener {
    ProgressDialog pd;
    long totalBytesInFile;
    long bytesDownloaded;
    ZGDownloader download;
    private ProgressDialog progressDialog = null;
    StringBuffer log = new StringBuffer(800);
    String friendlyErrorMessage;

    public GUIDownloadListener(ZGDownloader _download, ProgressDialog progressDialog) {
        this.download = _download;
        this.progressDialog = progressDialog;
        this.log.append("Date:  " + new Date().toString() + "\n");
        this.log.append("Java Vendor:  " + System.getProperty("java.vendor") + "\n");
        this.log.append("URL:  " + System.getProperty("java.vendor.url") + "\n");
        this.log.append("Java Version:  " + System.getProperty("java.version") + "\n");
        this.log.append("Java Class Version:  " + System.getProperty("java.class.version") + "\n");
        this.log.append("OS Name:  " + System.getProperty("os.name") + "\n");
        this.log.append("OS Architecture:  " + System.getProperty("os.arch") + "\n");
        this.log.append("OS Version:  " + System.getProperty("os.version") + "\n");
        this.log.append("---------------------------------\n");
    }

    public void downloadStarted(String _filename) {
        this.progressDialog.setPercentDone(0);
        this.progressDialog.setProgressDialogText(1, this.download.getContext().getProductName(), this.download.getFileDestination().toString());
        this.progressDialog.addObserver(this.download);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void downloadCompleted() {
    }

    public void downloadCancelled() {
        if (this.progressDialog != null) {
            this.progressDialog.hide();
            this.progressDialog.dispose();
            this.progressDialog.deleteObserver(this.download);
        }
        this.log.append("Download cancelled.\n");
    }

    public void setTotalNumberOfBytesInFile(long _totalBytesInFile) {
        this.totalBytesInFile = _totalBytesInFile;
    }

    public void setBytesInFileDownloaded(long _bytesDownloaded) {
        this.bytesDownloaded = _bytesDownloaded;
        this.progressDialog.setPercentDone((int)(_bytesDownloaded * 100L / this.totalBytesInFile));
    }

    public void errorOccured() {
        if (this.progressDialog != null) {
            this.progressDialog.hide();
        }
    }
}

