/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util;

import com.zerog.common.java.lang.StringUtil;
import com.zerog.util.FileEncoding;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ZGProperties
extends Properties {
    protected ZGProperties defaults;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public ZGProperties() {
        this((ZGProperties)null);
    }

    public ZGProperties(ZGProperties defaults) {
        this.defaults = defaults;
    }

    public synchronized Object setProperty(String key, String value) {
        return ((Hashtable)this).put(key, value);
    }

    public synchronized void load(Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            int valueIndex;
            int separatorIndex;
            int keyStart;
            char firstChar;
            if (line.length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.continueLine(line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = new String("");
                }
                String loppedLine = line.substring(0, line.length() - 1);
                int startIndex = 0;
                for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
            }
            int len = line.length();
            for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            if (keyStart == len) continue;
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (keyValueSeparators.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            ((Hashtable)this).put(key, ZGUtilCopy.decodeExternalProperty(value));
        }
        return;
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.load(FileEncoding.instance().getIAFileReader(inStream));
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(ZGProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(ZGProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(ZGProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(ZGProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public synchronized void save(OutputStream out, String header) {
        try {
            this.store(out, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream out, String header, boolean convert) throws IOException {
        try {
            this.store(new OutputStreamWriter(out, "UTF-8"), header, convert);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        try {
            this.store(new OutputStreamWriter(out, "UTF-8"), header, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(Writer out, String header, boolean convert) throws IOException {
        Object outKey = null;
        Object outVal = null;
        PrintWriter awriter = new PrintWriter(out);
        if (header != null) {
            awriter.println("#" + header);
        }
        awriter.println("#" + new Date().toString());
        Enumeration e = ((Hashtable)this).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)((Hashtable)this).get(key);
            awriter.println(key + "=" + StringUtil.convertFromEscapedUnicode(val));
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    public String getProperty(String key) {
        Object oval = super.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Enumeration propertyNames() {
        Hashtable h = new Hashtable();
        this.enumerate(h);
        return h.keys();
    }

    public void list(PrintStream out) {
        out.println("-- listing properties --");
        Hashtable h = new Hashtable();
        this.enumerate(h);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)h.get(key);
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Hashtable h = new Hashtable();
        this.enumerate(h);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)h.get(key);
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    private synchronized void enumerate(Hashtable h) {
        if (this.defaults != null) {
            this.defaults.enumerate(h);
        }
        Enumeration e = ((Hashtable)this).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            h.put(key, ((Hashtable)this).get(key));
        }
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public void mergeProperties(Properties child) {
        Enumeration keys = ((Hashtable)child).keys();
        while (keys.hasMoreElements()) {
            String cur = (String)keys.nextElement();
            this.setProperty(cur, (String)((Hashtable)child).get(cur));
        }
    }

    static class ZGUtilCopy {
        ZGUtilCopy() {
        }

        private static String decodeExternalProperty(String in) {
            StringBuffer out = null;
            int slashLoc = 0;
            int len = in.length();
            int lastWritten = 0;
            boolean done = false;
            while (!done && (slashLoc = in.indexOf("\\", slashLoc)) != -1) {
                if (slashLoc >= len - 1) {
                    done = true;
                    continue;
                }
                if (out == null) {
                    out = new StringBuffer(len);
                }
                out.append(in.substring(lastWritten, slashLoc));
                lastWritten = slashLoc + 2;
                switch (in.charAt(slashLoc + 1)) {
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case '\"': {
                        out.append("\"");
                        break;
                    }
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case 'u': {
                        int characterOffset = 0;
                        char currentChar = '\u0000';
                        int i = slashLoc + 2;
                        int formedUnicodeCharacter = 0;
                        for (int j = 0; j < 4 && i < len; ++i, ++j) {
                            currentChar = in.charAt(i);
                            characterOffset = ZGUtilCopy.getOffset(currentChar);
                            if (characterOffset == -1) {
                                out.append("\\u");
                                while (j > 0) {
                                    out.append(in.charAt(i - j));
                                    --j;
                                }
                                formedUnicodeCharacter = -1;
                                break;
                            }
                            formedUnicodeCharacter = (formedUnicodeCharacter << 4) + currentChar - characterOffset;
                        }
                        if (formedUnicodeCharacter != -1) {
                            out.append((char)formedUnicodeCharacter);
                        }
                        lastWritten = slashLoc + 6;
                    }
                }
                slashLoc += 2;
            }
            if (lastWritten <= len && out != null) {
                out.append(in.substring(lastWritten, len));
            }
            return out == null ? in : out.toString();
        }

        private static int getOffset(int c) {
            if (c >= 48 && c <= 57) {
                return 48;
            }
            if (c >= 65 && c <= 70) {
                return 55;
            }
            if (c >= 97 && c <= 102) {
                return 87;
            }
            return -1;
        }
    }
}

