/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.error;

import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sqlj.runtime.error.Errors;

public class RuntimeRefErrors
extends Errors {
    private static final String RESOURCE_NAME = "sqlj.runtime.error.RuntimeRefErrorsText";
    private static ResourceBundle m_bundle = null;
    public static final String PROFILE_NOT_FOUND = "RTR-0001";
    public static final String NO_ROW_SELECT_INTO = "RTR-0002";
    public static final String MULTI_ROW_SELECT_INTO = "RTR-0003";
    public static final String WRONG_NUM_COLS = "RTR-0004";
    public static final String NULL_CONN_CTX = "RTR-0008";
    public static final String NULL_EXEC_CTX = "RTR-0009";
    public static final String NULL_CONNECTION = "RTR-0010";
    public static final String NULL_DEFAULT_CONN_CTX = "RTR-0011";

    public static void raise_PROFILE_NOT_FOUND(String string, Exception exception) throws SQLException {
        Errors.raiseError("46130", m_bundle, PROFILE_NOT_FOUND, string, exception.toString());
    }

    public static void raise_NO_ROW_SELECT_INTO() throws SQLException {
        throw new SQLException(Errors.getText(m_bundle, NO_ROW_SELECT_INTO), "02000", 100);
    }

    public static void raise_MULTI_ROW_SELECT_INTO() throws SQLException {
        throw new SQLException(Errors.getText(m_bundle, MULTI_ROW_SELECT_INTO), "21000", -811);
    }

    public static void raise_WRONG_NUM_COLS(int n2, int n3) throws SQLException {
        Errors.raiseError("42122", m_bundle, WRONG_NUM_COLS, new Integer(n2), new Integer(n3));
    }

    public static void raise_NULL_CONN_CTX() throws SQLException {
        Errors.raiseError("08003", m_bundle, NULL_CONN_CTX);
    }

    public static void raise_NULL_EXEC_CTX() throws SQLException {
        Errors.raiseError("08000", m_bundle, NULL_EXEC_CTX);
    }

    public static void raise_NULL_CONNECTION() throws SQLException {
        Errors.raiseError("08000", m_bundle, NULL_CONNECTION);
    }

    public static void raise_NULL_DEFAULT_CONN_CTX() throws SQLException {
        Errors.raiseError("08003", m_bundle, NULL_DEFAULT_CONN_CTX);
    }

    static {
        try {
            m_bundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

