/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2ConnectionInfo;
import com.ibm.db2.jcc.DB2PooledConnection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

class DB2ConnectionPoolManager
implements ConnectionEventListener {
    private DB2ConnectionInfo[] connectionList = new DB2ConnectionInfo[1024];
    private int numConnections = 0;
    private int lastEntryChecked = -1;

    DB2ConnectionPoolManager() {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        DB2PooledConnection dB2PooledConnection = (DB2PooledConnection)connectionEvent.getSource();
        int n2 = dB2PooledConnection.getID();
        if (n2 == 0) {
            this.connectionList[this.numConnections] = new DB2ConnectionInfo();
            this.connectionList[this.numConnections].setPooledConnection(dB2PooledConnection);
            ++this.numConnections;
            dB2PooledConnection.setID(this.numConnections);
        } else {
            this.connectionList[n2 - 1].setAvailable(true);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        DB2PooledConnection dB2PooledConnection = (DB2PooledConnection)connectionEvent.getSource();
        int n2 = dB2PooledConnection.getID();
        if (n2 != 0) {
            this.connectionList[n2 - 1].setValid(false);
        }
        try {
            dB2PooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    PooledConnection lookup(String string, String string2) {
        PooledConnection pooledConnection = null;
        int n2 = this.lastEntryChecked + 1;
        pooledConnection = this.searchList(n2, this.numConnections, string, string2);
        if (pooledConnection == null) {
            pooledConnection = this.searchList(0, n2, string, string2);
        }
        return pooledConnection;
    }

    PooledConnection searchList(int n2, int n3, String string, String string2) {
        DB2ConnectionInfo dB2ConnectionInfo = null;
        DB2PooledConnection dB2PooledConnection = null;
        if (null == string) {
            string = "";
        }
        if (null == string2) {
            string2 = "";
        }
        int n4 = n2;
        while (n4 < n3) {
            this.lastEntryChecked = n4;
            dB2ConnectionInfo = this.connectionList[n4];
            if (dB2ConnectionInfo.isAvailable() && dB2ConnectionInfo.isValid()) {
                dB2PooledConnection = (DB2PooledConnection)dB2ConnectionInfo.getPooledConnection();
                if (string.equals(dB2PooledConnection.getUser()) && string2.equals(dB2PooledConnection.getPassword())) {
                    dB2ConnectionInfo.setAvailable(false);
                    break;
                }
                dB2PooledConnection = null;
            }
            ++n4;
        }
        return dB2PooledConnection;
    }

    void clear() throws SQLException {
        DB2ConnectionInfo dB2ConnectionInfo = null;
        int n2 = 0;
        while (n2 < this.numConnections) {
            dB2ConnectionInfo = this.connectionList[n2];
            if (dB2ConnectionInfo.isValid()) {
                dB2ConnectionInfo.getPooledConnection().close();
            }
            ++n2;
        }
    }
}

