/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.sqlj;

import com.ibm.db2.jcc.sqlj.d;
import com.ibm.db2.jcc.sqlj.k;
import com.ibm.db2.jcc.sqlj.l;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Date;
import java.util.Enumeration;
import java.util.Properties;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;

public class ProfilePrinter
extends sqlj.runtime.profile.util.ProfilePrinter {
    public PrintWriter a = null;

    public void print(ProfileData profileData) {
        int n2 = profileData.size();
        this.a.println("original source file: " + profileData.getSourceFile());
        this.a.println("contains " + n2 + " entries");
        this.a.println("===================================================");
        int n3 = 0;
        while (n3 < n2) {
            this.print(profileData, n3);
            this.a.println("===================================================");
            ++n3;
        }
        if (profileData instanceof l) {
            try {
                this.a.println(((l)profileData).b());
            }
            catch (IOException iOException) {
                this.a.println("IOException, failed to print entire ProfileData.");
                iOException.printStackTrace(this.a);
            }
        }
    }

    public void print(ProfileData profileData, int n2) {
        EntryInfo entryInfo = profileData.getEntryInfo(n2);
        this.a.println("profile " + profileData.getProfile().getProfileName() + " entry " + n2);
        this.a.println("#sql { " + entryInfo.getSQLString() + " };");
        this.a.println("line number: " + entryInfo.getLineNumber());
        this.a.println(EntryInfo.statementTypeToString(entryInfo.getStatementType()) + " executed via " + EntryInfo.executeTypeToString(entryInfo.getExecuteType()));
        this.a.println("role is " + EntryInfo.roleToString(entryInfo.getRole()));
        this.a.println("descriptor is " + entryInfo.getDescriptor());
        int n3 = entryInfo.getParamCount();
        this.a.println("contains " + n3 + " parameters");
        int n4 = 1;
        while (n4 <= n3) {
            this.print(profileData, entryInfo.getParamInfo(n4), n4);
            ++n4;
        }
        this.a.println("result set type is " + EntryInfo.resultSetTypeToString(entryInfo.getResultSetType()));
        this.a.println("result set name is " + entryInfo.getResultSetName());
        int n5 = entryInfo.getResultSetCount();
        this.a.println("contains " + n5 + " result columns");
        int n6 = 1;
        while (n6 <= n5) {
            this.print(profileData, entryInfo.getResultSetInfo(n6), n6);
            ++n6;
        }
        if (entryInfo instanceof k) {
            this.a.println(((k)entryInfo).l());
        }
    }

    public static void main(String[] stringArray) {
        try {
            ProfilePrinter.printMain(stringArray, new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            System.out.println("Error initializing PrintWriter output");
        }
    }

    public static void printMain(String[] stringArray, PrintWriter printWriter) {
        if (stringArray.length != 1) {
            ProfilePrinter.a(printWriter);
            return;
        }
        try {
            ProfilePrinter profilePrinter = new ProfilePrinter();
            profilePrinter.a = printWriter;
            Profile profile = null;
            if (stringArray[0].endsWith(".ser")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                profile = Profile.instantiate(null, fileInputStream);
            } else {
                profile = Profile.instantiate(null, stringArray[0]);
            }
            profilePrinter.print(profile);
        }
        catch (Exception exception) {
            printWriter.println("error:  exception while loading profile " + stringArray[0] + ":");
            printWriter.println(exception);
        }
    }

    public void print(Profile profile) {
        this.a.println("===================================================");
        this.a.println("printing contents of profile " + profile.getProfileName());
        this.a.println("created " + profile.getTimestamp() + " (" + new Date(profile.getTimestamp()) + ")");
        this.a.println("associated context is " + profile.getContextName());
        this.a.println("profile loader is " + profile.getLoader());
        int n2 = 0;
        Enumeration enumeration = profile.getCustomizations();
        while (enumeration.hasMoreElements()) {
            ++n2;
            enumeration.nextElement();
        }
        this.a.println("contains " + n2 + " customizations");
        boolean bl2 = false;
        Enumeration enumeration2 = profile.getCustomizations();
        while (enumeration2.hasMoreElements()) {
            Object e2 = enumeration2.nextElement();
            this.a.println(e2);
            if (!(e2 instanceof d)) continue;
            this.print(((d)e2).a());
            bl2 = true;
        }
        if (!bl2) {
            this.print(profile.getProfileData());
        }
    }

    private static void a(PrintWriter printWriter) {
        printWriter.println("");
        printWriter.println("(c) Copyright IBM Corporation 2001");
        printWriter.println("            ");
        printWriter.println("Usage: db2sqljprint profileName[.ser]");
        printWriter.println("            ");
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        String string = new String();
        while (enumeration.hasMoreElements() && !string.equalsIgnoreCase("java.vendor")) {
            string = (String)enumeration.nextElement();
        }
        String string2 = properties.getProperty(string).toLowerCase();
        if (string2 == null) {
            printWriter.println("       db2sqljprint  = java com.ibm.db2.jcc.sqlj.ProfilePrinter");
        } else if (string2.indexOf("microsoft") != -1) {
            printWriter.println("       db2sqljprint  = jview com.ibm.db2.jcc.sqlj.ProfilePrinter");
        } else {
            printWriter.println("       db2sqljprint  = java com.ibm.db2.jcc.sqlj.ProfilePrinter");
        }
        printWriter.println("");
    }
}

