/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.b.g;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public abstract class DB2Binder {
    private static Set traceLevelOptions__;
    static /* synthetic */ Class class$com$ibm$db2$jcc$DB2BaseDataSource;

    public static void main(String[] stringArray) throws Exception {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        String string = null;
        String string2 = null;
        String string3 = null;
        int n2 = 3;
        String string4 = "NULLID";
        int n3 = 0;
        if (stringArray.length == 0) {
            DB2Binder.printUsage(printWriter);
            return;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string5;
            if ((string5 = stringArray[n4++]).equals("-help")) {
                DB2Binder.printUsage(printWriter);
                continue;
            }
            if (string5.equals("-url")) {
                string = stringArray[n4++];
                continue;
            }
            if (string5.equals("-user")) {
                string2 = stringArray[n4++];
                continue;
            }
            if (string5.equals("-password")) {
                string3 = stringArray[n4++];
                continue;
            }
            if (string5.equals("-size")) {
                n2 = Integer.parseInt(stringArray[n4++]);
                continue;
            }
            if (string5.equals("-collection")) {
                string4 = stringArray[n4++];
                continue;
            }
            if (string5.equals("-tracelevel")) {
                try {
                    n3 = DB2Binder.parseTraceLevel(stringArray[n4++]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printWriter.println(illegalArgumentException.getMessage());
                    DB2Binder.printUsage(printWriter);
                    return;
                }
            }
            printWriter.println("Unrecognized option " + string5);
            DB2Binder.printUsage(printWriter);
            return;
        }
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            printWriter.println("Failure loading JDBC driver com.ibm.db2.jcc.DB2Driver.");
            printWriter.println("ClassNotFoundException: " + classNotFoundException.getMessage());
            return;
        }
        DB2Binder.binderMain(printWriter, string, string2, string3, n2, string4, n3);
    }

    public static void binderMain(PrintWriter printWriter, String string, String string2, String string3, int n2, String string4, int n3) {
        if (string == null) {
            printWriter.println("A url was not provided - binder can not proceed.");
            DB2Binder.printUsage(printWriter);
            return;
        }
        if (string2 == null) {
            printWriter.println("A user was not provided - binder can not proceed.");
            DB2Binder.printUsage(printWriter);
            return;
        }
        if (string3 == null) {
            printWriter.println("A password was not provided - binder can not proceed.");
            DB2Binder.printUsage(printWriter);
            return;
        }
        g.a(printWriter, string, string2, string3, n2, string4, n3);
    }

    private static void printUsage(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println();
        printWriter.println("IBM DB2 JDBC Universal Driver Architecture, JDBC Package Binder");
        printWriter.println("(c) Copyright IBM Corporation 2002");
        printWriter.println();
        printWriter.println("This binder utility is used to add the standard JCC JDBC packageset to the target database URL.");
        printWriter.println("The latest version of the JCC JDBC packageset will be bound to the server.");
        printWriter.println();
        printWriter.println("Usage:");
        printWriter.println();
        printWriter.println("  java com.ibm.db2.jcc.DB2Binder");
        printWriter.println("    -url jdbc:db2://<server name>:<port number>/<database name>");
        printWriter.println("    -user <userName>");
        printWriter.println("    -password <password>");
        printWriter.println("    [-size <number of dynamic JCC packages bound for each isolation and holdability>]");
        printWriter.println("    [-collection <current JCC packageset>]");
        printWriter.println("    [-tracelevel <comma-delimited list of jcc trace options>]");
        printWriter.println("    [-help]");
        printWriter.println();
        printWriter.println("  -user");
        printWriter.println("    The user must have bind authority.");
        printWriter.println("    Access to the JCC packages will be granted to public.");
        printWriter.println();
        printWriter.println("  -size");
        printWriter.println("    The number of internal JCC packages to bind for each DB2 isolation and holdability.");
        printWriter.println("    The default is 3.");
        printWriter.println("    Since there are 4 DB2 transaction isolations and 2 cursor holdabilities,");
        printWriter.println("    there will be 4x2=8 times as many dynamic packages bound as are specified by this option.");
        printWriter.println("    In addition, a single static package for JCC's internal use is always bound.");
        printWriter.println();
        printWriter.println("  -collection");
        printWriter.println("    The collection ID, aka CURRENT PACKAGESET, to use for JCC's internal packages.");
        printWriter.println("    The default is NULLID.");
        printWriter.println("    May be used by DBA's to create multiple instances of the JCC package set.");
        printWriter.println("    This option may only be used in conjunction with the connection/datasource property currentPackageSet.");
        printWriter.println("    Also see documentation for JCC DB2BaseDataSource.currentPackageSet.");
        printWriter.println();
        printWriter.println("  -tracelevel");
        printWriter.println("    Used to turn tracing on or off, and to specify the granularity of tracing.");
        printWriter.println("    Trace level options are defined by the JCC JDBC driver traceLevel data source property.");
        printWriter.println("    See documentation for JCC DB2BaseDataSource.traceLevel for a complete description.");
        printWriter.println("    For complete tracing, use TRACE_ALL.  Not all of the JCC JDBC trace level options");
        printWriter.println("    are meaningful for DB2Binder, but the complete options are: ");
        if (traceLevelOptions__ == null) {
            DB2Binder.reflectTraceLevelOptions();
        }
        Iterator iterator = traceLevelOptions__.iterator();
        printWriter.print(iterator.next());
        while (iterator.hasNext()) {
            printWriter.print("," + iterator.next());
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("Note: There is currently only one version of the JCC JDBC packageset.");
        printWriter.println("      So the current syntax does not allow for adding or dropping specific versions");
        printWriter.println("      of the JCC JDBC packageset.  This syntax could be extended at a later date to support this");
        printWriter.println("      if and when the contents of the JCC JDBC packageset definition changes.");
        printWriter.println();
        printWriter.println("Note: If the latest version of the JCC JDBC packageset is already bound to the server,");
        printWriter.println("      then this operation is a no-op, and the bind request will be rejected by the");
        printWriter.println("      following DB2 target servers: OS/390 v6-8, Unix/Windows UDB v8.");
        printWriter.println("      If the latest JCC JDBC packageset is already bound to the server, the bind request will");
        printWriter.println("      be accepted by a Unix/Windows UDB v7 server, but the pre-existing JCC JDBC packageset of");
        printWriter.println("      the same version will be replaced.  Since JCC JDBC packagesets with the same version");
        printWriter.println("      are identical this replacement operation is effectively a no-op.  However, an");
        printWriter.println("      exclusive lock on the packageset is required to prevent this non-operation from blocking.");
        printWriter.println("      The behavior against Unix/Windows UDB v7 server is due to a DRDA limitation on that server.");
        printWriter.println();
        printWriter.println();
    }

    private static void reflectTraceLevelOptions() {
        traceLevelOptions__ = new TreeSet();
        Class clazz = class$com$ibm$db2$jcc$DB2BaseDataSource == null ? (class$com$ibm$db2$jcc$DB2BaseDataSource = DB2Binder.class$("com.ibm.db2.jcc.DB2BaseDataSource")) : class$com$ibm$db2$jcc$DB2BaseDataSource;
        Field[] fieldArray = clazz.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            String string = fieldArray[n2].getName();
            if (string.startsWith("TRACE_")) {
                traceLevelOptions__.add(string);
            }
            ++n2;
        }
    }

    public static int parseTraceLevel(String string) throws IllegalArgumentException {
        String string2 = string.toUpperCase();
        if (traceLevelOptions__ == null) {
            DB2Binder.reflectTraceLevelOptions();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = null;
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            string3 = (String)stringTokenizer.nextElement();
            if (traceLevelOptions__.contains(string3)) {
                Class clazz = class$com$ibm$db2$jcc$DB2BaseDataSource == null ? DB2Binder.class$("com.ibm.db2.jcc.DB2BaseDataSource") : class$com$ibm$db2$jcc$DB2BaseDataSource;
                try {
                    Field field = clazz.getDeclaredField(string3);
                    n2 |= field.getInt(null);
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalArgumentException("bug check: NoSuchFieldException shouldn't happen");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("bug check: IllegalAccessException shouldn't happen");
                }
            }
            throw new IllegalArgumentException("Unsupported tracelevel: " + string3);
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

