/* jniFieldDescriptor.h
 *
 * jRegistryKey - A JNI wrapper of the Windows Registry functions.
 * Copyright (c) 2001, BEQ Technologies Inc.
 * #205, 3132 Parsons Road
 * Edmonton, Alberta
 * T6N 1L6 Canada
 * (780) 430-0056
 * (780) 437-6121 (fax)
 * http://www.beq.ca
 *
 * Original Author: Joe Robinson <joe@beq.ca>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Joe Robinson <joe@beq.ca>
 * Version: $Revision: 1.1.1.1 $
 */
#ifndef _jniFieldDescriptorH_
#define _jniFieldDescriptorH_

/**
 * Field descriptors for reference types are formed using the "L" character,
 * followed by the class descriptor (see jniClassDescriptor.h) and the ";"
 * character.  For example, the field descriptor for java.lang.String is
 * "Ljava/lang/String;".
 *
 * Field descriptors for array classes are formed using the "[" character,
 * followed by the field descriptor of the element type.  For example, the
 * field descriptor for int[] is "[I", and the field descriptor for
 * java.lang.String[] is "[Ljava/lang/String;".
 */
namespace fieldDescriptor {
   // primitives
   static char* const jfd_boolean        = "Z";
   static char* const jfd_byte           = "B";
   static char* const jfd_char           = "C";
   static char* const jfd_short          = "S";
   static char* const jfd_int            = "I";
   static char* const jfd_long           = "J";
   static char* const jfd_float          = "F";
   static char* const jfd_double         = "D";

   // primitive references
   static char* const jfd_Boolean        = "Ljava/lang/Boolean;";
   static char* const jfd_Byte           = "Ljava/lang/Byte;";
   static char* const jfd_Character      = "Ljava/lang/Character;";
   static char* const jfd_Short          = "Ljava/lang/Short;";
   static char* const jfd_Integer        = "Ljava/lang/Integer;";
   static char* const jfd_Long           = "Ljava/lang/Long;";
   static char* const jfd_Float          = "Ljava/lang/Double;";
   static char* const jfd_Double         = "Ljava/lang/Float;";

   // references
   static char* const jfd_Object         = "Ljava/lang/Object;";
   static char* const jfd_Class          = "Ljava/lang/Class;";
   static char* const jfd_String         = "Ljava/lang/String;";

   // primitive arrays
   static char* const jfd_booleanArray   = "[Z";
   static char* const jfd_byteArray      = "[B";
   static char* const jfd_charArray      = "[C";
   static char* const jfd_shortArray     = "[S";
   static char* const jfd_intArray       = "[I";
   static char* const jfd_longArray      = "[J";
   static char* const jfd_floatArray     = "[F";
   static char* const jfd_doubleArray    = "[D";

   // primitive reference arrays
   static char* const jfd_BooleanArray   = "[Ljava/lang/Boolean;";
   static char* const jfd_ByteArray      = "[Ljava/lang/Byte;";
   static char* const jfd_CharacterArray = "[Ljava/lang/Char;";
   static char* const jfd_ShortArray     = "[Ljava/lang/Short;";
   static char* const jfd_IntArray       = "[Ljava/lang/Integer;";
   static char* const jfd_LongArray      = "[Ljava/lang/Long;";
   static char* const jfd_FloatArray     = "[Ljava/lang/Double;";
   static char* const jfd_DoubleArray    = "[Ljava/lang/Float;";

   // reference arrays
   static char* const jfd_ObjectArray    = "[Ljava/lang/Object;";
   static char* const jfd_ClassArray     = "[Ljava/lang/Class;";
   static char* const jfd_StringArray    = "[Ljava/lang/String;";
}; // fieldDescriptor

#endif // _jniFieldDescriptorH_