/* jRegistryKey.h
 *
 * jRegistryKey - A JNI wrapper of the Windows Registry functions.
 * Copyright (c) 2001, BEQ Technologies Inc.
 * #205, 3132 Parsons Road
 * Edmonton, Alberta
 * T6N 1L6 Canada
 * (780) 430-0056
 * (780) 437-6121 (fax)
 * http://www.beq.ca
 *
 * Original Author: Joe Robinson <joe@beq.ca>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Joe Robinson <joe@beq.ca>
 * Version: $Revision: 1.1.1.1 $
 *
 * $Log: jRegistryKey.h,v $
 * Revision 1.1.1.1  2001/10/25 14:58:36  joe.robinson
 * Added project to CVS
 *
 */
#ifndef _jRegistryKeyH_
#define _jRegistryKeyH_

#include "jni.h"

/**
 * jRegistryKey.h provides a wrapper for the class and field descriptors of the
 * classes used in the ca.beq.util.win32.registry package.
 */
namespace registryDescriptor {
   static char* const jcd_KeyIterator        = "ca/beq/util/win32/registry/KeyIterator";
   static char* const jcd_RegistryException  = "ca/beq/util/win32/registry/RegistryException";
   static char* const jcd_RegistryKey        = "ca/beq/util/win32/registry/RegistryKey";
   static char* const jcd_RegistryValue      = "ca/beq/util/win32/registry/RegistryValue";
   static char* const jcd_RootKey            = "ca/beq/util/win32/registry/RootKey";
   static char* const jcd_ValueIterator      = "ca/beq/util/win32/registry/ValueIterator";
   static char* const jcd_ValueType          = "ca/beq/util/win32/registry/ValueType";

   static char* const jfd_KeyIterator        = "Lca/beq/util/win32/registry/KeyIterator;";
   static char* const jfd_RegistryException  = "Lca/beq/util/win32/registry/RegistryException;";
   static char* const jfd_RegistryKey        = "Lca/beq/util/win32/registry/RegistryKey;";
   static char* const jfd_RegistryValue      = "Lca/beq/util/win32/registry/RegistryValue;";
   static char* const jfd_RootKey            = "Lca/beq/util/win32/registry/RootKey;";
   static char* const jfd_ValueIterator      = "Lca/beq/util/win32/registry/ValueIterator;";
   static char* const jfd_ValueType          = "Lca/beq/util/win32/registry/ValueType;";
}; // registryDescriptor

#endif // _jRegistryKeyH_