/* RegistryException.java
 *
 * jRegistryKey - A JNI wrapper of the Windows Registry functions.
 * Copyright (c) 2001, BEQ Technologies Inc.
 * #205, 3132 Parsons Road
 * Edmonton, Alberta
 * T6N 1L6 Canada
 * (780) 430-0056
 * (780) 437-6121 (fax)
 * http://www.beq.ca
 *
 * Original Author: Joe Robinson <joe@beq.ca>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package ca.beq.util.win32.registry;

/**
 * <code>RegistryException</code> signals that a registry operation has failed.
 *
 * @see java.lang.RuntimeException
 *
 * @author BEQ Technologies Inc.
 * @version 1.0
 */
public class RegistryException extends RuntimeException {
   /**
    * Constructs a new <code>RegistryException</code> with no detail message.
    */
   public RegistryException() {
   } // RegistryException()

   /**
    * Constructs a new <code>RegistryException</code> with the specified detail
    * message.
    *
    * @param msg the detail message.
    */
   public RegistryException(String msg) {
      super(msg);
   } // RegistryException()
} // RegistryException
