/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.pvcs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.optional.pvcs.PvcsProject;
import org.apache.tools.ant.types.Commandline;

public class Pvcs
extends Task {
    private String pvcsbin = null;
    private String repository = null;
    private String pvcsProject = null;
    private Vector pvcsProjects = new Vector();
    private String workspace = null;
    private String force = null;
    private String promotiongroup = null;
    private String label = null;
    private boolean ignorerc = false;
    private boolean updateOnly = false;
    private static final String PCLI_EXE = "pcli";
    private static final String PCLI_LVF_ARGS = "lvf -z -aw";
    private static final String GET_EXE = "get";

    protected int runCmd(Commandline cmd, ExecuteStreamHandler out) {
        try {
            Project aProj = this.getProject();
            Execute exe = new Execute(out);
            exe.setAntRun(aProj);
            exe.setWorkingDirectory(aProj.getBaseDir());
            exe.setCommandline(cmd.getCommandline());
            return exe.execute();
        }
        catch (IOException e) {
            String msg = "Failed executing: " + cmd.toString() + ". Exception: " + e.getMessage();
            throw new BuildException(msg, this.location);
        }
    }

    private String getExecutable(String exe) {
        StringBuffer correctedExe = new StringBuffer();
        if (this.getPvcsbin() != null) {
            if (this.pvcsbin.endsWith(File.separator)) {
                correctedExe.append(this.pvcsbin);
            } else {
                correctedExe.append(this.pvcsbin).append(File.separator);
            }
        }
        return correctedExe.append(exe).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Project aProj = this.getProject();
        int result = 0;
        if (this.repository == null) throw new BuildException("Required argument repository not specified");
        if (this.repository.trim().equals("")) {
            throw new BuildException("Required argument repository not specified");
        }
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getExecutable(PCLI_EXE));
        commandLine.createArgument().setValue("lvf");
        commandLine.createArgument().setValue("-z");
        commandLine.createArgument().setValue("-aw");
        if (this.getWorkspace() != null) {
            commandLine.createArgument().setValue("-sp" + this.getWorkspace());
        }
        commandLine.createArgument().setValue("-pr" + this.getRepository());
        if (this.getPvcsproject() == null && this.getPvcsprojects().isEmpty()) {
            this.pvcsProject = "/";
        }
        if (this.getPvcsproject() != null) {
            commandLine.createArgument().setValue(this.getPvcsproject());
        }
        if (!this.getPvcsprojects().isEmpty()) {
            Enumeration e = this.getPvcsprojects().elements();
            while (e.hasMoreElements()) {
                String projectName = ((PvcsProject)e.nextElement()).getName();
                if (projectName == null) throw new BuildException("name is a required attribute of pvcsproject");
                if (projectName.trim().equals("")) {
                    throw new BuildException("name is a required attribute of pvcsproject");
                }
                commandLine.createArgument().setValue(projectName);
            }
        }
        File tmp = null;
        File tmp2 = null;
        try {
            try {
                Random rand = new Random(System.currentTimeMillis());
                tmp = new File("pvcs_ant_" + rand.nextLong() + ".log");
                tmp2 = new File("pvcs_ant_" + rand.nextLong() + ".log");
                this.log("Executing " + commandLine.toString(), 3);
                result = this.runCmd(commandLine, (ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new FileOutputStream(tmp), (OutputStream)new LogOutputStream((Task)this, 1)));
                if (result != 0 && !this.ignorerc) {
                    String msg = "Failed executing: " + commandLine.toString();
                    throw new BuildException(msg, this.location);
                }
                if (!tmp.exists()) {
                    throw new BuildException("Communication between ant and pvcs failed. No output generated from executing PVCS commandline interface \"pcli\" and \"get\"");
                }
                this.log("Creating folders", 2);
                this.createFolders(tmp);
                this.massagePCLI(tmp, tmp2);
                commandLine.clearArgs();
                commandLine.setExecutable(this.getExecutable(GET_EXE));
                if (this.getForce() != null && this.getForce().equals("yes")) {
                    commandLine.createArgument().setValue("-Y");
                } else {
                    commandLine.createArgument().setValue("-N");
                }
                if (this.getPromotiongroup() != null) {
                    commandLine.createArgument().setValue("-G" + this.getPromotiongroup());
                } else if (this.getLabel() != null) {
                    commandLine.createArgument().setValue("-r" + this.getLabel());
                }
                if (this.updateOnly) {
                    commandLine.createArgument().setValue("-U");
                }
                commandLine.createArgument().setValue("@" + tmp2.getAbsolutePath());
                this.log("Getting files", 2);
                this.log("Executing " + commandLine.toString(), 3);
                result = this.runCmd(commandLine, (ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
                if (result != 0 && !this.ignorerc) {
                    String msg = "Failed executing: " + commandLine.toString() + ". Return code was " + result;
                    throw new BuildException(msg, this.location);
                }
                Object var11_12 = null;
                if (tmp != null) {
                    tmp.delete();
                }
            }
            catch (FileNotFoundException e) {
                String msg = "Failed executing: " + commandLine.toString() + ". Exception: " + e.getMessage();
                throw new BuildException(msg, this.location);
            }
            catch (IOException e) {
                String msg = "Failed executing: " + commandLine.toString() + ". Exception: " + e.getMessage();
                throw new BuildException(msg, this.location);
            }
            catch (ParseException e) {
                String msg = "Failed executing: " + commandLine.toString() + ". Exception: " + e.getMessage();
                throw new BuildException(msg, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (tmp != null) {
                tmp.delete();
            }
            if (tmp2 == null) throw throwable;
            tmp2.delete();
            throw throwable;
        }
        if (tmp2 == null) return;
        tmp2.delete();
    }

    private void createFolders(File file) throws IOException, ParseException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        MessageFormat mf = new MessageFormat("{0}-arc({1})");
        String line = in.readLine();
        while (line != null) {
            this.log("Considering \"" + line + "\"", 3);
            if (line.startsWith("\"\\") || line.startsWith("\"/")) {
                Object[] objs = mf.parse(line);
                String f = (String)objs[1];
                int index = f.lastIndexOf(File.separator);
                if (index > -1) {
                    File dir = new File(f.substring(0, index));
                    if (!dir.exists()) {
                        this.log("Creating " + dir.getAbsolutePath(), 3);
                        if (dir.mkdirs()) {
                            this.log("Created " + dir.getAbsolutePath(), 2);
                        } else {
                            this.log("Failed to create " + dir.getAbsolutePath(), 2);
                        }
                    } else {
                        this.log(dir.getAbsolutePath() + " exists. Skipping", 3);
                    }
                } else {
                    this.log("File separator problem with " + line, 1);
                }
            } else {
                this.log("Skipped \"" + line + "\"", 3);
            }
            line = in.readLine();
        }
    }

    private void massagePCLI(File in, File out) throws FileNotFoundException, IOException {
        BufferedReader inReader = new BufferedReader(new FileReader(in));
        BufferedWriter outWriter = new BufferedWriter(new FileWriter(out));
        String s = null;
        while ((s = inReader.readLine()) != null) {
            String sNormal = s.replace('\\', '/');
            outWriter.write(sNormal);
            outWriter.newLine();
        }
        inReader.close();
        outWriter.close();
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repo) {
        this.repository = repo;
    }

    public String getPvcsproject() {
        return this.pvcsProject;
    }

    public void setPvcsproject(String prj) {
        this.pvcsProject = prj;
    }

    public Vector getPvcsprojects() {
        return this.pvcsProjects;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String ws) {
        this.workspace = ws;
    }

    public String getPvcsbin() {
        return this.pvcsbin;
    }

    public void setPvcsbin(String bin) {
        this.pvcsbin = bin;
    }

    public String getForce() {
        return this.force;
    }

    public void setForce(String f) {
        this.force = f != null && f.equalsIgnoreCase("yes") ? "yes" : "no";
    }

    public String getPromotiongroup() {
        return this.promotiongroup;
    }

    public void setPromotiongroup(String w) {
        this.promotiongroup = w;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public boolean getIgnoreReturnCode() {
        return this.ignorerc;
    }

    public void setIgnoreReturnCode(boolean b) {
        this.ignorerc = b;
    }

    public void addPvcsproject(PvcsProject p) {
        this.pvcsProjects.addElement(p);
    }

    public boolean getUpdateOnly() {
        return this.updateOnly;
    }

    public void setUpdateOnly(boolean l) {
        this.updateOnly = l;
    }
}

