/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.Project;
import com.ibm.ivj.util.base.ToolData;
import java.io.Serializable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ide.VAJAntToolGUI;
import org.apache.tools.ant.taskdefs.optional.ide.VAJBuildInfo;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;

public class VAJAntTool {
    private static final String TOOL_DATA_KEY = "AntTool";

    public static VAJBuildInfo loadBuildData(String projectName) {
        VAJBuildInfo result = null;
        try {
            Project project = VAJUtil.getWorkspace().loadedProjectNamed(projectName);
            if (project.testToolRepositoryData(TOOL_DATA_KEY)) {
                ToolData td = project.getToolRepositoryData(TOOL_DATA_KEY);
                String data = (String)((Object)td.getData());
                result = VAJBuildInfo.parse(data);
            } else {
                result = new VAJBuildInfo();
            }
            result.setVAJProjectName(projectName);
        }
        catch (Throwable t) {
            System.out.println("BuildInfo for Project " + projectName + " could not be loaded" + t);
            throw new BuildException(t);
        }
        return result;
    }

    public static void main(String[] args) {
        VAJBuildInfo info;
        if (args.length >= 2 && args[1] instanceof String) {
            String projectName = args[1];
            info = VAJAntTool.loadBuildData(projectName);
        } else {
            info = new VAJBuildInfo();
        }
        VAJAntToolGUI mainFrame = new VAJAntToolGUI(info);
        mainFrame.show();
    }

    public static void saveBuildData(VAJBuildInfo info) {
        String data = info.asDataString();
        try {
            ToolData td = new ToolData(TOOL_DATA_KEY, (Serializable)((Object)data));
            VAJUtil.getWorkspace().loadedProjectNamed(info.getVAJProjectName()).setToolRepositoryData(td);
        }
        catch (Throwable t) {
            throw new BuildException("BuildInfo for Project " + info.getVAJProjectName() + " could not be saved", t);
        }
    }
}

