/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.xml;

import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.MediaField;
import com.luna.insight.server.MediaMetaData;
import com.luna.insight.server.StringCriterionValue;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.VirtualCollectionInfo;
import com.luna.insight.server.xml.CollectionRequestHandler;
import com.luna.insight.server.xml.DataRequestHandler;
import com.luna.insight.server.xml.FieldRequestHandler;
import com.luna.insight.server.xml.GatewayConstants;
import com.luna.insight.server.xml.GatewayResultsProgressListener;
import com.luna.insight.server.xml.SearchRequestHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class InsightRequestHandler
implements GatewayConstants,
ContentHandler,
ErrorHandler {
    protected static int maxClientProxies = 10;
    protected static final Map fieldStandardsMap = new HashMap();
    protected static final Map thumbnailStandardsMap = new HashMap();
    protected static final Map sortStandardsMap = new HashMap();
    static final Map primaryGroupRecordCountMap = new HashMap();
    static final Map allowCollectionSortMaxMap = new HashMap();
    protected XMLReader reader = null;
    protected InputSource request = null;
    protected PrintWriter response = null;
    protected String username = null;
    protected String responseSystemID = null;
    protected String userServerAddress = null;
    protected StringBuffer responseBuffer = null;
    protected int indentLevel = 0;
    protected List openElementStack = new ArrayList();
    protected Map collectionMap = new HashMap();
    protected Locator locator = null;
    protected boolean parsingRequest = false;
    protected boolean haveDataCriterion = false;
    protected boolean haveKeywordCriterion = false;
    protected boolean listAllCollectionFields = true;
    protected int responseStatus = 7;
    protected Attributes fieldCollectionAttributes = null;
    protected SearchRequestAttributes searchRequestAttributes = null;
    protected DataRequestAttributes dataRequestAttributes = null;
    protected ListCollectionAttributes listCollectionAttributes = null;
    protected FieldRequestAttributes fieldRequestAttributes = null;
    protected List searchCollectionAttributes = new ArrayList();
    protected List returnResultInAttributes = new ArrayList();
    protected List searchSortFields = new ArrayList();
    protected List criteriaList = new ArrayList();
    protected List objectAttributes = new ArrayList();
    protected boolean useXSD = false;
    protected String nameSpace = "";

    public static void debugOut(String string) {
        InsightRequestHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightRequestHandler: " + string, n);
    }

    private InsightRequestHandler() {
    }

    public InsightRequestHandler(List list, String string, String string2, String string3, String string4) throws SAXException {
        this(list, string, string2, string3, string4, false);
    }

    public InsightRequestHandler(List list, String string, String string2, String string3, String string4, boolean bl) throws SAXException {
        this.reader = XMLReaderFactory.createXMLReader(string);
        if (bl) {
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
        } else {
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
        }
        this.reader.setContentHandler(this);
        this.reader.setErrorHandler(this);
        InsightRequestHandler.debugOut("Instantiated handler.  " + list.size() + " collections.");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)iterator.next();
            String string5 = this.getUniqueCollectionKey(trinityCollectionInfo);
            if (trinityCollectionInfo instanceof VirtualCollectionInfo && VirtualCollectionInfo.flattenSingleInfo(trinityCollectionInfo).size() > 1) {
                InsightRequestHandler.debugOut("\tIgnoring multi-collection virtual collection cid = " + string5, 1);
                continue;
            }
            this.collectionMap.put(string5, trinityCollectionInfo);
            InsightRequestHandler.debugOut("\tcid = " + string5);
        }
        this.username = string3;
        this.responseSystemID = string2;
        this.userServerAddress = string4;
        this.useXSD = bl;
    }

    public String getUniqueCollectionKey(TrinityCollectionInfo trinityCollectionInfo) {
        String string = trinityCollectionInfo.getCollectionID() + "::" + trinityCollectionInfo.getInstitutionID() + "::" + trinityCollectionInfo.getVCID();
        return string;
    }

    public int getRecordCount(String string, TrinityCollectionInfo trinityCollectionInfo, InsightSmartClient insightSmartClient) {
        return this.updatePrimaryGroupRecordCount(string, trinityCollectionInfo, insightSmartClient);
    }

    public static void setMaxClientProxies(int n) {
        InsightRequestHandler.debugOut("Setting maximum number of client proxies to: " + n, 1);
        maxClientProxies = n;
    }

    public String processRequest(String string) throws IOException, SAXException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        InputSource inputSource = new InputSource(new ByteArrayInputStream(string.getBytes()));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
        this.processRequest(inputSource, null, printWriter);
        printWriter.flush();
        String string2 = byteArrayOutputStream.toString("UTF-8");
        printWriter.close();
        this.response = null;
        this.responseBuffer = null;
        return string2.toString();
    }

    public StringBuffer processRequest(InputSource inputSource, String string) throws IOException, SAXException {
        this.processRequest(inputSource, string, null);
        StringBuffer stringBuffer = this.responseBuffer;
        this.responseBuffer = null;
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(InputSource inputSource, String string, PrintWriter printWriter) throws IOException, SAXException {
        long l;
        block11: {
            int n;
            l = System.currentTimeMillis();
            InsightRequestHandler.debugOut("processing request");
            this.request = inputSource;
            this.response = printWriter;
            boolean bl = false;
            this.responseBuffer = new StringBuffer();
            if (this.appendHeader()) {
                this.appendElement("insightResponse");
            }
            if (string != null && (n = string.indexOf("<" + (this.nameSpace != null ? this.nameSpace + ":" : "") + "insightRequest")) >= 0) {
                this.responseBuffer.append(string.substring(n));
            }
            this.flush();
            try {
                try {
                    this.reader.parse(inputSource);
                }
                catch (SAXParseException sAXParseException) {
                    this.closeElements("insightResponse", false);
                    this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(1)}, GatewayConstants.RESULT_MESSAGE[1] + sAXParseException.getMessage());
                    bl = true;
                    Object var9_10 = null;
                    if (!bl) {
                        this.closeElements("insightResponse", false);
                        this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(this.responseStatus)}, GatewayConstants.RESULT_MESSAGE[this.responseStatus]);
                    }
                    this.closeElements(-1);
                    this.flush();
                    this.locator = null;
                    this.request = null;
                    this.response = null;
                    this.indentLevel = 0;
                    this.openElementStack = new ArrayList();
                    this.parsingRequest = false;
                    this.haveDataCriterion = false;
                    this.haveKeywordCriterion = false;
                    this.listAllCollectionFields = true;
                    this.fieldCollectionAttributes = null;
                    this.searchRequestAttributes = null;
                    this.dataRequestAttributes = null;
                    this.fieldRequestAttributes = null;
                    this.listCollectionAttributes = null;
                    this.searchCollectionAttributes = new ArrayList();
                    this.returnResultInAttributes = new ArrayList();
                    this.criteriaList = new ArrayList();
                    this.searchSortFields = new ArrayList();
                    this.objectAttributes = new ArrayList();
                    this.responseStatus = 7;
                    InsightRequestHandler.debugOut("Time in processRequest: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "seconds.");
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    InsightRequestHandler.debugOut("Exception in InsightRequestHandler:", 1);
                    Debug.debugOut(exception, 1);
                    this.closeElements("insightResponse", false);
                    this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(2)}, GatewayConstants.RESULT_MESSAGE[2] + exception.toString());
                    bl = true;
                    Object var9_11 = null;
                    if (!bl) {
                        this.closeElements("insightResponse", false);
                        this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(this.responseStatus)}, GatewayConstants.RESULT_MESSAGE[this.responseStatus]);
                    }
                    this.closeElements(-1);
                    this.flush();
                    this.locator = null;
                    this.request = null;
                    this.response = null;
                    this.indentLevel = 0;
                    this.openElementStack = new ArrayList();
                    this.parsingRequest = false;
                    this.haveDataCriterion = false;
                    this.haveKeywordCriterion = false;
                    this.listAllCollectionFields = true;
                    this.fieldCollectionAttributes = null;
                    this.searchRequestAttributes = null;
                    this.dataRequestAttributes = null;
                    this.fieldRequestAttributes = null;
                    this.listCollectionAttributes = null;
                    this.searchCollectionAttributes = new ArrayList();
                    this.returnResultInAttributes = new ArrayList();
                    this.criteriaList = new ArrayList();
                    this.searchSortFields = new ArrayList();
                    this.objectAttributes = new ArrayList();
                    this.responseStatus = 7;
                    InsightRequestHandler.debugOut("Time in processRequest: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "seconds.");
                    return;
                }
                Object var9_9 = null;
                if (bl) break block11;
                this.closeElements("insightResponse", false);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (!bl) {
                    this.closeElements("insightResponse", false);
                    this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(this.responseStatus)}, GatewayConstants.RESULT_MESSAGE[this.responseStatus]);
                }
                this.closeElements(-1);
                this.flush();
                this.locator = null;
                this.request = null;
                this.response = null;
                this.indentLevel = 0;
                this.openElementStack = new ArrayList();
                this.parsingRequest = false;
                this.haveDataCriterion = false;
                this.haveKeywordCriterion = false;
                this.listAllCollectionFields = true;
                this.fieldCollectionAttributes = null;
                this.searchRequestAttributes = null;
                this.dataRequestAttributes = null;
                this.fieldRequestAttributes = null;
                this.listCollectionAttributes = null;
                this.searchCollectionAttributes = new ArrayList();
                this.returnResultInAttributes = new ArrayList();
                this.criteriaList = new ArrayList();
                this.searchSortFields = new ArrayList();
                this.objectAttributes = new ArrayList();
                this.responseStatus = 7;
                InsightRequestHandler.debugOut("Time in processRequest: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "seconds.");
                throw throwable;
            }
            this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(this.responseStatus)}, GatewayConstants.RESULT_MESSAGE[this.responseStatus]);
        }
        this.closeElements(-1);
        this.flush();
        this.locator = null;
        this.request = null;
        this.response = null;
        this.indentLevel = 0;
        this.openElementStack = new ArrayList();
        this.parsingRequest = false;
        this.haveDataCriterion = false;
        this.haveKeywordCriterion = false;
        this.listAllCollectionFields = true;
        this.fieldCollectionAttributes = null;
        this.searchRequestAttributes = null;
        this.dataRequestAttributes = null;
        this.fieldRequestAttributes = null;
        this.listCollectionAttributes = null;
        this.searchCollectionAttributes = new ArrayList();
        this.returnResultInAttributes = new ArrayList();
        this.criteriaList = new ArrayList();
        this.searchSortFields = new ArrayList();
        this.objectAttributes = new ArrayList();
        this.responseStatus = 7;
        InsightRequestHandler.debugOut("Time in processRequest: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "seconds.");
    }

    public void processErrorRequest(InputSource inputSource, String string, PrintWriter printWriter, String string2) throws IOException, SAXException {
        int n;
        long l = System.currentTimeMillis();
        InsightRequestHandler.debugOut("processing request");
        this.request = inputSource;
        this.response = printWriter;
        boolean bl = false;
        this.responseBuffer = new StringBuffer();
        if (this.appendHeader()) {
            this.appendElement("insightResponse");
        }
        if (string != null && (n = string.indexOf("<insightRequest")) >= 0) {
            this.responseBuffer.append(string.substring(n));
        }
        this.flush();
        this.closeElements("insightResponse", false);
        this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(2)}, GatewayConstants.RESULT_MESSAGE[2] + string2);
        bl = true;
        this.closeElements(-1);
        this.flush();
        InsightRequestHandler.debugOut("Time in processRequest: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "seconds.");
    }

    public void setInvalidXMLReplacement(String string) {
        InsightUtilities.setInvalidXMLReplacement(string);
    }

    public String getInvalidXMLReplacement() {
        return InsightUtilities.getInvalidXMLReplacement();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.criteriaList.size() > 0) {
            Criterion criterion = (Criterion)this.criteriaList.get(this.criteriaList.size() - 1);
            criterion.setValue(string);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        InsightRequestHandler.debugOut("Ending element: (" + string + ", " + string2 + ", " + string3 + ")", 3);
        if (string2.equals("collectionRequest") || string2.equals("fieldRequest") || string2.equals("searchRequest") || string2.equals("dataRequest")) {
            if (string2.equals("searchRequest")) {
                this.searchRequest();
            } else if (string2.equals("dataRequest")) {
                this.dataRequest();
            } else if (this.listAllCollectionFields && string2.equals("fieldRequest")) {
                Iterator iterator = this.collectionMap.keySet().iterator();
                while (iterator.hasNext()) {
                    this.fieldRequest((String)iterator.next(), this.fieldRequestAttributes.includePC);
                }
            }
            this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(this.responseStatus)}, GatewayConstants.RESULT_MESSAGE[this.responseStatus]);
        } else if (string2.equals("listCollections")) {
            this.collectionRequest();
        } else if (string2.equals("fieldCollection")) {
            this.fieldRequest(this.fieldCollectionAttributes.getValue(0), true);
            this.listAllCollectionFields = false;
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
        InsightRequestHandler.debugOut("Starting document.", 3);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            InsightRequestHandler.debugOut("Starting element: (" + string + ", " + string2 + ", " + string3 + ")", 3);
            if (!string2.equals("insightRequest")) {
                if (string2.equals("listCollections")) {
                    this.listCollectionAttributes = new ListCollectionAttributes(attributes);
                } else if (string2.equals("collectionRequest")) {
                    this.appendElement("collectionResponse");
                    this.parsingRequest = true;
                } else if (string2.equals("fieldRequest")) {
                    this.fieldRequestAttributes = new FieldRequestAttributes(attributes);
                    this.appendElement("fieldResponse");
                    this.parsingRequest = true;
                } else if (string2.equals("dataRequest")) {
                    this.dataRequestAttributes = new DataRequestAttributes(attributes);
                    this.appendElement("dataResponse");
                    this.parsingRequest = true;
                } else if (string2.equals("searchRequest")) {
                    this.appendElement("searchResponse");
                    this.parsingRequest = true;
                    this.searchRequestAttributes = new SearchRequestAttributes(attributes);
                } else if (string2.equals("fieldCollection")) {
                    this.fieldCollectionAttributes = attributes;
                } else if (string2.equals("searchCollection")) {
                    this.searchCollectionAttributes.add(attributes.getValue(0));
                } else if (string2.equals("sortField")) {
                    if (this.searchSortFields.size() == 4) {
                        this.fatalError(new SAXParseException("Maximum four sort fields", this.locator));
                    }
                    this.searchSortFields.add(attributes.getValue(0));
                } else if (string2.equals("returnResultIn")) {
                    this.returnResultInAttributes.add(new ReturnResultInAttributes(attributes));
                } else if (string2.equals("thumbnailField")) {
                    if (this.returnResultInAttributes.size() > 0) {
                        ReturnResultInAttributes returnResultInAttributes = (ReturnResultInAttributes)this.returnResultInAttributes.get(this.returnResultInAttributes.size() - 1);
                        returnResultInAttributes.addThumbnailField(attributes.getValue(0));
                    }
                } else if (string2.equals("objectCriteria")) {
                    this.objectAttributes.add(new ObjectAttributes(attributes));
                } else if (string2.equals("criteria")) {
                    Criterion criterion = new Criterion(attributes);
                    if (criterion.fieldtype.equals("keyword")) {
                        if (this.haveDataCriterion) {
                            this.fatalError(new SAXParseException("Can't mix keyword and data criteria", this.locator));
                        }
                        if (criterion.booleanOperator == 0 && this.criteriaList.size() > 0) {
                            this.fatalError(new SAXParseException("Keyword searches only support AND.", this.locator));
                        }
                        this.haveKeywordCriterion = true;
                    } else if (criterion.fieldtype.equals("data")) {
                        if (this.haveKeywordCriterion) {
                            this.fatalError(new SAXParseException("Can't mix keyword and data criteria", this.locator));
                        }
                        this.haveDataCriterion = true;
                    }
                    this.criteriaList.add(criterion);
                } else {
                    this.fatalError(new SAXParseException("Doctype must be insightRequest", this.locator));
                }
            }
            this.flush();
        }
        catch (SAXParseException sAXParseException) {
            this.fatalError(sAXParseException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.fatalError(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.parsingRequest) {
            this.parsingRequest = false;
            this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(1)}, GatewayConstants.RESULT_MESSAGE[1] + sAXParseException.getMessage());
        }
        this.flush();
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        InsightRequestHandler.debugOut("Warning:  " + sAXParseException);
    }

    void flush() {
        if (this.response != null) {
            this.response.print(this.responseBuffer.toString());
            this.response.flush();
            this.responseBuffer = new StringBuffer();
        }
    }

    private void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.responseBuffer.append("  ");
        }
    }

    void appendElement(String string, String[] stringArray, String[] stringArray2, String string2, boolean bl) {
        InsightRequestHandler.debugOut("Append element:  " + string, 3);
        this.indent(this.indentLevel++);
        this.responseBuffer.append('<').append(string);
        if (stringArray != null) {
            this.responseBuffer.append(' ');
            for (int i = 0; i < stringArray.length; ++i) {
                this.responseBuffer.append(stringArray[i]).append("=\"").append(InsightUtilities.attValueEncode(stringArray2[i])).append("\"").append(" ");
            }
        }
        if (string2 == null && bl) {
            this.responseBuffer.append("/>\n");
            --this.indentLevel;
            return;
        }
        this.responseBuffer.append('>');
        if (string2 != null) {
            this.responseBuffer.append(InsightUtilities.pcDataEncode(string2));
        }
        if (!bl) {
            this.responseBuffer.append('\n');
            this.openElementStack.add(0, string);
        } else {
            --this.indentLevel;
            this.responseBuffer.append(this.end(string));
        }
    }

    void appendElement(String string) {
        this.appendElement(string, null, null, null, false);
    }

    void appendElement(String string, boolean bl) {
        this.appendElement(string, null, null, null, bl);
    }

    void appendAndCloseElement(String string) {
        this.appendElement(string, true);
    }

    void appendAndCloseElement(String string, String[] stringArray, String[] stringArray2, String string2) {
        this.appendElement(string, stringArray, stringArray2, string2, true);
    }

    private boolean appendHeader() {
        if (this.useXSD) {
            this.appendXSDHeader();
            return false;
        }
        this.responseBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        this.responseBuffer.append("<!DOCTYPE insightResponse SYSTEM \"" + this.responseSystemID + "\">\n\n");
        return true;
    }

    private void appendXSDHeader() {
        this.responseBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        this.appendElement("insightResponse", new String[]{"xmlns", "xmlns:xsi", "xsi:schemaLocation"}, new String[]{"http://www.lunaimaging.com/support/xsd/oai/1.0/", "http://www.w3.org/2001/XMLSchema-instance", "http://www.lunaimaging.com/support/xsd/oai/1.0/ http://www.lunaimaging.com/support/xsd/oai/1.0/insight_xmlgateway.xsd"}, null, false);
    }

    void closeElements(String string, boolean bl) {
        if (this.openElementStack != null && this.openElementStack.size() > 0) {
            while (this.openElementStack.size() > 0) {
                String string2 = (String)this.openElementStack.get(0);
                if (!string2.equals(string)) {
                    this.closeElements(1);
                    continue;
                }
                if (!bl) break;
                this.closeElements(1);
                break;
            }
        }
    }

    void closeElements(int n) {
        int n2 = this.openElementStack.size();
        if (n == -1 || n > n2) {
            n = n2;
        }
        for (int i = 0; i < n; ++i) {
            this.indent(--this.indentLevel);
            String string = (String)this.openElementStack.remove(0);
            this.responseBuffer.append(this.end(string));
        }
    }

    private StringBuffer end(String string) {
        return new StringBuffer("</").append(string).append(">\n");
    }

    void setResponseStatus(boolean bl) {
        if (!bl) {
            if (this.responseStatus == 7) {
                this.responseStatus = 6;
            } else if (this.responseStatus == 0) {
                this.responseStatus = 5;
            }
        } else if (this.responseStatus == 7) {
            this.responseStatus = 0;
        } else if (this.responseStatus == 6) {
            this.responseStatus = 5;
        }
    }

    String getStandardTypeString(int n) {
        if (n == 1) {
            return "native";
        }
        if (n == 2 || n == 3) {
            return "standard";
        }
        return null;
    }

    String getMappingTypeString(int n) {
        if (n == 2) {
            return "numeric";
        }
        if (n == 1 || n == 3) {
            return "text";
        }
        return null;
    }

    String getObjectTypeString(InsightSmartClientResults insightSmartClientResults) {
        if (insightSmartClientResults.hasMpdSeries) {
            return "multi-page-document";
        }
        if (insightSmartClientResults.hasMviSeries) {
            return "multi-view-document";
        }
        return "media";
    }

    String getMediaTypeString(int n) {
        if (n == 2) {
            return "audio";
        }
        if (n == 1) {
            return "image";
        }
        if (n == 4) {
            return "qtvr";
        }
        if (n == 3) {
            return "video";
        }
        if (n == 5) {
            return "misc";
        }
        return "unknown";
    }

    FieldStandard getFieldStandard(String string, String string2, String string3) {
        List list = this.getFieldStandards(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string4;
                FieldStandard fieldStandard = (FieldStandard)iterator.next();
                if (!(string2.equals("native") ? (string4 = this.getStandardTypeString(fieldStandard.getType())) != null && string4.equals("native") : fieldStandard.getStandardName().equals(string3))) continue;
                return fieldStandard;
            }
        }
        return null;
    }

    FieldStandard getPreferredFieldStandard(String string) {
        List list = this.getFieldStandards(string);
        if (list != null && list.size() > 0) {
            return (FieldStandard)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getFieldStandards(String string) {
        String string2 = string.intern();
        synchronized (string2) {
            ArrayList<FieldStandard> arrayList = (ArrayList<FieldStandard>)fieldStandardsMap.get(string);
            if (arrayList != null) {
                return arrayList;
            }
            InsightRequestHandler.debugOut("Getting field standards for " + string);
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.collectionMap.get(string);
            if (trinityCollectionInfo == null) {
                return null;
            }
            InsightSmartClient insightSmartClient = new InsightSmartClient(trinityCollectionInfo);
            if (!insightSmartClient.areConnectionsGood()) {
                return null;
            }
            InsightSmartClient.enableProxyServerMode(maxClientProxies);
            Hashtable hashtable = insightSmartClient.getServerProps();
            Integer n = (Integer)hashtable.get("AllowCollectionSortMax");
            if (n != null) {
                allowCollectionSortMaxMap.put(string, n);
            }
            arrayList = new ArrayList<FieldStandard>();
            HashMap<FieldStandard, List> hashMap = new HashMap<FieldStandard, List>();
            HashMap<FieldStandard, List> hashMap2 = new HashMap<FieldStandard, List>();
            Iterator iterator = insightSmartClient.getStandardPreferences(trinityCollectionInfo).iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                FieldStandard fieldStandard = insightSmartClient.getFieldStandard(string3);
                if (fieldStandard == null) {
                    InsightRequestHandler.debugOut("Got null FieldStandard for " + string3 + ", collectionID " + string, 1);
                    continue;
                }
                if (this.getStandardTypeString(fieldStandard.getType()) == null) continue;
                arrayList.add(fieldStandard);
                List list = this.getThumbnailFields(fieldStandard);
                if (list.size() > 0) {
                    hashMap.put(fieldStandard, list);
                } else {
                    InsightRequestHandler.debugOut("FieldStandard " + string3 + ", collectionID " + string + " doesn't support thumbnails.", 1);
                }
                list = this.getSortFields(fieldStandard);
                if (list.size() > 0) {
                    hashMap2.put(fieldStandard, list);
                    continue;
                }
                InsightRequestHandler.debugOut("FieldStandard " + string3 + ", collectionID " + string + " doesn't support sorting.", 1);
            }
            InsightRequestHandler.debugOut("Initialized FieldStandard cache for collectionID " + string);
            fieldStandardsMap.put(string, arrayList);
            thumbnailStandardsMap.put(string, hashMap);
            sortStandardsMap.put(string, hashMap2);
            insightSmartClient.closeConnections();
            return arrayList;
        }
    }

    public void initializeFieldStandards() {
        Iterator iterator = this.collectionMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.initializeFieldStandards((String)iterator.next());
        }
    }

    public void initializeFieldStandards(String string) {
        fieldStandardsMap.remove(string);
        thumbnailStandardsMap.remove(string);
        sortStandardsMap.remove(string);
        this.getFieldStandards(string);
    }

    List getThumbnailFields(FieldStandard fieldStandard) {
        HashSet hashSet = new HashSet(fieldStandard.getMismatches().getMismatchedFields());
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        for (int i = 0; i < fieldStandard.thumbnailFieldMappings.length; ++i) {
            FieldMapping fieldMapping = fieldStandard.thumbnailFieldMappings[i];
            if (hashSet.contains(fieldMapping.getFieldName())) continue;
            arrayList.add(fieldMapping);
        }
        return arrayList;
    }

    List getSortFields(FieldStandard fieldStandard) {
        HashSet hashSet = new HashSet(fieldStandard.getMismatches().getMismatchedFields());
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        for (int i = 0; i < fieldStandard.sortFieldMappings.length; ++i) {
            FieldMapping fieldMapping = fieldStandard.sortFieldMappings[i];
            if (hashSet.contains(fieldMapping.getFieldName())) continue;
            arrayList.add(fieldMapping);
        }
        return arrayList;
    }

    List getResultStandardThumbnailFields(String string, FieldStandard fieldStandard, ReturnResultInAttributes returnResultInAttributes) {
        if (this.supportsThumbnails(string, fieldStandard) == null) {
            return null;
        }
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        Iterator iterator = returnResultInAttributes.getThumbnailFields().iterator();
        while (iterator.hasNext()) {
            FieldMapping fieldMapping = fieldStandard.getFieldMappingByDisplayName((String)iterator.next());
            if (fieldMapping == null || !this.isValidThumbnailField(fieldMapping, fieldStandard)) {
                return null;
            }
            arrayList.add(fieldMapping);
        }
        return arrayList.size() > 0 ? arrayList : this.supportsThumbnails(string, fieldStandard);
    }

    List supportsThumbnails(String string, FieldStandard fieldStandard) {
        return (List)((Map)thumbnailStandardsMap.get(string)).get(fieldStandard);
    }

    List supportsSort(String string, FieldStandard fieldStandard) {
        return (List)((Map)sortStandardsMap.get(string)).get(fieldStandard);
    }

    boolean isValidDefaultThumbField(FieldMapping fieldMapping, FieldStandard fieldStandard) {
        if (!this.isValidThumbnailField(fieldMapping, fieldStandard)) {
            return false;
        }
        for (int i = 0; i < fieldStandard.thumbnailFieldMappings.length; ++i) {
            if (fieldMapping.getFieldID() != fieldStandard.thumbnailFieldMappings[i].getFieldID()) continue;
            return true;
        }
        return false;
    }

    boolean isValidDefaultSortField(FieldMapping fieldMapping, FieldStandard fieldStandard) {
        if (!this.isValidSortField(fieldMapping, fieldStandard)) {
            return false;
        }
        for (int i = 0; i < fieldStandard.sortFieldMappings.length; ++i) {
            if (fieldMapping.getFieldID() != fieldStandard.sortFieldMappings[i].getFieldID()) continue;
            return true;
        }
        return false;
    }

    boolean isValidSortField(FieldMapping fieldMapping, FieldStandard fieldStandard) {
        if (!fieldMapping.isSortable()) {
            return false;
        }
        HashSet hashSet = new HashSet(fieldStandard.getMismatches().getMismatchedFields());
        return !hashSet.contains(fieldMapping.getFieldName());
    }

    boolean isValidThumbnailField(FieldMapping fieldMapping, FieldStandard fieldStandard) {
        if (!fieldMapping.isDisplayedInThumbnail()) {
            return false;
        }
        HashSet hashSet = new HashSet(fieldStandard.getMismatches().getMismatchedFields());
        return !hashSet.contains(fieldMapping.getFieldName());
    }

    boolean collectionAllowsSort(String string, TrinityCollectionInfo trinityCollectionInfo, InsightSmartClient insightSmartClient) {
        int n = this.getPrimaryGroupRecordCount(string, trinityCollectionInfo, insightSmartClient);
        Integer n2 = (Integer)allowCollectionSortMaxMap.get(string);
        if (n == -1 && n2 != null && n2 > 0) {
            return false;
        }
        if (n2 == null) {
            return true;
        }
        return n2 == 0 || n <= n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPrimaryGroupRecordCount(String string, TrinityCollectionInfo trinityCollectionInfo, InsightSmartClient insightSmartClient) {
        Map map = primaryGroupRecordCountMap;
        synchronized (map) {
            Integer n = (Integer)primaryGroupRecordCountMap.get(string);
            if (n == null) {
                if (trinityCollectionInfo != null && insightSmartClient != null) {
                    return this.updatePrimaryGroupRecordCount(string, trinityCollectionInfo, insightSmartClient);
                }
                return -1;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updatePrimaryGroupRecordCount(String string, TrinityCollectionInfo trinityCollectionInfo, InsightSmartClient insightSmartClient) {
        FieldStandard fieldStandard = this.getPreferredFieldStandard(string);
        if (fieldStandard != null) {
            if (!trinityCollectionInfo.isInfoComplete()) {
                trinityCollectionInfo = insightSmartClient.getConfigurationInfo(trinityCollectionInfo, fieldStandard.getStandardName());
            }
            if (trinityCollectionInfo.getProfileID() == -1 && !this.addProfileToTCI(insightSmartClient, trinityCollectionInfo)) {
                return -1;
            }
            GroupInformation groupInformation = insightSmartClient.getGroupInfo(trinityCollectionInfo.getInitialGroupOpen(), trinityCollectionInfo);
            groupInformation.setTci(trinityCollectionInfo);
            Vector<GatewayResultsProgressListener> vector = new Vector<GatewayResultsProgressListener>();
            GatewayResultsProgressListener gatewayResultsProgressListener = new GatewayResultsProgressListener(groupInformation);
            vector.add(gatewayResultsProgressListener);
            InsightSmartClientResults[] insightSmartClientResultsArray = null;
            InsightRequestHandler.debugOut("Updating collection record count via SHOW ALL");
            insightSmartClientResultsArray = insightSmartClient.getThumbnails(0, 1, this.username, fieldStandard.thumbnailFieldMappings, fieldStandard.sortFieldMappings, new ArrayList(), true, 0, vector);
            if (insightSmartClientResultsArray == null) {
                InsightRequestHandler.debugOut("Failed ShowAll query while getting collectionRecordCount.", 1);
                return -1;
            }
            Map map = primaryGroupRecordCountMap;
            synchronized (map) {
                primaryGroupRecordCountMap.put(string, new Integer(gatewayResultsProgressListener.getTotalHitCount()));
            }
            return gatewayResultsProgressListener.getTotalHitCount();
        }
        return -1;
    }

    void appendCollectionIDBlock(TrinityCollectionInfo trinityCollectionInfo) {
        String string = trinityCollectionInfo.getCollectionName();
        this.appendAndCloseElement("collectionName", null, null, string == null ? "" : string);
        string = trinityCollectionInfo.getCollectionID();
        this.appendAndCloseElement("collectionID", null, null, string == null ? "" : string);
        string = trinityCollectionInfo.getInstitutionID();
        this.appendAndCloseElement("institutionID", null, null, string == null ? "" : string);
        string = trinityCollectionInfo.getVCID();
        this.appendAndCloseElement("vcID", null, null, string == null ? "" : string);
    }

    void appendBadQueryBlock(String string, int n, String string2, TrinityCollectionInfo trinityCollectionInfo) {
        this.appendElement("collectionResultSet", GatewayConstants.ATTLIST_COLLECTION_RESULT_SET, new String[]{string, "0", "0", "0", "0", "0", "false", "false"}, null, false);
        if (trinityCollectionInfo != null) {
            this.appendCollectionIDBlock(trinityCollectionInfo);
        }
        this.appendAndCloseElement("status", GatewayConstants.ATTLIST_STATUS, new String[]{Integer.toString(n)}, string2);
        this.closeElements(1);
    }

    void includeMediaData(long l, int n, TrinityCollectionInfo trinityCollectionInfo, InsightSmartClient insightSmartClient) {
        Vector vector;
        MediaMetaData mediaMetaData = insightSmartClient.getFullMediaData(l, trinityCollectionInfo, n);
        if (mediaMetaData != null && (vector = mediaMetaData.getMediaFields()) != null && vector.size() > 0) {
            this.appendElement("mediaInfo");
            int n2 = 0;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                MediaField mediaField = (MediaField)iterator.next();
                String string = mediaField.getValue();
                if (string == null || string.equals("")) continue;
                this.appendElement("field", GatewayConstants.ATTLIST_FIELD, new String[]{mediaField.getName(), Integer.toString(++n2)}, null, false);
                this.appendAndCloseElement("value", GatewayConstants.ATTLIST_VALUE, new String[]{"1"}, string);
                this.closeElements(1);
            }
            this.closeElements(1);
        }
    }

    void includeFullData(long l, List list, TrinityCollectionInfo trinityCollectionInfo, InsightSmartClient insightSmartClient) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard = (FieldStandard)iterator.next();
            Vector vector = insightSmartClient.getFullInformation(l, trinityCollectionInfo, fieldStandard.getStandardName());
            if (vector == null) continue;
            if (!bl) {
                this.appendElement("fullData", null, null, null, false);
                bl = true;
            }
            this.appendElement("objectInfo", GatewayConstants.ATTLIST_OBJECT_INFO, new String[]{this.getStandardTypeString(fieldStandard.getType()), fieldStandard.getStandardName()}, null, false);
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                FieldValue fieldValue = (FieldValue)vector.get(i);
                String string = fieldValue.getField().getFieldDisplayName();
                if (string != null && !string.equals("")) {
                    if (fieldValue.isFieldGroupHeader || fieldValue.isFieldGroupName) {
                        if (bl2) {
                            this.closeElements(1);
                            bl2 = false;
                        }
                        if (fieldValue.isFieldGroupHeader) {
                            this.appendElement("fieldGroup", GatewayConstants.ATTLIST_FIELD_GROUP, new String[]{string, Integer.toString(++n)}, null, false);
                            n2 = 0;
                            bl2 = true;
                        }
                    }
                    if (!fieldValue.isFieldGroupHeader) {
                        this.appendElement("field", GatewayConstants.ATTLIST_FIELD, new String[]{string, Integer.toString(bl2 ? ++n2 : ++n)}, null, false);
                        List list2 = fieldValue.getValues();
                        int n3 = 0;
                        for (int j = 0; list2 != null && j < list2.size(); ++j) {
                            this.appendAndCloseElement("value", GatewayConstants.ATTLIST_VALUE, new String[]{Integer.toString(++n3)}, (String)list2.get(j));
                        }
                        this.closeElements(1);
                    }
                }
                this.flush();
            }
            if (bl2) {
                this.closeElements(1);
            }
            this.closeElements(1);
        }
        if (bl) {
            this.closeElements(1);
        }
    }

    boolean addProfileToTCI(InsightSmartClient insightSmartClient, TrinityCollectionInfo trinityCollectionInfo) {
        Vector vector = insightSmartClient.startSessions();
        if (vector != null && vector.size() > 0) {
            TrinityCollectionInfo trinityCollectionInfo2 = (TrinityCollectionInfo)vector.get(0);
            int n = trinityCollectionInfo2.getProfileID();
            if (n != -1) {
                trinityCollectionInfo.setProfileID(n);
                return true;
            }
            InsightRequestHandler.debugOut("Failed to start session for collection " + trinityCollectionInfo.getCollectionName(), 1);
        }
        insightSmartClient.endSession();
        return false;
    }

    private void collectionRequest() {
        CollectionRequestHandler.handleRequest(this);
    }

    private void fieldRequest(String string, boolean bl) {
        FieldRequestHandler.handleRequest(string, this, bl);
    }

    private void searchRequest() {
        SearchRequestHandler.handleRequest(this);
    }

    private void dataRequest() {
        DataRequestHandler.handleRequest(this);
    }

    static {
        InsightRequestHandler.debugOut("Default maxClientProxies: " + maxClientProxies, 1);
    }

    class Criterion
    implements GatewayConstants {
        String condition = "CONTAINS";
        String type = "text";
        String fieldname = null;
        String fieldtype = "keyword";
        int relationship = 2;
        int booleanOperator = 0;
        CriterionValue criterionValue = new StringCriterionValue("");

        private Criterion() {
        }

        private Criterion(Attributes attributes) throws SAXParseException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                if (string.equals("condition")) {
                    this.condition = string2;
                    continue;
                }
                if (string.equals("type")) {
                    this.type = string2;
                    continue;
                }
                if (string.equals("fieldname")) {
                    this.fieldname = string2;
                    continue;
                }
                if (string.equals("fieldtype")) {
                    this.fieldtype = string2;
                    continue;
                }
                if (!string.equals("booleanOperator") || !string2.equals("AND")) continue;
                this.booleanOperator = 1;
            }
            if (this.condition.equals("BEGINS_WITH")) {
                this.relationship = 3;
            } else if (this.condition.equals("ENDS_WITH")) {
                this.relationship = 4;
            } else if (this.condition.equals("DOES_NOT_CONTAIN")) {
                this.relationship = 9;
            } else if (this.condition.equals("LESS_THAN")) {
                this.relationship = 6;
            } else if (this.condition.equals("GREATER_THAN")) {
                this.relationship = 5;
            } else if (this.condition.equals("EQUALS")) {
                this.relationship = 1;
            }
            if (this.fieldtype.equals("keyword")) {
                if (this.relationship != 1) {
                    throw new SAXParseException("Keywords only support condition 'EQUALS'.", InsightRequestHandler.this.locator);
                }
                if (!this.type.equals("text")) {
                    throw new SAXParseException("Keywords must be of type 'text'.", InsightRequestHandler.this.locator);
                }
            }
            if (this.fieldtype.equals("data")) {
                if (this.type.equals("numeric") && this.relationship != 6 && this.relationship != 5 && this.relationship != 1) {
                    throw new SAXParseException("Numeric data field can't use condition '" + this.condition + "'.", InsightRequestHandler.this.locator);
                }
                if (this.type.equals("text") && this.relationship != 3 && this.relationship != 4 && this.relationship != 9 && this.relationship != 2 && this.relationship != 1) {
                    throw new SAXParseException("Text data field can't use condition '" + this.condition + "'.", InsightRequestHandler.this.locator);
                }
            }
        }

        private void setValue(String string) {
            this.criterionValue = new StringCriterionValue(string);
        }
    }

    class ObjectAttributes
    implements GatewayConstants {
        long objectID = -1L;
        long imageID = -1L;

        private ObjectAttributes() {
        }

        private ObjectAttributes(Attributes attributes) throws SAXParseException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                try {
                    if (string.equals("objectID")) {
                        this.objectID = Long.parseLong(string2);
                        continue;
                    }
                    if (!string.equals("imageID")) continue;
                    this.imageID = Long.parseLong(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXParseException("Attribute must be numeric: " + string2, InsightRequestHandler.this.locator);
                }
            }
        }
    }

    class ReturnResultInAttributes
    implements GatewayConstants {
        String mappingType = "native";
        String mappingName = null;
        private List thumbnailFields = new ArrayList();

        private ReturnResultInAttributes() {
        }

        private ReturnResultInAttributes(Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                if (string.equals("mappingType")) {
                    this.mappingType = string2;
                    continue;
                }
                if (!string.equals("mappingName")) continue;
                this.mappingName = string2;
            }
        }

        void addThumbnailField(String string) throws SAXException {
            if (this.thumbnailFields.size() == 4) {
                InsightRequestHandler.this.fatalError(new SAXParseException("Maximum four thumbnail fields", InsightRequestHandler.this.locator));
            }
            this.thumbnailFields.add(string);
        }

        boolean hasThumbnailFields() {
            return this.thumbnailFields.size() > 0;
        }

        List getThumbnailFields() {
            return this.thumbnailFields;
        }
    }

    class SearchRequestAttributes
    implements GatewayConstants {
        String mappingType = "native";
        String mappingName = null;
        int recordCount = 0;
        int firstRecordIndex = 0;
        int maxImageSize = -1;
        boolean includeGWLaunchURL = true;
        boolean includeThumbLabels = true;
        boolean includeFullDataRecord = true;
        boolean includeThumbnailUrl = true;
        boolean includeIWLaunchURL = true;
        boolean includeFullDetail = true;

        private SearchRequestAttributes() {
        }

        private SearchRequestAttributes(Attributes attributes) throws SAXParseException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                try {
                    if (string.equals("mappingType")) {
                        this.mappingType = string2;
                        continue;
                    }
                    if (string.equals("mappingName")) {
                        this.mappingName = string2;
                        continue;
                    }
                    if (string.equals("recordCount")) {
                        this.recordCount = Integer.parseInt(string2);
                        if (this.recordCount <= 500000) continue;
                        this.recordCount = 500000;
                        continue;
                    }
                    if (string.equals("firstRecordIndex")) {
                        this.firstRecordIndex = Integer.parseInt(string2) - 1;
                        if (this.firstRecordIndex >= 0) continue;
                        this.firstRecordIndex = 0;
                        continue;
                    }
                    if (string.equals("maxImageSize")) {
                        this.maxImageSize = Integer.parseInt(string2);
                        continue;
                    }
                    if (string.equals("includeGroupWorkspaceLaunchURL")) {
                        this.includeGWLaunchURL = string2.equals("true");
                        continue;
                    }
                    if (string.equals("includeThumbnailLabels")) {
                        this.includeThumbLabels = string2.equals("true");
                        continue;
                    }
                    if (string.equals("includeFullDataRecord")) {
                        this.includeFullDataRecord = string2.equals("true");
                        continue;
                    }
                    if (string.equals("includeThumbnailUrl")) {
                        this.includeThumbnailUrl = string2.equals("true");
                        continue;
                    }
                    if (string.equals("includeImageWorkspaceLaunchURL")) {
                        this.includeIWLaunchURL = string2.equals("true");
                        continue;
                    }
                    if (!string.equals("includeFullDetail")) continue;
                    this.includeFullDetail = string2.equals("true");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXParseException("searchRequest attribute number format error", InsightRequestHandler.this.locator);
                }
            }
        }
    }

    class DataRequestAttributes
    implements GatewayConstants {
        String collectionID;
        int maxImageSize = -1;

        private DataRequestAttributes() {
        }

        private DataRequestAttributes(Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                if (string.equals("cid")) {
                    this.collectionID = string2;
                    continue;
                }
                if (!string.equals("maxImageSize")) continue;
                try {
                    this.maxImageSize = Integer.parseInt(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    class FieldRequestAttributes
    extends ListCollectionAttributes {
        private FieldRequestAttributes(Attributes attributes) {
            super(attributes);
        }
    }

    class ListCollectionAttributes
    implements GatewayConstants {
        boolean includePC = true;

        private ListCollectionAttributes() {
        }

        private ListCollectionAttributes(Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                if (!string.equals("includePersonalCollections")) continue;
                this.includePC = new Boolean(string2);
            }
        }
    }
}

