/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.util.metadata.exiv2;

import com.luna.insight.server.Debug;
import com.luna.insight.server.util.Exec;
import com.luna.insight.server.util.metadata.AbstractTag;
import com.luna.insight.server.util.metadata.Exif;
import com.luna.insight.server.util.metadata.Iptc;
import com.luna.insight.server.util.metadata.Tag;
import com.luna.insight.server.util.metadata.exiv2.Exiv2CommandOutputParser;
import com.luna.insight.server.util.metadata.tool.MetadataTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Exiv2Exec
implements MetadataTool {
    public static final String CHECK_FILE_PATH = "Check file path:";
    public static final String READ_EXIF_OPTION = "-pv";
    public static final String READ_IPTC_OPTION = "-pi";
    public static final String DELETE_ALL = "-da";
    public static final String DELETE_EXIF = "-de";
    public static final String DELETE_IPTC = "-di";
    protected List tagList = new ArrayList();
    protected String filePath = null;
    protected Exec exec = null;
    protected String command = null;
    private Map tagMap = new HashMap();

    public Exiv2Exec() {
        this.exec = new Exec();
    }

    public Exiv2Exec(String string) {
        this();
        this.command = string;
    }

    public void init() {
        this.tagList.removeAll(this.tagList);
        this.filePath = null;
        this.tagMap.clear();
    }

    public Exec getExec() {
        return this.exec;
    }

    public void setExec(Exec exec) {
        this.exec = exec;
    }

    public boolean copyAllTags(String string, String string2) throws Exception {
        boolean bl = false;
        try {
            this.read("Exif", string);
            this.read("Iptc", string);
            bl = this.copyTags(string2);
        }
        catch (Exception exception) {
            this.debugOut("copyAllTags(String, String): " + exception.getMessage());
            throw exception;
        }
        return bl;
    }

    public boolean copyIptcTags(String string, String string2) throws Exception {
        boolean bl = false;
        try {
            this.read("Iptc", string);
            bl = this.copyTags(string2);
        }
        catch (Exception exception) {
            this.debugOut("copyAllTags(String, String): " + exception.getMessage());
            throw exception;
        }
        return bl;
    }

    public boolean copyTags(String string) throws Exception {
        String[] stringArray;
        boolean bl = false;
        this.checkFilePath(string);
        List list = this.getTagList();
        if (list == null || list.size() == 0) {
            throw new Exception("No tags were read.");
        }
        Iterator iterator = list.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getCommand());
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (stringArray == null) continue;
            String string2 = stringArray.getKey();
            String string3 = stringArray.getType();
            String string4 = stringArray.getValue();
            if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
            arrayList.add("-M");
            arrayList.add("add " + string2 + " " + string3 + " " + string4);
        }
        arrayList.add(string);
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        bl = this.exec.exec(stringArray);
        this.debugOut("copyTags(String, String, String):  isCommandSuccessful: " + bl);
        return bl;
    }

    public boolean deleteExifTags(String string) throws Exception {
        return this.deleteTags(string, DELETE_EXIF);
    }

    public boolean deleteIptcTags(String string) throws Exception {
        return this.deleteTags(string, DELETE_IPTC);
    }

    protected boolean deleteTags(String string, String string2) throws Exception {
        boolean bl = false;
        this.checkFilePath(string);
        String[] stringArray = new String[]{this.getCommand(), string2, string};
        bl = this.exec.exec(stringArray);
        this.debugOut("deleteAllTags(String): isCommandSuccessful: " + bl);
        if (bl) {
            String string3 = this.exec.getOutputString();
            this.debugOut("deleteTags(String): standard output: " + string3);
            this.tagMap.clear();
            this.tagList.clear();
        } else {
            String string4 = this.exec.getErrorString();
            this.debugOut("deleteAllTags(String): errorMessage: " + string4);
        }
        return bl;
    }

    public Tag getTag(String string) {
        List list;
        Object e;
        Tag tag = null;
        Object var3_3 = null;
        var3_3 = this.tagMap.get(string);
        if (var3_3 != null && var3_3 instanceof List && (e = (list = (List)var3_3).get(0)) != null && e instanceof Tag) {
            tag = (Tag)e;
        }
        return tag;
    }

    public List getTagList() {
        return this.tagList;
    }

    public String getType(String string) {
        String string2 = null;
        Tag tag = this.getTag(string);
        if (tag != null) {
            string2 = tag.getType();
        }
        return string2;
    }

    public String getValue(String string) {
        String string2 = null;
        Tag tag = this.getTag(string);
        if (tag != null) {
            string2 = tag.getValue();
        }
        return string2;
    }

    public boolean read(String string, String string2) throws Exception {
        boolean bl = false;
        String string3 = null;
        if ("Exif".equals(string)) {
            string3 = READ_EXIF_OPTION;
        } else if ("Iptc".equals(string)) {
            string3 = READ_IPTC_OPTION;
        } else {
            throw new Exception("Information Type does not exist: " + string);
        }
        this.checkFilePath(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getCommand());
        arrayList.add(string3);
        arrayList.add(string2);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        bl = this.exec.exec(stringArray);
        this.debugOut("read(String, String): " + bl);
        if (bl) {
            String string4 = this.exec.getOutputString();
            this.debugOut("read(String, String): standard output: " + string4);
            Exiv2CommandOutputParser exiv2CommandOutputParser = new Exiv2CommandOutputParser();
            List list = exiv2CommandOutputParser.parse(string, string4);
            this.keepTagList(list);
        } else {
            String string5 = this.exec.getErrorString();
            this.debugOut("read(String, String): errorMessage: " + string5);
        }
        return bl;
    }

    public boolean readExifTags(String string) throws Exception {
        return this.read("Exif", string);
    }

    public boolean readIptcTags(String string) throws Exception {
        return this.read("Iptc", string);
    }

    public void set(String string, String string2, String string3) throws Exception {
        AbstractTag abstractTag = null;
        if (string == null) {
            throw new Exception("Key is not specified.");
        }
        if (string3 == null) {
            throw new Exception("Value is not specified.");
        }
        if (string.startsWith("Exif.")) {
            abstractTag = new Exif();
        } else if (string.startsWith("Iptc.")) {
            abstractTag = new Iptc();
        }
        if (abstractTag == null) {
            throw new Exception("No tag found:  " + string);
        }
        abstractTag.setKey(string);
        abstractTag.setType(string2);
        abstractTag.setValue(string3);
        this.tagList.add(abstractTag);
        this.putTagInTagMap(abstractTag);
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public boolean update() throws Exception {
        String[] stringArray;
        boolean bl = false;
        if (this.filePath == null) {
            throw new Exception(CHECK_FILE_PATH);
        }
        this.checkFilePath(this.filePath);
        if (this.tagList == null) {
            throw new Exception("No tag(s) specified.");
        }
        Iterator iterator = this.tagList.iterator();
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getCommand());
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (stringArray != null) {
                String string2 = stringArray.getKey();
                String string3 = stringArray.getType();
                String string4 = stringArray.getValue();
                if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                    arrayList.add("-M");
                    arrayList.add("set " + string2 + " " + string3 + " " + string4);
                }
            }
            this.debugOut("update(): " + string);
        }
        arrayList.add(this.filePath);
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        bl = this.exec.exec(stringArray);
        this.debugOut("update(): isCommandSuccessful " + bl);
        return bl;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public String getOrientation(String string) throws Exception {
        String string2 = null;
        boolean bl = this.readExifTags(string);
        if (bl) {
            string2 = this.getValue("Exif.Image.Orientation");
        }
        return string2;
    }

    protected void keepTagList(List list) throws Exception {
        if (this.tagList == null || list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Tag tag = null;
            Object e = iterator.next();
            if (e == null || !(e instanceof Tag)) continue;
            tag = (Tag)e;
            this.tagList.add(tag);
            this.putTagInTagMap(tag);
        }
    }

    protected void putTagInTagMap(Tag tag) {
        String string = tag.getKey();
        Object v = this.tagMap.get(string);
        if (v == null) {
            ArrayList<Tag> arrayList = new ArrayList<Tag>();
            arrayList.add(tag);
            this.tagMap.put(string, arrayList);
            this.debugOut("putTagInTagMap(Tag): Adding tag, key: " + string + " value: " + tag.getValue());
        } else {
            ((List)v).add(tag);
        }
    }

    protected void checkFilePath(String string) throws Exception {
        if (string == null) {
            throw new Exception(CHECK_FILE_PATH);
        }
    }

    public static String escapeDoubleQuote(String string) {
        String string2 = null;
        if (string != null) {
            string.replaceAll("\"", "\\\"");
        }
        return string2;
    }

    protected void debugOut(String string) {
        Debug.debugOut("Exiv2Exec: " + string);
    }
}

