/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.util;

import com.luna.insight.server.util.BookManager;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LunaBookManager
extends BookManager {
    private static final String SCANDATA_FILENAME = "scandata.xml";
    private static final String SEARCHTEXT_FILE_SUFFIX = "_text.xml";
    private HashMap bookProperties = null;
    private String bookFolder = null;

    public HashMap getBookProperties() {
        return this.bookProperties;
    }

    public void setBookProperties(HashMap hashMap) {
        this.bookProperties = hashMap;
    }

    public LunaBookManager(String string) throws Exception {
        this.bookFolder = string;
        this.bookProperties = this.getBookDetails();
    }

    private File getScanDataFile() {
        File file = new File(this.bookFolder, SCANDATA_FILENAME);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private Properties getBookPropertiesFile() {
        File file = new File(this.bookFolder, "scandata.properties");
        if (file.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
                return properties;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private HashMap getScanData() {
        HashMap<String, Object> hashMap;
        block9: {
            File file = new File(this.bookFolder, SCANDATA_FILENAME);
            hashMap = null;
            if (file != null && file.exists()) {
                try {
                    SAXBuilder sAXBuilder = new SAXBuilder();
                    sAXBuilder.setValidation(false);
                    sAXBuilder.setIgnoringElementContentWhitespace(true);
                    Document document = sAXBuilder.build(file);
                    Element element = document.getRootElement();
                    int n = Integer.parseInt(element.getChild("bookData").getChildText("leafCount"));
                    if (n <= 0) break block9;
                    List list = element.getContent((Filter)new ElementFilter("pageData"));
                    Iterator iterator = list.iterator();
                    ArrayList<String> arrayList = new ArrayList<String>(n);
                    ArrayList<String> arrayList2 = new ArrayList<String>(n);
                    ArrayList<String> arrayList3 = new ArrayList<String>(n);
                    ArrayList<String> arrayList4 = new ArrayList<String>(n);
                    String string = null;
                    while (iterator.hasNext()) {
                        Element element2 = (Element)iterator.next();
                        List list2 = element2.getContent((Filter)new ElementFilter("page"));
                        Iterator iterator2 = list2.iterator();
                        while (iterator2.hasNext()) {
                            Element element3 = (Element)iterator2.next();
                            String string2 = element3.getAttributeValue("leafNum").trim();
                            arrayList.add(string2);
                            arrayList3.add(element3.getChildTextTrim("origWidth"));
                            arrayList2.add(element3.getChildTextTrim("origHeight"));
                            if (element3.getChildTextTrim("pageNumber") != null) {
                                arrayList4.add(element3.getChildTextTrim("pageNumber"));
                            } else {
                                arrayList4.add("");
                            }
                            if (string != null || !"Title".equalsIgnoreCase(element3.getChildTextTrim("pageType"))) continue;
                            string = string2;
                        }
                    }
                    hashMap = new HashMap<String, Object>(5);
                    hashMap.put("totalLeafs", String.valueOf(n));
                    hashMap.put("pageHeights", arrayList2);
                    hashMap.put("pageWidths", arrayList3);
                    hashMap.put("mappedPage", arrayList4);
                    hashMap.put("leafNumbers", arrayList);
                    if (string != null) {
                        hashMap.put("titleLeaf", string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("Error while reading the scandata - " + exception.toString());
                }
            } else {
                System.out.println("scandata.xml is not present in folder " + this.bookFolder);
            }
        }
        return hashMap;
    }

    private HashMap getMetaData(String string) {
        File file = new File(this.bookFolder, string);
        System.out.println("***************Reading meta data");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (file != null && file.exists()) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder();
                sAXBuilder.setValidation(false);
                sAXBuilder.setIgnoringElementContentWhitespace(true);
                Document document = sAXBuilder.build(file);
                Element element = document.getRootElement();
                List list = element.getContent((Filter)new ElementFilter());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    hashMap.put(element2.getName(), element2.getTextTrim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public HashMap getBookDetails() throws Exception {
        String string = "unknown";
        File file = new File(this.bookFolder);
        String string2 = null;
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith("_meta.xml");
            }
        });
        Object var5_5 = null;
        if (stringArray != null && stringArray.length > 0) {
            string2 = stringArray[0].substring(0, stringArray[0].lastIndexOf("_meta.xml"));
        }
        if (new File(this.bookFolder, string2 + "_jp2.zip").exists()) {
            string = "jp2";
        } else if (new File(this.bookFolder, string2 + "_tif.zip").exists()) {
            string = "tif";
        } else if (new File(this.bookFolder, string2 + "_jpg.zip").exists()) {
            string = "jpg";
        }
        if (string.equals("unknown")) {
            throw new Exception("Book not Found");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zip", string2 + "_" + string + ".zip");
        hashMap.put("imageFormat", string);
        hashMap.put("bookName", string2);
        hashMap.put("title", "");
        HashMap hashMap2 = this.getMetaData(string2 + "_meta.xml");
        HashMap hashMap3 = this.getScanData();
        if (hashMap2 != null) {
            hashMap.putAll(hashMap2);
        }
        if (hashMap3 != null) {
            hashMap.putAll(hashMap3);
        }
        hashMap.put("files", this.getDownloadableBookFiles());
        return hashMap;
    }

    public String searchBook(String string) {
        String[] stringArray;
        String string2 = null;
        File file = new File(this.bookFolder);
        if (file.exists() && (stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string != null && string.toLowerCase().endsWith(LunaBookManager.SEARCHTEXT_FILE_SUFFIX);
            }
        })) != null && stringArray.length == 1) {
            return this.searchText(this.bookFolder + File.separator + stringArray[0], string);
        }
        return string2;
    }

    private String searchText(String string, String string2) {
        StringBuffer stringBuffer = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            sAXBuilder.setValidation(false);
            sAXBuilder.setIgnoringElementContentWhitespace(true);
            sAXBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    if (string2.endsWith(".dtd")) {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                    return null;
                }
            });
            Document document = sAXBuilder.build(new File(string));
            Element element = document.getRootElement();
            List list = element.getChildren("page");
            Iterator iterator = list.iterator();
            stringBuffer = new StringBuffer("<SEARCH>");
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                List list2 = element2.getChildren("text");
                Iterator iterator2 = list2.iterator();
                StringBuffer stringBuffer2 = new StringBuffer("");
                while (iterator2.hasNext()) {
                    Element element3 = (Element)iterator2.next();
                    if (element3.getValue().toLowerCase().indexOf(string2.toLowerCase()) <= -1) continue;
                    String string3 = element3.getValue();
                    int n = string3.toLowerCase().indexOf(string2.toLowerCase());
                    int n2 = n + string2.length();
                    stringBuffer2.append("<LINE>");
                    stringBuffer2.append("<CONTEXT>");
                    stringBuffer2.append(string3.substring(0, n));
                    stringBuffer2.append("</CONTEXT>");
                    stringBuffer2.append("<WORD");
                    stringBuffer2.append(" top=\"" + element3.getAttributeValue("top") + "\"");
                    stringBuffer2.append(" left=\"" + element3.getAttributeValue("left") + "\"");
                    stringBuffer2.append(" right=\"" + (Integer.parseInt(element3.getAttributeValue("width")) + Integer.parseInt(element3.getAttributeValue("left"))) + "\"");
                    stringBuffer2.append(" bottom=\"" + (Integer.parseInt(element3.getAttributeValue("height")) + Integer.parseInt(element3.getAttributeValue("top"))) + "\">");
                    if (string3.length() == n2) {
                        stringBuffer2.append(string3.substring(n));
                    } else {
                        stringBuffer2.append(string3.substring(n, n2));
                    }
                    stringBuffer2.append("</WORD>");
                    stringBuffer2.append("<CONTEXT>");
                    stringBuffer2.append(string3.substring(n2));
                    stringBuffer2.append("</CONTEXT>");
                    stringBuffer2.append("</LINE>");
                }
                if (stringBuffer2.length() <= 0) continue;
                stringBuffer.append("<PAGE");
                stringBuffer.append(" number=\"" + element2.getAttributeValue("number") + "\"");
                stringBuffer.append(" width=\"" + element2.getAttributeValue("width") + "\"");
                stringBuffer.append(" height=\"" + element2.getAttributeValue("height") + "\">");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("</PAGE>");
            }
            stringBuffer.append("</SEARCH>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Error while searching the book for " + string2 + " - " + exception.toString());
        }
        System.out.println(stringBuffer);
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString().replaceAll("'", "").replaceAll("&", "");
    }

    public int getTitlePageLeaf() {
        int n = 0;
        if (this.bookProperties.containsKey("titleLeaf")) {
            n = Integer.parseInt((String)this.bookProperties.get("titleLeaf"));
        }
        return n;
    }

    public static String getImageUrlByLeafNumber(int n, int n2, String string, String string2, String string3, int n3, int n4) {
        String string4 = "000" + n;
        return string + "&zip=" + string2 + "&page=" + string4.substring(string4.length() - 4) + "." + string3 + "&width=" + Math.round((double)n3 / Math.pow(2.0, n2)) + "&height=" + Math.round((double)n4 / Math.pow(2.0, n2)) + "&level=" + n2;
    }

    public String getZipFileName() {
        return (String)this.bookProperties.get("zip");
    }

    public String getPageFileName(int n) {
        String string = String.valueOf(n);
        if (!((List)this.bookProperties.get("leafNumbers")).contains(string)) {
            string = (String)((List)this.bookProperties.get("leafNumbers")).get(0);
        }
        StringBuffer stringBuffer = new StringBuffer("000");
        stringBuffer.append(string);
        if (stringBuffer.length() > 4) {
            int n2 = stringBuffer.length() - 4;
            stringBuffer.delete(0, n2);
        }
        stringBuffer.append("." + (String)this.bookProperties.get("imageFormat"));
        return stringBuffer.toString();
    }

    public Dimension getPageDimensionByLeaf(int n) {
        return this.getPageDimension(((List)this.bookProperties.get("leafNumbers")).indexOf(String.valueOf(n)));
    }

    public Dimension getPageDimension(int n) {
        return new Dimension(Integer.parseInt((String)((List)this.bookProperties.get("pageWidths")).get(n)), Integer.parseInt((String)((List)this.bookProperties.get("pageHeights")).get(n)));
    }

    public String getBookName() {
        return (String)this.bookProperties.get("bookName");
    }

    public boolean isSearchEnabled() {
        return false;
    }

    public static boolean isBookValid(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.isDirectory()) {
            int n;
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return false;
            }
            for (n = fileArray.length; n > 0 && !bl; --n) {
                if (!fileArray[n - 1].isDirectory() || !fileArray[n - 1].getName().equals("JP2K")) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            bl = false;
            for (n = fileArray.length; n > 0 && !bl; --n) {
                if (!fileArray[n - 1].getName().equalsIgnoreCase(SCANDATA_FILENAME)) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        return bl;
    }

    private List getDownloadableBookFiles() {
        String[] stringArray;
        File file = new File(this.bookFolder);
        ArrayList<String> arrayList = null;
        if (file != null && file.isDirectory() && (stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file.getPath() + File.separator + string);
                return file2.isFile() && !file2.isHidden() && (string.toLowerCase().endsWith(".pdf") || string.toLowerCase().endsWith(".txt"));
            }
        })) != null && stringArray.length > 0) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = stringArray.length; i > 0; --i) {
                if (!stringArray[i - 1].toLowerCase().endsWith(".pdf") && !stringArray[i - 1].toLowerCase().endsWith(".txt")) continue;
                arrayList.add(stringArray[i - 1]);
            }
        }
        return arrayList;
    }
}

