/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.util;

import com.luna.insight.core.jpeg2000.JPegConverter;
import com.luna.insight.core.util.XMLWriter;
import com.luna.insight.server.Debug;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BookBuilder {
    private List imageDimensionMap = null;
    private String processedImageFolder = null;
    private String imageFormat = null;
    private Properties bookProperties = new Properties();
    private final String jpegFolderName = "jpeg";
    private final String jp2kFolderName = "JP2K";
    private final String bmpFolderName = "bmp";
    private final String bookPropertiesFile = "book.properties";
    private final String scanDataFile = "scandata.xml";

    public void processImages(String string, String string2) throws Exception {
        String[] stringArray = this.getFileNames(string);
        if (stringArray != null && stringArray.length > 0) {
            this.bookProperties.put("startLeafNumber", stringArray[0].substring(0, stringArray[0].lastIndexOf(".")));
            this.imageDimensionMap = new ArrayList(stringArray.length);
            if (JPegConverter.isJpeg2000Enabled()) {
                String string3;
                String string4 = string2 + File.separator + "bmp";
                File file = new File(string4);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (!(file = new File(string3 = string2 + File.separator + "JP2K")).exists()) {
                    file.mkdirs();
                }
                file = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.generateBmpFile(string, stringArray[i], string4) == null) continue;
                    this.generateJpeg2KImage(string4, stringArray[i].substring(0, stringArray[i].lastIndexOf(".")) + ".bmp", (Dimension)this.imageDimensionMap.get(i), string3);
                }
                try {
                    new File(string4).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.processedImageFolder = string2 + File.separator + "JP2K";
                this.imageFormat = "jp2";
            } else {
                String string5 = string2 + File.separator + "jpeg";
                this.generateJpegFiles(string, string5);
                this.processedImageFolder = string2 + File.separator + "jpeg";
                this.imageFormat = "jpeg";
            }
        } else {
            throw new Exception("Book folder is invalid");
        }
    }

    public void processImagesTemp(String string, String string2) throws Exception {
        File file = new File(string);
        Date date = new Date();
        if (string2 == null || string2.equals("") || string2.equalsIgnoreCase(string)) {
            string2 = string.concat(File.separator.concat("dest"));
        }
        String string3 = string2 + File.separator + "bmp";
        String string4 = string2 + File.separator + "JP2K";
        String string5 = string2 + File.separator + "jpeg";
        if (file.exists()) {
            String[] stringArray;
            File file2 = new File(string2);
            if (!file2.exists() && !file2.mkdir()) {
                throw new Exception("Dest folder could not be created");
            }
            if (JPegConverter.isJpeg2000Enabled()) {
                stringArray = new File(string3);
                stringArray.mkdir();
                File file3 = new File(string4);
                file3.mkdir();
            } else {
                stringArray = new File(string5);
                stringArray.mkdir();
            }
            stringArray = file.list();
            BookBuilder.debugOut("Total free memory1 - " + IJ.freeMemory());
            if (stringArray != null && stringArray.length > 0) {
                int n = stringArray.length;
                this.imageDimensionMap = new ArrayList(n);
                if (JPegConverter.isJpeg2000Enabled()) {
                    for (int i = 0; i < n; ++i) {
                        String string6 = stringArray[i];
                        BookBuilder.debugOut("Total free memory2 - " + string6 + "    -    " + IJ.freeMemory());
                        String string7 = this.generateBmpFile(string, string6, string3);
                        if (string7 == null) continue;
                        this.generateJpeg2KImage(string3, string7, (Dimension)this.imageDimensionMap.get(i), string4);
                        this.deleteObsoleteFile(string3, string7);
                    }
                } else {
                    this.generateJpegFiles(string, string5);
                }
            }
            BookBuilder.debugOut("Successfully converted files");
            BookBuilder.debugOut("Total Time for conversion - " + (new Date().getTime() - date.getTime()));
        }
    }

    private boolean generateBmpFiles(String string, String[] stringArray, String string2) throws Exception {
        boolean bl = false;
        File file = new File(string2);
        if (!file.exists() && !file.mkdir()) {
            throw new Exception("Dest folder could not be created");
        }
        file = null;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string, stringArray[i]);
                if (file2.isFile()) {
                    BookBuilder.debugOut("Free memmory    - " + IJ.freeMemory());
                    ImagePlus imagePlus = IJ.openImage((String)(string + File.separator + stringArray[i]));
                    this.imageDimensionMap.add(new Dimension(imagePlus.getWidth(), imagePlus.getHeight()));
                    BookBuilder.debugOut("Free memory after     - " + IJ.freeMemory());
                    IJ.save((ImagePlus)imagePlus, (String)(string2 + File.separator + stringArray[i].substring(0, stringArray[i].lastIndexOf(".")) + ".bmp"));
                    BookBuilder.debugOut("Free memory after " + stringArray[i] + "    - " + IJ.freeMemory());
                    imagePlus.flush();
                    imagePlus = null;
                }
                file2 = null;
            }
            bl = true;
        }
        return bl;
    }

    private String generateBmpFile(String string, String string2, String string3) throws Exception {
        File file = new File(string, string2);
        if (file.isFile()) {
            BookBuilder.debugOut("Free memmory    - " + IJ.freeMemory());
            ImagePlus imagePlus = IJ.openImage((String)(string + File.separator + string2));
            if (imagePlus != null) {
                this.imageDimensionMap.add(new Dimension(imagePlus.getWidth(), imagePlus.getHeight()));
                BookBuilder.debugOut("Free memory after     - " + IJ.freeMemory());
                String string4 = string2.substring(0, string2.lastIndexOf(".")) + ".bmp";
                IJ.save((ImagePlus)imagePlus, (String)(string3 + File.separator + string4));
                BookBuilder.debugOut("Free memory after " + string2 + "    - " + IJ.freeMemory());
                imagePlus.flush();
                imagePlus = null;
                return string4;
            }
        }
        return null;
    }

    private String[] getFileNames(String string) {
        File file = new File(string);
        Object[] objectArray = null;
        if (file.exists() && file.isDirectory()) {
            objectArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    File file2 = new File(file.getPath() + File.separator + string);
                    return file2.isFile() && !file2.isHidden();
                }
            });
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    private boolean generateJpegFiles(String string, String string2) throws Exception {
        boolean bl = false;
        File file = new File(string);
        File file2 = new File(string2);
        if (!file2.exists() && !file2.mkdir()) {
            throw new Exception("Dest folder could not be created");
        }
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(string, stringArray[i]);
                if (file3.isFile()) {
                    BookBuilder.debugOut("Free memmory    - " + IJ.freeMemory());
                    ImagePlus imagePlus = IJ.openImage((String)(string + File.separator + stringArray[i]));
                    if (imagePlus != null) {
                        this.imageDimensionMap.add(new Dimension(imagePlus.getWidth(), imagePlus.getHeight()));
                        BookBuilder.debugOut("Free memory after     - " + IJ.freeMemory());
                        FileSaver fileSaver = new FileSaver(imagePlus);
                        fileSaver.saveAsJpeg(string2 + File.separator + stringArray[i].substring(0, stringArray[i].lastIndexOf(".")) + ".jpg");
                        fileSaver = null;
                        BookBuilder.debugOut("Free memmory    - " + IJ.freeMemory());
                        imagePlus.flush();
                        imagePlus = null;
                    }
                }
                file3 = null;
            }
            bl = true;
        }
        return bl;
    }

    private boolean generateJpeg2KImages(String string, String[] stringArray, String string2) throws Exception {
        boolean bl = false;
        File file = new File(string);
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdir();
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i];
            BookBuilder.debugOut("********************** " + string3 + "*******");
            JPegConverter.convertToJpeg2000(string, string3.substring(0, string3.lastIndexOf(".")) + ".bmp", string2, (Dimension)this.imageDimensionMap.get(i));
            this.deleteObsoleteFile(string, string3.substring(0, string3.lastIndexOf(".")) + ".bmp");
        }
        bl = true;
        return bl;
    }

    private boolean generateJpeg2KImage(String string, String string2, Dimension dimension, String string3) throws Exception {
        boolean bl = false;
        BookBuilder.debugOut("********************** " + string + "*******");
        JPegConverter.convertToJpeg2000(string, string2, string3, dimension);
        this.deleteObsoleteFile(string, string2);
        bl = true;
        return bl;
    }

    private boolean deleteObsoleteFile(String string, String string2) {
        return new File(string, string2).delete();
    }

    private void generateImageZip(String string) {
        try {
            String string2 = string.substring(string.lastIndexOf(File.separator) + 1) + "_" + this.imageFormat + ".zip";
            File file = new File(this.processedImageFolder);
            String[] stringArray = file.list();
            byte[] byArray = new byte[1024];
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string + File.separator + string2));
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                File file2 = new File(this.processedImageFolder + File.separator + stringArray[i]);
                FileInputStream fileInputStream = new FileInputStream(file2);
                zipOutputStream.putNextEntry(new ZipEntry(stringArray[i]));
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                fileInputStream.close();
                file2.delete();
            }
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void generateScanData(String string, String string2, String string3) throws Exception {
        String string4 = null;
        int n = 0;
        string4 = this.bookProperties.getProperty("ThumbnailImage");
        if (string4 != null) {
            n = Integer.parseInt(string4);
        }
        int n2 = Integer.parseInt(this.bookProperties.getProperty("startLeafNumber"));
        String string5 = this.bookProperties.getProperty("Title");
        if (string5 == null) {
            string5 = string2.substring(string2.lastIndexOf(File.separator));
        }
        FileWriter fileWriter = new FileWriter(new File(string2, string3));
        XMLWriter xMLWriter = new XMLWriter(fileWriter, null, null, "");
        xMLWriter.appendElement("Book");
        xMLWriter.appendElement("bookData");
        xMLWriter.appendAndCloseElement("bookTitle", string5);
        int n3 = this.imageDimensionMap.size();
        xMLWriter.appendAndCloseElement("leafCount", String.valueOf(n3));
        xMLWriter.appendAndCloseElement("startLeafNumber", n2);
        xMLWriter.closeElement("bookData");
        xMLWriter.appendElement("pageData");
        for (int i = 0; i < n3; ++i) {
            xMLWriter.appendElement("page", new String[]{"leafNum"}, new String[]{String.valueOf(n2 + i)}, null, false);
            if (n == n2 + i) {
                xMLWriter.appendAndCloseElement("pageType", "Title");
            }
            xMLWriter.appendAndCloseElement("origWidth", String.valueOf((int)((Dimension)this.imageDimensionMap.get(i)).getWidth()));
            xMLWriter.appendAndCloseElement("origHeight", String.valueOf((int)((Dimension)this.imageDimensionMap.get(i)).getHeight()));
            xMLWriter.closeElement("page");
        }
        xMLWriter.closeElement("pageData");
        xMLWriter.closeElement("Book");
        xMLWriter.flush();
        ((Writer)fileWriter).close();
    }

    private void generateMetaData(String string) throws IOException {
        String string2 = string.substring(string.lastIndexOf(File.separator) + 1) + "_meta.xml";
        File file = new File(string, string2);
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    private void removeTmpFolders(String string, List list) {
        File[] fileArray;
        File file = new File(string);
        if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length != 0) {
            for (int i = fileArray.length; i > 0; --i) {
                if (list != null && list.contains(fileArray[i - 1].getName())) continue;
                if (fileArray[i - 1].isDirectory() && fileArray[i - 1].list() != null) {
                    this.removeTmpFolders(fileArray[i - 1].getPath(), list);
                    fileArray[i - 1].delete();
                    continue;
                }
                fileArray[i - 1].delete();
            }
        }
    }

    private void copyMiscFiles(String string, String string2) throws Exception {
        File[] fileArray;
        File file = new File(string);
        if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length != 0) {
            for (int i = fileArray.length; i > 0; --i) {
                int n;
                if (fileArray[i - 1].isDirectory() || fileArray[i - 1].isHidden()) continue;
                FileInputStream fileInputStream = new FileInputStream(fileArray[i - 1]);
                FileOutputStream fileOutputStream = new FileOutputStream(string2 + File.separator + fileArray[i - 1].getName());
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    private void loadBookProperties(String string) throws IOException {
        File file = new File(string, this.bookPropertiesFile);
        if (file.exists()) {
            this.bookProperties.load(new FileInputStream(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildBook(String string, String string2) throws Exception {
        try {
            ArrayList<String> arrayList;
            BookBuilder.debugOut("Book src dir = " + string);
            this.loadBookProperties(string);
            String string3 = (String)this.bookProperties.get("BookIdentifier");
            if (string3 == null) {
                string3 = string.substring(string.lastIndexOf(File.separator) + 1);
            }
            string3.replace(' ', '_');
            string2 = string2 + File.separator + string3;
            File file = new File(string2);
            BookBuilder.debugOut("Book dir  " + file.getPath() + " exists? = " + file.exists());
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    throw new Exception("Dest folder could not be created -" + string2);
                }
            } else {
                this.removeTmpFolders(string2, null);
                BookBuilder.debugOut("Book temp dir  " + file.getPath() + " is cleared");
            }
            try {
                this.processImages(string + File.separator + "images", string2);
                BookBuilder.debugOut("processed images");
                File file2 = new File(string2 + File.separator + string2.substring(string2.lastIndexOf(File.separator) + 1) + "_" + this.imageFormat + ".zip");
                file2.createNewFile();
                Object var7_7 = null;
                arrayList = new ArrayList<String>(2);
                arrayList.add("JP2K");
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ArrayList<String> arrayList2 = new ArrayList<String>(2);
                arrayList2.add("JP2K");
                arrayList2.add(string2.substring(string2.lastIndexOf(File.separator) + 1) + "_" + this.imageFormat + ".zip");
                this.removeTmpFolders(string2, arrayList2);
                throw throwable;
            }
            arrayList.add(string2.substring(string2.lastIndexOf(File.separator) + 1) + "_" + this.imageFormat + ".zip");
            this.removeTmpFolders(string2, arrayList);
            this.generateScanData(string, string2, "scandata.xml");
            this.generateMetaData(string2);
            this.copyMiscFiles(string, string2);
            BookBuilder.debugOut("Book processing complete");
            return file.getPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BookBuilder.debugOut(exception.toString());
            throw exception;
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        BookBuilder bookBuilder = new BookBuilder();
        long l = new Date().getTime();
        try {
            bookBuilder.processImages(string, string3);
            long l2 = new Date().getTime();
            bookBuilder.generateImageZip(string3);
            long l3 = new Date().getTime();
            bookBuilder.generateScanData(string, string3, "scandata.xml");
            bookBuilder.generateMetaData(string3);
            BookBuilder.debugOut("Total time for jp conversion- " + (l2 - l));
            BookBuilder.debugOut("Total time for  zip - " + (l3 - l2));
            BookBuilder.debugOut("*************************************************************************************");
        }
        catch (Exception exception) {
            BookBuilder.debugOut("Exception while processing the images - " + exception.toString());
        }
    }

    public String getBmpFolderName() {
        return "bmp";
    }

    public static void debugOut(String string) {
        BookBuilder.debugOut(string, 0);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("BookBuilder: " + string, n);
    }
}

