/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.util;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.util.BookManager;
import com.luna.insight.server.util.DownloadManager;
import com.luna.insight.server.util.ZipFileReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchiveBookManager
extends BookManager {
    private String bookThumbnailImagePath = null;
    private int bookThumbnailImageHeight = 0;
    private int bookThumbnailImageWidth = 0;
    private String server;
    private String itemPath;
    private String imageZipFile;
    private String downloadBookUrl;
    private String imageFormat;
    private String bookTitle;
    private String pageUrlPrefix;
    private int coverLeafNumber;
    private int coverPageHeight;
    private int coverPageWidth;
    private int titleLeafNumber;
    private int titlePageHeight;
    private int titlePageWidth;
    private int totalLeaf = 0;
    private List pageHeights;
    private List pageWidths;
    private List mappedPageNum;
    private List leafNumbers;
    private String pageProgression;
    private String localBookDir;

    public static void debugOut(String string) {
        ArchiveBookManager.debugOut(string, 0);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("SourceMediaItem: " + string, n);
    }

    private boolean downloadOnlineBookDetails(String string) throws Exception {
        String string2 = null;
        String string3 = null;
        try {
            JSONObject jSONObject = ArchiveBookManager.getBookMediaDetails(string);
            String string4 = null;
            String string5 = null;
            if (!jSONObject.has("metadata")) {
                return false;
            }
            string5 = jSONObject.getJSONObject("metadata").getJSONArray("identifier").getString(0);
            this.bookTitle = jSONObject.getJSONObject("metadata").getJSONArray("title").getString(0);
            this.server = jSONObject.getString("server");
            this.itemPath = jSONObject.getString("dir");
            ArchiveBookManager.debugOut("tempDirectory = " + this.localBookDir + " , identifier = " + string5);
            this.localBookDir = this.localBookDir.concat(File.separator + string5);
            if (!jSONObject.has("files")) {
                return false;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("files");
            JSONArray jSONArray = jSONObject2.names();
            if (string.indexOf("#") > -1) {
                string = string.substring(0, string.indexOf("#"));
            }
            if (string.indexOf("?") > -1) {
                string = string.substring(0, string.indexOf("?"));
            }
            String string6 = string.substring(string.lastIndexOf("/") + 1);
            double d = 0.0;
            String string7 = null;
            for (int i = jSONArray.length(); i > 0; --i) {
                if (jSONArray.getString(i - 1).indexOf("scandata.") > -1) {
                    if (string2 == null) {
                        string2 = jSONArray.getString(i - 1);
                        continue;
                    }
                    if (string2.endsWith(string6.concat("_scandata.xml"))) continue;
                    string2 = jSONArray.getString(i - 1);
                    continue;
                }
                if (jSONArray.getString(i - 1).indexOf("_jp2.zip") > -1) {
                    if (!jSONArray.getString(i - 1).endsWith(string6.concat("_jp2.zip"))) continue;
                    string3 = jSONArray.getString(i - 1);
                    this.imageFormat = "jp2";
                    continue;
                }
                if (string3 == null && jSONArray.getString(i - 1).indexOf("_tif.zip") > -1) {
                    if (!jSONArray.getString(i - 1).endsWith(string6.concat("_tif.zip"))) continue;
                    string3 = jSONArray.getString(i - 1);
                    this.imageFormat = "tif";
                    continue;
                }
                if (jSONArray.getString(i - 1).toLowerCase().indexOf(".pdf") > -1) {
                    if (d == 0.0) {
                        this.downloadBookUrl = "http://www.archive.org/download/" + string5 + jSONArray.getString(i - 1);
                        d = jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size");
                        continue;
                    }
                    if (!(jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size") > d)) continue;
                    this.downloadBookUrl = "http://www.archive.org/download/" + string5 + jSONArray.getString(i - 1);
                    d = jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size");
                    continue;
                }
                if (!jSONArray.getString(i - 1).toLowerCase().endsWith("meta.xml")) continue;
                string7 = "http://" + jSONObject.getString("server") + jSONObject.getString("dir") + jSONArray.getString(i - 1);
            }
            this.pageUrlPrefix = "http://" + this.server + "/BookReader/BookReaderImages.php";
            this.imageZipFile = jSONObject.getString("dir") + string3;
            string4 = "http://" + jSONObject.getString("server") + jSONObject.getString("dir") + string2;
            string4 = string2.indexOf(".xml") < 0 ? "http://www.archive.org/download/" + string5 + "/scandata.zip/scandata.xml" : "http://" + jSONObject.getString("server") + jSONObject.getString("dir") + string2;
            ArchiveBookManager.debugOut("****" + string4);
            this.loadMetaData(string7);
            DownloadManager.downloadFile(string4, this.localBookDir, "scandata.xml");
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ArchiveBookManager.debugOut("Error while downloading book details for url - " + string + "\n" + InsightUtilities.getStackTrace(exception));
            throw exception;
        }
    }

    private String findTitleImage(String string) throws Exception {
        String string2 = null;
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setValidation(false);
        sAXBuilder.setIgnoringElementContentWhitespace(true);
        try {
            Document document = sAXBuilder.build(new File(string, "scandata.xml"));
            Element element = document.getRootElement();
            Namespace namespace = element.getNamespace();
            Element element2 = element.getChild("bookData", namespace);
            int n = Integer.parseInt(element2.getChildTextTrim("leafCount", namespace));
            if (n > 0) {
                Element element3 = element.getChild("pageData", namespace);
                List list = element3.getChildren("page", namespace);
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && string2 == null) {
                    Element element4 = (Element)iterator.next();
                    String string3 = element4.getAttributeValue("leafNum").trim();
                    if (!"Title".equalsIgnoreCase(element4.getChildTextTrim("pageType", namespace)) && !"Title Page".equalsIgnoreCase(element4.getChildTextTrim("pageType", namespace))) continue;
                    string2 = string3;
                    this.bookThumbnailImageHeight = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("h", namespace)).intValue();
                    this.bookThumbnailImageWidth = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("w", namespace)).intValue();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw numberFormatException;
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            throw jDOMException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        return string2;
    }

    private String findCoverImage(String string) throws Exception {
        String string2 = null;
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setValidation(false);
        sAXBuilder.setIgnoringElementContentWhitespace(true);
        try {
            Document document = sAXBuilder.build(new File(string, "scandata.xml"));
            Element element = document.getRootElement();
            Namespace namespace = element.getNamespace();
            Element element2 = element.getChild("bookData", namespace);
            int n = Integer.parseInt(element2.getChildTextTrim("leafCount", namespace));
            if (n > 0) {
                Element element3 = element.getChild("pageData", namespace);
                List list = element3.getChildren("page", namespace);
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && string2 == null) {
                    Element element4 = (Element)iterator.next();
                    String string3 = element4.getAttributeValue("leafNum").trim();
                    if (!"Cover".equalsIgnoreCase(element4.getChildTextTrim("pageType", namespace))) continue;
                    string2 = string3;
                    this.bookThumbnailImageHeight = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("h", namespace)).intValue();
                    this.bookThumbnailImageWidth = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("w", namespace)).intValue();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw numberFormatException;
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            throw jDOMException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractBookThumbnailImage(String string, String string2) throws Exception {
        boolean bl = false;
        File file = new File(string);
        String[] stringArray = file.list();
        String string3 = null;
        for (int i = stringArray.length; i > 0; --i) {
            Serializable serializable2;
            FilterOutputStream filterOutputStream;
            FileOutputStream fileOutputStream;
            block22: {
                Object var17_17;
                if (!stringArray[i - 1].endsWith(".zip")) continue;
                string3 = stringArray[i - 1].indexOf("_jp2.zip") > -1 ? "jp2" : "tif";
                StringBuffer stringBuffer = new StringBuffer("000");
                stringBuffer.append(string2);
                if (stringBuffer.length() > 4) {
                    int n = stringBuffer.length() - 4;
                    stringBuffer.delete(0, n);
                }
                stringBuffer.append("." + string3);
                stringBuffer.insert(0, stringArray[i - 1].substring(0, stringArray[i - 1].indexOf("_" + string3) + 1));
                ZipFileReader zipFileReader = new ZipFileReader(string + File.separator + stringArray[i - 1]);
                BufferedInputStream bufferedInputStream = null;
                fileOutputStream = null;
                filterOutputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(zipFileReader.getInternalFile(stringArray[i - 1].substring(0, stringArray[i - 1].indexOf(".zip")) + "/" + stringBuffer));
                    File file2 = new File(string, stringArray[i - 1].substring(0, stringArray[i - 1].indexOf(".zip")) + "." + string3);
                    fileOutputStream = new FileOutputStream(file2);
                    filterOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                    ((BufferedOutputStream)filterOutputStream).flush();
                    this.bookThumbnailImagePath = file2.getPath();
                    bl = true;
                    var17_17 = null;
                    if (bufferedInputStream == null) break block22;
                }
                catch (Throwable throwable) {
                    var17_17 = null;
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Exception serializable2) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception serializable2) {
                            // empty catch block
                        }
                    }
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception serializable2) {
                            // empty catch block
                        }
                    }
                    try {
                        serializable2 = new File(string, stringArray[i - 1]);
                        ((File)serializable2).delete();
                    }
                    catch (Exception serializable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    bufferedInputStream.close();
                }
                catch (Exception serializable2) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception serializable2) {
                    // empty catch block
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception serializable2) {
                    // empty catch block
                }
            }
            try {
                serializable2 = new File(string, stringArray[i - 1]);
                ((File)serializable2).delete();
            }
            catch (Exception serializable2) {}
        }
        return bl;
    }

    public boolean downloadImage(int n, String string) throws Exception {
        return this.downloadImage(n, 0, string);
    }

    public boolean downloadImage(int n, int n2, String string) throws Exception {
        try {
            DownloadManager.downloadFile(this.getImageUrlByLeafNumber(n, n2), this.localBookDir, string);
            this.bookThumbnailImagePath = this.localBookDir + File.separator + string;
            return true;
        }
        catch (Exception exception) {
            ArchiveBookManager.debugOut("Exception while downloading the image - " + n + InsightUtilities.getStackTrace(exception));
            throw exception;
        }
    }

    public String getImageUrlByLeafNumber(int n, int n2) {
        return this.pageUrlPrefix + "?zip=" + this.imageZipFile + "&file=" + this.getFile(n) + "&scale=" + n2;
    }

    public String getImageUrlByLeafNumber(int n, int n2, String string, String string2, String string3) {
        this.pageUrlPrefix = string;
        this.imageZipFile = string2;
        this.imageFormat = string3;
        return this.getImageUrlByLeafNumber(n, n2);
    }

    public static String getBookDetailsUrl(String string) throws Exception {
        if (string.indexOf("#") > -1) {
            string = string.substring(0, string.indexOf("#"));
        }
        if (string.indexOf("?") > -1) {
            string = string.substring(0, string.indexOf("?"));
        }
        String string2 = new URL(string).getPath();
        StringBuffer stringBuffer = new StringBuffer((string2 = string.substring(0, string.indexOf(string2)) + string2).replaceAll("/stream/", "/details/"));
        int n = stringBuffer.indexOf("/", stringBuffer.indexOf("/details/") + 9);
        if (n > -1) {
            return stringBuffer.substring(0, n);
        }
        return stringBuffer.toString();
    }

    private static JSONObject getBookMediaDetails(String string) throws Exception {
        String string2 = ArchiveBookManager.getBookDetailsUrl(string);
        if (string2 == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(DownloadManager.readBookDetails(string2 + "&output=json"));
        return jSONObject;
    }

    public String getImageUrl(int n) {
        return this.getImageUrlByLeafNumber(n, 0);
    }

    private String getFile(int n) {
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer("000");
        stringBuffer.append(n);
        if (stringBuffer.length() > 4) {
            int n2 = stringBuffer.length() - 4;
            stringBuffer.delete(0, n2);
        }
        stringBuffer.append("." + this.imageFormat);
        String string = null;
        string = this.imageZipFile.lastIndexOf("/") > -1 ? this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_" + this.imageFormat)) : this.imageZipFile.substring(0, this.imageZipFile.lastIndexOf("_" + this.imageFormat));
        stringBuffer.insert(0, string + "_" + this.imageFormat + "/" + string + "_");
        return stringBuffer.toString();
    }

    public boolean processArchiveBook(String string, String string2, boolean bl, boolean bl2) throws Exception {
        this.localBookDir = string2;
        int n = string.lastIndexOf("$$lunaThumbnail=");
        String string3 = "1";
        if (n != -1) {
            string3 = string.substring(string.indexOf("=", n) + 1);
            string = string.substring(0, n);
        }
        if (!this.downloadOnlineBookDetails(string)) {
            return false;
        }
        if (!bl2) {
            this.extractBookDetails();
            if (bl) {
                if (string3.equals("T")) {
                    this.bookThumbnailImageHeight = this.titlePageHeight;
                    this.bookThumbnailImageWidth = this.titlePageWidth;
                    this.bookThumbnailImagePath = this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_") + 1) + this.titleLeafNumber + ".jpg";
                    return this.downloadImage(this.titleLeafNumber, this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_") + 1) + this.titleLeafNumber + ".jpg");
                }
                if (string3.equals("C")) {
                    this.bookThumbnailImageHeight = this.coverPageHeight;
                    this.bookThumbnailImageWidth = this.coverPageWidth;
                    this.bookThumbnailImagePath = this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_") + 1) + this.coverLeafNumber + ".jpg";
                    return this.downloadImage(this.coverLeafNumber, this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_") + 1) + this.coverLeafNumber + ".jpg");
                }
                this.bookThumbnailImagePath = this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_") + 1) + string3 + ".jpg";
                return this.downloadImage(Integer.parseInt(string3), this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_") + 1) + string3 + ".jpg");
            }
        }
        return true;
    }

    public boolean processArchiveBook(String string, String string2, boolean bl) throws Exception {
        boolean bl2 = true;
        if (bl) {
            bl2 = false;
        }
        return this.processArchiveBook(string, string2, bl, bl2);
    }

    private void extractBookDetails() throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setValidation(false);
        sAXBuilder.setIgnoringElementContentWhitespace(true);
        try {
            Document document = sAXBuilder.build(new File(this.localBookDir, "scandata.xml"));
            Element element = document.getRootElement();
            Namespace namespace = element.getNamespace();
            Element element2 = element.getChild("bookData", namespace);
            int n = Integer.parseInt(element2.getChildTextTrim("leafCount", namespace));
            if (n > 0) {
                Element element3 = element.getChild("pageData", namespace);
                this.pageHeights = new ArrayList(n);
                this.pageWidths = new ArrayList(n);
                this.mappedPageNum = new ArrayList(n);
                this.leafNumbers = new ArrayList(n);
                List list = element3.getChildren("page", namespace);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Element element4 = (Element)iterator.next();
                    if ("false".equalsIgnoreCase(element4.getChildTextTrim("addToAccessFormats", namespace))) continue;
                    ++this.totalLeaf;
                    String string = element4.getAttributeValue("leafNum").trim();
                    this.leafNumbers.add(string);
                    this.pageHeights.add(element4.getChild("cropBox", namespace).getChildTextTrim("h", namespace));
                    this.pageWidths.add(element4.getChild("cropBox", namespace).getChildTextTrim("w", namespace));
                    if (element4.getChildTextTrim("pageNumber") != null) {
                        this.mappedPageNum.add(element4.getChildTextTrim("pageNumber", namespace));
                    } else {
                        this.mappedPageNum.add("");
                    }
                    if ("cover".equalsIgnoreCase(element4.getChildTextTrim("pageType", namespace))) {
                        this.coverLeafNumber = Integer.parseInt(string);
                        this.coverPageHeight = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("h", namespace)).intValue();
                        this.coverPageWidth = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("w", namespace)).intValue();
                        continue;
                    }
                    if (!"title".equalsIgnoreCase(element4.getChildTextTrim("pageType", namespace)) && !"title Page".equalsIgnoreCase(element4.getChildTextTrim("pageType", namespace))) continue;
                    this.titleLeafNumber = Integer.parseInt(string);
                    this.titlePageHeight = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("h", namespace)).intValue();
                    this.titlePageWidth = Float.valueOf(element4.getChild("cropBox", namespace).getChildTextTrim("w", namespace)).intValue();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw numberFormatException;
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            throw jDOMException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    private void loadMetaData(String string) throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setValidation(false);
        sAXBuilder.setIgnoringElementContentWhitespace(true);
        try {
            Document document = sAXBuilder.build(string);
            Element element = document.getRootElement();
            Namespace namespace = element.getNamespace();
            if (element.getChildTextTrim("page-progression", namespace) != null) {
                this.pageProgression = element.getChildTextTrim("page-progression", namespace);
            }
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
            throw jDOMException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public static String setPageInUrl(String string, int n) {
        if (string.lastIndexOf("#") < 0) {
            return string.concat("#page/n" + n);
        }
        int n2 = string.indexOf("page/", string.indexOf("#"));
        if (n2 > 0) {
            if (string.indexOf("/", n2 + 6) > -1) {
                return string.substring(0, n2) + "page/n" + n + string.substring(string.indexOf("/", n2 + 6));
            }
            return string.substring(0, n2) + "page/n" + n;
        }
        return string.concat("/page/n" + n);
    }

    public Map getBookProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zip", this.imageZipFile);
        hashMap.put("imageFormat", this.imageFormat);
        hashMap.put("title", this.bookTitle);
        hashMap.put("totalLeafs", String.valueOf(this.totalLeaf));
        hashMap.put("pageHeights", this.pageHeights);
        hashMap.put("pageWidths", this.pageWidths);
        hashMap.put("mappedPage", this.mappedPageNum);
        hashMap.put("leafNumbers", this.leafNumbers);
        hashMap.put("server", this.server);
        hashMap.put("itemPath", this.itemPath);
        hashMap.put("downloadBookUrl", this.downloadBookUrl);
        if (this.pageProgression != null) {
            hashMap.put("pageProgression", this.pageProgression);
        } else {
            hashMap.put("pageProgression", "lr");
        }
        hashMap.put("pageUrlPrefix", "http://" + this.server + "/BookReader/BookReaderImages.php");
        if (this.titleLeafNumber > 0) {
            hashMap.put("titleLeaf", String.valueOf(this.titleLeafNumber));
            hashMap.put("titlePageHeight", String.valueOf(this.titlePageHeight));
            hashMap.put("titlePageWidth", String.valueOf(this.titlePageWidth));
        }
        hashMap.put("subPrefix", this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_" + this.imageFormat)));
        return hashMap;
    }

    public Map setBookProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zip", this.imageZipFile);
        hashMap.put("imageFormat", this.imageFormat);
        hashMap.put("title", this.bookTitle);
        hashMap.put("totalLeafs", String.valueOf(this.totalLeaf));
        hashMap.put("pageHeights", this.pageHeights);
        hashMap.put("pageWidths", this.pageWidths);
        hashMap.put("mappedPage", this.mappedPageNum);
        hashMap.put("leafNumbers", this.leafNumbers);
        hashMap.put("server", this.server);
        hashMap.put("pageUrlPrefix", this.pageUrlPrefix);
        if (this.titleLeafNumber > 0) {
            hashMap.put("titleLeaf", String.valueOf(this.titleLeafNumber));
            hashMap.put("titlePageHeight", String.valueOf(this.titlePageHeight));
            hashMap.put("titlePageWidth", String.valueOf(this.titlePageWidth));
        }
        hashMap.put("subPrefix", this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_" + this.imageFormat)));
        return hashMap;
    }

    private static String getBookDownloadUrl(String string, String string2, boolean bl) {
        try {
            JSONObject jSONObject = ArchiveBookManager.getBookMediaDetails(string);
            String string3 = null;
            if (!jSONObject.has("metadata") || !jSONObject.has("files")) {
                return null;
            }
            string3 = jSONObject.getJSONObject("metadata").getJSONArray("identifier").getString(0);
            JSONObject jSONObject2 = jSONObject.getJSONObject("files");
            JSONArray jSONArray = jSONObject2.names();
            String string4 = null;
            double d = 0.0;
            for (int i = jSONArray.length(); i > 0; --i) {
                if (jSONArray.getString(i - 1).toLowerCase().indexOf("." + string2) <= -1) continue;
                if (d == 0.0) {
                    string4 = "http://www.archive.org/download/" + string3 + jSONArray.getString(i - 1);
                    d = jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size");
                    continue;
                }
                if (bl) {
                    if (!(jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size") > d)) continue;
                    string4 = "http://www.archive.org/download/" + string3 + jSONArray.getString(i - 1);
                    d = jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size");
                    continue;
                }
                if (!(jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size") < d)) continue;
                string4 = "http://www.archive.org/download/" + string3 + jSONArray.getString(i - 1);
                d = jSONObject2.getJSONObject(jSONArray.getString(i - 1)).getDouble("size");
            }
            return string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String constructBookTextURL(String string) {
        return ArchiveBookManager.getBookDownloadUrl(string, "txt", false);
    }

    public static String constructBookPdfURL(String string) {
        return ArchiveBookManager.getBookDownloadUrl(string, "pdf", false);
    }

    public static String constructBookTextURL(String string, boolean bl) {
        return ArchiveBookManager.getBookDownloadUrl(string, "txt", bl);
    }

    public static String constructBookPdfURL(String string, boolean bl) {
        return ArchiveBookManager.getBookDownloadUrl(string, "pdf", bl);
    }

    public String getBookName() {
        if (this.imageZipFile != null) {
            return this.imageZipFile.substring(this.imageZipFile.lastIndexOf("/") + 1, this.imageZipFile.lastIndexOf("_"));
        }
        return null;
    }

    public String getBookThumbnailImagePath() {
        return this.bookThumbnailImagePath;
    }

    public void setBookThumbnailImagePath(String string) {
        this.bookThumbnailImagePath = string;
    }

    public int getBookThumbnailImageHeight() {
        return this.bookThumbnailImageHeight;
    }

    public int getBookThumbnailImageWidth() {
        return this.bookThumbnailImageWidth;
    }

    public int getTotalLeaf() {
        return this.totalLeaf;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }
}

