/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.usergroup;

import com.luna.insight.server.ThumbnailQueryCache;
import com.luna.insight.server.usergroup.UserGroup;
import com.luna.insight.server.usergroup.UserGroupConnectionKey;

public class UserGroupConnection {
    public static final int DEFAULT_TIMEOUT = 3600;
    protected UserGroup userGroup;
    protected String ipAddress;
    protected String localIPAddress;
    protected long lastHeardFrom;
    protected long timeOutMillis;
    protected boolean reservedConnection = false;
    protected ThumbnailQueryCache thumbQueryCache = new ThumbnailQueryCache();

    public UserGroupConnection(String string, String string2, UserGroup userGroup, int n, boolean bl) {
        this.ipAddress = string;
        this.localIPAddress = string2;
        this.userGroup = userGroup;
        this.timeOutMillis = n * 1000;
        this.reservedConnection = bl;
        this.heardFrom();
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getLocalIPAddress() {
        return this.localIPAddress;
    }

    public boolean isUsingReservedConnection() {
        return this.reservedConnection;
    }

    public boolean equals(Object object) {
        if (object instanceof UserGroupConnectionKey) {
            UserGroupConnectionKey userGroupConnectionKey = (UserGroupConnectionKey)object;
            return this.ipAddress != null && this.localIPAddress != null && userGroupConnectionKey.ipAddress != null && userGroupConnectionKey.localIPAddress != null && this.ipAddress.equals(userGroupConnectionKey.ipAddress) && this.localIPAddress.equals(userGroupConnectionKey.localIPAddress) && this.userGroup != null && userGroupConnectionKey.getUserGroup() != null && this.userGroup.equals(userGroupConnectionKey.getUserGroup());
        }
        return false;
    }

    public void heardFrom() {
        this.lastHeardFrom = System.currentTimeMillis();
    }

    public boolean isTimedOut() {
        return this.lastHeardFrom + this.timeOutMillis < System.currentTimeMillis();
    }

    public UserGroup getUserGroup() {
        return this.userGroup;
    }

    public String getGroupName() {
        return this.userGroup.getGroupName();
    }

    public String getCodeKey() {
        return this.userGroup.getGroupCodeKey();
    }

    public ThumbnailQueryCache getThumbnailQueryCache() {
        return this.thumbQueryCache;
    }
}

