/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.ucb;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ucb.FuzzyDateJulianRange;
import edu.berkeley.mip.FuzzyDateMachine.FuzzyDate;
import edu.berkeley.mip.FuzzyDateMachine.FuzzyDateMachine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UcbFuzzyDateMachine {
    public static final String COMPONENT_CODE = "Fuzzy Date";
    protected static final SimpleDateFormat DEBUG_DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    protected static final String DEFAULT_FZ_DEBUG_FILE;
    public static final long EXCESSIVE_FILE_SIZE = 2000000L;
    protected static String fzDebugFilename;
    protected static long dateNumber;

    public static void debugOut(String string) {
        UcbFuzzyDateMachine.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UcbFuzzyDateMachine: " + string, n);
    }

    public static void setFZDebugFilename(String string) {
        fzDebugFilename = string;
    }

    public static void fzDebugFile(String string) {
        if (fzDebugFilename != null) {
            try {
                Comparable<Date> comparable;
                if (dateNumber % 500L == 0L && ((File)(comparable = new File(fzDebugFilename))).exists() && ((File)comparable).length() > 2000000L) {
                    ((File)comparable).delete();
                }
                comparable = new Date();
                String string2 = DEBUG_DATE_FORMAT.format((Date)comparable) + " " + COMPONENT_CODE + ": " + string;
                FileWriter fileWriter = new FileWriter(fzDebugFilename, true);
                fileWriter.write(string2 + "\r\n");
                fileWriter.flush();
                fileWriter.close();
                ++dateNumber;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static FuzzyDateJulianRange getFuzzyDateJulianRange(String string) {
        FuzzyDateJulianRange fuzzyDateJulianRange = null;
        try {
            if (string != null) {
                FuzzyDate fuzzyDate = FuzzyDateMachine.getFuzzyDate(string);
                if (fuzzyDate != null) {
                    fuzzyDateJulianRange = new FuzzyDateJulianRange(fuzzyDate.getStartJulian(), fuzzyDate.getEndJulian());
                } else {
                    String string2 = "Fuzzy date julian range could not be calculated for " + string + ".";
                    UcbFuzzyDateMachine.debugOut(string2);
                    UcbFuzzyDateMachine.fzDebugFile(string2);
                }
            }
        }
        catch (Exception exception) {
            UcbFuzzyDateMachine.debugOut("Exception in getFuzzyDateJulianRange():\n" + InsightUtilities.convertStackTraceToString(exception));
            fuzzyDateJulianRange = null;
        }
        catch (Error error) {
            UcbFuzzyDateMachine.debugOut("Error in getFuzzyDateJulianRange():\n" + InsightUtilities.convertStackTraceToString(error));
            fuzzyDateJulianRange = null;
        }
        return fuzzyDateJulianRange;
    }

    static {
        fzDebugFilename = DEFAULT_FZ_DEBUG_FILE = null;
        dateNumber = 0L;
    }
}

