/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.support.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KDecodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageDecoder;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.core.jpeg2000.JPEG2KException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JPEG2KExtractServlet
extends HttpServlet {
    public static PrintWriter pw = null;
    public String jp2kfilesource = "";
    public String fout = "";

    public static void debugOut(String string) {
        if (pw == null) {
            System.out.println(string);
        } else {
            pw.println(string + "<BR>");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void error(Throwable throwable) {
        pw.println("<FONT COLOR=RED><pre>");
        throwable.printStackTrace(pw);
        pw.println("</pre></FONT><BR>");
    }

    public void error(String string) {
        pw.println("<FONT COLOR=RED>" + string + "</FONT><BR>");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (servletConfig.getInitParameter("sourceDir") != null && servletConfig.getInitParameter("sourceDir").trim().length() > 1) {
            this.jp2kfilesource = servletConfig.getInitParameter("sourceDir");
        }
        if (servletConfig.getInitParameter("outDir") != null && servletConfig.getInitParameter("outDir").trim().length() > 1) {
            this.fout = servletConfig.getInitParameter("outDir") + "/test.jpg";
        }
    }

    public static void debugOut(IJPEG2KDecodeParam iJPEG2KDecodeParam) {
        JPEG2KExtractServlet.debugOut("----------------------------------------");
        JPEG2KExtractServlet.debugOut("----------------------------------------");
    }

    public static void extractImage(String string, String string2, IJPEG2KDecodeParam iJPEG2KDecodeParam) throws IOException, JPEG2KException {
        long l = System.currentTimeMillis();
        FileInputStream fileInputStream = new FileInputStream(string);
        IJPEG2KImageDecoder iJPEG2KImageDecoder = JPEG2KCodec.createJPEG2KDecoder(string, iJPEG2KDecodeParam);
        BufferedImage bufferedImage = iJPEG2KImageDecoder.decodeAsBufferedImage();
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
        if (bufferedImage != null) {
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            fileOutputStream = new FileOutputStream(string2);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            int n = 15;
            if (n < 0) {
                n = 0;
            } else if (n > 100) {
                n = 100;
            }
            float f = 1.0f - (float)n / 100.0f;
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            bufferedImage.flush();
            bufferedImage = null;
            bufferedOutputStream.close();
            long l4 = System.currentTimeMillis();
        }
        fileInputStream.close();
    }

    public static int parseInt(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        pw = httpServletResponse.getWriter();
        pw.println("<HTML><HEAD></HEAD><BODY bgcolor=\"WHITE\">");
        pw.println("java.library.path: " + System.getProperty("java.library.path"));
        pw.println("<hr>");
        File file = new File(this.fout);
        file.delete();
        try {
            JPEG2KCodec.configure();
            String string = "sample.jp2";
            if (httpServletRequest.getParameter("src") != null && httpServletRequest.getParameter("src").length() > 1) {
                string = httpServletRequest.getParameter("src");
            }
            String string2 = this.jp2kfilesource + "/" + string;
            String string3 = this.fout;
            int n = JPEG2KExtractServlet.parseInt(httpServletRequest.getParameter("lrf"), 0);
            int n2 = JPEG2KExtractServlet.parseInt(httpServletRequest.getParameter("y"), 0);
            int n3 = JPEG2KExtractServlet.parseInt(httpServletRequest.getParameter("x"), 0);
            int n4 = JPEG2KExtractServlet.parseInt(httpServletRequest.getParameter("h"), 100);
            int n5 = JPEG2KExtractServlet.parseInt(httpServletRequest.getParameter("w"), 100);
            String string4 = "{" + n2 + "," + n3 + "},{" + n4 + "," + n5 + "}";
            JPEG2KExtractServlet.debugOut("input: " + string2 + "  output=" + string3);
            IJPEG2KDecodeParam iJPEG2KDecodeParam = JPEG2KCodec.getDefaultJPEG2KDecodeParam();
            iJPEG2KDecodeParam.setLevelReductionFactor(n);
            iJPEG2KDecodeParam.setRegion(string4);
            JPEG2KExtractServlet.extractImage(string2, string3, iJPEG2KDecodeParam);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.error(throwable);
        }
        pw.println("<h4>TEST IMAGE</h4>");
        pw.println("<img src=\"" + httpServletRequest.getContextPath() + "/temp/test.jpg\">");
        pw.println("</BODY></HTML>");
    }
}

