/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.Context;
import com.luna.insight.server.security.MediaSecurityConstants;
import java.io.File;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class MediaDeleteHandler
implements MediaSecurityConstants {
    protected String fileRootDir = "";
    protected String securityKey = "";
    protected boolean enableMediaDelete = false;

    public static void debugOut(String string) {
        MediaDeleteHandler.debugOut(string, null, 2);
    }

    public static void debugOut(String string, Context context) {
        MediaDeleteHandler.debugOut(string, context, 2);
    }

    public static void debugOut(String string, Context context, int n) {
        if (context == null) {
            Debug.debugOut("MediaDeleteHandler: " + string, n);
        } else {
            Debug.debugOut("MDelHndlr(" + context.getClientIP() + "): " + string, n);
        }
    }

    public void configure(EnhancedProperties enhancedProperties) {
        try {
            this.fileRootDir = enhancedProperties.getProperty("MediaFileRootDir", "");
            this.fileRootDir = File.separatorChar == '\\' ? this.fileRootDir.replace('/', File.separatorChar) : this.fileRootDir.replace('\\', File.separatorChar);
            MediaDeleteHandler.debugOut("Upload media file root dir: " + this.fileRootDir);
            this.securityKey = enhancedProperties.getProperty("MediaSecurityKey", "");
            MediaDeleteHandler.debugOut("MediaDelete security key = " + this.securityKey);
            this.enableMediaDelete = enhancedProperties.getProperty("MediaDeleteEnabled", "").equalsIgnoreCase("1");
            MediaDeleteHandler.debugOut("MediaDelete mode: " + this.enableMediaDelete);
        }
        catch (Exception exception) {
            MediaDeleteHandler.debugOut("Exception in configure():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public boolean handleRequest(Context context) {
        MediaDeleteHandler.debugOut("Received command: " + context.getCommand(), context);
        MediaDeleteHandler.debugOut("URL request:\n" + context.getRequestSignature(), context);
        if (context.getCommand().equalsIgnoreCase("deletemedia")) {
            return this.handleDelete(context);
        }
        return false;
    }

    protected boolean handleDelete(Context context) {
        MediaDeleteHandler.debugOut("in handleDelete()...");
        if (!this.enableMediaDelete) {
            return true;
        }
        Vector<String> vector = new Vector<String>();
        HttpServletRequest httpServletRequest = context.getRequest();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        boolean bl = false;
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("deletefile")) {
                vector.add(httpServletRequest.getParameter(string));
            }
            if (!string.startsWith("mediasecuritykey")) continue;
            if (!httpServletRequest.getParameter(string).equalsIgnoreCase(URLEncoder.encode(this.securityKey))) {
                MediaDeleteHandler.debugOut("handleDelete(): MediaSecurityKey do not match");
                return true;
            }
            bl = true;
        }
        if (!bl) {
            return true;
        }
        String string2 = "";
        for (int i = 0; i < vector.size(); ++i) {
            try {
                string2 = (String)vector.get(i);
                string2 = File.separatorChar == '\\' ? string2.replace('/', File.separatorChar) : string2.replace('\\', File.separatorChar);
                String string3 = InsightUtilities.concatFilepath(this.fileRootDir, string2);
                MediaDeleteHandler.debugOut("handleDelete(): fullFilePath = " + string3);
                File file = new File(string3);
                boolean bl2 = false;
                if (file.exists()) {
                    bl2 = file.delete();
                }
                MediaDeleteHandler.debugOut("handleDelete(): deleted = " + bl2);
                continue;
            }
            catch (Exception exception) {
                MediaDeleteHandler.debugOut("handleDelete(): Exception while deleting file: \n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return true;
    }
}

