/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.profile;

import com.luna.insight.server.profile.ICollectionProfile;

public class CollectionProfile
implements ICollectionProfile {
    public static final int MAX_DISPLAY_NAME_LENGTH = 50;
    public static final int STUDIO_PROFILE_ADMIN = 0;
    public static final int STUDIO_PROFILE_EDITOR = 1;
    public static final int STUDIO_PROFILE_CATALOGER = 2;
    public static final int STUDIO_PROFILE_GENERAL = 3;
    public static final int STUDIO_PROFILE_RESTRICTED = 4;
    public static final int[] STUDIO_PROFILE_IDS = new int[]{0, 1, 2, 3, 4};
    public static final String STUDIO_PROFILE_ADMIN_NAME = "Admin";
    public static final String STUDIO_PROFILE_EDITOR_NAME = "Editor";
    public static final String STUDIO_PROFILE_CATALOGER_NAME = "Cataloger";
    public static final String STUDIO_PROFILE_GENERAL_NAME = "General";
    public static final String STUDIO_PROFILE_RESTRICTED_NAME = "Restricted";
    public static final String[] STUDIO_PROFILE_NAMES = new String[]{"Admin", "Editor", "Cataloger", "General", "Restricted"};
    public static final int MEDE_PRIVS_ALL_ADMIN = 511;
    public static final int MEDE_PRIVS_ALL = 127;
    public static final int MEDE_PRIVS_ALL_BUT_MEDIA_PROCESSING = 63;
    public static final int MEDE_PRIVS_NONE = 0;
    protected static final CollectionProfile[] STUDIO_PROFILES = new CollectionProfile[5];
    protected int id;
    protected String displayName;
    protected int sps;
    protected int studioProfile;
    protected boolean saveGroup;
    protected boolean deleteGroup;
    protected boolean edit;
    protected boolean print;
    protected boolean editLink;
    protected boolean editMVI;
    protected boolean editMPD;
    protected boolean editVocab;
    protected boolean editPersonalCollections;
    protected boolean HTMLExport;
    protected int maxPresentationExportSize;
    protected int maxViewableSize;
    protected int maxExportSize;
    protected int approvalLevel;
    protected int medePermissions;

    public CollectionProfile(int n, int n2, int n3, String string, Integer n4) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (n3 < 0 || n3 >= STUDIO_PROFILES.length) {
            throw new IllegalArgumentException("invalid studio profile");
        }
        this.id = n;
        this.sps = n2;
        this.studioProfile = n3;
        this.displayName = this.generateDisplayName(string, n4);
    }

    protected CollectionProfile() {
    }

    protected String generateDisplayName(String string, Integer n) {
        String string2 = "-" + n + "-" + STUDIO_PROFILE_NAMES[this.studioProfile];
        if (string.length() > 50 - string2.length()) {
            string = string.substring(0, 50 - string2.length());
        }
        return string + string2;
    }

    public int getApprovalLevel() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].approvalLevel;
    }

    public boolean isDeleteGroup() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].deleteGroup;
    }

    public boolean isEdit() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].edit;
    }

    public boolean isEditLink() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].editLink;
    }

    public boolean isEditMPD() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].editMPD;
    }

    public boolean isEditMVI() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].editMVI;
    }

    public boolean isEditPersonalCollections() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].editPersonalCollections;
    }

    public boolean isEditVocab() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].editVocab;
    }

    public boolean isHTMLExport() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].HTMLExport;
    }

    public int getMaxExportSize() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].maxExportSize;
    }

    public int getMaxPresentationExportSize() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].maxPresentationExportSize;
    }

    public int getMaxViewableSize() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].maxViewableSize;
    }

    public int getMedePermissions() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].medePermissions;
    }

    public boolean isPrint() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].print;
    }

    public boolean isSaveGroup() {
        return CollectionProfile.STUDIO_PROFILES[this.studioProfile].saveGroup;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getId() {
        return this.id;
    }

    public int getSps() {
        return this.sps;
    }

    static {
        CollectionProfile.STUDIO_PROFILES[0] = new CollectionProfile();
        CollectionProfile.STUDIO_PROFILES[0].studioProfile = 0;
        CollectionProfile.STUDIO_PROFILES[0].saveGroup = true;
        CollectionProfile.STUDIO_PROFILES[0].deleteGroup = true;
        CollectionProfile.STUDIO_PROFILES[0].print = true;
        CollectionProfile.STUDIO_PROFILES[0].edit = false;
        CollectionProfile.STUDIO_PROFILES[0].editMVI = true;
        CollectionProfile.STUDIO_PROFILES[0].editMPD = true;
        CollectionProfile.STUDIO_PROFILES[0].editLink = true;
        CollectionProfile.STUDIO_PROFILES[0].editVocab = false;
        CollectionProfile.STUDIO_PROFILES[0].editPersonalCollections = false;
        CollectionProfile.STUDIO_PROFILES[0].HTMLExport = true;
        CollectionProfile.STUDIO_PROFILES[0].maxViewableSize = 8;
        CollectionProfile.STUDIO_PROFILES[0].maxExportSize = 8;
        CollectionProfile.STUDIO_PROFILES[0].approvalLevel = 6;
        CollectionProfile.STUDIO_PROFILES[0].medePermissions = 511;
        CollectionProfile.STUDIO_PROFILES[0].maxPresentationExportSize = 8;
        CollectionProfile.STUDIO_PROFILES[1] = new CollectionProfile();
        CollectionProfile.STUDIO_PROFILES[1].studioProfile = 1;
        CollectionProfile.STUDIO_PROFILES[1].saveGroup = true;
        CollectionProfile.STUDIO_PROFILES[1].deleteGroup = true;
        CollectionProfile.STUDIO_PROFILES[1].print = true;
        CollectionProfile.STUDIO_PROFILES[1].edit = false;
        CollectionProfile.STUDIO_PROFILES[1].editMVI = true;
        CollectionProfile.STUDIO_PROFILES[1].editMPD = true;
        CollectionProfile.STUDIO_PROFILES[1].editLink = true;
        CollectionProfile.STUDIO_PROFILES[1].editVocab = false;
        CollectionProfile.STUDIO_PROFILES[1].editPersonalCollections = false;
        CollectionProfile.STUDIO_PROFILES[1].HTMLExport = true;
        CollectionProfile.STUDIO_PROFILES[1].maxViewableSize = 8;
        CollectionProfile.STUDIO_PROFILES[1].maxExportSize = 8;
        CollectionProfile.STUDIO_PROFILES[1].approvalLevel = 5;
        CollectionProfile.STUDIO_PROFILES[1].medePermissions = 127;
        CollectionProfile.STUDIO_PROFILES[1].maxPresentationExportSize = 8;
        CollectionProfile.STUDIO_PROFILES[2] = new CollectionProfile();
        CollectionProfile.STUDIO_PROFILES[2].studioProfile = 2;
        CollectionProfile.STUDIO_PROFILES[2].saveGroup = false;
        CollectionProfile.STUDIO_PROFILES[2].deleteGroup = false;
        CollectionProfile.STUDIO_PROFILES[2].print = true;
        CollectionProfile.STUDIO_PROFILES[2].edit = false;
        CollectionProfile.STUDIO_PROFILES[2].editMVI = false;
        CollectionProfile.STUDIO_PROFILES[2].editMPD = false;
        CollectionProfile.STUDIO_PROFILES[2].editLink = false;
        CollectionProfile.STUDIO_PROFILES[2].editVocab = false;
        CollectionProfile.STUDIO_PROFILES[2].editPersonalCollections = false;
        CollectionProfile.STUDIO_PROFILES[2].HTMLExport = true;
        CollectionProfile.STUDIO_PROFILES[2].maxViewableSize = 8;
        CollectionProfile.STUDIO_PROFILES[2].maxExportSize = 8;
        CollectionProfile.STUDIO_PROFILES[2].approvalLevel = 4;
        CollectionProfile.STUDIO_PROFILES[2].medePermissions = 63;
        CollectionProfile.STUDIO_PROFILES[2].maxPresentationExportSize = 8;
        CollectionProfile.STUDIO_PROFILES[3] = new CollectionProfile();
        CollectionProfile.STUDIO_PROFILES[3].studioProfile = 3;
        CollectionProfile.STUDIO_PROFILES[3].saveGroup = false;
        CollectionProfile.STUDIO_PROFILES[3].deleteGroup = false;
        CollectionProfile.STUDIO_PROFILES[3].print = true;
        CollectionProfile.STUDIO_PROFILES[3].edit = false;
        CollectionProfile.STUDIO_PROFILES[3].editMVI = false;
        CollectionProfile.STUDIO_PROFILES[3].editMPD = false;
        CollectionProfile.STUDIO_PROFILES[3].editLink = false;
        CollectionProfile.STUDIO_PROFILES[3].editVocab = false;
        CollectionProfile.STUDIO_PROFILES[3].editPersonalCollections = false;
        CollectionProfile.STUDIO_PROFILES[3].HTMLExport = true;
        CollectionProfile.STUDIO_PROFILES[3].maxViewableSize = 8;
        CollectionProfile.STUDIO_PROFILES[3].maxExportSize = 5;
        CollectionProfile.STUDIO_PROFILES[3].approvalLevel = 0;
        CollectionProfile.STUDIO_PROFILES[3].medePermissions = 0;
        CollectionProfile.STUDIO_PROFILES[3].maxPresentationExportSize = 5;
        CollectionProfile.STUDIO_PROFILES[4] = new CollectionProfile();
        CollectionProfile.STUDIO_PROFILES[4].studioProfile = 4;
        CollectionProfile.STUDIO_PROFILES[4].saveGroup = false;
        CollectionProfile.STUDIO_PROFILES[4].deleteGroup = false;
        CollectionProfile.STUDIO_PROFILES[4].print = false;
        CollectionProfile.STUDIO_PROFILES[4].edit = false;
        CollectionProfile.STUDIO_PROFILES[4].editMVI = false;
        CollectionProfile.STUDIO_PROFILES[4].editMPD = false;
        CollectionProfile.STUDIO_PROFILES[4].editLink = false;
        CollectionProfile.STUDIO_PROFILES[4].editVocab = false;
        CollectionProfile.STUDIO_PROFILES[4].editPersonalCollections = false;
        CollectionProfile.STUDIO_PROFILES[4].HTMLExport = false;
        CollectionProfile.STUDIO_PROFILES[4].maxViewableSize = 8;
        CollectionProfile.STUDIO_PROFILES[4].maxExportSize = 0;
        CollectionProfile.STUDIO_PROFILES[4].approvalLevel = 0;
        CollectionProfile.STUDIO_PROFILES[4].medePermissions = 0;
        CollectionProfile.STUDIO_PROFILES[4].maxPresentationExportSize = 0;
    }
}

