/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.presentation;

import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.presentation.ImageSeries;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class PresentationFileManager
implements FilenameFilter {
    public static final String COMPONENT_NAME = "PresentationFileManager";
    public static final String COMPONENT_CODE = "PresentationFileManager";
    public static final String PRES_FILE_EXT = "prs";
    public static final String LIST_FILE_EXT = "lst";
    public static final String GROUP_PREFIX = "Group-";
    public static final String SERIES_PREFIX = "Presentation-";
    public static final String PRESENTATION_KEY = "presentation.";
    protected String presFilePath = "Presentation-Files";

    public static void debugOut(String string) {
        Debug.debugOut("PresentationFileManager: " + string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("PresentationFileManager: " + string, n);
    }

    public PresentationFileManager(String string) {
        if (string != null) {
            this.presFilePath = string;
        }
    }

    public List getPresentationNames(int n) {
        Object object;
        Vector<Object> vector = new Vector<Object>(0);
        EnhancedProperties enhancedProperties = this.getPropertyFile(n);
        if (enhancedProperties == null) {
            PresentationFileManager.debugOut("Creating presentation list file.");
            object = this.getPresentations(n);
            if (InsightUtilities.isNonEmpty((Collection)object)) {
                enhancedProperties = this.savePropertyFile(n, (List)object);
            }
        } else {
            PresentationFileManager.debugOut("Presentation list file found.");
        }
        if (enhancedProperties != null) {
            object = null;
            int n2 = 0;
            while (InsightUtilities.isNonEmpty((String)(object = enhancedProperties.getProperty(PRESENTATION_KEY + n2)))) {
                vector.add(object);
                ++n2;
            }
        }
        return vector;
    }

    public Vector getPresentations(int n) {
        PresentationFileManager.debugOut("in getPresentations().");
        Vector<ImageSeries> vector = new Vector<ImageSeries>();
        String string = this.getDirectoryPath(n);
        PresentationFileManager.debugOut("Retrieving available presentations for " + string);
        File file = new File(string);
        String[] stringArray = file.list(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ImageSeries imageSeries;
                String string2 = stringArray[i];
                if (!string2.endsWith(".prs") || (imageSeries = this.getPresentation(string + string2)) == null) continue;
                vector.addElement(imageSeries);
            }
        }
        return vector;
    }

    public ImageSeries getPresentation(int n, String string) {
        PresentationFileManager.debugOut("in getPresentation().");
        String string2 = this.getFilePath(n, string);
        return this.getPresentation(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ImageSeries getPresentation(String string) {
        ImageSeries imageSeries;
        block12: {
            imageSeries = null;
            PresentationFileManager.debugOut("Finding file at " + string);
            File file = new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                InsightPkgSetterInputStream insightPkgSetterInputStream = new InsightPkgSetterInputStream(fileInputStream);
                imageSeries = (ImageSeries)insightPkgSetterInputStream.readObject();
                insightPkgSetterInputStream.close();
                fileInputStream.close();
                Object var7_7 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    break block12;
                }
                catch (IOException iOException) {}
                break block12;
                {
                    catch (Exception exception) {
                        PresentationFileManager.debugOut("Exception in getPresentation():\n" + InsightUtilities.getStackTrace(exception));
                        Object var7_8 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block12;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return imageSeries;
    }

    public boolean savePresentation(ImageSeries imageSeries) {
        return this.savePresentation(imageSeries, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean savePresentation(ImageSeries imageSeries, boolean bl) {
        Object object;
        Object object2;
        PresentationFileManager.debugOut("in savePresentation().", 3);
        String string = this.getFilePath(imageSeries.getGroupID(), imageSeries.getSeriesName());
        File file = new File(string);
        if (file.exists()) {
            if (!bl) return false;
            file.delete();
        } else {
            object2 = this.getDirectoryPath(imageSeries.getGroupID());
            object = new File((String)object2);
            ((File)object).mkdirs();
        }
        try {
            object2 = new FileOutputStream(file);
            object = InsightPkgRemoverOutputStream.getInstance((OutputStream)object2);
            imageSeries.setChanges(false);
            ((ObjectOutputStream)object).writeObject(imageSeries);
            ((ObjectOutputStream)object).close();
            ((FileOutputStream)object2).close();
            this.deletePropertyFile(imageSeries.getGroupID());
            return file.exists();
        }
        catch (Exception exception) {
            PresentationFileManager.debugOut("Exception in savePresentation():\n" + InsightUtilities.getStackTrace(exception));
            return false;
        }
    }

    public boolean deletePresentation(int n, String string) {
        return this.deletePresentation(n, string, true);
    }

    public boolean deletePresentation(int n, String string, boolean bl) {
        PresentationFileManager.debugOut("in deletePresentation().");
        String string2 = this.getFilePath(n, string);
        PresentationFileManager.debugOut("Finding file at " + string2);
        File file = new File(string2);
        if (file.exists() && !bl) {
            return false;
        }
        boolean bl2 = file.delete();
        if (bl2) {
            PresentationFileManager.debugOut(string2 + " successfully deleted.");
        } else {
            PresentationFileManager.debugOut(string2 + " not deleted.");
        }
        this.deletePropertyFile(n);
        return bl2;
    }

    public void copyPresentations(int n, int n2) {
        String string = this.getDirectoryPath(n);
        File file = new File(string);
        String[] stringArray = file.list(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ImageSeries imageSeries;
                String string2 = stringArray[i];
                if (!string2.endsWith(".prs") || (imageSeries = this.getPresentation(string + string2)) == null) continue;
                imageSeries.setGroupID(n2);
                this.savePresentation(imageSeries);
            }
        }
    }

    public void deleteAllPresentations(int n) {
        String string = this.getDirectoryPath(n);
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + stringArray[i]);
                file2.delete();
            }
        }
        file.delete();
    }

    public boolean accept(File file, String string) {
        return string != null && string.endsWith(".prs");
    }

    public EnhancedProperties getPropertyFile(int n) {
        return InsightUtilities.getEnhancedProperties(this.getPropertyFilePath(n));
    }

    public EnhancedProperties savePropertyFile(int n, List list) {
        if (InsightUtilities.isNonEmpty(list)) {
            Object object;
            String string = this.getPropertyFilePath(n);
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            } else {
                object = this.getDirectoryPath(n);
                File file2 = new File((String)object);
                file2.mkdirs();
            }
            object = new EnhancedProperties();
            for (int i = 0; list != null && i < list.size(); ++i) {
                ((Properties)object).setProperty(PRESENTATION_KEY + i, ((ImageSeries)list.get(i)).getSeriesName());
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((EnhancedProperties)object).store(fileOutputStream, "Group " + n + " Presentation List");
                fileOutputStream.close();
            }
            catch (Exception exception) {
                PresentationFileManager.debugOut("Exception in savePropertyFile(): " + exception);
            }
            return object;
        }
        return null;
    }

    public void deletePropertyFile(int n) {
        PresentationFileManager.debugOut("in deletePropertyFile().");
        try {
            String string = this.getPropertyFilePath(n);
            if (InsightUtilities.isNonEmpty(string)) {
                new File(string).delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getDirectoryPath(int n) {
        return this.presFilePath + File.separator + this.getGroupHeader(n) + File.separator;
    }

    protected String getFilePath(int n, String string) {
        return this.getDirectoryPath(n) + this.getSeriesHeader(string) + "." + PRES_FILE_EXT;
    }

    protected String getGroupHeader(int n) {
        return GROUP_PREFIX + n;
    }

    protected String getSeriesHeader(String string) {
        return SERIES_PREFIX + InsightUtilities.cleanFilename(InsightUtilities.convertNonAsciiCharacters(string));
    }

    protected String getPropertyFilePath(int n) {
        return this.getDirectoryPath(n) + "presentation-names-" + n + "." + LIST_FILE_EXT;
    }
}

