/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.presentation;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.presentation.ImageSeriesSlide;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;

public class ImageSeries
implements Serializable,
Cloneable,
CollectionKey {
    static final long serialVersionUID = 3572169942303942419L;
    public static final String NO_SERIES_NAME = "Untitled";
    public static final int LINK_MODE_HIDE = 1;
    public static final int LINK_MODE_SHOW = 2;
    public static final int LINK_MODE_OPEN = 3;
    public static final int VIRTUAL_MAXIMUM = 8000;
    protected String seriesName = null;
    protected int groupID = 0;
    protected int imageSeriesID = 0;
    protected boolean changes = false;
    protected boolean readOnly = true;
    protected Vector slides = null;
    protected int linkVisibilityMode = 1;
    protected Dimension screenSize = null;

    public static void debugOut(String string) {
        ImageSeries.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ImageSeries: " + string, n);
    }

    public static boolean isSlideFullyVisible(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        if (dimension != null && dimension2 != null && dimension3 != null) {
            return dimension.width <= ImageSeries.translateToScreen(dimension2.width, dimension3.width) && dimension.height <= ImageSeries.translateToScreen(dimension2.height, dimension3.height);
        }
        return false;
    }

    public static int translateToVirtual(int n, int n2) {
        return Math.round((float)n * 8000.0f / (float)n2);
    }

    public static int translateToScreen(int n, int n2) {
        return Math.round((float)n * (float)n2 / 8000.0f);
    }

    public static Rectangle translateToVirtual(Rectangle rectangle, int n, int n2) {
        return new Rectangle(ImageSeries.translateToVirtual(rectangle.x, n), ImageSeries.translateToVirtual(rectangle.y, n2), ImageSeries.translateToVirtual(rectangle.width, n), ImageSeries.translateToVirtual(rectangle.height, n2));
    }

    public static Rectangle translateToScreen(Rectangle rectangle, int n, int n2) {
        return new Rectangle(ImageSeries.translateToScreen(rectangle.x, n), ImageSeries.translateToScreen(rectangle.y, n2), ImageSeries.translateToScreen(rectangle.width, n), ImageSeries.translateToScreen(rectangle.height, n2));
    }

    public ImageSeries(String string, int n) {
        this.seriesName = string;
        this.imageSeriesID = n;
        this.slides = new Vector();
        this.changes = false;
        this.readOnly = true;
    }

    public ImageSeries(String string) {
        this(string, 1);
    }

    public void setGroupID(int n) {
        this.groupID = n;
    }

    public void setImageSeriesID(int n) {
        this.imageSeriesID = n;
    }

    public void setSeriesName(String string) {
        this.seriesName = string;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setLinkVisibilityMode(int n) {
        this.linkVisibilityMode = n;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public void changed() {
        this.changes = true;
    }

    public void setScreenSize(Dimension dimension) {
        this.screenSize = dimension;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public int getImageSeriesID() {
        return this.imageSeriesID;
    }

    public Vector getSlideVector() {
        return this.getSlides();
    }

    public Vector getSlides() {
        return this.slides;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getLinkVisibilityMode() {
        return this.linkVisibilityMode;
    }

    public boolean hasChanged() {
        return this.changes;
    }

    public Dimension getScreenSize() {
        return this.getScreenSize(null);
    }

    public Dimension getScreenSize(Dimension dimension) {
        if (this.screenSize == null) {
            this.screenSize = dimension;
        }
        return this.screenSize;
    }

    public String getSeriesName() {
        if (this.seriesName == null) {
            this.seriesName = NO_SERIES_NAME;
        }
        return this.seriesName;
    }

    public ImageSeriesSlide getFirstSlide() {
        if (this.slides != null && this.slides.size() > 0) {
            return (ImageSeriesSlide)this.slides.firstElement();
        }
        return null;
    }

    public void trimToSize() {
        if (this.slides != null) {
            this.slides.trimToSize();
        }
    }

    public String toString() {
        return this.getSeriesName();
    }

    public Object clone() {
        return InsightUtilities.deepCopy(this);
    }

    public String getInstitutionID() {
        ImageSeriesSlide imageSeriesSlide = this.getFirstSlide();
        if (imageSeriesSlide != null) {
            return imageSeriesSlide.getInstitutionID();
        }
        return "";
    }

    public String getCollectionID() {
        ImageSeriesSlide imageSeriesSlide = this.getFirstSlide();
        if (imageSeriesSlide != null) {
            return imageSeriesSlide.getCollectionID();
        }
        return "";
    }

    public String getVCID() {
        ImageSeriesSlide imageSeriesSlide = this.getFirstSlide();
        if (imageSeriesSlide != null) {
            return imageSeriesSlide.getVCID();
        }
        return "NA";
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }
}

