/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mvi;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.ImageInGroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class MultiviewImageSlide
implements Serializable,
Cloneable,
CollectionKey {
    static final long serialVersionUID = 2365523160730333715L;
    public static final int TOTAL_DIRECTIONS = 4;
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    protected long objectIDLong = 0L;
    protected long imageIDV3 = 0L;
    protected String institutionIDV3 = null;
    protected String collectionIDV3 = null;
    protected String vcID;
    protected Vector slideRefs = null;
    protected transient ImageInGroup imageDetails = null;
    private int objectIDV3 = 0;
    private String imageID = null;
    private String collectionID = null;

    public MultiviewImageSlide(long l, long l2, CollectionKey collectionKey, ImageInGroup imageInGroup) {
        this.objectIDLong = l;
        this.imageIDV3 = l2;
        this.institutionIDV3 = collectionKey.getInstitutionID();
        this.collectionIDV3 = collectionKey.getCollectionID();
        this.vcID = collectionKey.getVCID();
        this.imageDetails = imageInGroup;
        this.slideRefs = new Vector(4);
        for (int i = 0; i < 4; ++i) {
            this.slideRefs.addElement(null);
        }
    }

    public Object clone() {
        return new MultiviewImageSlide(this.objectIDLong, this.imageIDV3, new CollectionKeyWrapper(this.institutionIDV3, this.collectionIDV3, this.vcID), this.imageDetails);
    }

    public long getObjectID() {
        return this.objectIDLong;
    }

    public long getImageID() {
        return this.imageIDV3;
    }

    public void setObjectID(long l) {
        this.objectIDLong = l;
    }

    public void setImageID(long l) {
        this.imageIDV3 = l;
    }

    public void setInstitutionID(String string) {
        this.institutionIDV3 = string;
    }

    public void setCollectionID(String string) {
        this.collectionIDV3 = string;
    }

    public void setVCID(String string) {
        this.vcID = string;
    }

    public void setSlide(MultiviewImageSlide multiviewImageSlide, int n) {
        this.slideRefs.removeElementAt(n);
        this.slideRefs.insertElementAt(multiviewImageSlide, n);
    }

    public MultiviewImageSlide getSlide(int n) {
        return (MultiviewImageSlide)this.slideRefs.elementAt(n);
    }

    public void setImageDetails(ImageInGroup imageInGroup) {
        this.imageDetails = imageInGroup;
    }

    public ImageInGroup getImageDetails() {
        return this.imageDetails;
    }

    public void severAllTies() {
        for (int i = 0; i < 4; ++i) {
            MultiviewImageSlide multiviewImageSlide = this.getSlide(i);
            if (multiviewImageSlide != null && multiviewImageSlide.getSlide(MultiviewImageSlide.oppositeDirection(i)) == this) {
                multiviewImageSlide.setSlide(null, MultiviewImageSlide.oppositeDirection(i));
            }
            this.setSlide(null, i);
        }
    }

    public static int oppositeDirection(int n) {
        if (n == 0) {
            return 2;
        }
        if (n == 2) {
            return 0;
        }
        if (n == 1) {
            return 3;
        }
        if (n == 3) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "MultiviewImageSlide [institution = " + this.institutionIDV3 + ", collection = " + this.collectionIDV3 + "; image = " + this.imageIDV3 + "]";
    }

    public String getInstitutionID() {
        return this.institutionIDV3;
    }

    public String getCollectionID() {
        return this.collectionIDV3;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.objectIDLong == 0L) {
            this.objectIDLong = this.objectIDV3;
        }
        if (this.imageIDV3 == 0L) {
            try {
                this.imageIDV3 = Long.parseLong(this.imageID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.collectionIDV3 == null) {
            try {
                this.collectionIDV3 = this.collectionID;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.imageID = null;
        this.collectionID = null;
    }
}

