/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mpd;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.mpd.MultipageDocumentLevel;
import com.luna.insight.server.mpd.MultipageDocumentNode;
import com.luna.insight.server.mpd.MultipageDocumentPage;
import com.luna.insight.server.mpd.MultipageDocumentPathEntry;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;

public class MultipageDocumentSeries
implements Serializable,
Cloneable,
CollectionKey {
    static final long serialVersionUID = 314416825658171259L;
    public static final int LINK_MODE_HIDE = 0;
    public static final int LINK_MODE_SHOW = 1;
    public static final int LINK_MODE_OPEN = 2;
    protected int linkVisibilityMode = 0;
    protected String documentID = "0";
    protected String documentName = "";
    protected Vector pages = new Vector();
    protected Vector nodes = new Vector();
    protected Vector levels = new Vector();
    protected Vector pathEntries = new Vector();
    protected boolean readOnly = false;
    protected boolean changes = false;
    protected int targetGroupID = 0;
    protected int identityFieldID = 0;
    protected String identityValue = null;

    public static void debugOut(String string) {
        MultipageDocumentSeries.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MPDSeries: " + string, n);
    }

    public MultipageDocumentSeries(String string, String string2) {
        this.documentID = string;
        this.documentName = string2;
    }

    public void setTargetGroupID(int n) {
        this.targetGroupID = n;
    }

    public int getTargetGroupID() {
        return this.targetGroupID;
    }

    public void setIdentityFieldID(int n) {
        this.identityFieldID = n;
    }

    public void setIdentityValue(String string) {
        this.identityValue = string;
    }

    public int getIdentityFieldID() {
        return this.identityFieldID;
    }

    public String getIdentityValue() {
        return this.identityValue;
    }

    public Object clone() {
        return InsightUtilities.deepCopy(this);
    }

    public void addLevel(String string, int n) {
        this.addLevel(string, n, 0);
    }

    public void addLevel(String string, int n, int n2) {
        this.addLevel(new MultipageDocumentLevel(string, n, n2));
    }

    public void addLevel(MultipageDocumentLevel multipageDocumentLevel) {
        if (this.levels == null) {
            this.levels = new Vector();
        }
        if (!this.levels.contains(multipageDocumentLevel)) {
            this.levels.addElement(multipageDocumentLevel);
        }
    }

    public Vector getLevels() {
        return this.levels;
    }

    public MultipageDocumentLevel getLevel(int n) {
        MultipageDocumentLevel multipageDocumentLevel = null;
        MultipageDocumentLevel multipageDocumentLevel2 = null;
        for (int i = 0; this.levels != null && i < this.levels.size(); ++i) {
            multipageDocumentLevel2 = (MultipageDocumentLevel)this.levels.elementAt(i);
            if (multipageDocumentLevel2.getLevelNumber() != n) continue;
            multipageDocumentLevel = multipageDocumentLevel2;
            break;
        }
        return multipageDocumentLevel;
    }

    public void addLevelNodeDefinition(int n, int n2, String string) {
        MultipageDocumentLevel multipageDocumentLevel = this.getLevel(n);
        multipageDocumentLevel.addLevelNodeDefinition(n2, string);
    }

    public void addPage(MultipageDocumentPage multipageDocumentPage) {
        if (multipageDocumentPage != null) {
            if (this.pages == null) {
                this.pages = new Vector();
            }
            multipageDocumentPage.setPagePosition(this.pages.size());
            this.pages.addElement(multipageDocumentPage);
            this.addNode(multipageDocumentPage);
        }
    }

    public void removePage(MultipageDocumentPage multipageDocumentPage) {
        this.pages.removeElement(multipageDocumentPage);
    }

    public void addNode(MultipageDocumentNode multipageDocumentNode) {
        if (multipageDocumentNode != null) {
            if (this.nodes == null) {
                this.nodes = new Vector();
            }
            multipageDocumentNode.setNodePosition(this.nodes.size());
            this.nodes.addElement(multipageDocumentNode);
        }
    }

    public MultipageDocumentPage getPage(int n) {
        MultipageDocumentPage multipageDocumentPage = null;
        MultipageDocumentPage multipageDocumentPage2 = null;
        for (int i = 0; this.pages != null && i < this.pages.size(); ++i) {
            multipageDocumentPage2 = (MultipageDocumentPage)this.pages.elementAt(i);
            if (multipageDocumentPage2.getPageID() != n) continue;
            multipageDocumentPage = multipageDocumentPage2;
            break;
        }
        return multipageDocumentPage;
    }

    public Vector getPages() {
        return this.pages;
    }

    public void orderPages() {
        for (int i = 0; i < this.pages.size(); ++i) {
            ((MultipageDocumentPage)this.pages.elementAt(i)).trimPath();
        }
        Collections.sort(this.pages);
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public MultipageDocumentPage getFirstPage() {
        if (this.pages != null && this.pages.size() > 0) {
            return (MultipageDocumentPage)this.pages.firstElement();
        }
        return null;
    }

    public MultipageDocumentPathEntry getPathEntry(int n, int n2) {
        MultipageDocumentPathEntry multipageDocumentPathEntry = new MultipageDocumentPathEntry(n, n2);
        int n3 = this.pathEntries.indexOf(multipageDocumentPathEntry);
        if (n3 > -1) {
            multipageDocumentPathEntry = (MultipageDocumentPathEntry)this.pathEntries.elementAt(n3);
        } else {
            this.pathEntries.addElement(multipageDocumentPathEntry);
        }
        return multipageDocumentPathEntry;
    }

    public void assembleDocumentHierarchy() {
        this.findParentNodes();
        this.addMainRootNode();
        this.findLevelsAndNodeNames();
        this.reorderNodes();
    }

    public void findParentNodes() {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)this.nodes.elementAt(i);
            multipageDocumentNode.findParentNode();
        }
    }

    public void addMainRootNode() {
        if (this.getRootNodeCount() > 1) {
            int n = -1000;
            this.addLevel("Document", n);
            this.addLevelNodeDefinition(n, n, this.getDocumentName());
            MultipageDocumentNode multipageDocumentNode = new MultipageDocumentNode(this);
            multipageDocumentNode.addToPath(n, n);
            MultipageDocumentPathEntry multipageDocumentPathEntry = this.getPathEntry(n, n);
            for (int i = 0; i < this.nodes.size(); ++i) {
                MultipageDocumentNode multipageDocumentNode2 = (MultipageDocumentNode)this.nodes.elementAt(i);
                multipageDocumentNode2.setFirstPathEntry(multipageDocumentPathEntry);
            }
            this.addNode(multipageDocumentNode);
            this.findParentNodes();
        }
    }

    public void findLevelsAndNodeNames() {
        for (int i = 0; i < this.pathEntries.size(); ++i) {
            MultipageDocumentPathEntry multipageDocumentPathEntry = (MultipageDocumentPathEntry)this.pathEntries.elementAt(i);
            multipageDocumentPathEntry.findLevelAndNodeName(this);
        }
    }

    public void reorderNodes() {
        int n;
        Vector vector = new Vector(this.nodes.size());
        for (n = 0; n < this.nodes.size(); ++n) {
            MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)this.nodes.elementAt(n);
            if (!multipageDocumentNode.isRoot()) continue;
            multipageDocumentNode.reorder(vector);
        }
        if (vector.size() == this.nodes.size()) {
            this.nodes.removeAllElements();
            for (n = 0; n < vector.size(); ++n) {
                this.addNode((MultipageDocumentNode)vector.elementAt(n));
            }
        } else {
            MultipageDocumentSeries.debugOut("Problem in orderNodes(), some nodes were lost. New order nodes: " + vector.size() + "Old order nodes: " + this.nodes.size());
        }
    }

    public int getRootNodeCount() {
        int n = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)this.nodes.elementAt(i);
            if (!multipageDocumentNode.isRoot()) continue;
            ++n;
        }
        return n;
    }

    public void displayDocumentHierarchy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nDocumentID: " + this.getDocumentID() + ", DocumentName: " + this.getDocumentName() + "\n");
        for (int i = 0; i < this.nodes.size(); ++i) {
            MultipageDocumentNode multipageDocumentNode = (MultipageDocumentNode)this.nodes.elementAt(i);
            if (!multipageDocumentNode.isRoot()) continue;
            multipageDocumentNode.display(stringBuffer, 0);
        }
        MultipageDocumentSeries.debugOut(stringBuffer.toString());
    }

    public String getDocumentID() {
        return this.documentID;
    }

    public void setDocumentID(String string) {
        this.documentID = string;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String string) {
        this.documentName = string;
    }

    public long getObjectID() {
        MultipageDocumentPage multipageDocumentPage = this.getFirstPage();
        if (multipageDocumentPage != null) {
            return multipageDocumentPage.getObjectID();
        }
        return -1L;
    }

    public long getImageID() {
        MultipageDocumentPage multipageDocumentPage = this.getFirstPage();
        if (multipageDocumentPage != null) {
            return multipageDocumentPage.getImageID();
        }
        return -1L;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean hasChanged() {
        return this.changes;
    }

    public void changed() {
        this.changes = true;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public void trimToSize() {
        if (this.pages != null) {
            this.pages.trimToSize();
        }
    }

    public String getInstitutionID() {
        MultipageDocumentPage multipageDocumentPage = this.getFirstPage();
        if (multipageDocumentPage != null) {
            return multipageDocumentPage.getInstitutionID();
        }
        return "";
    }

    public String getCollectionID() {
        MultipageDocumentPage multipageDocumentPage = this.getFirstPage();
        if (multipageDocumentPage != null) {
            return multipageDocumentPage.getCollectionID();
        }
        return "";
    }

    public String getVCID() {
        MultipageDocumentPage multipageDocumentPage = this.getFirstPage();
        if (multipageDocumentPage != null) {
            return multipageDocumentPage.getVCID();
        }
        return "NA";
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public void setLinkVisibilityMode(int n) {
        this.linkVisibilityMode = n;
    }

    public int getLinkVisibilityMode() {
        return this.linkVisibilityMode;
    }
}

