/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mpd;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ObjectKey;
import com.luna.insight.server.mpd.MultipageDocumentNode;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import java.io.Serializable;
import java.util.Vector;

public class MultipageDocumentPage
extends MultipageDocumentNode
implements Serializable,
Cloneable,
ObjectKey {
    static final long serialVersionUID = -6568765673140795597L;
    protected int pagePosition = 0;
    protected int linkCount = 0;
    protected long objectID = 0L;
    protected long imageID = 0L;
    protected int mediaType = 0;
    protected String institutionID = null;
    protected String collectionID = null;
    protected String vcID;
    protected transient ImageInGroup imageDetails = null;
    protected boolean isLinkParent = false;

    public static void debugOut(String string) {
        MultipageDocumentPage.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MPDPage: " + string, n);
    }

    public MultipageDocumentPage(MultipageDocumentSeries multipageDocumentSeries, ObjectKey objectKey) {
        this(multipageDocumentSeries, objectKey.getObjectID(), objectKey.getImageID(), objectKey.getMediaType(), objectKey, null);
    }

    public MultipageDocumentPage(MultipageDocumentSeries multipageDocumentSeries, ObjectKey objectKey, ImageInGroup imageInGroup) {
        this(multipageDocumentSeries, objectKey.getObjectID(), objectKey.getImageID(), objectKey.getMediaType(), objectKey, imageInGroup);
    }

    public MultipageDocumentPage(MultipageDocumentSeries multipageDocumentSeries, long l, long l2, int n, CollectionKey collectionKey) {
        this(multipageDocumentSeries, l, l2, n, collectionKey, null);
    }

    public MultipageDocumentPage(MultipageDocumentSeries multipageDocumentSeries, long l, long l2, int n, CollectionKey collectionKey, ImageInGroup imageInGroup) {
        super(multipageDocumentSeries);
        this.objectID = l;
        this.imageID = l2;
        this.mediaType = n;
        this.institutionID = collectionKey.getInstitutionID();
        this.collectionID = collectionKey.getCollectionID();
        this.vcID = collectionKey.getVCID();
        this.imageDetails = imageInGroup;
    }

    public Object clone() {
        MultipageDocumentPage multipageDocumentPage = (MultipageDocumentPage)InsightUtilities.deepCopy(this);
        multipageDocumentPage.setImageDetails(this.imageDetails);
        return multipageDocumentPage;
    }

    public MultipageDocumentPage getPreviousSection() {
        MultipageDocumentNode multipageDocumentNode = this.getFirstGenerationAncestor();
        MultipageDocumentNode multipageDocumentNode2 = null;
        MultipageDocumentNode multipageDocumentNode3 = null;
        MultipageDocumentPage multipageDocumentPage = null;
        if (multipageDocumentNode != null) {
            Vector vector = multipageDocumentNode.getSiblingNodes();
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                multipageDocumentNode3 = (MultipageDocumentNode)vector.elementAt(i);
                n2 = multipageDocumentNode.getNodePosition() - multipageDocumentNode3.getNodePosition();
                if (n2 <= 0 || n2 >= n) continue;
                n = n2;
                multipageDocumentNode2 = multipageDocumentNode3;
            }
        }
        if (multipageDocumentNode2 != null) {
            multipageDocumentPage = multipageDocumentNode2.getNearestPage();
        }
        return multipageDocumentPage;
    }

    public MultipageDocumentPage getNextSection() {
        MultipageDocumentNode multipageDocumentNode = this.getFirstGenerationAncestor();
        MultipageDocumentNode multipageDocumentNode2 = null;
        MultipageDocumentPage multipageDocumentPage = null;
        MultipageDocumentNode multipageDocumentNode3 = null;
        if (multipageDocumentNode != null) {
            Vector vector = multipageDocumentNode.getSiblingNodes();
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                multipageDocumentNode3 = (MultipageDocumentNode)vector.elementAt(i);
                n2 = multipageDocumentNode3.getNodePosition() - multipageDocumentNode.getNodePosition();
                if (n2 <= 0 || n2 >= n) continue;
                n = n2;
                multipageDocumentNode2 = multipageDocumentNode3;
            }
        }
        if (multipageDocumentNode2 != null) {
            multipageDocumentPage = multipageDocumentNode2.getNearestPage();
        }
        return multipageDocumentPage;
    }

    public void setPagePosition(int n) {
        this.pagePosition = n;
    }

    public void setLinkCount(int n) {
        this.linkCount = n;
    }

    public void setObjectID(long l) {
        this.objectID = l;
    }

    public void setImageID(long l) {
        this.imageID = l;
    }

    public void setMediaType(int n) {
        this.mediaType = n;
    }

    public void setInstitutionID(String string) {
        this.institutionID = string;
    }

    public void setCollectionID(String string) {
        this.collectionID = string;
    }

    public void setVCID(String string) {
        this.vcID = string;
    }

    public void setImageDetails(ImageInGroup imageInGroup) {
        this.imageDetails = imageInGroup;
    }

    public int getPageID() {
        return this.getPagePosition();
    }

    public int getPagePosition() {
        return this.pagePosition;
    }

    public int getLinkCount() {
        return this.linkCount;
    }

    public ImageInGroup getImageDetails() {
        return this.imageDetails;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public long getImageID() {
        return this.imageID;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public boolean isMultiview() {
        return false;
    }

    public boolean isMultipage() {
        return true;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public String toString() {
        return super.toString() + " -> [" + this.getPageID() + ":" + this.getObjectID() + ":" + this.getImageID() + ":" + this.getLinkCount() + ">";
    }
}

