/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mediacreation;

import com.luna.insight.server.collectionmanagement.JPEGImageCreationSettings;
import com.luna.insight.server.mediacreation.IMediaBatchProfileResolution;
import java.io.File;
import java.io.Serializable;

public class MediaBatchProfileResolution
implements IMediaBatchProfileResolution,
Serializable {
    static final long serialVersionUID = 6804432998319174173L;
    protected int resolutionNumber;
    protected int format;
    protected int pixelSize = -1;
    protected JPEGImageCreationSettings jpegSettings;

    public static int determineResolutionForSize(int n) {
        int n2 = IMediaBatchProfileResolution.PIXEL_SIZES.length - 1;
        if (n > IMediaBatchProfileResolution.PIXEL_SIZES[n2]) {
            return n2;
        }
        while (n2 > 0) {
            if (n <= IMediaBatchProfileResolution.PIXEL_SIZES[n2] && n > IMediaBatchProfileResolution.PIXEL_SIZES[n2 - 1]) {
                return n2;
            }
            --n2;
        }
        return 0;
    }

    public MediaBatchProfileResolution(int n, int n2) {
        this.resolutionNumber = n;
        this.format = n2;
        final class InsightJPEGImageCreationSettings
        implements JPEGImageCreationSettings,
        Serializable {
            static final long serialVersionUID = -3216412292806089063L;
            protected int jpegCompression;
            protected boolean useBrightness = false;
            protected boolean automaticTrimEdges = false;
            protected boolean forceUpsize = false;
            protected int brightness = 0;
            protected int edgeThreshold = 0;

            public InsightJPEGImageCreationSettings(int n) {
                this.jpegCompression = JPEGImageCreationSettings.DEFAULT_JPEG_COMPRESSIONS[n];
            }

            public String getName() {
                return "";
            }

            public int getJpegCompression() {
                return this.jpegCompression;
            }
        }
        this.jpegSettings = new InsightJPEGImageCreationSettings(n);
    }

    public int getResolutionNumber() {
        return this.resolutionNumber;
    }

    public int getFormat() {
        return this.format;
    }

    public JPEGImageCreationSettings getJpegSettings() {
        return this.jpegSettings;
    }

    public int getMediaType() {
        return 1;
    }

    public int getResolutionPixels() {
        if (this.pixelSize != -1) {
            return this.pixelSize;
        }
        return IMediaBatchProfileResolution.PIXEL_SIZES[this.resolutionNumber];
    }

    public int getMinimumPixelSize() {
        if (this.resolutionNumber == 0) {
            return 0;
        }
        return IMediaBatchProfileResolution.PIXEL_SIZES[this.resolutionNumber - 1] + 1;
    }

    public String getRelativeDirectoryPath() {
        return this.getRelativeDirectoryPath(1);
    }

    public String getRelativeDirectoryPath(int n) {
        if (n == 1) {
            if (this.format == 13) {
                return "JP2K";
            }
            if (this.format == 1) {
                return "SIDS";
            }
            return "Size" + this.resolutionNumber;
        }
        if (this.resolutionNumber == 2) {
            return MediaBatchProfileResolution.getMediaTypeName(n);
        }
        return MediaBatchProfileResolution.getMediaTypeName(n) + File.separator + "Size" + this.resolutionNumber;
    }

    public void setNonDefaultPixelSize(int n) {
        this.pixelSize = n;
    }

    private static String getMediaTypeName(int n) {
        if (n == 2) {
            return "AUDIO";
        }
        if (n == 3) {
            return "VIDEO";
        }
        if (n == 4) {
            return "QTVR";
        }
        if (n == 5) {
            return "MISC";
        }
        if (n == 6) {
            return "SOURCE";
        }
        if (n == 7) {
            return "BOOK";
        }
        return "IMAGE";
    }
}

