/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mediacreation;

import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.mediacreation.IMediaBatch;
import com.luna.insight.server.mediacreation.IMediaBatchElement;
import com.luna.insight.server.mediacreation.IMediaBatchProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MediaBatch
implements IMediaBatch,
Serializable {
    static final long serialVersionUID = 1078871328387304523L;
    protected Integer uniqueCollectionID;
    protected CollectionKeyWrapper collectionKey;
    protected boolean hasBeenSaved = false;
    private boolean modifiedSinceLastCommit = false;
    protected int batchID;
    protected String batchName;
    protected int batchStatus;
    protected int resProfileID;
    protected String destDir;
    protected String lpsDir;
    protected int lpsId;
    protected String logFilepath;
    protected String mappingFilepath;
    protected int mappingFieldID;
    protected List batchElements = null;
    protected boolean isBookBatch = false;
    protected IMediaBatchProfile batchProfile = null;
    protected long startingMediaID = -1L;
    protected Map filenameElementMap = null;

    public MediaBatch(Integer n, IMediaBatchProfile iMediaBatchProfile, CollectionKeyWrapper collectionKeyWrapper, String string, String string2, String string3) {
        this(n, iMediaBatchProfile, collectionKeyWrapper, string, string2, false, string3);
    }

    public MediaBatch(Integer n, IMediaBatchProfile iMediaBatchProfile, CollectionKeyWrapper collectionKeyWrapper, String string, String string2, boolean bl, String string3) {
        this.uniqueCollectionID = n;
        this.collectionKey = collectionKeyWrapper;
        this.resProfileID = iMediaBatchProfile.getProfileId();
        this.batchProfile = iMediaBatchProfile;
        this.batchName = string;
        this.destDir = string2;
        this.logFilepath = string3;
        this.isBookBatch = bl;
        this.batchElements = new ArrayList();
        this.modifiedSinceLastCommit = true;
    }

    public MediaBatch(Integer n, int n2, String string, int n3, IMediaBatchProfile iMediaBatchProfile, String string2, String string3, int n4, String string4, String string5, int n5, long l, boolean bl) {
        this.uniqueCollectionID = n;
        this.batchID = n2;
        this.batchName = string == null ? "" : string;
        this.batchStatus = n3;
        this.resProfileID = iMediaBatchProfile.getProfileId();
        this.batchProfile = iMediaBatchProfile;
        this.destDir = InsightUtilities.rightTrimSlashes(string2 == null ? "" : string2);
        this.lpsDir = string3 == null ? "" : string3;
        this.lpsId = n4;
        this.logFilepath = string4 == null ? "" : string4;
        this.mappingFilepath = string5 == null ? "" : string5;
        this.mappingFieldID = n5;
        this.startingMediaID = l;
        this.isBookBatch = bl;
        this.hasBeenSaved = true;
    }

    public int getMappingFieldID() {
        return this.mappingFieldID;
    }

    public void setMappingFieldID(int n) {
        if (this.mappingFieldID != n) {
            this.modifiedSinceLastCommit = true;
            this.mappingFieldID = n;
        }
        if (this.batchElements != null) {
            Iterator iterator = this.batchElements.iterator();
            while (iterator.hasNext()) {
                ((IMediaBatchElement)iterator.next()).setObjectKeyFieldID(n);
            }
        }
    }

    public String getMappingFilepath() {
        return this.mappingFilepath;
    }

    public String getLpsDir() {
        return this.lpsDir;
    }

    public void setLpsDir(String string) {
        this.lpsDir = string;
    }

    public int getLpsId() {
        return this.lpsId;
    }

    public void setLpsId(int n) {
        this.lpsId = n;
    }

    public List getResolutions() {
        return this.batchProfile.getResolutions();
    }

    public long getStartingMediaID() {
        return this.startingMediaID;
    }

    public IMediaBatchProfile getBatchProfile() {
        return this.batchProfile;
    }

    public void setBatchStatus(int n) {
        if (this.batchStatus != n) {
            this.modifiedSinceLastCommit = true;
        }
        this.batchStatus = n;
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public String getUltimateUrlPrefix() {
        if (this.getBatchProfile() == null) {
            return null;
        }
        return this.getBatchProfile().getUrlPrefix();
    }

    public String getUltimateSidUrlPrefix() {
        return this.getBatchProfile().getSidUrlPrefix();
    }

    public List getBatchElements() {
        return this.batchElements;
    }

    public int getBatchID() {
        return this.batchID;
    }

    public void setBatchID(int n) {
        this.batchID = n;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public int getBatchProfileID() {
        return this.resProfileID;
    }

    public int getBatchStatus() {
        return this.batchStatus;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getLogFilepath() {
        return this.logFilepath;
    }

    public IMediaBatchElement getBatchElement(long l) {
        if (this.batchElements != null) {
            Iterator iterator = this.batchElements.iterator();
            while (iterator.hasNext()) {
                IMediaBatchElement iMediaBatchElement = (IMediaBatchElement)iterator.next();
                if (iMediaBatchElement.getDestMediaID() != l) continue;
                return iMediaBatchElement;
            }
        }
        return null;
    }

    public void addBatchElement(IMediaBatchElement iMediaBatchElement) {
        if (this.batchElements == null) {
            this.batchElements = new ArrayList();
        }
        this.batchElements.add(iMediaBatchElement);
        this.filenameElementMap = null;
    }

    public void setBatchElements(List list) {
        this.batchElements = list;
        this.filenameElementMap = null;
    }

    public boolean hasBeenSaved() {
        return this.hasBeenSaved;
    }

    public void setHasBeenSaved(boolean bl) {
        this.hasBeenSaved = bl;
        this.modifiedSinceLastCommit = false;
    }

    public IMediaBatchElement getBatchElementBySourceFilename(String string) {
        Iterator iterator;
        IMediaBatchElement iMediaBatchElement;
        if (this.filenameElementMap == null) {
            this.hashElementsByFilename();
        }
        if ((iMediaBatchElement = (IMediaBatchElement)this.filenameElementMap.get(string)) == null && this.isBookBatch && (iterator = this.filenameElementMap.keySet().iterator()) != null) {
            while (iMediaBatchElement == null && iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.toLowerCase().startsWith("http") || string2.toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
                iMediaBatchElement = (IMediaBatchElement)this.filenameElementMap.get(string2);
            }
        }
        return iMediaBatchElement;
    }

    public void updateHashes() {
        this.filenameElementMap = null;
    }

    private void hashElementsByFilename() {
        if (this.filenameElementMap == null) {
            this.filenameElementMap = new HashMap();
        } else {
            this.filenameElementMap.clear();
        }
        if (this.batchElements != null) {
            Iterator iterator = this.batchElements.iterator();
            while (iterator.hasNext()) {
                IMediaBatchElement iMediaBatchElement = (IMediaBatchElement)iterator.next();
                String string = iMediaBatchElement.getSourceFilename();
                if (this.isBookBatch && iMediaBatchElement.getSourceDirectory() != null && iMediaBatchElement.getSourceFilename() == null) {
                    string = iMediaBatchElement.getSourceDirectory();
                }
                if (string == null || string.equals("")) continue;
                this.filenameElementMap.put(string, iMediaBatchElement);
            }
        }
    }

    public boolean isModifiedSinceLastCommit() {
        return this.modifiedSinceLastCommit;
    }

    public void setModifiedSinceLastCommit(boolean bl) {
        this.modifiedSinceLastCommit = bl;
    }

    public boolean hasModifiedElements() {
        boolean bl = false;
        if (this.batchElements != null) {
            Iterator iterator = this.batchElements.iterator();
            while (iterator.hasNext()) {
                if (!((IMediaBatchElement)iterator.next()).isModifiedSinceLastCommit()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public CollectionKeyWrapper getCollectionKeyWrapper() {
        return this.collectionKey;
    }

    public boolean isBookBatch() {
        return this.isBookBatch;
    }

    public void setBookBatch(boolean bl) {
        this.isBookBatch = bl;
    }
}

