/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.links;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.FontDescriptor;
import com.luna.insight.server.links.LinkAuthorshipInfo;
import com.luna.insight.server.links.LinkData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;

public class AnnotationLinkData
extends LinkData {
    static final long serialVersionUID = 3759201476295945383L;
    public static final int ICON = 0;
    public static final int IMMEDIATE = 1;
    private String text = "";
    private FontDescriptor fd = null;
    private Dimension windowSize = null;
    private Dimension windowDistance = null;
    private int displayMode = 0;
    private Font font = null;

    public AnnotationLinkData(CollectionKey collectionKey, long l, long l2) {
        super(collectionKey, l, l2);
    }

    public AnnotationLinkData(CollectionKey collectionKey, long l, long l2, Rectangle rectangle, Color color, String string, Font font) {
        super(collectionKey, l, l2, rectangle, color);
        this.text = string;
        this.setFont(font);
    }

    public AnnotationLinkData(CollectionKey collectionKey, long l, long l2, Rectangle rectangle) {
        super(collectionKey, l, l2, rectangle);
    }

    public AnnotationLinkData(AnnotationLinkData annotationLinkData) {
        super(annotationLinkData, annotationLinkData.getObjectID(), annotationLinkData.getImageID(), annotationLinkData.getRegion(), annotationLinkData.getColor(), annotationLinkData.getSaveLocation(), annotationLinkData.getGroupName(), annotationLinkData.getGroupCodeKey(), new LinkAuthorshipInfo(annotationLinkData.getAuthorshipInfo()));
        this.text = annotationLinkData.getText();
        this.fd = annotationLinkData.getFontDescriptor();
        this.windowSize = annotationLinkData.getTextWndSize();
        this.windowDistance = annotationLinkData.getTextWndDistance();
        this.displayMode = annotationLinkData.getDisplayMode();
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setFontDescriptor(FontDescriptor fontDescriptor) {
        this.fd = fontDescriptor;
    }

    public void setTextWndSize(Dimension dimension) {
        this.windowSize = dimension;
    }

    public void setTextWndDistance(Dimension dimension) {
        this.windowDistance = dimension;
    }

    public void setDisplayMode(int n) {
        this.displayMode = n;
    }

    public String getText() {
        return this.text;
    }

    public FontDescriptor getFontDescriptor() {
        return this.fd;
    }

    public Dimension getTextWndSize() {
        return this.windowSize;
    }

    public Dimension getTextWndDistance() {
        return this.windowDistance;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.fd = new FontDescriptor(font);
        }
    }

    public Font getFont() {
        if (this.fd != null) {
            return this.fd.getFont();
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.fd == null && this.font != null) {
            try {
                this.fd = new FontDescriptor(this.font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.font = null;
    }

    public static void debugOut(String string) {
        Debug.debugOut("AnnotationLinkData: " + string, 2);
    }
}

