/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.io;

import com.luna.insight.server.Debug;
import com.luna.insight.server.io.ClassDescriptionFilter;
import com.luna.insight.server.io.InsightByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class InsightPkgRemoverFilterOutputStream
extends FilterOutputStream {
    protected boolean receivingClassDesc = false;
    protected InsightByteArrayOutputStream baos = new InsightByteArrayOutputStream();
    protected ClassDescriptionFilter cDescFilter;

    public static void debugOut(String string) {
        InsightPkgRemoverFilterOutputStream.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("PkgRemoverFilterStream: " + string, n);
    }

    public InsightPkgRemoverFilterOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.cDescFilter = new ClassDescriptionFilter(outputStream, true);
    }

    public void receiveClassDescriptor() {
        this.receivingClassDesc = true;
    }

    public void filterClassDescriptor() throws IOException {
        this.receivingClassDesc = false;
        this.cDescFilter.filterClassDescriptor(this.baos.getInputStream());
        this.baos.reset();
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.receivingClassDesc) {
            this.baos.write(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.baos.close();
        this.out.close();
    }
}

