/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.core.util.IntegerRange;
import com.luna.insight.core.util.MutableBoolean;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.InsightDataAnchor;
import com.luna.insight.server.InsightSmartServer;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.MutableObject;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.InsightTableNames;
import com.luna.insight.server.backend.JdbcConnectorError;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.indexer.DiacriticMappings;
import com.luna.insight.server.indexer.TrinityFlatObjectRecord;
import com.luna.insight.server.indexer.TrinityIndexer;
import com.luna.insight.server.indexer.TrinityTable;
import com.luna.insight.server.indexer.TrinityTermObjectToMap;
import com.luna.insight.server.indexer.TrinityTermToIndex;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityAddChange;
import com.luna.insight.server.inscribe.EntityChange;
import com.luna.insight.server.inscribe.EntityChangeList;
import com.luna.insight.server.inscribe.EntityField;
import com.luna.insight.server.inscribe.EntityFieldChange;
import com.luna.insight.server.inscribe.EntityFieldChangeDetails;
import com.luna.insight.server.inscribe.EntityIndexer;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityMapChange;
import com.luna.insight.server.inscribe.EntityMediaMapChange;
import com.luna.insight.server.inscribe.EntityRelationship;
import com.luna.insight.server.inscribe.EntityType;
import com.luna.insight.server.inscribe.EntityValueDetails;
import com.luna.insight.server.inscribe.MedeConnector;
import com.luna.insight.server.inscribe.MedeTermProcessor;
import com.luna.insight.server.inscribe.MedeTermProcessorDetails;
import com.luna.insight.server.inscribe.MedeTermProcessorScheduler;
import com.luna.insight.server.inscribe.ValueTermDetails;
import com.luna.insight.server.ucb.FuzzyDateJulianRange;
import com.luna.insight.server.ucb.UcbFuzzyDateMachine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class MedePublisher
extends Thread
implements InsightTableNames {
    public static final String BUILD_DATE = "09Dec2010";
    public static final long DEFAULT_PUBLISH_CHANGES_INTERVAL = 300000L;
    public static final long DEFAULT_GATHER_INFO_INTERVAL = 28800000L;
    public static final boolean DEFAULT_PUBLISH_CHANGES_BLOCK_MODE = true;
    public static final int DEFAULT_PUBLISH_CHANGES_BATCH_SIZE = 0;
    public static final int DEFAULT_PUBLISH_TERM_INDEX_MODE = 1;
    public static final long DEFAULT_PUBLISH_TERM_INDEX_INTERVAL = 0L;
    protected static final boolean USE_TEMP_TABLES = false;
    protected MedeConnector medeBackend;
    protected Field[] fields = null;
    protected Map tables = new HashMap();
    protected Map entityTypes = new HashMap();
    protected Map preferredEntityTypeIDs = new HashMap();
    protected Map entityFields = new HashMap();
    protected Map entityRelations = new HashMap();
    protected Map valueTerms = new HashMap();
    protected String[] stopList = null;
    protected Map dataColumnLengths = new HashMap();
    protected String tableValues = "DTVALUES";
    protected String tableTerms = "DTTERMS";
    protected String tableValueToEntityMap = "DTVALUETOENTITYMAP";
    protected String tableEntityToEntityMap = "DTENTITYTOENTITYMAP";
    protected String tableTermToEntityMap = "DTTERMTOENTITYMAP";
    protected String tableEntityToMediaMap = "IRENTITYMEDIAMAP";
    protected String tableValueToObjectMap = "DTVALUETOOBJECT";
    protected String tableTermToObjectMap = "DTTERMOBJECTMAP";
    protected String tableObjectToImageMap = "IROBJECTIMAGEMAP";
    protected DiacriticMappings dcMappings;
    protected long msPublishChangesInterval = 300000L;
    protected long msGatherInfoInterval = 28800000L;
    protected boolean isPublishBlocking = true;
    protected int publishBatchSize = 0;
    protected int termIndexingMode = 1;
    protected long termIndexingInterval = 0L;
    protected Calendar termIndexingFirstTime = null;
    protected MutableBoolean isPublishChangesLock = new MutableBoolean(false);
    protected MutableObject isPublishChangesLockUID = new MutableObject();
    protected boolean stillNeeded = true;
    protected InsightSmartServer server = null;
    protected Map lastGatherEntityInfoTimes = Collections.synchronizedMap(new HashMap());

    public static void debugOut(String string) {
        MedePublisher.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MedePublisher: " + string, n);
    }

    public static void newLine() {
        Debug.debugOut("", 2);
    }

    public static String getClassName() {
        return "com.luna.insight.server.inscribe.MedePublisher";
    }

    public MedePublisher(MedeConnector medeConnector) {
        this(medeConnector, 300000L, 28800000L, true, 0, 1, 0L, null, null);
    }

    public MedePublisher(MedeConnector medeConnector, long l, long l2, boolean bl, int n, int n2, long l3, Calendar calendar, InsightSmartServer insightSmartServer) {
        this.medeBackend = medeConnector;
        this.msPublishChangesInterval = l;
        this.msGatherInfoInterval = l2;
        this.isPublishBlocking = bl;
        this.publishBatchSize = n;
        this.termIndexingMode = n2;
        this.termIndexingInterval = l3;
        this.termIndexingFirstTime = calendar;
        this.server = insightSmartServer;
        medeConnector.setMedePublisher(this);
        MedePublisher.newLine();
        this.dcMappings = new DiacriticMappings();
        MedePublisher.newLine();
        if (!this.dcMappings.hasMappings()) {
            MedePublisher.debugOut("No DiacriticMappings found.");
            this.dcMappings = null;
        } else {
            MedePublisher.debugOut("DiacriticMappings found.");
        }
        if (n2 == 2) {
            if (l3 > 0L) {
                MedeTermProcessorScheduler.schedule(calendar, l3);
            }
        } else {
            this.termIndexingInterval = 0L;
        }
    }

    protected void clearValueTerms(Integer n) {
        if (n != null) {
            this.valueTerms.remove(n);
        }
    }

    protected Vector getValueTerms(Integer n, long l, String string) {
        if (string.length() < 50) {
            return null;
        }
        if (n == null) {
            return null;
        }
        Vector vector = (Vector)this.valueTerms.get(n);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            ValueTermDetails valueTermDetails = (ValueTermDetails)vector.elementAt(i);
            if (l != valueTermDetails.getValueID()) continue;
            return valueTermDetails.getTerms();
        }
        return null;
    }

    protected void putValueTerms(Integer n, long l, String string, Vector vector) {
        if (string.length() < 50) {
            return;
        }
        if (n == null) {
            return;
        }
        ValueTermDetails valueTermDetails = new ValueTermDetails(l, vector);
        Vector<ValueTermDetails> vector2 = (Vector<ValueTermDetails>)this.valueTerms.get(n);
        if (vector2 == null) {
            vector2 = new Vector<ValueTermDetails>(1);
            vector2.addElement(valueTermDetails);
            this.valueTerms.put(n, vector2);
            return;
        }
        if (vector2.size() > 300) {
            vector2.removeElementAt(0);
            vector2.addElement(valueTermDetails);
            this.valueTerms.put(n, vector2);
        } else {
            vector2.addElement(valueTermDetails);
        }
    }

    protected void clearPreferredEntityTypeID(Integer n) {
        if (n != null) {
            this.preferredEntityTypeIDs.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPreferredEntityTypeID(Integer n) {
        int n2 = EntityIndexer.DEFAULT_OBJ_ENTITY_TYPE_ID;
        Integer n3 = null;
        if (n != null) {
            n3 = (Integer)this.preferredEntityTypeIDs.get(n);
        }
        if (n3 == null) {
            DatabaseConnector databaseConnector = null;
            try {
                databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                n2 = TrinityConnector.getPreferredEntityTypeID(n, databaseConnector, sqlQueryGenerator);
                if (n != null) {
                    this.preferredEntityTypeIDs.put(n, new Integer(n2));
                }
                MedePublisher.debugOut("Stored preferredEntityTypeID into cache: " + n2);
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception while getting \"preferred\" entity type ID:\n" + InsightUtilities.getStackTrace(exception));
            }
            finally {
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
            }
        } else {
            n2 = n3;
            MedePublisher.debugOut("Returning preferredEntityTypeID from cache: " + n2);
        }
        return n2;
    }

    public void run() {
        System.out.println("");
        System.out.println("MedePublisher: Started. (interval " + this.msPublishChangesInterval + "ms)" + ", (GatherInfo interval " + this.msGatherInfoInterval + "ms)" + ", (Blocking " + this.isPublishBlocking + ")" + ", (Batch size " + this.publishBatchSize + ")" + ", (Term Indexing Mode " + this.termIndexingMode + ")" + ", (Term Indexing Interval " + this.termIndexingInterval + ")" + ", (Term Indexing Firsttime " + (this.termIndexingFirstTime != null ? this.termIndexingFirstTime.toString() : "none") + ")");
        System.out.println("MedePublisher: Build of 09Dec2010");
        System.out.println("");
        while (this.stillNeeded) {
            try {
                MedePublisher.sleep(this.msPublishChangesInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Iterator iterator = this.server.getUniqueCollectionIDs().iterator();
            while (iterator.hasNext()) {
                this.publishImmediately((Integer)iterator.next(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishImmediately(final Integer n, boolean bl) {
        if (!this.isPublishBlocking) {
            bl = false;
        }
        MedePublisher.debugOut("in publishImmediately(). Block=" + bl);
        try {
            while (true) {
                if (this.getPublishChangesLock(n)) {
                    long l = System.currentTimeMillis();
                    final Vector vector = new Vector(1);
                    Vector vector2 = this.publishChangesToInvertedData(n, vector);
                    if (vector2 == null) {
                        vector2 = new Vector();
                    }
                    vector2.addAll(this.publishChangesToSourceData(n));
                    List list = Entity.getUniqueEntityKeyList(vector2);
                    MedePublisher.debugOut("Marking eligible changes fully committed.");
                    this.medeBackend.markChangesFullyCommitted(n);
                    MedePublisher.debugOut("Unlocking expired/obsolete entity locks.");
                    this.medeBackend.unlockEntities(list);
                    if (list != null && list.size() > 0) {
                        this.server.clearEntityCaches();
                    }
                    if (InsightUtilities.isNonEmpty(vector)) {
                        Runnable runnable = new Runnable(){

                            public void run() {
                                MedePublisher.this.server.updateServerThumbnailCaches(n, vector);
                            }
                        };
                        new Thread(runnable).start();
                    }
                    MedePublisher.debugOut("Time spent in publishImmediately: " + (System.currentTimeMillis() - l));
                    this.releasePublishChangesLock();
                    break;
                }
                if (!bl && this.isPublishing(n)) {
                    MedePublisher.debugOut("Already publishing changes to this collection.");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.releasePublishChangesLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPartiallyCommittedTerms() {
        if (this.termIndexingMode == 0) {
            return;
        }
        Iterator iterator = this.server.getUniqueCollectionIDs().iterator();
        block5: while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            try {
                while (true) {
                    if (this.getPublishChangesLock(n)) {
                        this.processPartiallyCommittedTerms(n);
                        this.releasePublishChangesLock();
                        continue block5;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.releasePublishChangesLock();
            }
        }
    }

    public void processPartiallyCommittedTerms(Integer n) {
        List list;
        Vector<EntityChange> vector = null;
        MutableObject mutableObject = new MutableObject();
        MutableBoolean mutableBoolean = new MutableBoolean(true);
        while (mutableBoolean.getValue() && (list = this.medeBackend.getEntityChangeListsPartiallyCommitted(n, mutableObject, mutableBoolean, this.publishBatchSize)) != null && list.size() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                Vector<EntityKey> vector2;
                Object object;
                this.gatherEntityInfo(n);
                vector = new Vector<EntityChange>(1);
                List list2 = null;
                for (int i = 0; list != null && i < list.size(); ++i) {
                    object = (EntityChangeList)list.get(i);
                    vector2 = ((EntityChangeList)object).getEntityChanges();
                    for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                        vector.add((EntityChange)vector2.get(j));
                    }
                }
                if (vector.size() > 0) {
                    List list3 = this.getAllEntityAncestors(n, vector);
                    object = MedeConnector.createEntitiesSubClauseList(list3, "");
                    vector2 = new Vector<EntityKey>(1);
                    Vector<Long> vector3 = new Vector<Long>(1);
                    int n2 = this.getPreferredEntityTypeID(n);
                    for (int i = 0; i < list3.size(); ++i) {
                        EntityKey entityKey = (EntityKey)list3.get(i);
                        if (entityKey.getEntityTypeID() != n2) continue;
                        vector2.add(entityKey);
                        Long l = new Long(entityKey.getEntityID());
                        if (vector3.contains(l)) continue;
                        vector3.add(l);
                    }
                    List list4 = null;
                    List list5 = null;
                    if (vector2 != null && vector2.size() > 0) {
                        list4 = MedeConnector.createEntitiesSubClauseList(vector2, "");
                        list5 = InsightUtilities.getListStringList(vector3, 50);
                    }
                    List list6 = null;
                    Object object2 = new Vector<Long>(vector.size());
                    for (int i = 0; i < vector.size(); ++i) {
                        object2.add(new Long(((EntityChange)vector.get(i)).getChangeID()));
                    }
                    list6 = InsightUtilities.getListStringList(object2, 50);
                    object2 = new MedeTermProcessorDetails(this, n, (List)object, list2, list4, list5, list6);
                    MedeTermProcessor.prepareAndProcessTermIndexingInBackground((MedeTermProcessorDetails)object2);
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in processPartiallyCommittedTerms():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in processPartiallyCommittedTerms():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
    }

    public boolean isTermProcessingInBackground() {
        return this.termIndexingMode == 2;
    }

    public boolean isTermProcessingScheduled() {
        return this.termIndexingInterval > 0L;
    }

    public boolean isPublishing() {
        return this.isPublishChangesLock.getValue();
    }

    public boolean isPublishing(Integer n) {
        if (this.isPublishing()) {
            Integer n2 = (Integer)this.isPublishChangesLockUID.getValue();
            return n != null && n2 != null && n.equals(n2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPublishChangesLock(Integer n) {
        boolean bl = false;
        MutableBoolean mutableBoolean = this.isPublishChangesLock;
        synchronized (mutableBoolean) {
            if (!this.isPublishChangesLock.getValue()) {
                this.isPublishChangesLock.setValue(true);
                this.isPublishChangesLockUID.setValue(n);
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePublishChangesLock() {
        MutableBoolean mutableBoolean = this.isPublishChangesLock;
        synchronized (mutableBoolean) {
            if (this.isPublishChangesLock.getValue()) {
                this.isPublishChangesLock.setValue(false);
                this.isPublishChangesLockUID.setValue(null);
            }
        }
    }

    public void setStillNeeded(boolean bl) {
        this.stillNeeded = bl;
    }

    protected int getDataColumnLength(String string, String string2, DatabaseConnector databaseConnector) {
        int n = -1;
        String string3 = "[TAB]" + string + "[COL]" + string2;
        Integer n2 = (Integer)this.dataColumnLengths.get(string3);
        if (n2 == null) {
            n = SqlQueryGenerator.getDataColumnLength(string, string2, databaseConnector);
            if (n > 0) {
                this.dataColumnLengths.put(string3, new Integer(n));
            }
        } else {
            n = n2;
        }
        return n;
    }

    private void doFlatObjectDataPopulation(Integer n, List list, List list2, int n2, List list3, DatabaseConnector databaseConnector) {
        List list4 = InsightUtilities.getListStringList(list3, 50);
        if (list4 == null || InsightUtilities.isEmpty((String)list4.get(0))) {
            return;
        }
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object;
            int n3;
            TreeMap treeMap = new TreeMap();
            for (n3 = 0; list3 != null && n3 < list3.size(); ++n3) {
                TrinityIndexer.getFlatObjectRecord(treeMap, (Long)list3.get(n3), list, list2);
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.tableValueToObjectMap, null, "ObjectID");
            sqlQueryGenerator.addTable(this.tableValues, null, new String[]{"FieldID", "ValueText", "ValueNumber"});
            sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
            sqlQueryGenerator.addJoin(this.tableValueToObjectMap, this.tableValues, "ValueID", 0);
            sqlQueryGenerator.addJoin(this.tableValues, "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere("(" + TrinityConnector.createFieldIDClause((Vector)list, (Vector)list2, this.tableValues) + " AND (" + this.tableValues + ".UniqueCollectionID = " + n + ")" + " AND (" + this.tableValueToObjectMap + ".Preferred = 1)" + " AND (" + this.tableValues + ".Enabled = 1))");
            databaseConnector = this.getDatabaseConnector();
            for (n3 = 0; n3 < list4.size(); ++n3) {
                object = (String)list4.get(n3);
                int n4 = sqlQueryGenerator.appendToWhere("ObjectID IN (" + (String)object + ")");
                String string = sqlQueryGenerator.getQuery(true);
                databaseConnector.setQuery(string);
                MedePublisher.debugOut("Values query:\n" + string);
                MedePublisher.debugOut("");
                sqlQueryGenerator.removeWhereAppendage(n4);
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    TrinityFlatObjectRecord trinityFlatObjectRecord = TrinityIndexer.getFlatObjectRecord(treeMap, databaseConnector.getLongField("ObjectID"), list, list2);
                    trinityFlatObjectRecord.addFieldValue(databaseConnector.getIntegerField("FieldID"), InsightDataAnchor.getPlainText(TrinityConnector.getFieldValue(databaseConnector)), n2);
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
            for (n3 = 0; n3 < list4.size(); ++n3) {
                object = (String)list4.get(n3);
                databaseConnector.setQuery("DELETE FROM DTFLATOBJECTDATA WHERE ObjectID IN (" + (String)object + ")");
                MedePublisher.debugOut("Remove changed objects from DTFLATOBJECTDATA:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
            MedePublisher.debugOut("Writing the flat object records.");
            MedePublisher.debugOut("");
            SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
            object = treeMap.values().iterator();
            while (object.hasNext()) {
                databaseConnector.setQuery(((TrinityFlatObjectRecord)object.next()).getInsertStatement(n, "DTFLATOBJECTDATA", sqlQueryGenerator2));
                MedePublisher.debugOut("Update DTFLATOBJECTDATA command:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in doFlatObjectDataPopulation():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
    }

    public List publishChangesToInvertedData(Integer n, List list) {
        List list2;
        long l;
        Vector vector = null;
        Vector<EntityChange> vector2 = null;
        long l2 = l = System.currentTimeMillis();
        MedePublisher.debugOut("Searching for changes ready for inverted data commit.");
        MutableObject mutableObject = new MutableObject();
        MutableBoolean mutableBoolean = new MutableBoolean(true);
        while (mutableBoolean.getValue() && (list2 = this.medeBackend.getEntityChangeListsToCommit(n, true, false, mutableObject, mutableBoolean, this.publishBatchSize)) != null && list2.size() > 0) {
            DatabaseConnector databaseConnector;
            block43: {
                long l3;
                l2 = l3 = System.currentTimeMillis();
                databaseConnector = this.getDatabaseConnector();
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    this.gatherEntityInfo(n);
                    vector2 = new Vector<EntityChange>(1);
                    boolean bl = true;
                    Vector vector3 = new Vector(1);
                    Vector vector4 = new Vector(1);
                    MutableBoolean mutableBoolean2 = new MutableBoolean(true);
                    TreeMap treeMap = new TreeMap();
                    for (int i = 0; list2 != null && i < list2.size(); ++i) {
                        EntityChangeList entityChangeList = (EntityChangeList)list2.get(i);
                        List list3 = entityChangeList.getEntityChanges();
                        for (int j = 0; list3 != null && j < list3.size(); ++j) {
                            EntityChange entityChange = (EntityChange)list3.get(j);
                            if (entityChange.getChangeCategory() == 5) {
                                if (!this.invertedDataCommitEntityAddChange(n, (EntityAddChange)entityChange, databaseConnector)) continue;
                                vector2.add(entityChange);
                                continue;
                            }
                            if (entityChange.getChangeCategory() == 1) {
                                if (this.invertedDataCommitEntityFieldChange(n, (EntityFieldChange)entityChange, databaseConnector, mutableBoolean2, treeMap, vector4)) {
                                    vector2.add(entityChange);
                                    if (!bl || vector3.contains(object4 = new Integer(((EntityFieldChange)entityChange).getFieldID()))) continue;
                                    vector3.add(object4);
                                    continue;
                                }
                                bl = false;
                                mutableBoolean2.setValue(false);
                                continue;
                            }
                            if (entityChange.getChangeCategory() == 2) {
                                if (this.invertedDataCommitEntityMapChange(n, (EntityMapChange)entityChange, databaseConnector)) {
                                    vector2.add(entityChange);
                                    mutableBoolean2.setValue(false);
                                    if (((EntityMapChange)entityChange).getChangeType() != 1) {
                                        bl = false;
                                        continue;
                                    }
                                    if (!bl) continue;
                                    object4 = this.getEntityType(n, ((EntityMapChange)entityChange).getEntityTypeID());
                                    if (object4 == null || ((EntityType)object4).isDependent()) {
                                        bl = false;
                                        continue;
                                    }
                                    object4 = this.getEntityType(n, ((EntityMapChange)entityChange).getRelatedEntityTypeID());
                                    if (object4 != null && ((EntityType)object4).isDependent()) continue;
                                    bl = false;
                                    continue;
                                }
                                bl = false;
                                continue;
                            }
                            if (entityChange.getChangeCategory() == 3) {
                                if (!entityChange.isSourceDataCommit() && !this.invertedDataCommitEntityMediaMapChange(n, (EntityMediaMapChange)entityChange, databaseConnector)) continue;
                                vector2.add(entityChange);
                                bl = false;
                                mutableBoolean2.setValue(false);
                                continue;
                            }
                            if (entityChange.getChangeCategory() != 4 || !this.invertedDataCommitEntityDelete(n, entityChange, databaseConnector)) continue;
                            vector2.add(entityChange);
                            bl = false;
                            mutableBoolean2.setValue(false);
                        }
                    }
                    l2 = l3 = System.currentTimeMillis();
                    if (bl) {
                        if (vector3.size() < 1 || vector3.size() > 100) {
                            bl = false;
                            vector3 = null;
                            vector4 = null;
                        } else if (vector4.size() < 1 || vector4.size() > 100) {
                            vector4 = null;
                        }
                    } else {
                        vector3 = null;
                        vector4 = null;
                    }
                    if (mutableBoolean2.getValue()) {
                        if (treeMap.isEmpty()) {
                            mutableBoolean2.setValue(false);
                        }
                        Iterator iterator = treeMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            Entity entity = (Entity)iterator.next();
                            object4 = (EntityFieldChangeDetails)treeMap.get(entity);
                            if (object4 == null || ((EntityFieldChangeDetails)object4).getNewValueID() == 0L) {
                                mutableBoolean2.setValue(false);
                                break;
                            }
                            int n2 = 0;
                            try {
                                databaseConnector.setQuery("SELECT COUNT(*) AS ValueCount FROM " + this.tableValueToEntityMap + " WHERE ValueID = " + ((EntityFieldChangeDetails)object4).getOldValueID() + " AND (RelEntityTypeID = 0 OR RelEntityID = 0)" + " AND UniqueCollectionID = " + n);
                                databaseConnector.runQuerySafe();
                                if (databaseConnector.more()) {
                                    n2 = databaseConnector.getIntegerField("ValueCount");
                                }
                                databaseConnector.close();
                            }
                            catch (Throwable throwable) {
                                mutableBoolean2.setValue(false);
                                databaseConnector.close();
                                break;
                            }
                            if (n2 <= 0) continue;
                            mutableBoolean2.setValue(false);
                            break;
                        }
                    }
                    if (vector2.size() <= 0) break block43;
                    if (vector == null) {
                        vector = vector2;
                    } else {
                        vector.addAll(vector2);
                    }
                    this.medeBackend.markChangesCommitted(vector2, true, false, this.isTermProcessingInBackground());
                    l2 = l3 = System.currentTimeMillis();
                    List list4 = this.getAllEntityAncestors(n, vector2);
                    l2 = l3 = System.currentTimeMillis();
                    List list5 = MedeConnector.createEntitiesSubClauseList(list4, "");
                    l2 = l3 = System.currentTimeMillis();
                    if (mutableBoolean2.getValue()) {
                        object4 = treeMap.keySet().iterator();
                        while (object4.hasNext()) {
                            Entity entity = (Entity)object4.next();
                            object3 = (EntityFieldChangeDetails)treeMap.get(entity);
                            if (object3 == null) continue;
                            MedePublisher.debugOut("Updating related entity values of ancestors.");
                            databaseConnector.setQuery("UPDATE " + this.tableValueToEntityMap + " SET ValueID = " + ((EntityFieldChangeDetails)object3).getNewValueID() + " WHERE ValueID = " + ((EntityFieldChangeDetails)object3).getOldValueID() + " AND (RelEntityTypeID > 0 OR RelEntityID > 0)" + " AND UniqueCollectionID = " + n);
                            MedePublisher.debugOut("Update related entity values of ancestors cmd:\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to update related entity values of ancestors: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                    } else {
                        MedePublisher.debugOut("Clearing related entity values of ancestors.");
                        for (int i = 0; i < list5.size(); ++i) {
                            String string = (String)list5.get(i);
                            databaseConnector.setQuery("DELETE FROM " + this.tableValueToEntityMap + " WHERE (RelEntityTypeID > 0 OR RelEntityID > 0)" + " AND (" + string + ") AND UniqueCollectionID = " + n + (vector4 != null ? " AND ValueID IN (" + InsightUtilities.getListString(vector4) + ")" : ""));
                            MedePublisher.debugOut("Delete related entity values of ancestors cmd:\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to clear related entity values of ancestors: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                        this.doEntityFlattening(n, list4, vector4);
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to flatten the affected entities: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                    }
                    object4 = new Vector<Object>(1);
                    Vector<Long> vector5 = new Vector<Long>(1);
                    int n3 = this.getPreferredEntityTypeID(n);
                    for (int i = 0; i < list4.size(); ++i) {
                        object3 = (EntityKey)list4.get(i);
                        if (object3.getEntityTypeID() != n3) continue;
                        object4.add(object3);
                        Long l4 = new Long(object3.getEntityID());
                        if (vector5.contains(l4)) continue;
                        vector5.add(l4);
                        if (list.contains(l4)) continue;
                        list.add(l4);
                    }
                    l2 = l3 = System.currentTimeMillis();
                    List list6 = null;
                    List list7 = null;
                    if (object4 != null && object4.size() > 0) {
                        String string;
                        int n4;
                        int n5;
                        list6 = MedeConnector.createEntitiesSubClauseList(object4, "");
                        list7 = InsightUtilities.getListStringList(vector5, 50);
                        MedePublisher.debugOut("Clearing legacy table " + this.tableValueToObjectMap + " of changed objects.");
                        for (n5 = 0; n5 < list7.size(); ++n5) {
                            object2 = (String)list7.get(n5);
                            databaseConnector.setQuery("DELETE FROM " + this.tableValueToObjectMap + " WHERE ObjectID IN (" + (String)object2 + ")" + (vector4 != null ? " AND ValueID IN (" + InsightUtilities.getListString(vector4) + ")" : ""));
                            MedePublisher.debugOut("Remove changed objects from " + this.tableValueToObjectMap + ":\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to clear legacy table ValueToObjectMap: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                        MedePublisher.debugOut("Updating legacy table " + this.tableValueToObjectMap + ".");
                        for (n5 = 0; n5 < list6.size(); ++n5) {
                            object2 = (String)list6.get(n5);
                            databaseConnector.setQuery("INSERT INTO " + this.tableValueToObjectMap + " (UniqueCollectionID, ValueID, ObjectID, Grouping, DisplayOrder, Preferred)" + " SELECT DISTINCT UniqueCollectionID" + ", ValueID" + ", EntityID AS ObjectID" + ", CAST(RelEntityID AS INTEGER)" + ", DisplayOrder" + ", Preferred" + " FROM " + this.tableValueToEntityMap + " WHERE (" + (String)object2 + ") AND UniqueCollectionID = " + n + (vector4 != null ? " AND ValueID IN (" + InsightUtilities.getListString(vector4) + ")" : ""));
                            MedePublisher.debugOut("Update " + this.tableValueToObjectMap + " command:\n" + databaseConnector.getQuery());
                            try {
                                databaseConnector.runUpdateQuerySafe();
                            }
                            catch (JdbcConnectorError jdbcConnectorError) {
                                MedePublisher.debugOut("CAST is not supported.  Trying the query without CAST");
                                databaseConnector.setQuery("INSERT INTO " + this.tableValueToObjectMap + " (UniqueCollectionID, ValueID, ObjectID, Grouping, DisplayOrder, Preferred)" + " SELECT DISTINCT UniqueCollectionID" + ", ValueID" + ", EntityID AS ObjectID" + ", RelEntityID" + ", DisplayOrder" + ", Preferred" + " FROM " + this.tableValueToEntityMap + " WHERE (" + (String)object2 + ") AND UniqueCollectionID = " + n + (vector4 != null ? " AND ValueID IN (" + InsightUtilities.getListString(vector4) + ")" : ""));
                                MedePublisher.debugOut("Update " + this.tableValueToObjectMap + " command:\n" + databaseConnector.getQuery());
                                databaseConnector.runUpdateQuerySafe();
                            }
                            databaseConnector.close();
                        }
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to update legacy table ValueToObjectMap: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                        object = this.getDatabaseConnector();
                        this.doFlatObjectDataPopulation(n, TrinityIndexer.getBrowserThumbFields(n, databaseConnector, (DatabaseConnector)object), TrinityIndexer.getBrowserSortFields(n, databaseConnector, (DatabaseConnector)object), 30, vector5, databaseConnector);
                        object.close();
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to update table TABLE_FLAT_OBJECT_DATA: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                        MedePublisher.debugOut("Clearing legacy table " + this.tableObjectToImageMap + " of changed objects.");
                        for (n4 = 0; n4 < list7.size(); ++n4) {
                            string = (String)list7.get(n4);
                            databaseConnector.setQuery("DELETE FROM " + this.tableObjectToImageMap + " WHERE ObjectID IN (" + string + ")");
                            MedePublisher.debugOut("Remove changed objects from " + this.tableObjectToImageMap + ":\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to clear legacy table ObjectToImageMap: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                        MedePublisher.debugOut("Updating legacy table " + this.tableObjectToImageMap + ".");
                        for (n4 = 0; n4 < list6.size(); ++n4) {
                            string = (String)list6.get(n4);
                            databaseConnector.setQuery("INSERT INTO " + this.tableObjectToImageMap + " (ObjectID, ImageID)" + " SELECT DISTINCT EntityID AS ObjectID" + ", MediaID AS ImageID" + " FROM " + this.tableEntityToMediaMap + " WHERE (" + string + ")");
                            MedePublisher.debugOut("Update " + this.tableObjectToImageMap + " command:\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                        MedePublisher.debugOut("\n\n\n***");
                        l3 = System.currentTimeMillis();
                        MedePublisher.debugOut("*** Total time to update legacy table ObjectToImageMap: " + (l3 - l2));
                        l2 = l3;
                        MedePublisher.debugOut("***\n\n\n");
                    }
                    object = null;
                    if (this.isTermProcessingInBackground()) {
                        Vector<Long> vector6 = new Vector<Long>(vector2.size());
                        for (int i = 0; i < vector2.size(); ++i) {
                            vector6.add(new Long(((EntityChange)vector2.get(i)).getChangeID()));
                        }
                        object = InsightUtilities.getListStringList(vector6, 50);
                    }
                    object2 = new MedeTermProcessorDetails(this, n, list5, vector3, list6, list7, (List)object);
                    MedeTermProcessor.prepareAndProcessTermIndexing((MedeTermProcessorDetails)object2);
                }
                catch (Exception exception) {
                    MedePublisher.debugOut("Exception in publishChangesToInvertedData():\n" + InsightUtilities.getStackTrace(exception));
                }
                catch (Error error) {
                    MedePublisher.debugOut("Error in publishChangesToInvertedData():\n" + InsightUtilities.getStackTrace(error));
                }
            }
            databaseConnector.close();
        }
        MedePublisher.debugOut("Total inverted data publishing time: " + (System.currentTimeMillis() - l));
        if (vector == null) {
            vector = new Vector(1);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invertedDataCommitEntityAddChange(Integer n, EntityAddChange entityAddChange, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (entityAddChange != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                MedePublisher.debugOut("Committing to inverted data: " + entityAddChange);
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, entityAddChange.getEntityTypeID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, entityAddChange.getEntityID());
                databaseConnector.setQuery("INSERT INTO ISCOLLECTIONENTITYMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                databaseConnector.runUpdateQuerySafe();
                bl = true;
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in invertedDataCommitEntityAddChange():\n" + InsightUtilities.getStackTrace(error));
                bl = false;
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in invertedDataCommitEntityAddChange():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            finally {
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
            }
        }
        return bl;
    }

    protected boolean invertedDataCommitEntityFieldChange(Integer n, EntityFieldChange entityFieldChange, DatabaseConnector databaseConnector, MutableBoolean mutableBoolean, Map map, List list) {
        boolean bl = false;
        if (entityFieldChange != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                MedePublisher.debugOut("Committing to inverted data: " + entityFieldChange);
                String string = entityFieldChange.getValueChange();
                if (this.dcMappings != null) {
                    string = this.dcMappings.normalize(string);
                }
                EntityField entityField = this.getEntityField(n, entityFieldChange.getEntityTypeID(), entityFieldChange.getFieldID());
                Field field = this.getField(entityFieldChange.getFieldID());
                long l = 0L;
                if (entityFieldChange.getChangeType() == 1) {
                    l = this.addValueMapping(n, InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength()), entityFieldChange.getEntityTypeID(), entityFieldChange.getEntityID(), field, "0", true, true);
                    Long l2 = new Long(l);
                    if (!list.contains(l2)) {
                        list.add(l2);
                    }
                    if (string != null && !string.equals(entityFieldChange.getValueChange())) {
                        mutableBoolean.setValue(false);
                        l = this.addValueMapping(n, InsightUtilities.truncate(string, entityField.getMaxValueLength()), entityFieldChange.getEntityTypeID(), entityFieldChange.getEntityID(), this.getField(entityFieldChange.getFieldID()), "0", false, false);
                        l2 = new Long(l);
                        if (!list.contains(l2)) {
                            list.add(l2);
                        }
                    }
                    bl = true;
                    if (l == 0L) {
                        mutableBoolean.setValue(false);
                    } else if (mutableBoolean.getValue()) {
                        Entity entity = new Entity(entityFieldChange.getEntityTypeID(), entityFieldChange.getEntityID());
                        Object object = map.keySet().iterator();
                        while (object.hasNext()) {
                            Entity entity2 = (Entity)object.next();
                            EntityFieldChangeDetails entityFieldChangeDetails = (EntityFieldChangeDetails)map.get(entity2);
                        }
                        object = (EntityFieldChangeDetails)map.get(entity);
                        if (object == null) {
                            mutableBoolean.setValue(false);
                        } else if (((EntityFieldChangeDetails)object).getNewValueID() > 0L) {
                            mutableBoolean.setValue(false);
                        } else {
                            ((EntityFieldChangeDetails)object).setNewValueID(l);
                        }
                    }
                } else if (entityFieldChange.getChangeType() == 2) {
                    l = this.removeValueMapping(n, InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength()), entityFieldChange.getEntityTypeID(), entityFieldChange.getEntityID(), this.getField(entityFieldChange.getFieldID()), "0", true);
                    Long l3 = new Long(l);
                    if (!list.contains(l3)) {
                        list.add(l3);
                    }
                    if (string != null && !string.equals(entityFieldChange.getValueChange())) {
                        mutableBoolean.setValue(false);
                        l = this.removeValueMapping(n, InsightUtilities.truncate(string, entityField.getMaxValueLength()), entityFieldChange.getEntityTypeID(), entityFieldChange.getEntityID(), this.getField(entityFieldChange.getFieldID()), "0", false);
                        l3 = new Long(l);
                        if (!list.contains(l3)) {
                            list.add(l3);
                        }
                    }
                    bl = true;
                    if (l == 0L) {
                        mutableBoolean.setValue(false);
                    } else if (mutableBoolean.getValue()) {
                        Entity entity = new Entity(entityFieldChange.getEntityTypeID(), entityFieldChange.getEntityID());
                        if (map.containsKey(entity)) {
                            mutableBoolean.setValue(false);
                        } else {
                            map.put(entity, new EntityFieldChangeDetails(l, 0L));
                        }
                    }
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in invertedDataCommitEntityFieldChange():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    protected boolean invertedDataCommitEntityMapChange(Integer n, EntityMapChange entityMapChange, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (entityMapChange != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                MedePublisher.debugOut("Committing to inverted data: " + entityMapChange);
                if (entityMapChange.getChangeType() == 1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, entityMapChange.getEntityTypeID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, entityMapChange.getEntityID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityTypeID", 2, stringBuffer2, entityMapChange.getRelatedEntityTypeID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityID", 2, stringBuffer2, entityMapChange.getRelatedEntityID());
                    databaseConnector.setQuery("INSERT INTO " + this.tableEntityToEntityMap + " (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    MedePublisher.debugOut("New entity-to-entity mapping cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    bl = true;
                } else if (entityMapChange.getChangeType() == 2) {
                    databaseConnector.setQuery("DELETE FROM " + this.tableEntityToEntityMap + " WHERE EntityTypeID = " + entityMapChange.getEntityTypeID() + " AND EntityID = " + entityMapChange.getEntityID() + " AND RelEntityTypeID = " + entityMapChange.getRelatedEntityTypeID() + " AND RelEntityID = " + entityMapChange.getRelatedEntityID());
                    MedePublisher.debugOut("Remove entity-to-entity mapping cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    EntityType entityType = this.getEntityType(n, entityMapChange.getRelatedEntityTypeID());
                    if (entityType != null && entityType.isDependent()) {
                        EntityChange entityChange = new EntityChange(EntityChange.getNextTempChangeID(), 4, 2, 1, entityMapChange.getApprovalLevel(), false, false, entityMapChange.getRelatedEntityTypeID(), entityMapChange.getRelatedEntityID(), entityMapChange.getUserID(), entityMapChange.getTimeStamp());
                        this.invertedDataCommitEntityDelete(n, entityChange, databaseConnector);
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in invertedDataCommitEntityMapChange():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    protected boolean invertedDataCommitEntityMediaMapChange(Integer n, EntityMediaMapChange entityMediaMapChange, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (entityMediaMapChange != null) {
            Serializable serializable;
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                MedePublisher.debugOut("Committing to inverted data: " + entityMediaMapChange);
                if (entityMediaMapChange.getChangeType() == 1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    serializable = new StringBuffer();
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, (StringBuffer)serializable, entityMediaMapChange.getEntityTypeID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, (StringBuffer)serializable, entityMediaMapChange.getEntityID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaID", 2, (StringBuffer)serializable, entityMediaMapChange.getMediaID() + "");
                    databaseConnector.setQuery("INSERT INTO " + this.tableEntityToMediaMap + " (" + stringBuffer.toString() + ")" + " VALUES (" + ((StringBuffer)serializable).toString() + ")");
                    MedePublisher.debugOut("New entity-to-media mapping cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    bl = true;
                } else if (entityMediaMapChange.getChangeType() == 2) {
                    databaseConnector.setQuery("DELETE FROM " + this.tableEntityToMediaMap + " WHERE EntityTypeID = " + entityMediaMapChange.getEntityTypeID() + " AND EntityID = " + entityMediaMapChange.getEntityID() + " AND MediaID = " + entityMediaMapChange.getMediaID());
                    MedePublisher.debugOut("Remove entity-to-media mapping cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    bl = true;
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in invertedDataCommitEntityMediaMapChange():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            databaseConnector.close();
            int n2 = this.getPreferredEntityTypeID(n);
            serializable = this.getEntityRelationship(n, n2, entityMediaMapChange.getEntityTypeID());
            if (serializable != null && ((EntityRelationship)serializable).getPublishRelatedMedia()) {
                this.copyRelatedMediaMappingChanges(entityMediaMapChange, n2);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyRelatedMediaMappingChanges(EntityMediaMapChange entityMediaMapChange, int n) {
        boolean bl = false;
        DatabaseConnector databaseConnector = null;
        try {
            MedePublisher.debugOut("Copying related media mapping changes.");
            databaseConnector = this.getDatabaseConnector();
            if (entityMediaMapChange.getChangeType() == 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("INSERT INTO " + this.tableEntityToMediaMap + "(EntityTypeID, EntityID, MediaID) ");
                stringBuffer.append("SELECT " + n + " AS EntityTypeID, " + this.tableEntityToEntityMap + ".EntityID AS EntityID, " + entityMediaMapChange.getMediaID() + " AS MediaID ");
                stringBuffer.append("FROM " + this.tableEntityToEntityMap + ", " + this.tableEntityToMediaMap + " WHERE (");
                stringBuffer.append(this.tableEntityToEntityMap + ".RelEntityTypeID = " + this.tableEntityToMediaMap + ".EntityTypeID AND ");
                stringBuffer.append(this.tableEntityToEntityMap + ".RelEntityID = " + this.tableEntityToMediaMap + ".EntityID ");
                stringBuffer.append(") AND (" + this.tableEntityToEntityMap + ".EntityTypeID = " + n + ") ");
                stringBuffer.append("AND (" + this.tableEntityToEntityMap + ".RelEntityTypeID = " + entityMediaMapChange.getEntityTypeID() + ") ");
                stringBuffer.append("AND (" + this.tableEntityToEntityMap + ".RelEntityID = " + entityMediaMapChange.getEntityID() + ")");
                databaseConnector.setQuery(stringBuffer.toString());
                MedePublisher.debugOut("Copy related media mappings query:\n" + databaseConnector.getQuery());
                int n2 = -1;
                try {
                    n2 = databaseConnector.runUpdateQuerySafe();
                }
                catch (JdbcConnectorError jdbcConnectorError) {
                    MedePublisher.debugOut("JdbcConnectorError while copying related media mappings: " + jdbcConnectorError);
                }
                MedePublisher.debugOut("Rows inserted = " + n2);
                bl = true;
            } else if (entityMediaMapChange.getChangeType() == 2) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT " + n + " AS EntityTypeID, " + this.tableEntityToEntityMap + ".EntityID AS EntityID, " + entityMediaMapChange.getMediaID() + " AS MediaID ");
                stringBuffer.append("FROM " + this.tableEntityToEntityMap + ", " + this.tableEntityToMediaMap + " WHERE (");
                stringBuffer.append(this.tableEntityToEntityMap + ".EntityTypeID = " + this.tableEntityToMediaMap + ".EntityTypeID AND ");
                stringBuffer.append(this.tableEntityToEntityMap + ".EntityID = " + this.tableEntityToMediaMap + ".EntityID ");
                stringBuffer.append(") AND (" + this.tableEntityToEntityMap + ".EntityTypeID = " + n + ") ");
                stringBuffer.append("AND (" + this.tableEntityToEntityMap + ".RelEntityTypeID = " + entityMediaMapChange.getEntityTypeID() + ") ");
                stringBuffer.append("AND (" + this.tableEntityToEntityMap + ".RelEntityID = " + entityMediaMapChange.getEntityID() + ") ");
                stringBuffer.append("AND (" + this.tableEntityToMediaMap + ".MediaID = " + entityMediaMapChange.getMediaID() + ")");
                Vector<Object> vector = new Vector<Object>();
                databaseConnector.setQuery(stringBuffer.toString());
                MedePublisher.debugOut("Select parent media mappings query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    try {
                        object = new long[]{databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), databaseConnector.getLongField("MediaID")};
                        vector.addElement(object);
                    }
                    catch (Exception exception) {
                        MedePublisher.debugOut("Exception getting existing parent entity media mappings:\n" + InsightUtilities.getStackTrace(exception));
                    }
                    databaseConnector.next();
                }
                if (vector.size() > 0) {
                    int n3;
                    object = new StringBuffer("DELETE FROM " + this.tableEntityToMediaMap + " WHERE (");
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        long[] lArray = (long[])vector.elementAt(n3);
                        if (n3 > 0) {
                            object.append(" OR ");
                        }
                        object.append("(EntityTypeID=" + lArray[0] + " AND EntityID=" + lArray[1] + " AND MediaID=" + lArray[2] + ")");
                    }
                    object.append(")");
                    databaseConnector.setQuery(object.toString());
                    MedePublisher.debugOut("Delete parent media mappings query:\n" + databaseConnector.getQuery());
                    n3 = -1;
                    try {
                        n3 = databaseConnector.runUpdateQuerySafe();
                    }
                    catch (JdbcConnectorError jdbcConnectorError) {
                        MedePublisher.debugOut("JdbcConnectorError while deleting parent media mappings: " + jdbcConnectorError);
                    }
                    MedePublisher.debugOut("Rows deleted = " + n3);
                }
                bl = true;
            }
            bl = true;
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in copyRelatedMediaMappingChanges():\n" + InsightUtilities.getStackTrace(exception));
            bl = false;
        }
        finally {
            databaseConnector.close();
        }
        return bl;
    }

    protected boolean invertedDataCommitEntityDelete(Integer n, EntityChange entityChange, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (entityChange != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                if (entityChange.getChangeCategory() == 4) {
                    MedePublisher.debugOut("Committing to inverted data: [ETID: " + entityChange.getEntityTypeID() + ", EID: " + entityChange.getEntityID() + "]-DELETE ENTITY");
                    Vector vector = (Vector)this.medeBackend.getDependentEntities(entityChange);
                    for (int i = 0; vector != null && i < vector.size(); ++i) {
                        Entity entity = (Entity)vector.get(i);
                        EntityChange entityChange2 = new EntityChange(EntityChange.getNextTempChangeID(), 4, 2, 1, entityChange.getApprovalLevel(), false, false, entity.getEntityTypeID(), entity.getEntityID(), entityChange.getUserID(), entityChange.getTimeStamp());
                        this.invertedDataCommitEntityDelete(n, entityChange2, databaseConnector);
                    }
                    databaseConnector.setQuery("DELETE FROM " + this.tableValueToEntityMap + " WHERE ((" + "EntityTypeID = " + entityChange.getEntityTypeID() + " AND EntityID = " + entityChange.getEntityID() + ") OR (" + "RelEntityTypeID = " + entityChange.getEntityTypeID() + " AND RelEntityID = " + entityChange.getEntityID() + ") OR (" + "ParentEntityTypeID = " + entityChange.getEntityTypeID() + " AND ParentEntityID = " + entityChange.getEntityID() + ")) AND UniqueCollectionID = " + n);
                    MedePublisher.debugOut("Delete from " + this.tableValueToEntityMap + " cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    databaseConnector.setQuery("DELETE FROM " + this.tableTermToEntityMap + " WHERE EntityTypeID = " + entityChange.getEntityTypeID() + " AND EntityID = " + entityChange.getEntityID() + " AND UniqueCollectionID = " + n);
                    MedePublisher.debugOut("Delete from " + this.tableTermToEntityMap + " cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    databaseConnector.setQuery("DELETE FROM " + this.tableEntityToEntityMap + " WHERE ((EntityTypeID = " + entityChange.getEntityTypeID() + " AND EntityID = " + entityChange.getEntityID() + ")" + " OR (RelEntityTypeID = " + entityChange.getEntityTypeID() + " AND RelEntityID = " + entityChange.getEntityID() + ")" + ") AND UniqueCollectionID = " + n);
                    MedePublisher.debugOut("Delete from " + this.tableEntityToEntityMap + " cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    databaseConnector.setQuery("DELETE FROM " + this.tableEntityToMediaMap + " WHERE (EntityTypeID = " + entityChange.getEntityTypeID() + " AND EntityID = " + entityChange.getEntityID() + ")");
                    MedePublisher.debugOut("Delete from " + this.tableEntityToMediaMap + " cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    EntityType entityType = this.getEntityType(n, entityChange.getEntityTypeID());
                    if (entityType != null && entityType.isDependent()) {
                        entityChange.setInvertedDataCommit(true);
                        this.medeBackend.writeEntityChange(n, entityChange, databaseConnector, true, null);
                    }
                    databaseConnector.close();
                    databaseConnector.setQuery("DELETE FROM ISCOLLECTIONENTITYMAP WHERE (EntityTypeID = " + entityChange.getEntityTypeID() + " AND EntityID = " + entityChange.getEntityID() + " AND UniqueCollectionID = " + n + ")");
                    databaseConnector.runUpdateQuery();
                    bl = true;
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in invertedDataCommitEntityDelete():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    protected long getMaxValueID() {
        return TrinityIndexer.getMaxValueID(this.getDatabaseConnector(), this.tableValues);
    }

    protected long getMaxTermID() {
        return TrinityIndexer.getMaxTermID(this.getDatabaseConnector(), this.tableTerms);
    }

    protected long addValueMapping(Integer n, String string, int n2, long l, Field field, String string2, boolean bl, boolean bl2) {
        long l2 = 0L;
        String string3 = string.trim();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            StringBuffer stringBuffer;
            CharSequence charSequence;
            boolean bl3 = false;
            if (field.fieldType == 2) {
                databaseConnector.setQuery("SELECT ValueID, ValueNumber FROM " + this.tableValues + " WHERE (ValueNumber = " + string3 + " AND FieldID = " + field.fieldID + " AND Enabled = " + (bl2 ? "1" : "0") + " AND UniqueCollectionID = " + n + ")");
            } else {
                databaseConnector.setQuery("SELECT ValueID, ValueText FROM " + this.tableValues + " WHERE (ValueText = " + this.prepStringForQuery(string3) + " AND FieldID = " + field.fieldID + " AND Enabled = " + (bl2 ? "1" : "0") + " AND UniqueCollectionID = " + n + ")");
            }
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                if (field.fieldType == 2) {
                    l2 = databaseConnector.getLongField("ValueID");
                    bl3 = true;
                    break;
                }
                charSequence = databaseConnector.getFieldByName("ValueText");
                if (charSequence != null && ((String)charSequence).equals(string3)) {
                    l2 = databaseConnector.getLongField("ValueID");
                    bl3 = true;
                    break;
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            if (!bl3) {
                charSequence = new StringBuffer();
                stringBuffer = new StringBuffer();
                l2 = this.getMaxValueID() + 1L;
                sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "UniqueCollectionID", 2, stringBuffer, n.toString());
                sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ValueID", 2, stringBuffer, l2 + "");
                sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "FieldID", 2, stringBuffer, field.fieldID + "");
                sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "Enabled", 2, stringBuffer, bl2 ? "1" : "0");
                if (field.fieldType == 2) {
                    sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ValueNumber", 2, stringBuffer, string3);
                } else {
                    sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ValueText", 1, stringBuffer, string3);
                }
                if (field.isDate()) {
                    FuzzyDateJulianRange fuzzyDateJulianRange = UcbFuzzyDateMachine.getFuzzyDateJulianRange(string3);
                    if (fuzzyDateJulianRange != null) {
                        sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ValueDate_Start", 2, stringBuffer, fuzzyDateJulianRange.getStartJulian() + "");
                        sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ValueDate_End", 2, stringBuffer, fuzzyDateJulianRange.getEndJulian() + "");
                    } else {
                        MedePublisher.debugOut("getFuzzyDataJulianRange failed.");
                    }
                }
                databaseConnector.setQuery("INSERT INTO " + this.tableValues + " (" + ((StringBuffer)charSequence).toString() + ")" + " VALUES (" + stringBuffer.toString() + ")");
                MedePublisher.debugOut("Insert new value '" + string3 + "' cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            charSequence = new StringBuffer();
            stringBuffer = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "UniqueCollectionID", 2, stringBuffer, n.toString());
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ValueID", 2, stringBuffer, l2 + "");
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "EntityTypeID", 2, stringBuffer, n2);
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "EntityID", 2, stringBuffer, l);
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "RelEntityTypeID", 2, stringBuffer, "0");
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "RelEntityID", 2, stringBuffer, "0");
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ParentEntityTypeID", 2, stringBuffer, "0");
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "ParentEntityID", 2, stringBuffer, "0");
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "DisplayOrder", 2, stringBuffer, "0");
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "Preferred", 2, stringBuffer, bl ? "1" : "0");
            sqlQueryGenerator.appendFieldAndValue((StringBuffer)charSequence, "Grouping", 1, stringBuffer, string2);
            databaseConnector.setQuery("INSERT INTO " + this.tableValueToEntityMap + " (" + ((StringBuffer)charSequence).toString() + ")" + " VALUES (" + stringBuffer.toString() + ")");
            MedePublisher.debugOut("Map value-to-entity cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in addValueMapping():\n" + InsightUtilities.getStackTrace(exception));
            l2 = 0L;
        }
        databaseConnector.close();
        return l2;
    }

    protected long removeValueMapping(Integer n, String string, int n2, long l, Field field, String string2, boolean bl) {
        long l2 = 0L;
        String string3 = string.trim();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            boolean bl2 = false;
            if (field.fieldType == 2) {
                databaseConnector.setQuery("SELECT ValueID, ValueNumber FROM " + this.tableValues + " WHERE (ValueNumber = " + string3 + " AND FieldID = " + field.fieldID + " AND Enabled = " + (bl ? "1" : "0") + " AND UniqueCollectionID = " + n + ")");
            } else {
                databaseConnector.setQuery("SELECT ValueID, ValueText FROM " + this.tableValues + " WHERE (ValueText = " + this.prepStringForQuery(string3) + " AND FieldID = " + field.fieldID + " AND Enabled = " + (bl ? "1" : "0") + " AND UniqueCollectionID = " + n + ")");
            }
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                if (field.fieldType == 2) {
                    l2 = databaseConnector.getLongField("ValueID");
                    bl2 = true;
                    break;
                }
                String string4 = databaseConnector.getFieldByName("ValueText");
                if (string4 != null && string4.equals(string3)) {
                    l2 = databaseConnector.getLongField("ValueID");
                    bl2 = true;
                    break;
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            if (bl2) {
                databaseConnector.setQuery("DELETE FROM " + this.tableValueToEntityMap + " WHERE ValueID = " + l2 + " AND EntityTypeID = " + n2 + " AND EntityID = " + l + " AND (RelEntityTypeID = 0 OR RelEntityID = 0)" + " AND UniqueCollectionID = " + n);
                MedePublisher.debugOut("Remove value-to-entity mapping cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in removeValueMapping():\n" + InsightUtilities.getStackTrace(exception));
            l2 = 0L;
        }
        databaseConnector.close();
        return l2;
    }

    protected List getAllEntityAncestors(Integer n, List list) {
        MedePublisher.debugOut("Get modified entity ancestors.");
        ArrayList<Object> arrayList = null;
        HashMap<String, Entity> hashMap = new HashMap<String, Entity>();
        if (list != null && list.size() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                Entity entity;
                int n2;
                String string;
                int n3;
                List list2 = MedeConnector.createEntitiesSubClauseList(list, this.tableValueToEntityMap, "RelEntityTypeID", "RelEntityID");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                sqlQueryGenerator.addTable(this.tableValueToEntityMap, new String[]{"EntityTypeID", "EntityID"});
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
                for (n3 = 0; n3 < list2.size(); ++n3) {
                    string = (String)list2.get(n3);
                    n2 = sqlQueryGenerator.appendToWhere(string);
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery(true));
                    sqlQueryGenerator.removeWhereAppendage(n2);
                    MedePublisher.debugOut("Get entity ancestors query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    while (databaseConnector.more()) {
                        entity = new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"));
                        hashMap.put(entity.getEntityKeyString(), entity);
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                }
                list2 = MedeConnector.createEntitiesSubClauseList(list, this.tableEntityToEntityMap, "RelEntityTypeID", "RelEntityID");
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                sqlQueryGenerator.addTable(this.tableEntityToEntityMap, new String[]{"EntityTypeID", "EntityID"});
                for (n3 = 0; n3 < list2.size(); ++n3) {
                    string = (String)list2.get(n3);
                    n2 = sqlQueryGenerator.appendToWhere(string);
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery(true));
                    sqlQueryGenerator.removeWhereAppendage(n2);
                    MedePublisher.debugOut("Get ancestors of entities w\\out native values query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    while (databaseConnector.more()) {
                        entity = new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"));
                        hashMap.put(entity.getEntityKeyString(), entity);
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                }
                for (n3 = 0; n3 < list.size(); ++n3) {
                    entity = new Entity(((EntityKey)list.get(n3)).getEntityTypeID(), ((EntityKey)list.get(n3)).getEntityID());
                    hashMap.put(entity.getEntityKeyString(), entity);
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in getAllEntityAncestors():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in getAllEntityAncestors():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        arrayList = !hashMap.isEmpty() ? new ArrayList(hashMap.values()) : new ArrayList(1);
        MedePublisher.debugOut("Modified entity ancestors retrieved.");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doEntityFlattening(Integer n, List list, List list2) {
        block24: {
            DatabaseConnector databaseConnector;
            block22: {
                MedePublisher.debugOut("Flatten entities.");
                if (list == null || list.size() <= 0) break block24;
                databaseConnector = this.getDatabaseConnector();
                SqlBatchController sqlBatchController = null;
                TreeMap treeMap = new TreeMap();
                MedePublisher.debugOut("Registering entity relationships.");
                for (int i = 0; list != null && i < list.size(); ++i) {
                    this.registerEntityMappings(n, treeMap, (Entity)list.get(i), databaseConnector, list2);
                }
                MedePublisher.debugOut("Gathering related entity copy commands.");
                List list3 = null;
                sqlBatchController = new SqlBatchController(this.getDatabaseConnector(), 100);
                MedePublisher.debugOut("Executing related entity copy commands");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                for (int i = 0; list != null && i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (!treeMap.containsKey(entity)) continue;
                    EntityIndexer.setRelatedEntities(treeMap, entity);
                    EntityIndexer.getRelatedEntitySqlCommands(n, entity, list3, this.tableValueToEntityMap, false, sqlBatchController, sqlQueryGenerator);
                }
                Object var12_14 = null;
                try {
                    if (sqlBatchController != null) {
                        sqlBatchController.executeRemainingCommands();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sqlBatchController != null) {
                    sqlBatchController.setStillNeeded(false);
                }
                break block22;
                {
                    catch (Exception exception) {
                        MedePublisher.debugOut("Exception in flattenEntities():\n" + InsightUtilities.getStackTrace(exception));
                        Object var12_15 = null;
                        try {
                            if (sqlBatchController != null) {
                                sqlBatchController.executeRemainingCommands();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        if (sqlBatchController != null) {
                            sqlBatchController.setStillNeeded(false);
                        }
                        break block22;
                    }
                    catch (Error error) {
                        MedePublisher.debugOut("Error in flattenEntities():\n" + InsightUtilities.getStackTrace(error));
                        Object var12_16 = null;
                        try {
                            if (sqlBatchController != null) {
                                sqlBatchController.executeRemainingCommands();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (sqlBatchController != null) {
                            sqlBatchController.setStillNeeded(false);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    try {
                        if (sqlBatchController != null) {
                            sqlBatchController.executeRemainingCommands();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (sqlBatchController != null) {
                        sqlBatchController.setStillNeeded(false);
                    }
                    throw throwable;
                }
            }
            databaseConnector.close();
        }
        MedePublisher.debugOut("Entity flattening complete.");
    }

    protected void registerEntityMappings(Integer n, Map map, Entity entity, DatabaseConnector databaseConnector, List list) {
        if (map != null && entity != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                if (!map.containsKey(entity)) {
                    boolean bl = false;
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable(this.tableEntityToEntityMap, "*");
                    sqlQueryGenerator.addTable(this.tableValueToEntityMap, new String[]{"ValueID", "Preferred", "DisplayOrder"});
                    sqlQueryGenerator.addJoin(this.tableEntityToEntityMap, new String[]{"RelEntityTypeID", "RelEntityID"}, this.tableValueToEntityMap, new String[]{"EntityTypeID", "EntityID"}, 0);
                    sqlQueryGenerator.appendToWhere("(" + this.tableValueToEntityMap + ".RelEntityTypeID = 0 OR " + this.tableValueToEntityMap + ".RelEntityID = 0)" + " AND " + this.tableEntityToEntityMap + ".EntityTypeID = " + entity.getEntityTypeID() + " AND " + this.tableEntityToEntityMap + ".EntityID = " + entity.getEntityID());
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    MedePublisher.debugOut("Get entity mappings query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    while (databaseConnector.more()) {
                        bl = true;
                        long l = databaseConnector.getLongField("ValueID");
                        EntityValueDetails entityValueDetails = null;
                        if (list == null || list.contains(new Long(l))) {
                            entityValueDetails = new EntityValueDetails(l, databaseConnector.getIntegerField("DisplayOrder"), databaseConnector.getBooleanField("Preferred"));
                        }
                        EntityIndexer.registerEntityMapping(map, new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID")), new Entity(databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getLongField("RelEntityID")), entityValueDetails);
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable(this.tableEntityToEntityMap, "*");
                    sqlQueryGenerator.appendToWhere(this.tableEntityToEntityMap + ".EntityTypeID = " + entity.getEntityTypeID() + " AND " + this.tableEntityToEntityMap + ".EntityID = " + entity.getEntityID());
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    MedePublisher.debugOut("Get entity mappings w\\out values query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    while (databaseConnector.more()) {
                        bl = true;
                        EntityIndexer.registerEntityMapping(map, new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID")), new Entity(databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getLongField("RelEntityID")), null);
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    if (!bl) {
                        EntityIndexer.registerEntityMapping(map, new Entity(entity.getEntityTypeID(), entity.getEntityID()), null, null);
                    }
                }
                List list2 = (List)map.get(entity);
                for (int i = 0; list2 != null && i < list2.size(); ++i) {
                    this.registerEntityMappings(n, map, (Entity)list2.get(i), databaseConnector, list);
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in registerEntityMappings():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in registerEntityMappings():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
    }

    protected void processTermIndexing(MedeTermProcessorDetails medeTermProcessorDetails) {
        Integer n = medeTermProcessorDetails.uniqueCollectionID;
        List list = medeTermProcessorDetails.entitySubClauseList;
        List list2 = medeTermProcessorDetails.fieldIDs;
        List list3 = medeTermProcessorDetails.objectsSubClauseList;
        List list4 = medeTermProcessorDetails.objectIDStrList;
        List list5 = medeTermProcessorDetails.changeIDStrList;
        long l = System.currentTimeMillis();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string;
            int n2;
            MedePublisher.debugOut("Clearing term mappings of ancestors.");
            for (n2 = 0; n2 < list.size(); ++n2) {
                string = (String)list.get(n2);
                databaseConnector.setQuery("DELETE FROM " + this.tableTermToEntityMap + " WHERE (" + string + ") AND UniqueCollectionID = " + n + (list2 != null ? " AND FieldID IN (" + InsightUtilities.getListString(list2) + ")" : ""));
                MedePublisher.debugOut("Delete term mappings of ancestors cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
            MedePublisher.debugOut("\n\n\n***");
            long l2 = System.currentTimeMillis();
            MedePublisher.debugOut("*** Total time to clear term mappings of ancestors: " + (l2 - l));
            l = l2;
            MedePublisher.debugOut("***\n\n\n");
            this.doTermIndexing(n, list, list2);
            MedePublisher.debugOut("\n\n\n***");
            l2 = System.currentTimeMillis();
            MedePublisher.debugOut("*** Total time to re-term index the affected entities: " + (l2 - l));
            l = l2;
            MedePublisher.debugOut("***\n\n\n");
            if (list3 != null) {
                MedePublisher.debugOut("Clearing legacy table " + this.tableTermToObjectMap + " of changed objects.");
                for (n2 = 0; n2 < list4.size(); ++n2) {
                    string = (String)list4.get(n2);
                    databaseConnector.setQuery("DELETE FROM " + this.tableTermToObjectMap + " WHERE ObjectID IN (" + string + ")" + (list2 != null ? " AND FieldID IN (" + InsightUtilities.getListString(list2) + ")" : ""));
                    MedePublisher.debugOut("Remove changed objects from " + this.tableTermToObjectMap + ":\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                }
                MedePublisher.debugOut("\n\n\n***");
                l2 = System.currentTimeMillis();
                MedePublisher.debugOut("*** Total time to clear legacy table TermToObjectMap: " + (l2 - l));
                l = l2;
                MedePublisher.debugOut("***\n\n\n");
                MedePublisher.debugOut("Updating legacy table " + this.tableTermToObjectMap + ".");
                for (n2 = 0; n2 < list3.size(); ++n2) {
                    string = (String)list3.get(n2);
                    databaseConnector.setQuery("INSERT INTO " + this.tableTermToObjectMap + " (UniqueCollectionID, TermID, ObjectID, FieldID, Grouping)" + " SELECT DISTINCT UniqueCollectionID" + ", TermID" + ", EntityID AS ObjectID" + ", FieldID" + ", Grouping" + " FROM " + this.tableTermToEntityMap + " WHERE (" + string + ") AND UniqueCollectionID = " + n + (list2 != null ? " AND FieldID IN (" + InsightUtilities.getListString(list2) + ")" : ""));
                    MedePublisher.debugOut("Update " + this.tableTermToObjectMap + " command:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                }
                MedePublisher.debugOut("\n\n\n***");
                l2 = System.currentTimeMillis();
                MedePublisher.debugOut("*** Total time to update legacy table TermToObjectMap: " + (l2 - l));
                l = l2;
                MedePublisher.debugOut("***\n\n\n");
            }
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in processTermIndexing():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            MedePublisher.debugOut("Error in processTermIndexing():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        this.medeBackend.markChangesCommittedFullState(list5);
    }

    protected void doTermIndexing(Integer n, List list, List list2) {
        MedePublisher.debugOut("Term index the entities.");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                TreeMap treeMap = new TreeMap();
                Collection collection = treeMap.values();
                boolean bl = true;
                MedePublisher.debugOut("Reading values to parse for terms.");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable(this.tableValues, null, "*");
                sqlQueryGenerator.addTable(this.tableValueToEntityMap, null, new String[]{"EntityTypeID", "EntityID", "Grouping"});
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addJoin(this.tableValueToEntityMap, this.tableValues, "ValueID", 0);
                sqlQueryGenerator.addJoin(this.tableValues, "IRFIELDS", new String[]{"FieldID"}, 0);
                sqlQueryGenerator.addJoin("IRFIELDS", new String[]{"FieldType"}, "IRTYPES", new String[]{"TypeID"}, 0);
                String string2 = "(IRFIELDS.KeywordSearchable = 1) AND (" + string + ")";
                sqlQueryGenerator.appendToWhere(string2);
                if (list2 != null) {
                    sqlQueryGenerator.appendToWhere(this.tableValues + ".FieldID IN (" + InsightUtilities.getListString(list2) + ")");
                }
                sqlQueryGenerator.appendToWhere(this.tableValues + ".UniqueCollectionID = " + n);
                sqlQueryGenerator.addOrderBy(this.tableValues, "ValueID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                MedePublisher.debugOut("Get terms query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                long l = -1L;
                Vector vector = null;
                while (databaseConnector.more()) {
                    String string3;
                    try {
                        string3 = TrinityConnector.getFieldValue(databaseConnector);
                    }
                    catch (Exception exception) {
                        string3 = null;
                    }
                    if (string3 != null) {
                        Vector vector2;
                        bl = false;
                        long l2 = databaseConnector.getLongField("ValueID");
                        if (l2 == l) {
                            vector2 = vector;
                        } else {
                            vector2 = this.getValueTerms(n, l2, string3 = string3.trim());
                            if (vector2 == null) {
                                vector2 = EntityIndexer.parseTerms(string3, this.stopList);
                                this.putValueTerms(n, l2, string3, vector2);
                            }
                            l = l2;
                            vector = vector2;
                        }
                        int n2 = databaseConnector.getIntegerField("EntityTypeID");
                        long l3 = databaseConnector.getLongField("EntityID");
                        String string4 = databaseConnector.getField("Grouping");
                        EntityIndexer.registerTerms(treeMap, vector2, n2, l3, databaseConnector.getIntegerField("FieldID"), string4);
                    }
                    databaseConnector.next();
                }
                databaseConnector.close();
                if (bl) {
                    MedePublisher.debugOut("No terms found.");
                }
                MedePublisher.debugOut("Writing the terms.");
                Iterator iterator = collection.iterator();
                int n3 = 0;
                while (iterator.hasNext()) {
                    TrinityTermToIndex trinityTermToIndex = (TrinityTermToIndex)iterator.next();
                    this.writeTerm(n, trinityTermToIndex, databaseConnector);
                    ++n3;
                }
                treeMap = null;
                collection = null;
            }
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in doTermIndexing():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            MedePublisher.debugOut("Error in doTermIndexing():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        MedePublisher.debugOut("Terms indexing complete.");
    }

    protected void writeTerm(Integer n, TrinityTermToIndex trinityTermToIndex, DatabaseConnector databaseConnector) {
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2;
            long l = -1L;
            databaseConnector.setQuery("SELECT TermID FROM " + this.tableTerms + " WHERE Keyword = " + this.prepStringForQuery(trinityTermToIndex.getTerm()));
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l = databaseConnector.getLongField("TermID");
            }
            databaseConnector.close();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            if (l <= 0L) {
                l = this.getMaxTermID() + 1L;
                stringBuffer2 = new StringBuffer();
                stringBuffer = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "TermID", 2, stringBuffer, l);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "Keyword", 1, stringBuffer, trinityTermToIndex.getTerm());
                databaseConnector.setQuery("INSERT INTO " + this.tableTerms + " (" + stringBuffer2.toString() + ")" + " VALUES (" + stringBuffer.toString() + ")");
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
            Iterator iterator = trinityTermToIndex.getEntityIDs();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                for (int i = 0; i < vector.size(); ++i) {
                    TrinityTermObjectToMap trinityTermObjectToMap = (TrinityTermObjectToMap)vector.get(i);
                    stringBuffer2 = new StringBuffer();
                    stringBuffer = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "UniqueCollectionID", 2, stringBuffer, n.toString());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "TermID", 2, stringBuffer, l);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "EntityTypeID", 2, stringBuffer, trinityTermObjectToMap.getEntityTypeID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "EntityID", 2, stringBuffer, trinityTermObjectToMap.getEntityID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "FieldID", 2, stringBuffer, trinityTermObjectToMap.getFieldID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "Grouping", 2, stringBuffer, trinityTermObjectToMap.getGrouping());
                    databaseConnector.setQuery("INSERT INTO " + this.tableTermToEntityMap + " (" + stringBuffer2.toString() + ")" + " VALUES (" + stringBuffer.toString() + ")");
                    databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                }
            }
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in writeTerm():\n" + InsightUtilities.getStackTrace(exception), 3);
        }
        catch (Error error) {
            MedePublisher.debugOut("Error in writeTerm():\n" + InsightUtilities.getStackTrace(error), 3);
        }
        databaseConnector.close();
    }

    public List publishChangesToSourceData(Integer n) {
        List list;
        Vector vector = null;
        Vector<EntityChange> vector2 = null;
        long l = System.currentTimeMillis();
        MedePublisher.debugOut("Searching for changes ready for source data commit.");
        MutableObject mutableObject = new MutableObject();
        MutableBoolean mutableBoolean = new MutableBoolean(true);
        while (mutableBoolean.getValue() && (list = this.medeBackend.getEntityChangeListsToCommit(n, false, true, mutableObject, mutableBoolean, this.publishBatchSize)) != null && list.size() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                this.gatherEntityInfo(n);
                vector2 = new Vector<EntityChange>(1);
                for (int i = 0; list != null && i < list.size(); ++i) {
                    EntityChangeList entityChangeList = (EntityChangeList)list.get(i);
                    List list2 = entityChangeList.getEntityChanges();
                    for (int j = 0; list2 != null && j < list2.size(); ++j) {
                        EntityChange entityChange = (EntityChange)list2.get(j);
                        if (entityChange.getChangeCategory() == 5) {
                            vector2.add(entityChange);
                            continue;
                        }
                        if (entityChange.getChangeCategory() == 1) {
                            if (!this.sourceDataCommitEntityFieldChange(n, (EntityFieldChange)entityChange, databaseConnector)) continue;
                            vector2.add(entityChange);
                            continue;
                        }
                        if (entityChange.getChangeCategory() == 2) {
                            if (!this.sourceDataCommitEntityMapChange(n, (EntityMapChange)entityChange, databaseConnector)) continue;
                            vector2.add(entityChange);
                            continue;
                        }
                        if (entityChange.getChangeCategory() == 3) {
                            if (!entityChange.isInvertedDataCommit() && !this.invertedDataCommitEntityMediaMapChange(n, (EntityMediaMapChange)entityChange, databaseConnector)) continue;
                            vector2.add(entityChange);
                            continue;
                        }
                        if (entityChange.getChangeCategory() != 4 || !this.sourceDataCommitEntityDelete(n, entityChange, databaseConnector)) continue;
                        vector2.add(entityChange);
                    }
                }
                if (vector2.size() > 0) {
                    if (vector == null) {
                        vector = vector2;
                    } else {
                        vector.addAll(vector2);
                    }
                    this.medeBackend.markChangesCommitted(vector2, false, true, false);
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in publishChangesToSourceData():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in publishChangesToSourceData():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        MedePublisher.debugOut("Total source data publishing time: " + (System.currentTimeMillis() - l));
        if (vector == null) {
            vector = new Vector(1);
        }
        return vector;
    }

    protected boolean sourceDataCommitEntityFieldChange(Integer n, EntityFieldChange entityFieldChange, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (entityFieldChange != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                MedePublisher.debugOut("Committing to source data: " + entityFieldChange);
                EntityField entityField = this.getEntityField(n, entityFieldChange.getEntityTypeID(), entityFieldChange.getFieldID());
                if (entityField != null && entityField.getJoinID() == 0) {
                    CharSequence charSequence;
                    Object object;
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable(entityField.getEntityType().getTable().name, null, entityField.getFieldValueColumnName());
                    sqlQueryGenerator.appendToWhere(entityField.getEntityType().getEntityIDColumnName() + " = " + entityFieldChange.getEntityID());
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    MedePublisher.debugOut("Get current field value query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    boolean bl2 = databaseConnector.more();
                    databaseConnector.close();
                    String string = null;
                    String string2 = null;
                    if (InsightUtilities.isNonEmpty(entityField.getSrcHierarchyIDColumnName()) && InsightUtilities.isNonEmpty(entityField.getSrcHierarchyNodeIDColumnName()) && (object = entityFieldChange.getMetaData()) != null) {
                        charSequence = (String)object.get("HIERARCHY_NAME");
                        if (charSequence != null) {
                            string = this.medeBackend.getHierarchyID((String)charSequence, databaseConnector) + "";
                        }
                        string2 = (String)object.get("NODE_ID");
                    }
                    if (entityFieldChange.getChangeType() == 1) {
                        if (bl2) {
                            object = new StringBuffer();
                            if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2) && InsightUtilities.isNonEmpty(entityField.getSrcHierarchyIDColumnName()) && InsightUtilities.isNonEmpty(entityField.getSrcHierarchyNodeIDColumnName())) {
                                ((StringBuffer)object).append(", " + entityField.getSrcHierarchyIDColumnName() + " = " + this.prepStringForQuery(string));
                                ((StringBuffer)object).append(", " + entityField.getSrcHierarchyNodeIDColumnName() + " = " + this.prepStringForQuery(string2));
                            }
                            charSequence = "UPDATE " + entityField.getEntityType().getTable().name + " SET " + entityField.getFieldValueColumnName() + " = ";
                            String string3 = null;
                            string3 = entityField.getField().getFieldType() != 2 ? this.prepStringForQuery(InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength())) : this.escapeQuotes(InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength()));
                            charSequence = (String)charSequence + string3 + " " + ((StringBuffer)object).toString() + " WHERE " + entityField.getEntityType().getEntityIDColumnName() + " = " + entityFieldChange.getEntityID();
                            databaseConnector.setQuery((String)charSequence);
                            MedePublisher.debugOut("Update source entity cmd:\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        } else {
                            object = new StringBuffer();
                            charSequence = new StringBuffer();
                            SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
                            sqlQueryGenerator2.appendFieldAndValue((StringBuffer)object, entityField.getEntityType().getEntityIDColumnName(), 2, (StringBuffer)charSequence, entityFieldChange.getEntityID());
                            if (entityField.getField().getFieldType() != 2) {
                                sqlQueryGenerator2.appendFieldAndValue((StringBuffer)object, entityField.getFieldValueColumnName(), 1, (StringBuffer)charSequence, InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength()));
                            } else {
                                sqlQueryGenerator2.appendFieldAndValue((StringBuffer)object, entityField.getFieldValueColumnName(), 2, (StringBuffer)charSequence, InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength()));
                            }
                            if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2) && InsightUtilities.isNonEmpty(entityField.getSrcHierarchyIDColumnName()) && InsightUtilities.isNonEmpty(entityField.getSrcHierarchyNodeIDColumnName())) {
                                sqlQueryGenerator2.appendFieldAndValue((StringBuffer)object, entityField.getSrcHierarchyIDColumnName(), 2, (StringBuffer)charSequence, string);
                                sqlQueryGenerator2.appendFieldAndValue((StringBuffer)object, entityField.getSrcHierarchyNodeIDColumnName(), 2, (StringBuffer)charSequence, string2);
                            }
                            databaseConnector.setQuery("INSERT INTO " + entityField.getEntityType().getTable().name + " (" + ((StringBuffer)object).toString() + ")" + " VALUES (" + ((StringBuffer)charSequence).toString() + ")");
                            MedePublisher.debugOut("Insert source entity cmd:\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                    } else if (entityFieldChange.getChangeType() == 2 && bl2) {
                        object = "UPDATE " + entityField.getEntityType().getTable().name + " SET " + entityField.getFieldValueColumnName() + " = ";
                        object = entityField.getField().getFieldType() != 2 ? (String)object + "''" : (String)object + "NULL";
                        object = (String)object + " WHERE " + entityField.getEntityType().getEntityIDColumnName() + " = " + entityFieldChange.getEntityID() + " AND " + entityField.getFieldValueColumnName() + " = ";
                        charSequence = null;
                        charSequence = entityField.getField().getFieldType() != 2 ? this.prepStringForQuery(InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength())) : this.escapeQuotes(InsightUtilities.truncate(entityFieldChange.getValueChange(), entityField.getMaxValueLength()));
                        object = (String)object + (String)charSequence;
                        databaseConnector.setQuery((String)object);
                        MedePublisher.debugOut("Delete source entity value cmd:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in sourceDataCommitEntityFieldChange():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in sourceDataCommitEntityFieldChange():\n" + InsightUtilities.getStackTrace(error));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    protected void sourceDataCommitMissingData(int n, EntityRelationship entityRelationship, int n2, long l, DatabaseConnector databaseConnector) {
        try {
            if (n != 1) {
                return;
            }
            EntityType entityType = entityRelationship.getEntityType();
            if (!entityType.isDependent()) {
                return;
            }
            List list = entityType.getEntityFields();
            if (list == null || list.size() != 1) {
                return;
            }
            EntityField entityField = (EntityField)list.get(0);
            if (entityField == null || entityField.getJoinID() != 0) {
                return;
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(entityField.getEntityType().getTable().name, null, entityField.getFieldValueColumnName());
            sqlQueryGenerator.appendToWhere(entityField.getEntityType().getEntityIDColumnName() + " = " + l);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            MedePublisher.debugOut("Get current field value query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            boolean bl = databaseConnector.more();
            databaseConnector.close();
            if (!bl) {
                MedePublisher.debugOut("Commiting field value which may have been missing");
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, entityField.getEntityType().getEntityIDColumnName(), 2, stringBuffer2, l);
                databaseConnector.setQuery("INSERT INTO " + entityField.getEntityType().getTable().name + " (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                MedePublisher.debugOut("Insert source entity cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            MedePublisher.debugOut("Exception in sourceDataCommitMissingData():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            MedePublisher.debugOut("Error in sourceDataCommitMissingData():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    protected boolean sourceDataCommitEntityMapChange(Integer n, EntityMapChange entityMapChange, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (entityMapChange != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                MedePublisher.debugOut("Committing to source data: " + entityMapChange);
                EntityRelationship entityRelationship = this.getEntityRelationship(n, entityMapChange.getEntityTypeID(), entityMapChange.getRelatedEntityTypeID());
                if (entityRelationship != null && entityRelationship.getEntityType() != null && entityRelationship.getRelEntityType() != null && entityRelationship.getSourceMapTable() != null) {
                    if (entityMapChange.getChangeType() == 1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, entityRelationship.getEntityType().getEntityIDColumnName(), 2, stringBuffer2, entityMapChange.getEntityID());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, entityRelationship.getRelEntityType().getEntityIDColumnName(), 2, stringBuffer2, entityMapChange.getRelatedEntityID());
                        databaseConnector.setQuery("INSERT INTO " + entityRelationship.getSourceMapTable().name + " (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        MedePublisher.debugOut("New source entity-to-entity mapping cmd:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        bl = true;
                    } else if (entityMapChange.getChangeType() == 2) {
                        databaseConnector.setQuery("DELETE FROM " + entityRelationship.getSourceMapTable().name + " WHERE " + entityRelationship.getEntityType().getEntityIDColumnName() + " = " + entityMapChange.getEntityID() + " AND " + entityRelationship.getRelEntityType().getEntityIDColumnName() + " = " + entityMapChange.getRelatedEntityID());
                        MedePublisher.debugOut("Remove source entity-to-entity mapping cmd:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        bl = true;
                    }
                    if (bl) {
                        this.sourceDataCommitMissingData(entityMapChange.getChangeType(), entityRelationship, entityMapChange.getEntityTypeID(), entityMapChange.getEntityID(), databaseConnector);
                    }
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in sourceDataCommitEntityMapChange():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in sourceDataCommitEntityMapChange():\n" + InsightUtilities.getStackTrace(error));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    protected boolean sourceDataCommitEntityDelete(Integer n, EntityChange entityChange, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (entityChange != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                if (entityChange.getChangeCategory() == 4) {
                    MedePublisher.debugOut("Committing to source data: [ETID: " + entityChange.getEntityTypeID() + ", EID: " + entityChange.getEntityID() + "]-DELETE ENTITY");
                    EntityType entityType = this.getEntityType(n, entityChange.getEntityTypeID());
                    if (entityType != null) {
                        if (entityType.getTable() != null) {
                            databaseConnector.setQuery("DELETE FROM " + entityType.getTable().name + " WHERE " + entityType.getEntityIDColumnName() + " = " + entityChange.getEntityID());
                            MedePublisher.debugOut("Remove entity from entity table " + entityType.getTable().name + " cmd:\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                        List list = this.getEntityRelationships(n, entityChange.getEntityTypeID());
                        for (int i = 0; list != null && i < list.size(); ++i) {
                            EntityRelationship entityRelationship = (EntityRelationship)list.get(i);
                            if (entityRelationship == null || entityRelationship.getSourceMapTable() == null) continue;
                            databaseConnector.setQuery("DELETE FROM " + entityRelationship.getSourceMapTable().name + " WHERE " + entityType.getEntityIDColumnName() + " = " + entityChange.getEntityID());
                            MedePublisher.debugOut("Remove source entity mappings from " + entityRelationship.getSourceMapTable().name + " cmd:\n" + databaseConnector.getQuery());
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                        }
                    }
                    databaseConnector.setQuery("DELETE FROM " + this.tableEntityToMediaMap + " WHERE (EntityTypeID = " + entityChange.getEntityTypeID() + " AND EntityID = " + entityChange.getEntityID() + ")");
                    MedePublisher.debugOut("Delete from " + this.tableEntityToMediaMap + " cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    bl = true;
                }
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in sourceDataCommitEntityDelete():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            catch (Error error) {
                MedePublisher.debugOut("Error in sourceDataCommitEntityDelete():\n" + InsightUtilities.getStackTrace(error));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    protected Field getField(int n) {
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            if (this.fields[i].fieldID != n) continue;
            return this.fields[i];
        }
        return null;
    }

    protected TrinityTable getTable(Integer n, int n2) {
        TrinityTable[] trinityTableArray = (TrinityTable[])this.tables.get(n);
        for (int i = 0; trinityTableArray != null && i < trinityTableArray.length; ++i) {
            if (trinityTableArray[i].getTableID() != n2) continue;
            return trinityTableArray[i];
        }
        return null;
    }

    protected EntityType getEntityType(Integer n, int n2) {
        Iterator iterator = ((List)this.entityTypes.get(n)).iterator();
        while (iterator.hasNext()) {
            EntityType entityType = (EntityType)iterator.next();
            if (entityType.getEntityTypeID() != n2) continue;
            return entityType;
        }
        return null;
    }

    protected EntityField getEntityField(Integer n, int n2, int n3) {
        List list = (List)this.entityFields.get(n);
        if (list == null || list.size() == 0) {
            if (n == null) {
                return null;
            }
            this.getEntityFields(n);
            list = (List)this.entityFields.get(n);
            if (list == null) {
                return null;
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityField entityField = (EntityField)iterator.next();
            if (entityField.getEntityTypeID() != n2 || entityField.getFieldID() != n3) continue;
            return entityField;
        }
        return null;
    }

    protected EntityRelationship getEntityRelationship(Integer n, int n2, int n3) {
        List list = (List)this.entityRelations.get(n);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityRelationship entityRelationship = (EntityRelationship)iterator.next();
            if (entityRelationship.getEntityTypeID() != n2 || entityRelationship.getRelEntityTypeID() != n3) continue;
            return entityRelationship;
        }
        return null;
    }

    protected List getEntityRelationships(Integer n, int n2) {
        List list = (List)this.entityRelations.get(n);
        if (list == null) {
            return null;
        }
        Vector<EntityRelationship> vector = new Vector<EntityRelationship>(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityRelationship entityRelationship = (EntityRelationship)iterator.next();
            if (entityRelationship.getEntityTypeID() != n2 && entityRelationship.getRelEntityTypeID() != n2) continue;
            vector.add(entityRelationship);
        }
        return vector;
    }

    protected List getEntityRelationships(Integer n) {
        return (List)this.entityRelations.get(n);
    }

    protected long getLastGatherEntityInfoTime(Integer n) {
        long l = 0L;
        Long l2 = (Long)this.lastGatherEntityInfoTimes.get(n);
        if (l2 == null) {
            this.lastGatherEntityInfoTimes.put(n, new Long(l));
        } else {
            l = l2;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEntityInfo() {
        MedePublisher.debugOut("EntityInfo: clearing the cache");
        Map map = this.lastGatherEntityInfoTimes;
        synchronized (map) {
            this.lastGatherEntityInfoTimes = Collections.synchronizedMap(new HashMap());
        }
    }

    public void clearEntityInfo(Integer n) {
        if (n != null) {
            MedePublisher.debugOut("EntityInfo: clearing the cache for UID=" + n);
            this.lastGatherEntityInfoTimes.remove(n);
        }
    }

    public void gatherEntityInfo(Integer n) {
        long l = System.currentTimeMillis() - this.getLastGatherEntityInfoTime(n);
        boolean bl = l > this.msGatherInfoInterval;
        MedePublisher.debugOut(l + " ms passed since the last time the entity info was gathered for UID=" + n + ". Reload=" + bl);
        this.gatherFields(bl);
        this.gatherStopList(bl);
        if (n != null) {
            this.gatherTables(n, bl);
            this.getEntityTypes(n, bl);
            this.getEntityFields(n, bl);
            this.gatherEntityRelationships(n, bl);
        }
        if (bl && n != null) {
            this.lastGatherEntityInfoTimes.put(n, new Long(System.currentTimeMillis()));
            this.clearPreferredEntityTypeID(n);
            this.clearValueTerms(n);
        }
    }

    protected void gatherStopList(boolean bl) {
        if (bl || this.stopList == null) {
            try {
                this.stopList = TrinityIndexer.getStopList(this.getDatabaseConnector());
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception in gatherStopList():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
    }

    protected void gatherFields(boolean bl) {
        if (bl || this.fields == null) {
            this.fields = this.medeBackend.getFieldList(null);
        }
    }

    protected void gatherTables(Integer n, boolean bl) {
        if (bl || this.tables.get(n) == null) {
            MedePublisher.debugOut("");
            MedePublisher.debugOut("Gathering table information.");
            try {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("ISTABLES", null, "*");
                sqlQueryGenerator.appendToWhere("ISTABLES.UniqueCollectionID = " + n);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                MedePublisher.debugOut("Tables query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                Vector<TrinityTable> vector = new Vector<TrinityTable>();
                MedePublisher.debugOut("");
                if (databaseConnector.more()) {
                    while (databaseConnector.more()) {
                        TrinityTable trinityTable = new TrinityTable();
                        trinityTable.tableID = databaseConnector.getIntegerField("TableID");
                        trinityTable.name = databaseConnector.getStringField("TableName");
                        MedePublisher.debugOut("  Table #" + trinityTable.tableID + ": " + trinityTable.name);
                        vector.addElement(trinityTable);
                        databaseConnector.next();
                    }
                } else {
                    MedePublisher.debugOut("Cannot gather tables from ISTABLES table.");
                }
                databaseConnector.close();
                this.tables.put(n, vector.toArray(new TrinityTable[vector.size()]));
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception while gathering tables:\n" + InsightUtilities.convertStackTraceToString(exception));
            }
        }
    }

    public List getEntityTypes(Integer n) {
        this.gatherEntityInfo(n);
        return (List)this.entityTypes.get(n);
    }

    public List getEntityTypes(Integer n, boolean bl) {
        if (bl || this.entityTypes.get(n) == null) {
            MedePublisher.debugOut("");
            MedePublisher.debugOut("Gathering entity type information.");
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("ISENTITYTYPES", null, "*");
                sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + this.prepStringForQuery("NA") + ")");
                sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeDisplayOrder");
                sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeDisplayName");
                sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                MedePublisher.debugOut("Entity types query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                Vector<EntityType> vector = new Vector<EntityType>();
                MedePublisher.debugOut("");
                if (databaseConnector.more()) {
                    while (databaseConnector.more()) {
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        boolean bl5;
                        boolean bl6;
                        try {
                            bl6 = databaseConnector.getBooleanField("IsVocabulary");
                        }
                        catch (Exception exception) {
                            bl6 = false;
                        }
                        try {
                            bl5 = databaseConnector.getBooleanField("IsDependent");
                        }
                        catch (Exception exception) {
                            bl5 = false;
                        }
                        try {
                            bl4 = databaseConnector.getBooleanField("IsDupeCheckEnabled");
                        }
                        catch (Exception exception) {
                            bl4 = false;
                        }
                        try {
                            bl3 = databaseConnector.getBooleanField("IsRefCheckEnabled");
                        }
                        catch (Exception exception) {
                            bl3 = false;
                        }
                        try {
                            bl2 = databaseConnector.getBooleanField("IsPreferredEntity");
                        }
                        catch (Exception exception) {
                            bl2 = false;
                        }
                        EntityType entityType = new EntityType(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getStringField("EntityTypeName"), databaseConnector.getStringField("EntityTypeDisplayName"), databaseConnector.getIntegerField("EntityTypeDisplayOrder"), databaseConnector.getIntegerField("EntityTableID"), databaseConnector.getStringField("EntityIDColumnName"), databaseConnector.getIntegerField("RestrictionLevel"), bl6, bl5, bl4, bl3);
                        entityType.setPrimaryType(bl2);
                        entityType.setTable(this.getTable(n, entityType.getTableID()));
                        MedePublisher.debugOut("  Entity type #" + entityType.getEntityTypeID() + ": " + entityType.getName());
                        vector.add(entityType);
                        databaseConnector.next();
                    }
                } else {
                    MedePublisher.debugOut("  No entity types defined.");
                }
                this.entityTypes.put(n, vector);
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception while gathering entity type data:\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return (List)this.entityTypes.get(n);
    }

    public List getEntityFields(Integer n) {
        this.gatherEntityInfo(n);
        return (List)this.entityFields.get(n);
    }

    public List getEntityFields(Integer n, boolean bl) {
        if (bl || this.entityFields.get(n) == null || ((List)this.entityFields.get(n)).size() == 0) {
            MedePublisher.debugOut("");
            MedePublisher.debugOut("Gathering entity field information.");
            try {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                int n2 = this.getDataColumnLength("DTVALUES", "ValueText", databaseConnector);
                MedePublisher.debugOut("DTVALUES.ValueText data length: " + n2);
                int n3 = this.getDataColumnLength("DTVALUES", "ValueNumber", databaseConnector);
                MedePublisher.debugOut("DTVALUES.ValueNumber data length: " + n3);
                int n4 = this.getDataColumnLength("IRENTITYCHANGES", "ValueChange", databaseConnector);
                MedePublisher.debugOut("IRENTITYCHANGES.ValueChange data length: " + n4);
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("ISENTITYFIELDS", "*");
                sqlQueryGenerator.addJoin("ISENTITYFIELDS", "ISENTITYTYPES", "EntityTypeID", 0);
                sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + this.prepStringForQuery("NA") + ")");
                sqlQueryGenerator.addOrderBy("ISENTITYFIELDS", "EntityTypeID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                Vector<EntityField> vector = new Vector<EntityField>();
                MedePublisher.debugOut("");
                if (databaseConnector.more()) {
                    String string = null;
                    String string2 = null;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n5 = 0;
                    int n6 = 0;
                    DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
                    while (databaseConnector.more()) {
                        try {
                            string = databaseConnector.getStringField("HierarchyIDColumnName");
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                        try {
                            string2 = databaseConnector.getStringField("HierarchyNodeIDColumnName");
                        }
                        catch (Exception exception) {
                            string2 = null;
                        }
                        try {
                            bl3 = databaseConnector.getBooleanField("AlwaysValidateNewValues");
                        }
                        catch (Exception exception) {
                            bl3 = false;
                        }
                        try {
                            bl2 = databaseConnector.getBooleanField("DisplayInRelatedEntities");
                        }
                        catch (Exception exception) {
                            bl2 = false;
                        }
                        EntityField entityField = new EntityField(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getIntegerField("FieldID"), databaseConnector.getIntegerField("JoinID"), databaseConnector.getIntegerField("FieldTableID"), databaseConnector.getStringField("FieldValueColumnName"), databaseConnector.getStringField("PreferredValueColumnName"), string, string2);
                        entityField.setRestrictionLevel(databaseConnector.getIntegerField("RestrictionLevel"));
                        entityField.setRequired(databaseConnector.getBooleanField("IsRequired"));
                        entityField.setIntegerRange(IntegerRange.getIntegerRange(databaseConnector.getFieldByName("IntegerRange")));
                        entityField.setValueListAllowed(databaseConnector.getBooleanField("IsValueListAllowed"));
                        entityField.setMinApprovalToAddValue(databaseConnector.getIntegerField("MinApprovalToAddNewValue"));
                        entityField.setRepeatedValuesAllowed(databaseConnector.getBooleanField("RepeatValuesAllowed"));
                        entityField.setAlwaysValidateNewValue(bl3);
                        entityField.setDisplayInRelatedEntities(bl2);
                        EntityType entityType = this.getEntityType(n, entityField.getEntityTypeID());
                        if (entityType != null) {
                            entityField.setEntityType(entityType);
                            entityType.addEntityField(entityField);
                        }
                        entityField.setField(this.getField(entityField.getFieldID()));
                        entityField.setFieldTable(this.getTable(n, entityField.getFieldTableID()));
                        try {
                            if (entityField.getFieldTable() != null) {
                                n6 = this.getDataColumnLength(entityField.getFieldTable().getTableName(), entityField.getFieldValueColumnName(), databaseConnector2);
                                n5 = entityField.getField().getFieldType() == 2 ? Math.min(n6, Math.min(n3, n4)) : Math.min(n6, Math.min(n2, n4));
                            } else {
                                n5 = entityField.getField().getFieldType() == 2 ? Math.min(n3, n4) : Math.min(n2, n4);
                            }
                            entityField.setMaxValueLength(n5);
                        }
                        catch (Exception exception) {
                            MedePublisher.debugOut("Exception while calculating max value length for field: " + entityField.getFieldID() + "\n" + InsightUtilities.getStackTrace(exception));
                            entityField.setMaxValueLength(-1);
                        }
                        vector.add(entityField);
                        MedePublisher.debugOut("  Entity field # " + vector.size() + ": " + entityField.getEntityType().getName() + ": " + entityField.getFieldID() + ", Max value length: " + entityField.getMaxValueLength());
                        databaseConnector.next();
                    }
                } else {
                    MedePublisher.debugOut("  No entity fields defined.");
                }
                databaseConnector.close();
                this.entityFields.put(n, vector);
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception while gathering entity field data:\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return (List)this.entityFields.get(n);
    }

    protected void gatherEntityRelationships(Integer n, boolean bl) {
        if (bl || this.entityRelations.get(n) == null || ((List)this.entityRelations.get(n)).size() == 0) {
            MedePublisher.debugOut("");
            MedePublisher.debugOut("Gathering entity relationship information.");
            try {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("ISENTITYRELATIONSHIPS", "*");
                sqlQueryGenerator.addJoin("ISENTITYRELATIONSHIPS", "ISENTITYTYPES", "EntityTypeID", 0);
                sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + this.prepStringForQuery("NA") + ")");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                Vector<EntityRelationship> vector = new Vector<EntityRelationship>();
                MedePublisher.debugOut("");
                if (databaseConnector.more()) {
                    while (databaseConnector.more()) {
                        boolean bl2 = false;
                        try {
                            bl2 = databaseConnector.getBooleanField("PublishRelatedMedia");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n2 = -1;
                        try {
                            n2 = databaseConnector.getIntegerField("RelatedEntitiesAllowed");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        EntityRelationship entityRelationship = new EntityRelationship(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getIntegerField("JoinID"), databaseConnector.getIntegerField("SourceMapTableID"), bl2, n2);
                        entityRelationship.setEntityType(this.getEntityType(n, entityRelationship.getEntityTypeID()));
                        entityRelationship.setRelEntityType(this.getEntityType(n, entityRelationship.getRelEntityTypeID()));
                        entityRelationship.setSourceMapTable(this.getTable(n, entityRelationship.getSourceMapTableID()));
                        vector.add(entityRelationship);
                        MedePublisher.debugOut("  Entity relationship # " + vector.size() + ": " + (entityRelationship.getEntityType() == null ? "[" + entityRelationship.getEntityTypeID() + "]" : entityRelationship.getEntityType().getName()) + " to " + (entityRelationship.getRelEntityType() == null ? "[" + entityRelationship.getRelEntityTypeID() + "]" : entityRelationship.getRelEntityType().getName()));
                        databaseConnector.next();
                    }
                } else {
                    MedePublisher.debugOut("  No entity relationships defined.");
                }
                databaseConnector.close();
                this.entityRelations.put(n, vector);
            }
            catch (Exception exception) {
                MedePublisher.debugOut("Exception while gathering entity relationship data:\n" + InsightUtilities.getStackTrace(exception));
            }
        }
    }

    protected DatabaseConnector getDatabaseConnector() {
        return this.medeBackend.getDatabaseConnector();
    }

    protected SqlQueryGenerator getQueryGenerator() {
        return this.medeBackend.getQueryGenerator();
    }

    protected SqlQueryGenerator getQueryGeneratorUtil() {
        return this.medeBackend.getQueryGeneratorUtil();
    }

    protected String escapeQuotes(String string) {
        return this.medeBackend.escapeQuotes(string);
    }

    protected String prepStringForQuery(String string) {
        return this.medeBackend.prepStringForQuery(string);
    }
}

