/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.core.catalog.CatalogTemplate;
import com.luna.insight.core.catalog.TemplateEntityField;
import com.luna.insight.core.catalog.TemplateEntityType;
import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseEntityType;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.ICatalogEdit;
import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IEntityFieldEdit;
import com.luna.insight.core.catalog.iface.IEntityType;
import com.luna.insight.core.catalog.iface.IEntityTypeEdit;
import com.luna.insight.core.catalog.iface.ITemplate;
import com.luna.insight.core.catalog.iface.ITemplateEdit;
import com.luna.insight.core.util.IntegerRange;
import com.luna.insight.core.util.MutableBoolean;
import com.luna.insight.server.AudioFieldCriterion;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldStandardsManager;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightDataAnchor;
import com.luna.insight.server.InsightSmartServer;
import com.luna.insight.server.InsightSmartServicer;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.KeywordsFieldCriterion;
import com.luna.insight.server.MutableInteger;
import com.luna.insight.server.MutableObject;
import com.luna.insight.server.ObjectIndicatorFieldCriterion;
import com.luna.insight.server.OrphanSearchFieldCriterion;
import com.luna.insight.server.QtvrFieldCriterion;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.StringCriterionValue;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.VideoFieldCriterion;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.JdbcConnectorError;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlColumnSelection;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.collectionmanagement.CollectionBuildingObject;
import com.luna.insight.server.collectionmanagement.MappingStandard;
import com.luna.insight.server.hierarchy.HierarchyNodeFieldCriterion;
import com.luna.insight.server.indexer.TrinityFieldProfile;
import com.luna.insight.server.indexer.TrinityIndexer;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityAddChange;
import com.luna.insight.server.inscribe.EntityBuilder;
import com.luna.insight.server.inscribe.EntityChange;
import com.luna.insight.server.inscribe.EntityChangeList;
import com.luna.insight.server.inscribe.EntityChangeListBuilder;
import com.luna.insight.server.inscribe.EntityEquivalenceQuery;
import com.luna.insight.server.inscribe.EntityField;
import com.luna.insight.server.inscribe.EntityFieldChange;
import com.luna.insight.server.inscribe.EntityFieldValue;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyWrapper;
import com.luna.insight.server.inscribe.EntityLock;
import com.luna.insight.server.inscribe.EntityMapChange;
import com.luna.insight.server.inscribe.EntityMediaMapChange;
import com.luna.insight.server.inscribe.EntitySearchQuery;
import com.luna.insight.server.inscribe.EntitySearchResult;
import com.luna.insight.server.inscribe.EntityType;
import com.luna.insight.server.inscribe.EntityTypeBuilder;
import com.luna.insight.server.inscribe.EquivalenceClass;
import com.luna.insight.server.inscribe.EquivalenceCriterion;
import com.luna.insight.server.inscribe.EquivalenceEntityKeyWrapper;
import com.luna.insight.server.inscribe.EquivalenceRule;
import com.luna.insight.server.inscribe.FieldEquivalenceCriterion;
import com.luna.insight.server.inscribe.MedePublisher;
import com.luna.insight.server.inscribe.MediaSearchQuery;
import com.luna.insight.server.inscribe.MediaSearchResult;
import com.luna.insight.server.links.LinkFieldCriterion;
import com.luna.insight.server.mpd.MpdFieldCriterion;
import com.luna.insight.server.mvi.MviFieldCriterion;
import com.luna.insight.server.profile.CollectionProfile;
import com.luna.insight.server.theme.ThemeFileManager;
import com.luna.insight.server.ucb.FuzzyDateFieldCriterion;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class MedeConnector
extends TrinityConnector {
    public static final String browserRTLImage = "http://www.lunaimaging.com/support/remotelaunch/icon.gif";
    public static final String remoteLaunchLinkTemplate = "<a onFocus=\"this.blur()\" href=\"javascript:iw=window.open('$S1','RedirectorLaunch','height=300,width=500,x=' + ((screen.width-257) /2) + ',left=' + ((screen.width-257) /2) + ',y=' + ((screen.height-298) /2) + ',top=' + ((screen.height-257) /2) + ''); void(0);\">[open in Insight&#8482;]</a>";
    public static final int ENTITY_LOCK_TIMEOUT_MINS = 30;
    public static final int ID_LIST_BLOCK_SIZE = 50;
    protected static final Object ENTITY_LOCK_OBJECT = new Object();
    protected static final Object ENTITY_ID_LOCK_OBJECT = new Object();
    protected static final Object CHANGE_ID_LOCK_OBJECT = new Object();
    public String MEDE_VERSION_ID = InsightVersion.releaseName();
    public String MEDE_COMPONENT_CODE = "MedeConnector";
    protected MedePublisher publisher;

    public static String createFieldIDClause(TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2, String string) {
        int n;
        Vector<Integer> vector = new Vector<Integer>(1);
        for (n = 0; trinityFieldProfileArray != null && n < trinityFieldProfileArray.length; ++n) {
            if (trinityFieldProfileArray[n] == null || MedeConnector.intExistsInVector(vector, trinityFieldProfileArray[n].fieldID)) continue;
            vector.addElement(new Integer(trinityFieldProfileArray[n].fieldID));
        }
        for (n = 0; trinityFieldProfileArray2 != null && n < trinityFieldProfileArray2.length; ++n) {
            if (trinityFieldProfileArray2[n] == null || MedeConnector.intExistsInVector(vector, trinityFieldProfileArray2[n].fieldID)) continue;
            vector.addElement(new Integer(trinityFieldProfileArray2[n].fieldID));
        }
        String string2 = InsightUtilities.getListString(vector);
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            String string3 = "";
            if (string != null && string.length() > 0) {
                string3 = string + ".";
            }
            stringBuffer.append(string3 + "FieldID IN (" + string2 + ")");
        }
        return stringBuffer.toString();
    }

    public static String createEntitiesSubClause(List list, String string) {
        return MedeConnector.createEntitiesSubClause(list, string, "EntityTypeID", "EntityID");
    }

    public static String createEntitiesSubClause(List list, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        string = string != null && string.trim().length() > 0 ? string.trim() + "." : "";
        List list2 = MedeConnector.groupEntitiesByType(list);
        int n = 0;
        Vector<Long> vector = new Vector<Long>(0);
        for (int i = 0; i < list2.size(); ++i) {
            List list3 = (List)list2.get(i);
            int n2 = 0;
            while (n2 < list3.size()) {
                vector.clear();
                int n3 = 0;
                while (n2 < list3.size()) {
                    EntityKey entityKey = (EntityKey)list3.get(n2++);
                    n = entityKey.getEntityTypeID();
                    Long l = new Long(entityKey.getEntityID());
                    if (vector.contains(l)) continue;
                    vector.add(l);
                    if (++n3 < 50) continue;
                }
                if (vector.size() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(" + string + string2 + " = " + n + " AND " + string + string3 + " IN (" + InsightUtilities.getListString(vector) + "))");
            }
        }
        return stringBuffer.toString();
    }

    public static List createEntitiesSubClauseList(List list, String string) {
        return MedeConnector.createEntitiesSubClauseList(list, string, "EntityTypeID", "EntityID");
    }

    public static List createEntitiesSubClauseList(List list, String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>(0);
        StringBuffer stringBuffer = new StringBuffer();
        string = string != null && string.trim().length() > 0 ? string.trim() + "." : "";
        List list2 = MedeConnector.groupEntitiesByType(list);
        int n = 0;
        Vector<Long> vector2 = new Vector<Long>(0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < list2.size()) {
            List list3 = (List)list2.get(n3++);
            int n4 = 0;
            while (n4 < list3.size()) {
                vector2.clear();
                int n5 = 0;
                while (n4 < list3.size()) {
                    EntityKey entityKey = (EntityKey)list3.get(n4++);
                    n = entityKey.getEntityTypeID();
                    Long l = new Long(entityKey.getEntityID());
                    if (vector2.contains(l)) continue;
                    vector2.add(l);
                    if (++n5 < 50) continue;
                }
                if (vector2.size() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(" + string + string2 + " = " + n + " AND " + string + string3 + " IN (" + InsightUtilities.getListString(vector2) + "))");
                if (++n2 <= 2 || n4 >= list3.size() && n3 >= list2.size()) continue;
                vector.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                n2 = 0;
            }
        }
        vector.add(stringBuffer.toString());
        return vector;
    }

    public static List groupEntitiesByType(List list) {
        Vector vector = new Vector(0);
        Vector<EntityKey> vector2 = null;
        for (int i = 0; list != null && i < list.size(); ++i) {
            EntityKey entityKey = (EntityKey)list.get(i);
            vector2 = null;
            for (int j = vector.size() - 1; j >= 0 && ((EntityKey)(vector2 = (Vector<EntityKey>)vector.get(j)).get(0)).getEntityTypeID() != entityKey.getEntityTypeID(); --j) {
                vector2 = null;
            }
            if (vector2 == null) {
                vector2 = new Vector<EntityKey>(1);
                vector.add(vector2);
            }
            vector2.add(entityKey);
        }
        return vector;
    }

    public MedeConnector(Hashtable hashtable, MedePublisher medePublisher) {
        super(hashtable);
        this.setVersionID(this.MEDE_VERSION_ID);
        this.setComponentCode(this.MEDE_COMPONENT_CODE);
        this.setMedePublisher(medePublisher);
    }

    public String getImplementationName() {
        return "Multi-Entity Data Editor " + this.dbConnectorGenerator.getConnectorTypeString() + " Insight Backend";
    }

    public void setMedePublisher(MedePublisher medePublisher) {
        this.publisher = medePublisher;
    }

    public int getMedePermissions(int n, int n2) {
        int n3 = 0;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRPROFILE", null, "MEDEPermissions");
            sqlQueryGenerator.appendToWhere("ProfileId = " + n);
            sqlQueryGenerator.appendToWhere("CollectionId = " + n2);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n3 = databaseConnector.getIntegerField("MEDEPermissions");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMedePermissions():\n" + InsightUtilities.getStackTrace(exception));
            n3 = 0;
        }
        databaseConnector.close();
        return n3;
    }

    public int getApprovalLevel(int n, int n2) {
        int n3 = -1;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRPROFILE", null, "ApprovalLevel");
            sqlQueryGenerator.appendToWhere("ProfileId = " + n);
            sqlQueryGenerator.appendToWhere("CollectionId = " + n2);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n3 = databaseConnector.getIntegerField("ApprovalLevel");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getApprovalLevel():\n" + InsightUtilities.getStackTrace(exception));
            n3 = -1;
        }
        databaseConnector.close();
        return n3;
    }

    public int getEntityLockUserID(int n, long l) {
        return this.getEntityLockUserID(n, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntityLockUserID(int n, long l, DatabaseConnector databaseConnector) {
        int n2 = -1;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object = ENTITY_LOCK_OBJECT;
            synchronized (object) {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRENTITYLOCKS", null, "UserID");
                sqlQueryGenerator.appendToWhere("IRENTITYLOCKS.EntityTypeID = " + n + " AND " + "IRENTITYLOCKS" + ".EntityID = " + l);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get entity lock user ID:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerField("UserID");
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityLockUserID():\n" + InsightUtilities.getStackTrace(exception));
            n2 = -1;
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityLock getEntityLock(int n, long l, int n2) {
        EntityLock entityLock = new EntityLock(n, l);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            Object object = ENTITY_LOCK_OBJECT;
            synchronized (object) {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRUSERS", null, "*");
                sqlQueryGenerator.addTable("IRENTITYLOCKS", null, new String[]{"EntityTypeID", "EntityID", "IsLocked", "LockTimeStamp"});
                sqlQueryGenerator.addJoin("IRUSERS", "IRENTITYLOCKS", "UserID", 0);
                sqlQueryGenerator.appendToWhere("EntityTypeID = " + n + " AND EntityID = " + l);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Check entity lock query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    entityLock.setLockingUser(this.getInsightUser(databaseConnector));
                    entityLock.setLockTimeStamp(new SimpleDate(databaseConnector.getFieldByName("LockTimeStamp")));
                    if (entityLock.getLockingUser() != null && entityLock.getLockingUser().getUserID() == n2) {
                        entityLock.setLockStatus(1);
                    } else {
                        entityLock.setLockStatus(2);
                    }
                } else {
                    databaseConnector.close();
                    databaseConnector.setQuery("SELECT * FROM IRUSERS WHERE UserID = " + n2);
                    databaseConnector.runQuery();
                    entityLock.setLockingUser(databaseConnector.more() ? this.getInsightUser(databaseConnector) : null);
                    if (entityLock.getLockingUser() == null) {
                        entityLock.setLockStatus(2);
                    } else {
                        databaseConnector.close();
                        databaseConnector.setQuery("DELETE FROM IRENTITYLOCKS WHERE EntityTypeID = " + n + " AND EntityID = " + l);
                        databaseConnector.runUpdateQuery();
                        entityLock.setLockTimeStamp(new SimpleDate());
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, n);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, l);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, entityLock.getLockingUser().getUserID());
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "IsLocked", 2, stringBuffer2, 1);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "LockTimeStamp", 1, stringBuffer2, entityLock.getLockTimeStamp().get());
                        databaseConnector.close();
                        databaseConnector.setQuery("INSERT INTO IRENTITYLOCKS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Insert entity lock cmd:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        entityLock.setLockStatus(1);
                    }
                }
                if (entityLock.getLockingUser() != null) {
                    entityLock.getLockingUser().setUserID(-1);
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityLock():\n" + InsightUtilities.getStackTrace(exception));
            entityLock.setLockStatus(2);
        }
        catch (Error error) {
            this.debugOut("Error in getEntityLock():\n" + InsightUtilities.getStackTrace(error));
            entityLock.setLockStatus(2);
        }
        databaseConnector.close();
        return entityLock;
    }

    public boolean unlockEntity(int n, long l) {
        return this.unlockEntity(n, l, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockEntity(int n, long l, int n2, boolean bl) {
        boolean bl2 = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            Object object = ENTITY_LOCK_OBJECT;
            synchronized (object) {
                if (!(this.getEntityChangesCount(n, l, 1, databaseConnector) != 0 || bl && this.getEntityLockUserID(n, l, databaseConnector) != n2)) {
                    String string = "DELETE FROM IRENTITYLOCKS WHERE EntityTypeID = " + n + " AND EntityID = " + l;
                    if (bl) {
                        string = string + " AND UserID = " + n2;
                    }
                    databaseConnector.setQuery(string);
                    this.debugOut("Unlock entity cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    bl2 = true;
                } else {
                    bl2 = false;
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in unlockEntity():\n" + InsightUtilities.getStackTrace(exception));
            bl2 = false;
        }
        catch (Error error) {
            this.debugOut("Error in unlockEntity():\n" + InsightUtilities.getStackTrace(error));
            bl2 = false;
        }
        databaseConnector.close();
        return bl2;
    }

    public void unlockEntities(List list) {
        this.unlockEntities(30, list);
    }

    public void unlockEntities(int n, List list) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
        try {
            SimpleDate simpleDate = new SimpleDate();
            simpleDate.add(12, -n);
            databaseConnector.setQuery("SELECT EntityTypeID, EntityID FROM IRENTITYLOCKS WHERE ( SELECT COUNT(*) FROM IRENTITYCHANGES WHERE IRENTITYLOCKS.EntityTypeID = IRENTITYCHANGES.EntityTypeID AND IRENTITYLOCKS.EntityID = IRENTITYCHANGES.EntityID AND ChangeStatus = 1) = 0 AND LockTimeStamp < '" + simpleDate.get() + "'" + " ORDER BY LockTimeStamp");
            this.debugOut("Get expired entity locks query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                databaseConnector2.setQuery("DELETE FROM IRENTITYLOCKS WHERE EntityTypeID = " + databaseConnector.getIntegerField("EntityTypeID") + " AND EntityID = " + databaseConnector.getLongField("EntityID"));
                this.debugOut("Unlock entity cmd:\n" + databaseConnector2.getQuery());
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
                databaseConnector.next();
            }
            databaseConnector.close();
            if (list != null && list.size() > 0) {
                int n2 = 50;
                Vector vector = new Vector(Math.min(n2, list.size()));
                int n3 = 0;
                while (list != null && n3 < list.size()) {
                    vector.clear();
                    for (int i = n3; i < list.size() && vector.size() < n2; ++i) {
                        vector.add(list.get(i));
                        ++n3;
                    }
                    String string = MedeConnector.createEntitiesSubClause(vector, "IRENTITYLOCKS");
                    if (vector.size() <= 0 || string == null || string.length() <= 0) continue;
                    databaseConnector.setQuery("SELECT EntityTypeID, EntityID FROM IRENTITYLOCKS WHERE ( SELECT COUNT(*) FROM IRENTITYCHANGES WHERE IRENTITYLOCKS.EntityTypeID = IRENTITYCHANGES.EntityTypeID AND IRENTITYLOCKS.EntityID = IRENTITYCHANGES.EntityID AND ChangeStatus = 1) = 0 AND (" + string + ")" + " ORDER BY LockTimeStamp");
                    this.debugOut("Get unnecessary entity locks query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    while (databaseConnector.more()) {
                        databaseConnector2.setQuery("DELETE FROM IRENTITYLOCKS WHERE EntityTypeID = " + databaseConnector.getIntegerField("EntityTypeID") + " AND EntityID = " + databaseConnector.getLongField("EntityID"));
                        this.debugOut("Unlock entity cmd:\n" + databaseConnector2.getQuery());
                        databaseConnector2.runUpdateQuery();
                        databaseConnector2.close();
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in unlockEntities():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in unlockEntities():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        databaseConnector2.close();
    }

    public boolean saveEntityChanges(Integer n, List list, int n2, int n3, int n4, boolean bl) {
        if (list != null && list.size() > 0 && n4 > -1) {
            return this.saveEntityChanges(n, list, this.getApprovalLevel(n2, n3), n4, bl);
        }
        return false;
    }

    public boolean saveEntityChanges(Integer n, List list, int n2, int n3, boolean bl) {
        if (list != null && list.size() > 0 && n2 > -1 && n3 > -1) {
            EntityChangeListBuilder entityChangeListBuilder = new EntityChangeListBuilder();
            for (int i = 0; i < list.size(); ++i) {
                entityChangeListBuilder.addEntityChange((EntityChange)list.get(i));
            }
            List list2 = entityChangeListBuilder.getEntityChangeLists();
            for (int i = 0; list2 != null && i < list2.size(); ++i) {
                EntityChangeList entityChangeList = (EntityChangeList)list2.get(i);
                entityChangeList.setApprovalLevel(n2);
                entityChangeList.setUserID(n3);
                if (this.saveEntityChanges(n, entityChangeList, bl, null, null, null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean saveEntityChanges(Integer n, EntityChangeList entityChangeList, int n2, int n3, Map map) {
        return this.saveEntityChanges(n, entityChangeList, n2, n3, true, map);
    }

    public boolean saveEntityChanges(Integer n, EntityChangeList entityChangeList, int n2, int n3, boolean bl, Map map) {
        if (entityChangeList != null) {
            return this.saveEntityChanges(n, entityChangeList, this.getApprovalLevel(n2, n3), bl, map, null);
        }
        return false;
    }

    public boolean saveEntityChanges(Integer n, EntityChangeList entityChangeList, int n2, boolean bl, Map map, SqlBatchController sqlBatchController) {
        if (entityChangeList != null && n2 > -1) {
            entityChangeList.setApprovalLevel(n2);
            return this.saveEntityChanges(n, entityChangeList, bl, map, null, sqlBatchController);
        }
        return false;
    }

    protected boolean saveEntityChanges(Integer n, EntityChangeList entityChangeList, boolean bl, Map map, DatabaseConnector databaseConnector, SqlBatchController sqlBatchController) {
        boolean bl2 = false;
        if (entityChangeList != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                if (Entity.isTempEntityID(entityChangeList.getEntityID()) || !bl || entityChangeList.getUserID() == this.getEntityLockUserID(entityChangeList.getEntityTypeID(), entityChangeList.getEntityID(), databaseConnector)) {
                    Object object;
                    if (Entity.isTempEntityID(entityChangeList.getEntityID())) {
                        object = entityChangeList.getEntityKeyString();
                        entityChangeList.setEntityID(this.getNextEntityID());
                        if (map != null) {
                            map.put(object, new EntityKeyWrapper(entityChangeList.getEntityTypeID(), entityChangeList.getEntityID(), entityChangeList));
                        }
                    }
                    object = entityChangeList.getRelatedChangeLists();
                    for (int i = 0; object != null && i < object.size(); ++i) {
                        EntityChangeList entityChangeList2 = (EntityChangeList)object.get(i);
                        if (this.saveEntityChanges(n, entityChangeList2, false, map, databaseConnector, sqlBatchController)) continue;
                        this.debugOut("Changes for entity " + entityChangeList2.getEntityKeyString() + " could not be saved.");
                        databaseConnector.close();
                        return false;
                    }
                    entityChangeList.addEntityChanges(this.getEntityChanges(n, entityChangeList.getEntityTypeID(), entityChangeList.getEntityID(), 1));
                    this.removePendingEntityChanges(n, entityChangeList.getEntityTypeID(), entityChangeList.getEntityID(), databaseConnector, sqlBatchController);
                    List list = entityChangeList.getFilteredChanges();
                    if (list != null && list.size() > 0) {
                        int n2 = 0;
                        for (int i = 0; i < list.size(); ++i) {
                            EntityChange entityChange = (EntityChange)list.get(i);
                            if (entityChange == null || entityChange.getChangeCategory() == 0 || !EntityChange.isTempChangeID(entityChange.getChangeID())) continue;
                            ++n2;
                        }
                        long l = this.getNextEntityChangeID(null, n2);
                        for (int i = 0; i < list.size(); ++i) {
                            EntityChange entityChange = (EntityChange)list.get(i);
                            if (entityChange != null && entityChange.getChangeCategory() != 0 && EntityChange.isTempChangeID(entityChange.getChangeID())) {
                                entityChange.setChangeID(l++);
                            }
                            this.writeEntityChange(n, entityChange, databaseConnector, false, sqlBatchController);
                        }
                    }
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in saveEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return bl2;
    }

    public List getDeletedEntities(Integer n, List list, DatabaseConnector databaseConnector) {
        Vector<EntityKey> vector = new Vector<EntityKey>(0);
        if (list != null && list.size() > 0) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                String string = MedeConnector.createEntitiesSubClause(list, "");
                if (string.length() > 0) {
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("IRENTITYCHANGES", null, new String[]{"EntityTypeID", "EntityID"});
                    sqlQueryGenerator.appendToWhere("ChangeCategory = 4 AND ChangeStatus = 1 AND (" + string + ")" + " AND UniqueCollectionID = " + n);
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Get deleted entities query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        EntityKey entityKey = Entity.getEntityKey(list, databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"));
                        if (entityKey != null) {
                            vector.add(entityKey);
                        }
                        databaseConnector.next();
                    }
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getDeletedEntities():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return vector;
    }

    public boolean deleteEntity(Integer n, int n2, long l, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6;
        boolean bl3 = false;
        if (!Entity.isTempEntityID(l) && (n6 = this.getApprovalLevel(n4, n5)) > -1) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                if (bl2 || n3 == this.getEntityLockUserID(n2, l, databaseConnector)) {
                    this.removePendingEntityChanges(n, n2, l, databaseConnector, null);
                    if (bl) {
                        EntityChange entityChange = new EntityChange(EntityChange.getNextTempChangeID(), 4, 2, 1, n6, false, false, n2, l, n3, new SimpleDate());
                        this.writeEntityChange(n, entityChange, databaseConnector, true, null);
                    }
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in deleteEntity():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in deleteEntity():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List importEntities(Integer n, int n2, int n3, int n4, Collection collection) {
        Object object;
        HashSet<Long> hashSet;
        boolean bl;
        block31: {
            bl = false;
            hashSet = new HashSet<Long>();
            int n5 = this.getApprovalLevel(n3, n4);
            if (n5 > -1) {
                Entity entity;
                object = null;
                long l = 1L;
                if (collection.size() > 0) {
                    long l2 = l = this.getNextEntityID(collection.size());
                    for (int i = 0; i < collection.size(); ++i) {
                        hashSet.add(new Long(l2++));
                    }
                }
                Object object2 = collection.iterator();
                while (object2.hasNext()) {
                    entity = (Entity)object2.next();
                    entity.setEntityID(l++);
                    this.debugOut("Entity found, set ID to: " + entity.getEntityID());
                }
                object = new SqlBatchController(this.getDatabaseConnector(), 100);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Vector vector;
                    int n6;
                    entity = (Entity)iterator.next();
                    EntityType entityType = entity.getEntityType();
                    int n7 = entityType.getEntityTypeID();
                    object2 = new EntityChangeList(entity, false);
                    ((EntityChangeList)object2).addEntityChange(new EntityAddChange(EntityChange.getNextTempChangeID(), 1, 1, n5, false, false, n7, entity.getEntityID(), n2, new SimpleDate()));
                    Vector vector2 = (Vector)entity.getFieldValues();
                    if (vector2 != null && vector2.size() > 0) {
                        for (n6 = 0; vector2 != null && n6 < vector2.size(); ++n6) {
                            EntityFieldValue entityFieldValue = (EntityFieldValue)vector2.get(n6);
                            int n8 = entityFieldValue.getField().fieldID;
                            if (((Vector)entityFieldValue.getValues()).size() <= 0) continue;
                            Vector vector3 = (Vector)entityFieldValue.getValues();
                            for (int i = 0; i < vector3.size(); ++i) {
                                String string = (String)vector3.get(i);
                                if (object2 == null) continue;
                                ((EntityChangeList)object2).addEntityChange(new EntityFieldChange(EntityChange.getNextTempChangeID(), 1, 1, n5, false, false, n7, entity.getEntityID(), n2, new SimpleDate(), n8, string));
                            }
                        }
                    }
                    if ((vector = (Vector)entity.getRelatedEntities()) != null && vector.size() > 0) {
                        for (n6 = 0; vector != null && n6 < vector.size(); ++n6) {
                            Entity entity2 = (Entity)vector.get(n6);
                            if (object2 == null) continue;
                            ((EntityChangeList)object2).addEntityChange(new EntityMapChange(EntityChange.getNextTempChangeID(), 1, 1, n5, false, false, n7, entity.getEntityID(), n2, new SimpleDate(), entity2.getEntityTypeID(), entity2.getEntityID()));
                        }
                    }
                    this.saveEntityChanges(n, (EntityChangeList)object2, n5, false, null, (SqlBatchController)object);
                }
                bl = true;
                Object var27_29 = null;
                try {
                    if (object != null) {
                        ((SqlBatchController)object).executeRemainingCommands();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object != null) {
                    ((SqlBatchController)object).setStillNeeded(false);
                }
                break block31;
                {
                    catch (Exception exception) {
                        this.debugOut("Exception in importEntities():\n" + InsightUtilities.getStackTrace(exception));
                        Object var27_30 = null;
                        try {
                            if (object != null) {
                                ((SqlBatchController)object).executeRemainingCommands();
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        if (object != null) {
                            ((SqlBatchController)object).setStillNeeded(false);
                        }
                        break block31;
                    }
                    catch (Error error) {
                        this.debugOut("Error in importEntities():\n" + InsightUtilities.getStackTrace(error));
                        Object var27_31 = null;
                        try {
                            if (object != null) {
                                ((SqlBatchController)object).executeRemainingCommands();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object != null) {
                            ((SqlBatchController)object).setStillNeeded(false);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var27_32 = null;
                    try {
                        if (object != null) {
                            ((SqlBatchController)object).executeRemainingCommands();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object != null) {
                        ((SqlBatchController)object).setStillNeeded(false);
                    }
                    throw throwable;
                }
            }
        }
        object = null;
        if (bl) {
            object = new ArrayList(hashSet);
            Collections.sort(object);
        }
        return object;
    }

    public List getEntityChangeUsers(Integer n, int n2, int n3, int n4, List list, int n5, int n6) {
        Vector<InsightUser> vector = new Vector<InsightUser>(0);
        int n7 = this.getApprovalLevel(n2, n3);
        if (n7 > -1) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("IRENTITYCHANGES.ChangeStatus = " + n4);
                if (n5 > 0) {
                    stringBuffer.append(" AND IRENTITYCHANGES.LastEditorUserID = " + n5);
                }
                if (n6 == 1) {
                    stringBuffer.append(" AND IRENTITYCHANGES.ApprovalLevel < " + n7);
                } else if (n6 == 2) {
                    stringBuffer.append(" AND IRENTITYCHANGES.ApprovalLevel = " + n7);
                } else if (n6 == 0) {
                    // empty if block
                }
                if (list != null && list.size() > 0) {
                    stringBuffer.append(" AND IRENTITYCHANGES.ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                }
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                sqlQueryGenerator.addTable("IRUSERS", null, "*");
                sqlQueryGenerator.addJoin("IRUSERS", "UserID", "IRENTITYCHANGES", "UserID", 0);
                sqlQueryGenerator.appendToWhere(stringBuffer.toString());
                sqlQueryGenerator.appendToWhere("IRENTITYCHANGES.UniqueCollectionID = " + n);
                sqlQueryGenerator.addOrderBy("IRUSERS", "FirstName");
                sqlQueryGenerator.addOrderBy("IRUSERS", "LastName");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get entity change users query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    InsightUser insightUser = this.getInsightUser(databaseConnector);
                    if (insightUser != null) {
                        vector.add(insightUser);
                    }
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getEntityChangeMedeUsers():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return vector;
    }

    public List getEntityChangeLists(Integer n, int n2, int n3, int n4, int n5, int n6, List list, int n7, int n8) {
        EntityChangeListBuilder entityChangeListBuilder = new EntityChangeListBuilder();
        int n9 = this.getApprovalLevel(n4, n5);
        if (n9 > -1) {
            Vector vector;
            List list2;
            List list3;
            String string;
            int n10;
            Object object;
            Object object2;
            try {
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("EntityTypeID = " + n2 + " AND ChangeStatus = " + n6 + " AND UserID = " + n3);
                if (n7 > 0) {
                    ((StringBuffer)object2).append(" AND LastEditorUserID = " + n7);
                }
                if (n8 == 1) {
                    ((StringBuffer)object2).append(" AND ApprovalLevel < " + n9);
                } else if (n8 == 2) {
                    ((StringBuffer)object2).append(" AND ApprovalLevel = " + n9);
                } else if (n8 == 0) {
                    // empty if block
                }
                if (list != null && list.size() > 0) {
                    ((StringBuffer)object2).append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                }
                object = this.getQueryGenerator();
                ((SqlQueryGenerator)object).addTable("IRENTITYCHANGES", null, "*");
                ((SqlQueryGenerator)object).appendToWhere(((StringBuffer)object2).toString());
                ((SqlQueryGenerator)object).appendToWhere("UniqueCollectionID = " + n);
                ((SqlQueryGenerator)object).addOrderBy("IRENTITYCHANGES", "ChangeTimeStamp");
                entityChangeListBuilder = this.buildEntityChangeLists(((SqlQueryGenerator)object).getQuery());
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("DTENTITYTOENTITYMAP.EntityTypeID = " + n2 + " AND " + "IRENTITYCHANGES" + ".ChangeStatus = " + n6 + " AND " + "IRENTITYCHANGES" + ".UserID = " + n3 + " AND " + "ISENTITYTYPES" + ".IsDependent = 1");
                if (n8 == 1) {
                    ((StringBuffer)object2).append(" AND IRENTITYCHANGES.ApprovalLevel < " + n9);
                } else if (n8 == 2) {
                    ((StringBuffer)object2).append(" AND IRENTITYCHANGES.ApprovalLevel = " + n9);
                }
                if (list != null && list.size() > 0) {
                    ((StringBuffer)object2).append(" AND IRENTITYCHANGES.ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                }
                object = this.getQueryGenerator();
                ((SqlQueryGenerator)object).addTable("DTENTITYTOENTITYMAP", new String[]{"EntityTypeID", "EntityID"});
                ((SqlQueryGenerator)object).addJoin("DTENTITYTOENTITYMAP", new String[]{"RelEntityTypeID", "RelEntityID"}, "IRENTITYCHANGES", new String[]{"EntityTypeID", "EntityID"}, 0);
                ((SqlQueryGenerator)object).addJoin("IRENTITYCHANGES", "ISENTITYTYPES", "EntityTypeID", 0);
                ((SqlQueryGenerator)object).appendToWhere(((StringBuffer)object2).toString());
                ((SqlQueryGenerator)object).appendToWhere("IRENTITYCHANGES.UniqueCollectionID = " + n);
                ((SqlQueryGenerator)object).addOrderBy("IRENTITYCHANGES", "ChangeTimeStamp");
                this.addUnchangedEntityChangeLists(((SqlQueryGenerator)object).getQuery(), entityChangeListBuilder);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getEntityChangeLists():\n" + InsightUtilities.getStackTrace(exception));
            }
            object2 = entityChangeListBuilder.getEntityKeys();
            object = new Vector();
            for (n10 = 0; n10 < object2.size(); ++n10) {
                List list4 = this.getDependentEntities((EntityKey)object2.get(n10));
                if (list4 == null || list4.size() <= 0) continue;
                entityChangeListBuilder.addDependentEntityChangeLists((EntityKey)object2.get(n10), list4);
                object.addAll(list4);
            }
            if (object.size() > 0 && (string = this.constructDependentChangesQuery(n, (List)object, n3, n6, list, n7, n9, n8)) != null) {
                entityChangeListBuilder = this.buildEntityChangeLists(string, entityChangeListBuilder);
            }
            entityChangeListBuilder.removeEmptyChangeLists();
            n10 = list.contains(new Integer(1)) ? 1 : 0;
            boolean bl = list.contains(new Integer(2));
            if ((n10 != 0 || bl) && (list3 = this.getDependentEntityTypeIDs(n2)) != null && list3.size() > 0) {
                list2 = this.getEntityChangeLists(n, n2, n3, n4, n5, n6, Arrays.asList("2"), n7, n8);
                vector = new Vector(0);
                for (int i = 0; list2 != null && i < list2.size(); ++i) {
                    EntityChangeList entityChangeList = (EntityChangeList)list2.get(i);
                    List list5 = entityChangeList.getEntityChanges();
                    for (int j = 0; list5 != null && j < list5.size(); ++j) {
                        try {
                            StringBuffer stringBuffer;
                            EntityMapChange entityMapChange = (EntityMapChange)list5.get(j);
                            if (!list3.contains(entityMapChange.getRelatedEntityTypeID() + "") || entityMapChange.getChangeType() != 1) continue;
                            if (n10 != 0) {
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("SELECT * FROM IRENTITYCHANGES WHERE EntityTypeID = " + entityMapChange.getRelatedEntityTypeID() + " AND EntityID = " + entityMapChange.getRelatedEntityID() + " AND ChangeStatus = " + n6 + " AND UserID = " + n3);
                                if (n7 > 0) {
                                    stringBuffer.append(" AND LastEditorUserID = " + n7);
                                }
                                if (n8 == 1) {
                                    stringBuffer.append(" AND ApprovalLevel < " + n9);
                                } else if (n8 == 2) {
                                    stringBuffer.append(" AND ApprovalLevel = " + n9);
                                }
                                stringBuffer.append(" AND ChangeCategory IN (1)");
                                stringBuffer.append(" AND ChangeType = 1");
                                stringBuffer.append(" AND UniqueCollectionID = " + n);
                                stringBuffer.append(" ORDER BY ChangeTimeStamp");
                                List list6 = this.getEntityChanges(stringBuffer.toString());
                                if (list6 != null && list6.size() > 0) {
                                    for (int k = 0; k < list6.size(); ++k) {
                                        entityChangeListBuilder.addEntityChange(entityMapChange.getEntityTypeID(), entityMapChange.getEntityID(), (EntityChange)list6.get(k));
                                    }
                                    entityChangeListBuilder.addEntityChange(entityMapChange.getEntityTypeID(), entityMapChange.getEntityID(), entityMapChange);
                                }
                            }
                            if (!bl) continue;
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("SELECT * FROM IRENTITYCHANGES WHERE EntityTypeID = " + entityMapChange.getRelatedEntityTypeID() + " AND EntityID = " + entityMapChange.getRelatedEntityID() + " AND ChangeStatus = " + n6 + " AND UserID = " + n3 + " AND UniqueCollectionID = " + n);
                            if (n7 > 0) {
                                stringBuffer.append(" AND LastEditorUserID = " + n7);
                            }
                            if (n8 == 1) {
                                stringBuffer.append(" AND ApprovalLevel < " + n9);
                            } else if (n8 == 2) {
                                stringBuffer.append(" AND ApprovalLevel = " + n9);
                            }
                            stringBuffer.append(" AND ChangeCategory IN (2)");
                            stringBuffer.append(" AND ChangeType = 1");
                            stringBuffer.append(" ORDER BY ChangeTimeStamp");
                            entityChangeListBuilder.addDependentEntityChangeList(entityMapChange, new Entity(entityMapChange.getRelatedEntityTypeID(), entityMapChange.getRelatedEntityID()));
                            this.buildEntityChangeLists(stringBuffer.toString(), entityChangeListBuilder);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            object2 = entityChangeListBuilder.getEntityKeys(true);
            list3 = this.getShallowEntities(n, (List)object2);
            entityChangeListBuilder.setEntities(list3);
            list2 = entityChangeListBuilder.getMediaIDs();
            if (list2 != null && ((Vector)list2).size() > 0) {
                vector = this.getImageFiles((Vector)list2, 0, n4, n5);
                entityChangeListBuilder.setMediaFiles(vector);
            }
        }
        return entityChangeListBuilder.getEntityChangeLists();
    }

    protected EntityChangeListBuilder buildEntityChangeLists(String string) {
        return this.buildEntityChangeLists(string, null);
    }

    protected EntityChangeListBuilder buildEntityChangeLists(String string, EntityChangeListBuilder entityChangeListBuilder) {
        this.debugOut("in buildEntityChangeLists().");
        if (entityChangeListBuilder == null) {
            entityChangeListBuilder = new EntityChangeListBuilder();
        }
        try {
            if (string != null) {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery(string);
                this.debugOut("Build entity change lists query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    entityChangeListBuilder.addEntityChange(this.getEntityChange(databaseConnector));
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in buildEntityChangeLists():\n" + InsightUtilities.getStackTrace(exception));
        }
        return entityChangeListBuilder;
    }

    protected EntityChangeListBuilder buildEntityChangeLists(String string, EntityChangeListBuilder entityChangeListBuilder, MutableBoolean mutableBoolean, int n) {
        block11: {
            this.debugOut("in buildEntityChangeLists() with BatchSize=" + n);
            if (entityChangeListBuilder == null) {
                entityChangeListBuilder = new EntityChangeListBuilder();
            }
            try {
                if (string == null) break block11;
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery(string);
                this.debugOut("Build entity change lists query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                boolean bl = false;
                if (n <= 0) {
                    while (databaseConnector.more()) {
                        EntityChangeList entityChangeList = entityChangeListBuilder.addEntityChange(this.getEntityChange(databaseConnector), true, true);
                        databaseConnector.next();
                    }
                } else {
                    EntityChangeList entityChangeList = null;
                    int n2 = 0;
                    while (databaseConnector.more()) {
                        EntityChangeList entityChangeList2 = entityChangeListBuilder.addEntityChange(this.getEntityChange(databaseConnector), n2 < n, true);
                        if (entityChangeList2 == null) {
                            if (n2 >= n) {
                                this.debugOut("Processed a batch of EntityChangeList");
                                bl = true;
                                break;
                            }
                            ++n2;
                        } else if (entityChangeList2 != entityChangeList) {
                            ++n2;
                            entityChangeList = entityChangeList2;
                        }
                        databaseConnector.next();
                    }
                }
                mutableBoolean.setValue(bl);
                databaseConnector.close();
            }
            catch (Exception exception) {
                this.debugOut("Exception in buildEntityChangeLists():\n" + InsightUtilities.getStackTrace(exception));
                mutableBoolean.setValue(false);
            }
        }
        return entityChangeListBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getDependentEntities(EntityKey entityKey) {
        Vector<Entity> vector = new Vector<Entity>();
        DatabaseConnector databaseConnector = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("SELECT M.* FROM DTENTITYTOENTITYMAP M, ISENTITYTYPES T WHERE (M.EntityTypeID = " + entityKey.getEntityTypeID() + " AND M.EntityID = " + entityKey.getEntityID() + " AND M.RelEntityTypeID = T.EntityTypeID" + " AND T.IsDependent = 1)");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(stringBuffer.toString());
            this.debugOut("Get dependent entities query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                int n = databaseConnector.getIntegerField("RelEntityTypeID");
                long l = databaseConnector.getLongField("RelEntityID");
                vector.add(new Entity(n, l));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getDependentEntities():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getDependentEntityTypeIDs(int n) {
        Vector<String> vector = new Vector<String>();
        DatabaseConnector databaseConnector = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("SELECT R.RelEntityTypeID FROM ISENTITYTYPES T, ISENTITYRELATIONSHIPS R WHERE ((T.EntityTypeID = R.RelEntityTypeID) AND  R.EntityTypeID = " + n + " AND T.IsDependent = 1)");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(stringBuffer.toString());
            this.debugOut("Get dependent entity types query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerField("RelEntityTypeID");
                vector.add(n2 + "");
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getDependentEntityTypeIDs():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return vector;
    }

    protected String constructDependentChangesQuery(Integer n, List list, int n2, int n3, List list2, int n4, int n5, int n6) {
        if (list == null || list.size() == 0) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("(");
            for (int i = 0; i < list.size(); ++i) {
                EntityKey entityKey = (EntityKey)list.get(i);
                if (i > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(EntityTypeID=" + entityKey.getEntityTypeID() + " AND EntityID=" + entityKey.getEntityID() + ")");
            }
            stringBuffer.append(") AND ChangeStatus = " + n3 + " AND UserID = " + n2);
            if (n4 > 0) {
                stringBuffer.append(" AND LastEditorUserID = " + n4);
            }
            if (n6 == 1) {
                stringBuffer.append(" AND ApprovalLevel < " + n5);
            } else if (n6 == 2) {
                stringBuffer.append(" AND ApprovalLevel = " + n5);
            } else if (n6 == 0) {
                // empty if block
            }
            if (list2 != null && list2.size() > 0) {
                stringBuffer.append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list2) + ")");
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRENTITYCHANGES", null, "*");
            sqlQueryGenerator.appendToWhere(stringBuffer.toString());
            sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            sqlQueryGenerator.addOrderBy("IRENTITYCHANGES", "ChangeTimeStamp");
            return sqlQueryGenerator.getQuery();
        }
        catch (Exception exception) {
            this.debugOut("Exception in constructDependentChangesQuery():\n" + InsightUtilities.getStackTrace(exception));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUnchangedEntityChangeLists(String string, EntityChangeListBuilder entityChangeListBuilder) {
        this.debugOut("in addUnchangedEntityChangeLists().");
        if (entityChangeListBuilder == null) {
            entityChangeListBuilder = new EntityChangeListBuilder();
        }
        DatabaseConnector databaseConnector = null;
        try {
            if (string != null) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery(string);
                this.debugOut("Unchanged entities query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                while (databaseConnector.more()) {
                    int n = databaseConnector.getIntegerField("EntityTypeID");
                    long l = databaseConnector.getLongField("EntityID");
                    entityChangeListBuilder.getEntityChangeList(new EntityKeyWrapper(n, l), true);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addUnchangedEntityChangeLists():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public int getEntityChangesCount(int n, long l, int n2, DatabaseConnector databaseConnector) {
        int n3 = 0;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            databaseConnector.setQuery("SELECT COUNT(*) AS ChangesCount FROM IRENTITYCHANGES WHERE EntityTypeID = " + n + " AND EntityID = " + l + (n2 > -1 ? " AND ChangeStatus = " + n2 : ""));
            this.debugOut("Get entity changes count query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n3 = databaseConnector.getIntegerField("ChangesCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityChangesCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n3;
    }

    public List getEntityChanges(Integer n, int n2, long l, int n3) {
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRENTITYCHANGES", "*");
        sqlQueryGenerator.appendToWhere("EntityTypeID = " + n2 + " AND EntityID = " + l + (n3 > -1 ? " AND ChangeStatus = " + n3 : "") + " AND UniqueCollectionID = " + n);
        sqlQueryGenerator.addOrderBy("IRENTITYCHANGES", "ChangeTimeStamp");
        return this.getEntityChanges(sqlQueryGenerator.getQuery());
    }

    public List getEntityChanges(String string) {
        Vector<EntityChange> vector = new Vector<EntityChange>(0);
        if (string != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                databaseConnector.setQuery(string);
                this.debugOut("Get entity changes query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    EntityChange entityChange = this.getEntityChange(databaseConnector);
                    if (entityChange != null) {
                        vector.add(entityChange);
                    }
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return vector;
    }

    public EntityChange getEntityChange(DatabaseConnector databaseConnector) {
        EntityChange entityChange;
        block13: {
            entityChange = null;
            try {
                if (databaseConnector == null || !databaseConnector.more()) break block13;
                int n = databaseConnector.getIntegerField("ChangeCategory");
                if (n == 1) {
                    entityChange = new EntityFieldChange(databaseConnector.getLongField("ChangeID"), databaseConnector.getIntegerField("ChangeType"), databaseConnector.getIntegerField("ChangeStatus"), databaseConnector.getIntegerField("ApprovalLevel"), databaseConnector.getIntegerField("CommittedToInvertedData") > 0, databaseConnector.getBooleanField("CommittedToSourceData"), databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), databaseConnector.getIntegerField("UserID"), new SimpleDate(databaseConnector.getField("ChangeTimeStamp")), databaseConnector.getIntegerField("FieldID"), databaseConnector.getField("ValueChange"));
                    try {
                        String string = databaseConnector.getStringField("MetaData");
                        if (InsightUtilities.isNonEmpty(string)) {
                            ((EntityFieldChange)entityChange).setMetaData(InsightUtilities.loadPropertiesFromString(string));
                        }
                        break block13;
                    }
                    catch (Exception exception) {}
                    break block13;
                }
                if (n == 2) {
                    entityChange = new EntityMapChange(databaseConnector.getLongField("ChangeID"), databaseConnector.getIntegerField("ChangeType"), databaseConnector.getIntegerField("ChangeStatus"), databaseConnector.getIntegerField("ApprovalLevel"), databaseConnector.getIntegerField("CommittedToInvertedData") > 0, databaseConnector.getBooleanField("CommittedToSourceData"), databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), databaseConnector.getIntegerField("UserID"), new SimpleDate(databaseConnector.getField("ChangeTimeStamp")), databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getLongField("RelEntityID"));
                } else if (n == 3) {
                    entityChange = new EntityMediaMapChange(databaseConnector.getLongField("ChangeID"), databaseConnector.getIntegerField("ChangeType"), databaseConnector.getIntegerField("ChangeStatus"), databaseConnector.getIntegerField("ApprovalLevel"), databaseConnector.getIntegerField("CommittedToInvertedData") > 0, databaseConnector.getBooleanField("CommittedToSourceData"), databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), databaseConnector.getIntegerField("UserID"), new SimpleDate(databaseConnector.getField("ChangeTimeStamp")), databaseConnector.getLongField("MediaID"));
                } else if (n == 4) {
                    entityChange = new EntityChange(databaseConnector.getLongField("ChangeID"), 4, databaseConnector.getIntegerField("ChangeType"), databaseConnector.getIntegerField("ChangeStatus"), databaseConnector.getIntegerField("ApprovalLevel"), databaseConnector.getIntegerField("CommittedToInvertedData") > 0, databaseConnector.getBooleanField("CommittedToSourceData"), databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), databaseConnector.getIntegerField("UserID"), new SimpleDate(databaseConnector.getField("ChangeTimeStamp")));
                } else if (n == 5) {
                    entityChange = new EntityAddChange(databaseConnector.getLongField("ChangeID"), databaseConnector.getIntegerField("ChangeType"), databaseConnector.getIntegerField("ChangeStatus"), databaseConnector.getIntegerField("ApprovalLevel"), databaseConnector.getIntegerField("CommittedToInvertedData") > 0, databaseConnector.getBooleanField("CommittedToSourceData"), databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), databaseConnector.getIntegerField("UserID"), new SimpleDate(databaseConnector.getField("ChangeTimeStamp")));
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getEntityChange():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return entityChange;
    }

    protected void removePendingEntityChanges(Integer n, int n2, long l, DatabaseConnector databaseConnector, SqlBatchController sqlBatchController) {
        this.removeEntityChanges(n, n2, l, 1, databaseConnector, sqlBatchController);
    }

    protected void removeRejectedEntityChanges(Integer n, int n2, long l, DatabaseConnector databaseConnector) {
        this.removeEntityChanges(n, n2, l, 2, databaseConnector, null);
    }

    protected void removeEntityChanges(Integer n, int n2, long l, int n3, DatabaseConnector databaseConnector, SqlBatchController sqlBatchController) {
        if (sqlBatchController != null) {
            String string = "DELETE FROM IRENTITYCHANGES WHERE EntityTypeID = " + n2 + " AND EntityID = " + l + " AND ChangeStatus = " + n3 + " AND UniqueCollectionID = " + n;
            this.debugOut("[Batched] Remove entity changes cmd:\n" + string);
            return;
        }
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            databaseConnector.setQuery("DELETE FROM IRENTITYCHANGES WHERE EntityTypeID = " + n2 + " AND EntityID = " + l + " AND ChangeStatus = " + n3 + " AND UniqueCollectionID = " + n);
            this.debugOut("Remove entity changes cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
    }

    public boolean approveEntityChanges(Integer n, boolean bl, int n2, int n3, int n4, long l, int n5, List list, List list2, int n6) {
        boolean bl2 = false;
        int n7 = this.getApprovalLevel(n2, n3);
        if (n7 > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                boolean bl3 = false;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("UPDATE IRENTITYCHANGES");
                if (bl) {
                    stringBuffer.append(" SET ApprovalLevel = " + n7);
                } else {
                    stringBuffer.append(" SET ChangeStatus = 2");
                }
                stringBuffer.append(", LastEditorUserID = " + n6);
                stringBuffer.append(", LastEditorTimeStamp = " + this.prepStringForQuery(new SimpleDate().get()));
                stringBuffer.append(" WHERE ChangeStatus = 1 AND ApprovalLevel < " + n7);
                if (list2 != null && list2.size() > 0) {
                    stringBuffer.append(" AND ChangeID IN (" + InsightUtilities.getListString(list2) + ")");
                    bl3 = true;
                } else if (n4 > -1 && l > -1L && n5 > -1) {
                    stringBuffer.append(" AND EntityTypeID = " + n4 + " AND EntityID = " + l + " AND UserID = " + n5);
                    if (list != null && list.size() > 0) {
                        stringBuffer.append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                    }
                    stringBuffer.append(" AND UniqueCollectionID = " + n);
                    bl3 = true;
                } else if (n4 > -1 && n5 > -1) {
                    stringBuffer.append(" AND EntityTypeID = " + n4 + " AND UserID = " + n5);
                    if (list != null && list.size() > 0) {
                        stringBuffer.append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                    }
                    stringBuffer.append(" AND UniqueCollectionID = " + n);
                    bl3 = true;
                } else if (n5 > -1) {
                    stringBuffer.append(" AND UserID = " + n5);
                    if (list != null && list.size() > 0) {
                        stringBuffer.append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                    }
                    stringBuffer.append(" AND UniqueCollectionID = " + n);
                    bl3 = true;
                }
                if (bl3) {
                    databaseConnector.setQuery(stringBuffer.toString());
                    this.debugOut("Approve/reject entity changes cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    bl2 = true;
                } else {
                    this.debugOut("Approve/reject entity cmd INCOMPLETE:\n" + stringBuffer.toString());
                    bl2 = false;
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in approveEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
                bl2 = false;
            }
            catch (Error error) {
                this.debugOut("Error in approveEntityChanges():\n" + InsightUtilities.getStackTrace(error));
                bl2 = false;
            }
            databaseConnector.close();
        }
        return bl2;
    }

    public boolean cancelEntityChanges(Integer n, int n2, int n3, int n4, long l, List list, int n5) {
        boolean bl = false;
        int n6 = this.getApprovalLevel(n2, n3);
        if (n6 > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                boolean bl2 = false;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("UPDATE IRENTITYCHANGES");
                stringBuffer.append(" SET ChangeStatus = 4");
                stringBuffer.append(", LastEditorUserID = " + n5);
                stringBuffer.append(", LastEditorTimeStamp = " + this.prepStringForQuery(new SimpleDate().get()));
                stringBuffer.append(" WHERE ChangeStatus = 1");
                stringBuffer.append(" AND (ApprovalLevel < " + n6 + " OR UserID = " + n5 + ")");
                if (list != null && list.size() > 0) {
                    stringBuffer.append(" AND ChangeID IN (" + InsightUtilities.getListString(list) + ")");
                    bl2 = true;
                }
                if (bl2) {
                    databaseConnector.setQuery(stringBuffer.toString());
                    this.debugOut("Cancel entity changes cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    bl = true;
                } else {
                    this.debugOut("Cancel entity cmd INCOMPLETE:\n" + stringBuffer.toString());
                    bl = false;
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in cancelEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            catch (Error error) {
                this.debugOut("Error in cancelEntityChanges():\n" + InsightUtilities.getStackTrace(error));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    public boolean cancelRejectedEntityChanges(Integer n, int n2, int n3, int n4, long l, int n5, List list, List list2, int n6) {
        boolean bl = false;
        int n7 = this.getApprovalLevel(n2, n3);
        if (n7 > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                boolean bl2 = false;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("UPDATE IRENTITYCHANGES");
                stringBuffer.append(" SET ChangeStatus = 4");
                stringBuffer.append(", LastEditorUserID = " + n6);
                stringBuffer.append(", LastEditorTimeStamp = " + this.prepStringForQuery(new SimpleDate().get()));
                stringBuffer.append(" WHERE ChangeStatus = 2");
                stringBuffer.append(" AND (ApprovalLevel < " + n7 + " OR UserID = " + n6 + ")");
                if (list2 != null && list2.size() > 0) {
                    stringBuffer.append(" AND ChangeID IN (" + InsightUtilities.getListString(list2) + ")");
                    bl2 = true;
                } else if (n4 > -1 && l > -1L && n5 > -1) {
                    stringBuffer.append(" AND EntityTypeID = " + n4 + " AND EntityID = " + l + " AND UserID = " + n5);
                    if (list != null && list.size() > 0) {
                        stringBuffer.append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                    }
                    stringBuffer.append(" AND UniqueCollectionID = " + n);
                    bl2 = true;
                } else if (n4 > -1 && n5 > -1) {
                    stringBuffer.append(" AND EntityTypeID = " + n4 + " AND UserID = " + n5);
                    if (list != null && list.size() > 0) {
                        stringBuffer.append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                    }
                    stringBuffer.append(" AND UniqueCollectionID = " + n);
                    bl2 = true;
                } else if (n5 > -1) {
                    stringBuffer.append(" AND UserID = " + n5);
                    if (list != null && list.size() > 0) {
                        stringBuffer.append(" AND ChangeCategory IN (" + InsightUtilities.getListString(list) + ")");
                    }
                    stringBuffer.append(" AND UniqueCollectionID = " + n);
                    bl2 = true;
                }
                if (bl2) {
                    databaseConnector.setQuery(stringBuffer.toString());
                    this.debugOut("Cancel rejected entity changes cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    bl = true;
                } else {
                    this.debugOut("Cancel rejected entity changes cmd INCOMPLETE:\n" + stringBuffer.toString());
                    bl = false;
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in cancelRejectedEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
                bl = false;
            }
            catch (Error error) {
                this.debugOut("Error in cancelRejectedEntityChanges():\n" + InsightUtilities.getStackTrace(error));
                bl = false;
            }
            databaseConnector.close();
        }
        return bl;
    }

    protected boolean writeEntityChange(Integer n, EntityChange entityChange, DatabaseConnector databaseConnector, boolean bl, SqlBatchController sqlBatchController) {
        boolean bl2 = false;
        if (entityChange != null && entityChange.getChangeCategory() != 0) {
            if (databaseConnector == null && sqlBatchController == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                Object object;
                if (bl && EntityChange.isTempChangeID(entityChange.getChangeID())) {
                    entityChange.setChangeID(this.getNextEntityChangeID(null));
                }
                entityChange.setTimeStamp(new SimpleDate());
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ChangeID", 2, stringBuffer2, entityChange.getChangeID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ChangeCategory", 2, stringBuffer2, entityChange.getChangeCategory());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ChangeType", 2, stringBuffer2, entityChange.getChangeType());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ChangeStatus", 2, stringBuffer2, entityChange.getChangeStatus());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ApprovalLevel", 2, stringBuffer2, entityChange.getApprovalLevel());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, entityChange.getEntityTypeID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, entityChange.getEntityID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, entityChange.getUserID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ChangeTimeStamp", 1, stringBuffer2, entityChange.getTimeStamp().get());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CommittedToInvertedData", 2, stringBuffer2, entityChange.isInvertedDataCommit() ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CommittedToSourceData", 2, stringBuffer2, entityChange.isSourceDataCommit() ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LastEditorUserID", 2, stringBuffer2, "0");
                if (entityChange instanceof EntityFieldChange) {
                    object = this.publisher.getEntityField(n, entityChange.getEntityTypeID(), ((EntityFieldChange)entityChange).getFieldID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, ((EntityFieldChange)entityChange).getFieldID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueChange", 1, stringBuffer2, InsightUtilities.truncate(((EntityFieldChange)entityChange).getValueChange(), ((EntityField)object).getMaxValueLength()));
                    Map map = ((EntityFieldChange)entityChange).getMetaData();
                    if (map != null && map.size() > 0) {
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MetaData", 1, stringBuffer2, InsightUtilities.convertMapContentToString(map));
                    }
                } else if (entityChange instanceof EntityMapChange) {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityTypeID", 2, stringBuffer2, ((EntityMapChange)entityChange).getRelatedEntityTypeID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityID", 2, stringBuffer2, ((EntityMapChange)entityChange).getRelatedEntityID());
                } else if (entityChange instanceof EntityMediaMapChange) {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaID", 2, stringBuffer2, ((EntityMediaMapChange)entityChange).getMediaID() + "");
                }
                object = "INSERT INTO IRENTITYCHANGES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")";
                if (sqlBatchController != null) {
                    this.debugOut("[Batched] Write entity change command:\n" + (String)object);
                    sqlBatchController.postSqlCommand((String)object);
                } else {
                    this.debugOut("Write entity change command:\n" + (String)object);
                    databaseConnector.setQuery((String)object);
                    databaseConnector.runUpdateQuerySafe();
                }
                bl2 = true;
            }
            catch (Exception exception) {
                this.debugOut("Exception in writeEntityChange():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in writeEntityChange():\n" + InsightUtilities.getStackTrace(error));
            }
            if (sqlBatchController == null) {
                databaseConnector.close();
            }
        }
        return bl2;
    }

    public int getInvertedCommitApprovalLevel(Integer n) {
        int n2 = -1;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT ApprovalLevel FROM IRAPPROVALLEVELS WHERE CommitToInvertedData = 1 AND UniqueCollectionID = " + n);
            this.debugOut("Get inverted commit approval level:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("ApprovalLevel");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getInvertedCommitApprovalLevel():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getInvertedCommitApprovalLevel():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return n2;
    }

    public int getSourceCommitApprovalLevel(Integer n) {
        int n2 = -1;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT ApprovalLevel FROM IRAPPROVALLEVELS WHERE CommitToSourceData = 1 AND UniqueCollectionID = " + n);
            this.debugOut("Get source commit approval level:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("ApprovalLevel");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getSourceCommitApprovalLevel():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getSourceCommitApprovalLevel():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return n2;
    }

    public List getEntityChangeListsToCommit(Integer n, boolean bl, boolean bl2) {
        List list = new Vector(0);
        int n2 = -1;
        int n3 = -1;
        if (bl) {
            n2 = this.getInvertedCommitApprovalLevel(n);
        }
        if (bl2) {
            n3 = this.getSourceCommitApprovalLevel(n);
        }
        if (n2 > -1 || n3 > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > -1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(ApprovalLevel >= " + n2 + " AND CommittedToInvertedData <> 1" + " AND CommittedToInvertedData <> 2)");
            }
            if (n3 > -1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(ApprovalLevel >= " + n3 + " AND CommittedToSourceData <> 1)");
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRENTITYCHANGES", "*");
            sqlQueryGenerator.appendToWhere(stringBuffer.toString());
            sqlQueryGenerator.appendToWhere(" UniqueCollectionID = " + n);
            EntityChangeListBuilder entityChangeListBuilder = this.buildEntityChangeLists(sqlQueryGenerator.getQuery());
            list = entityChangeListBuilder.getEntityChangeLists();
        }
        return list;
    }

    public List getEntityChangeListsToCommit(Integer n, boolean bl, boolean bl2, MutableObject mutableObject, MutableBoolean mutableBoolean, int n2) {
        String string = (String)mutableObject.getValue();
        if (string != null) {
            EntityChangeListBuilder entityChangeListBuilder = this.buildEntityChangeLists(string, null, mutableBoolean, n2);
            List list = entityChangeListBuilder.getEntityChangeLists();
            return list;
        }
        if (n2 <= 0) {
            mutableBoolean.setValue(false);
            return this.getEntityChangeListsToCommit(n, bl, bl2);
        }
        List list = new Vector(0);
        int n3 = -1;
        int n4 = -1;
        if (bl) {
            n3 = this.getInvertedCommitApprovalLevel(n);
        }
        if (bl2) {
            n4 = this.getSourceCommitApprovalLevel(n);
        }
        if (n3 > -1 || n4 > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 > -1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(ApprovalLevel >= " + n3 + " AND CommittedToInvertedData <> 1" + " AND CommittedToInvertedData <> 2)");
            }
            if (n4 > -1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(ApprovalLevel >= " + n4 + " AND CommittedToSourceData <> 1)");
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRENTITYCHANGES", "*");
            sqlQueryGenerator.appendToWhere(stringBuffer.toString());
            sqlQueryGenerator.appendToWhere(" UniqueCollectionID = " + n);
            sqlQueryGenerator.addOrderBy("IRENTITYCHANGES", "EntityID");
            mutableObject.setValue(sqlQueryGenerator.getQuery());
            EntityChangeListBuilder entityChangeListBuilder = this.buildEntityChangeLists(sqlQueryGenerator.getQuery(), null, mutableBoolean, n2);
            list = entityChangeListBuilder.getEntityChangeLists();
        } else {
            mutableBoolean.setValue(false);
        }
        return list;
    }

    public List getEntityChangeListsPartiallyCommitted(Integer n) {
        List list = new Vector(0);
        int n2 = this.getInvertedCommitApprovalLevel(n);
        if (n2 > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" OR ");
            }
            stringBuffer.append("(ApprovalLevel >= " + n2 + " AND CommittedToInvertedData = 2)");
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRENTITYCHANGES", "*");
            sqlQueryGenerator.appendToWhere(stringBuffer.toString());
            sqlQueryGenerator.appendToWhere(" UniqueCollectionID = " + n);
            EntityChangeListBuilder entityChangeListBuilder = this.buildEntityChangeLists(sqlQueryGenerator.getQuery());
            list = entityChangeListBuilder.getEntityChangeLists();
        }
        return list;
    }

    public List getEntityChangeListsPartiallyCommitted(Integer n, MutableObject mutableObject, MutableBoolean mutableBoolean, int n2) {
        String string = (String)mutableObject.getValue();
        if (string != null) {
            EntityChangeListBuilder entityChangeListBuilder = this.buildEntityChangeLists(string, null, mutableBoolean, n2);
            List list = entityChangeListBuilder.getEntityChangeLists();
            return list;
        }
        if (n2 <= 0) {
            mutableBoolean.setValue(false);
            return this.getEntityChangeListsPartiallyCommitted(n);
        }
        List list = new Vector(0);
        int n3 = -1;
        n3 = this.getInvertedCommitApprovalLevel(n);
        if (n3 > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" OR ");
            }
            stringBuffer.append("(ApprovalLevel >= " + n3 + " AND CommittedToInvertedData = 2)");
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRENTITYCHANGES", "*");
            sqlQueryGenerator.appendToWhere(stringBuffer.toString());
            sqlQueryGenerator.appendToWhere(" UniqueCollectionID = " + n);
            sqlQueryGenerator.addOrderBy("IRENTITYCHANGES", "EntityID");
            mutableObject.setValue(sqlQueryGenerator.getQuery());
            EntityChangeListBuilder entityChangeListBuilder = this.buildEntityChangeLists(sqlQueryGenerator.getQuery(), null, mutableBoolean, n2);
            list = entityChangeListBuilder.getEntityChangeLists();
        } else {
            mutableBoolean.setValue(false);
        }
        return list;
    }

    public List getApprovalExtraItems(Integer n, long l, List list) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRENTITYCHANGES", "ChangeID");
        sqlQueryGenerator.appendToWhere("EntityID = " + l);
        sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Integer)iterator.next();
            if (n2++ != 0) {
                stringBuffer.append("," + object);
                continue;
            }
            stringBuffer.append((Integer)object);
        }
        sqlQueryGenerator.appendToWhere("ChangeCategory in (" + stringBuffer.toString() + ")");
        object = this.getDatabaseConnector();
        try {
            object.setQuery(sqlQueryGenerator.getQuery());
            object.runQuery();
            while (object.more()) {
                arrayList.add("" + object.getIntegerField("ChangeID"));
                object.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in markChangesCommitted():\n" + InsightUtilities.getStackTrace(exception));
        }
        object.close();
        return arrayList;
    }

    public void markChangesCommitted(List list, boolean bl, boolean bl2, boolean bl3) {
        if (list != null && list.size() > 0 && (bl || bl2)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                if (bl3) {
                    stringBuffer.append("CommittedToInvertedData = 2");
                } else {
                    stringBuffer.append("CommittedToInvertedData = 1");
                }
            }
            if (bl2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("CommittedToSourceData = 1");
            }
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            int n = 0;
            while (n < list.size()) {
                int n2 = list.size() - n < 50 ? list.size() - n : 50;
                Vector<Long> vector = new Vector<Long>(n2);
                for (int i = 0; i < n2; ++i) {
                    vector.add(new Long(((EntityChange)list.get(n)).getChangeID()));
                    ++n;
                }
                try {
                    databaseConnector.setQuery("UPDATE IRENTITYCHANGES SET " + stringBuffer.toString() + " WHERE ChangeID IN (" + InsightUtilities.getListString(vector) + ")");
                    this.debugOut("Mark changes commited cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                }
                catch (Exception exception) {
                    this.debugOut("Exception in markChangesCommitted():\n" + InsightUtilities.getStackTrace(exception));
                    break;
                }
                catch (Error error) {
                    this.debugOut("Error in markChangesCommitted():\n" + InsightUtilities.getStackTrace(error));
                    break;
                }
                databaseConnector.close();
            }
            databaseConnector.close();
        }
    }

    public void markChangesCommittedFullState(List list) {
        if (list != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                for (int i = 0; i < list.size(); ++i) {
                    String string = (String)list.get(i);
                    databaseConnector.setQuery("UPDATE IRENTITYCHANGES SET CommittedToInvertedData = 1 WHERE ChangeID IN (" + string + ")" + " AND CommittedToInvertedData = 2");
                    this.debugOut("Mark partially committed changes as commited cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in markChangesCommittedFullState():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in markChangesCommittedFullState():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
    }

    public void markChangesFullyCommitted(Integer n) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            boolean bl = false;
            boolean bl2 = false;
            databaseConnector.setQuery("SELECT * FROM IRAPPROVALLEVELS WHERE (CommitToInvertedData = 1 OR CommitToSourceData = 1) AND UniqueCollectionID = " + n);
            this.debugOut("Get approval level information:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                if (!bl) {
                    bl = databaseConnector.getBooleanField("CommitToInvertedData");
                }
                if (!bl2) {
                    bl2 = databaseConnector.getBooleanField("CommitToSourceData");
                }
                if (bl && bl2) break;
                databaseConnector.next();
            }
            databaseConnector.close();
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" WHERE ");
                }
                stringBuffer.append("CommittedToInvertedData > 0");
            }
            if (bl2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" WHERE ");
                }
                stringBuffer.append("CommittedToSourceData = 1");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" AND UniqueCollectionID = " + n);
            } else {
                stringBuffer.append(" WHERE UniqueCollectionID = " + n);
            }
            databaseConnector.setQuery("UPDATE IRENTITYCHANGES SET ChangeStatus = 3" + stringBuffer.toString());
            this.debugOut("Mark changes fully committed cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
        }
        catch (Exception exception) {
            this.debugOut("Exception in markEligibleChangesFullyCommitted():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in markEligibleChangesFullyCommitted():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    public List getEntityTypeRelationships(Integer n) {
        this.debugOut("In getEntityTypeRelationships().");
        List list = this.publisher.getEntityRelationships(n);
        return list;
    }

    public List getEntityTypes(Integer n) {
        this.debugOut("In getEntityTypes().");
        EntityTypeBuilder entityTypeBuilder = new EntityTypeBuilder();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            List list = this.publisher.getEntityTypes(n);
            for (int i = 0; list != null && i < list.size(); ++i) {
                EntityType entityType = (EntityType)list.get(i);
                entityTypeBuilder.addEntityType(entityType);
                if (i < 10) {
                    this.debugOut("0" + i + " " + entityType);
                    continue;
                }
                this.debugOut(i + " " + entityType);
            }
            sqlQueryGenerator.clear();
            sqlQueryGenerator.addTable("ISENTITYRELATIONSHIPS", "*");
            sqlQueryGenerator.addJoin("ISENTITYRELATIONSHIPS", "ISENTITYTYPES", "EntityTypeID", 0);
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
            sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + this.prepStringForQuery("NA") + ")");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Entity type relationships query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                entityTypeBuilder.setEntityTypeRelationship(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getIntegerField("RelEntityTypeID"));
                databaseConnector.next();
            }
            databaseConnector.close();
            List list2 = this.publisher.getEntityFields(n);
            for (int i = 0; list2 != null && i < list2.size(); ++i) {
                EntityField entityField = (EntityField)list2.get(i);
                entityTypeBuilder.addEntityField(entityField);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityTypes():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return entityTypeBuilder.getEntityTypes();
    }

    public Entity getEntityByFieldValue(Integer n, int n2, int n3, String string, MutableInteger mutableInteger) {
        Entity entity = null;
        if (string != null && string.length() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", new String[]{"EntityTypeID", "EntityID"});
                sqlQueryGenerator.addTable("DTVALUES", new String[]{"ValueText", "ValueNumber"});
                sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
                String string2 = "DTVALUES.ValueText = " + this.prepStringForQuery(string);
                try {
                    long l = Long.parseLong(string);
                    string2 = string2 + " OR DTVALUES.ValueNumber = " + l;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + n2 + " AND " + "DTVALUES" + ".UniqueCollectionID = " + n + " AND " + "DTVALUES" + ".FieldID = " + n3 + " AND " + "DTVALUES" + ".Enabled = 1" + " AND (" + string2 + ")");
                sqlQueryGenerator.addOrderBy("DTVALUES", "ValueText");
                sqlQueryGenerator.addOrderBy("DTVALUES", "ValueNumber");
                sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "EntityID");
                String string3 = sqlQueryGenerator.getQuery();
                if (mutableInteger != null) {
                    databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(string3, "ResultCount"));
                    this.debugOut("Get entity by field value COUNT query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        mutableInteger.setValue(databaseConnector.getIntegerField("ResultCount"));
                    }
                    databaseConnector.close();
                }
                databaseConnector.setQuery(string3);
                this.debugOut("Get entity by field value query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerField("EntityTypeID");
                    long l = databaseConnector.getLongField("EntityID");
                    entity = this.getEntity(n, n2, l);
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getEntityByFieldValue():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return entity;
    }

    public List getEntitiesByFieldValue(Integer n, int n2, int n3, String string, int n4, int n5, MutableInteger mutableInteger) {
        List list = new Vector(0);
        if (string != null && string.length() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", new String[]{"EntityTypeID", "EntityID"});
                sqlQueryGenerator.addTable("DTVALUES", new String[]{"ValueText", "ValueNumber"});
                sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
                String string2 = "DTVALUES.ValueText = " + this.prepStringForQuery(string);
                try {
                    long l = Long.parseLong(string);
                    string2 = string2 + " OR DTVALUES.ValueNumber = " + l;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + n2 + " AND " + "DTVALUES" + ".UniqueCollectionID = " + n + " AND " + "DTVALUES" + ".FieldID = " + n3 + " AND " + "DTVALUES" + ".Enabled = 1" + " AND (" + string2 + ")");
                sqlQueryGenerator.addOrderBy("DTVALUES", "ValueText");
                sqlQueryGenerator.addOrderBy("DTVALUES", "ValueNumber");
                sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "EntityID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get entities by field value query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                Vector<EntityKeyWrapper> vector = new Vector<EntityKeyWrapper>(0);
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (databaseConnector.more() && n7 < n4) {
                    ++n7;
                    ++n6;
                    databaseConnector.next();
                }
                while (databaseConnector.more() && n7 >= n4 && (n5 == -1 || n8 < n5)) {
                    EntityKeyWrapper entityKeyWrapper = new EntityKeyWrapper(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"));
                    entityKeyWrapper.setIgnoreCollectionKey(true);
                    if (!vector.contains(entityKeyWrapper)) {
                        vector.add(entityKeyWrapper);
                    }
                    ++n8;
                    ++n7;
                    ++n6;
                    databaseConnector.next();
                }
                while (databaseConnector.more()) {
                    ++n6;
                    databaseConnector.next();
                }
                databaseConnector.close();
                if (mutableInteger != null) {
                    mutableInteger.setValue(n6);
                }
                list = this.getEntities(n, vector, false, false);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getEntitiesByFieldValue():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in getEntitiesByFieldValue():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return list;
    }

    public int getEntityValueCount(Integer n, EntityKey entityKey) {
        return this.getEntityValueCount(n, entityKey, null);
    }

    public int getEntityValueCount(Integer n, EntityKey entityKey, DatabaseConnector databaseConnector) {
        int n2 = 0;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", null, new Object[]{new SqlColumnSelection("COUNT(*) AS ResultCount", false)});
            sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
            sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + entityKey.getEntityTypeID() + " AND " + "DTVALUETOENTITYMAP" + ".EntityID = " + entityKey.getEntityID() + " AND " + "DTVALUES" + ".Enabled = 1");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get entity value count query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("ResultCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityValueCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n2;
    }

    public Entity getEntity(Integer n, int n2, long l) {
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", "*");
        sqlQueryGenerator.addTable("DTVALUES", new String[]{"ValueText", "ValueNumber"});
        sqlQueryGenerator.addTable("IRFIELDS", "FieldID");
        sqlQueryGenerator.addTable("IRTYPES", "TypeCode");
        sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
        sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
        sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
        sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + n2 + " AND " + "DTVALUETOENTITYMAP" + ".EntityID = " + l + " AND " + "DTVALUES" + ".Enabled = 1");
        sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("DTVALUES", "ValueText");
        sqlQueryGenerator.addOrderBy("DTVALUES", "ValueNumber");
        EntityBuilder entityBuilder = this.buildEntities(sqlQueryGenerator.getQuery());
        Entity entity = entityBuilder.getEntity(n2, l);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEntities(Integer n, List list, boolean bl, boolean bl2) {
        Vector<Entity> vector = new Vector<Entity>(0);
        DatabaseConnector databaseConnector = null;
        try {
            Object object;
            if (list != null && list.size() > 0 && ((String)(object = MedeConnector.createEntitiesSubClause(list, "DTVALUETOENTITYMAP"))).length() > 0) {
                int n2;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", "*");
                sqlQueryGenerator.addTable("DTVALUES", new String[]{"ValueText", "ValueNumber"});
                sqlQueryGenerator.addTable("IRFIELDS", "FieldID");
                sqlQueryGenerator.addTable("IRTYPES", "TypeCode");
                sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
                sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                sqlQueryGenerator.appendToWhere("DTVALUES.UniqueCollectionID = " + n);
                sqlQueryGenerator.appendToWhere("DTVALUES.Enabled = 1 AND " + ((String)object).toString());
                sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
                sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "DisplayOrder");
                EntityBuilder entityBuilder = this.buildEntities(sqlQueryGenerator.getQuery());
                for (n2 = 0; n2 < list.size(); ++n2) {
                    Entity entity = entityBuilder.getEntity((EntityKey)list.get(n2), bl);
                    if (entity == null) continue;
                    vector.add(entity);
                }
                if (bl2 && vector.size() > 0) {
                    Serializable serializable;
                    Object object2;
                    Serializable serializable2;
                    n2 = 0;
                    StringBuffer stringBuffer = new StringBuffer("IN (");
                    boolean bl3 = true;
                    Object object3 = vector.iterator();
                    while (object3.hasNext()) {
                        serializable2 = (Entity)object3.next();
                        stringBuffer.append(bl3 ? "" + ((Entity)serializable2).getEntityID() : ", " + ((Entity)serializable2).getEntityID());
                        if (!bl3) continue;
                        n2 = ((Entity)serializable2).getEntityTypeID();
                        bl3 = false;
                    }
                    stringBuffer.append(")");
                    object3 = "SELECT * FROM DTENTITYTOENTITYMAP WHERE UniqueCollectionID = " + n + " AND RelEntityTypeID = " + n2 + " AND RelEntityID " + stringBuffer;
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery((String)object3);
                    databaseConnector.runQuery();
                    serializable2 = new HashMap();
                    while (databaseConnector.more()) {
                        try {
                            object2 = new Entity(n2, databaseConnector.getLongField("RelEntityID"));
                            serializable = (List)serializable2.get(object2);
                            if (serializable == null) {
                                serializable = new ArrayList<Entity>();
                                serializable2.put(object2, serializable);
                            }
                            serializable.add(new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID")));
                        }
                        catch (Exception exception) {
                            serializable = new Vector();
                            if (databaseConnector != null) {
                                databaseConnector.close();
                            }
                            return serializable;
                        }
                        databaseConnector.next();
                    }
                    object2 = serializable2.keySet().iterator();
                    while (object2.hasNext()) {
                        serializable = (Entity)object2.next();
                        Entity entity = entityBuilder.getEntity((EntityKey)((Object)serializable));
                        if (entity == null) continue;
                        Iterator iterator = ((List)serializable2.get(serializable)).iterator();
                        while (iterator.hasNext()) {
                            entity.addParentEntity((Entity)iterator.next());
                        }
                    }
                }
            }
            object = vector;
            return object;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public List getShallowEntities(Integer n, List list) {
        String string;
        List list2 = new Vector(0);
        if (list != null && list.size() > 0 && (string = MedeConnector.createEntitiesSubClause(list, "DTVALUETOENTITYMAP")).length() > 0) {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", "*");
            sqlQueryGenerator.addTable("DTVALUES", new String[]{"ValueText", "ValueNumber"});
            sqlQueryGenerator.addTable("IRFIELDS", "FieldID");
            sqlQueryGenerator.addTable("IRTYPES", "TypeCode");
            sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
            sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.RelEntityTypeID = 0 AND DTVALUES.UniqueCollectionID = " + n + " AND " + "DTVALUETOENTITYMAP" + ".RelEntityID = 0" + " AND " + "DTVALUES" + ".Enabled = 1" + " AND (" + string.toString() + ")");
            sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
            sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "DisplayOrder");
            EntityBuilder entityBuilder = this.buildEntities(sqlQueryGenerator.getQuery());
            list2 = entityBuilder.getEntities();
        }
        return list2;
    }

    protected EntityBuilder buildEntities(String string) {
        this.debugOut("In buildEntities().");
        EntityBuilder entityBuilder = new EntityBuilder();
        try {
            if (string != null) {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery(string);
                this.debugOut("Build entities query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    entityBuilder.addEntityData(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getLongField("RelEntityID"), databaseConnector.getIntegerField("ParentEntityTypeID"), databaseConnector.getLongField("ParentEntityID"), databaseConnector.getIntegerField("FieldID"), MedeConnector.getFieldValue(databaseConnector));
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in buildEntities():\n" + InsightUtilities.getStackTrace(exception));
        }
        entityBuilder.ensureParentChildRelationships();
        return entityBuilder;
    }

    public List getMappedMediaFiles(EntityKey entityKey, int n, int n2, int n3) {
        Vector<ImageFile> vector = new Vector<ImageFile>(0);
        if (entityKey != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                boolean bl;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRENTITYMEDIAMAP", null, new String[]{"MediaID"});
                sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"ImageID", "ResolutionSize", "Width", "Height", "Filename", "Format", "MediaType"});
                sqlQueryGenerator.addJoin("IRENTITYMEDIAMAP", "MediaID", "IRIMAGEFILES", "ImageID", 0);
                sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ResolutionSize = " + n3 + " AND " + "IRENTITYMEDIAMAP" + ".EntityTypeID = " + entityKey.getEntityTypeID() + " AND " + "IRENTITYMEDIAMAP" + ".EntityID IN (" + entityKey.getEntityID() + ")");
                boolean bl2 = bl = n >= 0 || n2 >= 0;
                if (bl) {
                    sqlQueryGenerator.addTable("IRSPS", null, "URL");
                    sqlQueryGenerator.addTable("IRLPS", null, "LPS");
                    sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", "LPSid", 0);
                    sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
                    sqlQueryGenerator.addJoin("IRSPS", "IRPROFILE", new String[]{"SPSNum"}, 0);
                    sqlQueryGenerator.appendToWhere("IRPROFILE.ProfileId = " + n + " AND " + "IRPROFILE" + ".CollectionId = " + n2);
                }
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get mapped media files query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                while (databaseConnector.more()) {
                    vector.add(this.getImageFile(databaseConnector));
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getMappedMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in getMappedMediaFiles():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return vector;
    }

    public void populateEntityEquivalenceClassData(Integer n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EquivalenceClass equivalenceClass = (EquivalenceClass)iterator.next();
            if (equivalenceClass.hasAllEntities()) continue;
            Map map = equivalenceClass.getWrapperElements();
            equivalenceClass.addEntityElements(this.getEntities(n, new ArrayList(map.values()), false, true));
            map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List doEntityEquivalenceSearch(Integer n, EntityEquivalenceQuery entityEquivalenceQuery) {
        DatabaseConnector databaseConnector = null;
        HashMap<Object, EquivalenceClass> hashMap = new HashMap<Object, EquivalenceClass>();
        try {
            Object object;
            databaseConnector = this.getDatabaseConnector();
            EquivalenceRule equivalenceRule = entityEquivalenceQuery.getRule();
            int n2 = equivalenceRule.getEntityType().getTypeID();
            databaseConnector.setQuery(this.getEquivalenceClassQuery(n, equivalenceRule));
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                object = databaseConnector.getField("FieldValue").toLowerCase();
                EquivalenceEntityKeyWrapper equivalenceEntityKeyWrapper = new EquivalenceEntityKeyWrapper(n2, databaseConnector.getLongField("EntityID"), (String)object);
                EquivalenceClass equivalenceClass = (EquivalenceClass)hashMap.get(object);
                if (equivalenceClass == null) {
                    equivalenceClass = new EquivalenceClass(equivalenceRule);
                    hashMap.put(object, equivalenceClass);
                }
                equivalenceClass.addWrapperElement(equivalenceEntityKeyWrapper);
                databaseConnector.next();
            }
            object = new ArrayList(hashMap.values());
            return object;
        }
        catch (Exception exception) {
            this.debugOut("Exception in doEntityEquivalenceSearch: " + InsightUtilities.getStackTrace(exception));
            List list = null;
            return list;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    protected String getEquivalenceClassQuery(Integer n, EquivalenceRule equivalenceRule) {
        String string = "";
        EntityType entityType = equivalenceRule.getEntityType();
        EquivalenceCriterion equivalenceCriterion = (EquivalenceCriterion)equivalenceRule.getCriteria().get(0);
        if (equivalenceCriterion instanceof FieldEquivalenceCriterion) {
            EntityField entityField = ((FieldEquivalenceCriterion)equivalenceCriterion).getCriterionField();
            String string2 = entityField.getField().getFieldType() == 2 ? "ValueNumber" : "ValueText";
            boolean bl = this.useLowerCaseCommand && entityField.getField().getFieldType() != 2;
            string = "SELECT VTE1.ValueID, VTE1.EntityID, V1." + string2 + " AS FieldValue" + " FROM " + "DTVALUETOENTITYMAP" + " VTE1 INNER JOIN " + "DTVALUES" + " V1 ON VTE1.ValueID = V1.ValueID" + " WHERE V1.FieldID = " + entityField.getFieldID() + " AND V1.UniqueCollectionID = " + n + " AND VTE1.EntityTypeID = " + entityType.getEntityTypeID() + " AND " + equivalenceRule.getCountThreshold() + " <= (SELECT COUNT(*) FROM " + "DTVALUETOENTITYMAP" + " VTE2, " + "DTVALUES" + " V2 WHERE " + (bl ? " LOWER(V2." + string2 + ") = LOWER(V1." + string2 + ")" : " V2." + string2 + " = V1." + string2) + this.createFieldEquivalenceValueClause((FieldEquivalenceCriterion)equivalenceCriterion, string2, bl) + " AND VTE2.ValueID = V2.ValueID AND V2.FieldID = " + entityField.getFieldID() + " AND VTE2.EntityTypeID = " + entityType.getEntityTypeID() + " AND V2.UniqueCollectionID = " + n + ")" + " ORDER BY FieldValue";
        }
        return string;
    }

    public String createFieldEquivalenceValueClause(FieldEquivalenceCriterion fieldEquivalenceCriterion, String string, boolean bl) {
        String string2 = fieldEquivalenceCriterion.getSearchText();
        int n = fieldEquivalenceCriterion.getCriterionField().getField().getFieldType();
        if (string2 == null) {
            return "";
        }
        if (bl) {
            string2 = this.useLowerCaseCommandOnSearchValue ? this.escapeSpecialCharacters(string2) : this.escapeSpecialCharacters(string2).toLowerCase();
        }
        StringBuffer stringBuffer = new StringBuffer(" AND ");
        if (bl) {
            stringBuffer.append("LOWER(V1.").append(string).append(")");
        } else {
            stringBuffer.append("V1.").append(string);
        }
        if (n != 2 || this.useDistinctKeyword) {
            if (bl && this.useLowerCaseCommandOnSearchValue) {
                stringBuffer.append(" LIKE LOWER(" + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false) + ")");
            } else {
                stringBuffer.append(" LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false));
            }
        } else {
            stringBuffer.append(" = " + string2);
        }
        return stringBuffer.toString();
    }

    protected String getUniqueListQuery(Integer n, int n2, int n3, String string, int n4, int n5, String string2) {
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
        }
        sqlQueryGenerator.addTable("DTVALUES", null, string);
        sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOENTITYMAP", "ValueID", 0);
        sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + n2 + " AND " + "DTVALUES" + ".UniqueCollectionID = " + n + " AND " + "DTVALUES" + ".FieldID = " + n3 + " AND " + "DTVALUES" + ".Enabled = 1");
        if (n5 != 0 && string2 != null) {
            String string3 = "DTVALUES." + string;
            if (this.useLowerCaseCommand && n4 != 2) {
                string3 = "LOWER(" + string3 + ")";
            }
            boolean bl = false;
            String string4 = this.escapeSpecialCharacters(string2);
            if (string4 == null) {
                string4 = "";
            }
            if (this.useLowerCaseCommand) {
                if (this.useLowerCaseCommandOnSearchValue && n4 != 2) {
                    bl = true;
                } else {
                    string4 = string4.toLowerCase();
                }
            }
            if (n4 != 2 || string4 != null && !string4.equals("")) {
                sqlQueryGenerator.appendToWhere(this.createEquivalenceRelationshipClause(string3, n4, n5, string4, bl));
            }
        }
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.addOrderBy("DTVALUES", string);
        }
        return sqlQueryGenerator.getQuery();
    }

    protected int getUniqueListCount(Integer n, int n2, int n3, String string, int n4, int n5, String string2) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        int n6 = 0;
        try {
            databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(this.getUniqueListQuery(n, n2, n3, string, n4, n5, string2), "ResultCount", true, this.useDistinctInCount));
            this.debugOut("Unique list count query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n6 = databaseConnector.getIntegerField("ResultCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueListCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n6;
    }

    public CriterionValue[] getUniqueList(Integer n, int n2, Field field, int n3, String string, int n4) {
        this.debugOut("in getUniqueList().");
        Vector<StringCriterionValue> vector = new Vector<StringCriterionValue>();
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            int n5 = field.fieldID;
            int n6 = field.fieldType;
            String string2 = MedeConnector.getFieldValueName(field.typeCode);
            boolean bl2 = bl = n4 > -1 && this.useSqlCountForThreshold && this.getUniqueListCount(n, n2, n5, string2, n6, n3, string) > n4;
            if (!bl) {
                databaseConnector.setQuery(this.getUniqueListQuery(n, n2, n5, string2, n6, n3, string));
                this.debugOut("Get unique list query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    String string3 = null;
                    StringCriterionValue stringCriterionValue = null;
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    while (databaseConnector.more()) {
                        string3 = databaseConnector.getFieldByName(string2);
                        if (!hashtable.containsKey(string3)) {
                            hashtable.put(string3, string3);
                            stringCriterionValue = new StringCriterionValue(string3);
                            if (stringCriterionValue != null && !stringCriterionValue.isEmpty()) {
                                vector.add(stringCriterionValue);
                            }
                        }
                        databaseConnector.next();
                    }
                    this.debugOut(vector.size() + " elements found.");
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueList():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        if (!bl && n4 > -1 && vector.size() > n4) {
            bl = true;
        }
        Object[] objectArray = null;
        if (!bl) {
            objectArray = new CriterionValue[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public List getEntitySearchResults(Integer n, EntitySearchQuery entitySearchQuery, int n2, int n3, int n4, int n5, List list, boolean bl, boolean bl2, boolean bl3) {
        Vector vector;
        long l = System.currentTimeMillis();
        Vector vector2 = this.doEntitySearch(n, entitySearchQuery, list, bl2);
        this.debugOut("Do entity search time: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        if (n4 > -1 && n5 > -1) {
            vector = new Vector(n5);
            for (int i = n4; i < vector2.size() && vector.size() < n5; ++i) {
                vector.add(vector2.get(i));
            }
        } else {
            vector = vector2;
        }
        this.debugOut("Fetch requested page (" + n4 + ", " + n5 + ") time: " + (System.currentTimeMillis() - l));
        if (bl) {
            l = System.currentTimeMillis();
            this.getEsrMediaFiles(vector, 0, n2, n3, bl3);
            this.debugOut("Get ESR media files time: " + (System.currentTimeMillis() - l));
        }
        return vector;
    }

    public List doEntitySearch(Integer n, EntitySearchQuery entitySearchQuery, List list, boolean bl) {
        List list2 = new Vector(0);
        boolean bl2 = true;
        List list3 = entitySearchQuery.getCaptionFields();
        List list4 = entitySearchQuery.getSortFields();
        TrinityFieldProfile[] trinityFieldProfileArray = this.getFieldProfiles(list3);
        TrinityFieldProfile[] trinityFieldProfileArray2 = this.getFieldProfiles(list4);
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        int n2 = -1;
        int n3 = 0;
        if (bl) {
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", null, new String[]{"EntityTypeID", "EntityID"});
            sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.UniqueCollectionID = " + n);
        } else {
            sqlQueryGenerator.addTable("DTVALUES", null, new String[]{"ValueText", "ValueNumber", "FieldID"});
            sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", null, new String[]{"EntityTypeID", "EntityID"});
            sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOENTITYMAP", "ValueID", 0);
            n2 = sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.Preferred = 1");
            String string = MedeConnector.createFieldIDClause(trinityFieldProfileArray, trinityFieldProfileArray2, "DTVALUES");
            if (string.length() > 0) {
                n3 = sqlQueryGenerator.appendToWhere(string);
            }
            sqlQueryGenerator.appendToWhere("DTVALUES.UniqueCollectionID = " + n);
        }
        if (list == null || list.size() == 0) {
            sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + entitySearchQuery.getEntityTypeID());
        }
        boolean bl3 = false;
        String string = "";
        if (list != null && list.size() > 0) {
            string = MedeConnector.createEntitiesSubClause(list, "DTVALUETOENTITYMAP");
        } else if (entitySearchQuery.isKeywordSearch()) {
            string = this.createKeywordClause(n, entitySearchQuery.getKeywords(), "DTVALUETOENTITYMAP", entitySearchQuery.getEntityTypeID());
            bl2 = false;
        } else if (entitySearchQuery.getFieldCriteria() != null && entitySearchQuery.getFieldCriteria().size() > 0) {
            string = this.createCriteriaClause(entitySearchQuery.getFieldCriteria(), entitySearchQuery.getEntityTypeID());
            bl2 = false;
        }
        if (string.length() > 0) {
            sqlQueryGenerator.appendToWhere(string);
            bl3 = true;
        }
        if (bl) {
            sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "EntityTypeID");
            sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "EntityID");
        } else {
            sqlQueryGenerator.addOrderBy("DTVALUES", "FieldID");
            sqlQueryGenerator.addOrderBy("DTVALUES", "ValueText");
            sqlQueryGenerator.addOrderBy("DTVALUES", "ValueNumber");
            sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "EntityID");
        }
        if (bl3 || entitySearchQuery.isKeywordSearch() && (entitySearchQuery.getKeywords() == null || entitySearchQuery.getKeywords().size() == 0) || entitySearchQuery.getFieldCriteria() == null || entitySearchQuery.getFieldCriteria().size() == 0) {
            String string2 = sqlQueryGenerator.getQuery();
            String string3 = null;
            if (!bl) {
                sqlQueryGenerator.clearColumnSelections("DTVALUES");
                sqlQueryGenerator.clearColumnSelections("DTVALUETOENTITYMAP");
                sqlQueryGenerator.addColumnSelection("DTVALUETOENTITYMAP", "EntityID");
                String string4 = sqlQueryGenerator.removeWhereAppendage(n3);
                string4 = sqlQueryGenerator.removeWhereAppendage(n2);
                if (!this.useValueFromSubQuery) {
                    sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityID NOT IN (SELECT EntityID FROM DTVALUES, DTVALUETOENTITYMAP WHERE DTVALUES.ValueID = DTVALUETOENTITYMAP.ValueID AND (" + MedeConnector.createFieldIDClause(trinityFieldProfileArray, trinityFieldProfileArray2, "DTVALUES") + ")" + " AND " + "DTVALUETOENTITYMAP" + ".EntityTypeID = " + entitySearchQuery.getEntityTypeID() + ")");
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string5 = "SELECT EntityID FROM DTVALUES, DTVALUETOENTITYMAP WHERE DTVALUES.ValueID = DTVALUETOENTITYMAP.ValueID AND (" + MedeConnector.createFieldIDClause(trinityFieldProfileArray, trinityFieldProfileArray2, "DTVALUES") + ")" + " AND " + "DTVALUETOENTITYMAP" + ".EntityTypeID = " + entitySearchQuery.getEntityTypeID();
                    DatabaseConnector databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery(string5);
                    this.debugOut("Sub entity search query:\n" + string5);
                    long l = System.currentTimeMillis();
                    databaseConnector.runQuery();
                    this.debugOut("Sub entity search query time: " + (System.currentTimeMillis() - l));
                    try {
                        while (databaseConnector.more()) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(databaseConnector.getIntegerField("EntityID"));
                            databaseConnector.next();
                        }
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception in createKeywordClause():\n" + InsightUtilities.getStackTrace(exception));
                    }
                    databaseConnector.close();
                    sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityID NOT IN (" + stringBuffer.toString() + ")");
                }
                sqlQueryGenerator.clearOrderBys();
                sqlQueryGenerator.addOrderBy("DTVALUETOENTITYMAP", "EntityID");
                string3 = sqlQueryGenerator.getQuery(true);
            }
            list2 = this.gatherEntityResults(n, entitySearchQuery, string2, string3, trinityFieldProfileArray, trinityFieldProfileArray2, bl, bl2, list);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List gatherEntityResults(Integer n, EntitySearchQuery entitySearchQuery, String string, String string2, TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2, boolean bl, boolean bl2, List list) {
        this.totalRecords = 0;
        Vector<EntitySearchResult> vector = new Vector<EntitySearchResult>(0);
        if (string != null && (bl || string2 != null && trinityFieldProfileArray2 != null && trinityFieldProfileArray2.length > 0)) {
            long l = System.currentTimeMillis();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(string);
            this.debugOut("Entity search query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            this.debugOut("Entity search query time: " + (System.currentTimeMillis() - l));
            try {
                long l2;
                int n2;
                int n3;
                Hashtable hashtable = new Hashtable();
                HashSet<Long> hashSet = new HashSet<Long>();
                EntitySearchResult entitySearchResult = null;
                Integer n4 = null;
                Hashtable<Integer, Vector> hashtable2 = new Hashtable<Integer, Vector>();
                Hashtable<Integer, Vector> hashtable3 = new Hashtable<Integer, Vector>();
                List list2 = null;
                List list3 = null;
                vector = new Vector(50);
                l = System.currentTimeMillis();
                for (n3 = 0; trinityFieldProfileArray != null && n3 < trinityFieldProfileArray.length; ++n3) {
                    hashtable2.put(new Integer(trinityFieldProfileArray[n3].fieldID), this.getFieldIndices(trinityFieldProfileArray, trinityFieldProfileArray[n3].fieldID));
                }
                for (n3 = 0; trinityFieldProfileArray2 != null && n3 < trinityFieldProfileArray2.length; ++n3) {
                    hashtable3.put(new Integer(trinityFieldProfileArray2[n3].fieldID), this.getFieldIndices(trinityFieldProfileArray2, trinityFieldProfileArray2[n3].fieldID));
                }
                while (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerField("EntityTypeID");
                    entitySearchResult = this.getEntitySearchResult(hashtable, n2, l2 = databaseConnector.getLongField("EntityID"));
                    if (entitySearchResult == null) {
                        entitySearchResult = new EntitySearchResult(n2, l2);
                        entitySearchResult.setCaptionData(new String[trinityFieldProfileArray != null ? trinityFieldProfileArray.length : 0]);
                        entitySearchResult.setSortData(new String[trinityFieldProfileArray2 != null ? trinityFieldProfileArray2.length : 0]);
                        this.registerEntitySearchResult(hashtable, entitySearchResult);
                        vector.add(entitySearchResult);
                        hashSet.add(new Long(l2));
                    }
                    if (!bl && entitySearchResult != null && (entitySearchResult.getCaptionData() != null && entitySearchResult.getCaptionData().length > 0 || entitySearchResult.getSortData() != null && entitySearchResult.getSortData().length > 0)) {
                        n4 = new Integer(databaseConnector.getIntegerField("FieldID"));
                        list2 = (List)hashtable2.get(n4);
                        list3 = (List)hashtable3.get(n4);
                        if (list2 != null && list2.size() > 0 || list3 != null && list3.size() > 0) {
                            int n5;
                            String string3 = list2 != null && list2.size() > 0 ? trinityFieldProfileArray[((Integer)list2.get((int)0)).intValue()].fieldValueName : trinityFieldProfileArray2[((Integer)list3.get((int)0)).intValue()].fieldValueName;
                            String string4 = MedeConnector.getFieldValue(databaseConnector, string3);
                            if ((string4 = InsightDataAnchor.getPlainText(string4)).length() > InsightSmartServicer.MAXIMUM_THUMBNAIL_FIELD_LENGTH) {
                                string4 = string4.substring(0, InsightSmartServicer.MAXIMUM_THUMBNAIL_FIELD_LENGTH);
                            }
                            for (n3 = 0; list2 != null && n3 < list2.size(); ++n3) {
                                n5 = (Integer)list2.get(n3);
                                entitySearchResult.setCaption(string4, n5);
                            }
                            for (n3 = 0; list3 != null && n3 < list3.size(); ++n3) {
                                n5 = (Integer)list3.get(n3);
                                entitySearchResult.setSort(string4, n5);
                            }
                        }
                    }
                    databaseConnector.next();
                }
                databaseConnector.close();
                this.debugOut("Add ESR time: " + (System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                if (!bl) {
                    databaseConnector.setQuery(string2);
                    this.debugOut("Missing entity query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    this.debugOut("Missing entity query time: " + (System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                    while (databaseConnector.more()) {
                        n2 = entitySearchQuery.getEntityTypeID();
                        entitySearchResult = this.getEntitySearchResult(hashtable, n2, l2 = databaseConnector.getLongField("EntityID"));
                        if (entitySearchResult == null) {
                            entitySearchResult = new EntitySearchResult(n2, l2);
                            entitySearchResult.setCaptionData(new String[trinityFieldProfileArray.length]);
                            entitySearchResult.setSortData(new String[trinityFieldProfileArray2.length]);
                            this.registerEntitySearchResult(hashtable, entitySearchResult);
                            vector.add(entitySearchResult);
                            hashSet.add(new Long(l2));
                        }
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    this.debugOut("Add missing entity time: " + (System.currentTimeMillis() - l));
                }
                ArrayList<EntitySearchResult> arrayList = new ArrayList<EntitySearchResult>();
                if (bl2) {
                    Object object;
                    String string5 = null;
                    if (list != null && list.size() > 0) {
                        object = new ArrayList();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Long l3 = new Long(((EntityKey)iterator.next()).getEntityID());
                            if (hashSet.contains(l3)) continue;
                            object.add(l3);
                        }
                        if (object.size() > 0) {
                            string5 = "EntityID IN (" + InsightUtilities.getListString((List)object) + ")";
                        } else {
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        n2 = entitySearchQuery.getEntityTypeID();
                        object = this.getQueryGenerator();
                        ((SqlQueryGenerator)object).addTable("ISCOLLECTIONENTITYMAP", null, "EntityID");
                        ((SqlQueryGenerator)object).addOrderBy("ISCOLLECTIONENTITYMAP", "EntityID");
                        ((SqlQueryGenerator)object).appendToWhere("EntityTypeID = " + n2);
                        if (string5 != null) {
                            ((SqlQueryGenerator)object).appendToWhere(string5);
                        }
                        ((SqlQueryGenerator)object).appendToWhere("UniqueCollectionID = " + n);
                        databaseConnector.setQuery(((SqlQueryGenerator)object).getQuery());
                        databaseConnector.runQuery();
                        while (databaseConnector.more()) {
                            l2 = databaseConnector.getLongField("EntityID");
                            entitySearchResult = this.getEntitySearchResult(hashtable, n2, l2);
                            if (entitySearchResult == null) {
                                entitySearchResult = new EntitySearchResult(n2, l2);
                                entitySearchResult.setCaptionData(new String[trinityFieldProfileArray != null ? trinityFieldProfileArray.length : 0]);
                                entitySearchResult.setSortData(new String[trinityFieldProfileArray2 != null ? trinityFieldProfileArray2.length : 0]);
                                this.registerEntitySearchResult(hashtable, entitySearchResult);
                                arrayList.add(entitySearchResult);
                            }
                            databaseConnector.next();
                        }
                        databaseConnector.close();
                    }
                }
                if (!bl) {
                    l = System.currentTimeMillis();
                    Collections.sort(vector);
                    this.debugOut("Sort results time: " + (System.currentTimeMillis() - l));
                }
                if (bl2) {
                    vector.addAll(0, arrayList);
                }
                this.totalRecords = vector.size();
            }
            catch (Exception exception) {
                this.debugOut("Exception in gatherEntityResults():\n" + InsightUtilities.getStackTrace(exception));
            }
            finally {
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
            }
        }
        return vector;
    }

    public void getEsrMediaFiles(List list, int n, int n2, int n3, boolean bl) {
        if (list != null && list.size() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                EntitySearchResult entitySearchResult;
                int n4 = ((EntitySearchResult)list.get(0)).getEntityTypeID();
                Vector<Long> vector = new Vector<Long>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    entitySearchResult = (EntitySearchResult)list.get(i);
                    if (entitySearchResult.getThumbnailFiles() != null && entitySearchResult.getThumbnailFiles().size() != 0) continue;
                    vector.add(new Long(entitySearchResult.getEntityID()));
                }
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRENTITYMEDIAMAP", null, new String[]{"EntityTypeID", "EntityID", "MediaID"});
                sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"ResolutionSize", "Width AS ThumbWidth", "Height AS ThumbHeight", "Filename", "Format", "MediaType"});
                sqlQueryGenerator.addJoin("IRENTITYMEDIAMAP", "MediaID", "IRIMAGEFILES", "ImageID", 0);
                sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ResolutionSize = " + n + " AND " + "IRENTITYMEDIAMAP" + ".EntityTypeID = " + n4 + " AND " + "IRENTITYMEDIAMAP" + ".EntityID IN (" + InsightUtilities.getListString(vector) + ")");
                if (!bl) {
                    sqlQueryGenerator.addTable("IRSPS", null, "URL");
                    sqlQueryGenerator.addTable("IRLPS", null, "LPS");
                    sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", "LPSid", 0);
                    sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
                    sqlQueryGenerator.addJoin("IRSPS", "IRPROFILE", new String[]{"SPSNum"}, 0);
                    sqlQueryGenerator.appendToWhere("IRPROFILE.ProfileId = " + n2 + " AND " + "IRPROFILE" + ".CollectionId = " + n3);
                }
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get media files query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    entitySearchResult = this.getEntitySearchResult(list, databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"));
                    if (entitySearchResult != null) {
                        ImageFile imageFile = new ImageFile();
                        imageFile.imageID = databaseConnector.getLongField("MediaID");
                        imageFile.imageSize = new Dimension(databaseConnector.getIntegerField("ThumbWidth"), databaseConnector.getIntegerField("ThumbHeight"));
                        imageFile.resolution = databaseConnector.getIntegerField("ResolutionSize");
                        imageFile.URL = this.getMediaUrl(databaseConnector);
                        imageFile.format = ImageFile.getFormatTypeToInt(databaseConnector.getFieldByName("Format"));
                        imageFile.mediaType = databaseConnector.getIntegerField("MediaType");
                        entitySearchResult.addThumbnailFile(imageFile);
                    }
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in setEsrMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
    }

    public List getMediaSearchResults(Integer n, MediaSearchQuery mediaSearchQuery, int n2, int n3, int n4, int n5, EntitySearchQuery entitySearchQuery, boolean bl) {
        List list;
        Object object;
        boolean bl2;
        long l = System.currentTimeMillis();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"ImageID", "ResolutionSize", "Width", "Height", "Filename", "Format", "MediaType"});
        sqlQueryGenerator.appendToWhere(this.createMediaCriteriaClause(mediaSearchQuery.getSearchCriteria()));
        boolean bl3 = bl2 = n2 >= 0 || n3 >= 0;
        if (bl2) {
            sqlQueryGenerator.addTable("IRSPS", null, "URL");
            sqlQueryGenerator.addTable("IRLPS", null, "LPS");
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", "LPSid", 0);
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
            sqlQueryGenerator.addJoin("IRSPS", "IRPROFILE", new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere("IRPROFILE.ProfileId = " + n2 + " AND " + "IRPROFILE" + ".CollectionId = " + n3);
        }
        sqlQueryGenerator.addJoin("IRIMAGEFILES", "ImageID", "IRCOLLECTIONMEDIAMAP", "MediaID", 0);
        sqlQueryGenerator.appendToWhere("IRCOLLECTIONMEDIAMAP.UniqueCollectionID = " + n);
        if (mediaSearchQuery.getKeywordCriterion() != null) {
            object = mediaSearchQuery.getKeywordCriterion();
            List<String> list2 = Arrays.asList(((FieldCriterion)object).getEquivalence().getSearchValue());
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IROBJECTIMAGEMAP", "ImageID", 0);
            sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ObjectID", "DTVALUETOENTITYMAP", "EntityID", 0);
            sqlQueryGenerator.appendToWhere(this.createKeywordClause(n, list2, "DTVALUETOENTITYMAP", mediaSearchQuery.getPrimaryEntityTypeID()));
        }
        sqlQueryGenerator.addOrderBy("IRIMAGEFILES", "ImageID");
        object = this.gatherMediaSearchResults(sqlQueryGenerator.getQuery(), n4, n5);
        int n6 = this.getTotalRecords();
        if (entitySearchQuery != null && (list = this.getMappedEntityKeys((List)object, entitySearchQuery.getEntityTypeID())) != null && list.size() > 0) {
            List list3 = this.getEntitySearchResults(n, entitySearchQuery, n2, n3, -1, -1, list, false, false, bl);
            for (int i = 0; i < object.size(); ++i) {
                ((MediaSearchResult)object.get(i)).addEntitySearchResults(list3);
            }
        }
        this.totalRecords = n6;
        this.debugOut("Get ESR media files time: " + (System.currentTimeMillis() - l));
        return object;
    }

    protected List gatherMediaSearchResults(String string, int n, int n2) {
        this.totalRecords = 0;
        Vector<MediaSearchResult> vector = new Vector<MediaSearchResult>(0);
        if (string != null) {
            long l = System.currentTimeMillis();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                databaseConnector.setQuery(string);
                this.debugOut("Media search query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                this.debugOut("Media search query time: " + (System.currentTimeMillis() - l));
                vector = new Vector(n2);
                l = System.currentTimeMillis();
                for (int i = 0; databaseConnector.more() && i < n; ++i) {
                    ++this.totalRecords;
                    databaseConnector.next();
                }
                while (databaseConnector.more() && vector.size() < n2) {
                    vector.add(new MediaSearchResult(this.getImageFile(databaseConnector)));
                    ++this.totalRecords;
                    databaseConnector.next();
                }
                while (databaseConnector.more()) {
                    ++this.totalRecords;
                    databaseConnector.next();
                }
                this.debugOut("Add media files time: " + (System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
            }
            catch (Exception exception) {
                this.debugOut("Exception in gatherMediaFileResults():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in gatherMediaFileResults():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return vector;
    }

    public List getMappedEntityKeys(List list, int n) {
        Vector<EntityKeyWrapper> vector = new Vector<EntityKeyWrapper>(0);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            Vector<Long> vector2 = new Vector<Long>(list.size());
            for (int i = 0; list != null && i < list.size(); ++i) {
                vector2.add(new Long(((MediaSearchResult)list.get(i)).getMediaID()));
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            sqlQueryGenerator.addTable("IRENTITYMEDIAMAP", null, new String[]{"EntityTypeID", "EntityID", "MediaID"});
            sqlQueryGenerator.appendToWhere("MediaID IN (" + InsightUtilities.getListString(vector2) + ")" + " AND EntityTypeID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get mapped entities query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                EntityKeyWrapper entityKeyWrapper = new EntityKeyWrapper(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"));
                vector.add(entityKeyWrapper);
                MediaSearchResult mediaSearchResult = this.getMediaSearchResult(list, databaseConnector.getLongField("MediaID"));
                if (mediaSearchResult != null) {
                    mediaSearchResult.addEntityKey(entityKeyWrapper);
                }
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMappedEntities():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getMappedEntities():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return vector;
    }

    protected MediaSearchResult getMediaSearchResult(List list, long l) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            MediaSearchResult mediaSearchResult = (MediaSearchResult)list.get(i);
            if (mediaSearchResult.getMediaID() != l) continue;
            return mediaSearchResult;
        }
        return null;
    }

    public int getReferencedEntityCount(int n, long l) {
        int n2 = 0;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("DTENTITYTOENTITYMAP", "*");
            sqlQueryGenerator.appendToWhere("RelEntityTypeID = " + n);
            sqlQueryGenerator.appendToWhere("RelEntityID = " + l);
            databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(sqlQueryGenerator.getQuery(), "ReferenceCount"));
            this.debugOut("Get referenced entity count query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("ReferenceCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getReferencedEntityCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n2;
    }

    protected String getKey(int n, long l) {
        return n + "-" + l;
    }

    protected EntitySearchResult getEntitySearchResult(List list, int n, long l) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            EntitySearchResult entitySearchResult = (EntitySearchResult)list.get(i);
            if (entitySearchResult.getEntityTypeID() != n || entitySearchResult.getEntityID() != l) continue;
            return entitySearchResult;
        }
        return null;
    }

    protected EntitySearchResult getEntitySearchResult(Map map, int n, long l) {
        if (map != null) {
            return (EntitySearchResult)map.get(this.getKey(n, l));
        }
        return null;
    }

    protected EntitySearchResult registerEntitySearchResult(Map map, EntitySearchResult entitySearchResult) {
        if (map != null) {
            map.put(this.getKey(entitySearchResult.getEntityTypeID(), entitySearchResult.getEntityID()), entitySearchResult);
        }
        return entitySearchResult;
    }

    protected TrinityFieldProfile[] getFieldProfiles(List list) {
        this.debugOut("In getFieldProfiles().");
        TrinityFieldProfile[] trinityFieldProfileArray = new TrinityFieldProfile[list == null ? 0 : list.size()];
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Field field = (Field)list.get(i);
                if (field == null) continue;
                TrinityFieldProfile trinityFieldProfile = new TrinityFieldProfile();
                trinityFieldProfile.fieldName = field.fieldName;
                trinityFieldProfile.fieldID = field.fieldID;
                trinityFieldProfile.fieldValueName = MedeConnector.getFieldValueName(field.typeCode);
                trinityFieldProfileArray[i] = trinityFieldProfile;
            }
        }
        return trinityFieldProfileArray;
    }

    public boolean isValueInValueList(Integer n, String string, int n2, int n3) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", new String[]{"EntityTypeID", "EntityID"});
                sqlQueryGenerator.addTable("DTVALUES", new String[]{"ValueText", "ValueNumber"});
                sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
                String string2 = "DTVALUES.ValueText = " + this.prepStringForQuery(string);
                try {
                    long l = Long.parseLong(string);
                    string2 = string2 + " OR DTVALUES.ValueNumber = " + l;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sqlQueryGenerator.appendToWhere("DTVALUES.UniqueCollectionID = " + n);
                sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + n3 + " AND " + "DTVALUES" + ".FieldID = " + n2 + " AND " + "DTVALUES" + ".Enabled = 1" + " AND (" + string2 + ")");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Is value in value list query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    bl = true;
                    databaseConnector.close();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in isValueInValueList():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return bl;
    }

    public List getKeysOfDuplicateEntities(Integer n, Entity entity) {
        Vector<EntityKeyWrapper> vector = new Vector<EntityKeyWrapper>(0);
        if (entity != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                int n2;
                int n3 = this.getNextSearchQueryID(databaseConnector);
                this.clearSearchResults(n3, databaseConnector);
                long l = System.currentTimeMillis();
                List list = this.getDuplicateEntityPopulationQueries(n, n3, entity);
                for (n2 = 0; list != null && n2 < list.size(); ++n2) {
                    databaseConnector.setQuery((String)list.get(n2));
                    this.debugOut("Find dupe entities cmd[" + n2 + "]:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                }
                this.debugOut("Duplicate entity population time: " + (System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                databaseConnector.setQuery(this.getDuplicateEntitiesQuery(n3));
                this.debugOut("Get duplicate entities query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                while (databaseConnector.more()) {
                    vector.add(new EntityKeyWrapper(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID"), entity));
                    databaseConnector.next();
                }
                this.debugOut("Get duplicate entities query time: " + (System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                this.clearSearchResults(n3);
                if (vector.size() > 0) {
                    this.debugOut("Verify the duplicate entities.");
                    n2 = entity.getValueCountDeep();
                    this.debugOut("Target entity value count: " + n2);
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        EntityKey entityKey = (EntityKey)vector.get(n4);
                        int n5 = this.getEntityValueCount(n, entityKey, databaseConnector);
                        this.debugOut("Dupe entity candidate: " + entityKey.getEntityKeyString() + ", value count: " + n5);
                        if (n5 != n2) {
                            this.debugOut("Removing dupe entity candidate: " + entityKey.getEntityKeyString());
                            vector.remove(n4);
                            continue;
                        }
                        ++n4;
                    }
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getKeysOfDuplicateEntities():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in getKeysOfDuplicateEntities():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return vector;
    }

    protected String getDuplicateEntitiesQuery(int n) {
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("ITSEARCHRESULTS", null, new String[]{"ObjectID AS EntityTypeID", "MediaID AS EntityID"});
        sqlQueryGenerator.appendToWhere("ITSEARCHRESULTS.SearchQueryID = " + n);
        return sqlQueryGenerator.getQuery();
    }

    protected List getDuplicateEntityPopulationQueries(Integer n, int n2, Entity entity) {
        Vector<String> vector = new Vector<String>(0);
        if (entity != null) {
            List list = entity.getFieldValuesDeep();
            int n3 = -1;
            for (int i = 0; list != null && i < list.size(); ++i) {
                EntityFieldValue entityFieldValue = (EntityFieldValue)list.get(i);
                List list2 = entityFieldValue.getValues();
                for (int j = 0; list2 != null && j < list2.size(); ++j) {
                    String string;
                    if ((string = this.getSingleDuplicateEntityPopulationQuery(n, n2, ++n3, entity, entityFieldValue.getField(), (String)list2.get(j))) != null && string.length() > 0) {
                        vector.add(string);
                        continue;
                    }
                    --n3;
                }
            }
            if (n3 > 0) {
                vector.add("DELETE FROM ITSEARCHRESULTS WHERE SearchQueryID = " + n2 + " AND CriteriaID <> " + n3);
            }
        }
        return vector;
    }

    protected String getSingleDuplicateEntityPopulationQuery(Integer n, int n2, int n3, EntityKey entityKey, Field field, String string) {
        try {
            if (entityKey != null && field != null && string != null && string.length() > 0) {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                if (this.useDistinctKeyword) {
                    sqlQueryGenerator.setDistinctKeyword(this.distinctKeyword);
                }
                sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", null, new Object[]{new SqlColumnSelection(n2 + " AS SearchQueryID", false), new SqlColumnSelection(n3 + " AS CriteriaID", false), new SqlColumnSelection("EntityTypeID AS ObjectID", true), new SqlColumnSelection("EntityID AS MediaID", true)});
                sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
                String string2 = string;
                if (field.fieldType == 1) {
                    string2 = this.prepStringForQuery(string);
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DTVALUETOENTITYMAP.EntityTypeID = " + entityKey.getEntityTypeID() + " AND " + "DTVALUES" + ".UniqueCollectionID = " + n + " AND " + "DTVALUETOENTITYMAP" + ".EntityID NOT IN (" + entityKey.getEntityID() + ")" + " AND " + "DTVALUES" + ".FieldID = " + field.fieldID + " AND " + "DTVALUES" + ".Enabled = 1" + " AND " + "DTVALUES" + "." + MedeConnector.getFieldValueName(field.typeCode) + " = " + string2);
                if (n3 > 0) {
                    sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", new String[]{"EntityTypeID", "EntityID"}, "ITSEARCHRESULTS", new String[]{"ObjectID", "MediaID"}, 0);
                    stringBuffer.append(" AND (ITSEARCHRESULTS.CriteriaID = " + (n3 - 1) + " AND " + "ITSEARCHRESULTS" + ".SearchQueryID = " + n2 + ")");
                }
                sqlQueryGenerator.appendToWhere(stringBuffer.toString());
                return "INSERT INTO ITSEARCHRESULTS " + sqlQueryGenerator.getQuery();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getSingleDuplicateEntityPopulationQuery():\n" + InsightUtilities.getStackTrace(exception));
        }
        return null;
    }

    public List getEntityTypeFields(int n) {
        Vector<EntityField> vector = new Vector<EntityField>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRFIELDS", "*");
            sqlQueryGenerator.addTable("ISENTITYFIELDS", "*");
            sqlQueryGenerator.addJoin("IRFIELDS", "ISENTITYFIELDS", "FieldID", 0);
            sqlQueryGenerator.appendToWhere("ISENTITYFIELDS.EntityTypeID = " + n);
            sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("getEntityTypeFields query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            String string = null;
            String string2 = null;
            while (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerField("FieldID");
                int n3 = databaseConnector.getIntegerField("JoinID");
                int n4 = databaseConnector.getIntegerField("TableID");
                String string3 = databaseConnector.getFieldByName("DisplayName");
                String string4 = databaseConnector.getFieldByName("PreferredFieldName");
                try {
                    string = databaseConnector.getStringField("HierarchyIDColumnName");
                }
                catch (Exception exception) {
                    string = null;
                }
                try {
                    string2 = databaseConnector.getStringField("HierarchyNodeIDColumnName");
                }
                catch (Exception exception) {
                    string2 = null;
                }
                vector.add(new EntityField(n, n2, n3, n4, string3, string4, string, string2));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityTypeFields():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    protected void createKeywordClauseWithoutIntersect(StringBuffer stringBuffer, List list, boolean bl, Integer n, String string, int n2) {
        StringTokenizer stringTokenizer = null;
        for (int i = 0; list != null && i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                String string3 = this.useLowerCaseCommand ? this.convertKeyword(stringTokenizer.nextToken()).toLowerCase() : this.convertKeyword(stringTokenizer.nextToken());
                if (!this.useValueFromSubQuery) {
                    stringBuffer.append("(" + string + "EntityID IN (" + "SELECT " + "DTTERMTOENTITYMAP" + ".EntityID" + " FROM " + "DTTERMTOENTITYMAP" + ", " + "DTTERMS" + " WHERE " + "DTTERMTOENTITYMAP" + ".TermID = " + "DTTERMS" + ".TermID" + " AND " + "DTTERMTOENTITYMAP" + ".EntityTypeID = " + n2 + " AND " + "DTTERMTOENTITYMAP" + ".UniqueCollectionID = " + n);
                    if (bl) {
                        stringBuffer.append(" AND DTTERMS.Keyword LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string3 + this.STRING_WILDCARD_SYMBOL, false));
                    } else {
                        stringBuffer.append(" AND DTTERMS.Keyword LIKE " + this.prepStringForQuery(string3, false));
                    }
                } else {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    StringBuffer stringBuffer3 = new StringBuffer();
                    stringBuffer2.append("SELECT DTTERMTOENTITYMAP.EntityID FROM DTTERMTOENTITYMAP, DTTERMS WHERE DTTERMTOENTITYMAP.TermID = DTTERMS.TermID AND DTTERMTOENTITYMAP.EntityTypeID = " + n2 + " AND " + "DTTERMTOENTITYMAP" + ".UniqueCollectionID = " + n);
                    if (bl) {
                        stringBuffer2.append(" AND DTTERMS.Keyword LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string3 + this.STRING_WILDCARD_SYMBOL, false));
                    } else {
                        stringBuffer2.append(" AND DTTERMS.Keyword LIKE " + this.prepStringForQuery(string3, false));
                    }
                    DatabaseConnector databaseConnector = this.getDatabaseConnector();
                    databaseConnector.setQuery(stringBuffer2.toString());
                    this.debugOut("Entity sub search query:\n" + databaseConnector.getQuery());
                    long l = System.currentTimeMillis();
                    databaseConnector.runQuery();
                    this.debugOut("Entity search query time: " + (System.currentTimeMillis() - l));
                    try {
                        while (databaseConnector.more()) {
                            if (stringBuffer3.length() > 0) {
                                stringBuffer3.append(",");
                            }
                            stringBuffer3.append(databaseConnector.getIntegerField("EntityID"));
                            databaseConnector.next();
                        }
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception in createKeywordClause():\n" + InsightUtilities.getStackTrace(exception));
                    }
                    databaseConnector.close();
                    stringBuffer.append("(" + string + "EntityID IN (" + stringBuffer3.toString());
                }
                stringBuffer.append("))");
            }
        }
    }

    protected void createKeywordClauseWithIntersect(StringBuffer stringBuffer, List list, boolean bl, Integer n, String string, int n2) {
        StringTokenizer stringTokenizer = null;
        for (int i = 0; list != null && i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("(" + string + "EntityID IN (");
                } else {
                    stringBuffer.append(" INTERSECT ");
                }
                String string3 = this.useLowerCaseCommand ? this.convertKeyword(stringTokenizer.nextToken()).toLowerCase() : this.convertKeyword(stringTokenizer.nextToken());
                stringBuffer.append("SELECT DTTERMTOENTITYMAP.EntityID FROM DTTERMTOENTITYMAP, DTTERMS WHERE DTTERMTOENTITYMAP.TermID = DTTERMS.TermID AND DTTERMTOENTITYMAP.EntityTypeID = " + n2 + " AND " + "DTTERMTOENTITYMAP" + ".UniqueCollectionID = " + n);
                if (bl) {
                    stringBuffer.append(" AND DTTERMS.Keyword LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string3 + this.STRING_WILDCARD_SYMBOL, false));
                    continue;
                }
                stringBuffer.append(" AND DTTERMS.Keyword LIKE " + this.prepStringForQuery(string3, false));
            }
        }
        stringBuffer.append("))");
    }

    protected String createKeywordClause(Integer n, List list, String string, int n2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + ".";
        }
        boolean bl2 = bl = this.collectionLocale.equals(Locale.TRADITIONAL_CHINESE) || this.collectionLocale.equals(new Locale("zh", "CN")) || this.collectionLocale.equals(Locale.JAPAN) || this.collectionLocale.equals(Locale.KOREA);
        if (this.useIntersectInKeyword) {
            this.createKeywordClauseWithIntersect(stringBuffer, list, bl, n, string2, n2);
        } else {
            this.createKeywordClauseWithoutIntersect(stringBuffer, list, bl, n, string2, n2);
        }
        return stringBuffer.toString();
    }

    protected String createCriteriaClause(List list, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.groupFieldCriterions(list);
        Object var5_5 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            var5_5 = vector.get(i);
            if (var5_5 instanceof KeywordsFieldCriterion) {
                // empty if block
            }
            if (var5_5 instanceof ObjectIndicatorFieldCriterion || var5_5 instanceof MviFieldCriterion || var5_5 instanceof MpdFieldCriterion || var5_5 instanceof AudioFieldCriterion || var5_5 instanceof VideoFieldCriterion || var5_5 instanceof QtvrFieldCriterion || var5_5 instanceof HierarchyNodeFieldCriterion || var5_5 instanceof FuzzyDateFieldCriterion || var5_5 instanceof LinkFieldCriterion) continue;
            if (var5_5 instanceof OrphanSearchFieldCriterion) {
                if (stringBuffer.length() > 0) {
                    if (((FieldCriterion)var5_5).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("((SELECT COUNT(*) FROM IRENTITYMEDIAMAP WHERE IRENTITYMEDIAMAP.EntityTypeID = DTVALUETOENTITYMAP.EntityTypeID AND IRENTITYMEDIAMAP.EntityID = DTVALUETOENTITYMAP.EntityID) = 0)");
                continue;
            }
            if (!(var5_5 instanceof Vector)) continue;
            Vector vector2 = var5_5;
            FieldCriterion fieldCriterion = (FieldCriterion)vector2.firstElement();
            Field field = fieldCriterion.field;
            if (field == null) continue;
            if (stringBuffer.length() > 0) {
                if (fieldCriterion.booleanOperator == 1) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" OR ");
                }
            }
            stringBuffer.append("(");
            String string = vector2.size() == 1 && ((FieldCriterion)vector2.get((int)0)).relationship == 11 ? "NOT IN" : "IN";
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("SELECT EntityID FROM DTVALUES, DTVALUETOENTITYMAP WHERE (DTVALUES.ValueID = DTVALUETOENTITYMAP.ValueID) AND (DTVALUETOENTITYMAP.EntityTypeID = " + n + " AND FieldID = " + field.fieldID + " AND (");
            FieldCriterion fieldCriterion2 = null;
            for (int j = 0; j < vector2.size(); ++j) {
                String string2;
                fieldCriterion2 = (FieldCriterion)vector2.get(j);
                if (j > 0) {
                    if (fieldCriterion2.booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                object = fieldCriterion2.equivalence.getSearchValue();
                object = field.fieldType == 1 ? this.escapeSpecialCharacters((String)object) : this.escapeQuotes((String)object);
                boolean bl = false;
                if (this.useLowerCaseCommand) {
                    string2 = field.fieldType == 2 ? "DTVALUES." + MedeConnector.getFieldValueName(field.typeCode) : "LOWER(DTVALUES." + MedeConnector.getFieldValueName(field.typeCode) + ")";
                    if (this.useLowerCaseCommandOnSearchValue && field.fieldType != 2) {
                        bl = true;
                    } else {
                        object = ((String)object).toLowerCase();
                    }
                } else {
                    string2 = "DTVALUES." + MedeConnector.getFieldValueName(field.typeCode);
                }
                stringBuffer2.append(this.createEquivalenceRelationshipClause(string2, field.fieldType, fieldCriterion2.relationship, (String)object, bl));
            }
            stringBuffer2.append("))");
            if (!this.useValueFromSubQuery) {
                stringBuffer.append("(DTVALUETOENTITYMAP.EntityID " + string + " (" + stringBuffer2.toString() + ")))");
                continue;
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            object = this.getDatabaseConnector();
            object.setQuery(stringBuffer2.toString());
            this.debugOut("Sub entity search query:\n" + object.getQuery());
            long l = System.currentTimeMillis();
            object.runQuery();
            this.debugOut("Sub entity search query time: " + (System.currentTimeMillis() - l));
            try {
                while (object.more()) {
                    if (stringBuffer3.length() > 0) {
                        stringBuffer3.append(",");
                    }
                    stringBuffer3.append(object.getIntegerField("EntityID"));
                    object.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in createCriteriaClause():\n" + InsightUtilities.getStackTrace(exception));
            }
            object.close();
            stringBuffer.append("(DTVALUETOENTITYMAP.EntityID " + string + " (" + stringBuffer3.toString() + ")))");
        }
        return stringBuffer.toString();
    }

    protected Vector groupFieldCriterions(List list) {
        Vector<Cloneable> vector = new Vector<Cloneable>();
        if (list != null && list.size() > 0) {
            boolean bl = false;
            Object var4_4 = null;
            Vector vector2 = null;
            FieldCriterion fieldCriterion = null;
            for (int i = 0; i < list.size(); ++i) {
                FieldCriterion fieldCriterion2 = (FieldCriterion)list.get(i);
                if (fieldCriterion2 == null) continue;
                if (fieldCriterion2.getType() == 0) {
                    if (fieldCriterion2.field == null || fieldCriterion2.field.fieldType == 0 || fieldCriterion2.relationship == 0) continue;
                    bl = false;
                    for (int j = 0; j < vector.size(); ++j) {
                        var4_4 = vector.get(j);
                        if (!(var4_4 instanceof Vector)) continue;
                        vector2 = var4_4;
                        fieldCriterion = (FieldCriterion)vector2.firstElement();
                        if (fieldCriterion2.getType() != fieldCriterion.getType() || fieldCriterion2.booleanOperator != fieldCriterion.booleanOperator || fieldCriterion2.field == null || fieldCriterion.field == null || fieldCriterion2.field.fieldID != fieldCriterion.field.fieldID) continue;
                        vector2.add(fieldCriterion2);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    vector2 = new Vector(1);
                    vector2.add(fieldCriterion2);
                    vector.add(vector2);
                    continue;
                }
                vector.add(fieldCriterion2);
            }
        }
        return vector;
    }

    protected String createMediaCriteriaClause(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; list != null && i < list.size(); ++i) {
            FieldCriterion fieldCriterion = (FieldCriterion)list.get(i);
            if (fieldCriterion instanceof OrphanSearchFieldCriterion) {
                if (stringBuffer.length() > 0) {
                    if (fieldCriterion.booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("((SELECT COUNT(*) FROM IRENTITYMEDIAMAP WHERE IRENTITYMEDIAMAP.MediaID = IRIMAGEFILES.ImageID) = 0)");
                continue;
            }
            if (fieldCriterion.getType() != 0) continue;
            if (stringBuffer.length() > 0) {
                if (fieldCriterion.booleanOperator == 1) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" OR ");
                }
            }
            String string = fieldCriterion.equivalence.getSearchValue();
            String string2 = "IRIMAGEFILES." + fieldCriterion.field.fieldName;
            stringBuffer.append(this.createEquivalenceRelationshipClause(string2, fieldCriterion.field.fieldType, fieldCriterion.relationship, string, false));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCollectionBuildingObject(CollectionBuildingObject collectionBuildingObject) {
        if (collectionBuildingObject == null || collectionBuildingObject.getTCI() == null) {
            return false;
        }
        TrinityCollectionInfo trinityCollectionInfo = collectionBuildingObject.getTCI();
        BaseTemplate baseTemplate = this.getCatalogTemplate(collectionBuildingObject.getFieldStandardTemplateName());
        if (baseTemplate == null) {
            return false;
        }
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        boolean bl = true;
        try {
            Serializable serializable;
            Object object;
            Object object2;
            Object object3;
            int n = 0;
            if (collectionBuildingObject.isFieldStandardModified() || collectionBuildingObject.isMappingStandardsModified()) {
                object3 = this.getQueryGenerator();
                ((SqlQueryGenerator)object3).addTable("SLSTANDARDSLOOKUP", null, "StandardID");
                ((SqlQueryGenerator)object3).appendToWhere("Standard_Type = 4");
                ((SqlQueryGenerator)object3).appendToWhere("StandardName = " + ((SqlQueryGenerator)object3).prepStringForQuery(collectionBuildingObject.getCollectionName()));
                databaseConnector.setQuery(((SqlQueryGenerator)object3).getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n = databaseConnector.getIntegerField("StandardID", n);
                }
                databaseConnector.close();
                if (n == 0) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            if (collectionBuildingObject.isFieldStandardModified()) {
                String string;
                bl = false;
                object3 = new ArrayList();
                object2 = new ArrayList();
                object = collectionBuildingObject.getThumbnailFields().iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    serializable = baseTemplate.getLinkedEntityFieldByName(string);
                    if (serializable == null) {
                        serializable = baseTemplate.getLinkedEntityFieldByDisplayName(string);
                    }
                    if (serializable != null) {
                        object3.add(new Integer(((BaseTemplateElement)serializable).getID()));
                        continue;
                    }
                    object3.add(new Integer(-1));
                }
                object = collectionBuildingObject.getSortFields().iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    serializable = baseTemplate.getLinkedEntityFieldByName(string);
                    if (serializable == null) {
                        serializable = baseTemplate.getLinkedEntityFieldByDisplayName(string);
                    }
                    if (serializable != null) {
                        object2.add(new Integer(((BaseTemplateElement)serializable).getID()));
                        continue;
                    }
                    object2.add(new Integer(-1));
                }
                object = "UPDATE IRCOLLECTIONCONFIGURATIONINFO SET ThumbnailDataField1 = " + this.prepStringForQuery((Integer)object3.get(0) + "") + ", " + "ThumbnailDataField2 = " + this.prepStringForQuery((Integer)object3.get(1) + "") + ", " + "ThumbnailDataField3 = " + this.prepStringForQuery((Integer)object3.get(2) + "") + ", " + "ThumbnailDataField4 = " + this.prepStringForQuery((Integer)object3.get(3) + "") + ", " + "DefaultSortField1 = " + this.prepStringForQuery((Integer)object2.get(0) + "") + ", " + "DefaultSortField2 = " + this.prepStringForQuery((Integer)object2.get(1) + "") + ", " + "DefaultSortField3 = " + this.prepStringForQuery((Integer)object2.get(2) + "") + ", " + "DefaultSortField4 = " + this.prepStringForQuery((Integer)object2.get(3) + "") + " WHERE UniqueCollectionID = " + collectionBuildingObject.getUniqueCollectionID() + " AND VCID = " + this.prepStringForQuery("NA");
                databaseConnector.setQuery((String)object);
                bl = databaseConnector.runUpdateQuery() > 0;
                databaseConnector.close();
                if (bl) {
                    string = "UPDATE SLSTANDARDSSTARTUP SET Thumbnail1FieldID = " + (Integer)object3.get(0) + ", " + "Thumbnail2FieldID = " + (Integer)object3.get(1) + ", " + "Thumbnail3FieldID = " + (Integer)object3.get(2) + ", " + "Thumbnail4FieldID = " + (Integer)object3.get(3) + ", " + "Sort1FieldID = " + (Integer)object2.get(0) + ", " + "Sort2FieldID = " + (Integer)object2.get(1) + ", " + "Sort3FieldID = " + (Integer)object2.get(2) + ", " + "Sort4FieldID = " + (Integer)object2.get(3) + " " + " WHERE StandardID = " + n;
                    databaseConnector.setQuery(string);
                    bl = databaseConnector.runUpdateQuery() > 0;
                    databaseConnector.close();
                }
                if (!bl) {
                    boolean bl3 = bl;
                    return bl3;
                }
            }
            if (collectionBuildingObject.isCollectionDescriptionModified() || collectionBuildingObject.isCopyrightModified() || collectionBuildingObject.isCollectionURLModified() || collectionBuildingObject.isPCUserGroupEditableModified() || collectionBuildingObject.isPCNonUserGroupEditableModified()) {
                bl = false;
                object3 = "UPDATE IRCOLLECTIONCONFIGURATIONINFO SET ";
                object2 = new StringBuffer();
                if (collectionBuildingObject.isCollectionDescriptionModified()) {
                    object = "ShortDescription = " + this.prepStringForQuery(collectionBuildingObject.getDescription());
                    ((StringBuffer)object2).append((String)object);
                }
                if (collectionBuildingObject.isCopyrightModified()) {
                    object = "CopyrightStatement = " + this.prepStringForQuery(collectionBuildingObject.getCollectionCopyright());
                    ((StringBuffer)object2).append((String)(((StringBuffer)object2).length() > 0 ? ", " + (String)object : object));
                }
                if (collectionBuildingObject.isCollectionURLModified()) {
                    object = "LongDescriptionURL = " + this.prepStringForQuery(collectionBuildingObject.getCollectionURL());
                    ((StringBuffer)object2).append((String)(((StringBuffer)object2).length() > 0 ? ", " + (String)object : object));
                }
                if (collectionBuildingObject.isPCUserGroupEditableModified()) {
                    object = "PcUserGroupMemberPrivs = " + collectionBuildingObject.getTCI().getPcUsrGrpMemberPrivs();
                    ((StringBuffer)object2).append((String)(((StringBuffer)object2).length() > 0 ? ", " + (String)object : object));
                }
                if (collectionBuildingObject.isPCNonUserGroupEditableModified()) {
                    object = "PcNonUserGroupMemberPrivs = " + collectionBuildingObject.getTCI().getPcNonUsrGrpMemberPrivs();
                    ((StringBuffer)object2).append((String)(((StringBuffer)object2).length() > 0 ? ", " + (String)object : object));
                }
                object3 = (String)object3 + object2 + " WHERE UniqueCollectionID = " + collectionBuildingObject.getUniqueCollectionID();
                object3 = collectionBuildingObject.getCollectionType().equals(CollectionBuildingObject.VIRTUAL_TYPE) ? (String)object3 + " AND VCID = " + this.prepStringForQuery(trinityCollectionInfo.getVCID()) : (String)object3 + " AND VCID = " + this.prepStringForQuery("NA");
                databaseConnector.setQuery((String)object3);
                bl = databaseConnector.runUpdateQuery() > 0;
                databaseConnector.close();
                if (!bl) {
                    boolean bl4 = bl;
                    return bl4;
                }
            }
            if (collectionBuildingObject.isMappingStandardsModified()) {
                bl = false;
                object3 = collectionBuildingObject.getMappingStandards();
                if (object3 == null) {
                    object2 = "DELETE FROM SLCOLLECTIONSTANDARDMAP WHERE UniqueCollectionID = " + collectionBuildingObject.getUniqueCollectionID();
                    object = this.generateDefaultCollectionStandardMapUpdateBatch(collectionBuildingObject, baseTemplate, n);
                    object.add(0, object2);
                    databaseConnector.executeBatch((Collection)object, false);
                    databaseConnector.close();
                } else {
                    object2 = "DELETE FROM SLCOLLECTIONSTANDARDMAP WHERE UniqueCollectionID = " + collectionBuildingObject.getUniqueCollectionID() + " AND StandardID NOT IN (" + n + ", " + baseTemplate.getTemplateID() + ")";
                    object = new ArrayList<Object>();
                    object.add(object2);
                    for (int i = 0; i < object3.size(); ++i) {
                        serializable = (MappingStandard)object3.get(i);
                        object.add("INSERT INTO SLCOLLECTIONSTANDARDMAP (UniqueCollectionID, StandardID, Standards_Order) VALUES (" + collectionBuildingObject.getUniqueCollectionID() + ", " + ((MappingStandard)serializable).getStandardID() + ", " + (i + 100) + ")");
                    }
                    databaseConnector.executeBatch((Collection)object, false);
                    databaseConnector.close();
                }
                this.updateFieldStandardsManagerEnabledOrder(collectionBuildingObject.getUniqueCollectionID());
                bl = true;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateCollectionBuildingObject():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFieldStandardsManagerEnabledOrder(Integer n) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            FieldStandardsManager fieldStandardsManager = InsightSmartServer.getPrimaryServerInstance().getFSM(n);
            if (fieldStandardsManager != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList arrayList2 = new ArrayList();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "StandardName");
                sqlQueryGenerator.addTable("SLCOLLECTIONSTANDARDMAP", null, "*");
                sqlQueryGenerator.addJoin("SLSTANDARDSLOOKUP", "SLCOLLECTIONSTANDARDMAP", "StandardID", 0);
                sqlQueryGenerator.addOrderBy("SLCOLLECTIONSTANDARDMAP", "Standards_Order");
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    arrayList.add(databaseConnector.getFieldByName("StandardName"));
                    databaseConnector.next();
                }
                fieldStandardsManager.setEnabledStandardsOrder(arrayList);
            }
        }
        catch (Throwable throwable) {
            this.debugOut("Exception when updating field standards:\n" + InsightUtilities.getStackTrace(throwable));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean saveVirtualCollection(CollectionBuildingObject var1_1, ThemeFileManager var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCollectionBuildingObject(CollectionBuildingObject collectionBuildingObject, ThemeFileManager themeFileManager, int n) {
        this.debugOut("in saveCollectionBuildingObject().");
        if (!collectionBuildingObject.isTemporary()) {
            return this.updateCollectionBuildingObject(collectionBuildingObject);
        }
        if (collectionBuildingObject.getCollectionType().equals(CollectionBuildingObject.VIRTUAL_TYPE)) {
            return this.saveVirtualCollection(collectionBuildingObject, themeFileManager);
        }
        if (collectionBuildingObject != null && collectionBuildingObject.getTCI() != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                Object object;
                Object object2;
                TrinityCollectionInfo trinityCollectionInfo = collectionBuildingObject.getTCI();
                BaseTemplate baseTemplate = this.getCatalogTemplate(collectionBuildingObject.getFieldStandardTemplateName());
                if (baseTemplate == null) {
                    boolean bl = false;
                    return bl;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                Iterator iterator = collectionBuildingObject.getThumbnailFields().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    object = baseTemplate.getLinkedEntityFieldByName((String)object2);
                    if (object == null) {
                        object = baseTemplate.getLinkedEntityFieldByDisplayName((String)object2);
                    }
                    if (object != null) {
                        arrayList.add(new Integer(((BaseTemplateElement)object).getID()));
                        continue;
                    }
                    arrayList.add(new Integer(-1));
                }
                iterator = collectionBuildingObject.getSortFields().iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    object = baseTemplate.getLinkedEntityFieldByName((String)object2);
                    if (object == null) {
                        object = baseTemplate.getLinkedEntityFieldByDisplayName((String)object2);
                    }
                    if (object != null) {
                        arrayList2.add(new Integer(((BaseTemplateElement)object).getID()));
                        continue;
                    }
                    arrayList2.add(new Integer(-1));
                }
                int n2 = 0;
                object2 = MAX_IDS_LOCK_OBJ;
                synchronized (object2) {
                    try {
                        int n3;
                        int n4;
                        int n5;
                        object = this.getNextCollectionID(databaseConnector);
                        collectionBuildingObject.setCollectionID((int)object[0]);
                        collectionBuildingObject.setUniqueCollectionID(new Integer((int)object[1]));
                        if (!collectionBuildingObject.isPersonalCollection()) {
                            n2 = this.getNextProfileID();
                        }
                        trinityCollectionInfo.setNativeStandardID(baseTemplate.getTemplateID());
                        String string = collectionBuildingObject.getCollectionName();
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                        int n6 = this.getInsightUserID(trinityCollectionInfo.getPcOwner(), true, databaseConnector);
                        if (collectionBuildingObject.isPersonalCollection()) {
                            String string2 = themeFileManager.getBrowserBaseThemeURL();
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsPersonalCollection", 2, stringBuffer2, "1");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcOwnerID", 2, stringBuffer2, n6);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcOwnerUserGroupID", 2, stringBuffer2, n);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcUserGroupMemberPrivs", 2, stringBuffer2, trinityCollectionInfo.getPcUsrGrpMemberPrivs());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcNonUserGroupMemberPrivs", 2, stringBuffer2, trinityCollectionInfo.getPcNonUsrGrpMemberPrivs());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserCollection", 2, stringBuffer2, 0);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGMenu", 1, stringBuffer2, string2 + "menu_bg.jpg");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGroupLeft", 1, stringBuffer2, string2 + "groupleft_bg.jpg");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGroupLeftNS", 1, stringBuffer2, string2 + "groupleft_bg_ns.jpg");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGroupRight", 1, stringBuffer2, string2 + "groupright_bg.jpg");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGWBottom", 1, stringBuffer2, string2 + "gwbottom_bg.jpg");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGWTop", 1, stringBuffer2, string2 + "gwtop_bg.jpg");
                        } else {
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbCacheProfileID", 2, stringBuffer2, n2);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserCollection", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsPersonalCollection", 2, stringBuffer2, "0");
                        }
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InstitutionID", 1, stringBuffer2, collectionBuildingObject.getInstitutionID());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionID", 1, stringBuffer2, collectionBuildingObject.getCollectionID());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VCID", 1, stringBuffer2, collectionBuildingObject.getVCID());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID().toString());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "NativeStandardID", 2, stringBuffer2, trinityCollectionInfo.getNativeStandardID() + "");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionName", 1, stringBuffer2, trinityCollectionInfo.getCollectionName());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InitialActivity", 2, stringBuffer2, trinityCollectionInfo.getInitialActivity());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InitialGroupOpen", 1, stringBuffer2, trinityCollectionInfo.getCollectionName());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayArtistStories", 2, stringBuffer2, "0");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VerticalBarX", 2, stringBuffer2, trinityCollectionInfo.getVerticalBarX());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HorizontalBarY", 2, stringBuffer2, trinityCollectionInfo.getHorizontalBarY());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BackgroundColorR", 2, stringBuffer2, trinityCollectionInfo.getBackgroundColor().getRed());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BackgroundColorG", 2, stringBuffer2, trinityCollectionInfo.getBackgroundColor().getGreen());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BackgroundColorB", 2, stringBuffer2, trinityCollectionInfo.getBackgroundColor().getBlue());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LargeThumbnailThreshold", 2, stringBuffer2, trinityCollectionInfo.getLargeThumbnailThreshold());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DefaultViewResolution", 2, stringBuffer2, trinityCollectionInfo.getDefaultViewResolution());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupTopInset", 2, stringBuffer2, trinityCollectionInfo.getGroupTopInset());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupLeftInset", 2, stringBuffer2, trinityCollectionInfo.getGroupLeftInset());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupSpacingH", 2, stringBuffer2, trinityCollectionInfo.getGroupSpacingH());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupSpacingV", 2, stringBuffer2, trinityCollectionInfo.getGroupSpacingV());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MenuXPosition", 2, stringBuffer2, trinityCollectionInfo.getMenuXPosition());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MaximumWindows", 2, stringBuffer2, trinityCollectionInfo.getMaximumWindows());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InterWindowSpacing", 2, stringBuffer2, trinityCollectionInfo.getInterWindowSpacing());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MinImageWindowSizeWidth", 2, stringBuffer2, trinityCollectionInfo.getMinImageWindowSize().width);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MinImageWindowSizeHeight", 2, stringBuffer2, trinityCollectionInfo.getMinImageWindowSize().height);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DragSpeedCoeffecient", 2, stringBuffer2, trinityCollectionInfo.getDragSpeedCoeffecient());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InitialGroupROnly", 2, stringBuffer2, "1");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HelpGroup", 1, stringBuffer2, trinityCollectionInfo.getHelpGroup());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HelpImage", 1, stringBuffer2, trinityCollectionInfo.getHelpImage());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SimultaneousIWLoads", 2, stringBuffer2, trinityCollectionInfo.getSimultaneousIWLoads());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SimultaneousGWLoads", 2, stringBuffer2, trinityCollectionInfo.getSimultaneousGWLoads());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MacWidthAdjustment", 2, stringBuffer2, trinityCollectionInfo.getMacWidthAdjustment());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BGURL", 1, stringBuffer2, trinityCollectionInfo.getBGURL());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FastScaling", 2, stringBuffer2, trinityCollectionInfo.getScaleFast() ? "1" : "0");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CopyrightStatement", 1, stringBuffer2, trinityCollectionInfo.getCopyrightStatement());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ForceCollectionNameDisplay", 2, stringBuffer2, trinityCollectionInfo.getForceCollectionName() ? "1" : "0");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShortDescription", 1, stringBuffer2, collectionBuildingObject.getDescription());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongDescriptionURL", 1, stringBuffer2, collectionBuildingObject.getCollectionURL());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, new SimpleDate().get());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LanguageCode", 1, stringBuffer2, "en");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CountryCode", 1, stringBuffer2, "US");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserSecurity", 2, stringBuffer2, 1);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserRtlURL", 1, stringBuffer2, InsightSmartServer.getPrimaryServerInstance().getBrowserRemoteLaunchURL());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserRtlImage", 1, stringBuffer2, browserRTLImage);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RemoteLaunchBaseURL", 1, stringBuffer2, InsightSmartServer.getPrimaryServerInstance().getJvaRemoteLaunchURL());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RemoteLaunchHyperlinkTemplate ", 1, stringBuffer2, remoteLaunchLinkTemplate);
                        for (n5 = 0; n5 < arrayList.size(); ++n5) {
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbnailDataField" + (n5 + 1), 1, stringBuffer2, ((Integer)arrayList.get(n5)).toString());
                        }
                        for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DefaultSortField" + (n5 + 1), 1, stringBuffer2, ((Integer)arrayList2.get(n5)).toString());
                        }
                        databaseConnector.setQuery("INSERT INTO IRCOLLECTIONCONFIGURATIONINFO (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Insert collection info cmd:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        TrinityIndexer.clearBrowserFieldsCache(collectionBuildingObject.getUniqueCollectionID());
                        if (this.publisher != null) {
                            this.publisher.clearEntityInfo(collectionBuildingObject.getUniqueCollectionID());
                        }
                        stringBuffer = new StringBuffer();
                        stringBuffer2 = new StringBuffer();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID().toString());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ApprovalLevel", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CommitToInvertedData", 2, stringBuffer2, 1);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CommitToSourceData", 2, stringBuffer2, 0);
                        databaseConnector.setQuery("INSERT INTO IRAPPROVALLEVELS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Insert approval level:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        stringBuffer = new StringBuffer();
                        stringBuffer2 = new StringBuffer();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID().toString());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "WIDTHFIELDID", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HEIGHTFIELDID", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "METRIC", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "WIDTHQUALIFIERFIELDID", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "WIDTHQUALIFIERVALUE", 1, stringBuffer2, "");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HEIGHTQUALIFIERFIELDID", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HEIGHTQUALIFIERVALUE", 1, stringBuffer2, "");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "WIDTHMETRICFIELDID", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HEIGHTMETRICFIELDID", 2, stringBuffer2, 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "METRICNAMEMAP", 1, stringBuffer2, "");
                        databaseConnector.setQuery("INSERT INTO IROBJECTDIMENSION (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Insert object dimension level:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        n5 = this.getNextGroupId();
                        stringBuffer = new StringBuffer();
                        stringBuffer2 = new StringBuffer();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID().toString());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, n5);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Name", 1, stringBuffer2, collectionBuildingObject.getCollectionName());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupType", 2, stringBuffer2, 1);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VCID", 1, stringBuffer2, collectionBuildingObject.getVCID());
                        String string3 = new SimpleDate().get();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, string3);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LastModifiedTimestamp", 1, stringBuffer2, string3);
                        databaseConnector.setQuery("INSERT INTO IRGROUPS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Insert collection group:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        if (!collectionBuildingObject.isPersonalCollection()) {
                            String string4 = null;
                            String string5 = "admin";
                            for (n4 = 0; n4 < CollectionProfile.STUDIO_PROFILE_IDS.length; ++n4) {
                                CollectionProfile collectionProfile = new CollectionProfile(n2 + n4, 1, CollectionProfile.STUDIO_PROFILE_IDS[n4], collectionBuildingObject.getCollectionName(), collectionBuildingObject.getUniqueCollectionID());
                                if (CollectionProfile.STUDIO_PROFILE_IDS[n4] == 0) {
                                    string4 = collectionProfile.getDisplayName();
                                }
                                stringBuffer = new StringBuffer();
                                stringBuffer2 = new StringBuffer();
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ProfileID", 2, stringBuffer2, collectionProfile.getId());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SpsNum", 2, stringBuffer2, collectionProfile.getSps());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ExportPriv", 2, stringBuffer2, collectionProfile.getMaxExportSize());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PrintPriv", 2, stringBuffer2, collectionProfile.isPrint());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EditPriv", 2, stringBuffer2, collectionProfile.isEdit());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EditVocabPriv", 2, stringBuffer2, collectionProfile.isEditVocab());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MaxViewableSize", 2, stringBuffer2, collectionProfile.getMaxViewableSize());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HTMLExport", 2, stringBuffer2, collectionProfile.isHTMLExport());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SaveGroups", 2, stringBuffer2, collectionProfile.isSaveGroup());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DeleteGroups", 2, stringBuffer2, collectionProfile.isDeleteGroup());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EditMVIPriv", 2, stringBuffer2, collectionProfile.isEditMVI());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EditLinkPriv", 2, stringBuffer2, collectionProfile.isEditLink());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EditMPDPriv", 2, stringBuffer2, collectionProfile.isEditMPD());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayName", 1, stringBuffer2, collectionProfile.getDisplayName());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ApprovalLevel", 2, stringBuffer2, collectionProfile.getApprovalLevel());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MedePermissions", 2, stringBuffer2, collectionProfile.getMedePermissions());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ExportPresentationPriv", 2, stringBuffer2, collectionProfile.getMaxPresentationExportSize());
                                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EditPersonalCollections", 2, stringBuffer2, collectionProfile.isEditPersonalCollections());
                                databaseConnector.setQuery("INSERT INTO IRPROFILE (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                                databaseConnector.runUpdateQuerySafe();
                                databaseConnector.close();
                            }
                            n4 = this.getNextUserGroupID();
                            stringBuffer = new StringBuffer();
                            stringBuffer2 = new StringBuffer();
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, n4);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ProfileID", 2, stringBuffer2, n2);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupName", 1, stringBuffer2, string4);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupCodeKey", 1, stringBuffer2, string5);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ConnectionPoolID", 2, stringBuffer2, 1);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ConnectionReserve", 2, stringBuffer2, 0);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IPADDRESSRANGES", 1, stringBuffer2, "0.0.0.0 - 255.255.255.255");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserIPAddressRanges", 1, stringBuffer2, "0.0.0.0 - 255.255.255.255");
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, new SimpleDate().get());
                            databaseConnector.setQuery("INSERT INTO IRUSERGROUPS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                            databaseConnector.runUpdateQuerySafe();
                            databaseConnector.close();
                            collectionBuildingObject.setCollectionUserGroupName(string4);
                            collectionBuildingObject.setCollectionUserGroupCodeKey(string5);
                        }
                        int n7 = this.getNextFieldStandardID();
                        stringBuffer = new StringBuffer();
                        stringBuffer2 = new StringBuffer();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n7);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Standard_Type", 2, stringBuffer2, 4);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, string);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ParentStandardID", 2, stringBuffer2, baseTemplate.getTemplateID());
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Version", 1, stringBuffer2, "1.0");
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsTemplate", 2, stringBuffer2, false);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, new SimpleDate().get());
                        databaseConnector.setQuery("INSERT INTO SLSTANDARDSLOOKUP (" + stringBuffer.toString() + ") VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Insert standards lookup query:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        stringBuffer = new StringBuffer();
                        stringBuffer2 = new StringBuffer();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n7);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreateThumbCache", 2, stringBuffer2, collectionBuildingObject.isPersonalCollection() ? 0 : 1);
                        for (n3 = 0; n3 < arrayList.size(); ++n3) {
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Thumbnail" + (n3 + 1) + "FieldID", 2, stringBuffer2, (Integer)arrayList.get(n3));
                        }
                        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Sort" + (n3 + 1) + "FieldID", 2, stringBuffer2, (Integer)arrayList2.get(n3));
                        }
                        databaseConnector.setQuery("INSERT INTO SLSTANDARDSSTARTUP (" + stringBuffer.toString() + ") VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Insert standards startup query:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        List list = this.generateDefaultCollectionStandardMapUpdateBatch(collectionBuildingObject, baseTemplate, n7);
                        if (list != null && list.size() > 0) {
                            databaseConnector.executeBatch(list, true);
                            databaseConnector.close();
                        }
                        n4 = 1;
                        return n4 != 0;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Exception exception) {
                            this.debugOut("Exception in saveCollectionBuildingObject():\n" + InsightUtilities.getStackTrace(exception));
                        }
                        catch (Error error) {
                            this.debugOut("Error in saveCollectionBuildingObject():\n" + InsightUtilities.getStackTrace(error));
                        }
                    }
                }
            }
            finally {
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
            }
        }
        {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List generateDefaultCollectionStandardMapUpdateBatch(CollectionBuildingObject collectionBuildingObject, BaseTemplate baseTemplate, int n) throws Exception {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            databaseConnector.setQuery("SELECT StandardID, Standards_Order FROM SLSTANDARDSLOOKUP WHERE Standard_Type = 3");
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerField("Standards_Order", -1);
                if (n2 >= 0) {
                    hashMap.put(new Integer(n2), new Integer(databaseConnector.getIntegerField("StandardID")));
                }
                databaseConnector.next();
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Standards_Order", 2, stringBuffer2, 1);
            arrayList.add("INSERT INTO SLCOLLECTIONSTANDARDMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, baseTemplate.getTemplateID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Standards_Order", 2, stringBuffer2, 2);
            arrayList.add("INSERT INTO SLCOLLECTIONSTANDARDMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            Object object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                Integer n3 = (Integer)object.next();
                Integer n4 = (Integer)hashMap.get(n3);
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, collectionBuildingObject.getUniqueCollectionID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n4);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Standards_Order", 2, stringBuffer2, 3 + n3);
                arrayList.add("INSERT INTO SLCOLLECTIONSTANDARDMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            }
            object = arrayList;
            return object;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    private boolean createEntityTypeAndFieldIDs(DatabaseConnector databaseConnector, BaseTemplate baseTemplate) {
        BaseTemplateElement baseTemplateElement;
        Set set = baseTemplate.getLinkedTypes();
        Set set2 = baseTemplate.getLinkedFields();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            baseTemplateElement = (BaseEntityType)iterator.next();
            baseTemplateElement.setID(this.getNextFieldID(databaseConnector));
            if (baseTemplateElement.getID() != -1) continue;
            return false;
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            baseTemplateElement = (BaseEntityField)iterator.next();
            baseTemplateElement.setID(this.getNextFieldID(databaseConnector));
            if (baseTemplateElement.getID() != -1) continue;
            return false;
        }
        return true;
    }

    public BaseTemplate getCatalogTemplate(String string) {
        Set set = this.getCatalogTemplates();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            BaseTemplate baseTemplate = (BaseTemplate)iterator.next();
            if (!baseTemplate.getTemplateName().equals(string)) continue;
            return baseTemplate;
        }
        return null;
    }

    public BaseTemplate getCatalogTemplate(int n) {
        Set set = this.getCatalogTemplates();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            BaseTemplate baseTemplate = (BaseTemplate)iterator.next();
            if (baseTemplate.getTemplateID() != n) continue;
            return baseTemplate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMappingStandards() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        ArrayList<MappingStandard> arrayList = new ArrayList<MappingStandard>();
        try {
            HashSet<FieldMapping> hashSet;
            String string;
            Integer n;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDFIELDS", null, new String[]{"StandardID", "StandardName", "StandardFieldID", "StandardFieldName", "StandardFieldDisplayName", "StandardFieldType", "LongString"});
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "Standard_Type");
            sqlQueryGenerator.addJoin("SLSTANDARDFIELDS", "SLSTANDARDSLOOKUP", "StandardID", 0);
            sqlQueryGenerator.appendToWhere("SLSTANDARDSLOOKUP.Standard_Type = 3 OR SLSTANDARDSLOOKUP.Standard_Type = 2");
            sqlQueryGenerator.appendToWhere("SLSTANDARDSLOOKUP.Standards_Order > -1");
            sqlQueryGenerator.addOrderBy("SLSTANDARDSLOOKUP", "Standards_Order");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            HashMap<Integer, HashSet<FieldMapping>> hashMap2 = new HashMap<Integer, HashSet<FieldMapping>>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            while (databaseConnector.more()) {
                FieldMapping fieldMapping = new FieldMapping(databaseConnector.getFieldByName("StandardFieldName"), databaseConnector.getFieldByName("StandardFieldDisplayName"), databaseConnector.getIntegerField("StandardFieldID"), databaseConnector.getIntegerField("StandardFieldType"));
                fieldMapping.setStringType(databaseConnector.getIntegerField("LongString"));
                n = new Integer(databaseConnector.getIntegerField("StandardID"));
                string = (String)hashMap.get(n);
                if (string == null) {
                    string = databaseConnector.getFieldByName("StandardName");
                    hashMap.put(n, string);
                    arrayList2.add(n);
                    arrayList3.add(new Integer(databaseConnector.getIntegerField("Standard_Type", 0)));
                }
                if ((hashSet = (Set)hashMap2.get(n)) == null) {
                    hashSet = new HashSet<FieldMapping>();
                    hashMap2.put(n, hashSet);
                }
                hashSet.add(fieldMapping);
                databaseConnector.next();
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                n = (Integer)arrayList2.get(i);
                string = (String)hashMap.get(n);
                hashSet = (HashSet<FieldMapping>)hashMap2.get(n);
                arrayList.add(MappingStandard.createMappingStandard(n, (Integer)arrayList3.get(i), string, hashSet));
            }
        }
        catch (Throwable throwable) {
            this.debugOut("Exception in getMappingStandards(): " + InsightUtilities.getStackTrace(throwable));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getCatalogTemplates() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            class ComparableElement
            implements Comparable {
                private int order = 0;
                private BaseTemplateElement data = null;

                public ComparableElement(int n, BaseTemplateElement baseTemplateElement) {
                    this.order = n;
                    this.data = baseTemplateElement;
                }

                public int compareTo(Object object) {
                    if (((ComparableElement)object).order == this.order) {
                        int n = this.data.getName().compareTo(((ComparableElement)object).data.getName());
                        if (n == 0) {
                            return -1;
                        }
                        return n;
                    }
                    return ((ComparableElement)object).order < this.order ? 1 : -1;
                }

                public BaseTemplateElement getData() {
                    return this.data;
                }
            }
            int n;
            Object object;
            Object object2;
            Object object3;
            Serializable serializable;
            HashMap<Integer, Serializable> hashMap = new HashMap<Integer, Serializable>();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", "*");
            sqlQueryGenerator.appendToWhere("IsTemplate = 1");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuerySafe();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            while (databaseConnector.more()) {
                block37: {
                    int n2 = databaseConnector.getIntegerField("StandardID", -1);
                    try {
                        serializable = new CatalogTemplate(n2, databaseConnector.getStringField("StandardName"));
                        if (serializable == null) {
                            throw new Exception();
                        }
                        ((BaseTemplate)serializable).setVersion(databaseConnector.getStringField("Version"));
                        ((BaseTemplate)serializable).setVersionInfo(databaseConnector.getStringField("Version_Info"));
                        ((BaseTemplate)serializable).setDescriptionURL(databaseConnector.getStringField("StandardDescriptionURL"));
                        ((BaseTemplate)serializable).setCreatorID(databaseConnector.getIntegerField("StandardCreatorID", 0));
                        ((BaseTemplate)serializable).setPersonalCollectionTemplate(databaseConnector.getBooleanField("IsPCTemplate"));
                        ((BaseTemplate)serializable).setPublished(databaseConnector.getBooleanField("IsPublishedTemplate"));
                        String string = databaseConnector.getStringField("CreatedTimestamp");
                        if (string != null) {
                            object3 = new SimpleDate(string);
                            ((BaseTemplate)serializable).setCreatedDate(((SimpleDate)object3).getDate());
                        }
                        hashMap.put(new Integer(((BaseTemplate)serializable).getTemplateID()), serializable);
                    }
                    catch (Exception exception) {
                        if (n2 == -1) break block37;
                        hashSet.add(new Integer(n2));
                        this.debugOut("Exception reading database record for template id = " + n2);
                    }
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
            serializable = new HashMap();
            sqlQueryGenerator.addTable("ISTEMPLATEENTITYTYPEMAP", "*");
            sqlQueryGenerator.addTable("ISENTITYRELATIONSHIPS", "EntityTypeID As ParentTypeID");
            sqlQueryGenerator.addTable("ISENTITYTYPES", new String[]{"EntityTypeName", "EntityTypeDisplayName", "RestrictionLevel", "IsVocabulary", "IsDependent", "IsDupeCheckEnabled", "IsRefCheckEnabled", "IsPreferredEntity", "EntityTypeDisplayOrder", "EntityTableID", "EntityIDColumnName"});
            sqlQueryGenerator.addTable("IRFIELDGROUPS", "FieldGroupType");
            sqlQueryGenerator.addJoin("ISTEMPLATEENTITYTYPEMAP", "ISENTITYTYPES", "EntityTypeID", 0);
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "EntityTypeID", "IRFIELDGROUPS", "FieldGroupID", 0);
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "EntityTypeID", "ISENTITYRELATIONSHIPS", "RelEntityTypeID", 1);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                block38: {
                    int n3 = databaseConnector.getIntegerField("TemplateID", -1);
                    object3 = (CatalogTemplate)hashMap.get(new Integer(n3));
                    try {
                        object2 = TemplateEntityType.createTemplateEntityType((CatalogTemplate)object3, databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getStringField("EntityTypeName"), databaseConnector.getStringField("EntityTypeDisplayName"));
                        if (object2 == null) {
                            throw new Exception();
                        }
                        serializable.put(new Integer(((BaseTemplateElement)object2).getID()), object2);
                        ((BaseEntityType)object2).setUnvalidatedAttribute(0, new Boolean(databaseConnector.getBooleanField("IsDependent")));
                        ((BaseEntityType)object2).setDupeCheckEnabled(databaseConnector.getBooleanField("IsDupeCheckEnabled"));
                        ((BaseEntityType)object2).setFieldGroupType(databaseConnector.getIntegerField("FieldGroupType"));
                        ((BaseEntityType)object2).setRefCheckEnabled(databaseConnector.getBooleanField("IsRefCheckEnabled"));
                        ((BaseEntityType)object2).setRestrictionLevel(databaseConnector.getIntegerField("RestrictionLevel"));
                        ((BaseEntityType)object2).setUnvalidatedAttribute(1, new Boolean(databaseConnector.getBooleanField("IsVocabulary")));
                        ((BaseEntityType)object2).setTableID(databaseConnector.getIntegerField("EntityTableID", -1));
                        ((BaseEntityType)object2).setEntityIDColumnName(databaseConnector.getField("EntityIDColumnName"));
                        if (databaseConnector.getBooleanField("IsPreferredEntity")) {
                            ((BaseTemplate)object3).setPrimaryEntityType((BaseEntityType)object2);
                        }
                        int n4 = -1;
                        n4 = databaseConnector.getIntegerField("ParentTypeID", -1);
                        if (-1 != n4) {
                            object = new Integer(n4);
                            TreeSet<ComparableElement> treeSet = (TreeSet<ComparableElement>)hashMap2.get(object);
                            if (treeSet == null) {
                                treeSet = new TreeSet<ComparableElement>();
                                hashMap2.put((Integer)object, treeSet);
                            }
                            n = databaseConnector.getIntegerField("EntityTypeDisplayOrder");
                            ((BaseTemplateElement)object2).setDbDisplayOrder(n);
                            treeSet.add(new ComparableElement(n, (BaseTemplateElement)object2));
                        }
                    }
                    catch (Exception exception) {
                        if (n3 == -1) break block38;
                        hashSet.add(new Integer(n3));
                        this.debugOut("Exception reading type record for template with id = " + n3);
                    }
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYFIELDS", "*");
            sqlQueryGenerator.addTable("IRFIELDS", new String[]{"DisplayName", "FieldName", "FieldType", "DelimiterType", "DisplayOrder", "DataFieldSearchable", "KeywordSearchable", "DisplayedInData", "SearchPick", "LongString", "IsDate", "HierarchyMode", "HierarchyID", "SelectListBehavior"});
            sqlQueryGenerator.addTable("SLSTANDARDFIELDS", new String[]{"StandardID AS TemplateID", "FieldDescriptionURL", "DisplayedInThumbnail", "Sortable"});
            sqlQueryGenerator.addJoin("ISTEMPLATEENTITYTYPEMAP", "ISENTITYTYPES", "EntityTypeID", 0);
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISENTITYFIELDS", "EntityTypeID", 0);
            sqlQueryGenerator.addJoin("ISENTITYFIELDS", "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldID", "SLSTANDARDFIELDS", "StandardFieldID", 0);
            StringBuffer stringBuffer = new StringBuffer();
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                stringBuffer.append(object3.next());
                if (!object3.hasNext()) continue;
                stringBuffer.append(", ");
            }
            sqlQueryGenerator.appendToWhere("SLSTANDARDFIELDS.StandardID IN (" + stringBuffer + ")");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                block39: {
                    int n5 = databaseConnector.getIntegerField("TemplateID", -1);
                    try {
                        object2 = TemplateEntityField.getTemplateEntityField((CatalogTemplate)hashMap.get(new Integer(n5)), TemplateEntityField.SHORT_TEXT, databaseConnector.getIntegerField("FieldID"), databaseConnector.getStringField("FieldName"), databaseConnector.getStringField("DisplayName"));
                        Integer n6 = new Integer(databaseConnector.getIntegerField("EntityTypeID"));
                        object = (Set)hashMap2.get(n6);
                        if (object == null) {
                            object = new TreeSet();
                            hashMap2.put(n6, object);
                        }
                        int n7 = databaseConnector.getIntegerField("DisplayOrder");
                        ((BaseTemplateElement)object2).setDbDisplayOrder(n7);
                        object.add(new ComparableElement(n7, (BaseTemplateElement)object2));
                        ((BaseEntityField)object2).setAllowRepeatingValues(databaseConnector.getBooleanField("RepeatValuesAllowed"));
                        ((BaseEntityField)object2).setDataDisplayType(databaseConnector.getIntegerField("LongString"));
                        ((BaseEntityField)object2).setDataFieldSearchable(databaseConnector.getBooleanField("DataFieldSearchable"));
                        ((BaseEntityField)object2).setDelimiterType(databaseConnector.getIntegerField("DelimiterType"));
                        ((BaseEntityField)object2).setDescriptionUrl(databaseConnector.getStringField("FieldDescriptionURL"));
                        ((BaseEntityField)object2).setDisplayedInData(databaseConnector.getBooleanField("DisplayedInData"));
                        ((BaseEntityField)object2).setDisplayInRelatedEntities(databaseConnector.getBooleanField("DisplayInRelatedEntities"));
                        ((BaseEntityField)object2).setFieldType(databaseConnector.getIntegerField("FieldType"));
                        ((BaseEntityField)object2).setFuzzyDate(databaseConnector.getBooleanField("IsDate"));
                        n = databaseConnector.getIntegerField("HierarchyID", 0);
                        if (n != 0) {
                            ((BaseEntityField)object2).setHierarchy(this.getHierarchyName(n));
                        }
                        ((BaseEntityField)object2).setHierarchyMode(databaseConnector.getIntegerField("HierarchyMode"));
                        ((BaseEntityField)object2).setFieldValueColumnName(databaseConnector.getStringField("FieldValueColumnName"));
                        IntegerRange integerRange = IntegerRange.getIntegerRange(databaseConnector.getStringField("IntegerRange"));
                        if (integerRange != null) {
                            ((BaseEntityField)object2).setIntegerRange(integerRange);
                        }
                        ((BaseEntityField)object2).setKeywordSearchable(databaseConnector.getBooleanField("KeywordSearchable"));
                        ((BaseEntityField)object2).setMinApprovalToAddValue(databaseConnector.getIntegerField("MinApprovalToAddNewValue"));
                        ((BaseEntityField)object2).setPickable(databaseConnector.getBooleanField("SearchPick"));
                        ((BaseEntityField)object2).setRequired(databaseConnector.getBooleanField("IsRequired"));
                        ((BaseEntityField)object2).setRestrictionLevel(databaseConnector.getIntegerField("RestrictionLevel"));
                        ((BaseEntityField)object2).setSelectListBehavior(databaseConnector.getIntegerField("SelectListBehavior"));
                        ((BaseEntityField)object2).setSortOption(databaseConnector.getBooleanField("Sortable"));
                        ((BaseEntityField)object2).setThumbnailOption(databaseConnector.getBooleanField("DisplayedInThumbnail"));
                        ((BaseEntityField)object2).setUseUniqueValues(databaseConnector.getBooleanField("AlwaysValidateNewValues"));
                        ((BaseEntityField)object2).setValueListAllowed(databaseConnector.getBooleanField("IsValueListAllowed"));
                    }
                    catch (Exception exception) {
                        if (n5 == -1) break block39;
                        hashSet.add(new Integer(n5));
                        this.debugOut("Exception reading type record for template with id = " + n5);
                    }
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            Object object4 = hashMap2.keySet().iterator();
            while (object4.hasNext()) {
                object2 = (Integer)object4.next();
                TemplateEntityType templateEntityType = (TemplateEntityType)serializable.get(object2);
                if (templateEntityType == null) continue;
                object = ((Set)hashMap2.get(object2)).iterator();
                while (object.hasNext()) {
                    BaseTemplateElement baseTemplateElement = ((ComparableElement)object.next()).getData();
                    if (baseTemplateElement == null) continue;
                    baseTemplateElement.setParentEntityType(templateEntityType);
                }
            }
            object4 = new HashSet(hashMap.values());
            object2 = object4.iterator();
            while (object2.hasNext()) {
                CatalogTemplate catalogTemplate = (CatalogTemplate)object2.next();
                if (catalogTemplate.getPrimaryEntityType() == null) {
                    object2.remove();
                    continue;
                }
                if (hashSet.contains(new Integer(catalogTemplate.getTemplateID()))) {
                    object2.remove();
                    continue;
                }
                catalogTemplate.calculateDisplayOrders();
            }
            object2 = object4.iterator();
            while (object2.hasNext()) {
                CatalogTemplate catalogTemplate = (CatalogTemplate)object2.next();
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("SLFIELDSTANDARDRELATION", null, new String[]{"MappingStandardFieldID", "StandardFieldID", "MappingStandardName"});
                sqlQueryGenerator.addTable("SLSTANDARDFIELDS", null, new String[]{"StandardFieldName", "StandardFieldDisplayName", "StandardFieldType", "StandardID"});
                sqlQueryGenerator.addJoin("SLFIELDSTANDARDRELATION", new String[]{"MappingStandardFieldID", "MappingStandardName"}, "SLSTANDARDFIELDS", new String[]{"StandardFieldID", "StandardName"}, 0);
                sqlQueryGenerator.appendToWhere("SLFIELDSTANDARDRELATION.StandardID = " + catalogTemplate.getTemplateID());
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    object = catalogTemplate.getEntityFieldByID(databaseConnector.getIntegerField("StandardFieldID"));
                    if (object != null) {
                        FieldMapping fieldMapping = new FieldMapping(databaseConnector.getFieldByName("StandardFieldName"), databaseConnector.getFieldByName("StandardFieldDisplayName"), databaseConnector.getIntegerField("MappingStandardFieldID"), databaseConnector.getIntegerField("StandardFieldType"));
                        fieldMapping.setFieldStandardName(databaseConnector.getFieldByName("MappingStandardName"));
                        object.addFieldMapping(databaseConnector.getIntegerField("StandardID"), fieldMapping);
                    }
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
            object2 = object4.iterator();
            while (object2.hasNext()) {
                BaseEntityField[] baseEntityFieldArray = new BaseEntityField[4];
                object = new BaseEntityField[4];
                CatalogTemplate catalogTemplate = (CatalogTemplate)object2.next();
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("SLSTANDARDSSTARTUP", null, "*");
                sqlQueryGenerator.appendToWhere("StandardID = " + catalogTemplate.getTemplateID());
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n = databaseConnector.getIntegerField("Thumbnail1FieldID", -1);
                    int n8 = databaseConnector.getIntegerField("Thumbnail2FieldID", -1);
                    int n9 = databaseConnector.getIntegerField("Thumbnail3FieldID", -1);
                    int n10 = databaseConnector.getIntegerField("Thumbnail4FieldID", -1);
                    int n11 = databaseConnector.getIntegerField("Sort1FieldID", -1);
                    int n12 = databaseConnector.getIntegerField("Sort2FieldID", -1);
                    int n13 = databaseConnector.getIntegerField("Sort3FieldID", -1);
                    int n14 = databaseConnector.getIntegerField("Sort4FieldID", -1);
                    baseEntityFieldArray[0] = catalogTemplate.getEntityFieldByID(n) == null ? null : catalogTemplate.getEntityFieldByID(n);
                    baseEntityFieldArray[1] = catalogTemplate.getEntityFieldByID(n8) == null ? null : catalogTemplate.getEntityFieldByID(n8);
                    baseEntityFieldArray[2] = catalogTemplate.getEntityFieldByID(n9) == null ? null : catalogTemplate.getEntityFieldByID(n9);
                    baseEntityFieldArray[3] = catalogTemplate.getEntityFieldByID(n10) == null ? null : catalogTemplate.getEntityFieldByID(n10);
                    object[0] = catalogTemplate.getEntityFieldByID(n11) == null ? null : catalogTemplate.getEntityFieldByID(n11);
                    object[1] = catalogTemplate.getEntityFieldByID(n12) == null ? null : catalogTemplate.getEntityFieldByID(n12);
                    object[2] = catalogTemplate.getEntityFieldByID(n13) == null ? null : catalogTemplate.getEntityFieldByID(n13);
                    object[3] = catalogTemplate.getEntityFieldByID(n14) == null ? null : catalogTemplate.getEntityFieldByID(n14);
                    try {
                        catalogTemplate.setThumbnailFields(baseEntityFieldArray);
                        catalogTemplate.setSortFields((BaseEntityField[])object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                databaseConnector.close();
            }
            object2 = object4;
            return object2;
        }
        catch (Throwable throwable) {
            this.debugOut("Exception getting catalog template: " + InsightUtilities.getStackTrace(throwable));
            Set set = null;
            return set;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCatalogTemplate(BaseTemplate baseTemplate) {
        int n = baseTemplate.getTemplateID();
        this.debugOut("deleteCatalogTemplate(" + n + ") entered");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            CollectionKey collectionKey;
            if (baseTemplate.isTemporary()) {
                boolean bl = false;
                return bl;
            }
            List list = null;
            list = this.getDependentCollections(n);
            if (!(list.size() <= 0 || (collectionKey = (CollectionKey)((Object[])list.get(0))[1]).getInstitutionID().equals("") && collectionKey.getCollectionID().equals("") && collectionKey.getVCID().equals(""))) {
                boolean bl = false;
                return bl;
            }
            collectionKey = null;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = "delete from SLFIELDSTANDARDRELATION where STANDARDID = " + n;
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from SLSTANDARDFIELDS where STANDARDID = " + n;
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGenerator();
            sqlQueryGenerator2.addTable("IRFIELDS", "FIELDGROUPID");
            sqlQueryGenerator2.addJoin("IRFIELDS", "ISENTITYFIELDS", "FIELDID", 0);
            sqlQueryGenerator2.addJoin("ISENTITYFIELDS", "ISTEMPLATEENTITYTYPEMAP", "ENTITYTYPEID", 0);
            sqlQueryGenerator2.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TEMPLATEID = " + n);
            string = "delete from IRFIELDGROUPS where FIELDGROUPID in (" + sqlQueryGenerator2.getQuery() + ")";
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            sqlQueryGenerator2 = this.getQueryGenerator();
            sqlQueryGenerator2.addTable("ISENTITYFIELDS", "FIELDID");
            sqlQueryGenerator2.addJoin("ISENTITYFIELDS", "ISTEMPLATEENTITYTYPEMAP", "ENTITYTYPEID", 0);
            sqlQueryGenerator2.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TEMPLATEID = " + n);
            string = "delete from IRFIELDS where FIELDID in (" + sqlQueryGenerator2.getQuery() + ")";
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from ISENTITYFIELDS where ENTITYTYPEID in (select ENTITYTYPEID from ISTEMPLATEENTITYTYPEMAP where TEMPLATEID = " + n + ")";
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from ISENTITYRELATIONSHIPS where ENTITYTYPEID in (select ENTITYTYPEID from ISTEMPLATEENTITYTYPEMAP where TEMPLATEID = " + n + ")";
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from ISENTITYTYPES where ENTITYTYPEID in (select ENTITYTYPEID from ISTEMPLATEENTITYTYPEMAP where TEMPLATEID = " + n + ")";
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from ISTEMPLATEENTITYTYPEMAP where TEMPLATEID = " + n;
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from SLSTANDARDSSTARTUP where STANDARDID = " + n;
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from SLSTANDARDSSTARTUP where STANDARDID in (select standardid from SLSTANDARDSLOOKUP WHERE ParentStandardID = " + n + ")";
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from SLSTANDARDSLOOKUP where STANDARDID = " + n;
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            string = "delete from SLSTANDARDSLOOKUP where PARENTSTANDARDID = " + n;
            this.debugOut("deleteCatalogTemplate: " + string);
            arrayList.add(string);
            databaseConnector.executeBatch(arrayList, true);
            this.debugOut("deleteCatalogTemplate(" + n + ") completed normally");
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            this.debugOut("Exception deleting catalog template: " + InsightUtilities.getStackTrace(throwable));
            boolean bl = false;
            return bl;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCatalogTemplate(BaseTemplate baseTemplate) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        Object var3_3 = null;
        try {
            if (!baseTemplate.isTemporary() || baseTemplate.getPrimaryEntityType() == null) {
                boolean bl = false;
                return bl;
            }
            if (this.getAllStandardNames().contains(baseTemplate.getTemplateName())) {
                boolean bl = false;
                return bl;
            }
            baseTemplate.setTemplateID(this.getNextFieldStandardID());
            if (baseTemplate.isTemporary()) {
                boolean bl = false;
                return bl;
            }
            int n = baseTemplate.getTemplateID();
            if (!this.createEntityTypeAndFieldIDs(databaseConnector, baseTemplate)) {
                baseTemplate.setTemplateID(-1);
                boolean bl = false;
                return bl;
            }
            baseTemplate.calculateDisplayOrders();
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Standard_Type", 2, stringBuffer2, 1);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, baseTemplate.getTemplateName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ParentStandardID", 2, stringBuffer2, n);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Version", 1, stringBuffer2, baseTemplate.getVersion());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Version_Info", 1, stringBuffer2, baseTemplate.getVersionInfo());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardDescriptionURL", 1, stringBuffer2, baseTemplate.getDescriptionURL());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsTemplate", 2, stringBuffer2, true);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsPCTemplate", 2, stringBuffer2, baseTemplate.isPersonalCollectionTemplate());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsPublishedTemplate", 2, stringBuffer2, baseTemplate.isPublished());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, new SimpleDate().get());
            String string = "INSERT INTO SLSTANDARDSLOOKUP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
            arrayList.add(string);
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreateThumbCache", 2, stringBuffer2, 1);
            BaseEntityField[] baseEntityFieldArray = baseTemplate.getThumbnailFields();
            BaseEntityField[] baseEntityFieldArray2 = baseTemplate.getSortFields();
            for (int i = 0; i < 4; ++i) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Thumbnail" + (i + 1) + "FieldID", 2, stringBuffer2, baseEntityFieldArray[i] == null ? -1 : baseEntityFieldArray[i].getID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Sort" + (i + 1) + "FieldID", 2, stringBuffer2, baseEntityFieldArray2[i] == null ? -1 : baseEntityFieldArray2[i].getID());
            }
            string = "INSERT INTO SLSTANDARDSSTARTUP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
            arrayList.add(string);
            Iterator iterator = baseTemplate.getLinkedTypes().iterator();
            while (iterator.hasNext()) {
                BaseTemplateElement baseTemplateElement;
                Iterator iterator2;
                BaseEntityType baseEntityType = (BaseEntityType)iterator.next();
                int n2 = baseEntityType.getTableID();
                if (n2 == -1) {
                    n2 = this.getNextTableID();
                }
                int n3 = baseTemplate.getPrimaryEntityType().getID();
                if (!baseTemplate.isPersonalCollectionTemplate() || baseEntityType.isPrimaryType()) {
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TemplateID", 2, stringBuffer2, n);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, baseEntityType.getID());
                    string = "INSERT INTO ISTEMPLATEENTITYTYPEMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                    arrayList.add(string);
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, baseEntityType.getID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeName", 1, stringBuffer2, baseEntityType.getName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeDisplayName", 1, stringBuffer2, baseEntityType.getDisplayName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RestrictionLevel", 2, stringBuffer2, baseEntityType.getRestrictionLevel());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsVocabulary", 2, stringBuffer2, baseEntityType.isVocabulary());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDependent", 2, stringBuffer2, baseEntityType.isDependent());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDupeCheckEnabled", 2, stringBuffer2, baseEntityType.isDupeCheckEnabled());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsRefCheckEnabled", 2, stringBuffer2, baseEntityType.isRefCheckEnabled());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsPreferredEntity", 2, stringBuffer2, baseEntityType.isPrimaryType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeDisplayOrder", 2, stringBuffer2, baseEntityType.getDisplayOrder());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTableID", 2, stringBuffer2, n2);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityIDColumnName", 1, stringBuffer2, baseEntityType.getEntityIDColumnName());
                    string = "INSERT INTO ISENTITYTYPES (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                    arrayList.add(string);
                    if (!baseTemplate.isPersonalCollectionTemplate()) {
                        iterator2 = baseEntityType.getRelatedEntityTypes().iterator();
                        while (iterator2.hasNext()) {
                            baseTemplateElement = (BaseEntityType)iterator2.next();
                            stringBuffer = new StringBuffer();
                            stringBuffer2 = new StringBuffer();
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, baseEntityType.getID());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityTypeID", 2, stringBuffer2, baseTemplateElement.getID());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JoinID", 2, stringBuffer2, 0);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SourceMapTableID", 2, stringBuffer2, 0);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelatedEntitiesAllowed", 2, stringBuffer2, 0);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PublishRelatedMedia", 2, stringBuffer2, 0);
                            string = "INSERT INTO ISENTITYRELATIONSHIPS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                            arrayList.add(string);
                        }
                    }
                }
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldGroupID", 2, stringBuffer2, baseEntityType.getID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayName", 1, stringBuffer2, baseEntityType.getDisplayName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldGroupType", 2, stringBuffer2, baseEntityType.getFieldGroupType());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, baseEntityType.getDisplayOrder());
                string = "INSERT INTO IRFIELDGROUPS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                arrayList.add(string);
                iterator2 = baseEntityType.getEntityFields().iterator();
                while (iterator2.hasNext()) {
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    baseTemplateElement = (BaseEntityField)iterator2.next();
                    IntegerRange integerRange = ((BaseEntityField)baseTemplateElement).getIntegerRange();
                    int n4 = baseTemplate.isPersonalCollectionTemplate() ? n3 : baseEntityType.getID();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, n4);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, baseTemplateElement.getID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JoinID", 2, stringBuffer2, 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RestrictionLevel", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getRestrictionLevel());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsRequired", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isRequired());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IntegerRange", 1, stringBuffer2, integerRange == null ? "" : integerRange.toString());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsValueListAllowed", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isValueListAllowed());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MinApprovalToAddNewValue", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getMinApprovalToAddValue());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RepeatValuesAllowed", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isAllowRepeatingValues());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayInRelatedEntities", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isDisplayInRelatedEntities());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "AlwaysValidateNewValues", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isUseUniqueValues());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyIDColumnName", 1, stringBuffer2, "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyNodeIDColumnName", 1, stringBuffer2, "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldTableID", 2, stringBuffer2, n2);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldValueColumnName", 1, stringBuffer2, ((BaseEntityField)baseTemplateElement).getFieldValueColumnName());
                    string = "INSERT INTO ISENTITYFIELDS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                    arrayList.add(string);
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, baseTemplateElement.getID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldGroupID", 2, stringBuffer2, baseEntityType.getID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayName", 1, stringBuffer2, baseTemplateElement.getDisplayName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldName", 1, stringBuffer2, baseTemplateElement.getName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldType", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getFieldType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DelimiterType", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getDelimiterType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, baseTemplateElement.getDisplayOrder());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DataFieldSearchable", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isDataFieldSearchable());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "KeywordSearchable", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isKeywordSearchable());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayedInData", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isDisplayedInData());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SearchPick", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isPickable());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongString", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getDataDisplayType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDate", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isFuzzyDate());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyMode", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getHierarchyMode());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyID", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getHierarchyMode() == 0 ? 0 : this.getHierarchyID(((BaseEntityField)baseTemplateElement).getHierarchy()));
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SelectListBehavior", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getSelectListBehavior());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TableID", 2, stringBuffer2, n2);
                    string = "INSERT INTO IRFIELDS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                    arrayList.add(string);
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, baseTemplate.getTemplateName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldID", 2, stringBuffer2, baseTemplateElement.getID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldName", 1, stringBuffer2, baseTemplateElement.getName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldDisplayName", 1, stringBuffer2, baseTemplateElement.getDisplayName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldType", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getFieldType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldDisplayOrder", 2, stringBuffer2, baseTemplateElement.getDisplayOrder());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardPickedField", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isPickable());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongString", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getDataDisplayType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldDescriptionURL", 1, stringBuffer2, ((BaseEntityField)baseTemplateElement).getDescriptionUrl());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DataFieldSearchable", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isDataFieldSearchable());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayedInThumbnail", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isThumbnailOption());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Sortable", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isSortOption());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDate", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).isFuzzyDate());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SelectListBehavior", 2, stringBuffer2, ((BaseEntityField)baseTemplateElement).getSelectListBehavior());
                    string = "INSERT INTO SLSTANDARDFIELDS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                    arrayList.add(string);
                    int[] nArray = ((BaseEntityField)baseTemplateElement).getStandardsWithMappings();
                    for (int i = 0; i < nArray.length; ++i) {
                        List list = ((BaseEntityField)baseTemplateElement).getFieldMappings(nArray[i]);
                        Iterator iterator3 = list.iterator();
                        while (iterator3.hasNext()) {
                            FieldMapping fieldMapping = (FieldMapping)iterator3.next();
                            stringBuffer = new StringBuffer();
                            stringBuffer2 = new StringBuffer();
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, n);
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, baseTemplate.getTemplateName());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldID", 2, stringBuffer2, baseTemplateElement.getID());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingStandardName", 1, stringBuffer2, fieldMapping.getFieldStandardName());
                            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingStandardFieldID", 2, stringBuffer2, fieldMapping.getFieldID());
                            string = "INSERT INTO SLFIELDSTANDARDRELATION (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                            arrayList.add(string);
                        }
                    }
                }
            }
            databaseConnector.executeBatch(arrayList, true);
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            this.debugOut("Exception saving catalog template: " + InsightUtilities.getStackTrace(throwable));
            boolean bl = false;
            return bl;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllStandardNames() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            HashSet<String> hashSet = new HashSet<String>();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "StandardName");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                hashSet.add(databaseConnector.getFieldByName("StandardName"));
                databaseConnector.next();
            }
            HashSet<String> hashSet2 = hashSet;
            return hashSet2;
        }
        catch (Throwable throwable) {
            this.debugOut("Exception getting standard names: " + InsightUtilities.getStackTrace(throwable));
            Set set = null;
            return set;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public List getDependentCollections(int n) {
        Vector<Object[]> vector = new Vector<Object[]>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, new String[]{"CollectionName", "CollectionID", "VCID", "UniqueCollectionID", "InstitutionID"});
            sqlQueryGenerator.appendToWhere("IRCOLLECTIONCONFIGURATIONINFO.NATIVESTANDARDID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("getDependentCollections query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            String string = null;
            String string2 = null;
            while (databaseConnector.more()) {
                string = databaseConnector.getFieldByName("CollectionName");
                string2 = databaseConnector.getFieldByName("InstitutionID");
                String string3 = databaseConnector.getFieldByName("CollectionID");
                String string4 = databaseConnector.getFieldByName("VCID");
                CollectionKeyWrapper collectionKeyWrapper = new CollectionKeyWrapper(string2, string3, string4);
                Integer n2 = new Integer(databaseConnector.getIntegerField("UniqueCollectionID"));
                vector.add(new Object[]{string, collectionKeyWrapper, n2});
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getDependentCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    private boolean setTemplateElementID(DatabaseConnector databaseConnector, BaseTemplateElement baseTemplateElement) {
        if (baseTemplateElement.getID() != -1) {
            return false;
        }
        baseTemplateElement.setID(this.getNextFieldID(databaseConnector));
        return baseTemplateElement.getID() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCatalogTemplate(BaseTemplate baseTemplate, BaseTemplate baseTemplate2) {
        if (baseTemplate.getPrimaryEntityType() != null && !baseTemplate.isTemporary()) {
            Serializable serializable;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                int n = baseTemplate.getTemplateID();
                serializable = new ArrayList();
                BaseTemplate baseTemplate3 = this.getCatalogTemplate(n);
                List list = baseTemplate2.getChangedValues(baseTemplate3, false);
                if (list.size() != 0) {
                    boolean bl = false;
                    return bl;
                }
                list = baseTemplate.getChangedValues(baseTemplate3, true);
                Collections.sort(list, new Comparator(){

                    public int compare(Object object, Object object2) {
                        return ((ITemplateEdit)object).getChangeType() - ((ITemplateEdit)object2).getChangeType();
                    }
                });
                Iterator iterator = list.iterator();
                block19: while (iterator.hasNext()) {
                    ITemplateEdit iTemplateEdit = (ITemplateEdit)iterator.next();
                    switch (iTemplateEdit.getChangeType()) {
                        case 8: {
                            ((ArrayList)serializable).addAll(this.getEntityChangeStatements(baseTemplate, (IEntityTypeEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 7: {
                            ((ArrayList)serializable).addAll(this.getFieldChangeStatements(baseTemplate, (IEntityFieldEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 9: {
                            ((ArrayList)serializable).addAll(this.getTemplateChangeStatements((ICatalogEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 3: {
                            ((ArrayList)serializable).addAll(this.getEntityAddStatements(baseTemplate, (IEntityTypeEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 2: {
                            ((ArrayList)serializable).addAll(this.getEntityDeleteStatements(baseTemplate, (IEntityTypeEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 6: {
                            ((ArrayList)serializable).addAll(this.getEntityMoveStatements(baseTemplate, (IEntityTypeEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 4: {
                            ((ArrayList)serializable).addAll(this.getFieldAddStatements(baseTemplate, (IEntityFieldEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 1: {
                            ((ArrayList)serializable).addAll(this.getFieldDeleteStatements(baseTemplate, (IEntityFieldEdit)iTemplateEdit));
                            continue block19;
                        }
                        case 5: {
                            ((ArrayList)serializable).addAll(this.getFieldMoveStatements(baseTemplate, (IEntityFieldEdit)iTemplateEdit));
                            continue block19;
                        }
                    }
                    throw new Exception("unsupported change type: " + iTemplateEdit.getChangeType());
                }
                if (((ArrayList)serializable).size() > 0) {
                    this.executeBatch(databaseConnector, (List)((Object)serializable));
                    this.debugOut("updateCatalogTemplate(" + n + ") completed normally");
                }
                this.debugOut("updateCatalogTemplate(" + n + ") completed normally, no updates generated");
                boolean bl = true;
                return bl;
            }
            catch (JdbcConnectorError jdbcConnectorError) {
                serializable = jdbcConnectorError.getCause();
                System.out.println("JDBC Exception when updating catalog template: " + ((Throwable)serializable).getMessage());
                jdbcConnectorError.printStackTrace();
            }
            catch (Throwable throwable) {
                System.out.println("Exception updating catalog template: " + InsightUtilities.getStackTrace(throwable));
            }
            finally {
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
            }
        }
        return false;
    }

    protected int[] executeBatch(DatabaseConnector databaseConnector, List list) throws Throwable {
        return databaseConnector.executeBatch(list, true);
    }

    protected List getEntityChangeStatements(BaseTemplate baseTemplate, IEntityTypeEdit iEntityTypeEdit) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        IEntityType iEntityType = iEntityTypeEdit.getTargetEntityType();
        String string = "";
        String string2 = "";
        Iterator iterator = iEntityTypeEdit.getPropertyChanges().iterator();
        while (iterator.hasNext()) {
            ITemplateEdit.ITemplatePropertyChange iTemplatePropertyChange = (ITemplateEdit.ITemplatePropertyChange)iterator.next();
            switch (iTemplatePropertyChange.getPropertyID()) {
                case 2: {
                    stringBuffer2.append(string + "EntityTypeName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 1: {
                    stringBuffer2.append(string + "EntityTypeDisplayName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    stringBuffer.append(string2 + "DisplayName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 0: {
                    stringBuffer2.append(string + "EntityTypeDisplayOrder = " + iTemplatePropertyChange.getIntValue());
                    stringBuffer.append(string2 + "DisplayOrder = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 201: {
                    stringBuffer.append(string2 + "FieldGroupType = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 204: {
                    stringBuffer2.append(string + "IsDependent = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 205: {
                    stringBuffer2.append(string + "IsDupCheckEnabled = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 6: {
                    break;
                }
                case 206: {
                    stringBuffer2.append(string + "IsRefCheckEnabled = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 203: {
                    stringBuffer2.append(string + "IsVocabulary = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 202: {
                    stringBuffer2.append(string + "RestrictionLevel = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 208: {
                    stringBuffer2.append(string + "EntityIDColumnName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 207: {
                    stringBuffer2.append(string + "EntityTableID = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                default: {
                    this.debugOut("Unknown entity edit encountered: " + iTemplatePropertyChange.getPropertyID());
                }
            }
            if (string.equals("") && stringBuffer2.length() > 0) {
                string = ", ";
            }
            if (!string2.equals("") || stringBuffer.length() <= 0) continue;
            string2 = ", ";
        }
        if (stringBuffer2.length() > 0) {
            arrayList.add("UPDATE ISENTITYTYPES SET " + stringBuffer2 + " WHERE EntityTypeID = " + iEntityType.getID());
        }
        if (stringBuffer.length() > 0) {
            arrayList.add("UPDATE IRFIELDGROUPS SET " + stringBuffer + " WHERE FieldGroupID = " + iEntityType.getID());
        }
        return arrayList;
    }

    protected List getEntityDeleteStatements(BaseTemplate baseTemplate, IEntityTypeEdit iEntityTypeEdit) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = iEntityTypeEdit.getTargetEntityType().getID();
        arrayList.add("DELETE FROM IRENTITYMEDIAMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM ISCOLLECTIONENTITYMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM ISTEMPLATEENTITYTYPEMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM IRFIELDS WHERE FieldGroupID = " + n);
        arrayList.add("DELETE FROM IRFIELDGROUPS WHERE FieldGroupID = " + n);
        arrayList.add("DELETE FROM ISENTITYTYPES WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM ISENTITYRELATIONSHIPS WHERE RelEntityTypeID = " + n);
        arrayList.add("DELETE FROM ISENTITYFIELDS WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM IRENTITYLOCKS WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM IRENTITYCHANGES WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM DTENTITYTOENTITYMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM DTTERMTOENTITYMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM DTVALUETOENTITYMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM ITENTITYTOENTITYMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM ITTERMTOENTITYMAP WHERE EntityTypeID = " + n);
        arrayList.add("DELETE FROM ITVALUETOENTITYMAP WHERE EntityTypeID = " + n);
        return arrayList;
    }

    protected List getEntityAddStatements(BaseTemplate baseTemplate, IEntityTypeEdit iEntityTypeEdit) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TemplateEntityType templateEntityType = (TemplateEntityType)iEntityTypeEdit.getTargetEntityType();
        if (this.setTemplateElementID(this.getDatabaseConnector(), templateEntityType)) {
            int n = templateEntityType.getTableID();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            if (n == -1) {
                n = this.getNextTableID();
            }
            if (!baseTemplate.isPersonalCollectionTemplate()) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TemplateID", 2, stringBuffer2, baseTemplate.getTemplateID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, templateEntityType.getID());
                arrayList.add("INSERT INTO ISTEMPLATEENTITYTYPEMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, templateEntityType.getID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeName", 1, stringBuffer2, templateEntityType.getName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeDisplayName", 1, stringBuffer2, templateEntityType.getDisplayName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RestrictionLevel", 2, stringBuffer2, templateEntityType.getRestrictionLevel());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsVocabulary", 2, stringBuffer2, templateEntityType.isVocabulary());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDependent", 2, stringBuffer2, templateEntityType.isDependent());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDupeCheckEnabled", 2, stringBuffer2, templateEntityType.isDupeCheckEnabled());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsRefCheckEnabled", 2, stringBuffer2, templateEntityType.isRefCheckEnabled());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsPreferredEntity", 2, stringBuffer2, templateEntityType.isPrimaryType());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeDisplayOrder", 2, stringBuffer2, templateEntityType.getDisplayOrder());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTableID", 2, stringBuffer2, n);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityIDColumnName", 1, stringBuffer2, templateEntityType.getEntityIDColumnName());
                arrayList.add("INSERT INTO ISENTITYTYPES (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
                TemplateEntityType templateEntityType2 = (TemplateEntityType)templateEntityType.getParentEntityType();
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, templateEntityType2.getID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityTypeID", 2, stringBuffer2, templateEntityType.getID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JoinID", 2, stringBuffer2, 0);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SourceMapTableID", 2, stringBuffer2, 0);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelatedEntitiesAllowed", 2, stringBuffer2, 0);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PublishRelatedMedia", 2, stringBuffer2, 0);
                arrayList.add("INSERT INTO ISENTITYRELATIONSHIPS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            }
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldGroupID", 2, stringBuffer2, templateEntityType.getID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayName", 1, stringBuffer2, templateEntityType.getDisplayName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldGroupType", 2, stringBuffer2, templateEntityType.getFieldGroupType());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, templateEntityType.getDisplayOrder());
            arrayList.add("INSERT INTO IRFIELDGROUPS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
        }
        return arrayList;
    }

    protected List getEntityMoveStatements(BaseTemplate baseTemplate, IEntityTypeEdit iEntityTypeEdit) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    protected List getTemplateChangeStatements(ICatalogEdit iCatalogEdit) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        ITemplate iTemplate = iCatalogEdit.getTargetTemplate();
        int n = iTemplate.getTemplateID();
        String string = "";
        Iterator iterator = iCatalogEdit.getPropertyChanges().iterator();
        while (iterator.hasNext()) {
            ITemplateEdit.ITemplatePropertyChange iTemplatePropertyChange = (ITemplateEdit.ITemplatePropertyChange)iterator.next();
            switch (iTemplatePropertyChange.getPropertyID()) {
                case 1: {
                    stringBuffer.append(string + "StandardName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    arrayList.add("UPDATE SLFIELDSTANDARDRELATION SET StandardName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()) + " WHERE StandardID = " + iTemplate.getTemplateID());
                    arrayList.add("UPDATE SLSTANDARDFIELDS SET StandardName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()) + " WHERE StandardID = " + iTemplate.getTemplateID());
                    break;
                }
                case 8: {
                    stringBuffer.append(string + "StandardDescriptionURL = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 6: {
                    stringBuffer.append(string + "IsPCTemplate = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 5: {
                    stringBuffer.append(string + "IsPublishedTemplate = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 4: {
                    stringBuffer.append(string + "Version_Info = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 3: {
                    stringBuffer.append(string + "Version = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 7: {
                    stringBuffer.append(string + "StandardCreatorID = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                }
            }
            string = ", ";
        }
        arrayList.add("UPDATE SLSTANDARDSLOOKUP SET " + stringBuffer + " WHERE StandardID = " + iTemplate.getTemplateID());
        return arrayList;
    }

    protected List getFieldChangeStatements(BaseTemplate baseTemplate, IEntityFieldEdit iEntityFieldEdit) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IEntityField iEntityField = iEntityFieldEdit.getTargetField();
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = "";
        StringBuffer stringBuffer3 = new StringBuffer();
        Iterator iterator = iEntityFieldEdit.getPropertyChanges().iterator();
        while (iterator.hasNext()) {
            ITemplateEdit.ITemplatePropertyChange iTemplatePropertyChange = (ITemplateEdit.ITemplatePropertyChange)iterator.next();
            switch (iTemplatePropertyChange.getPropertyID()) {
                case 2: {
                    String string4 = this.prepStringForQuery(iTemplatePropertyChange.getStringValue());
                    stringBuffer.append(string + "FieldName = " + string4);
                    stringBuffer2.append(string2 + "StandardFieldName = " + string4);
                    stringBuffer3.append(string3 + "FieldValueColumnName = " + string4);
                    break;
                }
                case 1: {
                    String string4 = this.prepStringForQuery(iTemplatePropertyChange.getStringValue());
                    stringBuffer.append(string + "DisplayName = " + string4);
                    stringBuffer2.append(string2 + "StandardFieldDisplayName = " + string4);
                    break;
                }
                case 0: {
                    stringBuffer.append(string + "DisplayOrder = " + iTemplatePropertyChange.getIntValue());
                    stringBuffer2.append(string2 + "StandardFieldDisplayOrder = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 121: {
                    stringBuffer3.append(string3 + "FieldValueColumnName = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 106: {
                    stringBuffer.append(string + "LongString = " + iTemplatePropertyChange.getIntValue());
                    stringBuffer2.append(string2 + "LongString = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 110: {
                    stringBuffer.append(string + "DelimiterType = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 8: {
                    stringBuffer2.append(string2 + "FieldDescriptionURL = " + this.prepStringForQuery(iTemplatePropertyChange.getStringValue()));
                    break;
                }
                case 108: {
                    stringBuffer.append(string + "DisplayedInData = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 116: {
                    stringBuffer3.append(string3 + "DisplayInRelatedEntities = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 104: {
                    stringBuffer3.append(string3 + "AlwaysValidateNewValues = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 105: {
                    stringBuffer.append(string + "FieldType = " + iTemplatePropertyChange.getIntValue());
                    stringBuffer2.append(string2 + "StandardFieldType = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 118: {
                    stringBuffer.append(string + "HierarchyID = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 119: {
                    stringBuffer.append(string + "HierarchyMode = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 102: {
                    stringBuffer3.append(string3 + "IntegerRange = " + this.prepStringForQuery(iTemplatePropertyChange.getIntegerRange().toString()));
                    break;
                }
                case 122: {
                    stringBuffer.append(string + "DataFieldSearchable = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    stringBuffer2.append(string2 + "DataFieldSearchable = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 123: {
                    stringBuffer.append(string + "IsDate = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    stringBuffer2.append(string2 + "IsDate = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 107: {
                    stringBuffer.append(string + "KeywordSearchable = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 101: {
                    stringBuffer3.append(string3 + "IsRequired = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 112: {
                    stringBuffer2.append(string2 + "Sortable = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 111: {
                    stringBuffer2.append(string2 + "DisplayedInThumbnail = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 124: {
                    arrayList.addAll(this.generateThumbFieldUpdate(baseTemplate, iEntityField, iTemplatePropertyChange.getBooleanValue()));
                    break;
                }
                case 125: {
                    arrayList.addAll(this.generateSortFieldUpdate(baseTemplate, iEntityField, iTemplatePropertyChange.getBooleanValue()));
                    break;
                }
                case 126: {
                    arrayList.addAll(this.generateFieldMapping(baseTemplate, iEntityField, true));
                    break;
                }
                case 109: {
                    stringBuffer.append(string + "SelectListBehavior = " + iTemplatePropertyChange.getIntValue());
                    stringBuffer2.append(string2 + "SelectListBehavior = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 115: {
                    stringBuffer3.append(string3 + "MinApprovalToAddNewValue = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 117: {
                    stringBuffer.append(string + "SearchPick = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    stringBuffer2.append(string2 + "StandardPickedField = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 103: {
                    stringBuffer3.append(string3 + "RepeatValuesAllowed = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                case 114: {
                    stringBuffer3.append(string3 + "RestrictionLevel = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 120: {
                    stringBuffer.append(string + "TableID = " + iTemplatePropertyChange.getIntValue());
                    stringBuffer3.append(string3 + "FieldTableID = " + iTemplatePropertyChange.getIntValue());
                    break;
                }
                case 113: {
                    stringBuffer3.append(string3 + "IsValueListAllowed = " + iTemplatePropertyChange.getBooleanAsIntValue());
                    break;
                }
                default: {
                    this.debugOut("Unknown field edit encountered: " + iTemplatePropertyChange.getPropertyID());
                }
            }
            if (string2.equals("") && stringBuffer2.length() > 0) {
                string2 = ", ";
            }
            if (string3.equals("") && stringBuffer3.length() > 0) {
                string3 = ", ";
            }
            if (!string.equals("") || stringBuffer.length() <= 0) continue;
            string = ", ";
        }
        if (stringBuffer2.length() != 0) {
            arrayList.add("UPDATE SLSTANDARDFIELDS SET " + stringBuffer2 + " WHERE StandardFieldID = " + iEntityField.getID());
        }
        if (stringBuffer3.length() != 0) {
            arrayList.add("UPDATE ISENTITYFIELDS SET " + stringBuffer3 + " WHERE FieldID = " + iEntityField.getID());
        }
        if (stringBuffer.length() != 0) {
            arrayList.add("UPDATE IRFIELDS SET " + stringBuffer + " WHERE FieldID = " + iEntityField.getID());
        }
        return arrayList;
    }

    protected List generateSortFieldUpdate(BaseTemplate baseTemplate, IEntityField iEntityField, boolean bl) {
        BaseEntityField[] baseEntityFieldArray = baseTemplate.getSortFields();
        return this.generateFieldThumbSortUpdate(baseEntityFieldArray, baseTemplate, "Sort", iEntityField, bl);
    }

    protected List generateThumbFieldUpdate(BaseTemplate baseTemplate, IEntityField iEntityField, boolean bl) {
        BaseEntityField[] baseEntityFieldArray = baseTemplate.getThumbnailFields();
        return this.generateFieldThumbSortUpdate(baseEntityFieldArray, baseTemplate, "Thumbnail", iEntityField, bl);
    }

    protected List generateFieldThumbSortUpdate(BaseEntityField[] baseEntityFieldArray, BaseTemplate baseTemplate, String string, IEntityField iEntityField, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            for (int i = 0; i < baseEntityFieldArray.length; ++i) {
                if (baseEntityFieldArray[i] == null || baseEntityFieldArray[i].getID() != iEntityField.getID()) continue;
                arrayList.add("UPDATE SLSTANDARDSSTARTUP SET " + string + (i + 1) + "FieldID = " + iEntityField.getID() + " WHERE StandardID = " + baseTemplate.getTemplateID());
                break;
            }
        } else {
            for (int i = 0; i < baseEntityFieldArray.length; ++i) {
                arrayList.add("UPDATE SLSTANDARDSSTARTUP SET " + string + (i + 1) + "FieldID = -1" + " WHERE " + string + (i + 1) + "FieldID = " + iEntityField.getID() + " and StandardID = " + baseTemplate.getTemplateID());
            }
        }
        return arrayList;
    }

    protected List generateFieldMapping(BaseTemplate baseTemplate, IEntityField iEntityField, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("DELETE FROM SLFIELDSTANDARDRELATION WHERE StandardID = " + baseTemplate.getTemplateID() + " AND StandardFieldID = " + iEntityField.getID());
        }
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
        int[] nArray = iEntityField.getStandardsWithMappings();
        for (int i = 0; i < nArray.length; ++i) {
            List list = iEntityField.getFieldMappings(nArray[i]);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FieldMapping fieldMapping = (FieldMapping)iterator.next();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, baseTemplate.getTemplateID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, baseTemplate.getTemplateName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldID", 2, stringBuffer2, iEntityField.getID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingStandardName", 1, stringBuffer2, fieldMapping.getFieldStandardName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingStandardFieldID", 2, stringBuffer2, fieldMapping.getFieldID());
                arrayList.add("INSERT INTO SLFIELDSTANDARDRELATION (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            }
        }
        return arrayList;
    }

    protected List getFieldDeleteStatements(BaseTemplate baseTemplate, IEntityFieldEdit iEntityFieldEdit) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BaseEntityField baseEntityField = (BaseEntityField)iEntityFieldEdit.getTargetField();
        int n = baseEntityField.getID();
        arrayList.addAll(this.generateThumbFieldUpdate(baseTemplate, baseEntityField, false));
        arrayList.addAll(this.generateSortFieldUpdate(baseTemplate, baseEntityField, false));
        arrayList.add("DELETE FROM IRLINKFIELDS WHERE FieldID = " + n);
        arrayList.add("DELETE FROM IRINITIALSEARCHCRITERIA WHERE FieldID = " + n);
        arrayList.add("DELETE FROM IRENTITYCHANGES WHERE FieldID = " + n);
        arrayList.add("DELETE FROM ISENTITYFIELDS WHERE FieldID = " + n);
        arrayList.add("DELETE FROM IRFIELDS WHERE FieldID = " + n);
        arrayList.add("DELETE FROM SLFIELDSTANDARDRELATION WHERE StandardFieldID = " + n + " AND StandardID = " + baseTemplate.getTemplateID());
        arrayList.add("DELETE FROM SLSTANDARDFIELDS WHERE StandardFieldID = " + n + " AND StandardID = " + baseTemplate.getTemplateID());
        return arrayList;
    }

    protected List getFieldAddStatements(BaseTemplate baseTemplate, IEntityFieldEdit iEntityFieldEdit) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BaseEntityField baseEntityField = (BaseEntityField)iEntityFieldEdit.getTargetField();
        if (this.setTemplateElementID(this.getDatabaseConnector(), baseEntityField)) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            BaseEntityField baseEntityField2 = (BaseEntityField)iEntityFieldEdit.getTargetField();
            BaseEntityType baseEntityType = (BaseEntityType)baseEntityField2.getParentEntityType();
            IntegerRange integerRange = baseEntityField2.getIntegerRange();
            int n = baseTemplate.getPrimaryEntityType().getID();
            int n2 = baseTemplate.isPersonalCollectionTemplate() ? n : baseEntityType.getID();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, n2);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, baseEntityField2.getID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JoinID", 2, stringBuffer2, 0);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RestrictionLevel", 2, stringBuffer2, baseEntityField2.getRestrictionLevel());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsRequired", 2, stringBuffer2, baseEntityField2.isRequired());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IntegerRange", 1, stringBuffer2, integerRange == null ? "" : integerRange.toString());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsValueListAllowed", 2, stringBuffer2, baseEntityField2.isValueListAllowed());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MinApprovalToAddNewValue", 2, stringBuffer2, baseEntityField2.getMinApprovalToAddValue());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RepeatValuesAllowed", 2, stringBuffer2, baseEntityField2.isAllowRepeatingValues());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayInRelatedEntities", 2, stringBuffer2, baseEntityField2.isDisplayInRelatedEntities());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "AlwaysValidateNewValues", 2, stringBuffer2, baseEntityField2.isUseUniqueValues());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyIDColumnName", 1, stringBuffer2, "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyNodeIDColumnName", 1, stringBuffer2, "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldTableID", 2, stringBuffer2, baseEntityType.getTableID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldValueColumnName", 1, stringBuffer2, baseEntityField2.getName());
            arrayList.add("INSERT INTO ISENTITYFIELDS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, baseEntityField2.getID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldGroupID", 2, stringBuffer2, baseEntityType.getID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayName", 1, stringBuffer2, baseEntityField2.getDisplayName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldName", 1, stringBuffer2, baseEntityField2.getName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldType", 2, stringBuffer2, baseEntityField2.getFieldType());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DelimiterType", 2, stringBuffer2, baseEntityField2.getDelimiterType());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, baseEntityField2.getDisplayOrder());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DataFieldSearchable", 2, stringBuffer2, baseEntityField2.isDataFieldSearchable());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "KeywordSearchable", 2, stringBuffer2, baseEntityField2.isKeywordSearchable());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayedInData", 2, stringBuffer2, baseEntityField2.isDisplayedInData());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SearchPick", 2, stringBuffer2, baseEntityField2.isPickable());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongString", 2, stringBuffer2, baseEntityField2.getDataDisplayType());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDate", 2, stringBuffer2, baseEntityField2.isFuzzyDate());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyMode", 2, stringBuffer2, baseEntityField2.getHierarchyMode());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyID", 2, stringBuffer2, baseEntityField2.getHierarchyMode() == 0 ? 0 : this.getHierarchyID(baseEntityField2.getHierarchy()));
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SelectListBehavior", 2, stringBuffer2, baseEntityField2.getSelectListBehavior());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TableID", 2, stringBuffer2, baseEntityType.getTableID());
            arrayList.add("INSERT INTO IRFIELDS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, baseTemplate.getTemplateID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, baseTemplate.getTemplateName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldID", 2, stringBuffer2, baseEntityField2.getID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldName", 1, stringBuffer2, baseEntityField2.getName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldDisplayName", 1, stringBuffer2, baseEntityField2.getDisplayName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldType", 2, stringBuffer2, baseEntityField2.getFieldType());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldDisplayOrder", 2, stringBuffer2, baseEntityField2.getDisplayOrder());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardPickedField", 2, stringBuffer2, baseEntityField2.isPickable());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongString", 2, stringBuffer2, baseEntityField2.getDataDisplayType());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldDescriptionURL", 1, stringBuffer2, baseEntityField2.getDescriptionUrl());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DataFieldSearchable", 2, stringBuffer2, baseEntityField2.isDataFieldSearchable());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayedInThumbnail", 2, stringBuffer2, baseEntityField2.isThumbnailOption());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Sortable", 2, stringBuffer2, baseEntityField2.isSortOption());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDate", 2, stringBuffer2, baseEntityField2.isFuzzyDate());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SelectListBehavior", 2, stringBuffer2, baseEntityField2.getSelectListBehavior());
            arrayList.add("INSERT INTO SLSTANDARDFIELDS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            arrayList.addAll(this.generateFieldMapping(baseTemplate, baseEntityField2, false));
            this.checkForThumbSortUpdate(baseTemplate, baseEntityField2, arrayList);
        }
        return arrayList;
    }

    protected void checkForThumbSortUpdate(BaseTemplate baseTemplate, BaseEntityField baseEntityField, List list) {
        int n;
        BaseEntityField[] baseEntityFieldArray = baseTemplate.getSortFields();
        BaseEntityField[] baseEntityFieldArray2 = baseTemplate.getThumbnailFields();
        for (n = 0; n < baseEntityFieldArray2.length; ++n) {
            if (baseEntityFieldArray2[n] == null || baseEntityFieldArray2[n].getID() != baseEntityField.getID()) continue;
            list.addAll(this.generateThumbFieldUpdate(baseTemplate, baseEntityField, true));
            break;
        }
        for (n = 0; n < baseEntityFieldArray.length; ++n) {
            if (baseEntityFieldArray[n] == null || baseEntityFieldArray[n].getID() != baseEntityField.getID()) continue;
            list.addAll(this.generateSortFieldUpdate(baseTemplate, baseEntityField, true));
            break;
        }
    }

    protected List getFieldMoveStatements(BaseTemplate baseTemplate, IEntityFieldEdit iEntityFieldEdit) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }
}

