/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.inscribe.EntityKeyWrapper;
import com.luna.insight.server.inscribe.EquivalenceRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EquivalenceClass
implements Serializable {
    static final long serialVersionUID = -4575068767218987795L;
    protected EquivalenceRule rule;
    protected long id;
    private boolean sorted = true;
    private Map wrapperElements = new HashMap();
    private List entityElements = new ArrayList();

    public EquivalenceClass(EquivalenceRule equivalenceRule) {
        this.rule = equivalenceRule;
        this.id = equivalenceRule.getNextID();
    }

    public boolean hasAllEntities() {
        return this.wrapperElements.size() == 0;
    }

    protected void addWrapperElement(EntityKeyWrapper entityKeyWrapper) {
        this.wrapperElements.put(new Long(entityKeyWrapper.getEntityID()), entityKeyWrapper);
    }

    protected Map getWrapperElements() {
        return this.wrapperElements;
    }

    protected void addEntityElements(List list) {
        this.entityElements.addAll(list);
        this.sorted = false;
    }

    public List getElements() {
        return Collections.unmodifiableList(this.entityElements);
    }

    public void setElements(List list) {
        this.entityElements = list;
        this.wrapperElements.clear();
        this.sorted = false;
    }

    public List getSortedElements() {
        if (!this.sorted) {
            Collections.sort(this.entityElements, this.rule);
            this.sorted = true;
        }
        return this.getElements();
    }

    public long getId() {
        return this.id;
    }

    public EquivalenceRule getRule() {
        return this.rule;
    }

    public int getSize() {
        return this.wrapperElements.size() + this.entityElements.size();
    }
}

