/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Field;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.ThreadedGetter;
import com.luna.insight.server.UniqueListResultCollector;
import java.util.Vector;

public class EntityUniqueListGetter
extends ThreadedGetter {
    protected int entityTypeID;
    protected Field field;
    protected int relationship;
    protected String comparator;
    protected int threshold;
    protected UniqueListResultCollector ulrc;
    protected ResultsProgressListener rpl;

    public EntityUniqueListGetter(int n, Field field, int n2, String string, int n3, UniqueListResultCollector uniqueListResultCollector, ResultsProgressListener resultsProgressListener, CollectionConnection collectionConnection, InsightSmartClient insightSmartClient) {
        this.entityTypeID = n;
        this.field = field;
        this.relationship = n2;
        this.comparator = string;
        this.threshold = n3;
        this.ulrc = uniqueListResultCollector;
        this.rpl = resultsProgressListener;
        this.cc = collectionConnection;
        this.isc = insightSmartClient;
        uniqueListResultCollector.addClient();
    }

    public void run() {
        boolean bl;
        Vector<CriterionValue> vector;
        block14: {
            vector = new Vector<CriterionValue>(0);
            bl = true;
            try {
                if (!this.isc.continueUniqueListRetrieval()) {
                    return;
                }
                InsightRequest insightRequest = InsightRequest.newRequest(103, this.cc.tci, this.isc.getLocalAddress());
                insightRequest.addIntegerParam("ENTITY_TYPE_ID", this.entityTypeID);
                insightRequest.addObjectParam("FIELD", this.field);
                insightRequest.addIntegerParam("RELATIONSHIP", this.relationship);
                if (this.relationship != 0) {
                    insightRequest.addStringParam("COMPARATOR", this.comparator);
                }
                insightRequest.addIntegerParam("THRESHOLD", this.threshold);
                this.cc.oos.writeObject(insightRequest);
                this.cc.oos.flush();
                this.debugOut("Waiting for data -> " + this.cc.tci.toKeyString(), 3);
                if (this.waitWhileKeepAlive(1) > 0) {
                    if (this.rpl != null) {
                        this.rpl.serverContacted(true);
                    }
                    if (!this.isc.continueUniqueListRetrieval()) {
                        return;
                    }
                    bl = this.cc.ois.readBoolean();
                    if (bl) {
                        int n = this.cc.ois.readInt();
                        if (this.rpl != null) {
                            this.rpl.setResultCounts(n, n);
                        }
                        CriterionValue criterionValue = null;
                        for (int i = 0; i < n; ++i) {
                            if (!this.isc.continueUniqueListRetrieval()) {
                                return;
                            }
                            criterionValue = (CriterionValue)this.cc.ois.readObject();
                            if (criterionValue != null && !criterionValue.isEmpty()) {
                                vector.add(criterionValue);
                            }
                            if (this.rpl == null) continue;
                            this.rpl.setResultProgress(i);
                        }
                        if (this.rpl != null) {
                            this.rpl.resultLoadComplete();
                        }
                    }
                } else {
                    this.debugOut("(waitWhileKeepAlive(1) > 0) returned false -> " + this.cc.tci.toKeyString(), 3);
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in run():\n" + InsightUtilities.getStackTrace(exception), 2);
                if (this.rpl == null) break block14;
                this.rpl.resultLoadFailed();
            }
        }
        this.ulrc.addResult(vector, bl);
        this.debugOut("Calling remove client -> " + this.cc.tci.toKeyString(), 3);
        this.ulrc.removeClient();
    }
}

