/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.ThreadedGetter;
import com.luna.insight.server.inscribe.EntitySearchQuery;
import com.luna.insight.server.inscribe.EntitySearchResult;
import com.luna.insight.server.inscribe.EntitySearchResultCollector;

public class EntitySearchResultGetter
extends ThreadedGetter {
    protected EntitySearchQuery esq;
    protected int start;
    protected int length;
    protected boolean includeMediaFiles;
    protected boolean entityIDsOnly;
    protected EntitySearchResultCollector collector;

    public EntitySearchResultGetter(EntitySearchQuery entitySearchQuery, int n, int n2, boolean bl, boolean bl2, EntitySearchResultCollector entitySearchResultCollector, ResultsProgressListener resultsProgressListener, CollectionConnection collectionConnection, InsightSmartClient insightSmartClient) {
        this.esq = entitySearchQuery;
        this.start = n;
        this.length = n2;
        this.includeMediaFiles = bl;
        this.entityIDsOnly = bl2;
        this.collector = entitySearchResultCollector;
        this.rpl = resultsProgressListener;
        this.cc = collectionConnection;
        this.isc = insightSmartClient;
        entitySearchResultCollector.addClient();
    }

    public void run() {
        block12: {
            try {
                if (this.rpl != null) {
                    this.rpl.serverContacted(true);
                }
                this.setPriority(1);
                this.debugOut("EntitySearchResultGetter: Starting.", 3);
                if (!this.isc.continueThumbRetrieval()) {
                    this.collector.removeClient();
                    if (this.rpl != null) {
                        this.rpl.resultLoadFailed();
                    }
                    return;
                }
                InsightRequest insightRequest = InsightRequest.newRequest(104, this.cc.tci, this.isc.getLocalAddress());
                insightRequest.addObjectParam("ENTITY_SEARCH_QUERY", this.esq);
                insightRequest.addIntegerParam("PROFILE_ID", this.cc.tci.getProfileID());
                insightRequest.addIntegerParam("USER_COLLECTION", this.cc.tci.getUserCollection());
                insightRequest.addIntegerParam("START", this.start);
                insightRequest.addIntegerParam("LENGTH", this.length);
                insightRequest.addBooleanParam("INCLUDE_MEDIA_FILES_FLAG", this.includeMediaFiles);
                insightRequest.addBooleanParam("ENTITY_IDS_ONLY_FLAG", this.entityIDsOnly);
                insightRequest.addStringParam("SESSION_GROUP_NAME", this.cc.tci.sessionResults.sessionGroupName);
                insightRequest.addStringParam("SESSION_GROUP_CODE_KEY", this.cc.tci.sessionResults.sessionCodeKey);
                insightRequest.addStringParam("CLIENT_LOCAL_IP", this.isc.getLocalAddress());
                insightRequest.addBooleanParam("EXCLUDE_SPS", false);
                this.cc.oos.writeObject(insightRequest);
                this.cc.oos.flush();
                this.cc.oos.flush();
                this.debugOut("Waiting for data.");
                if (this.waitWhileKeepAlive(1) > 0) {
                    this.debugOut("Receiving data.", 3);
                    this.cc.totalRecords = this.cc.ois.readInt();
                    int n = this.cc.ois.readInt();
                    if (this.rpl != null) {
                        this.rpl.setResultCounts(this.cc.totalRecords, n);
                    }
                    EntitySearchResult entitySearchResult = null;
                    for (int i = 0; i < n; ++i) {
                        if (!this.isc.continueThumbRetrieval()) {
                            this.collector.removeClient();
                            if (this.rpl != null) {
                                this.rpl.resultLoadFailed();
                            }
                            return;
                        }
                        if (this.rpl != null) {
                            this.rpl.setResultProgress(i);
                        }
                        entitySearchResult = (EntitySearchResult)this.cc.ois.readObject();
                        entitySearchResult.setCollectionKey(this.cc.tci);
                        this.collector.addResult(entitySearchResult);
                        this.debugOut("Item #" + i + "  added to ESRCollector.");
                    }
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in ESRGetter:\n" + InsightUtilities.getStackTrace(exception), 2);
                if (this.rpl == null) break block12;
                this.rpl.serverContacted(false);
                this.rpl.resultLoadFailed();
            }
        }
        this.collector.removeClient();
        if (this.rpl != null) {
            this.rpl.resultLoadComplete();
        }
    }
}

