/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.InsightUtilities;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class EntitySearchQuery
implements Serializable {
    static final long serialVersionUID = -2588948116568371537L;
    protected String queryName;
    protected int entityTypeID;
    protected List captionFields = new Vector(0);
    protected List sortFields = new Vector(0);
    protected boolean isKeywordSearch = false;
    protected List fieldCriteria = new Vector(0);
    protected List keywords = new Vector(0);
    protected transient List results = null;
    protected int resultCount = 0;
    protected Integer uniqueCollectionID = null;

    public static void debugOut(String string) {
        EntitySearchQuery.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("EntitySearchQuery: " + string, n);
    }

    public Field addCaptionField(Field field) {
        if (field != null) {
            this.captionFields.add(field);
        }
        return field;
    }

    public Field addSortField(Field field) {
        if (field != null) {
            this.sortFields.add(field);
        }
        return field;
    }

    public FieldCriterion addFieldCriterion(FieldCriterion fieldCriterion) {
        if (fieldCriterion != null) {
            this.fieldCriteria.add(fieldCriterion);
        }
        return fieldCriterion;
    }

    public String addKeyword(String string) {
        if (string != null) {
            this.keywords.add(string);
        }
        return string;
    }

    public void setName(String string) {
        this.queryName = string;
    }

    public void setEntityTypeID(int n) {
        this.entityTypeID = n;
    }

    public void setKeywordSearch(boolean bl) {
        this.isKeywordSearch = bl;
    }

    public void setCaptionFields(List list) {
        this.captionFields = list;
        if (this.captionFields == null) {
            this.captionFields = new Vector(0);
        }
    }

    public void setSortFields(List list) {
        this.sortFields = list;
        if (this.sortFields == null) {
            this.sortFields = new Vector(0);
        }
    }

    public void setResults(List list) {
        this.results = list;
    }

    public void setResultCount(int n) {
        this.resultCount = n;
    }

    public String getName() {
        return this.queryName;
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public boolean isKeywordSearch() {
        return this.isKeywordSearch;
    }

    public List getCaptionFields() {
        return this.captionFields;
    }

    public List getSortFields() {
        return this.sortFields;
    }

    public int getCaptionFieldCount() {
        return this.captionFields.size();
    }

    public int getSortFieldCount() {
        return this.sortFields.size();
    }

    public List getFieldCriteria() {
        return this.fieldCriteria;
    }

    public FieldCriterion getFieldCriterionByID(int n) {
        return this.getFieldCriterion(n);
    }

    public FieldCriterion getFieldCriterion(int n) {
        FieldCriterion fieldCriterion = null;
        for (int i = 0; this.fieldCriteria != null && i < this.fieldCriteria.size(); ++i) {
            fieldCriterion = (FieldCriterion)this.fieldCriteria.get(i);
            if (fieldCriterion.getField() == null || fieldCriterion.getField().fieldID != n) continue;
            return fieldCriterion;
        }
        return null;
    }

    public int getFieldCriteriaCount() {
        return this.fieldCriteria.size();
    }

    public List getKeywords() {
        return this.keywords;
    }

    public int getKeywordCount() {
        return this.keywords.size();
    }

    public List getResults() {
        return this.results;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof EntitySearchQuery)) return super.equals(object);
        EntitySearchQuery entitySearchQuery = (EntitySearchQuery)object;
        if (this.uniqueCollectionID != null) {
            if (entitySearchQuery.uniqueCollectionID == null) return false;
            if (!this.uniqueCollectionID.equals(entitySearchQuery.uniqueCollectionID)) {
                return false;
            }
        } else if (entitySearchQuery.uniqueCollectionID != null) {
            return false;
        }
        if (this.getEntityTypeID() != entitySearchQuery.getEntityTypeID()) return false;
        if (!InsightUtilities.listsEqual(this.getCaptionFields(), entitySearchQuery.getCaptionFields())) return false;
        if (!InsightUtilities.listsEqual(this.getSortFields(), entitySearchQuery.getSortFields())) return false;
        if (!InsightUtilities.listsEqual(this.getFieldCriteria(), entitySearchQuery.getFieldCriteria())) return false;
        if (!InsightUtilities.listsEqual(this.getKeywords(), entitySearchQuery.getKeywords())) return false;
        if (this.isKeywordSearch() == entitySearchQuery.isKeywordSearch()) return true;
        if (!InsightUtilities.listEmpty(this.getFieldCriteria())) return false;
        if (!InsightUtilities.listEmpty(entitySearchQuery.getFieldCriteria())) return false;
        if (!InsightUtilities.listEmpty(this.getKeywords())) return false;
        if (!InsightUtilities.listEmpty(entitySearchQuery.getKeywords())) return false;
        return true;
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return "";
    }

    public void setUniqueCollectionID(Integer n) {
        this.uniqueCollectionID = n;
    }
}

