/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.InsightTableNames;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.indexer.TrinityGroupPresentations;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.presentation.ImageSeriesSlide;
import com.luna.insight.server.presentation.PresentationFileManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class TrinityLegacyPresentationConverter
implements InsightTableNames {
    public static final String CLASS_NAME = "TrinityLegacyPresentationConverter";
    public static final String COMPONENT_NAME = "Insight (v3) Legacy Presentation Converter";
    public static final String COMPONENT_CODE = "LPC";
    public static final String BUILD_DATE = "09Dec2010";
    public static final String PADDER = "                                                                              ";
    public static final long PROGRESS_DISPLAY_DELAY = 200L;
    public static String DEFAULT_CONNECT_STRING = "";
    public static int DEFAULT_DEBUG_LEVEL = 1;
    public static final String DEFAULT_PROPS_FILE = "InsightServer.dat";
    public static final String DEFAULT_PRES_FILE_PATH = "Presentation-Files";
    public static String PROPS_FILE = "InsightServer.dat";
    protected Properties properties;
    protected String connectString = DEFAULT_CONNECT_STRING;
    protected String presFilePath = "Presentation-Files";
    protected PresentationFileManager presFileManager;
    protected String GROUPS_TABLE = "IRGROUPS";
    protected String IMAGE_SERIES_TABLE = "IRIMAGESERIES";
    protected String IMAGE_SERIES_SLIDES_TABLE = "IRIMAGESERIESSLIDES";
    protected String OBJECT_IMAGE_MAP_TABLE = "IROBJECTIMAGEMAP";
    protected int DATABASE_QUERY_MODE = 0;
    protected String DATABASE_GLOBALESCAPEDELIMITER = null;
    protected String DATABASE_UNICODEFIELDPREFIX = null;
    protected DatabaseConnectorGenerator DB_CONNECTOR_GENERATOR;

    public TrinityLegacyPresentationConverter() {
        this.properties = TrinityLegacyPresentationConverter.loadProperties(PROPS_FILE);
        this.DB_CONNECTOR_GENERATOR = DatabaseConnectorGenerator.getCustomGenerator(this.properties);
        this.connectString = this.properties.getProperty("DatabaseConnect", this.connectString);
        this.presFilePath = this.properties.getProperty("PresFilePath", this.presFilePath);
        this.GROUPS_TABLE = this.properties.getProperty("TableGroups", this.GROUPS_TABLE);
        this.IMAGE_SERIES_TABLE = this.properties.getProperty("TableImageSeries", this.IMAGE_SERIES_TABLE);
        this.IMAGE_SERIES_SLIDES_TABLE = this.properties.getProperty("TableImageSeriesSlides", this.IMAGE_SERIES_SLIDES_TABLE);
        this.OBJECT_IMAGE_MAP_TABLE = this.properties.getProperty("TableObjectImageMap", this.OBJECT_IMAGE_MAP_TABLE);
        try {
            this.DATABASE_QUERY_MODE = Integer.parseInt(this.properties.getProperty("DatabaseQueryMode", this.DATABASE_QUERY_MODE + ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.properties.getProperty("GlobalEscapeDelimiter") != null) {
            this.DATABASE_GLOBALESCAPEDELIMITER = this.properties.getProperty("GlobalEscapeDelimiter");
        }
        if (this.properties.getProperty("UnicodeFieldPrefix") != null) {
            this.DATABASE_UNICODEFIELDPREFIX = this.properties.getProperty("UnicodeFieldPrefix");
        }
        try {
            int n = Integer.parseInt(this.properties.getProperty("DebugLevel"));
            Debug.setDebugLevel(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.presFileManager = new PresentationFileManager(this.presFilePath);
    }

    public void start() {
        int n;
        Vector vector;
        TrinityGroupPresentations trinityGroupPresentations;
        int n2;
        TrinityLegacyPresentationConverter.debugOut("");
        TrinityLegacyPresentationConverter.debugOut("Locating target groups...");
        Vector vector2 = this.getGroups();
        TrinityLegacyPresentationConverter.debugOut("");
        TrinityLegacyPresentationConverter.debugOut("Retrieving presentations for " + vector2.size() + " group(s).");
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            trinityGroupPresentations = (TrinityGroupPresentations)vector2.elementAt(n2);
            TrinityLegacyPresentationConverter.debugOut("Getting presentations for [" + trinityGroupPresentations.getGroupInfo().getGroupName() + ", " + trinityGroupPresentations.getGroupInfo().getGroupID() + "].");
            vector = trinityGroupPresentations.getImageSeriesIDs();
            for (n = 0; n < vector.size(); ++n) {
                int n3 = (Integer)vector.elementAt(n);
                ImageSeries imageSeries = this.getImageSeries(n3);
                if (imageSeries != null) {
                    trinityGroupPresentations.addImageSeries(imageSeries);
                    continue;
                }
                TrinityLegacyPresentationConverter.debugOut("Unable to retrieve presentation for [group: " + trinityGroupPresentations.getGroupInfo().getGroupName() + ", seriesID: " + n3 + "].");
            }
        }
        TrinityLegacyPresentationConverter.debugOut("");
        TrinityLegacyPresentationConverter.debugOut("Saving presentations to the file system in folder " + this.presFilePath);
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            trinityGroupPresentations = (TrinityGroupPresentations)vector2.elementAt(n2);
            TrinityLegacyPresentationConverter.debugOut("");
            TrinityLegacyPresentationConverter.debugOut("Saving presentations for [" + trinityGroupPresentations.getGroupInfo().getGroupName() + ", " + trinityGroupPresentations.getGroupInfo().getGroupID() + "].");
            vector = trinityGroupPresentations.getImageSerieses();
            for (n = 0; n < vector.size(); ++n) {
                ImageSeries imageSeries = (ImageSeries)vector.elementAt(n);
                imageSeries.setGroupID(trinityGroupPresentations.getGroupInfo().getGroupID());
                boolean bl = this.presFileManager.savePresentation(imageSeries);
                if (bl) {
                    TrinityLegacyPresentationConverter.debugOut("\t-presentation [" + imageSeries.getSeriesName() + ", " + imageSeries.getImageSeriesID() + "] successfully saved.");
                    continue;
                }
                TrinityLegacyPresentationConverter.debugOut("\t-presentation [" + imageSeries.getSeriesName() + ", " + imageSeries.getImageSeriesID() + "] was not saved.");
            }
        }
    }

    protected Vector getGroups() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        Vector<TrinityGroupPresentations> vector = new Vector<TrinityGroupPresentations>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.GROUPS_TABLE, null, new String[]{"*"});
            sqlQueryGenerator.addTable(this.IMAGE_SERIES_TABLE, null, new String[]{"ImageSeriesID"});
            sqlQueryGenerator.addJoin(this.GROUPS_TABLE, this.IMAGE_SERIES_TABLE, "GroupID", 0);
            sqlQueryGenerator.appendToWhere(this.GROUPS_TABLE + ".GroupType = " + 2);
            sqlQueryGenerator.addOrderBy(this.GROUPS_TABLE, "GroupID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            TrinityLegacyPresentationConverter.debugOut("Groups query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            int n = -1;
            if (databaseConnector.more()) {
                TrinityGroupPresentations trinityGroupPresentations = null;
                while (databaseConnector.more()) {
                    int n2 = databaseConnector.getIntegerFieldByName("GroupID");
                    if (trinityGroupPresentations == null || n2 != n) {
                        GroupInformation groupInformation = new GroupInformation();
                        groupInformation.setGroupName(databaseConnector.getFieldByName("Name"));
                        groupInformation.setGroupID(n2);
                        TrinityLegacyPresentationConverter.debugOutClean();
                        TrinityLegacyPresentationConverter.debugOutStay("[Found Group, Name: " + groupInformation.getGroupName() + ", ID: " + groupInformation.getGroupID() + "]\r");
                        trinityGroupPresentations = new TrinityGroupPresentations(groupInformation);
                        vector.addElement(trinityGroupPresentations);
                    }
                    trinityGroupPresentations.addImageSeriesID(databaseConnector.getIntegerFieldByName("ImageSeriesID"));
                    n = n2;
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            TrinityLegacyPresentationConverter.debugOut("Exception in getGroups(): " + exception);
        }
        databaseConnector.close();
        TrinityLegacyPresentationConverter.debugOutClean();
        return vector;
    }

    public ImageSeries getImageSeries(int n) {
        ImageSeries imageSeries = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.IMAGE_SERIES_TABLE, "*");
            sqlQueryGenerator.appendToWhere("ImageSeriesID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            TrinityLegacyPresentationConverter.debugOut("Image series name query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                String string = databaseConnector.getFieldByName("SeriesName");
                if (string != null && string.length() == 0) {
                    string = null;
                }
                imageSeries = new ImageSeries(string, n);
                TrinityLegacyPresentationConverter.debugOutClean();
                TrinityLegacyPresentationConverter.debugOutStay("[Found presentation, Name: " + string + ", ID: " + n + "]\r");
                Vector vector = imageSeries.getSlideVector();
                databaseConnector.close();
                sqlQueryGenerator.clear();
                sqlQueryGenerator.addTable(this.IMAGE_SERIES_SLIDES_TABLE, "*");
                sqlQueryGenerator.appendToWhere("ImageSeriesID = " + n);
                sqlQueryGenerator.addOrderBy(this.IMAGE_SERIES_SLIDES_TABLE, "DisplayOrder");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                TrinityLegacyPresentationConverter.debugOut("Image series query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runQuery();
                int n2 = -1;
                long l = -1L;
                while (databaseConnector.more()) {
                    int n3 = databaseConnector.getIntegerFieldByName("DisplayOrder");
                    if (n3 > n2) {
                        TrinityLegacyPresentationConverter.debugOutClean();
                        TrinityLegacyPresentationConverter.debugOutStay("[Reading slide: " + n3 + ", PresName: " + string + ", PresID: " + n + "]\r");
                        n2 = n3;
                        boolean bl = databaseConnector.getIntegerFieldByName("Enabled") == 1;
                        int n4 = databaseConnector.getIntegerFieldByName("LinkCount");
                        boolean bl2 = databaseConnector.getIntegerFieldByName("Maximized") == 1;
                        boolean bl3 = databaseConnector.getIntegerFieldByName("Minimized") == 1;
                        Dimension dimension = new Dimension(databaseConnector.getIntegerFieldByName("TotalWidth"), databaseConnector.getIntegerFieldByName("TotalHeight"));
                        if (dimension.width == -1 && dimension.height == -1) {
                            dimension = null;
                        }
                        Rectangle rectangle = new Rectangle(databaseConnector.getIntegerFieldByName("XPosition"), databaseConnector.getIntegerFieldByName("YPosition"), databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                        if (rectangle.width == -1 && rectangle.height == -1) {
                            rectangle = null;
                        }
                        Point point = new Point(databaseConnector.getIntegerFieldByName("ViewLeft"), databaseConnector.getIntegerFieldByName("ViewTop"));
                        if (point.x == -1 && point.y == -1) {
                            point = null;
                        }
                        boolean bl4 = true;
                        int n5 = databaseConnector.getIntegerFieldByName("SlideID");
                        long l2 = databaseConnector.getLongField("ObjectID");
                        long l3 = databaseConnector.getLongField("ImageID");
                        if (l2 == 0L) {
                            l2 = this.getObjectID(l3);
                            if ((long)n5 == l) {
                                bl4 = false;
                            }
                        }
                        l = n5;
                        ImageSeriesSlide imageSeriesSlide = new ImageSeriesSlide(n, l2, l3, new CollectionKeyWrapper(databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), null), databaseConnector.getIntegerFieldByName("Resolution"), rectangle, point, dimension, bl, n4, null, bl2, bl3);
                        TrinityLegacyPresentationConverter.debugOut("Slide " + n3 + " -> objectID: " + imageSeriesSlide.getObjectID(), 3);
                        if (bl4) {
                            vector.addElement(imageSeriesSlide);
                        }
                    }
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            TrinityLegacyPresentationConverter.debugOut("Exception in getImageSeries: " + exception);
        }
        databaseConnector.close();
        TrinityLegacyPresentationConverter.debugOutClean();
        return imageSeries;
    }

    public long getObjectID(long l) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        long l2 = -1L;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.OBJECT_IMAGE_MAP_TABLE, "ObjectID");
            sqlQueryGenerator.appendToWhere("ImageID = " + l);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            TrinityLegacyPresentationConverter.debugOut("Get Object ID query: \n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l2 = databaseConnector.getLongField("ObjectID");
            }
        }
        catch (Exception exception) {
            TrinityLegacyPresentationConverter.debugOut("Exception in getObjectID(): " + exception);
        }
        databaseConnector.close();
        return l2;
    }

    protected DatabaseConnector getDatabaseConnector() {
        return this.DB_CONNECTOR_GENERATOR.getConnector(this.connectString);
    }

    protected SqlQueryGenerator getQueryGenerator() {
        return new SqlQueryGenerator(this.DATABASE_QUERY_MODE, this.DATABASE_GLOBALESCAPEDELIMITER, this.DATABASE_UNICODEFIELDPREFIX);
    }

    public static void main(String[] stringArray) {
        System.out.println("\nInsight (v3) Legacy Presentation Converter");
        System.out.println("Build of 09Dec2010\n");
        Debug.setDebugLevel(DEFAULT_DEBUG_LEVEL);
        if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("/?")) {
                    TrinityLegacyPresentationConverter.showHelp();
                    System.exit(0);
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-cf") && !stringArray[i].equalsIgnoreCase("-configfile")) continue;
                if (stringArray.length <= i + 1 || stringArray[i + 1] == null) break;
                PROPS_FILE = stringArray[++i];
                break;
            }
        }
        TrinityLegacyPresentationConverter trinityLegacyPresentationConverter = new TrinityLegacyPresentationConverter();
        trinityLegacyPresentationConverter.start();
    }

    protected static void showHelp() {
        System.out.println("Command syntax:");
        System.out.println("");
        System.out.println("TrinityLegacyPresentationConverter [/?] [[-cf] | [-configfile] filename]");
        System.out.println("");
        System.out.println("/?\t\t- show switches.");
        System.out.println("-cf\t\t- specify the configuration file to use.");
        System.out.println("-configfile\t- same as -cf.");
        System.out.println("");
        System.out.println("NOTE: The default configuration file is InsightServer.dat.");
    }

    protected static Properties loadProperties(String string) {
        Properties properties = new Properties();
        try {
            TrinityLegacyPresentationConverter.debugOut("Configuration file is " + string + ".");
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            TrinityLegacyPresentationConverter.debugOut("Cannot read configuration file!");
            TrinityLegacyPresentationConverter.debugOut("Terminating due to configuration file problems.");
            System.exit(0);
        }
        return properties;
    }

    public static void debugOut(String string) {
        TrinityLegacyPresentationConverter.debugOut(string, DEFAULT_DEBUG_LEVEL);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LPC: " + string, n);
    }

    public static void debugOutStay(String string) {
        TrinityLegacyPresentationConverter.debugOutStay(string, DEFAULT_DEBUG_LEVEL);
    }

    public static void debugOutStay(String string, int n) {
        Debug.debugOutStay("LPC: " + string, n);
    }

    public static void debugOutClean() {
        Debug.debugOutStay("                                                                              \r", DEFAULT_DEBUG_LEVEL);
    }
}

