/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.core.util.CSVLogger;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightDataAnchor;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.MutableLong;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.InsightTableNames;
import com.luna.insight.server.backend.JdbcConnectorError;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.SqlTable;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.hierarchy.ThesaurusRelationType;
import com.luna.insight.server.indexer.DiacriticMappings;
import com.luna.insight.server.indexer.TrinityField;
import com.luna.insight.server.indexer.TrinityFieldGroup;
import com.luna.insight.server.indexer.TrinityFieldProfile;
import com.luna.insight.server.indexer.TrinityFlatObjectRecord;
import com.luna.insight.server.indexer.TrinityHierarchy;
import com.luna.insight.server.indexer.TrinityHierarchyNode;
import com.luna.insight.server.indexer.TrinityIndexerField;
import com.luna.insight.server.indexer.TrinityIndexerProgressListener;
import com.luna.insight.server.indexer.TrinityJoin;
import com.luna.insight.server.indexer.TrinityTable;
import com.luna.insight.server.indexer.TrinityTermObjectToMap;
import com.luna.insight.server.indexer.TrinityTermToFilter;
import com.luna.insight.server.indexer.TrinityTermToIndex;
import com.luna.insight.server.indexer.TrinityValueObjectToMap;
import com.luna.insight.server.indexer.TrinityValueToIndex;
import com.luna.insight.server.inscribe.EntityIndexer;
import com.luna.insight.server.mpd.MultipageDocumentLevel;
import com.luna.insight.server.mpd.MultipageDocumentPage;
import com.luna.insight.server.mpd.MultipageDocumentPageLookup;
import com.luna.insight.server.mpd.MultipageDocumentPathEntry;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import com.luna.insight.server.ucb.FuzzyDateJulianRange;
import com.luna.insight.server.ucb.UcbFuzzyDateMachine;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

public class TrinityIndexer
implements InsightTableNames {
    public static final String COMPONENT_NAME = "Insight (v" + InsightVersion.version() + ") Database Indexer";
    public static final String COMPONENT_CODE = "IDX";
    public static final String BUILD_DATE = "09Dec2010";
    public static final int DEFAULT_DEBUG_LEVEL = 3;
    public static final String PROPS_FILE = "InsightTrinityIndexer.dat";
    public static final String PADDER = "                               ";
    public static final long PROGRESS_DISPLAY_DELAY = 200L;
    public static final String DEFAULT_PRIMARY_OBJECT_TABLE = "Objects";
    public static final String DEFAULT_PRIMARY_OBJECT_KEY = "ObjectID";
    public static String DEFAULT_DATE_FORMAT_STRING = "yyyy-MM-dd hh:mm:ss.S";
    public static int DEFAULT_QUERY_MODE = 0;
    public static String DEFAULT_SERVER_ADDRESS = "localhost";
    public static int DEFAULT_SERVER_PORT = 2845;
    public static final int DEFAULT_MAX_CHARS = 30;
    public static final int MAXIMUM_MAX_CHARS = 100;
    public static final String FZ_DEBUG_FILENAME = "FuzzydateErrors.txt";
    public static final String DEFAULT_LOADFILE_NAME = "Idx";
    public static final String DEFAULT_LOADFILE_EXTENSION = ".txt";
    public static final String DEFAULT_LOADFILE_ENDOFRECORD = "]|#";
    public static final boolean USE_DISTINCT_KEYWORD = true;
    public static Map thumbFieldsCache = Collections.synchronizedMap(new HashMap());
    public static Map sortFieldsCache = Collections.synchronizedMap(new HashMap());
    protected static int queryMode = DEFAULT_QUERY_MODE;
    protected static String globalEscapeDelimiter = null;
    protected static String unicodeFieldPrefix = null;
    protected static SqlQueryGenerator sqlQueryGeneratorUtil = TrinityIndexer.getQueryGenerator();
    protected Integer uniqueCollectionID = null;
    protected boolean doFileLoad = false;
    protected boolean doIncrementalIndex = false;
    protected boolean doFullIndex = false;
    protected boolean doValueIndex = false;
    protected boolean doTermIndex = false;
    protected boolean doHierarchyIndex = false;
    protected boolean automaticallyPostChanges = false;
    protected boolean doFlatObjectDataBrowser = false;
    protected int maxChars = -1;
    protected boolean updateLiveCaches = false;
    protected boolean convertFuzzyDates = false;
    protected boolean generateMultipageDocuments = false;
    protected boolean clearTempTablesOnExit = true;
    protected boolean clearTempTablesOnEntry = true;
    protected int debugLevel = 3;
    protected long startTime;
    protected long timeSpent = -1L;
    protected long lastTime;
    protected long maxValueID = 1L;
    protected long maxTermID = 1L;
    protected int objectCount = 0;
    protected String connectString;
    protected Properties properties;
    protected CollectionKey targetCollectionKey = null;
    protected Vector keywords;
    protected Vector values;
    protected TrinityTable[] tables;
    protected TrinityIndexerField[] fields;
    protected TrinityIndexerField[] selectedFields;
    protected List selectedFieldIDs;
    protected boolean selectedAllFields;
    protected TrinityJoin[] joins;
    protected TrinityFieldGroup[] fieldGroups;
    protected String[] stopList;
    protected TrinityHierarchy[] hierarchies;
    protected ThesaurusRelationType[] thesaurusRelationTypes;
    protected TrinityIndexerField firstClassOneEntity;
    protected String primaryObjectTable = null;
    protected String primaryObjectKey = null;
    protected String elapsedTime;
    protected String remainingTime;
    protected Vector icTables;
    protected boolean primaryIdTableEmpty = true;
    protected DiacriticMappings dcMappings;
    protected long incrementalLastTime = 400L;
    protected String serverAddress = DEFAULT_SERVER_ADDRESS;
    protected int serverPort = DEFAULT_SERVER_PORT;
    protected DatabaseConnectorGenerator dbConnectorGenerator;
    protected SqlBatchController sqlBatchController = null;
    protected TrinityIndexerProgressListener progressListener = null;
    protected boolean indexCancelled = false;
    protected int preferredEntityTypeID;
    protected String loadFilePathname = null;
    protected String loadFilename_VALUES = null;
    protected String loadFilename_VTO = null;
    protected String loadFilename_TERMS = null;
    protected String loadFilename_TOM = null;
    protected DataOutputStream dos_VALUES = null;
    protected DataOutputStream dos_VTO = null;
    protected DataOutputStream dos_TERMS = null;
    protected DataOutputStream dos_TOM = null;

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n = 30;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = true;
        int n2 = 0;
        if (stringArray.length >= 1) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equalsIgnoreCase("-uid") || stringArray[n3].equalsIgnoreCase("-uniquecollectionid")) {
                    if (++n3 >= stringArray.length) continue;
                    try {
                        n2 = Integer.parseInt(stringArray[n3]);
                        ++n3;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-h") || stringArray[n3].equalsIgnoreCase("-hierarchy")) {
                    ++n3;
                    bl5 = true;
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-f") || stringArray[n3].equalsIgnoreCase("-force")) {
                    ++n3;
                    bl6 = true;
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-stt") || stringArray[n3].equalsIgnoreCase("-savetemptables")) {
                    ++n3;
                    bl11 = false;
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-u") || stringArray[n3].equalsIgnoreCase("-updatecaches")) {
                    ++n3;
                    bl8 = true;
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-fd") || stringArray[n3].equalsIgnoreCase("-fuzzydates")) {
                    ++n3;
                    bl9 = true;
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-mpd") || stringArray[n3].equalsIgnoreCase("-mpdgen")) {
                    ++n3;
                    bl10 = true;
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-flatobjbrow")) {
                    bl7 = true;
                    if (++n3 >= stringArray.length) continue;
                    try {
                        n = Integer.parseInt(stringArray[n3]);
                        ++n3;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-b") || stringArray[n3].equalsIgnoreCase("-bulk")) {
                    ++n3;
                    bl = true;
                    continue;
                }
                if (stringArray[n3].equalsIgnoreCase("-?") || stringArray[n3].equalsIgnoreCase("-help") || stringArray[n3].equalsIgnoreCase("/?")) {
                    ++n3;
                    System.out.println("Switches: \n   -uid <id>  OR   -uniquecollectionid <id> : Unique Collection Identifier.\n                                              Example: -uid 1\n                                              Run without -uid to see a list of collections\n   -b    OR   -bulk               : Create files to bulk load into the database.\n   -f    OR   -force              : Do not prompt about overwriting old tables.\n   -stt  OR   -savetemptables     : Save (do not clear) the temp tables on exit.\n   -h    OR   -hierarchy          : Index hierarchies.\n   -u    OR   -updatecaches       : Update the caches on live collection server.\n   -fd   OR   -fuzzydates         : Index fuzzy dates.\n   -mpd  OR   -mpdgen             : Generate multipage documents.\n   -flatobjbrow     [maxChars]    : Populate flat object data for Browser.\n   -?    OR   /?                  : Show this help message.");
                    System.exit(-1);
                    continue;
                }
                ++n3;
            }
        }
        if (n2 <= 0) {
            System.out.println("\n Unique Collection ID is not specified.  Use -help for the usage options");
            System.exit(0);
        }
        System.out.println("\n" + COMPONENT_NAME + "\nBuild of " + BUILD_DATE + "\n");
        TrinityIndexer trinityIndexer = new TrinityIndexer(new Integer(n2), bl, bl2, bl3, bl4, bl5, bl6, bl7, n, bl8, bl9, bl10, bl11);
        trinityIndexer.go();
    }

    public static void debugOut(String string) {
        TrinityIndexer.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IDX: " + string, n);
    }

    public static void debugOutStay(String string) {
        TrinityIndexer.debugOutStay(string, 3);
    }

    public static void debugOutStay(String string, int n) {
        Debug.debugOutStay("IDX: " + string + "\r", n);
    }

    public static void clearDebugOutStay() {
        Debug.debugOutStay("                                                                               \r", 3);
    }

    public static String getPadderSubstring(int n) {
        if (n < PADDER.length()) {
            return PADDER.substring(n);
        }
        return "";
    }

    public static int getRecordCount(DatabaseConnector databaseConnector, String string) {
        int n = 0;
        if (databaseConnector != null) {
            try {
                databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(string, "ValueCount"));
                databaseConnector.runQuery();
                n = databaseConnector.getIntegerField("ValueCount");
            }
            catch (Exception exception) {
                n = 0;
                TrinityIndexer.debugOut("Exception getting record count:\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return n;
    }

    public static long numeralizeDate(String string) {
        long l = 0L;
        try {
            return InsightUtilities.numeralizeDate(string, DEFAULT_DATE_FORMAT_STRING);
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Couldn't convert date " + string + " into millisecond value. Exception:\n" + InsightUtilities.getStackTrace(exception));
            return l;
        }
    }

    public static String formatTimeString(int n) {
        int n2 = n / 60;
        int n3 = n2 / 60;
        String string = "";
        string = n3 < 10 ? string + "0" + n3 + ":" : string + n3 + ":";
        string = n2 < 10 ? string + "0" + n2 + ":" : string + (n2 %= 60) + ":";
        string = n < 10 ? string + "0" + n : string + (n %= 60);
        return string;
    }

    public static String[] getStopList(DatabaseConnector databaseConnector) {
        String[] stringArray = new String[]{};
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Gathering stop-list information.");
        try {
            databaseConnector.setQuery("SELECT * FROM ISSTOPLIST");
            databaseConnector.runQuery();
            Vector<String> vector = new Vector<String>();
            TrinityIndexer.debugOut("");
            while (databaseConnector.more()) {
                String string = databaseConnector.getStringField("Term");
                vector.add(string);
                TrinityIndexer.debugOut("  Stop-list term #" + vector.size() + ": " + string);
                databaseConnector.next();
            }
            databaseConnector.close();
            stringArray = vector.toArray(new String[0]);
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception in getStopList():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            TrinityIndexer.debugOut("Error in getStopList():\n" + InsightUtilities.getStackTrace(error));
        }
        return stringArray;
    }

    public static Vector parseTerms(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        if (InsightUtilities.isNonEmpty(string)) {
            String string2 = string.toLowerCase();
            int n = 0;
            int n2 = 0;
            Vector<String> vector2 = new Vector<String>();
            String string3 = null;
            int n3 = 0;
            int n4 = 0;
            while (n4 < string2.length()) {
                boolean bl = TrinityIndexer.isSkippableCharacter(string2.charAt(n4));
                if (bl) {
                    ++n;
                }
                string3 = null;
                if (n4 == string2.length() - 1) {
                    if (bl && n3 < n4) {
                        string3 = string2.substring(n3, n4);
                    } else if (!bl && n3 <= n4) {
                        string3 = string2.substring(n3);
                    }
                    ++n4;
                } else if (bl) {
                    if (n3 < n4) {
                        string3 = string2.substring(n3, n4);
                    }
                    n3 = ++n4;
                } else {
                    ++n4;
                }
                if (string3 == null) continue;
                n2 += string3.length();
                vector2.add(string3);
                boolean bl2 = true;
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string3)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2 || vector.contains(string3)) continue;
                vector.addElement(string3);
            }
            if (n2 + n != string2.length()) {
                TrinityIndexer.debugOut("Potential term parsing error!\nValue: " + string2 + "\nTerms:" + vector2);
            }
        }
        return vector;
    }

    public static boolean isSkippableCharacter(char c) {
        return c >= '\u0000' && c <= ',' || c >= '.' && c <= '/' || c >= ':' && c <= '`' || c >= '{' && c <= '\u007f' || c >= '\ua141' && c <= '\ua17e' || c >= '\ua1a1' && c <= '\ua1bf' || c >= '\ua3a1' && c <= '\ua3b2' || c >= '\ua3a7' && c <= '\ua3a9' || c >= '\ua3b0' && c <= '\ua3bb' || c >= '\ua3fb' && c <= '\ua3fd' || c == '\ua1c4' || c == '\ua3ac' || c == '\ua3ae' || c == '\ua3db' || c == '\ua3bf' || c == '\ua3dd' || c == '\ua3e0';
    }

    public static String escapeQuotes(String string) {
        return TrinityIndexer.getQueryGeneratorUtil().escapeQuotes(string);
    }

    public static String prepStringForQuery(String string) {
        return TrinityIndexer.getQueryGeneratorUtil().prepStringForQuery(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized long addValueMapping(Integer n, String string, long l, int n2, int n3, String string2, boolean bl, boolean bl2, boolean bl3, MutableLong mutableLong, DatabaseConnector databaseConnector) {
        long l2 = 0L;
        String string3 = bl3 ? "ITVALUES" : "DTVALUES";
        String string4 = bl3 ? "ITVALUETOOBJECT" : "DTVALUETOOBJECT";
        try {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2;
            String string5 = string.trim();
            if (n3 == 3) {
                string5 = TrinityIndexer.numeralizeDate(string5) + "";
            }
            boolean bl4 = false;
            if (n3 == 2) {
                databaseConnector.setQuery("SELECT ValueID, ValueNumber FROM " + string3 + " WHERE (ValueNumber = " + string5 + " AND FieldID = " + n2 + " AND Enabled = " + (bl2 ? "1" : "0") + " AND UniqueCollectionID = " + n + ")");
            } else {
                databaseConnector.setQuery("SELECT ValueID, ValueText FROM " + string3 + " WHERE (ValueText = " + TrinityIndexer.prepStringForQuery(string5) + " AND FieldID = " + n2 + " AND Enabled = " + (bl2 ? "1" : "0") + " AND UniqueCollectionID = " + n + ")");
            }
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l2 = databaseConnector.getLongField("ValueID");
                bl4 = true;
            }
            databaseConnector.close();
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGeneratorUtil();
            if (!bl4) {
                stringBuffer2 = new StringBuffer();
                stringBuffer = new StringBuffer();
                if (mutableLong != null) {
                    mutableLong.addToValue(1L);
                    l2 = mutableLong.getValue();
                } else {
                    l2 = TrinityIndexer.getMaxValueID(databaseConnector, string3);
                    ++l2;
                }
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "UniqueCollectionID", 2, stringBuffer, n.toString());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "ValueID", 2, stringBuffer, l2 + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "FieldID", 2, stringBuffer, n2 + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "Enabled", 2, stringBuffer, bl2 ? "1" : "0");
                if (n3 == 2) {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "ValueNumber", 2, stringBuffer, string5);
                } else {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "ValueText", 1, stringBuffer, string5);
                }
                databaseConnector.setQuery("INSERT INTO " + string3 + " (" + stringBuffer2.toString() + ")" + " VALUES (" + stringBuffer.toString() + ")");
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            stringBuffer2 = new StringBuffer();
            stringBuffer = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "UniqueCollectionID", 2, stringBuffer, n.toString());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "ValueID", 2, stringBuffer, l2 + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer2, DEFAULT_PRIMARY_OBJECT_KEY, 2, stringBuffer, l + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "Grouping", 2, stringBuffer, string2);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "DisplayOrder", 2, stringBuffer, "0");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "Preferred", 2, stringBuffer, bl ? "1" : "0");
            databaseConnector.setQuery("INSERT INTO " + string4 + " (" + stringBuffer2.toString() + ")" + " VALUES (" + stringBuffer.toString() + ")");
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            if (bl3) return l2;
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception in addValueMapping():\n" + InsightUtilities.getStackTrace(exception));
            return l2;
        }
        catch (Error error) {
            TrinityIndexer.debugOut("Error in addValueMapping():\n" + InsightUtilities.getStackTrace(error));
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized long addTermMapping(Integer n, String string, long l, int n2, String string2, boolean bl, boolean bl2, MutableLong mutableLong, DatabaseConnector databaseConnector) {
        long l2 = 0L;
        try {
            boolean bl3 = false;
            String string3 = bl2 ? "ITTERMS" : "DTTERMS";
            String string4 = bl2 ? "ITTERMOBJECTMAP" : "DTTERMOBJECTMAP";
            databaseConnector.setQuery("SELECT TermID FROM " + string3 + " WHERE Keyword = " + TrinityIndexer.prepStringForQuery(string));
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                try {
                    l2 = databaseConnector.getLongField("TermID");
                }
                catch (Exception exception) {
                    TrinityIndexer.debugOut("Exception in addTermMapping():\n" + InsightUtilities.getStackTrace(exception));
                }
                bl3 = true;
            }
            databaseConnector.close();
            if (bl) {
                if (!bl3) return l2;
                databaseConnector.setQuery("DELETE FROM " + string4 + " WHERE TermID = " + l2 + " AND ObjectID = " + l + " AND FieldID = " + n2 + " AND Grouping = " + string2);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                return l2;
            }
            if (!bl3) {
                if (mutableLong != null) {
                    mutableLong.addToValue(1L);
                    l2 = mutableLong.getValue();
                } else {
                    l2 = TrinityIndexer.getMaxTermID(databaseConnector, string3);
                    ++l2;
                }
                databaseConnector.setQuery("INSERT INTO " + string3 + " (TermID, Keyword)" + " VALUES (" + l2 + ", " + TrinityIndexer.prepStringForQuery(string) + ")");
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            databaseConnector.setQuery("INSERT INTO " + string4 + " (UniqueCollectionID, TermID, FieldID, ObjectID, Grouping)" + " VALUES (" + n + ", " + l2 + ", " + n2 + ", " + l + ", " + string2 + ")");
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            if (!bl3) return l2;
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception in addTermMapping():\n" + InsightUtilities.getStackTrace(exception));
            return l2;
        }
        catch (Error error) {
            TrinityIndexer.debugOut("Error in addTermMapping():\n" + InsightUtilities.getStackTrace(error));
        }
        return l2;
    }

    public static long getMaxValueID(DatabaseConnector databaseConnector, String string) {
        long l = 0L;
        databaseConnector.setQuery("SELECT Max(ValueID) AS MaxID FROM " + string);
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            try {
                l = databaseConnector.getLongField("MaxID");
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in getMaxValueID():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return l;
    }

    public static long getMaxTermID(DatabaseConnector databaseConnector, String string) {
        long l = 0L;
        databaseConnector.setQuery("SELECT Max(TermID) AS MaxID FROM " + string);
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            try {
                l = databaseConnector.getLongField("MaxID");
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in getMaxTermID():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return l;
    }

    public static TrinityFlatObjectRecord getFlatObjectRecord(Map map, long l, List list, List list2) {
        Long l2 = new Long(l);
        TrinityFlatObjectRecord trinityFlatObjectRecord = (TrinityFlatObjectRecord)map.get(l2);
        if (trinityFlatObjectRecord == null) {
            trinityFlatObjectRecord = new TrinityFlatObjectRecord(l, list, list2);
            map.put(l2, trinityFlatObjectRecord);
        }
        return trinityFlatObjectRecord;
    }

    protected static TrinityFieldProfile getFieldProfile(int n, DatabaseConnector databaseConnector) {
        TrinityFieldProfile trinityFieldProfile = new TrinityFieldProfile();
        try {
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            sqlQueryGenerator.addTable("IRFIELDS", null, "*");
            sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere("(IRFIELDS.FieldID = " + n + ")");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            TrinityIndexer.debugOut("Get field profile query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                trinityFieldProfile.fieldName = databaseConnector.getFieldByName("FieldName");
                trinityFieldProfile.fieldID = databaseConnector.getIntegerField("FieldID");
                trinityFieldProfile.fieldValueName = TrinityConnector.getFieldValueName(databaseConnector.getFieldByName("TypeCode"));
            }
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception in getFieldProfile():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return trinityFieldProfile;
    }

    protected static TrinityFieldProfile getFieldProfile(String string, DatabaseConnector databaseConnector) {
        TrinityFieldProfile trinityFieldProfile = new TrinityFieldProfile();
        try {
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            sqlQueryGenerator.addTable("IRFIELDS", null, "*");
            sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere("(IRFIELDS.FieldName = " + TrinityIndexer.prepStringForQuery(string) + ")");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            TrinityIndexer.debugOut("Get field profile query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                trinityFieldProfile.fieldName = databaseConnector.getFieldByName("FieldName");
                trinityFieldProfile.fieldID = databaseConnector.getIntegerField("FieldID");
                trinityFieldProfile.fieldValueName = TrinityConnector.getFieldValueName(databaseConnector.getFieldByName("TypeCode"));
            }
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception in getFieldProfile():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return trinityFieldProfile;
    }

    public static List getBrowserThumbFields(Integer n, DatabaseConnector databaseConnector, DatabaseConnector databaseConnector2) {
        if (n == null) {
            Vector vector = new Vector(4);
            return vector;
        }
        List list = (List)thumbFieldsCache.get(n);
        if (list == null) {
            TrinityIndexer.gatherBrowserFields(n, databaseConnector, databaseConnector2);
            list = (List)thumbFieldsCache.get(n);
        }
        return list;
    }

    public static List getBrowserSortFields(Integer n, DatabaseConnector databaseConnector, DatabaseConnector databaseConnector2) {
        if (n == null) {
            Vector vector = new Vector(4);
            return vector;
        }
        List list = (List)sortFieldsCache.get(n);
        if (list == null) {
            TrinityIndexer.gatherBrowserFields(n, databaseConnector, databaseConnector2);
            list = (List)sortFieldsCache.get(n);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearBrowserFieldsCache() {
        TrinityIndexer.debugOut("BrowserFieldsCache: clearing the cache");
        Map map = thumbFieldsCache;
        synchronized (map) {
            thumbFieldsCache = Collections.synchronizedMap(new HashMap());
        }
        map = sortFieldsCache;
        synchronized (map) {
            sortFieldsCache = Collections.synchronizedMap(new HashMap());
        }
    }

    public static void clearBrowserFieldsCache(Integer n) {
        if (n == null) {
            TrinityIndexer.clearBrowserFieldsCache();
            return;
        }
        TrinityIndexer.debugOut("BrowserFieldsCache: clearing the cache for UID:" + n);
        thumbFieldsCache.remove(n);
        sortFieldsCache.remove(n);
    }

    private static void gatherBrowserFields(Integer n, DatabaseConnector databaseConnector, DatabaseConnector databaseConnector2) {
        TrinityIndexer.debugOut("Gathering browser thumb and sort fields for UID: " + n);
        TrinityIndexer.debugOut("");
        Vector<TrinityFieldProfile> vector = new Vector<TrinityFieldProfile>(4);
        Vector<TrinityFieldProfile> vector2 = new Vector<TrinityFieldProfile>(4);
        try {
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "*");
            sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            sqlQueryGenerator.appendToWhere("VCID = " + TrinityIndexer.prepStringForQuery("NA"));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            TrinityIndexer.debugOut("Get browser thumb and sort fields query:\n" + databaseConnector.getQuery());
            TrinityIndexer.debugOut("");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField1"), databaseConnector2));
                vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField2"), databaseConnector2));
                vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField3"), databaseConnector2));
                vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField4"), databaseConnector2));
                vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField1"), databaseConnector2));
                vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField2"), databaseConnector2));
                vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField3"), databaseConnector2));
                vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField4"), databaseConnector2));
            } else {
                TrinityIndexer.debugOut("Cannot gather browser thumb and sort fields for UID: " + n);
            }
            databaseConnector.close();
            databaseConnector2.close();
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception while gathering browser thumb and sort fields:\n" + InsightUtilities.getStackTrace(exception));
        }
        thumbFieldsCache.put(n, vector);
        sortFieldsCache.put(n, vector2);
    }

    public TrinityIndexer(Integer n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n2, boolean bl8, boolean bl9, boolean bl10, boolean bl11) {
        this.uniqueCollectionID = n;
        this.doFileLoad = bl;
        this.doIncrementalIndex = bl2;
        this.doValueIndex = bl3;
        this.doTermIndex = bl4;
        this.doHierarchyIndex = bl5;
        this.automaticallyPostChanges = bl6;
        this.doFlatObjectDataBrowser = bl7;
        this.maxChars = n2;
        this.updateLiveCaches = bl8;
        this.convertFuzzyDates = bl9;
        this.generateMultipageDocuments = bl10;
        this.clearTempTablesOnExit = bl11;
        this.properties = this.loadProperties();
        this.dbConnectorGenerator = DatabaseConnectorGenerator.getCustomGenerator(this.properties);
        this.keywords = new Vector();
        this.icTables = new Vector();
        this.connectString = this.properties.getProperty("DatabaseConnect");
        queryMode = Integer.parseInt(this.properties.getProperty("DatabaseQueryMode", "" + DEFAULT_QUERY_MODE));
        globalEscapeDelimiter = this.properties.getProperty("GlobalEscapeDelimiter");
        unicodeFieldPrefix = this.properties.getProperty("UnicodeFieldPrefix");
        sqlQueryGeneratorUtil = TrinityIndexer.getQueryGenerator();
        DEFAULT_DATE_FORMAT_STRING = this.properties.getProperty("DateFormatString", DEFAULT_DATE_FORMAT_STRING);
        this.serverAddress = this.properties.getProperty("ServerAddress", DEFAULT_SERVER_ADDRESS);
        if (this.properties.getProperty("ServerPort") != null) {
            this.serverPort = Integer.parseInt(this.properties.getProperty("ServerPort"));
        }
        try {
            this.debugLevel = Integer.parseInt(this.properties.getProperty("DebugLevel", "3"));
            Debug.setDebugLevel(this.debugLevel);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TrinityIndexer.debugOut("");
        this.dcMappings = new DiacriticMappings();
        TrinityIndexer.debugOut("");
        if (!this.dcMappings.hasMappings()) {
            TrinityIndexer.debugOut("No DiacriticMappings found.");
            this.dcMappings = null;
        } else {
            TrinityIndexer.debugOut("DiacriticMappings found.");
        }
        if (this.connectString == null || this.connectString.length() == 0) {
            TrinityIndexer.debugOut("Connect string is empty.  Stopping.");
            System.exit(0);
        }
        int n3 = 100;
        try {
            n3 = Integer.parseInt(this.properties.getProperty("BatchSize"));
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 100;
        }
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("SQL command batch size: " + n3);
        TrinityIndexer.debugOut("");
        this.sqlBatchController = new SqlBatchController(this.getDatabaseConnector(), n3);
        if (bl) {
            String string = this.loadFilePathname != null ? InsightUtilities.concatFilepath(this.loadFilePathname, DEFAULT_LOADFILE_NAME) : DEFAULT_LOADFILE_NAME;
            this.loadFilename_VALUES = string + "_VALUES" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_VTO = string + "_VALUETOOBJECT" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TERMS = string + "_TERMS" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TOM = string + "_TERMOBJECTMAP" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
        }
    }

    public TrinityIndexer(Integer n, List list, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, boolean bl5, int n2, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string2, int n3, int n4, int n5, String string3, String string4, String string5, File file, boolean bl10, boolean bl11, boolean bl12, int n6, String string6, DatabaseConnectorGenerator databaseConnectorGenerator) {
        this.uniqueCollectionID = n;
        this.doFileLoad = bl4;
        this.loadFilePathname = string;
        this.doIncrementalIndex = bl3;
        this.doValueIndex = bl;
        this.doTermIndex = bl2;
        this.doFlatObjectDataBrowser = bl5;
        this.maxChars = n2;
        this.doHierarchyIndex = bl6;
        this.automaticallyPostChanges = bl10;
        this.updateLiveCaches = bl9;
        this.convertFuzzyDates = bl8;
        this.generateMultipageDocuments = bl7;
        this.clearTempTablesOnExit = !bl11;
        this.clearTempTablesOnEntry = bl12;
        this.selectedFieldIDs = list;
        this.serverAddress = string2;
        this.serverPort = n3;
        queryMode = n5;
        globalEscapeDelimiter = string3;
        unicodeFieldPrefix = string4;
        sqlQueryGeneratorUtil = TrinityIndexer.getQueryGenerator();
        DEFAULT_DATE_FORMAT_STRING = string5;
        this.dbConnectorGenerator = databaseConnectorGenerator;
        this.connectString = string6;
        this.keywords = new Vector();
        this.icTables = new Vector();
        try {
            this.debugLevel = n6;
            Debug.setDebugLevel(n6);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TrinityIndexer.debugOut("");
        this.dcMappings = file != null ? new DiacriticMappings(file) : new DiacriticMappings();
        TrinityIndexer.debugOut("");
        if (!this.dcMappings.hasMappings()) {
            TrinityIndexer.debugOut("No DiacriticMappings found.");
            this.dcMappings = null;
        } else {
            TrinityIndexer.debugOut("DiacriticMappings found.");
        }
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("SQL command batch size: " + n4);
        this.sqlBatchController = new SqlBatchController(this.getDatabaseConnector(), n4);
        TrinityIndexer.debugOut("");
        if (bl4) {
            String string7 = string != null ? InsightUtilities.concatFilepath(string, DEFAULT_LOADFILE_NAME) : DEFAULT_LOADFILE_NAME;
            this.loadFilename_VALUES = string7 + "_VALUES" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_VTO = string7 + "_VALUETOOBJECT" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TERMS = string7 + "_TERMS" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TOM = string7 + "_TERMOBJECTMAP" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPreferredEntityTypeID(Integer n) {
        int n2 = EntityIndexer.DEFAULT_OBJ_ENTITY_TYPE_ID;
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            n2 = TrinityConnector.getPreferredEntityTypeID(n, databaseConnector, sqlQueryGenerator);
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception while getting \"preferred\" entity type ID:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n2;
    }

    public void go() {
        this.startTime = System.currentTimeMillis();
        if (this.doIncrementalIndex) {
            this.doFileLoad = false;
            this.doValueIndex = false;
            this.doTermIndex = false;
        }
        try {
            if ((this.doIncrementalIndex || this.doValueIndex || this.doTermIndex || this.doHierarchyIndex) && !this.indexCancelled) {
                int n;
                this.startTime = System.currentTimeMillis();
                TrinityIndexer.debugOut("Connecting to database.");
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("Get preferred entity type ID.");
                this.preferredEntityTypeID = this.getPreferredEntityTypeID(this.uniqueCollectionID);
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("Gathering Insight Source (IS) information from database.");
                this.gatherTableData(this.uniqueCollectionID);
                this.gatherJoinData(this.uniqueCollectionID);
                this.gatherFieldGroupData();
                this.gatherFieldData();
                this.gatherStopList();
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("Clearing out temporary indices.");
                TrinityIndexer.debugOut("");
                if (this.clearTempTablesOnEntry) {
                    try {
                        this.clearTemporaryTables(this.uniqueCollectionID);
                    }
                    catch (Exception exception) {
                        this.exitError("Exception while clearing temporary tables:\n" + InsightUtilities.convertStackTraceToString(exception));
                    }
                }
                if (this.selectedFieldIDs == null) {
                    this.selectedFieldIDs = new Vector(0);
                }
                if (this.selectedFieldIDs != null && this.selectedFieldIDs.size() > 0) {
                    Vector<TrinityIndexerField> vector = new Vector<TrinityIndexerField>(this.selectedFieldIDs.size());
                    for (int i = 0; i < this.selectedFieldIDs.size(); ++i) {
                        TrinityIndexerField trinityIndexerField;
                        try {
                            trinityIndexerField = this.getField((Integer)this.selectedFieldIDs.get(i));
                        }
                        catch (Exception exception) {
                            trinityIndexerField = null;
                        }
                        if (trinityIndexerField == null) continue;
                        vector.add(trinityIndexerField);
                    }
                    if (vector.size() > 0) {
                        this.selectedFields = vector.toArray(new TrinityIndexerField[0]);
                    }
                }
                this.selectedAllFields = false;
                if (this.selectedFields == null) {
                    this.selectedFields = this.fields;
                    this.selectedAllFields = true;
                } else if (this.selectedFields.length == this.fields.length) {
                    this.selectedAllFields = true;
                }
                this.selectedFieldIDs.clear();
                for (n = 0; this.selectedFields != null && n < this.selectedFields.length; ++n) {
                    this.selectedFieldIDs.add(new Integer(this.selectedFields[n].fieldID));
                }
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("  " + this.selectedFields.length + " field(s) selected for indexing:");
                for (n = 0; n < this.selectedFields.length; ++n) {
                    if (n < 9) {
                        TrinityIndexer.debugOut("  Field  " + (n + 1) + ": " + this.selectedFields[n].sourceName + TrinityIndexer.getPadderSubstring(this.selectedFields[n].sourceName.length()) + " (" + this.selectedFields[n].displayName + ")");
                        continue;
                    }
                    TrinityIndexer.debugOut("  Field " + (n + 1) + ": " + this.selectedFields[n].sourceName + TrinityIndexer.getPadderSubstring(this.selectedFields[n].sourceName.length()) + " (" + this.selectedFields[n].displayName + ")");
                }
                if (this.findFirstClassOneEntity()) {
                    TrinityIndexer.debugOut("");
                    TrinityIndexer.debugOut("Class one entity found: " + this.firstClassOneEntity.sourceName);
                } else {
                    this.exitError("Cannot find any class-one entities in IRFIELDGROUPS.");
                }
                TrinityIndexer.debugOut("");
                Debug.debugOutStay("IDX: Counting objects - ", 3);
                databaseConnector.setQuery("SELECT Count(*) AS ObjectCount FROM " + this.firstClassOneEntity.table.name + ";");
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    try {
                        this.objectCount = databaseConnector.getIntegerFieldByName("ObjectCount");
                    }
                    catch (Exception exception) {
                        TrinityIndexer.debugOut("Exception in constructor:\n" + InsightUtilities.convertStackTraceToString(exception));
                    }
                    Debug.debugOut(this.objectCount + " objects found.", 3);
                } else {
                    Debug.debugOut("cannot determine object count.", 3);
                }
                databaseConnector.close();
                boolean bl = !this.selectedAllFields;
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("Indexing.");
                TrinityIndexer.debugOut("");
                if (this.doValueIndex && this.doTermIndex) {
                    this.doFullIndex = true;
                }
                if (this.doFullIndex && !this.indexCancelled) {
                    this.doFullIndexing(this.uniqueCollectionID);
                } else if (this.doValueIndex && !this.indexCancelled) {
                    this.doValueIndexing(this.uniqueCollectionID);
                } else if (this.doTermIndex && !this.indexCancelled) {
                    this.doTermIndexing(this.uniqueCollectionID, false);
                } else if (this.doIncrementalIndex && !this.indexCancelled) {
                    this.doIncrementalIndexing(this.uniqueCollectionID);
                    bl = false;
                }
                TrinityIndexer.clearDebugOutStay();
                if (this.doHierarchyIndex && !this.indexCancelled) {
                    this.doHierarchyIndexing(this.uniqueCollectionID, this.doValueIndex);
                }
                if (!this.indexCancelled) {
                    try {
                        this.commitIndexingChanges(this.uniqueCollectionID, bl);
                    }
                    catch (Exception exception) {
                        this.exitError("Exception while clearing and copying to destination tables:\n" + InsightUtilities.convertStackTraceToString(exception));
                    }
                }
                TrinityIndexer.debugOut("");
                this.timeSpent = System.currentTimeMillis() - this.startTime;
                TrinityIndexer.debugOut("Time spent indexing including waits: " + TrinityIndexer.formatTimeString((int)(this.timeSpent / 1000L)));
            }
            if (this.updateLiveCaches && !this.indexCancelled) {
                TrinityIndexer.debugOut("Updating live FSM and thumbnail caches...");
                this.startTime = System.currentTimeMillis();
                this.updateLiveCaches();
                TrinityIndexer.debugOut("Time spent updating caches: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - this.startTime) / 1000L)));
            }
            if (this.convertFuzzyDates && !this.indexCancelled) {
                TrinityIndexer.debugOut("Converting fuzzy dates");
                this.doFuzzyDateIndexing(this.uniqueCollectionID);
            }
            if (this.generateMultipageDocuments && !this.indexCancelled) {
                this.doMultipageDocumentsGeneration(this.uniqueCollectionID);
            }
            if (this.doFlatObjectDataBrowser && !this.indexCancelled) {
                this.doBrowserFlatObjectDataPopulation(this.uniqueCollectionID, this.maxChars);
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while Indexing:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        catch (JdbcConnectorError jdbcConnectorError) {
            TrinityIndexer.debugOut("  Caught JdbcConnectorError while Indexing: " + InsightUtilities.getStackTrace(jdbcConnectorError));
            this.exitError("Caught JdbcConnectorError while Indexing:\n" + InsightUtilities.getStackTrace(jdbcConnectorError));
        }
        if (this.progressListener != null) {
            this.progressListener.stopTimer();
            this.progressListener.stopRemainingTimeTimer();
            this.progressListener.setCancelButtonText("Close");
        }
        if (this.sqlBatchController != null) {
            this.sqlBatchController.setStillNeeded(false);
        }
    }

    protected void commitIndexingChanges(Integer n, boolean bl) {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Clearing old destination tables.");
        TrinityIndexer.debugOut("");
        if (this.canClearDestinationTables()) {
            if (this.progressListener != null) {
                this.progressListener.setDestinationTablesStatusText("Deleting Tables");
            }
            if (this.doTermIndex) {
                if (bl) {
                    if (this.selectedFieldIDs != null && this.selectedFieldIDs.size() > 0) {
                        this.clearTable(n, "DTTERMOBJECTMAP", "FieldID IN (" + InsightUtilities.getListString(this.selectedFieldIDs) + ")");
                    }
                    this.clearTable(null, "DTTERMS", "TermID NOT IN (SELECT TermID FROM DTTERMOBJECTMAP)");
                } else {
                    this.clearTable(n, "DTTERMOBJECTMAP");
                    this.clearTable(null, "DTTERMS", "TermID NOT IN (SELECT TermID FROM DTTERMOBJECTMAP)");
                }
            }
            if (this.doValueIndex) {
                if (bl) {
                    if (this.selectedFieldIDs != null && this.selectedFieldIDs.size() > 0) {
                        this.clearTable(n, "DTVALUES", "FieldID IN (" + InsightUtilities.getListString(this.selectedFieldIDs) + ")");
                    }
                    this.clearTable(n, "DTVALUETOOBJECT", "ValueID NOT IN (SELECT ValueID FROM DTVALUES)");
                } else {
                    this.clearTable(n, "DTVALUES");
                    this.clearTable(n, "DTVALUETOOBJECT");
                }
            }
        } else {
            this.exitError("Aborting indexing.");
        }
        if (!this.indexCancelled) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            if (this.doIncrementalIndex) {
                // empty if block
            }
            databaseConnector.setQuery("DELETE FROM IDTEMPOLD");
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.setQuery("DELETE FROM IDTEMPNEW");
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("Copying from temporary tables to destination tables.");
            TrinityIndexer.debugOut("");
            DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
            if (this.doTermIndex) {
                databaseConnector2.setQuery("INSERT INTO DTTERMOBJECTMAP SELECT Distinct * FROM ITTERMOBJECTMAP");
                TrinityIndexer.debugOut("  ITTERMOBJECTMAP -> DTTERMOBJECTMAP.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                databaseConnector2.setQuery("INSERT INTO DTTERMS SELECT * FROM ITTERMS");
                TrinityIndexer.debugOut("  ITTERMS -> DTTERMS.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
            }
            if (this.doValueIndex) {
                databaseConnector2.setQuery("INSERT INTO DTVALUETOOBJECT SELECT Distinct * FROM ITVALUETOOBJECT");
                TrinityIndexer.debugOut("  ITVALUETOOBJECT -> DTVALUETOOBJECT.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                databaseConnector2.setQuery("INSERT INTO DTVALUES SELECT * FROM ITVALUES");
                TrinityIndexer.debugOut("  ITVALUES -> DTVALUES.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
            }
            for (int i = 0; this.hierarchies != null && i < this.hierarchies.length; ++i) {
                String string = "HierarchyID = " + this.hierarchies[i].getHierarchyID();
                this.clearTable(null, "DTHIERARCHYNODES", string);
                this.clearTable(null, "DTHIERARCHYNODERELATIONS", string);
                this.clearTable(null, "DTHIERARCHYTOOBJECT", string);
                databaseConnector2.setQuery("INSERT INTO DTHIERARCHYNODES SELECT * FROM ITHIERARCHYNODES WHERE " + string);
                TrinityIndexer.debugOut("  ITHIERARCHYNODES -> DTHIERARCHYNODES WHERE " + string + ".");
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
                databaseConnector2.setQuery("INSERT INTO DTHIERARCHYNODERELATIONS SELECT * FROM ITHIERARCHYNODERELATIONS WHERE " + string);
                TrinityIndexer.debugOut("  ITHIERARCHYNODERELATIONS -> DTHIERARCHYNODERELATIONS WHERE " + string + ".");
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
                databaseConnector2.setQuery("INSERT INTO DTHIERARCHYTOOBJECT SELECT * FROM ITHIERARCHYTOOBJECT WHERE " + string);
                TrinityIndexer.debugOut("  ITHIERARCHYTOOBJECT -> DTHIERARCHYTOOBJECT WHERE " + string + ".");
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
                databaseConnector2.setQuery("UPDATE ISHIERARCHIES SET Generate = 0 WHERE " + string);
                TrinityIndexer.debugOut("  Marking hierarchy " + this.hierarchies[i].getHierarchyName() + " as generated.");
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
            }
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("Resetting \"IC\" tables for future indexing.");
            TrinityIndexer.debugOut("");
            if (this.progressListener != null) {
                this.progressListener.setDestinationPb1Maximum(this.tables.length);
                this.progressListener.setDestinationTablesStatusText("Copying Values into Tables");
            }
            for (int i = 0; this.icTables != null && i < this.icTables.size(); ++i) {
                TrinityTable trinityTable = (TrinityTable)this.icTables.get(i);
                databaseConnector2.setQuery("DELETE FROM IC" + trinityTable.name);
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
                databaseConnector2.setQuery("INSERT INTO IC" + trinityTable.name + " SELECT * FROM " + trinityTable.name);
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
                if (this.progressListener == null) continue;
                this.progressListener.setDestinationPb1Value(i + 1);
            }
            if (this.clearTempTablesOnExit) {
                TrinityIndexer.debugOut("Cleaning up.  (Removing data from temporary tables.)");
                TrinityIndexer.debugOut("");
                if (this.progressListener != null) {
                    this.progressListener.setDestinationTablesStatusText("Clearing Temporary Tables");
                }
                this.clearTemporaryTables(n);
            }
            if (this.progressListener != null) {
                this.progressListener.setDestinationPb1Value(this.tables.length);
                this.progressListener.setDestinationTablesStatusText("Completed");
            }
        }
    }

    protected boolean canClearDestinationTables() {
        int n;
        int n2;
        block11: {
            n2 = 110;
            n = -1;
            if (!this.automaticallyPostChanges) {
                String string = "";
                if (this.doValueIndex) {
                    string = string + " Values";
                }
                if (this.doTermIndex) {
                    if (string.length() > 0) {
                        string = string + " and";
                    }
                    string = string + " Terms";
                }
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("Indexing complete.\n     About to delete contents of old DT" + string + " tables and" + "\n     copy data from IT" + string + " tables into them." + "\n     Please look at your IT" + string + " tables" + "\n     and make sure that everything worked as you intended" + "\n     before changes are committed." + "\n\n     Really clear old destination tables? (y/n)", 1);
                n2 = 110;
                byte[] byArray = new byte[1];
                if (!this.automaticallyPostChanges) {
                    try {
                        if (this.progressListener != null) {
                            TrinityIndexer.debugOut("Get answer through progressListener.");
                            this.progressListener.pauseTimer();
                            this.progressListener.pauseRemainingTimeTimer();
                            n = this.progressListener.showJOptionPaneConfirmDialog("Would you like to update the destination tables?", "Commit Changes");
                            if (n == 0) {
                                this.progressListener.restartTimer();
                                this.progressListener.restartRemainingTimeTimer();
                                this.progressListener.setBorderTitle("Updating Destination Tables");
                                this.progressListener.setDestinationTablesStatusText("Started");
                            }
                            break block11;
                        }
                        while (true) {
                            System.in.read(byArray);
                            n2 = (char)byArray[0];
                            if (n2 != 121 && n2 != 89 && n2 != 110 && n2 != 78) {
                                TrinityIndexer.debugOut("Please enter y for Yes or n for No", 1);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return n2 == 121 || this.automaticallyPostChanges || n == 0;
    }

    protected void gatherCollectionData() {
    }

    protected void gatherTableData(Integer n) {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Gathering table information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT * FROM ISTABLES WHERE UniqueCollectionID = " + n);
            databaseConnector.runQuery();
            Vector<TrinityTable> vector = new Vector<TrinityTable>();
            TrinityIndexer.debugOut("");
            if (databaseConnector.more()) {
                DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityTable trinityTable = new TrinityTable();
                    trinityTable.tableID = this.getIntegerField(databaseConnector, "TableID");
                    trinityTable.name = this.getStringField(databaseConnector, "TableName");
                    try {
                        databaseConnector2.setQuery("SELECT COUNT(*) AS TableRowCount FROM IC" + trinityTable.name);
                        databaseConnector2.runQuerySafe();
                        if (databaseConnector2.more()) {
                            this.icTables.addElement(trinityTable);
                            TrinityIndexer.debugOut("  Found IC table for table " + trinityTable.name);
                        }
                        databaseConnector2.close();
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                    boolean bl = false;
                    try {
                        bl = databaseConnector.getBooleanField("IsPrimaryObjectTable");
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    String string = null;
                    try {
                        string = databaseConnector.getField("PrimaryObjectKey");
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                    if (bl) {
                        this.primaryObjectTable = trinityTable.name;
                        this.primaryObjectKey = string;
                    }
                    TrinityIndexer.debugOut("  Table #" + trinityTable.tableID + ": " + trinityTable.name);
                    vector.addElement(trinityTable);
                    databaseConnector.next();
                }
            } else {
                this.exitError("Cannot gather table data from ISTABLES table.");
            }
            databaseConnector.close();
            this.tables = new TrinityTable[vector.size()];
            for (int i = 0; i < this.tables.length; ++i) {
                this.tables[i] = (TrinityTable)vector.elementAt(i);
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering table data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        this.setPrimaryObjectTable();
        this.setPrimaryObjectKey();
    }

    protected void gatherJoinData(Integer n) {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Gathering join information.");
        try {
            int n2;
            int n3;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT * FROM ISJOINS WHERE UniqueCollectionID = " + n);
            databaseConnector.runQuery();
            Vector<TrinityJoin> vector = new Vector<TrinityJoin>();
            TrinityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityJoin trinityJoin = new TrinityJoin();
                    trinityJoin.joinID = this.getIntegerField(databaseConnector, "JoinID");
                    trinityJoin.startTableField = this.getStringField(databaseConnector, "StartFieldName");
                    trinityJoin.endTableField = this.getStringField(databaseConnector, "EndFieldName");
                    trinityJoin.nextJoinID = this.getIntegerField(databaseConnector, "NextJoin");
                    n3 = 0;
                    n2 = 0;
                    n3 = this.getIntegerField(databaseConnector, "StartTableID");
                    n2 = this.getIntegerField(databaseConnector, "EndTableID");
                    for (int i = 0; i < this.tables.length; ++i) {
                        if (n3 == this.tables[i].tableID) {
                            trinityJoin.startTable = this.tables[i];
                        }
                        if (n2 != this.tables[i].tableID) continue;
                        trinityJoin.endTable = this.tables[i];
                    }
                    TrinityIndexer.debugOut("  Join #" + trinityJoin.joinID + ": " + trinityJoin.startTable.name + " to " + trinityJoin.endTable.name);
                    vector.addElement(trinityJoin);
                    databaseConnector.next();
                }
            } else {
                TrinityIndexer.debugOut("  No join data.");
            }
            databaseConnector.close();
            this.joins = new TrinityJoin[vector.size()];
            for (n3 = 0; n3 < this.joins.length; ++n3) {
                this.joins[n3] = (TrinityJoin)vector.elementAt(n3);
            }
            block5: for (n3 = 0; n3 < this.joins.length; ++n3) {
                for (n2 = 0; n2 < this.joins.length; ++n2) {
                    if (this.joins[n3].nextJoinID != this.joins[n2].joinID) continue;
                    this.joins[n3].nextJoin = this.joins[n2];
                    continue block5;
                }
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering join data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void gatherHierarchyData() {
        TrinityIndexer.debugOut("  Gathering hierarchy information.");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT * FROM ISHIERARCHIES WHERE Generate = 1");
            TrinityIndexer.debugOut("Get hierarchies to generate query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            Vector<TrinityHierarchy> vector = new Vector<TrinityHierarchy>(1);
            while (databaseConnector.more()) {
                TrinityHierarchy trinityHierarchy = new TrinityHierarchy(databaseConnector.getIntegerField("HierarchyID"), databaseConnector.getStringField("HierarchyName"), databaseConnector.getStringField("HierarchyIDColumnName"), databaseConnector.getIntegerField("TermsTableID"), databaseConnector.getStringField("TermIDColumnName"), databaseConnector.getStringField("TermColumnName"), databaseConnector.getIntegerField("RelationshipsTableID"), databaseConnector.getStringField("RelationshipTypeColumnName"), databaseConnector.getStringField("RelTermID1ColumnName"), databaseConnector.getStringField("RelTermID2ColumnName"), databaseConnector.getBooleanField("IsANSICompliant"));
                trinityHierarchy.setTermsTable(this.getTable(trinityHierarchy.getTermsTableID()));
                trinityHierarchy.setRelationsTable(this.getTable(trinityHierarchy.getRelationsTableID()));
                vector.add(trinityHierarchy);
                databaseConnector.next();
            }
            this.hierarchies = vector.toArray(new TrinityHierarchy[0]);
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering hierarchy data:\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.exitError("Error while gathering hierarchy data:\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    protected void gatherThesaurusRelationTypes() {
        TrinityIndexer.debugOut("  Gathering thesaurus relation type information.");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT * FROM IRTHESAURUSRELATIONTYPES");
            TrinityIndexer.debugOut("Get thesaurus relation types query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            Vector<ThesaurusRelationType> vector = new Vector<ThesaurusRelationType>(1);
            while (databaseConnector.more()) {
                ThesaurusRelationType thesaurusRelationType = new ThesaurusRelationType(databaseConnector.getIntegerField("RelationTypeID"), databaseConnector.getFieldByName("RelationTypeName"), databaseConnector.getFieldByName("RelationTypeAbbr"), databaseConnector.getFieldByName("RelationTypeDesc"));
                vector.add(thesaurusRelationType);
                databaseConnector.next();
            }
            this.thesaurusRelationTypes = vector.toArray(new ThesaurusRelationType[0]);
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering thesaurus relation types:\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.exitError("Error while gathering thesaurus relation types:\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    protected void gatherFieldGroupData() {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Gathering field-group information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT * FROM IRFIELDGROUPS ORDER BY DisplayOrder;");
            databaseConnector.runQuery();
            Vector<TrinityFieldGroup> vector = new Vector<TrinityFieldGroup>();
            TrinityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityFieldGroup trinityFieldGroup = new TrinityFieldGroup();
                    trinityFieldGroup.fieldGroupID = this.getIntegerField(databaseConnector, "FieldGroupID");
                    trinityFieldGroup.displayName = this.getStringField(databaseConnector, "DisplayName");
                    trinityFieldGroup.fieldGroupType = this.getIntegerField(databaseConnector, "FieldGroupType");
                    TrinityIndexer.debugOut("  FieldGroup #" + trinityFieldGroup.fieldGroupID + ": " + trinityFieldGroup.displayName);
                    vector.addElement(trinityFieldGroup);
                    databaseConnector.next();
                }
            } else {
                this.exitError("Cannot gather field-group data from IRFIELDGROUPS table.");
            }
            databaseConnector.close();
            this.fieldGroups = new TrinityFieldGroup[vector.size()];
            for (int i = 0; i < this.fieldGroups.length; ++i) {
                this.fieldGroups[i] = (TrinityFieldGroup)vector.elementAt(i);
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering field-group data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void gatherFieldData() {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Gathering field information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            sqlQueryGenerator.addTable("IRFIELDS", null, "*");
            sqlQueryGenerator.addTable("IRTYPES", null, "*");
            sqlQueryGenerator.addJoin("IRFIELDS", new String[]{"FieldType"}, "IRTYPES", new String[]{"TypeID"}, 0);
            sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            Vector<TrinityIndexerField> vector = new Vector<TrinityIndexerField>();
            TrinityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    int n;
                    int n2;
                    TrinityIndexerField trinityIndexerField = new TrinityIndexerField();
                    trinityIndexerField.fieldID = this.getIntegerField(databaseConnector, "FieldID");
                    trinityIndexerField.displayName = this.getStringField(databaseConnector, "DisplayName");
                    trinityIndexerField.setType(this.getStringField(databaseConnector, "TypeCode"));
                    trinityIndexerField.sourceName = this.getStringField(databaseConnector, "FieldName");
                    trinityIndexerField.searchable = this.getIntegerField(databaseConnector, "KeywordSearchable") == 1;
                    trinityIndexerField.setPreferredFieldName(this.getStringField(databaseConnector, "PreferredFieldName"));
                    try {
                        trinityIndexerField.setHierarchyID(databaseConnector.getIntegerField("HierarchyID"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String string = null;
                    try {
                        string = databaseConnector.getFieldByName("GroupingFieldName");
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                    trinityIndexerField.setGroupingFieldName(string);
                    int n3 = 0;
                    try {
                        n3 = databaseConnector.getIntegerField("GroupingTableID");
                    }
                    catch (Exception exception) {
                        n3 = 0;
                    }
                    for (n2 = 0; n2 < this.tables.length; ++n2) {
                        if (n3 != this.tables[n2].tableID) continue;
                        trinityIndexerField.setGroupingTable(this.tables[n2]);
                        break;
                    }
                    n3 = this.getIntegerField(databaseConnector, "TableID");
                    for (n2 = 0; n2 < this.tables.length; ++n2) {
                        if (n3 != this.tables[n2].tableID) continue;
                        trinityIndexerField.table = this.tables[n2];
                        break;
                    }
                    n2 = 0;
                    trinityIndexerField.joinID = n2 = this.getIntegerField(databaseConnector, "JoinPath");
                    if (n2 > 0) {
                        for (n = 0; n < this.joins.length; ++n) {
                            if (n2 != this.joins[n].joinID) continue;
                            trinityIndexerField.join = this.joins[n];
                            break;
                        }
                    }
                    n = 0;
                    n = this.getIntegerField(databaseConnector, "FieldGroupID");
                    if (n == 0) {
                        TrinityIndexer.debugOut("Error: " + trinityIndexerField.displayName + " has no field-group set!");
                    }
                    for (int i = 0; i < this.fieldGroups.length; ++i) {
                        if (n != this.fieldGroups[i].fieldGroupID) continue;
                        trinityIndexerField.fieldGroup = this.fieldGroups[i];
                        break;
                    }
                    if (trinityIndexerField.fieldGroup != null) {
                        TrinityIndexer.debugOut("  Field #" + trinityIndexerField.fieldID + ": " + trinityIndexerField.displayName + ", field group " + trinityIndexerField.fieldGroup.fieldGroupID);
                    } else {
                        TrinityIndexer.debugOut("  Field #" + trinityIndexerField.fieldID + ": " + trinityIndexerField.displayName + " has no field-group!");
                    }
                    TrinityIndexer.debugOut("    first join: " + trinityIndexerField.join);
                    vector.addElement(trinityIndexerField);
                    databaseConnector.next();
                }
            } else {
                this.exitError("Cannot gather collection data from IRFIELDS table.");
            }
            databaseConnector.close();
            this.fields = new TrinityIndexerField[vector.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = (TrinityIndexerField)vector.elementAt(i);
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering field data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void gatherStopList() {
        try {
            this.stopList = TrinityIndexer.getStopList(this.getDatabaseConnector());
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering field-group data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected TrinityTable getTable(int n) {
        for (int i = 0; this.tables != null && i < this.tables.length; ++i) {
            if (this.tables[i].getTableID() != n) continue;
            return this.tables[i];
        }
        return null;
    }

    protected TrinityJoin getJoin(int n) {
        for (int i = 0; this.joins != null && i < this.joins.length; ++i) {
            if (this.joins[i].joinID != n) continue;
            return this.joins[i];
        }
        return null;
    }

    protected TrinityIndexerField getField(int n) {
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            if (this.fields[i].fieldID != n) continue;
            return this.fields[i];
        }
        return null;
    }

    protected boolean isStopWord(String string) {
        for (int i = 0; string != null && this.stopList != null && i < this.stopList.length; ++i) {
            if (this.stopList[i] == null || !this.stopList[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected ThesaurusRelationType getThesaurusRelationType(int n) {
        for (int i = 0; this.thesaurusRelationTypes != null && i < this.thesaurusRelationTypes.length; ++i) {
            if (this.thesaurusRelationTypes[i].getTypeCode() != n) continue;
            return this.thesaurusRelationTypes[i];
        }
        return null;
    }

    protected ThesaurusRelationType getThesaurusRelationType(String string) {
        for (int i = 0; string != null && this.thesaurusRelationTypes != null && i < this.thesaurusRelationTypes.length; ++i) {
            if (this.thesaurusRelationTypes[i].getAbbreviation() == null || !this.thesaurusRelationTypes[i].getAbbreviation().equalsIgnoreCase(string)) continue;
            return this.thesaurusRelationTypes[i];
        }
        return null;
    }

    protected void setPrimaryObjectTable() {
        if (this.primaryObjectTable == null || this.primaryObjectTable.length() == 0) {
            this.primaryObjectTable = DEFAULT_PRIMARY_OBJECT_TABLE;
            if (this.properties != null) {
                this.primaryObjectTable = this.properties.getProperty("PrimaryObjectTable", DEFAULT_PRIMARY_OBJECT_TABLE);
            }
        }
    }

    protected void setPrimaryObjectKey() {
        if (this.primaryObjectKey == null || this.primaryObjectKey.length() == 0) {
            this.primaryObjectKey = DEFAULT_PRIMARY_OBJECT_KEY;
            if (this.properties != null) {
                this.primaryObjectKey = this.properties.getProperty("PrimaryObjectKey", DEFAULT_PRIMARY_OBJECT_KEY);
            }
        }
    }

    protected boolean findFirstClassOneEntity() {
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].fieldGroup == null || this.fields[i].join != null) continue;
            this.firstClassOneEntity = this.fields[i];
            return true;
        }
        return false;
    }

    protected void doFullIndexing(Integer n) {
        if (!this.indexCancelled) {
            this.doValueIndexing(n);
        }
        if (!this.indexCancelled) {
            this.doTermIndexing(n, true);
        }
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("SQL command execution time: " + TrinityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
    }

    protected void doValueIndexing(Integer n) {
        long l = System.currentTimeMillis();
        this.doValueIndex = true;
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Value indexing for UID: " + n.toString());
        TrinityIndexer.debugOut("");
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        BufferedOutputStream bufferedOutputStream = null;
        BufferedOutputStream bufferedOutputStream2 = null;
        boolean bl = true;
        if (this.doFileLoad) {
            try {
                fileOutputStream = new FileOutputStream(this.loadFilename_VALUES);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.dos_VALUES = new DataOutputStream(bufferedOutputStream);
                fileOutputStream2 = new FileOutputStream(this.loadFilename_VTO);
                bufferedOutputStream2 = new BufferedOutputStream(fileOutputStream2);
                this.dos_VTO = new DataOutputStream(bufferedOutputStream2);
            }
            catch (IOException iOException) {
                this.doFileLoad = false;
                this.exitError("Exception while indexing fields:\n" + InsightUtilities.convertStackTraceToString(iOException));
            }
        }
        this.maxValueID = this.getMaxValueID(true);
        TrinityIndexer.debugOut("Max value ID: " + this.maxValueID);
        TrinityIndexer.debugOut("Time spent getting maxValueID: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
        if (this.progressListener != null) {
            this.progressListener.setBorderTitle("Value Indexing");
            this.progressListener.setValuePb3Maximum(this.selectedFields.length);
        }
        for (int i = 0; i < this.selectedFields.length; ++i) {
            if (!this.indexCancelled) {
                TrinityIndexerField trinityIndexerField;
                if (this.progressListener != null) {
                    this.progressListener.reportTime(System.currentTimeMillis(), this.selectedFields.length);
                    this.progressListener.setValuePb1Value(0);
                    this.progressListener.setValuePb1Maximum(100);
                    this.progressListener.setValuePb2Value(0);
                }
                if (!(trinityIndexerField = this.selectedFields[i]).isProcessed()) {
                    TrinityFieldGroup trinityFieldGroup = trinityIndexerField.fieldGroup;
                    if (trinityFieldGroup != null) {
                        long l2;
                        Object object;
                        MutableLong mutableLong = new MutableLong();
                        long l3 = 0L;
                        int n2 = i * 100 / (this.selectedFields.length + 1 > 0 ? this.selectedFields.length + 1 : 1);
                        int n3 = 100 / (this.selectedFields.length + 1 > 0 ? this.selectedFields.length + 1 : 1);
                        String string = "";
                        string = trinityIndexerField.sourceName;
                        TrinityIndexer.debugOut("  Field: " + string);
                        if (this.progressListener != null) {
                            this.progressListener.setValueIndexingFieldText("" + string);
                        }
                        TreeMap treeMap = new TreeMap();
                        Collection collection = treeMap.values();
                        TrinityValueToIndex trinityValueToIndex = null;
                        boolean bl2 = true;
                        boolean bl3 = true;
                        long l4 = 0L;
                        String string2 = "";
                        String string3 = "";
                        if (!this.indexCancelled) {
                            try {
                                object = this.getDatabaseConnector();
                                String string4 = this.constructFieldQuery(trinityIndexerField);
                                TrinityIndexer.clearDebugOutStay();
                                Debug.debugOutStay("  Querying field values.\r", 3);
                                l2 = System.currentTimeMillis();
                                l3 = TrinityIndexer.getRecordCount((DatabaseConnector)object, string4);
                                TrinityIndexer.debugOut("Total record count: " + l3);
                                TrinityIndexer.debugOut("Time spent getting record count: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
                                l2 = System.currentTimeMillis();
                                object = this.getDatabaseConnector();
                                object.setQuery(string4);
                                object.runQuery();
                                TrinityIndexer.debugOut("Time spent getting records: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
                                TrinityIndexer.clearDebugOutStay();
                                l2 = System.currentTimeMillis();
                                long l5 = 0L;
                                long l6 = 0L;
                                boolean bl4 = false;
                                while (object.more() && !this.indexCancelled) {
                                    String string5;
                                    long l7 = this.getLongField((DatabaseConnector)object, this.primaryObjectKey);
                                    if (trinityIndexerField.preferredFieldName == null || trinityIndexerField.preferredFieldName.length() == 0) {
                                        bl2 = true;
                                    } else {
                                        try {
                                            bl2 = object.getIntegerFieldByName(trinityIndexerField.preferredFieldName) == 1;
                                        }
                                        catch (Exception exception) {
                                            bl2 = true;
                                        }
                                    }
                                    String string6 = "0";
                                    try {
                                        string6 = object.getFieldByName(trinityIndexerField.getGroupingFieldName());
                                        if (string6 == null) {
                                            string6 = "0";
                                        }
                                    }
                                    catch (Exception exception) {
                                        string6 = "0";
                                    }
                                    try {
                                        string5 = object.getFieldByName(trinityIndexerField.sourceName);
                                    }
                                    catch (Exception exception) {
                                        string5 = null;
                                    }
                                    if (!(string5 == null || string5.equals(string2) && l7 == l4 && string6.equals(string3))) {
                                        String string7;
                                        long l8;
                                        long l9;
                                        if (l7 != l4) {
                                            bl4 = false;
                                        }
                                        l4 = l7;
                                        string2 = string5;
                                        string3 = string6;
                                        string5 = string5.trim();
                                        if (trinityIndexerField.fieldType == 3) {
                                            string5 = TrinityIndexer.numeralizeDate(string5) + "";
                                        }
                                        bl3 = false;
                                        if (bl2) {
                                            l9 = System.currentTimeMillis();
                                            if (bl4) {
                                                TrinityIndexer.debugOut("Warning: Object " + l7 + " has more than one preferred value for this field." + "\n     Marking value \"" + string5 + "\" as not preferred.");
                                                bl2 = false;
                                            } else {
                                                bl4 = true;
                                            }
                                            l8 = System.currentTimeMillis() - l9;
                                            l5 += l8;
                                        }
                                        l9 = System.currentTimeMillis();
                                        this.registerValue(treeMap, string5, true, l7, bl2, string6);
                                        if (this.dcMappings != null && !string5.equals(string7 = this.dcMappings.normalize(string5))) {
                                            this.registerValue(treeMap, string7, false, l7, false, string6);
                                        }
                                        l8 = System.currentTimeMillis() - l9;
                                        l6 += l8;
                                    }
                                    if (!this.indexCancelled) {
                                        this.updateValueReadProgress(mutableLong.addToValue(1L), l3, n2, n3, 1, this.maxValueID, this.maxTermID);
                                    }
                                    object.next();
                                }
                                TrinityIndexer.debugOut("Total time spent processing records: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
                                object.close();
                                if (bl3) {
                                    TrinityIndexer.clearDebugOutStay();
                                    TrinityIndexer.debugOut("No values found for this field.");
                                }
                            }
                            catch (Exception exception) {
                                this.exitError("Exception while indexing fields:\n" + InsightUtilities.convertStackTraceToString(exception));
                            }
                        }
                        l3 = 0L;
                        object = collection.iterator();
                        int n4 = 0;
                        while (object.hasNext() && !this.indexCancelled) {
                            trinityValueToIndex = (TrinityValueToIndex)object.next();
                            l3 += (long)trinityValueToIndex.getObjectIDCount();
                            ++n4;
                        }
                        TrinityIndexer.debugOut("Total record count: " + l3);
                        mutableLong.setValue(0L);
                        TrinityIndexer.clearDebugOutStay();
                        if (!this.indexCancelled) {
                            try {
                                l2 = System.currentTimeMillis();
                                object = collection.iterator();
                                n4 = 0;
                                while (object.hasNext()) {
                                    trinityValueToIndex = (TrinityValueToIndex)object.next();
                                    if (this.indexCancelled) break;
                                    if (this.doFileLoad) {
                                        this.writeValueToFile(n, trinityValueToIndex, trinityIndexerField, mutableLong, l3, n2, n3, bl);
                                        bl = false;
                                    } else {
                                        this.writeValue(n, trinityValueToIndex, trinityIndexerField, mutableLong, l3, n2, n3);
                                    }
                                    ++n4;
                                }
                                TrinityIndexer.debugOut("");
                                TrinityIndexer.debugOut("Time spent writing values: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
                            }
                            catch (Exception exception) {
                                this.exitError("Exception while indexing values:\n" + InsightUtilities.getStackTrace(exception));
                            }
                        }
                        if (trinityIndexerField instanceof TrinityIndexerField) {
                            trinityIndexerField.setProcessed(true);
                        }
                        treeMap = null;
                        collection = null;
                    } else {
                        TrinityIndexer.debugOut("Error: field " + trinityIndexerField.sourceName + " has no field-group.");
                    }
                }
            }
            TrinityIndexer.clearDebugOutStay();
            if (this.progressListener == null) continue;
            this.progressListener.setValuePb3Value(i + 1);
        }
        try {
            if (this.dos_VALUES != null) {
                this.dos_VALUES.close();
                this.dos_VALUES = null;
            }
            if (this.dos_VTO != null) {
                this.dos_VTO.close();
                this.dos_VTO = null;
            }
        }
        catch (IOException iOException) {
            this.exitError("Exception while indexing values:\n" + InsightUtilities.getStackTrace(iOException));
        }
        this.sqlBatchController.executeRemainingCommands();
        if (!this.doTermIndex) {
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("SQL command execution time: " + TrinityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
        } else {
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("SQL command execution time so far: " + TrinityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
        }
        if (this.doFileLoad) {
            TrinityIndexer.debugOut("Time spent in value indexing phase before file load: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
            this.generateLoadControlFiles(n, this.loadFilename_VALUES, this.loadFilename_VTO, null, null);
            if (!this.loadedFiles(this.loadFilename_VALUES, this.loadFilename_VTO)) {
                this.exitError("Could not upload files.");
            }
        }
        if (this.progressListener != null) {
            this.progressListener.setValueIndexingFieldText("Completed");
            this.progressListener.setValuePb1Value(100);
            this.progressListener.setValuePb2Value(100);
        }
        TrinityIndexer.debugOut("Time spent in value indexing phase including waits: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
    }

    protected void generateLoadControlFiles(Integer n, String string, String string2, String string3, String string4) {
        String string5 = this.loadFilePathname != null ? InsightUtilities.concatFilepath(this.loadFilePathname, DEFAULT_LOADFILE_NAME) : DEFAULT_LOADFILE_NAME;
        String string6 = null;
        String string7 = "\r\n";
        String string8 = ".cmd";
        String string9 = ".ctl";
        String string10 = "usrid";
        String string11 = "pass";
        TrinityIndexer.debugOut("");
        try {
            if (string6 == null || string6.equalsIgnoreCase("Oracle")) {
                FileWriter fileWriter;
                File file;
                String string12;
                if (string != null) {
                    string12 = string5 + "_VALUES" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITVALUES data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_VALUES" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_VALUES" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITVALUES" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(UniqueCollectionID integer external," + string7 + " ValueID integer external," + string7 + " FieldID integer external," + string7 + " Enabled integer external," + string7 + " ValueNumber float external," + string7 + " ValueText char(4000) OPTIONALLY ENCLOSED BY X'22')" + string7);
                        fileWriter.close();
                    }
                }
                if (string2 != null) {
                    string12 = string5 + "_VALUETOOBJECT" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITVALUETOOBJECT data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_VALUETOOBJECT" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_VALUETOOBJECT" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string2).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITVALUETOOBJECT" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(UniqueCollectionID integer external," + string7 + " ValueID integer external," + string7 + " ObjectID integer external," + string7 + " DisplayOrder integer external," + string7 + " Grouping integer external," + string7 + " Preferred integer external)" + string7);
                        fileWriter.close();
                    }
                }
                if (string3 != null) {
                    string12 = string5 + "_TERMS" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITTERMS data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_TERMS" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_TERMS" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string3).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITTERMS" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(TermID integer external," + string7 + " Keyword char(255) OPTIONALLY ENCLOSED BY X'22')" + string7);
                        fileWriter.close();
                    }
                }
                if (string4 != null) {
                    string12 = string5 + "_TERMOBJECTMAP" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITTERMOBJECTMAP data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_TERMOBJECTMAP" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_TERMOBJECTMAP" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        TrinityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        TrinityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string4).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITTERMOBJECTMAP" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(UniqueCollectionID integer external," + string7 + " TermID integer external," + string7 + " ObjectID integer external," + string7 + " FieldID integer external," + string7 + " Grouping integer external)" + string7);
                        fileWriter.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            TrinityIndexer.debugOut("Got exception creating bulk load scripts");
        }
    }

    protected boolean loadedFiles(String string, String string2) {
        int n = 110;
        int n2 = -1;
        if (!this.indexCancelled) {
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("Files ready for bulk load.\n     Files   " + string + "\n     and     " + string2 + "\n     are ready for bulk upload." + "\n     Please upload the files to the database and check whether" + "\n     the data have been successfully uploaded." + "\n\n     Have the files been successfully uploaded? (y/n)", 1);
            n = 110;
            byte[] byArray = new byte[1];
            try {
                if (this.progressListener != null) {
                    TrinityIndexer.debugOut("Get answer through progressListener.");
                    this.progressListener.pauseTimer();
                    this.progressListener.pauseRemainingTimeTimer();
                    n2 = this.progressListener.showJOptionPaneConfirmDialog("Files   " + string + "\nand     " + string2 + "\nare ready for bulk upload." + "\n\nHave the files been successfully uploaded?", "upload files");
                    if (n2 == 0) {
                        this.progressListener.restartTimer();
                        this.progressListener.restartRemainingTimeTimer();
                    }
                } else {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    while ((n = (int)bufferedReader.readLine().charAt(0)) != 121 && n != 89 && n != 110 && n != 78) {
                        TrinityIndexer.debugOut("Please enter y for Yes or n for No", 1);
                    }
                }
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Got exception reading answer");
            }
        }
        return n == 121 || n2 == 0;
    }

    protected void doTermIndexing(Integer n, boolean bl) {
        long l;
        this.doTermIndex = true;
        long l2 = System.currentTimeMillis();
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Term indexing for UID: " + n.toString());
        TrinityIndexer.debugOut("");
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        BufferedOutputStream bufferedOutputStream = null;
        BufferedOutputStream bufferedOutputStream2 = null;
        boolean bl2 = true;
        if (this.doFileLoad) {
            try {
                fileOutputStream = new FileOutputStream(this.loadFilename_TERMS);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.dos_TERMS = new DataOutputStream(bufferedOutputStream);
                fileOutputStream2 = new FileOutputStream(this.loadFilename_TOM);
                bufferedOutputStream2 = new BufferedOutputStream(fileOutputStream2);
                this.dos_TOM = new DataOutputStream(bufferedOutputStream2);
            }
            catch (IOException iOException) {
                this.doFileLoad = false;
                this.exitError("Exception while indexing fields:\n" + InsightUtilities.convertStackTraceToString(iOException));
            }
        }
        this.maxTermID = this.getMaxTermID(true);
        TrinityIndexer.debugOut("Max term ID:  " + this.maxTermID);
        TrinityIndexer.debugOut("Time spent getting maxTermID: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
        TrinityIndexer.debugOut("");
        try {
            TrinityIndexerField trinityIndexerField = null;
            boolean bl3 = true;
            MutableLong mutableLong = new MutableLong();
            long l3 = 0L;
            MutableLong mutableLong2 = new MutableLong();
            long l4 = 0L;
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            String string = bl ? "ITVALUES" : "DTVALUES";
            String string2 = bl ? "ITVALUETOOBJECT" : "DTVALUETOOBJECT";
            TrinityIndexer.debugOut("Term indexing: valueTable=" + string + ", valueToObjectTable=" + string2);
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            if (this.progressListener != null) {
                this.progressListener.setBorderTitle("Term Indexing");
                this.progressListener.setTermPb3Maximum(this.selectedFields.length);
            }
            for (int i = 0; i < this.selectedFields.length; ++i) {
                if (this.indexCancelled) continue;
                trinityIndexerField = this.selectedFields[i];
                if (trinityIndexerField.isKeywordSearchable() && trinityIndexerField.fieldGroup != null) {
                    TrinityTermToIndex trinityTermToIndex;
                    int n2;
                    TrinityIndexer.clearDebugOutStay();
                    TrinityIndexer.debugOut("  Fields: " + trinityIndexerField.sourceName);
                    if (this.progressListener != null) {
                        if (!this.progressListener.isTimeRemainingEstimated()) {
                            this.progressListener.reportTime(System.currentTimeMillis(), this.selectedFields.length);
                        }
                        this.progressListener.setTermIndexingFieldText("" + trinityIndexerField.sourceName);
                        this.progressListener.setTermPb1Value(0);
                        this.progressListener.setTermPb2Value(0);
                    }
                    bl3 = true;
                    TreeMap treeMap = new TreeMap();
                    Collection collection = treeMap.values();
                    Debug.debugOutStay("  Querying terms.\r", 3);
                    sqlQueryGenerator.clear();
                    sqlQueryGenerator.addTable(string, null, "*");
                    sqlQueryGenerator.addTable(string2, null, new String[]{DEFAULT_PRIMARY_OBJECT_KEY, "Grouping"});
                    sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                    sqlQueryGenerator.addJoin(string2, string, "ValueID", 0);
                    sqlQueryGenerator.addJoin(string, "IRFIELDS", new String[]{"FieldID"}, 0);
                    sqlQueryGenerator.addJoin("IRFIELDS", new String[]{"FieldType"}, "IRTYPES", new String[]{"TypeID"}, 0);
                    sqlQueryGenerator.appendToWhere(string + ".FieldID = " + trinityIndexerField.fieldID);
                    sqlQueryGenerator.appendToWhere(string + ".UniqueCollectionID = " + n);
                    String string3 = sqlQueryGenerator.getQuery();
                    TrinityIndexer.debugOut("Term indexing: Query to get values to parse for terms:");
                    TrinityIndexer.debugOut("  " + string3 + "\n");
                    l = System.currentTimeMillis();
                    l3 = TrinityIndexer.getRecordCount(databaseConnector, string3);
                    TrinityIndexer.debugOut("Term indexing: recordsToRead =" + l3);
                    mutableLong.setValue(0L);
                    databaseConnector.setQuery(string3);
                    databaseConnector.runQuery();
                    TrinityIndexer.clearDebugOutStay();
                    l = System.currentTimeMillis();
                    long l5 = 0L;
                    while (databaseConnector.more()) {
                        String string4;
                        try {
                            if (this.indexCancelled) break;
                            string4 = databaseConnector.getFieldByName(TrinityConnector.getFieldValueName(databaseConnector.getFieldByName("TypeCode")));
                        }
                        catch (Exception exception) {
                            string4 = null;
                        }
                        if (string4 != null) {
                            bl3 = false;
                            string4 = string4.trim();
                            long l6 = databaseConnector.getLongField(DEFAULT_PRIMARY_OBJECT_KEY);
                            String string5 = databaseConnector.getField("Grouping");
                            long l7 = System.currentTimeMillis();
                            try {
                                this.registerTerms(treeMap, TrinityIndexer.parseTerms(string4, this.stopList), l6, trinityIndexerField.fieldID, string5);
                            }
                            catch (Exception exception) {
                                TrinityIndexer.debugOut("Term indexing: Caught exception in registerTerms(): " + InsightUtilities.getStackTrace(exception));
                            }
                            long l8 = System.currentTimeMillis() - l7;
                            l5 += l8;
                        }
                        if (!this.indexCancelled) {
                            this.updateTermReadProgress(mutableLong.addToValue(1L), l3, this.maxTermID);
                        }
                        if (this.indexCancelled) break;
                        databaseConnector.next();
                    }
                    TrinityIndexer.debugOut("Total time spent processing records: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                    databaseConnector.close();
                    if (bl3) {
                        TrinityIndexer.clearDebugOutStay();
                        TrinityIndexer.debugOut("No terms found.");
                    }
                    l4 = 0L;
                    Iterator iterator = null;
                    if (!this.indexCancelled) {
                        iterator = collection.iterator();
                        n2 = 0;
                        while (iterator.hasNext() && !this.indexCancelled) {
                            trinityTermToIndex = (TrinityTermToIndex)iterator.next();
                            l4 += (long)trinityTermToIndex.getEntityIDCount();
                            ++n2;
                        }
                        mutableLong2.setValue(0L);
                    }
                    TrinityIndexer.clearDebugOutStay();
                    TrinityIndexer.debugOut("Term indexing: recordsToWrite=" + l4 + "   ");
                    if (!this.indexCancelled) {
                        try {
                            l = System.currentTimeMillis();
                            iterator = collection.iterator();
                            n2 = 0;
                            while (iterator.hasNext() && !this.indexCancelled) {
                                trinityTermToIndex = (TrinityTermToIndex)iterator.next();
                                if (this.doFileLoad) {
                                    this.writeTermToFile(n, trinityTermToIndex, mutableLong2, l4, bl2);
                                    bl2 = false;
                                } else {
                                    this.writeTerm(n, trinityTermToIndex, mutableLong2, l4);
                                }
                                ++n2;
                            }
                            TrinityIndexer.debugOut("Time spent writing terms: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                        }
                        catch (Exception exception) {
                            this.exitError("Term indexing: Exception while writing terms to database:\n" + InsightUtilities.getStackTrace(exception));
                        }
                        catch (JdbcConnectorError jdbcConnectorError) {
                            String string6 = "";
                            Exception exception = jdbcConnectorError.getRootCause();
                            if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                                string6 = "Problem: " + exception.getMessage() + "\n";
                            }
                            string6 = string6 + "Term indexing: Exception while writing terms to database:\n";
                            this.exitError(string6 + InsightUtilities.getStackTrace(exception));
                        }
                    }
                    treeMap = null;
                    collection = null;
                }
                if (this.progressListener == null) continue;
                this.progressListener.setTermPb3Value(i + 1);
            }
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception while indexing terms:\n" + InsightUtilities.getStackTrace(exception));
        }
        try {
            if (this.dos_TERMS != null) {
                this.dos_TERMS.close();
                this.dos_TERMS = null;
            }
            if (this.dos_TOM != null) {
                this.dos_TOM.close();
                this.dos_TOM = null;
            }
        }
        catch (IOException iOException) {
            this.exitError("Exception while indexing terms:\n" + InsightUtilities.getStackTrace(iOException));
        }
        if (this.doFileLoad) {
            TrinityIndexer.debugOut("Time spent in term indexing phase before file load: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("*** NOTE: Term filtering will start once the files have been uploaded", 1);
            TrinityIndexer.debugOut("");
            this.generateLoadControlFiles(n, null, null, this.loadFilename_TERMS, this.loadFilename_TOM);
            if (!this.loadedFiles(this.loadFilename_TERMS, this.loadFilename_TOM)) {
                this.exitError("Could not upload files.");
            }
        }
        if (!this.indexCancelled) {
            TrinityIndexer.debugOut("Term indexing: telling SqlBatchController to execute any remaining commands.");
            try {
                this.sqlBatchController.executeRemainingCommands();
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Term indexing: Exception executing remaining SQL commands: " + InsightUtilities.getStackTrace(exception));
            }
            l = System.currentTimeMillis();
            this.filterTerms(n);
            TrinityIndexer.debugOut("Time spent filtering terms: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
            TrinityIndexer.clearDebugOutStay();
            if (!this.doValueIndex) {
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("SQL command execution time: " + TrinityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
            }
        }
        if (this.progressListener != null) {
            this.progressListener.setTermIndexingFieldText("Completed");
        }
        TrinityIndexer.debugOut("Time spent in term indexing phase including waits: " + TrinityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
    }

    protected void filterTerms(Integer n) {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Filter terms.");
        if (this.progressListener != null) {
            this.progressListener.setTermIndexingFieldText("Filtering Terms");
        }
        try {
            TrinityTermToFilter trinityTermToFilter;
            boolean bl = true;
            MutableLong mutableLong = new MutableLong();
            long l = 0L;
            MutableLong mutableLong2 = new MutableLong();
            long l2 = 0L;
            boolean bl2 = true;
            String string = bl2 ? "ITTERMS" : "DTTERMS";
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            Debug.debugOutStay("  Querying values.\r", 3);
            sqlQueryGenerator.addTable(string, null, "*");
            sqlQueryGenerator.addOrderBy(string, "TermID");
            String string2 = sqlQueryGenerator.getQuery();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            l = TrinityIndexer.getRecordCount(databaseConnector, string2);
            TrinityIndexer.debugOut("Filter terms: recordsToRead =" + l + "          ");
            TreeMap<String, TrinityTermToFilter> treeMap = new TreeMap<String, TrinityTermToFilter>();
            databaseConnector.setQuery(string2);
            databaseConnector.runQuery();
            TrinityIndexer.clearDebugOutStay();
            while (databaseConnector.more() && !this.indexCancelled) {
                String string3;
                try {
                    string3 = databaseConnector.getFieldByName("Keyword");
                }
                catch (Exception exception) {
                    string3 = null;
                }
                if (string3 != null) {
                    bl = false;
                    string3 = string3.trim();
                    String string4 = string3.toLowerCase();
                    int n2 = databaseConnector.getIntegerField("TermID");
                    trinityTermToFilter = (TrinityTermToFilter)treeMap.get(string4);
                    if (trinityTermToFilter == null) {
                        trinityTermToFilter = new TrinityTermToFilter(n2, string3);
                        treeMap.put(string4, trinityTermToFilter);
                    } else {
                        trinityTermToFilter.addDupeTermID(n2);
                    }
                }
                this.updateTermReadProgress(mutableLong.addToValue(1L), l, this.maxTermID);
                databaseConnector.next();
            }
            databaseConnector.close();
            if (bl) {
                TrinityIndexer.clearDebugOutStay();
                TrinityIndexer.debugOut("No terms found.");
            }
            l2 = 0L;
            Iterator iterator = treeMap.values().iterator();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (iterator.hasNext() && !this.indexCancelled) {
                trinityTermToFilter = (TrinityTermToFilter)iterator.next();
                n3 = trinityTermToFilter.getDupeTermIDCount();
                if (n3 > 0) {
                    n4 += n3;
                    l2 += (long)n3;
                    l2 += (long)n3;
                }
                ++n5;
            }
            TrinityIndexer.debugOut("Filter terms: dupeCount     =" + n4 + "          ");
            TrinityIndexer.debugOut("Filter terms: recordsToWrite=" + l2 + "          ");
            mutableLong2.setValue(0L);
            TrinityIndexer.clearDebugOutStay();
            try {
                iterator = treeMap.values().iterator();
                while (iterator.hasNext() && !this.indexCancelled) {
                    trinityTermToFilter = (TrinityTermToFilter)iterator.next();
                    n3 = trinityTermToFilter.getDupeTermIDCount();
                    if (n3 <= 0) continue;
                    String string5 = "";
                    Iterator iterator2 = trinityTermToFilter.getDupeTermIDs();
                    while (iterator2.hasNext() && !this.indexCancelled) {
                        n5 = (Integer)iterator2.next();
                        if (string5.length() > 0) {
                            string5 = string5 + ", ";
                        }
                        string5 = string5 + n5;
                    }
                    this.sqlBatchController.postSqlCommand("UPDATE ITTERMOBJECTMAP SET TermID = " + trinityTermToFilter.getTermID() + " WHERE TermID IN (" + string5 + ")");
                    this.updateTermWriteProgress(mutableLong2.addToValue(n3), l2, this.maxTermID);
                    this.sqlBatchController.postSqlCommand("DELETE FROM ITTERMS WHERE TermID IN (" + string5 + ")");
                    this.updateTermWriteProgress(mutableLong2.addToValue(n3), l2, this.maxTermID);
                }
            }
            catch (Exception exception) {
                this.exitError("Filter terms: Exception while updating database:\n" + InsightUtilities.getStackTrace(exception));
            }
            treeMap = null;
        }
        catch (Exception exception) {
            this.exitError("Exception while filtering terms:\n" + InsightUtilities.getStackTrace(exception));
        }
        TrinityIndexer.debugOut("Filter terms: telling SqlBatchController to execute any remaining commands.");
        try {
            this.sqlBatchController.executeRemainingCommands();
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Filter terms: Exception caught while executing remaining SQL commands: " + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void registerTerms(Map map, Vector vector, long l, int n, String string) throws Exception {
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            this.registerTerm(map, (String)vector.elementAt(i), l, n, string);
        }
    }

    protected void registerTerm(Map map, String string, long l, int n, String string2) throws Exception {
        if (map != null && string != null && string2 != null) {
            try {
                String string3 = string.toLowerCase();
                TrinityTermToIndex trinityTermToIndex = (TrinityTermToIndex)map.get(string3);
                if (trinityTermToIndex == null) {
                    trinityTermToIndex = new TrinityTermToIndex(string);
                    map.put(string3, trinityTermToIndex);
                }
                trinityTermToIndex.addObjectID(this.preferredEntityTypeID, l, n, string2);
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Caught exception in registerTerm() [term=" + string + "]: " + InsightUtilities.getStackTrace(exception));
                throw exception;
            }
        }
    }

    protected void registerValue(Map map, String string, boolean bl, long l, boolean bl2, String string2) {
        if (map != null && string != null) {
            String string3 = string.toLowerCase() + "-" + bl;
            TrinityValueToIndex trinityValueToIndex = (TrinityValueToIndex)map.get(string3);
            if (trinityValueToIndex == null) {
                trinityValueToIndex = new TrinityValueToIndex(string, false, bl);
                map.put(string3, trinityValueToIndex);
            }
            trinityValueToIndex.addObjectID(l, bl2, string2);
        }
    }

    protected void addValueMapping(Integer n, String string, long l, TrinityField trinityField, String string2, boolean bl, boolean bl2) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        MutableLong mutableLong = new MutableLong(this.maxValueID);
        long l2 = TrinityIndexer.addValueMapping(n, string, l, trinityField.fieldID, trinityField.fieldType, string2, bl, bl2, true, mutableLong, databaseConnector);
        this.maxValueID = mutableLong.getValue();
    }

    protected void removeValueMapping(String string, long l, TrinityField trinityField, String string2, boolean bl) {
        long l2 = 0L;
        String string3 = string.trim();
        if (trinityField.fieldType == 3) {
            string3 = TrinityIndexer.numeralizeDate(string3) + "";
        }
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        boolean bl2 = false;
        if (trinityField.fieldType == 2) {
            databaseConnector.setQuery("SELECT ValueID, ValueNumber FROM ITVALUES WHERE (ValueNumber = " + string3 + " AND FieldID = " + trinityField.fieldID + " AND Enabled = " + (bl ? "1" : "0") + ")");
        } else {
            databaseConnector.setQuery("SELECT ValueID, ValueText FROM ITVALUES WHERE (ValueText = " + TrinityIndexer.prepStringForQuery(string3) + " AND FieldID = " + trinityField.fieldID + " AND Enabled = " + (bl ? "1" : "0") + ")");
        }
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            l2 = this.getLongField(databaseConnector, "ValueID");
            bl2 = true;
        }
        databaseConnector.close();
        if (bl2) {
            databaseConnector.setQuery("DELETE FROM ITVALUETOOBJECT WHERE ObjectID = " + l + " AND ValueID = " + l2 + " AND Grouping = " + string2);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        databaseConnector.close();
    }

    protected void writeValueToFile(Integer n, TrinityValueToIndex trinityValueToIndex, TrinityField trinityField, MutableLong mutableLong, long l, int n2, int n3, boolean bl) throws IOException {
        if (!this.indexCancelled) {
            StringWriter stringWriter;
            StringWriter stringWriter2;
            ++this.maxValueID;
            String string = this.maxValueID + "";
            if (bl) {
                stringWriter2 = new StringWriter();
                CSVLogger.writeFirstRecord(stringWriter2, "UniqueCollectionID");
                CSVLogger.write(stringWriter2, "ValueID");
                CSVLogger.write(stringWriter2, "FieldID");
                CSVLogger.write(stringWriter2, "Enabled");
                CSVLogger.write(stringWriter2, "ValueNumber");
                CSVLogger.write(stringWriter2, "ValueText");
                CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
                this.dos_VALUES.writeBytes(stringWriter2.toString());
            }
            stringWriter2 = new StringWriter();
            CSVLogger.writeFirstRecord(stringWriter2, n);
            CSVLogger.write(stringWriter2, string);
            CSVLogger.write(stringWriter2, trinityField.fieldID + "");
            CSVLogger.write(stringWriter2, trinityValueToIndex.isEnabled() ? "1" : "0");
            if (trinityField.fieldType == 2) {
                CSVLogger.write(stringWriter2, trinityValueToIndex.getValue());
                CSVLogger.write(stringWriter2, null);
            } else {
                CSVLogger.write(stringWriter2, null);
                CSVLogger.write(stringWriter2, trinityValueToIndex.getValue());
            }
            CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
            this.dos_VALUES.writeBytes(stringWriter2.toString());
            stringWriter2 = null;
            this.updateValueWriteProgress(mutableLong.getValue(), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            if (bl) {
                stringWriter = new StringWriter();
                CSVLogger.writeFirstRecord(stringWriter, "UniqueCollectionID");
                CSVLogger.write(stringWriter, "ValueID");
                CSVLogger.write(stringWriter, DEFAULT_PRIMARY_OBJECT_KEY);
                CSVLogger.write(stringWriter, "DisplayOrder");
                CSVLogger.write(stringWriter, "Grouping");
                CSVLogger.write(stringWriter, "Preferred");
                CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
                this.dos_VTO.writeBytes(stringWriter.toString());
                stringWriter = null;
            }
            Iterator iterator = trinityValueToIndex.getObjectIDs();
            while (iterator.hasNext() && !this.indexCancelled) {
                TrinityValueObjectToMap trinityValueObjectToMap = (TrinityValueObjectToMap)iterator.next();
                stringWriter = new StringWriter();
                CSVLogger.writeFirstRecord(stringWriter, n);
                CSVLogger.write(stringWriter, string);
                CSVLogger.write(stringWriter, trinityValueObjectToMap.getObjectID() + "");
                CSVLogger.write(stringWriter, "0");
                CSVLogger.write(stringWriter, trinityValueObjectToMap.getGrouping());
                CSVLogger.write(stringWriter, trinityValueObjectToMap.isPreferred() ? "1" : "0");
                CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
                this.dos_VTO.writeBytes(stringWriter.toString());
                stringWriter = null;
                this.updateValueWriteProgress(mutableLong.addToValue(1L), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            }
        }
    }

    protected void writeValue(Integer n, TrinityValueToIndex trinityValueToIndex, TrinityField trinityField, MutableLong mutableLong, long l, int n2, int n3) {
        if (!this.indexCancelled) {
            ++this.maxValueID;
            String string = this.maxValueID + "";
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueID", 2, stringBuffer2, string);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, trinityField.fieldID + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Enabled", 2, stringBuffer2, trinityValueToIndex.isEnabled() ? "1" : "0");
            if (trinityField.fieldType == 2) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueNumber", 2, stringBuffer2, trinityValueToIndex.getValue());
            } else {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueText", 1, stringBuffer2, trinityValueToIndex.getValue());
            }
            this.sqlBatchController.postSqlCommand("INSERT INTO ITVALUES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.updateValueWriteProgress(mutableLong.getValue(), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            Iterator iterator = trinityValueToIndex.getObjectIDs();
            while (iterator.hasNext() && !this.indexCancelled) {
                TrinityValueObjectToMap trinityValueObjectToMap = (TrinityValueObjectToMap)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueID", 2, stringBuffer2, string);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, DEFAULT_PRIMARY_OBJECT_KEY, 2, stringBuffer2, trinityValueObjectToMap.getObjectID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Grouping", 2, stringBuffer2, trinityValueObjectToMap.getGrouping());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Preferred", 2, stringBuffer2, trinityValueObjectToMap.isPreferred() ? "1" : "0");
                this.sqlBatchController.postSqlCommand("INSERT INTO ITVALUETOOBJECT (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.updateValueWriteProgress(mutableLong.addToValue(1L), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            }
        }
    }

    protected void writeTermToFile(Integer n, TrinityTermToIndex trinityTermToIndex, MutableLong mutableLong, long l, boolean bl) throws IOException {
        StringWriter stringWriter;
        StringWriter stringWriter2;
        ++this.maxTermID;
        String string = this.maxTermID + "";
        if (bl) {
            stringWriter2 = new StringWriter();
            CSVLogger.writeFirstRecord(stringWriter2, "TermID");
            CSVLogger.write(stringWriter2, "Keyword");
            CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
            this.dos_TERMS.writeBytes(stringWriter2.toString());
        }
        stringWriter2 = new StringWriter();
        CSVLogger.writeFirstRecord(stringWriter2, string);
        CSVLogger.write(stringWriter2, trinityTermToIndex.getTerm());
        CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
        this.dos_TERMS.writeBytes(stringWriter2.toString());
        stringWriter2 = null;
        this.updateTermWriteProgress(mutableLong.getValue(), l, this.maxTermID);
        if (bl) {
            stringWriter = new StringWriter();
            CSVLogger.writeFirstRecord(stringWriter, "UniqueCollectionID");
            CSVLogger.write(stringWriter, "TermID");
            CSVLogger.write(stringWriter, DEFAULT_PRIMARY_OBJECT_KEY);
            CSVLogger.write(stringWriter, "FieldID");
            CSVLogger.write(stringWriter, "Grouping");
            CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
            this.dos_TOM.writeBytes(stringWriter.toString());
            stringWriter = null;
        }
        Iterator iterator = trinityTermToIndex.getEntityIDs();
        while (iterator.hasNext() && !this.indexCancelled) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                TrinityTermObjectToMap trinityTermObjectToMap = (TrinityTermObjectToMap)vector.elementAt(i);
                stringWriter = new StringWriter();
                CSVLogger.writeFirstRecord(stringWriter, n);
                CSVLogger.write(stringWriter, string);
                CSVLogger.write(stringWriter, trinityTermObjectToMap.getObjectID() + "");
                CSVLogger.write(stringWriter, trinityTermObjectToMap.getFieldID() + "");
                CSVLogger.write(stringWriter, trinityTermObjectToMap.getGrouping());
                CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
                this.dos_TOM.writeBytes(stringWriter.toString());
                stringWriter = null;
                this.updateTermWriteProgress(mutableLong.addToValue(1L), l, this.maxTermID);
            }
        }
    }

    protected void writeTerm(Integer n, TrinityTermToIndex trinityTermToIndex, MutableLong mutableLong, long l) {
        ++this.maxTermID;
        String string = this.maxTermID + "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGeneratorUtil();
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TermID", 2, stringBuffer2, string);
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Keyword", 1, stringBuffer2, trinityTermToIndex.getTerm());
        this.sqlBatchController.postSqlCommand("INSERT INTO ITTERMS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
        this.updateTermWriteProgress(mutableLong.getValue(), l, this.maxTermID);
        Iterator iterator = trinityTermToIndex.getEntityIDs();
        while (iterator.hasNext() && !this.indexCancelled) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                TrinityTermObjectToMap trinityTermObjectToMap = (TrinityTermObjectToMap)vector.elementAt(i);
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TermID", 2, stringBuffer2, string);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, DEFAULT_PRIMARY_OBJECT_KEY, 2, stringBuffer2, trinityTermObjectToMap.getObjectID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, trinityTermObjectToMap.getFieldID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Grouping", 2, stringBuffer2, trinityTermObjectToMap.getGrouping());
                this.sqlBatchController.postSqlCommand("INSERT INTO ITTERMOBJECTMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.updateTermWriteProgress(mutableLong.addToValue(1L), l, this.maxTermID);
            }
        }
    }

    protected void updateValueReadProgress(long l, long l2, int n, int n2, int n3, long l3, long l4) {
        if (l % 20L == 0L) {
            long l5 = System.currentTimeMillis() - this.startTime;
            int n4 = (int)(l5 / 1000L);
            int n5 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            int n6 = n + n2 * n3 * n5 / 100;
            if (l5 > this.lastTime + 2000L) {
                double d = 0.0;
                int n7 = 0;
                if (n4 > 5) {
                    d = (double)n4 * 100.0 / ((double)n + (double)(n2 * n3 * n5) / 100.0);
                    n7 = (int)d - n4;
                }
                this.elapsedTime = this.elapsedTime(l5);
                this.remainingTime = TrinityIndexer.formatTimeString(n7);
                this.lastTime = l5;
            }
            Debug.debugOutStay("  Reading/indexing values " + l + "val (" + n5 + "%, " + n6 + "%)/" + l3 + "fv/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setValuePb1Value(n5);
            }
        }
    }

    protected void updateValueWriteProgress(long l, long l2, int n, int n2, int n3, long l3, long l4) {
        if (l % 20L == 0L) {
            long l5 = System.currentTimeMillis() - this.startTime;
            int n4 = (int)(l5 / 1000L);
            int n5 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            int n6 = n + n2 * n3 * n5 / 100;
            if (l5 > this.lastTime + 2000L) {
                double d = 0.0;
                int n7 = 0;
                if (n4 > 5) {
                    d = (double)n4 * 100.0 / ((double)n + (double)(n2 * n3 * n5) / 100.0);
                    n7 = (int)d - n4;
                }
                this.elapsedTime = this.elapsedTime(l5);
                this.remainingTime = TrinityIndexer.formatTimeString(n7);
                if (this.progressListener != null) {
                    // empty if block
                }
                this.lastTime = l5;
            }
            Debug.debugOutStay("  Writing values " + l + "rec (" + n5 + "%, " + n6 + "%)/" + l3 + "fv/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setValuePb2Value(n5);
            }
        }
    }

    protected void updateTermReadProgress(long l, long l2, long l3) {
        if (l % 20L == 0L) {
            long l4 = System.currentTimeMillis() - this.startTime;
            int n = (int)(l4 / 1000L);
            int n2 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            if (l4 > this.lastTime + 2000L) {
                double d = 0.0;
                int n3 = 0;
                if (n > 5) {
                    d = n * 100 / (n2 > 0 ? n2 : 1);
                    n3 = (int)d - n;
                }
                this.elapsedTime = this.elapsedTime(l4);
                this.remainingTime = TrinityIndexer.formatTimeString(n3);
                this.lastTime = l4;
            }
            Debug.debugOutStay("  Reading/indexing terms " + l + "val (" + n2 + "%)/" + l3 + "t/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setTermPb1Value(n2 + 1);
            }
        }
    }

    protected void updateTermWriteProgress(long l, long l2, long l3) {
        if (l % 20L == 0L) {
            long l4 = System.currentTimeMillis() - this.startTime;
            int n = (int)(l4 / 1000L);
            int n2 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            if (l4 > this.lastTime + 2000L) {
                double d = 0.0;
                int n3 = 0;
                if (n > 5) {
                    d = n * 100 / (n2 > 0 ? n2 : 1);
                    n3 = (int)d - n;
                }
                this.elapsedTime = this.elapsedTime(l4);
                this.remainingTime = TrinityIndexer.formatTimeString(n3);
                this.lastTime = l4;
            }
            Debug.debugOutStay("  Writing terms " + l + "rec (" + n2 + "%)/" + l3 + "t/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setTermPb2Value(n2 + 1);
            }
        }
    }

    protected void doIncrementalIndexing(Integer n) {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Incremental indexing.");
        TrinityIndexer.debugOut("");
        int n2 = 1;
        if (this.progressListener != null) {
            this.progressListener.setIncrementalIndexingText("Started");
            this.progressListener.setIncrementalPb1Maximum(2 + this.selectedFields.length);
        }
        if (!this.indexCancelled) {
            this.maxValueID = this.getMaxValueID(false);
            TrinityIndexer.debugOut("Max value ID: " + this.maxValueID);
            this.maxTermID = this.getMaxTermID(false);
            TrinityIndexer.debugOut("Max term ID:  " + this.maxTermID);
            TrinityIndexer.debugOut("");
            if (this.progressListener != null) {
                this.progressListener.setIncrementalPb1Value(n2++);
            }
            if (!this.indexCancelled) {
                TrinityIndexer.debugOut("Copy destination tables into temporary tables.");
                TrinityIndexer.debugOut("");
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("INSERT INTO ITTERMOBJECTMAP SELECT Distinct * FROM DTTERMOBJECTMAP WHERE UniqueCollectionID = " + n);
                TrinityIndexer.debugOut("  DTTERMOBJECTMAP -> ITTERMOBJECTMAP.");
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                databaseConnector.setQuery("INSERT INTO ITVALUETOOBJECT SELECT Distinct * FROM DTVALUETOOBJECT WHERE UniqueCollectionID = " + n);
                TrinityIndexer.debugOut("  DTVALUETOOBJECT -> ITVALUETOOBJECT.");
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                databaseConnector.setQuery("INSERT INTO ITTERMS SELECT * FROM DTTERMS");
                TrinityIndexer.debugOut("  DTTERMS -> ITTERMS.");
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                databaseConnector.setQuery("INSERT INTO ITVALUES SELECT * FROM DTVALUES WHERE UniqueCollectionID = " + n);
                TrinityIndexer.debugOut("  DTVALUES -> ITVALUES.");
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                if (this.progressListener != null) {
                    this.progressListener.setIncrementalPb1Value(n2++);
                }
                for (int i = 0; i < this.selectedFields.length && !this.indexCancelled; ++i) {
                    if (this.progressListener != null) {
                        this.progressListener.setIncrementalPb1Value(n2++);
                    }
                    boolean bl = false;
                    Vector<TrinityValueToIndex> vector = new Vector<TrinityValueToIndex>();
                    long l = System.currentTimeMillis();
                    TrinityIndexerField trinityIndexerField = this.selectedFields[i];
                    if (!this.icTables.contains(trinityIndexerField.table)) continue;
                    TrinityIndexer.clearDebugOutStay();
                    TrinityIndexer.debugOut("");
                    TrinityIndexer.debugOut("Field: " + trinityIndexerField.sourceName);
                    TrinityFieldGroup trinityFieldGroup = trinityIndexerField.fieldGroup;
                    if (trinityFieldGroup != null) {
                        Object object;
                        String string;
                        Object object2;
                        Object object3;
                        this.doValueIndex = true;
                        this.doTermIndex = true;
                        int n3 = 0;
                        int n4 = i * 100 / (this.selectedFields.length + 1 > 0 ? this.selectedFields.length + 1 : 1);
                        int n5 = 100 / (this.selectedFields.length + 1 > 0 ? this.selectedFields.length + 1 : 1);
                        try {
                            String string2;
                            long l2;
                            String string3;
                            int n6;
                            int n7;
                            long l3;
                            object3 = this.getDatabaseConnector();
                            object2 = trinityIndexerField.table.name;
                            string = trinityIndexerField.sourceName;
                            String string4 = "";
                            object = "";
                            String string5 = "";
                            String string6 = "";
                            String[] stringArray = this.constructInnerJoin(trinityIndexerField, false);
                            string5 = stringArray[0];
                            string6 = stringArray[1];
                            stringArray = this.constructInnerJoin(trinityIndexerField, true);
                            string4 = stringArray[0];
                            object = stringArray[1];
                            object3.setQuery("DELETE FROM IDTEMPOLD");
                            object3.runUpdateQuery();
                            object3.close();
                            object3.setQuery("DELETE FROM IDTEMPNEW");
                            object3.runUpdateQuery();
                            object3.close();
                            String string7 = "0";
                            String string8 = "0";
                            if (trinityIndexerField.getGroupingFieldName() != null && trinityIndexerField.getGroupingFieldName().length() > 0 && trinityIndexerField.getGroupingTable() != null) {
                                string8 = string7 = trinityIndexerField.getGroupingTable().name + "." + trinityIndexerField.getGroupingFieldName();
                                if (this.icTables.contains(trinityIndexerField.getGroupingTable())) {
                                    string8 = "IC" + string7;
                                }
                            }
                            String string9 = "";
                            string9 = trinityIndexerField.getPreferredFieldName() != null ? trinityIndexerField.getPreferredFieldName() : "1";
                            String string10 = "";
                            boolean bl2 = false;
                            if (trinityIndexerField.fieldType == 3) {
                                string10 = "ValueDate";
                                bl2 = true;
                            } else {
                                string10 = "ValueText";
                            }
                            object3.setQuery("INSERT INTO IDTEMPNEW (ObjectID, ValueText, ValueDate, Grouping, Preferred) SELECT " + this.primaryObjectTable + "." + this.primaryObjectKey + " AS ObjectID, " + (!bl2 ? (String)object2 + "." + string : "NULL") + " AS ValueText, " + (bl2 ? (String)object2 + "." + string : "NULL") + " AS ValueDate, " + string7 + " AS Grouping, " + string9 + " AS Preferred" + " FROM " + string5 + " WHERE ((" + (String)object2 + "." + string + " IS NOT NULL)" + (string6 != null && string6.length() > 0 ? " AND " + string6 : "") + ")" + " ORDER BY " + this.primaryObjectTable + "." + this.primaryObjectKey);
                            Debug.debugOutStay("  Load IDTEMPNEW table.\r", 3);
                            object3.runUpdateQuery();
                            object3.close();
                            object3.setQuery("INSERT INTO IDTEMPOLD (ObjectID, ValueText, ValueDate, Grouping, Preferred) SELECT IC" + this.primaryObjectTable + "." + this.primaryObjectKey + " AS ObjectID, " + (!bl2 ? "IC" + (String)object2 + "." + string : "NULL") + " AS ValueText, " + (bl2 ? "IC" + (String)object2 + "." + string : "NULL") + " AS ValueDate, " + string8 + " AS Grouping, " + string9 + " AS Preferred" + " FROM " + string4 + " WHERE ((" + "IC" + (String)object2 + "." + string + " IS NOT NULL)" + (object != null && ((String)object).length() > 0 ? " AND " + (String)object : "") + ")" + " ORDER BY " + "IC" + this.primaryObjectTable + "." + this.primaryObjectKey);
                            Debug.debugOutStay("  Load IDTEMPOLD table.\r", 3);
                            object3.runUpdateQuery();
                            object3.close();
                            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                            sqlQueryGenerator.addTable("IDTEMPOLD", null, new String[]{DEFAULT_PRIMARY_OBJECT_KEY, string10, "Grouping", "Preferred"});
                            sqlQueryGenerator.addJoin("IDTEMPNEW", "IDTEMPOLD", new String[]{DEFAULT_PRIMARY_OBJECT_KEY, string10, "Grouping", "Preferred"}, 2);
                            sqlQueryGenerator.appendToWhere("IDTEMPNEW.ObjectID IS NULL");
                            object3.setQuery(sqlQueryGenerator.getQuery());
                            Debug.debugOutStay("  Query removed values.\r", 3);
                            object3.runQuery();
                            if (object3.more()) {
                                TrinityIndexer.clearDebugOutStay();
                                TrinityIndexer.debugOut("  Found removed values.");
                                l3 = System.currentTimeMillis();
                                n7 = TrinityIndexer.getRecordCount(this.getDatabaseConnector(), object3.getQuery());
                                n6 = 0;
                                while (!this.indexCancelled && object3.more()) {
                                    String string11;
                                    ++n6;
                                    l = System.currentTimeMillis();
                                    bl = true;
                                    string3 = this.getStringField((DatabaseConnector)object3, string10).trim();
                                    l2 = this.getLongField((DatabaseConnector)object3, DEFAULT_PRIMARY_OBJECT_KEY);
                                    string2 = this.getStringField((DatabaseConnector)object3, "Grouping");
                                    if (System.currentTimeMillis() - this.incrementalLastTime > 200L) {
                                        this.incrementalLastTime = System.currentTimeMillis();
                                        this.updateProgressIncrementalValue(n6, n7, string3, l3);
                                    }
                                    TrinityValueToIndex trinityValueToIndex = new TrinityValueToIndex(string3, true, true);
                                    trinityValueToIndex.addObjectID(l2, true, string2);
                                    vector.addElement(trinityValueToIndex);
                                    this.removeValueMapping(string3, l2, trinityIndexerField, string2, true);
                                    if (this.dcMappings != null && trinityIndexerField.fieldType == 1 && !string3.equals(string11 = this.dcMappings.normalize(string3))) {
                                        trinityValueToIndex = new TrinityValueToIndex(string11, true, false);
                                        trinityValueToIndex.addObjectID(l2, true, string2);
                                        vector.addElement(trinityValueToIndex);
                                        this.removeValueMapping(string11, l2, trinityIndexerField, string2, false);
                                    }
                                    object3.next();
                                }
                            }
                            object3.close();
                            TrinityIndexer.clearDebugOutStay();
                            if (!this.indexCancelled) {
                                sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                                sqlQueryGenerator.addTable("IDTEMPNEW", null, new String[]{DEFAULT_PRIMARY_OBJECT_KEY, string10, "Grouping", "Preferred"});
                                sqlQueryGenerator.addJoin("IDTEMPNEW", "IDTEMPOLD", new String[]{DEFAULT_PRIMARY_OBJECT_KEY, string10, "Grouping", "Preferred"}, 1);
                                sqlQueryGenerator.appendToWhere("IDTEMPOLD.ObjectID IS NULL");
                                object3.setQuery(sqlQueryGenerator.getQuery());
                                Debug.debugOutStay("  Query added values.\r", 3);
                                object3.runQuery();
                                if (object3.more()) {
                                    TrinityIndexer.clearDebugOutStay();
                                    TrinityIndexer.debugOut("  Found added values.");
                                    l3 = System.currentTimeMillis();
                                    n7 = TrinityIndexer.getRecordCount(this.getDatabaseConnector(), object3.getQuery());
                                    n6 = 0;
                                    while (!this.indexCancelled && object3.more()) {
                                        String string12;
                                        ++n6;
                                        l = System.currentTimeMillis();
                                        bl = true;
                                        string3 = this.getStringField((DatabaseConnector)object3, string10).trim();
                                        l2 = object3.getLongField(DEFAULT_PRIMARY_OBJECT_KEY);
                                        string2 = this.getStringField((DatabaseConnector)object3, "Grouping");
                                        if (System.currentTimeMillis() - this.incrementalLastTime > 200L) {
                                            this.incrementalLastTime = System.currentTimeMillis();
                                            this.updateProgressIncrementalValue(n6, n7, string3, l3);
                                        }
                                        boolean bl3 = true;
                                        int n8 = 0;
                                        int n9 = 0;
                                        DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
                                        databaseConnector2.setQuery("SELECT COUNT(*) AS PrefCount FROM ITVALUES, ITVALUETOOBJECT WHERE ITVALUES.ValueID = ITVALUETOOBJECT.ValueID AND ITVALUES.FieldID = " + trinityIndexerField.fieldID + " AND " + "ITVALUETOOBJECT" + ".ObjectID = " + l2 + " AND " + "ITVALUETOOBJECT" + ".Preferred = 1");
                                        databaseConnector2.runQuery();
                                        if (databaseConnector2.more()) {
                                            try {
                                                n8 = databaseConnector2.getIntegerField("PrefCount");
                                            }
                                            catch (Exception exception) {
                                                TrinityIndexer.debugOut("Exception counting preferred values:\n" + InsightUtilities.getStackTrace(exception));
                                            }
                                        }
                                        databaseConnector2.close();
                                        if (trinityIndexerField.getPreferredFieldName() != null && trinityIndexerField.getPreferredFieldName().length() > 0) {
                                            bl3 = this.getIntegerField((DatabaseConnector)object3, trinityIndexerField.getPreferredFieldName()) == 1;
                                            databaseConnector2.setQuery("SELECT COUNT(*) AS PrefCount FROM " + string5 + " WHERE " + this.primaryObjectTable + "." + this.primaryObjectKey + " = " + l2 + " AND " + trinityIndexerField.getPreferredFieldName() + " = 1" + (string6 != null && string6.length() > 0 ? " AND " + string6 : ""));
                                            databaseConnector2.runQuery();
                                            if (databaseConnector2.more()) {
                                                try {
                                                    n9 = databaseConnector2.getIntegerField("PrefCount");
                                                }
                                                catch (Exception exception) {
                                                    TrinityIndexer.debugOut("Exception counting new preferred values:\n" + InsightUtilities.getStackTrace(exception));
                                                }
                                            }
                                            databaseConnector2.close();
                                        }
                                        if (n8 == 0 && n9 == 0) {
                                            bl3 = true;
                                        } else if (n8 > 0 && bl3) {
                                            TrinityIndexer.clearDebugOutStay();
                                            TrinityIndexer.debugOut("Warning: Object " + l2 + " has more than one preferred value for this field." + "\n     Marking value \"" + string3 + "\" as not preferred.");
                                            bl3 = false;
                                        }
                                        TrinityValueToIndex trinityValueToIndex = new TrinityValueToIndex(string3, false, true);
                                        trinityValueToIndex.addObjectID(l2, bl3, string2);
                                        vector.addElement(trinityValueToIndex);
                                        this.addValueMapping(n, string3, l2, trinityIndexerField, string2, bl3, true);
                                        if (this.dcMappings != null && trinityIndexerField.fieldType == 1 && !string3.equals(string12 = this.dcMappings.normalize(string3))) {
                                            trinityValueToIndex = new TrinityValueToIndex(string12, false, false);
                                            trinityValueToIndex.addObjectID(l2, bl3, string2);
                                            vector.addElement(trinityValueToIndex);
                                            this.addValueMapping(n, string12, l2, trinityIndexerField, string2, false, false);
                                        }
                                        object3.next();
                                    }
                                }
                            }
                            object3.close();
                            TrinityIndexer.clearDebugOutStay();
                        }
                        catch (Exception exception) {
                            this.exitError("Exception while incrementally indexing fields:\n" + InsightUtilities.convertStackTraceToString(exception));
                        }
                        if (trinityIndexerField.isKeywordSearchable() && vector.size() > 0) {
                            TrinityIndexer.clearDebugOutStay();
                            TrinityIndexer.debugOut("  Indexing terms.");
                            for (int j = 0; j < vector.size() && !this.indexCancelled; ++j) {
                                ++n3;
                                try {
                                    object3 = (TrinityValueToIndex)vector.elementAt(j);
                                    if (object3 == null || (string = ((TrinityValueToIndex)object3).getValue()) == null || string.length() <= 0) continue;
                                    string = string.toLowerCase();
                                    object2 = ((TrinityValueToIndex)object3).getObjectIDs();
                                    while (object2.hasNext() && !this.indexCancelled) {
                                        object = (TrinityValueObjectToMap)object2.next();
                                        this.parseKeywords(n, ((TrinityValueObjectToMap)object).getObjectID(), string, trinityIndexerField, ((TrinityValueObjectToMap)object).getGrouping(), ((TrinityValueToIndex)object3).removal, n3, vector.size());
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    this.exitError("Exception while incrementally indexing values:\n" + InsightUtilities.convertStackTraceToString(exception));
                                }
                            }
                        }
                        if (bl) continue;
                        TrinityIndexer.clearDebugOutStay();
                        TrinityIndexer.debugOut("  No changes found.");
                        continue;
                    }
                    TrinityIndexer.debugOut("Error: field " + trinityIndexerField.sourceName + " has no field-group.");
                }
            }
        }
        if (this.progressListener != null) {
            this.progressListener.setIncrementalIndexingText("Completed");
        }
    }

    protected void updateProgressIncrementalValue(int n, int n2, String string, long l) {
        String string2 = string;
        if (string2.length() > 28) {
            string2 = string2.substring(0, 28);
            string2 = string2.concat("...");
        }
        int n3 = n * 100 / (n2 > 0 ? n2 : 1);
        long l2 = System.currentTimeMillis() - l;
        int n4 = (int)(l2 / 1000L);
        double d = 0.0;
        int n5 = 0;
        if (n4 > 1) {
            d = (double)n4 / (double)n3 * 100.0;
            n5 = (int)d - n4;
        } else {
            d = 0.0;
            n5 = 0;
        }
        String string3 = this.elapsedTime(l2);
        String string4 = TrinityIndexer.formatTimeString(n5);
        TrinityIndexer.clearDebugOutStay();
        Debug.debugOutStay("  Progress: " + n3 + "%   " + string3 + "e/" + string4 + "r, value: " + string2 + "\r", 3);
    }

    protected void updateProgressIncrementalTerm(long l, long l2, String string) {
        String string2 = string;
        if (string2.length() > 28) {
            string2 = string2.substring(0, 28);
            string2 = string2.concat("...");
        }
        long l3 = System.currentTimeMillis() - this.startTime;
        int n = (int)(l3 / 1000L);
        int n2 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
        double d = 0.0;
        int n3 = 0;
        if (n > 1) {
            d = (double)n / (double)n2 * 100.0;
            n3 = (int)d - n;
        } else {
            d = 0.0;
            n3 = 0;
        }
        String string3 = this.elapsedTime(l3);
        String string4 = TrinityIndexer.formatTimeString(n3);
        this.lastTime = l3;
        TrinityIndexer.clearDebugOutStay();
        Debug.debugOutStay("  Progress: " + n2 + "%   " + string3 + "e/" + string4 + "r, term: " + string2 + "\r", 3);
    }

    protected void parseKeywords(Integer n, long l, String string, TrinityField trinityField, String string2, boolean bl, long l2, long l3) {
        this.parseKeywords(n, l, string, trinityField, string2, bl, l2, l3, 0, 0);
    }

    protected void parseKeywords(Integer n, long l, String string, TrinityField trinityField, String string2, boolean bl, long l2, long l3, int n2, int n3) {
        Vector vector = TrinityIndexer.parseTerms(string, this.stopList);
        for (int i = 0; i < vector.size(); ++i) {
            MutableLong mutableLong;
            String string3 = (String)vector.elementAt(i);
            if (this.doFullIndex) {
                this.updateProgress(l2, l3, n2, n3, 1, this.maxValueID, this.maxTermID);
            }
            if (this.doFullIndex) {
                mutableLong = new MutableLong(this.maxTermID);
                TrinityIndexer.addTermMapping(n, string3, l, trinityField.getFieldID(), string2, false, true, mutableLong, this.getDatabaseConnector());
                this.maxTermID = mutableLong.getValue();
                this.updateProgress(l2, l3, n2, n3, 1, this.maxValueID, this.maxTermID);
                continue;
            }
            mutableLong = new MutableLong(this.maxTermID);
            TrinityIndexer.addTermMapping(n, string3, l, trinityField.getFieldID(), string2, bl, true, mutableLong, this.getDatabaseConnector());
            this.maxTermID = mutableLong.getValue();
            if (System.currentTimeMillis() - this.incrementalLastTime <= 200L) continue;
            this.incrementalLastTime = System.currentTimeMillis();
            this.updateProgressIncrementalTerm(l2, l3, string3);
        }
    }

    protected void doHierarchyIndexing(Integer n, boolean bl) {
        String string;
        TrinityHierarchy trinityHierarchy;
        int n2;
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("Hierarchy generation.");
        TrinityIndexer.debugOut("");
        this.gatherHierarchyData();
        this.gatherThesaurusRelationTypes();
        if (this.progressListener != null) {
            this.progressListener.setBorderTitle("Hierarchy Indexing");
            this.progressListener.setHierarchyStatusText("Started");
            this.progressListener.setHierarchyPb1Maximum(this.hierarchies != null ? this.hierarchies.length : 0);
            this.progressListener.setHierarchyPb1Value(0);
            this.progressListener.setHierarchyPb2Maximum(this.hierarchies != null ? this.hierarchies.length : 0);
            this.progressListener.setHierarchyPb2Value(0);
            this.progressListener.setHierarchyPb3Maximum(this.hierarchies != null ? this.hierarchies.length : 0);
            this.progressListener.setHierarchyPb3Value(0);
        }
        if (this.hierarchies == null || this.hierarchies.length == 0) {
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("No hierarchies to generate.");
            TrinityIndexer.debugOut("");
        }
        for (n2 = 0; !this.indexCancelled && this.hierarchies != null && n2 < this.hierarchies.length; ++n2) {
            trinityHierarchy = this.hierarchies[n2];
            this.processHierarchy(trinityHierarchy);
            trinityHierarchy.clearHierarchyNodes();
            if (this.progressListener == null) continue;
            this.progressListener.setHierarchyPb2Value(n2 + 1);
        }
        if (this.progressListener != null) {
            this.progressListener.setHierarchyPb3Maximum(this.hierarchies != null ? this.hierarchies.length : 0);
            this.progressListener.setHierarchyPb3Value(1);
        }
        for (n2 = 0; !this.indexCancelled && this.hierarchies != null && n2 < this.hierarchies.length; ++n2) {
            trinityHierarchy = this.hierarchies[n2];
            this.createHierarchyMappings(n, trinityHierarchy, bl);
            if (this.progressListener == null) continue;
            this.progressListener.setHierarchyPb3Value(n2 + 1);
        }
        if (this.progressListener != null) {
            this.progressListener.setHierarchyStatusText("Completed");
        }
        if (this.progressListener != null && !(string = this.progressListener.getHierarchyStatusText()).equals("Completed")) {
            this.progressListener.setHierarchyStatusText("Cancelled");
        }
    }

    protected void processHierarchy(TrinityHierarchy trinityHierarchy) {
        TrinityIndexer.clearDebugOutStay();
        if (trinityHierarchy != null) {
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("  Processing hierarchy: " + trinityHierarchy.getHierarchyName());
            TrinityIndexer.debugOut("");
            if (trinityHierarchy.getTermsTable() == null) {
                TrinityIndexer.debugOut("Terms table is not defined -> terms table ID: " + trinityHierarchy.getTermsTableID());
                return;
            }
            if (trinityHierarchy.getRelationsTable() == null) {
                TrinityIndexer.debugOut("Term relationships table is not defined -> term relations table ID: " + trinityHierarchy.getRelationsTableID());
                return;
            }
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                Object object;
                ThesaurusRelationType thesaurusRelationType;
                TrinityHierarchyNode trinityHierarchyNode;
                int n;
                int n2;
                Object object2;
                SqlQueryGenerator sqlQueryGenerator;
                if (trinityHierarchy.getHierarchyNodes() == null || trinityHierarchy.getHierarchyNodes().size() == 0) {
                    TrinityIndexer.clearDebugOutStay();
                    TrinityIndexer.debugOut("  Fetching lexicon.");
                    sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                    sqlQueryGenerator.addTable(trinityHierarchy.getTermsTable().getTableName(), new String[]{trinityHierarchy.getTermIDColumnName(), trinityHierarchy.getTermColumnName()});
                    if (trinityHierarchy.getHierarchyIDColumnName() != null && trinityHierarchy.getHierarchyIDColumnName().length() > 0) {
                        sqlQueryGenerator.appendToWhere(trinityHierarchy.getHierarchyIDColumnName() + " = " + trinityHierarchy.getHierarchyID());
                    }
                    object2 = sqlQueryGenerator.getQuery();
                    n2 = 0;
                    n = TrinityIndexer.getRecordCount(databaseConnector, (String)object2);
                    databaseConnector.setQuery((String)object2);
                    TrinityIndexer.debugOut("Get hierarchy terms query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    while (!this.indexCancelled && databaseConnector.more()) {
                        trinityHierarchyNode = new TrinityHierarchyNode();
                        trinityHierarchyNode.hierarchyID = trinityHierarchy.getHierarchyID();
                        trinityHierarchyNode.termID = databaseConnector.getIntegerField(trinityHierarchy.getTermIDColumnName());
                        trinityHierarchyNode.term = databaseConnector.getStringField(trinityHierarchy.getTermColumnName());
                        trinityHierarchyNode.term = trinityHierarchyNode.term == null ? "" : trinityHierarchyNode.term.trim();
                        trinityHierarchy.addHierarchyNode(trinityHierarchyNode);
                        this.updateProgress(System.currentTimeMillis() - this.startTime, ++n2, n, "  Reading hierarchy term (" + n2 + " / " + n + ") ", "");
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                }
                TrinityIndexer.clearDebugOutStay();
                if (trinityHierarchy.getHierarchyNodes() != null && trinityHierarchy.getHierarchyNodes().size() > 0) {
                    TrinityIndexer.clearDebugOutStay();
                    TrinityIndexer.debugOut("  Fetching lexicon relationships.");
                    sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                    sqlQueryGenerator.addTable(trinityHierarchy.getRelationsTable().getTableName(), new String[]{trinityHierarchy.getRelTermID1ColumnName(), trinityHierarchy.getRelTermID2ColumnName()});
                    if (trinityHierarchy.isAnsiCompliant() && (object2 = sqlQueryGenerator.getTableByTableName(trinityHierarchy.getRelationsTable().getTableName())) != null) {
                        ((SqlTable)object2).addColumnSelection(trinityHierarchy.getRelationTypeColumnName());
                    }
                    if (trinityHierarchy.getHierarchyIDColumnName() != null && trinityHierarchy.getHierarchyIDColumnName().length() > 0) {
                        sqlQueryGenerator.appendToWhere(trinityHierarchy.getHierarchyIDColumnName() + " = " + trinityHierarchy.getHierarchyID());
                    }
                    object2 = sqlQueryGenerator.getQuery();
                    n2 = 0;
                    n = TrinityIndexer.getRecordCount(databaseConnector, (String)object2);
                    databaseConnector.setQuery((String)object2);
                    TrinityIndexer.debugOut("Get term relationships query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuerySafe();
                    thesaurusRelationType = this.getThesaurusRelationType(4);
                    object = null;
                    while (!this.indexCancelled && databaseConnector.more()) {
                        if (trinityHierarchy.isAnsiCompliant()) {
                            thesaurusRelationType = this.getThesaurusRelationType(databaseConnector.getStringField(trinityHierarchy.getRelationTypeColumnName()));
                        }
                        if (thesaurusRelationType != null) {
                            object = this.getThesaurusRelationType(ThesaurusRelationType.getInverseTypeCode(thesaurusRelationType.getTypeCode()));
                        }
                        trinityHierarchy.addNodeRelationship(databaseConnector.getIntegerField(trinityHierarchy.getRelTermID1ColumnName()), databaseConnector.getIntegerField(trinityHierarchy.getRelTermID2ColumnName()), thesaurusRelationType, (ThesaurusRelationType)object);
                        this.updateProgress(System.currentTimeMillis() - this.startTime, ++n2, n, "  Reading term relationship (" + n2 + " / " + n + ") ", "");
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                }
                if ((object2 = trinityHierarchy.getHierarchyNodes()) != null) {
                    TrinityIndexer.clearDebugOutStay();
                    TrinityIndexer.debugOut("  Assembling parent/child relationships.");
                    Collections.sort(object2);
                    n2 = 0;
                    for (n = 0; !this.indexCancelled && n < object2.size(); ++n) {
                        trinityHierarchyNode = (TrinityHierarchyNode)object2.get(n);
                        if (trinityHierarchyNode.getParent() != null) continue;
                        n2 = trinityHierarchyNode.setHierarchyNodesIndices(n2, 0);
                    }
                    TrinityIndexer.debugOut("  Writing hierarchy nodes.");
                    SqlQueryGenerator sqlQueryGenerator2 = TrinityIndexer.getQueryGeneratorUtil();
                    for (int i = 0; !this.indexCancelled && object2 != null && i < object2.size(); ++i) {
                        trinityHierarchyNode = (TrinityHierarchyNode)object2.get(i);
                        this.updateProgress(System.currentTimeMillis() - this.startTime, i + 1, object2.size(), "  Inserting node (" + (i + 1) + " / " + object2.size() + ")", "");
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "HierarchyID", 2, stringBuffer2, trinityHierarchyNode.hierarchyID);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "HierarchyIndex", 2, stringBuffer2, trinityHierarchyNode.hierarchyIndex);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ValueID", 2, stringBuffer2, trinityHierarchyNode.termID);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ValueText", 1, stringBuffer2, trinityHierarchyNode.term);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Parent", 2, stringBuffer2, trinityHierarchyNode.parentIndex);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "StartOfChildren", 2, stringBuffer2, trinityHierarchyNode.start);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "EndOfChildren", 2, stringBuffer2, trinityHierarchyNode.end);
                        databaseConnector.setQuery("INSERT INTO ITHIERARCHYNODES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                        Iterator iterator = trinityHierarchyNode.getRelationTypes();
                        int n3 = 0;
                        while (iterator.hasNext()) {
                            thesaurusRelationType = (ThesaurusRelationType)iterator.next();
                            object = trinityHierarchyNode.getRelatives(thesaurusRelationType);
                            for (int j = 0; object != null && j < object.size(); ++j) {
                                TrinityHierarchyNode trinityHierarchyNode2 = (TrinityHierarchyNode)object.get(j);
                                ++n3;
                                stringBuffer = new StringBuffer();
                                stringBuffer2 = new StringBuffer();
                                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "HierarchyID", 2, stringBuffer2, trinityHierarchyNode.hierarchyID);
                                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "HierarchyIndex", 2, stringBuffer2, trinityHierarchyNode.hierarchyIndex);
                                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "RelHierarchyIndex", 2, stringBuffer2, trinityHierarchyNode2.hierarchyIndex);
                                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "RelationTypeID", 2, stringBuffer2, thesaurusRelationType.getRelationTypeID());
                                databaseConnector.setQuery("INSERT INTO ITHIERARCHYNODERELATIONS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                                databaseConnector.runUpdateQuerySafe();
                                databaseConnector.close();
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in processHierarchy():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                TrinityIndexer.debugOut("Error in processHierarchy():\n" + InsightUtilities.getStackTrace(error));
            }
            TrinityIndexer.clearDebugOutStay();
            databaseConnector.close();
        }
    }

    protected void createHierarchyMappings(Integer n, TrinityHierarchy trinityHierarchy, boolean bl) {
        TrinityIndexer.clearDebugOutStay();
        if (trinityHierarchy != null) {
            TrinityIndexer.debugOut("  Map hierarchy " + trinityHierarchy.getHierarchyName() + " to objects.");
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                String string = bl ? "ITVALUES" : "DTVALUES";
                String string2 = bl ? "ITVALUETOOBJECT" : "DTVALUETOOBJECT";
                Vector vector = new Vector();
                TrinityIndexer.debugOut("  Finding associated fields.");
                Vector<TrinityIndexerField> vector2 = new Vector<TrinityIndexerField>(0);
                Vector<Integer> vector3 = new Vector<Integer>(0);
                for (int i = 0; i < this.fields.length; ++i) {
                    if (this.fields[i].getHierarchyID() != trinityHierarchy.getHierarchyID()) continue;
                    vector2.add(this.fields[i]);
                    vector3.add(new Integer(this.fields[i].getFieldID()));
                }
                if (vector3.size() == 0) {
                    TrinityIndexer.debugOut("  No fields associated to hierarchy " + trinityHierarchy.getHierarchyName());
                } else {
                    SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                    sqlQueryGenerator.addTable(string2, null, new String[]{"ObjectID AS ObjectID"});
                    sqlQueryGenerator.addTable("ITHIERARCHYNODES", null, new String[]{"HierarchyID AS HierarchyID", "HierarchyIndex AS HierarchyIndex"});
                    sqlQueryGenerator.addJoin(string2, string, "ValueID", 0);
                    sqlQueryGenerator.addJoin(string, "IRFIELDS", new String[]{"FieldID"}, 0);
                    sqlQueryGenerator.addJoin("IRFIELDS", new String[]{"FieldType"}, "IRTYPES", new String[]{"TypeID"}, 0);
                    sqlQueryGenerator.addJoin(string, "ITHIERARCHYNODES", "ValueText", 0);
                    sqlQueryGenerator.appendToWhere(string + ".FieldID IN (" + InsightUtilities.getListString(vector3) + ")");
                    String string3 = sqlQueryGenerator.getQuery();
                    databaseConnector.setQuery("INSERT INTO ITHIERARCHYTOOBJECT (ObjectID, HierarchyID, HierarchyIndex) " + string3);
                    TrinityIndexer.debugOut("Insert hierarchy-to-object mappings command:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                }
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in createHierarchyMappings():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                TrinityIndexer.debugOut("Error in createHierarchyMappings():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        TrinityIndexer.clearDebugOutStay();
    }

    protected void updateLiveCaches() {
        if (this.progressListener != null) {
            this.progressListener.setBorderTitle("Update Thumbnail Cache Indexing");
            this.progressListener.setUpdateStatusText("Started");
            this.progressListener.setUtcPb1Maximum(5);
        }
        if (!this.indexCancelled) {
            TrinityIndexer.clearBrowserFieldsCache();
            TrinityCollectionInfo trinityCollectionInfo = new TrinityCollectionInfo(this.serverAddress, this.serverPort);
            trinityCollectionInfo.setUniqueCollectionID(this.uniqueCollectionID);
            InsightSmartClient insightSmartClient = new InsightSmartClient(trinityCollectionInfo);
            if (insightSmartClient.areConnectionsGood()) {
                if (!this.indexCancelled) {
                    InsightVersion insightVersion = insightSmartClient.getServerVersion();
                    if (!this.indexCancelled && InsightVersion.compareVersions(insightVersion, new InsightVersion(3, 10, 12), 7)) {
                        boolean bl = insightSmartClient.rebuildFsmAndThumbCache(false, null);
                        if (this.progressListener != null) {
                            if (bl) {
                                this.progressListener.setUpdateStatusText("Completed - Server rebuilding live caches.");
                                this.progressListener.setUtcPb1Value(5);
                            } else {
                                this.progressListener.setUpdateStatusText("Server busy rebuilding live caches from earlier request.");
                                this.progressListener.setUtcPb1Value(5);
                            }
                        }
                    } else if (!this.indexCancelled && this.progressListener != null) {
                        this.progressListener.setUpdateStatusText("Server version is " + insightVersion + " and not compatible with update live caches.");
                        this.progressListener.setUtcPb1Value(0);
                    }
                }
            } else if (this.progressListener != null) {
                this.progressListener.setUpdateStatusText("Could not contact collection server.");
                this.progressListener.setUtcPb1Value(0);
            }
            insightSmartClient.closeConnections();
        }
    }

    protected void doFuzzyDateIndexing(Integer n) {
        if (!this.indexCancelled) {
            Object object;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String[] stringArray = new String[]{"ValueDate_Start", "ValueDate_End"};
            boolean bl = SqlQueryGenerator.doesColumnExist(databaseConnector, stringArray, "DTVALUES");
            TrinityIndexer.debugOut("columnsExist value: " + bl);
            databaseConnector.close();
            if (bl) {
                object = this.getDatabaseConnector();
                String string = "SELECT COUNT( DTVALUES.ValueID ) AS RecordCount FROM DTVALUES, IRTYPES, IRFIELDS WHERE DTVALUES.FieldID = IRFIELDS.FieldID AND IRFIELDS.FieldType = IRTYPES.TypeID AND IRFIELDS.IsDate = 1 AND DTVALUES.UniqueCollectionID = " + n;
                object.setQuery(string);
                object.runQuery();
                int n2 = 0;
                try {
                    n2 = object.getIntegerFieldByName("RecordCount");
                }
                catch (Exception exception) {
                    n2 = 0;
                }
                int n3 = 1;
                object.close();
                if (this.progressListener != null) {
                    this.progressListener.setBorderTitle("Fuzzy Date Indexing");
                    this.progressListener.setFdPb1Maximum(n2);
                    this.progressListener.setFdIndexingStatusText("Started");
                }
                DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "SELECT DTVALUES.ValueID, DTVALUES.ValueText, DTVALUES.ValueNumber, IRTYPES.TypeCode FROM DTVALUES, IRTYPES, IRFIELDS WHERE DTVALUES.FieldID = IRFIELDS.FieldID AND IRFIELDS.FieldType = IRTYPES.TypeID AND IRFIELDS.IsDate = 1 AND DTVALUES.UniqueCollectionID = " + n;
                TrinityIndexer.debugOut(string6);
                databaseConnector2.setQuery(string6);
                databaseConnector2.runQuery();
                TrinityIndexer.debugOut("valuesQuery.more() is: " + databaseConnector2.more());
                if (databaseConnector2.more()) {
                    UcbFuzzyDateMachine.setFZDebugFilename(FZ_DEBUG_FILENAME);
                    DatabaseConnector databaseConnector3 = this.getDatabaseConnector();
                    while (databaseConnector2.more() && !this.indexCancelled) {
                        if (this.indexCancelled) continue;
                        Debug.debugOutStay("Processing fuzzy date #" + n3++ + " of " + n2 + "." + "\r", 3);
                        try {
                            string2 = databaseConnector2.getFieldByName("ValueID");
                            string3 = databaseConnector2.getFieldByName("ValueText");
                            string4 = databaseConnector2.getFieldByName("ValueNumber");
                            string5 = databaseConnector2.getFieldByName("TypeCode");
                        }
                        catch (Exception exception) {
                            TrinityIndexer.debugOut("Exception while retrieving values from the values query:\n" + InsightUtilities.convertStackTraceToString(exception));
                            string2 = "";
                            string3 = "";
                            string4 = "";
                            string5 = "";
                        }
                        if (string3 == null) {
                            string3 = "";
                        }
                        if (string4 == null) {
                            string4 = "";
                        }
                        if (string5 == null) {
                            string5 = "";
                        }
                        FuzzyDateJulianRange fuzzyDateJulianRange = null;
                        if (string5.equals("T") && !string3.equals("")) {
                            fuzzyDateJulianRange = UcbFuzzyDateMachine.getFuzzyDateJulianRange(string3);
                        } else if (string5.equals("N") && !string4.equals("")) {
                            fuzzyDateJulianRange = UcbFuzzyDateMachine.getFuzzyDateJulianRange(string4);
                        }
                        if (fuzzyDateJulianRange != null) {
                            String string7 = "UPDATE DTVALUES SET ValueDate_Start = " + fuzzyDateJulianRange.getStartJulian() + ", ValueDate_End = " + fuzzyDateJulianRange.getEndJulian() + " WHERE ValueID = " + string2 + ";";
                            databaseConnector3.setQuery(string7);
                            databaseConnector3.runUpdateQuery();
                        }
                        if (this.progressListener != null) {
                            this.progressListener.setFdPb1Value(n3);
                        }
                        databaseConnector2.next();
                    }
                    if (this.progressListener != null && !databaseConnector2.more()) {
                        this.progressListener.setFdIndexingStatusText("Completed");
                    }
                    TrinityIndexer.clearDebugOutStay();
                    databaseConnector3.close();
                    UcbFuzzyDateMachine.setFZDebugFilename(null);
                } else {
                    this.progressListener.setFdIndexingStatusText("Completed");
                }
                databaseConnector2.close();
            } else {
                TrinityIndexer.debugOut("The database is not properly set up in DTValues to run this function.");
                TrinityIndexer.debugOut("Add the ValueDate_Start and ValueDate_End columns to the DTValues table, then rerun the program.");
            }
            if (this.progressListener != null && !((String)(object = this.progressListener.getFdIndexingStatusText())).equals("Completed")) {
                this.progressListener.setFdIndexingStatusText("Cancelled");
            }
        }
    }

    protected void doMultipageDocumentsGeneration(Integer n) {
        if (!this.indexCancelled) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            TrinityIndexer.debugOut("");
            TrinityIndexer.debugOut("\t\tMULTIPAGE DOCUMENT GENERATION");
            TrinityIndexer.debugOut("");
            try {
                TrinityIndexer.debugOut("Retrieving the multipage documents to generate.");
                Vector vector = this.getMultipageDocumentsToGenerate(databaseConnector);
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut(vector.size() + " document(s) to generate.");
                if (this.progressListener != null) {
                    this.progressListener.setBorderTitle("Multipage Document Indexing");
                    this.progressListener.setMpdPb1Maximum(vector.size());
                }
                for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                    if (!this.indexCancelled) {
                        MultipageDocumentSeries multipageDocumentSeries = (MultipageDocumentSeries)vector.elementAt(i);
                        if (this.progressListener != null) {
                            this.progressListener.setMpdIndexingFieldText(multipageDocumentSeries.getDocumentName());
                        }
                        TrinityIndexer.debugOut("");
                        TrinityIndexer.debugOut("");
                        if (this.indexCancelled) break;
                        this.doMultipageDocumentGeneration(n, multipageDocumentSeries, databaseConnector);
                        if (this.indexCancelled) break;
                        this.writeMultipageDocumentPages(multipageDocumentSeries, databaseConnector);
                        if (this.indexCancelled) break;
                        this.mapMpdToTargetGroup(multipageDocumentSeries, databaseConnector);
                    }
                    if (this.progressListener == null) continue;
                    this.progressListener.setMpdPb1Value(i + 1);
                }
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in doMultipageDocumentsGeneration():\n" + InsightUtilities.convertStackTraceToString(exception));
            }
            if (!this.indexCancelled) {
                databaseConnector.setQuery("SELECT * FROM ISDOCUMENTS");
                databaseConnector.runQuery();
            }
            databaseConnector.close();
            if (this.progressListener != null) {
                this.progressListener.setMpdIndexingFieldText("Completed");
            }
        }
    }

    protected Vector getMultipageDocumentsToGenerate() {
        return this.getMultipageDocumentsToGenerate(null);
    }

    protected Vector getMultipageDocumentsToGenerate(DatabaseConnector databaseConnector) {
        if (!this.indexCancelled) {
            Vector<MultipageDocumentSeries> vector = new Vector<MultipageDocumentSeries>();
            try {
                if (databaseConnector == null) {
                    databaseConnector = this.getDatabaseConnector();
                }
                SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                sqlQueryGenerator.addTable("ISDOCUMENTS", null, "*");
                sqlQueryGenerator.appendToWhere("ISDOCUMENTS.GenerateDocument = 1");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                TrinityIndexer.debugOut("Get documents query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityIndexer.debugOut("");
                    MultipageDocumentSeries multipageDocumentSeries = new MultipageDocumentSeries(databaseConnector.getFieldByName("DocumentID"), databaseConnector.getFieldByName("DocumentName"));
                    multipageDocumentSeries.setTargetGroupID(databaseConnector.getIntegerField("TargetGroupID"));
                    try {
                        multipageDocumentSeries.setIdentityFieldID(databaseConnector.getIntegerField("IdentityFieldID"));
                    }
                    catch (Exception exception) {
                        multipageDocumentSeries.setIdentityFieldID(0);
                    }
                    if (multipageDocumentSeries.getIdentityFieldID() <= 0) {
                        TrinityIndexer.debugOut("Document '" + multipageDocumentSeries.getDocumentName() + "' has not defined an identity field.");
                    } else {
                        TrinityIndexer.debugOut("Document '" + multipageDocumentSeries.getDocumentName() + "' identity field ID: " + multipageDocumentSeries.getIdentityFieldID());
                    }
                    try {
                        multipageDocumentSeries.setIdentityValue(databaseConnector.getFieldByName("IdentityValue"));
                    }
                    catch (Exception exception) {
                        multipageDocumentSeries.setIdentityValue(null);
                    }
                    if (multipageDocumentSeries.getIdentityValue() == null || multipageDocumentSeries.getIdentityValue().length() == 0) {
                        TrinityIndexer.debugOut("Document '" + multipageDocumentSeries.getDocumentName() + "' has not defined an identity value.");
                    } else {
                        TrinityIndexer.debugOut("Document '" + multipageDocumentSeries.getDocumentName() + "' identity value: " + multipageDocumentSeries.getIdentityValue());
                    }
                    int n = databaseConnector.getIntegerField("MaxLevelCount");
                    String string = "";
                    for (int i = 1; i <= n; ++i) {
                        string = databaseConnector.getFieldByName("LevelName" + i);
                        int n2 = databaseConnector.getIntegerField("LevelFieldID" + i);
                        if (string == null || n2 <= 0) continue;
                        multipageDocumentSeries.addLevel(string, i, n2);
                    }
                    vector.addElement(multipageDocumentSeries);
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in getMultipageDocumentsToIndex():\n" + InsightUtilities.convertStackTraceToString(exception));
            }
            if (databaseConnector != null) {
                databaseConnector.close();
            }
            return vector;
        }
        return null;
    }

    protected void doMultipageDocumentGeneration(Integer n, MultipageDocumentSeries multipageDocumentSeries) {
        this.doMultipageDocumentGeneration(n, multipageDocumentSeries, null);
    }

    protected void doMultipageDocumentGeneration(Integer n, MultipageDocumentSeries multipageDocumentSeries, DatabaseConnector databaseConnector) {
        block14: {
            try {
                if (multipageDocumentSeries == null) break block14;
                if (databaseConnector == null) {
                    databaseConnector = this.getDatabaseConnector();
                }
                TrinityIndexer.debugOut("Generating document: [" + multipageDocumentSeries.getDocumentID() + ", " + multipageDocumentSeries.getDocumentName() + "].");
                SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                String string = "";
                if (multipageDocumentSeries.getIdentityFieldID() > 0 && multipageDocumentSeries.getIdentityValue() != null && multipageDocumentSeries.getIdentityValue().length() > 0) {
                    boolean bl = false;
                    long l = 0L;
                    try {
                        l = Long.parseLong(multipageDocumentSeries.getIdentityValue());
                        bl = true;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, DEFAULT_PRIMARY_OBJECT_KEY);
                    sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOOBJECT", new String[]{"ValueID"}, 0);
                    sqlQueryGenerator.appendToWhere("DTVALUES.FieldID = " + multipageDocumentSeries.getIdentityFieldID() + " AND " + "DTVALUES" + ".UniqueCollectionID = " + n + " AND (" + "DTVALUES" + ".ValueText = " + TrinityIndexer.prepStringForQuery(multipageDocumentSeries.getIdentityValue()) + (bl ? " OR DTVALUES.ValueNumber = " + l : "") + ")");
                    string = sqlQueryGenerator.getQuery();
                    sqlQueryGenerator.clear();
                }
                Vector vector = multipageDocumentSeries.getLevels();
                boolean bl = false;
                int n2 = 0;
                MultipageDocumentPageLookup multipageDocumentPageLookup = new MultipageDocumentPageLookup();
                CollectionKeyWrapper collectionKeyWrapper = new CollectionKeyWrapper("", "", "");
                for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                    MultipageDocumentLevel multipageDocumentLevel = (MultipageDocumentLevel)vector.elementAt(i);
                    TrinityIndexer.debugOut("Processing document level [" + multipageDocumentLevel.getLevelNumber() + "] using field [" + multipageDocumentLevel.getFieldID() + "].");
                    bl = i == 0;
                    sqlQueryGenerator.clear();
                    sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, "*");
                    sqlQueryGenerator.addTable("DTVALUES", null, "*");
                    sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOOBJECT", new String[]{"ValueID"}, 0);
                    sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "IROBJECTIMAGEMAP", new String[]{DEFAULT_PRIMARY_OBJECT_KEY}, 0);
                    sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "IRIMAGEFILES", new String[]{"ImageID"}, 0);
                    sqlQueryGenerator.appendToWhere("DTVALUES.FieldID = " + multipageDocumentLevel.getFieldID());
                    sqlQueryGenerator.appendToWhere("DTVALUES.ValueText <> '0' OR DTVALUES.ValueNumber > 0");
                    sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ResolutionSize = 0");
                    sqlQueryGenerator.appendToWhere("DTVALUES.UniqueCollectionID = " + n);
                    if (string != null && string.length() > 0) {
                        sqlQueryGenerator.appendToWhere("DTVALUETOOBJECT.ObjectID IN (" + string + ")");
                    }
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    databaseConnector.runQuery();
                    n2 = 0;
                    while (databaseConnector.more() && !this.indexCancelled) {
                        int n3 = databaseConnector.getIntegerField("ValueText");
                        if (n3 <= 0) {
                            n3 = databaseConnector.getIntegerField("ValueNumber");
                        }
                        if (n3 > 0) {
                            long l;
                            long l2 = databaseConnector.getLongField(DEFAULT_PRIMARY_OBJECT_KEY);
                            MultipageDocumentPage multipageDocumentPage = multipageDocumentPageLookup.getPage(l2, l = databaseConnector.getLongField("ImageID"));
                            if (multipageDocumentPage == null && bl) {
                                multipageDocumentPage = new MultipageDocumentPage(multipageDocumentSeries, l2, l, 0, collectionKeyWrapper);
                                multipageDocumentSeries.addPage(multipageDocumentPage);
                                multipageDocumentPageLookup.addPage(multipageDocumentPage);
                            }
                            if (multipageDocumentPage != null) {
                                multipageDocumentPage.addToPath(multipageDocumentLevel.getLevelNumber(), n3);
                            }
                        }
                        databaseConnector.next();
                        TrinityIndexer.debugOutStay("Processed " + ++n2 + " node values.  Generated " + multipageDocumentSeries.getPages().size() + " document page(s).        ");
                    }
                    TrinityIndexer.clearDebugOutStay();
                }
                multipageDocumentSeries.orderPages();
                multipageDocumentPageLookup.clear();
                TrinityIndexer.debugOut("Generated " + multipageDocumentSeries.getPages().size() + " page(s) for document: [" + multipageDocumentSeries.getDocumentID() + ", " + multipageDocumentSeries.getDocumentName() + "].");
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in doMultipageDocumentGeneration():\n" + InsightUtilities.convertStackTraceToString(exception));
            }
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
    }

    protected void writeMultipageDocumentPages(MultipageDocumentSeries multipageDocumentSeries) {
        this.writeMultipageDocumentPages(multipageDocumentSeries, null);
    }

    protected void writeMultipageDocumentPages(MultipageDocumentSeries multipageDocumentSeries, DatabaseConnector databaseConnector) {
        try {
            if (multipageDocumentSeries != null) {
                if (databaseConnector == null) {
                    databaseConnector = this.getDatabaseConnector();
                }
                String string = multipageDocumentSeries.getDocumentID();
                String string2 = multipageDocumentSeries.getDocumentName();
                TrinityIndexer.debugOut("Writing pages for document: [" + string + ", " + string2 + "].");
                TrinityIndexer.debugOut("Removing previous pages for document: [" + string + ", " + string2 + "].");
                databaseConnector.setQuery("DELETE FROM ISDOCUMENTPAGES WHERE DocumentID = " + multipageDocumentSeries.getDocumentID());
                TrinityIndexer.debugOut("Delete previous pages:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                Vector vector = multipageDocumentSeries.getPages();
                TrinityIndexer.debugOut("Document: [" + string + ", " + string2 + "] contains " + vector.size() + " page(s).");
                SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGeneratorUtil();
                for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                    MultipageDocumentPage multipageDocumentPage = (MultipageDocumentPage)vector.elementAt(i);
                    Vector vector2 = multipageDocumentPage.getPath();
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DocumentID", 2, stringBuffer2, string);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, i + 1 + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, DEFAULT_PRIMARY_OBJECT_KEY, 2, stringBuffer2, multipageDocumentPage.getObjectID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, multipageDocumentPage.getImageID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LinkCount", 2, stringBuffer2, multipageDocumentPage.getLinkCount() + "");
                    vector2 = multipageDocumentPage.getPath();
                    for (int j = 0; vector2 != null && j < vector2.size() && !this.indexCancelled; ++j) {
                        MultipageDocumentPathEntry multipageDocumentPathEntry = (MultipageDocumentPathEntry)vector2.elementAt(j);
                        if (multipageDocumentPathEntry.getLevelNumber() <= -1) continue;
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Level" + multipageDocumentPathEntry.getLevelNumber(), 2, stringBuffer2, multipageDocumentPathEntry.getNodeValue() + "");
                    }
                    databaseConnector.setQuery("INSERT INTO ISDOCUMENTPAGES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    TrinityIndexer.debugOutStay("Writing page " + (i + 1) + " of " + vector.size() + ".        ");
                    databaseConnector.runUpdateQuery();
                }
                TrinityIndexer.clearDebugOutStay();
            }
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception in writeMultipageDocumentPages():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
    }

    protected void mapMpdToTargetGroup(MultipageDocumentSeries multipageDocumentSeries) {
        this.mapMpdToTargetGroup(multipageDocumentSeries, null);
    }

    protected void mapMpdToTargetGroup(MultipageDocumentSeries multipageDocumentSeries, DatabaseConnector databaseConnector) {
        try {
            if (multipageDocumentSeries.getTargetGroupID() > 0 && multipageDocumentSeries.getPages().size() > 0) {
                if (databaseConnector == null) {
                    databaseConnector = this.getDatabaseConnector();
                }
                long l = ((MultipageDocumentPage)multipageDocumentSeries.getPages().firstElement()).getImageID();
                TrinityIndexer.debugOut("Mapping DocumentID [" + multipageDocumentSeries.getDocumentID() + "] to GroupID [" + multipageDocumentSeries.getTargetGroupID() + "] using ImageID [" + l + "]");
                databaseConnector.setQuery("SELECT ImageID FROM IRIMAGETODOCUMENTMAP WHERE DocumentID = " + multipageDocumentSeries.getDocumentID());
                databaseConnector.runQuery();
                Vector<Long> vector = new Vector<Long>();
                Long l2 = null;
                while (databaseConnector.more() && !this.indexCancelled) {
                    l2 = new Long(databaseConnector.getLongField("ImageID"));
                    if (l2 != l) {
                        vector.addElement(l2);
                    }
                    databaseConnector.next();
                }
                databaseConnector.close();
                for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                    databaseConnector.setQuery("DELETE FROM IRGROUPIMAGEMAP WHERE (ImageID = " + (Long)vector.elementAt(i) + " AND MpdSeries = 1)");
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                }
                databaseConnector.setQuery("DELETE FROM IRIMAGETODOCUMENTMAP WHERE ImageID = " + l + " OR DocumentID = " + multipageDocumentSeries.getDocumentID());
                databaseConnector.runUpdateQuery();
                databaseConnector.setQuery("INSERT INTO IRIMAGETODOCUMENTMAP(ImageID, DocumentID) VALUES (" + l + ", " + multipageDocumentSeries.getDocumentID() + ")");
                databaseConnector.runUpdateQuery();
                databaseConnector.setQuery("INSERT INTO IRGROUPIMAGEMAP(GroupID, ImageID, MviSeries, MpdSeries, ObjectID) VALUES(" + multipageDocumentSeries.getTargetGroupID() + ", " + l + ", 0, 1, 0)");
                databaseConnector.runUpdateQuery();
            }
        }
        catch (Exception exception) {
            TrinityIndexer.debugOut("Exception in mapMpdToTargetGroup():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
    }

    protected void doBrowserFlatObjectDataPopulation(Integer n, int n2) {
        if (!this.indexCancelled) {
            Object object;
            TrinityIndexer.clearDebugOutStay();
            TrinityIndexer.debugOut("Populating DTFLATOBJECTDATA with browser thumb and sort fields.");
            TrinityIndexer.debugOut("");
            if (n2 > 100) {
                n2 = 100;
            }
            if (this.progressListener != null) {
                this.progressListener.setBorderTitle("Browser Indexing (max chars: " + (n2 > 0 ? n2 + "" : "unlimited") + ")");
                this.progressListener.setBrowserStatusText("Started");
            }
            try {
                object = TrinityIndexer.getQueryGenerator();
                ((SqlQueryGenerator)object).addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "*");
                ((SqlQueryGenerator)object).appendToWhere("UniqueCollectionID = " + n);
                ((SqlQueryGenerator)object).appendToWhere("VCID = " + TrinityIndexer.prepStringForQuery("NA"));
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
                Vector<TrinityFieldProfile> vector = new Vector<TrinityFieldProfile>(4);
                Vector<TrinityFieldProfile> vector2 = new Vector<TrinityFieldProfile>(4);
                databaseConnector.setQuery(((SqlQueryGenerator)object).getQuery());
                TrinityIndexer.debugOut("Get browser thumb and sort fields query:\n" + databaseConnector.getQuery());
                TrinityIndexer.debugOut("");
                databaseConnector.runQuery();
                if (databaseConnector.more() && !this.indexCancelled) {
                    vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField1"), databaseConnector2));
                    vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField2"), databaseConnector2));
                    vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField3"), databaseConnector2));
                    vector.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("ThumbnailDataField4"), databaseConnector2));
                    vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField1"), databaseConnector2));
                    vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField2"), databaseConnector2));
                    vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField3"), databaseConnector2));
                    vector2.add(TrinityIndexer.getFieldProfile(databaseConnector.getIntegerField("DefaultSortField4"), databaseConnector2));
                }
                databaseConnector.close();
                databaseConnector2.close();
                this.doFlatObjectDataPopulation(n, vector, vector2, n2);
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in doBrowserFlatObjectDataPopulation():\n" + InsightUtilities.getStackTrace(exception));
            }
            if (this.progressListener != null && !this.indexCancelled) {
                this.progressListener.setBrowserStatusText("Completed");
            }
            if (this.progressListener != null && !((String)(object = this.progressListener.getBrowserStatusText())).equals("Completed")) {
                this.progressListener.setBrowserStatusText("Cancelled");
            }
        }
    }

    protected void doFlatObjectDataPopulation(Integer n, List list, List list2, int n2) {
        if (!this.indexCancelled) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, DEFAULT_PRIMARY_OBJECT_KEY);
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                String string = sqlQueryGenerator.getQuery();
                TrinityIndexer.debugOut("Objects query:\n" + string);
                databaseConnector.setQuery(string);
                databaseConnector.runQuery();
                TreeMap treeMap = new TreeMap();
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityIndexer.getFlatObjectRecord(treeMap, databaseConnector.getLongField(DEFAULT_PRIMARY_OBJECT_KEY), list, list2);
                    databaseConnector.next();
                }
                databaseConnector.close();
                sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
                sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, DEFAULT_PRIMARY_OBJECT_KEY);
                sqlQueryGenerator.addTable("DTVALUES", null, new String[]{"FieldID", "ValueText", "ValueNumber"});
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "DTVALUES", "ValueID", 0);
                sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                sqlQueryGenerator.appendToWhere("(" + TrinityConnector.createFieldIDClause((Vector)list, (Vector)list2, "DTVALUES") + " AND (" + "DTVALUES" + ".UniqueCollectionID = " + n + ")" + " AND (" + "DTVALUETOOBJECT" + ".Preferred = 1)" + " AND (" + "DTVALUES" + ".Enabled = 1))");
                String string2 = sqlQueryGenerator.getQuery();
                databaseConnector = this.getDatabaseConnector();
                TrinityIndexer.clearDebugOutStay();
                TrinityIndexer.debugOut("Reading the object values.");
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("Sort field character limit: " + (n2 > 0 ? n2 + "" : "unlimited"));
                TrinityIndexer.debugOut("");
                TrinityIndexer.debugOut("Counting records.");
                TrinityIndexer.debugOut("");
                MutableLong mutableLong = new MutableLong();
                long l = 0L;
                if (!this.indexCancelled) {
                    l = TrinityIndexer.getRecordCount(databaseConnector, string2);
                }
                int n3 = 0;
                if (this.progressListener != null) {
                    int n4 = (int)l;
                    this.progressListener.setBrowserPb1Maximum(n4);
                    this.progressListener.setBrowserPb1Value(0);
                }
                if (!this.indexCancelled) {
                    databaseConnector.setQuery(string2);
                    TrinityIndexer.debugOut("Values query:\n" + string2);
                    TrinityIndexer.debugOut("");
                    databaseConnector.runQuery();
                }
                while (!this.indexCancelled && databaseConnector.more()) {
                    TrinityFlatObjectRecord trinityFlatObjectRecord = TrinityIndexer.getFlatObjectRecord(treeMap, databaseConnector.getLongField(DEFAULT_PRIMARY_OBJECT_KEY), list, list2);
                    trinityFlatObjectRecord.addFieldValue(databaseConnector.getIntegerField("FieldID"), InsightDataAnchor.getPlainText(TrinityConnector.getFieldValue(databaseConnector)), n2);
                    this.updateFlatObjectReadProgress(mutableLong.addToValue(1L), l);
                    databaseConnector.next();
                    if (this.progressListener == null) continue;
                    int n5 = (int)l;
                    this.progressListener.setBrowserPb1Maximum(n5);
                    this.progressListener.setBrowserPb1Value(++n3);
                }
                databaseConnector.close();
                TrinityIndexer.debugOut("");
                this.clearTable(n, "DTFLATOBJECTDATA");
                TrinityIndexer.debugOut("");
                TrinityIndexer.clearDebugOutStay();
                TrinityIndexer.debugOut("Writing the flat object records.");
                TrinityIndexer.debugOut("");
                mutableLong.setValue(0L);
                l = treeMap.size();
                n3 = 0;
                if (this.progressListener != null) {
                    this.progressListener.setBrowserPb3Maximum((int)l);
                    this.progressListener.setBrowserPb3Value(0);
                }
                SqlQueryGenerator sqlQueryGenerator2 = TrinityIndexer.getQueryGeneratorUtil();
                Iterator iterator = treeMap.values().iterator();
                while (iterator.hasNext() && !this.indexCancelled) {
                    this.sqlBatchController.postSqlCommand(((TrinityFlatObjectRecord)iterator.next()).getInsertStatement(n, "DTFLATOBJECTDATA", sqlQueryGenerator2));
                    this.updateFlatObjectWriteProgress(mutableLong.addToValue(1L), l);
                    if (this.progressListener == null) continue;
                    this.progressListener.setBrowserPb3Value(++n3);
                }
                if (!this.indexCancelled) {
                    this.sqlBatchController.executeRemainingCommands();
                }
                TrinityIndexer.clearDebugOutStay();
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in doFlatObjectDataPopulation():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
    }

    protected void updateFlatObjectReadProgress(long l, long l2) {
        if (l % 20L == 0L) {
            long l3 = System.currentTimeMillis() - this.startTime;
            int n = (int)(l3 / 1000L);
            int n2 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            if (l3 > this.lastTime + 2000L) {
                double d = 0.0;
                int n3 = 0;
                if (n > 5) {
                    d = (double)n / (double)n2 * 100.0;
                    n3 = (int)d - n;
                }
                this.elapsedTime = this.elapsedTime(l3);
                this.remainingTime = TrinityIndexer.formatTimeString(n3);
                this.lastTime = l3;
            }
            Debug.debugOutStay("  Reading object values " + l + "val (" + n2 + "%)/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
        }
    }

    protected void updateFlatObjectWriteProgress(long l, long l2) {
        if (l % 20L == 0L) {
            long l3 = System.currentTimeMillis() - this.startTime;
            int n = (int)(l3 / 1000L);
            int n2 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            if (l3 > this.lastTime + 2000L) {
                double d = 0.0;
                int n3 = 0;
                if (n > 5) {
                    d = (double)n / (double)n2 * 100.0;
                    n3 = (int)d - n;
                }
                this.elapsedTime = this.elapsedTime(l3);
                this.remainingTime = TrinityIndexer.formatTimeString(n3);
                this.lastTime = l3;
            }
            Debug.debugOutStay("  Writing object records " + l + "rec (" + n2 + "%)/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
        }
    }

    protected DatabaseConnector getDatabaseConnector() {
        return this.dbConnectorGenerator.getConnector(this.connectString);
    }

    protected static SqlQueryGenerator getQueryGenerator() {
        return new SqlQueryGenerator(queryMode, globalEscapeDelimiter, unicodeFieldPrefix);
    }

    protected static SqlQueryGenerator getQueryGeneratorUtil() {
        return sqlQueryGeneratorUtil;
    }

    protected String getStringField(DatabaseConnector databaseConnector, String string) {
        String string2 = null;
        try {
            string2 = databaseConnector.getFieldByName(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "Exception:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        return string2;
    }

    protected int getIntegerField(DatabaseConnector databaseConnector, String string) {
        int n = 0;
        try {
            n = databaseConnector.getIntegerFieldByName(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "Exception:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        return n;
    }

    protected long getLongField(DatabaseConnector databaseConnector, String string) {
        long l = 0L;
        try {
            l = databaseConnector.getLongField(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "\nException:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        return l;
    }

    protected Date getDateField(DatabaseConnector databaseConnector, String string) {
        Date date = null;
        try {
            date = databaseConnector.getDateFieldByName(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "Exception:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        return date;
    }

    protected void clearTemporaryTables(Integer n) {
        if (this.progressListener != null) {
            this.progressListener.setBorderTitle("Clearing Temporary Tables");
        }
        this.clearTable(null, "ITTERMOBJECTMAP");
        this.clearTable(null, "ITTERMS");
        this.clearTable(null, "ITVALUES");
        this.clearTable(null, "ITVALUETOOBJECT");
        this.clearTable(null, "ITHIERARCHYNODES");
        this.clearTable(null, "ITHIERARCHYNODERELATIONS");
        this.clearTable(null, "ITHIERARCHYTOOBJECT");
        this.clearTable(null, "IDTEMPOLD");
        this.clearTable(null, "IDTEMPNEW");
    }

    protected void exitError(String string) {
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut("");
        TrinityIndexer.debugOut(string);
        TrinityIndexer.debugOut("");
        if (this.timeSpent == -1L) {
            this.timeSpent = System.currentTimeMillis() - this.startTime;
        }
        TrinityIndexer.debugOut("Time spent indexing: " + TrinityIndexer.formatTimeString((int)(this.timeSpent / 1000L)));
        try {
            if (this.dos_VALUES != null) {
                this.dos_VALUES.close();
                this.dos_VALUES = null;
            }
            if (this.dos_VTO != null) {
                this.dos_VTO.close();
                this.dos_VTO = null;
            }
            if (this.dos_TERMS != null) {
                this.dos_TERMS.close();
                this.dos_TERMS = null;
            }
            if (this.dos_TOM != null) {
                this.dos_TOM.close();
                this.dos_TOM = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.progressListener != null) {
            this.setIndexCancelled(true);
            this.progressListener.indexerFailure(string);
        } else {
            System.exit(-1);
        }
    }

    protected Properties loadProperties(File file) {
        Properties properties = new Properties();
        try {
            TrinityIndexer.debugOut("Configuration file is " + file + ".");
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("IDX: Cannot read configuration file: " + file);
            System.out.println("IDX: Server terminating due to configuration file problems.");
            System.out.println("IDX: Exception in loadProperties():\n" + InsightUtilities.convertStackTraceToString(exception));
            System.exit(0);
        }
        return properties;
    }

    protected Properties loadProperties() {
        Properties properties = new Properties();
        try {
            TrinityIndexer.debugOut("Configuration file is InsightTrinityIndexer.dat.");
            FileInputStream fileInputStream = new FileInputStream(PROPS_FILE);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("IDX: Cannot read configuration file: InsightTrinityIndexer.dat");
            System.out.println("IDX: Server terminating due to configuration file problems.");
            System.out.println("IDX: Exception in loadProperties():\n" + InsightUtilities.convertStackTraceToString(exception));
            System.exit(0);
        }
        return properties;
    }

    protected long getMaxValueID() {
        return this.getMaxValueID(false);
    }

    protected long getMaxValueID(boolean bl) {
        long l = 0L;
        StringBuffer stringBuffer = new StringBuffer("SELECT MAX(ValueID) AS MaxID FROM DTVALUES");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(stringBuffer.toString());
        databaseConnector.runQuerySafe();
        if (databaseConnector.more()) {
            try {
                l = databaseConnector.getLongField("MaxID");
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in getMaxValueID():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return l;
    }

    protected long getMaxTermID() {
        return this.getMaxTermID(false);
    }

    protected long getMaxTermID(boolean bl) {
        long l = 0L;
        StringBuffer stringBuffer = new StringBuffer("SELECT MAX(DTTERMS.TermID) AS MaxID FROM DTTERMS");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(stringBuffer.toString());
        databaseConnector.runQuerySafe();
        if (databaseConnector.more()) {
            try {
                l = databaseConnector.getLongField("MaxID");
            }
            catch (Exception exception) {
                TrinityIndexer.debugOut("Exception in getMaxTermID():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return l;
    }

    protected void updateProgress(long l, long l2, long l3, String string, String string2) {
        if (l2 % 20L == 0L) {
            Debug.debugOutStay("  " + string + " " + this.getProgressString(l, l2, l3) + " " + string2 + "\r", 3);
            this.lastTime = System.currentTimeMillis();
        }
    }

    protected String getProgressString(long l, long l2, long l3) {
        long l4 = l / 1000L;
        long l5 = l2 * 100L / (l3 > 0L ? l3 : 1L);
        long l6 = (long)((double)l4 * 100.0 / (double)l5) - l4;
        String string = TrinityIndexer.formatTimeString((int)l4);
        String string2 = TrinityIndexer.formatTimeString((int)l6);
        return "(" + l5 + "%, " + string + "e/" + string2 + "r)";
    }

    protected void updateProgress(long l, long l2, int n, int n2, int n3, long l3, long l4) {
        long l5 = System.currentTimeMillis() - this.startTime;
        int n4 = (int)(l5 / 1000L);
        int n5 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
        int n6 = n + n2 * n3 * n5 / 100;
        if (l5 > this.lastTime + 2000L) {
            double d = 0.0;
            int n7 = 0;
            if (n4 > 5) {
                d = (double)n4 * 100.0 / ((double)n + (double)(n2 * n3 * n5) / 100.0);
                n7 = (int)d - n4;
            }
            this.elapsedTime = this.elapsedTime(l5);
            this.remainingTime = TrinityIndexer.formatTimeString(n7);
            this.lastTime = l5;
        }
        Debug.debugOutStay("  " + l + "obj (" + n5 + "%, " + n6 + "%)/" + l3 + "fv/" + l4 + "t/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
    }

    protected String elapsedTime(long l) {
        int n = (int)(l / 1000L);
        return TrinityIndexer.formatTimeString(n);
    }

    protected Vector groupFieldsByJoinPath(TrinityIndexerField[] trinityIndexerFieldArray) {
        Vector<Vector<TrinityIndexerField>> vector = new Vector<Vector<TrinityIndexerField>>();
        Vector<TrinityIndexerField> vector2 = null;
        boolean bl = false;
        for (int i = 0; trinityIndexerFieldArray != null && i < trinityIndexerFieldArray.length; ++i) {
            bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                vector2 = (Vector<TrinityIndexerField>)vector.elementAt(j);
                if (vector2.size() <= 0 || ((TrinityIndexerField)vector2.firstElement()).joinID != trinityIndexerFieldArray[i].joinID) continue;
                bl = true;
                break;
            }
            if (!bl || vector2 == null) {
                vector2 = new Vector<TrinityIndexerField>(1);
                vector.addElement(vector2);
            }
            vector2.addElement(trinityIndexerFieldArray[i]);
            vector2 = null;
        }
        return vector;
    }

    protected String constructFieldQuery(TrinityField trinityField) {
        return this.constructFieldQuery(trinityField, false);
    }

    protected String constructFieldQuery(TrinityField trinityField, boolean bl) {
        if (trinityField != null) {
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            if (!this.doValueIndex && !bl) {
                sqlQueryGenerator.addTable("ID" + this.primaryObjectTable, null, new String[]{this.primaryObjectKey, "Removal"});
            } else if (bl) {
                sqlQueryGenerator.addTable(this.primaryObjectTable, null, this.primaryObjectKey + " AS " + this.primaryObjectKey);
            } else {
                sqlQueryGenerator.addTable(this.primaryObjectTable, null, this.primaryObjectKey);
            }
            SqlTable sqlTable = new SqlTable(trinityField.table.name);
            if (bl) {
                sqlTable.addColumnSelection(trinityField.sourceName + "ID AS " + trinityField.sourceName + "ID");
            }
            if (trinityField.getPreferredFieldName() != null && trinityField.getPreferredFieldName().length() > 0) {
                sqlTable.addColumnSelection(trinityField.getPreferredFieldName());
            }
            sqlTable.addColumnSelection(trinityField.sourceName);
            sqlQueryGenerator.addTable(sqlTable);
            if (trinityField.getGroupingFieldName() != null && trinityField.getGroupingFieldName().length() > 0 && trinityField.getGroupingTable() != null) {
                sqlTable = new SqlTable(trinityField.getGroupingTable().name);
                sqlTable.addColumnSelection(trinityField.getGroupingFieldName());
                sqlQueryGenerator.addTable(sqlTable);
            }
            if (!this.doValueIndex && !bl) {
                sqlQueryGenerator.addOrderBy("ID" + this.primaryObjectTable, this.primaryObjectKey);
            } else if (bl) {
                sqlQueryGenerator.addOrderBy(this.primaryObjectTable, this.primaryObjectKey);
            } else {
                sqlQueryGenerator.addOrderBy(this.primaryObjectTable, this.primaryObjectKey);
                if (!this.primaryObjectTable.equals(trinityField.table.name) || !this.primaryObjectKey.equals(trinityField.sourceName)) {
                    sqlQueryGenerator.addOrderBy(trinityField.table.name, trinityField.sourceName);
                }
            }
            TrinityJoin trinityJoin = trinityField.join;
            while (trinityJoin != null) {
                sqlQueryGenerator.addJoin(trinityJoin.startTable.name, new String[]{trinityJoin.startTableField}, trinityJoin.endTable.name, new String[]{trinityJoin.endTableField}, 0);
                trinityJoin = trinityJoin.nextJoin;
            }
            return sqlQueryGenerator.getQuery();
        }
        return null;
    }

    protected String constructFieldsQuery(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n;
            SqlQueryGenerator sqlQueryGenerator = TrinityIndexer.getQueryGenerator();
            sqlQueryGenerator.addTable(this.primaryObjectTable, null, this.primaryObjectKey);
            Vector<String> vector2 = new Vector<String>(vector.size());
            Vector<String> vector3 = new Vector<String>(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                TrinityField trinityField = (TrinityField)vector.elementAt(i);
                if (trinityField.sourceName != null && trinityField.sourceName.length() > 0 && !vector2.contains(trinityField.sourceName)) {
                    vector2.addElement(trinityField.sourceName);
                }
                if (trinityField.getPreferredFieldName() == null || trinityField.getPreferredFieldName().length() <= 0 || vector3.contains(trinityField.getPreferredFieldName())) continue;
                vector3.addElement(trinityField.getPreferredFieldName());
            }
            TrinityField trinityField = (TrinityField)vector.firstElement();
            SqlTable sqlTable = new SqlTable(trinityField.table.name);
            for (n = 0; n < vector2.size(); ++n) {
                sqlTable.addColumnSelection((String)vector2.elementAt(n));
            }
            for (n = 0; n < vector3.size(); ++n) {
                sqlTable.addColumnSelection((String)vector3.elementAt(n));
            }
            sqlQueryGenerator.addTable(sqlTable);
            sqlQueryGenerator.addOrderBy(this.primaryObjectTable, this.primaryObjectKey);
            TrinityJoin trinityJoin = trinityField.join;
            while (trinityJoin != null) {
                sqlQueryGenerator.addJoin(trinityJoin.startTable.name, new String[]{trinityJoin.startTableField}, trinityJoin.endTable.name, new String[]{trinityJoin.endTableField}, 0);
                trinityJoin = trinityJoin.nextJoin;
            }
            return sqlQueryGenerator.getQuery();
        }
        return null;
    }

    protected String[] constructInnerJoin(TrinityField trinityField, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (trinityField != null) {
            TrinityJoin trinityJoin = trinityField.join;
            while (trinityJoin != null) {
                String string = trinityJoin.startTable.name;
                String string2 = trinityJoin.endTable.name;
                if (bl) {
                    if (this.icTables.contains(trinityJoin.startTable)) {
                        string = "IC" + trinityJoin.startTable.name;
                    }
                    if (this.icTables.contains(trinityJoin.endTable)) {
                        string2 = "IC" + trinityJoin.endTable.name;
                    }
                }
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string + ", " + string2);
                    stringBuffer2.append("(" + string + "." + trinityJoin.startTableField + " = " + string2 + "." + trinityJoin.endTableField + ")");
                } else {
                    stringBuffer.append(", " + string2);
                    stringBuffer2.append(" AND (" + string + "." + trinityJoin.startTableField + " = " + string2 + "." + trinityJoin.endTableField + ")");
                }
                trinityJoin = trinityJoin.nextJoin;
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append((bl ? "IC" : "") + this.primaryObjectTable);
            }
        }
        return new String[]{stringBuffer.toString(), stringBuffer2.toString()};
    }

    protected void clearTable(Integer n, String string) {
        this.clearTable(n, string, "");
    }

    protected void clearTable(Integer n, String string, String string2) {
        String string3 = "";
        if (string2 != null && string2.length() > 0) {
            string3 = " WHERE " + string2;
            if (n != null) {
                string3 = string3 + " AND UniqueCollectionID = " + n;
            }
        } else if (n != null) {
            string3 = " WHERE UniqueCollectionID = " + n;
        }
        TrinityIndexer.debugOut("  Deleting contents of " + string + string3 + ".");
        this.quickUpdateQuery("DELETE FROM " + string + string3);
    }

    protected void quickQuery(String string) {
        TrinityIndexer.debugOut("  Executing query: " + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(string);
        databaseConnector.runUpdateQuerySafe();
        databaseConnector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quickUpdateQuery(String string) {
        TrinityIndexer.debugOut("  Executing update query: " + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(string);
        try {
            databaseConnector.runUpdateQuerySafe();
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public void setIndexCancelled(boolean bl) {
        this.indexCancelled = bl;
        if (this.indexCancelled && this.sqlBatchController != null) {
            this.sqlBatchController.setStillNeeded(false);
        }
        UcbFuzzyDateMachine.setFZDebugFilename(null);
    }

    public void setProgressListener(TrinityIndexerProgressListener trinityIndexerProgressListener) {
        this.progressListener = trinityIndexerProgressListener;
    }
}

