/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.server.hierarchy.ThesaurusRelationType;
import com.luna.insight.server.indexer.TrinityHierarchyNode;
import com.luna.insight.server.indexer.TrinityTable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class TrinityHierarchy {
    protected int hID;
    protected String hName;
    protected String hIDColumnName;
    protected int termsTableID;
    protected TrinityTable termsTable;
    protected String termIDColumnName;
    protected String termColumnName;
    protected int relationsTableID;
    protected TrinityTable relationsTable;
    protected String relationTypeColumnName;
    protected String relTermID1ColumnName;
    protected String relTermID2ColumnName;
    protected boolean isAnsiCompliant = false;
    protected List hierarchyNodes = new Vector(1);
    protected Map nodesMap = new TreeMap();

    public TrinityHierarchy(int n, String string, String string2, int n2, String string3, String string4, int n3, String string5, String string6, String string7, boolean bl) {
        this.hID = n;
        this.hName = string;
        this.hIDColumnName = string2;
        this.termsTableID = n2;
        this.termIDColumnName = string3;
        this.termColumnName = string4;
        this.relationsTableID = n3;
        this.relationTypeColumnName = string5;
        this.relTermID1ColumnName = string6;
        this.relTermID2ColumnName = string7;
        this.isAnsiCompliant = bl;
    }

    public void addHierarchyNode(TrinityHierarchyNode trinityHierarchyNode) {
        if (trinityHierarchyNode != null) {
            Object object = this.getNodeKey(trinityHierarchyNode.termID);
            Vector<TrinityHierarchyNode> vector = (Vector<TrinityHierarchyNode>)this.nodesMap.get(object);
            if (vector == null) {
                vector = new Vector<TrinityHierarchyNode>(1);
                this.nodesMap.put(object, vector);
            }
            if (!vector.contains(trinityHierarchyNode)) {
                vector.add(trinityHierarchyNode);
                this.hierarchyNodes.add(trinityHierarchyNode);
            }
        }
    }

    public void addNodeRelationship(int n, int n2, ThesaurusRelationType thesaurusRelationType, ThesaurusRelationType thesaurusRelationType2) {
        if (thesaurusRelationType != null && n != n2) {
            TrinityHierarchyNode trinityHierarchyNode = this.getHierarchyNodeByTermID(n);
            TrinityHierarchyNode trinityHierarchyNode2 = this.getHierarchyNodeByTermID(n2);
            if (trinityHierarchyNode != null && trinityHierarchyNode2 != null) {
                if (thesaurusRelationType.getTypeCode() == 4 || thesaurusRelationType.getTypeCode() == 5) {
                    TrinityHierarchyNode trinityHierarchyNode3 = trinityHierarchyNode;
                    TrinityHierarchyNode trinityHierarchyNode4 = trinityHierarchyNode2;
                    if (thesaurusRelationType.getTypeCode() == 4) {
                        trinityHierarchyNode3 = trinityHierarchyNode;
                        trinityHierarchyNode4 = trinityHierarchyNode2;
                    } else if (thesaurusRelationType.getTypeCode() == 5) {
                        trinityHierarchyNode3 = trinityHierarchyNode2;
                        trinityHierarchyNode4 = trinityHierarchyNode;
                    }
                    if (trinityHierarchyNode4.getParent() != null) {
                        trinityHierarchyNode4 = this.getNewHierarchyNode(trinityHierarchyNode4);
                    }
                    trinityHierarchyNode4.setParent(trinityHierarchyNode3);
                    trinityHierarchyNode3.addChild(trinityHierarchyNode4);
                } else {
                    int n3;
                    List list = this.getHierarchyNodes(trinityHierarchyNode.getTermID());
                    for (n3 = 0; list != null && n3 < list.size(); ++n3) {
                        ((TrinityHierarchyNode)list.get(n3)).addRelation(trinityHierarchyNode2, thesaurusRelationType);
                    }
                    list = this.getHierarchyNodes(trinityHierarchyNode2.getTermID());
                    for (n3 = 0; list != null && n3 < list.size(); ++n3) {
                        ((TrinityHierarchyNode)list.get(n3)).addRelation(trinityHierarchyNode, thesaurusRelationType2);
                    }
                }
            }
        }
    }

    public void clearHierarchyNodes() {
        if (this.hierarchyNodes != null) {
            this.hierarchyNodes.clear();
        }
    }

    public void setTermsTable(TrinityTable trinityTable) {
        this.termsTable = trinityTable;
    }

    public void setRelationsTable(TrinityTable trinityTable) {
        this.relationsTable = trinityTable;
    }

    public int getHierarchyID() {
        return this.hID;
    }

    public String getHierarchyName() {
        return this.hName;
    }

    public String getHierarchyIDColumnName() {
        return this.hIDColumnName;
    }

    public int getTermsTableID() {
        return this.termsTableID;
    }

    public TrinityTable getTermsTable() {
        return this.termsTable;
    }

    public String getTermIDColumnName() {
        return this.termIDColumnName;
    }

    public String getTermColumnName() {
        return this.termColumnName;
    }

    public int getRelationsTableID() {
        return this.relationsTableID;
    }

    public TrinityTable getRelationsTable() {
        return this.relationsTable;
    }

    public String getRelationTypeColumnName() {
        return this.relationTypeColumnName;
    }

    public String getRelTermID1ColumnName() {
        return this.relTermID1ColumnName;
    }

    public String getRelTermID2ColumnName() {
        return this.relTermID2ColumnName;
    }

    public boolean isAnsiCompliant() {
        return this.isAnsiCompliant;
    }

    public List getHierarchyNodes() {
        return this.hierarchyNodes;
    }

    public List getHierarchyNodes(int n) {
        return (List)this.nodesMap.get(this.getNodeKey(n));
    }

    public TrinityHierarchyNode getHierarchyNodeByTermID(int n) {
        List list = (List)this.nodesMap.get(this.getNodeKey(n));
        if (list != null && list.size() > 0) {
            return (TrinityHierarchyNode)list.get(0);
        }
        return null;
    }

    public TrinityHierarchyNode getNewHierarchyNode(TrinityHierarchyNode trinityHierarchyNode) {
        if (trinityHierarchyNode != null) {
            TrinityHierarchyNode trinityHierarchyNode2 = new TrinityHierarchyNode();
            trinityHierarchyNode2.setHierarchyID(this.getHierarchyID());
            trinityHierarchyNode2.setTermID(trinityHierarchyNode.getTermID());
            trinityHierarchyNode2.setTerm(trinityHierarchyNode.getTerm());
            this.addHierarchyNode(trinityHierarchyNode2);
            return trinityHierarchyNode2;
        }
        return null;
    }

    protected Object getNodeKey(int n) {
        return new Integer(n);
    }

    public boolean equals(Object object) {
        if (object instanceof TrinityHierarchy) {
            return this.getHierarchyID() == ((TrinityHierarchy)object).getHierarchyID();
        }
        return super.equals(object);
    }
}

