/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.TrinityConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class UniqueListCache {
    private int debugLevel = 3;
    private List fieldCountList = new ArrayList();
    private List fieldSearchList = new ArrayList();

    protected UniqueListCache(int n) {
        this.debugLevel = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Debug.debugOut("UniqueListCache: clearing the cache", this.debugLevel);
        List list = this.fieldSearchList;
        synchronized (list) {
            this.fieldSearchList = new ArrayList();
        }
        list = this.fieldCountList;
        synchronized (list) {
            this.fieldCountList = new ArrayList();
        }
    }

    protected int getFieldCount(int n, int n2) {
        Iterator iterator = this.fieldCountList.iterator();
        while (iterator.hasNext()) {
            int n3;
            Object[] objectArray = (Object[])iterator.next();
            int n4 = (Integer)objectArray[0];
            if (n4 != n || (n3 = ((Integer)objectArray[1]).intValue()) != n2) continue;
            return (Integer)objectArray[2];
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFieldCount(TrinityConnector trinityConnector, int n, int n2, String string) {
        int n3 = -1;
        List list = this.fieldCountList;
        synchronized (list) {
            n3 = this.getFieldCount(n, n2);
            if (n3 < 0) {
                Debug.debugOut("UniqueListCache: in getFieldCount for cacheUniqueCollectionID=" + n + " fieldID=" + n2 + ". Handling and caching", this.debugLevel);
                n3 = trinityConnector.getUniqueListFieldCount(n2, string);
                Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
                this.fieldCountList.add(objectArray);
            }
        }
        Debug.debugOut("UniqueListCache: in getFieldCount for cacheUniqueCollectionID=" + n + " fieldID=" + n2 + ", count: " + n3, this.debugLevel);
        return n3;
    }

    private synchronized List getSearchList(int n, int n2, boolean bl) {
        Object[] objectArray;
        Object object = this.fieldSearchList.iterator();
        while (object.hasNext()) {
            int n3;
            objectArray = (Object[])object.next();
            int n4 = (Integer)objectArray[0];
            if (n4 != n || (n3 = ((Integer)objectArray[1]).intValue()) != n2) continue;
            return (List)objectArray[2];
        }
        if (bl) {
            object = Collections.synchronizedList(new LinkedList());
            objectArray = new Object[]{new Integer(n), new Integer(n2), object};
            this.fieldSearchList.add(objectArray);
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCount(int n, int n2, int n3, int n4, String string, boolean bl, String string2) {
        Debug.debugOut("UniqueListCache: in getCount for cacheUniqueCollectionID=" + n + " fieldID=" + n2 + " groupID=" + n3 + " comparator:" + string, this.debugLevel);
        int n5 = -1;
        List list = this.getSearchList(n, n2, false);
        if (list == null) {
            return n5;
        }
        Vector vector = null;
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                int n6 = (Integer)objectArray[0];
                if (n6 != n3) continue;
                Debug.debugOut("UniqueListCache: getCount found in cache", this.debugLevel);
                if (!InsightUtilities.isNonEmpty(string)) {
                    return (Integer)objectArray[1];
                }
                vector = (Vector)objectArray[2];
                break;
            }
        }
        if (vector != null) {
            return this.getPartialRecordsCount(vector, n4, string, bl, string2);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCount(TrinityConnector trinityConnector, int n, int n2, String string, int n3, int n4, int n5, String string2) {
        List list;
        Debug.debugOut("UniqueListCache: in getCount for cacheUniqueCollectionID=" + n + " fieldID=" + n2 + " groupID=" + n4 + " comparator:" + string2, this.debugLevel);
        int n6 = -1;
        if (InsightUtilities.isNonEmpty(string2)) {
            return n6;
        }
        List list2 = list = this.getSearchList(n, n2, true);
        synchronized (list2) {
            Object[] objectArray = list.iterator();
            while (objectArray.hasNext()) {
                Object[] objectArray2 = (Object[])objectArray.next();
                int n7 = (Integer)objectArray2[0];
                if (n7 != n4) continue;
                Debug.debugOut("UniqueListCache: getCount found in cache, count: " + (Integer)objectArray2[1], this.debugLevel);
                return (Integer)objectArray2[1];
            }
            n6 = trinityConnector.getUniqueListCount(n2, string, n3, n4, n5, string2);
            objectArray = new Object[]{new Integer(n4), new Integer(n6), null};
            list.add(objectArray);
            Debug.debugOut("UniqueListCache: getCount added to cache, count: " + n6, this.debugLevel);
        }
        return n6;
    }

    private int getPartialRecordsCount(Vector vector, int n, String string, boolean bl, String string2) {
        int n2 = -1;
        if (!InsightUtilities.isNonEmpty(string)) {
            return vector.size();
        }
        if (n != 3) {
            return n2;
        }
        if (string.indexOf(string2) >= 0) {
            return n2;
        }
        n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            CriterionValue criterionValue = (CriterionValue)vector.elementAt(i);
            if (criterionValue == null || criterionValue.getSearchValue() == null) continue;
            if (bl) {
                if (!criterionValue.getSearchValue().toLowerCase().startsWith(string.toLowerCase())) continue;
                ++n2;
                continue;
            }
            if (!criterionValue.getSearchValue().startsWith(string)) continue;
            ++n2;
        }
        Debug.debugOut("UniqueListCache: getPartialRecords returning partial results count: " + n2, this.debugLevel);
        return n2;
    }

    private Vector getPartialRecords(Vector vector, int n, String string, boolean bl, String string2) {
        if (!InsightUtilities.isNonEmpty(string)) {
            return vector;
        }
        if (n != 3) {
            return null;
        }
        if (string.indexOf(string2) >= 0) {
            return null;
        }
        Vector<CriterionValue> vector2 = new Vector<CriterionValue>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            CriterionValue criterionValue = (CriterionValue)vector.elementAt(i);
            if (criterionValue == null || criterionValue.getSearchValue() == null) continue;
            if (bl) {
                if (!criterionValue.getSearchValue().toLowerCase().startsWith(string.toLowerCase())) continue;
                vector2.addElement(criterionValue);
                continue;
            }
            if (!criterionValue.getSearchValue().startsWith(string)) continue;
            vector2.addElement(criterionValue);
        }
        Debug.debugOut("UniqueListCache: getPartialRecords returning partial results of size: " + vector2.size(), this.debugLevel);
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getRecords(int n, int n2, int n3, int n4, String string, boolean bl, String string2) {
        Debug.debugOut("UniqueListCache: in getRecords for cacheUniqueCollectionID=" + n + " fieldID=" + n2 + " groupID=" + n3 + " comparator:" + string + " relationship=" + n4, this.debugLevel);
        List list = this.getSearchList(n, n2, false);
        if (list == null) {
            return null;
        }
        Vector vector = null;
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                int n5 = (Integer)objectArray[0];
                if (n5 != n3) continue;
                Debug.debugOut("UniqueListCache: getRecords found in cache", this.debugLevel);
                vector = (Vector)objectArray[2];
                break;
            }
        }
        if (vector != null) {
            if (!InsightUtilities.isNonEmpty(string)) {
                return vector;
            }
            return this.getPartialRecords(vector, n4, string, bl, string2);
        }
        Debug.debugOut("UniqueListCache: in getRecords, searchresults not available", this.debugLevel);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRecords(int n, int n2, int n3, int n4, String string, Vector vector) {
        List list;
        if (InsightUtilities.isNonEmpty(string)) {
            return;
        }
        Debug.debugOut("UniqueListCache: in addRecords for cacheUniqueCollectionID=" + n + " fieldID=" + n2 + " groupID=" + n3 + " comparator:" + string, this.debugLevel);
        List list2 = list = this.getSearchList(n, n2, true);
        synchronized (list2) {
            Object[] objectArray = list.iterator();
            while (objectArray.hasNext()) {
                Object[] objectArray2 = (Object[])objectArray.next();
                int n5 = (Integer)objectArray2[0];
                if (n5 != n3) continue;
                Debug.debugOut("UniqueListCache: in addRecords updating existing entry with count: " + vector.size(), this.debugLevel);
                objectArray2[1] = new Integer(vector.size());
                objectArray2[2] = vector;
                return;
            }
            Debug.debugOut("UniqueListCache: in addRecords creating new entry with count: " + vector.size(), this.debugLevel);
            objectArray = new Object[]{new Integer(n3), new Integer(vector.size()), vector};
            list.add(objectArray);
        }
    }
}

