/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class DatabaseUtility {
    public static String PROPS_FILE = "DatabaseUtility.dat";
    protected DatabaseConnectorGenerator dbConnectorGenerator = null;
    protected String dbQuery = "";
    protected Vector connectStrings = new Vector();
    protected String fieldName = "";
    protected boolean getAsInteger = false;

    public DatabaseUtility() {
        if (this.loadSettings()) {
            this.runQuery();
        } else {
            DatabaseUtility.debugOut("Error: Not properly configured.");
        }
    }

    protected boolean loadSettings() {
        boolean bl = false;
        Properties properties = DatabaseUtility.loadProperties(PROPS_FILE);
        if (properties != null) {
            this.dbConnectorGenerator = DatabaseConnectorGenerator.getCustomGenerator(properties);
            this.dbQuery = properties.getProperty("DBQuery", null);
            if (this.dbQuery == null || this.dbQuery.length() == 0) {
                DatabaseUtility.debugOut("Specify database query using property 'DBQuery'.");
                return false;
            }
            this.fieldName = properties.getProperty("FieldName", "NO_FIELD_NAME");
            this.getAsInteger = properties.getProperty("GetAsInteger", "0").equals("1");
            int n = 0;
            while (properties.getProperty("DatabaseConnect" + n, null) != null) {
                this.connectStrings.addElement(properties.getProperty("DatabaseConnect" + n));
                ++n;
            }
            if (this.connectStrings.size() == 0) {
                DatabaseUtility.debugOut("Specify the database connect strings starting with 'DatabaseConnect0'.");
                return false;
            }
            return true;
        }
        DatabaseUtility.debugOut("Unable to load props file " + PROPS_FILE + ".");
        return false;
    }

    protected void runQuery() {
        DatabaseUtility.debugOut("Running query:\n" + this.dbQuery);
        System.out.println("");
        for (int i = 0; i < this.connectStrings.size(); ++i) {
            String string = (String)this.connectStrings.elementAt(i);
            DatabaseUtility.debugOut("Getting connector for:\n\t" + string);
            DatabaseConnector databaseConnector = this.getDbConnector(string);
            try {
                databaseConnector.setQuery(this.dbQuery);
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    DatabaseUtility.debugOut("Values for '" + this.fieldName + "' " + (this.getAsInteger ? "as integer:" : "as string:"));
                    while (databaseConnector.more()) {
                        if (this.getAsInteger) {
                            DatabaseUtility.debugOut("" + databaseConnector.getIntegerFieldByName(this.fieldName));
                        } else {
                            DatabaseUtility.debugOut(databaseConnector.getFieldByName(this.fieldName));
                        }
                        databaseConnector.next();
                    }
                } else {
                    DatabaseUtility.debugOut("No results returned.");
                }
            }
            catch (Exception exception) {
                DatabaseUtility.debugOut("Exception: " + exception);
            }
            databaseConnector.close();
            System.out.println("");
        }
    }

    protected DatabaseConnector getDbConnector(String string) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.dbConnectorGenerator.getConnector(string);
        }
        catch (Exception exception) {
            DatabaseUtility.debugOut("Exception while getting database connector: " + exception);
        }
        return databaseConnector;
    }

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(2);
        DatabaseUtility.processCommandLine(stringArray);
        DatabaseUtility databaseUtility = new DatabaseUtility();
    }

    protected static Properties loadProperties(String string) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            DatabaseUtility.debugOut("Configuration file is " + string + ".");
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            DatabaseUtility.debugOut("IOException: " + iOException);
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static void processCommandLine(String[] stringArray) {
        if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-cf")) {
                    if (stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                    PROPS_FILE = stringArray[++i];
                    continue;
                }
                if (!stringArray[i].equals("/?")) continue;
                System.out.println("\nUsage:\n   java DatabaseUtility [-cf <configuration file>]");
                System.out.println("\nOptions:");
                System.out.println("   -cf <configuration file>   Configuration file (def. '" + PROPS_FILE + "')");
                System.exit(0);
            }
        }
    }

    public static void debugOut(String string) {
        DatabaseUtility.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("DatabaseUtility: " + string, n);
    }
}

