/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ResultCollector;
import com.luna.insight.server.UniqueListResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class UniqueListResultCollector
extends ResultCollector {
    protected Map resultsMap = new HashMap();
    protected int numberOfClients = 0;
    protected int relationship;
    protected String comparator;
    protected int threshold;
    protected int fieldType;
    protected boolean thresholdIntact = true;

    public UniqueListResultCollector(int n, String string, int n2, int n3) {
        this.relationship = n;
        this.comparator = string;
        this.threshold = n2;
        this.fieldType = n3;
    }

    public synchronized void addResult(Vector vector, boolean bl) {
        if (this.thresholdIntact) {
            if (bl) {
                if (vector != null && vector.size() > 0) {
                    HashMap hashMap = new HashMap(vector.size());
                    UniqueListResult uniqueListResult = null;
                    for (int i = 0; i < vector.size(); ++i) {
                        uniqueListResult = new UniqueListResult((CriterionValue)vector.elementAt(i), this.fieldType);
                        this.resultsMap.put(uniqueListResult.getComparableValue(), uniqueListResult);
                    }
                }
            } else {
                this.thresholdIntact = false;
                this.resultsMap = new HashMap();
            }
        }
    }

    public CriterionValue[] getResults() {
        if (this.resultsMap.isEmpty()) {
            return new CriterionValue[0];
        }
        ArrayList arrayList = new ArrayList(this.resultsMap.values());
        Collections.sort(arrayList);
        CriterionValue[] criterionValueArray = new CriterionValue[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            criterionValueArray[i] = ((UniqueListResult)arrayList.get(i)).getValue();
        }
        this.resultsMap = null;
        return criterionValueArray;
    }

    public static void debugOut(String string) {
        UniqueListResultCollector.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ULRC: " + string, n);
    }
}

